@extends('admin.index')
@section('content')

  <title>{{trans('admin.ExchangeCommissionsSechdule')}}</title>

    <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.HR')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('admin.ExchangeCommissionsSechdule')}}</li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>
                    <div class="row">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                         <span class="fw-300"><i>{{trans('admin.ExchangeCommissionsSechdule')}}</i></span>
                                    </h2>

                                    <div class="panel-toolbar">

                                        <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                                        @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                                   <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">
                                        <!-- datatable start -->
                                         <div style="overflow:auto;">
                                        <table id="dt-basic-example"
                                            class="table table-bordered table-hover table-striped " >
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.Employee')}}</th>
                                                    <th>{{trans('admin.Amount')}}</th>
                                                    <th>{{trans('admin.Details')}}</th>
                                                    <th>{{trans('admin.Data')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                            @foreach($items as $item)
                                                <tr @if($item->Delete == 1) class="deleted" @endif>
                                                    <td>{{$item->Code}}</td>
                                                    <td>{{$item->Date}}</td>
                                                    <td>

                                                        {{app()->getLocale() == 'ar' ?$item->Emp()->first()->Name :$item->Emp()->first()->NameEn}}
                                                    </td>

                                                    <td>{{$item->Amount}}</td>

                                                    <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#details{{$item->id}}">
                                                            {{trans('admin.Details')}}
                                                        </button>
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#data{{$item->id}}">
                                                            {{trans('admin.Data')}}
                                                        </button>
                                                    </td>

                                                    <td>

                                                        @if($item->Delete == 0)

                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>
                                                        @else

                                                            <span class="btn btn-danger">{{trans('admin.Deleted')}}</span>

                                                        @endif
                                                    </td>

                                                </tr>
                                             @endforeach


                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.Employee')}}</th>
                                                    <th>{{trans('admin.Amount')}}</th>
                                                    <th>{{trans('admin.Details')}}</th>
                                                    <th>{{trans('admin.Data')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                       {{$items->Links()}}
                                        </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </main>


@foreach($items as $item)
<!-- Modal Delete -->
<div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
   <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h4 class="modal-title">
               {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
            </h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true"><i class="fal fa-times"></i></span>
            </button>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.No')}}</button>
            <a href="{{url('DeleteCommission/'.$item->id)}}" class="btn btn-primary">{{trans('admin.Yes')}}</a>
         </div>
      </div>
   </div>
</div>

<!-- Modal Data -->
<div class="modal fade" id="data{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Details')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">

                    <div class="col-md-2 detailsX"> {{trans('admin.Draw')}}</div>
                    <div class="col-md-2 detailsX">{{$item->Draw}}</div>
                    <div class="col-md-2 detailsX"> {{trans('admin.Safe')}}</div>
                    <div class="col-md-2 detailsX"> {{app()->getLocale() == 'ar' ?$item->Safe()->first()->Name :$item->Safe()->first()->NameEn}}</div>
                    <div class="col-md-2 detailsX"> {{trans('admin.Coin')}}</div>
                    <div class="col-md-2 detailsX">{{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}  </div>

                    <div class="col-md-2 detailsX"> {{trans('admin.Cost_Center')}}</div>
                    <div class="col-md-2 detailsX">
                        @if(!empty($item->Cost_Center()->first()->Arabic_Name))
                            {{app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name}}
                        @endif
                    </div>
                    <div class="col-md-2 detailsX"> {{trans('admin.Notes')}}</div>
                    <div class="col-md-2 detailsX">{{$item->Note}}</div>
                    <div class="col-md-2 detailsX"> {{trans('admin.User')}}</div>
                    <div class="col-md-2 detailsX"> {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}</div>


                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
            </div>
        </div>
    </div>
</div>



<!-- Modal Details -->
<div class="modal fade" id="details{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Details')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">

                    <div class="col-md-2 detailsX"> {{trans('admin.Precentage_of_Sales')}}</div>
                    <div class="col-md-2 detailsX">{{$item->Pre_Sales}}</div>
                    <div class="col-md-2 detailsX"> {{trans('admin.Precentage_of_Execution')}}</div>
                    <div class="col-md-2 detailsX">{{$item->Pre_Execu}}</div>
                    <div class="col-md-2 detailsX"> {{trans('admin.Return_Maintaince')}}</div>
                    <div class="col-md-2 detailsX">{{$item->Return_Maintaince}}</div>

                    <div class="col-md-2 detailsX"> {{trans('admin.Commision')}}</div>
                    <div class="col-md-2 detailsX">{{$item->Commision}}</div>
                    <div class="col-md-2 detailsX"> {{trans('admin.Collection')}}</div>
                    <div class="col-md-2 detailsX">{{$item->Collection}}</div>            
                    
                    <div class="col-md-2 detailsX"> {{trans('admin.ShippingPrecent')}}</div>
                    <div class="col-md-2 detailsX">{{$item->Ship}}</div>
                    <div class="col-md-2 detailsX"> {{trans('admin.Total_Exchange_Commision')}}</div>
                    <div class="col-md-2 detailsX">{{$item->Total_Exchange_Commision}}</div>

                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
            </div>
        </div>
    </div>
</div>


@endforeach
  <style>
      .detailsX{

          margin-top: 5px;
          padding: 5px;
      }
  </style>
@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
   <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search '  + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
@endpush

