@extends('admin.index')
@section('content')
<title>{{trans('admin.Add_Emp')}}</title>
<style>
   .box{
   position: relative;
   padding:20px 10px;
   border: 1px solid #ccc;
   border-radius: 5px;
   margin-bottom:25px;
   }
   .box h1{
   position: absolute;
   background: white;
   top: -25px;
   padding: 5px;
   }
   .custom-card {
        border-radius: 15px;
        padding: 20px;
        border: 2px solid #ddd;
        background: linear-gradient(135deg, #f9f9f9, #e6e9f0);
        box-shadow: 0 4px 20px rgba(0,0,0,0.1);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        animation: fadeInUp 0.6s ease-out;
           margin-bottom: 20px;
    }
#mobile-overflow table,
#mobile-overflow th,
#mobile-overflow td {
  border: 1px solid #5a3e36 !important;
}

#mobile-overflow table {
  border-collapse: collapse; /* عشان الحدود تبقى متصلة */
}
    .custom-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.15);
    }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    
</style>
<main id="js-page-content" role="main" class="page-content">
   <ol class="breadcrumb page-breadcrumb">
      <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.HR')}}</a></li>
      <li class="breadcrumb-item active">{{trans('admin.Add_Emp')}}</li>
      <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
         class="js-get-date"></span></li>
   </ol>
   <form action="{{url('PostAddEmp')}}" method="post" enctype="multipart/form-data">
      {!! csrf_field() !!}
      @honeypot
      <div class="row">
         <div class="col-xl-12">
            <div  class="panel">
               <div class="panel-container show">
                  <div class="panel-content">
                     <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                           <ul class="nav nav-tabs" role="tablist">
                              <li class="nav-item">
                                 <a class="nav-link active" data-toggle="tab" href="#tab_borders_icons-1" role="tab"><i class="fal fa-home mr-1"></i>   {{trans('admin.Main_Data')}}</a>
                              </li>
                              <li class="nav-item">
                                 <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-3" role="tab"><i class="fal fa-dollar-sign mr-1"></i>  {{trans('admin.Ratio')}}</a>
                              </li>
                              <li class="nav-item">
                                 <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-4" role="tab"><i class="fal fa-dollar-sign mr-1"></i>  {{trans('admin.Allowances')}}</a>
                              </li>
                              <li class="nav-item">
                                 <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-5" role="tab"><i class="fal fa-dollar-sign mr-1"></i>  {{trans('admin.Discounts')}}</a>
                              </li>
                              <li class="nav-item">
                                 <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-6" role="tab"><i class="fal fa-dollar-sign mr-1"></i>  {{trans('admin.production_quantity')}}</a>
                              </li>
                              <li class="nav-item">
                                 <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-9" role="tab"><i class="fal fa-dollar-sign mr-1"></i>  {{trans('admin.Attendence_Policy')}}</a>
                              </li>
                              <li class="nav-item">
                                 <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-10" role="tab"><i class="fal fa-dollar-sign mr-1"></i>  {{trans('admin.Departure_Policy')}}</a>
                              </li>
                           </ul>
                           <div class="tab-content border border-top-0 p-3">
                              <div class="tab-pane fade show active" id="tab_borders_icons-1" role="tabpanel">
                                 <div class="card shadow-sm border rounded-3 p-3" style="border: 2px solid #ddd; border-radius: 15px; background-color: #fff;">
                                     
                                     
                                    <div class="custom-card">
    <div class="form-row">
            <div class="form-group col-md-2">
                <label class="form-label" for="simpleinput">{{trans('admin.Code')}}</label>
                <input type="text" value="{{$Code}}" disabled class="form-control">
                <input type="hidden" name="Code" value="{{$Code}}">
            </div>

            <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.EmpSort')}}</label><span class="strick">*</span>
                <select class="select2 form-control w-100" name="EmpSort" required>
                    <option value="1" selected>{{trans('admin.Employee')}}</option>
                    <option value="2">{{trans('admin.JobApplication')}}</option>
                </select>
            </div>

            <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.Arabic_Name')}}</label><span class="strick">*</span>
                <input type="text" name="Name" value="{{old('Name')}}" class="form-control" required>
            </div>

            <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.English_Name')}}</label><span class="strick">*</span>
                <input type="text" name="NameEn" value="{{old('NameEn')}}" class="form-control">
            </div>

            <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.Emp_Type')}}</label><span class="strick">*</span>
                <select class="select2 form-control w-100" name="Emp_Type" required>
                    <option value="">{{trans('admin.Emp_Type')}}</option>
                    <option value="Manager" selected>{{trans('admin.Manager')}}</option>
                    <option value="Production_Manager">{{trans('admin.Production_Manager')}}</option>
                    <option value="Saller">{{trans('admin.Saller')}}</option>
                    <option value="Buyer">{{trans('admin.Buyer')}}</option>
                    <option value="Driver">{{trans('admin.Driver')}}</option>
                    <option value="Engineer">{{trans('admin.Engineer')}}</option>
                    <option value="Techinical">{{trans('admin.Techinical')}}</option>
                    <option value="Delivery">{{trans('admin.Delivery')}}</option>
                    <option value="Designer">{{trans('admin.Designer')}}</option>
                    <option value="Programmer">{{trans('admin.Programmer')}}</option>
                    <option value="Accountant">{{trans('admin.Accountant')}}</option>
                    <option value="StoreKeeper">{{trans('admin.Store_Keeper')}}</option>
                    <option value="ObserverQuality">{{trans('admin.Observer_Quality')}}</option>
                    <option value="Supervisor">{{trans('admin.Supervisor')}}</option>
                    <option value="Doctor">{{trans('admin.Doctor')}}</option>
                    <option value="Teacher">{{trans('admin.Teacher')}}</option>
                    <option value="Worker">{{trans('admin.Worker')}}</option>
                    <option value="Nurse">{{trans('admin.Nurse')}}</option>
                    <option value="Cashier">{{trans('admin.Cashier')}}</option>
                    <option value="Chef">{{trans('admin.Chef')}}</option>
                    <option value="Waiter">{{trans('admin.Waiter')}}</option>
                    <option value="Secuirty">{{trans('admin.Secuirty')}}</option>
                </select>
            </div>

            <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.Department')}}</label><span class="strick">*</span>
                <select class="select2 form-control w-100" name="Department" required>
                    <option value="">{{trans('admin.Department')}}</option>
                    @foreach($Departments as $dep)
                        <option value="{{$dep->id}}" @if($dep->id == 6) selected @endif>
                            {{app()->getLocale() == 'ar' ? $dep->Arabic_Name : $dep->English_Name}}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.Job')}}</label><span class="strick">*</span>
                <select class="select2 form-control w-100" name="Job" required>
                    <option value="">{{trans('admin.Job')}}</option>
                    @foreach($JobsTypes as $job)
                        <option value="{{$job->id}}" @if($job->id == 8) selected @endif>
                            {{app()->getLocale() == 'ar' ? $job->Arabic_Name : $job->English_Name}}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.Account')}}</label><span class="strick">*</span>
                <select class="select2 form-control w-100" name="Account" required>
                    <option value="">{{trans('admin.Account')}}</option>
                    @foreach($Accounts as $acc)
                        @if($acc->Type == 0)
                            <option value="{{$acc->id}}" @if($acc->id == 53) selected @endif>
                                {{app()->getLocale() == 'ar' ? $acc->Name : $acc->NameEn}}
                            </option>
                        @endif
                    @endforeach
                </select>
            </div>

            <div class="form-group col-md-2" id="NUMOFBILLLL" style="display: none">
                <label class="form-label">{{trans('admin.NumbersOfBill')}}</label>
                <input type="number" name="NumbersOfBill" value="{{old('NumbersOfBill')}}" class="form-control">
            </div>

            <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.Group')}}</label>
                <select class="select2 form-control w-100" name="Pro_Group">
                    <option value="">{{trans('admin.Group')}}</option>
                    @foreach($Groups as $grop)
                        <option value="{{$grop->id}}">
                            {{app()->getLocale() == 'ar' ? $grop->Name : $grop->NameEn}}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.Salary')}}</label><span class="strick">*</span>
                <input type="number" step="any" name="Salary" value="1" class="form-control" required>
            </div>

            <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.Attend')}}</label>
                <input type="time" name="Attendence" value="09:00:00" class="form-control">
            </div>

            <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.Departure')}}</label>
                <input type="time" name="Departure" value="17:00:00" class="form-control">
            </div>
        
        
                <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.ThereIsAnOtherShift')}}</label>
                <select class="select2 form-control w-100" onchange="OtherShiftChange()" name="Other_Shift" id="Other_Shift">
                    <option value="No">{{trans('admin.No')}}</option>
                    <option value="Yes">{{trans('admin.Yes')}}</option>
              
                </select>
            </div>

        
            <div class="form-group col-md-2" id="Attend2" style="display: none">
                <label class="form-label">{{trans('admin.Attend')}} 2</label>
                <input type="time" name="Attendence2" id="AttendValue"   class="form-control">
            </div>

            <div class="form-group col-md-2" id="Departure2" style="display: none">
                <label class="form-label">{{trans('admin.Departure')}} 2</label>
                <input type="time" name="Departure2" id="DepValue" class="form-control">
            </div>
        
        
        
        


            <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.Hours_Numbers')}}</label>
                <input type="number" name="Hours_Numbers" value="1" class="form-control" required>
            </div>

            <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.MonthlyTarget')}}</label>
                <input type="number" name="MonthlyTarget" value="1" class="form-control" required>
            </div>

            <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.QuarterTarget')}}</label>
                <input type="number" name="QuarterTarget" value="1" class="form-control" required>
            </div>

            <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.SemiTarget')}}</label>
                <input type="number" name="SemiTarget" value="1" class="form-control" required>
            </div>

            <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.YearlyTarget')}}</label>
                <input type="number" name="YearlyTarget" value="1" class="form-control" required>
            </div>

            <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.Job_Number')}}</label>
                <input type="text" name="Job_Number" value="{{old('Job_Number')}}" class="form-control">
            </div>

            <div class="form-group col-md-3">
                <label class="form-label">{{trans('admin.Stores')}}</label>
                <select class="select2 form-control w-100" multiple name="POSStores[]" required>
                    @foreach($Stores as $sto)
                        <option value="{{$sto->id}}" @if($sto->id == 21) selected @endif>
                            {{app()->getLocale() == 'ar' ? $sto->Name : $sto->NameEn}}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="form-group col-md-3">
                <label class="form-label">{{trans('admin.Safes')}}</label>
                <select class="select2 form-control w-100" multiple name="POSSafes[]" required>
                    @foreach($Safes as $safe)
                        <option value="{{$safe->id}}" @if($safe->id == 30) selected @endif>
                            {{app()->getLocale() == 'ar' ? $safe->Name : $safe->NameEn}}
                        </option>
                    @endforeach
                </select>
            </div>
        
            <div class="form-group col-md-2">
                <label class="form-label">{{trans('admin.ShippingCollectionType')}}</label>
                <select class="select2 form-control w-100"  name="ShippingCollectionType" id="ShippingCollectionType" onchange="ChangeShippingCollectionType()">
              <option value="">{{trans('admin.ShippingCollectionType')}}</option>
              <option value="0" selected>{{trans('admin.Value')}}</option>
              <option value="1">{{trans('admin.Precent')}}</option>
                </select>
            </div>
        
             <div class="form-group col-md-2" id="ShippingCollectionValue" >
                <label class="form-label">{{trans('admin.ShippingCollectionValue')}}</label>
                <input type="number" step="any" name="ShippingCollectionValue" value="1" class="form-control">
            </div>

        
        
                  <div class="form-group col-md-6">
                <label class="form-label">{{trans('admin.EmpPaymentAccounts')}}</label>
                <select class="select2 form-control w-100"  name="EmpPaymentAccounts[]" id="EmpPaymentAccounts" multiple >

            
                </select>
            </div>
        
        
                  <div class="form-group col-md-6">
                <label class="form-label">{{trans('admin.EmpReciptAccounts')}}</label>
                <select class="select2 form-control w-100"  name="EmpReciptAccounts[]" id="EmpReciptAccounts" multiple >

            
                </select>
            </div>
        
        
        
        

      
</div> 
                                     
  
</div>

                                 <div class="custom-card" >
                                    <!--<h1> {{trans('admin.Sub_Data')}}</h1>-->
                                    <div class="form-row">
                                       <div class="form-group col-lg-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.Price_Level')}}</label>
                                          <select class="select2 form-control" name="Price_Level" required>
                                             <option value="1">{{trans('admin.Level_1')}}</option>
                                             <option value="2">{{trans('admin.Level_2')}}</option>
                                             <option value="3">{{trans('admin.Level_3')}}</option>
                                          </select>
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="">  {{trans('admin.Have_Store')}}</label><span class="strick">*</span>
                                          <select class="select2 form-control w-100" name="STORE" required>
                                             <option value="0">{{trans('admin.No')}}</option>
                                             <option value="1">{{trans('admin.Yes')}}</option>
                                          </select>
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="">  {{trans('admin.Bill_Numbers')}}</label>
                                          <select class="select2 form-control w-100" id="Bill_Num" name="Bill_Num" onchange="bill()" required>
                                             <option value="0">{{trans('admin.No')}}</option>
                                             <option value="1">{{trans('admin.Yes')}}</option>
                                          </select>
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="">   {{trans('admin.Days_Numbers')}} </label>
                                          <input type="number" name="Days_Numbers" value="{{old('Days_Numbers')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="">   {{trans('admin.Day_Price')}} </label>
                                          <input type="number" name="Day_Price" value="{{old('Day_Price')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="">  {{trans('admin.Notes')}}    </label>
                                          <input type="text" name="Note" value="{{old('Note')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.Bank_Account')}}  </label>
                                          <input type="text" name="Bank_Account" value="{{old('Bank_Account')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.Qualifications')}}   </label>
                                          <input type="text" name="Qualifications" value="{{old('Qualifications')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput">{{trans('admin.Address')}}    </label>
                                          <input type="text" name="Address" value="{{old('Address')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput">{{trans('admin.Social_Status')}}  </label>
                                          <input type="text" name="Social_Status" value="{{old('Social_Status')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput">{{trans('admin.Contract_Start')}}  </label>
                                          <input type="date" name="Contract_Start" value="{{old('Contract_Start')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput">{{trans('admin.Contract_End')}}  </label>
                                          <input type="date" name="Contract_End" value="{{old('Contract_End')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput">{{trans('admin.IDExpireDate')}}  </label>
                                          <input type="date" name="IDExpireDate" value="{{old('IDExpireDate')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput">{{trans('admin.LicensExpireDate')}}  </label>
                                          <input type="date" name="LicensExpireDate" value="{{old('LicensExpireDate')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput">{{trans('admin.PassportExpireDate')}}  </label>
                                          <input type="date" name="PassportExpireDate" value="{{old('PassportExpireDate')}}" class="form-control">
                                       </div>
                                        <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.ID_Number')}}  </label>
                                          <input type="number" name="ID_Number" value="{{old('ID_Number')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.Phone')}}  </label>
                                          <input type="number" name="Phone" value="{{old('Phone')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput">{{trans('admin.Phone2')}}   </label>
                                          <input type="number" name="Phone2" value="{{old('Phone2')}}" class="form-control">
                                       </div>
                                        <div class="form-group col-md-2">
                                          <label class="form-label" for="">  {{trans('admin.Branch')}}</label>
                                          <select class="select2 form-control w-100" name="Branch">
                                             <option value="">{{trans('admin.Branch')}}</option>
                                             @foreach($Branches as $branch)
                                             <option value="{{$branch->id}}">
                                                {{app()->getLocale() == 'ar' ?$branch->Arabic_Name :$branch->English_Name}}
                                             </option>
                                             @endforeach
                                          </select>
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="">  {{trans('admin.Level')}}</label>
                                          <select class="select2 form-control w-100" name="Level">
                                             <option value="">{{trans('admin.Level')}}</option>
                                             @foreach($Employment_levels as $level)
                                             <option value="{{$level->id}}">
                                                {{app()->getLocale() == 'ar' ?$level->Arabic_Name :$level->English_Name}}
                                             </option>
                                             @endforeach
                                          </select>
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.Birthdate')}} </label>
                                          <input type="date" name="Birthdate" value="{{old('Birthdate')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.duration_criminal_investigation')}} </label>
                                          <input type="date" name="duration_criminal_investigation" value="{{old('duration_criminal_investigation')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.date_resignation')}} </label>
                                          <input type="date" name="date_resignation" value="{{old('date_resignation')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.Attitude_recruiting')}} </label>
                                          <input type="text" name="Attitude_recruiting" value="{{old('Attitude_recruiting')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.Living')}} </label>
                                          <input type="text" name="Living" value="{{old('Living')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.Religion')}} </label>
                                          <input type="text" name="Religion" value="{{old('Religion')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.Insurance_salary')}} </label>
                                          <input type="text" name="Insurance_salary" value="{{old('Insurance_salary')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.Previous_experience')}} </label>
                                          <input type="text" name="Previous_experience" value="{{old('Previous_experience')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.SearchCode')}} </label>
                                          <input type="text" name="SearchCode" value="{{old('SearchCode')}}" class="form-control">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="">  {{trans('admin.Insurance_companies')}}</label>
                                          <select class="select2 form-control w-100" name="Insurance_companies">
                                             <option value="">{{trans('admin.Insurance_companies')}}</option>
                                             @foreach($Insurance_companies as $comp)
                                             <option value="{{$comp->id}}">
                                                {{app()->getLocale() == 'ar' ?$comp->Arabic_Name :$comp->English_Name}}
                                             </option>
                                             @endforeach
                                          </select>
                                       </div>
                                       <div class="form-group col-md-2 mb-2">
                                          <label class="form-label customize-input" for="imgInp"><i class="fal fa-image"></i> {{trans('admin.Image')}}  </label>
                                          <input type='file' name="Image" />
                                       </div>
                                       
                                        
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.CV')}} </label>
                                          <input type="file" name="CV">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.ID_Image')}} </label>
                                          <input type="file" name="ID_Image">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.Criminal_status')}} </label>
                                          <input type="file" name="Criminal_status">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.Contract')}} </label>
                                          <input type="file" name="Contract">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.health_certificate')}} </label>
                                          <input type="file" name="health_certificate">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.Search_Card')}} </label>
                                          <input type="file" name="Search_Card">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.Recruitment_certificate')}} </label>
                                          <input type="file" name="Recruitment_certificate">
                                       </div>
                                       <div class="form-group col-md-2">
                                          <label class="form-label" for="simpleinput"> {{trans('admin.employee_profile')}} </label>
                                          <input type="file" name="employee_profile">
                                       </div>
                                    </div>
                                   
                                 </div>
                                </div>
                              </div>
                              <div class="tab-pane fade" id="tab_borders_icons-3" role="tabpanel">
                                 <div class="panel-container show">
                                    <div class="custom-card">
                                       <div id="mobile-overflow">
                                          <table
                                             class="table table-bordered table-hover table-striped w-100 mobile-width th-width">
                                             <thead>
                                                <tr>
                                                   <th>{{trans('admin.From')}}</th>
                                                   <th>{{trans('admin.To')}}</th>
                                                   <th>{{trans('admin.Salary')}} %</th>
                                                   <th>{{trans('admin.Precent')}} % </th>
                                                   <th>{{trans('admin.Rate_Type')}} </th>
                                                   <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                             </thead>
                                             <tbody>
                                                <tr>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUS()" onclick="PLUS()" step="any" id="from" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUS()" onclick="PLUS()" step="any" id="to" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUS()" onclick="PLUS()" step="any" id="salary" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUS()" onclick="PLUS()" step="any" id="rate" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <div class="form-group">
                                                         <select onchange="PLUS()" class="form-control w-100" id="XX">
                                                            <option value="1"> {{trans('admin.Precentage_of_Sales')}}  </option>
                                                            <option value="2"> {{trans('admin.Precentage_of_Execution')}}  </option>
                                                            <option value="3"> {{trans('admin.Precentage_of_Collection')}}  </option>
                                                            <option value="4"> {{trans('admin.Precentage_of_Shipping')}}  </option>
                                                         </select>
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <button type="button" onclick="InsertData()" class="btn btn-default" id="add-data"><i class="fal fa-plus"></i></button>
                                                   </td>
                                                </tr>
                                             </tbody>
                                          </table>
                                       </div>
                                       <!-- datatable start -->
                                       <div id="mobile-overflow">
                                          <table id=""
                                             class="table table-bordered table-hover table-striped w-100 mobile-width">
                                             <thead>
                                                <tr>
                                                   <th>{{trans('admin.From')}}</th>
                                                   <th>{{trans('admin.To')}}</th>
                                                   <th>{{trans('admin.Salary')}} %</th>
                                                   <th>{{trans('admin.Precent')}} % </th>
                                                   <th>{{trans('admin.Rate_Type')}} </th>
                                                   <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                             </thead>
                                             <tbody id="data-dt">
                                             </tbody>
                                          </table>
                                       </div>
                                       <!-- datatable end -->
                                    </div>
                                 </div>
                              </div>
                              <div class="tab-pane fade" id="tab_borders_icons-4" role="tabpanel">
                                 <div class="panel-container show">
                                    <div class="panel-content">
                                       <div id="mobile-overflow">
                                          <table
                                             class="table table-bordered table-hover table-striped w-100 mobile-width th-width">
                                             <thead>
                                                <tr>
                                                   <th>{{trans('admin.Name')}}</th>
                                                   <th>{{trans('admin.Amount')}}</th>
                                                   <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                             </thead>
                                             <tbody>
                                                <tr>
                                                   <td>
                                                      <div class="form-group">
                                                         <select onchange="PLUSAllow()" class="form-control w-100" id="Allow">
                                                            @foreach($Aloownces  as $allow)
                                                            <option value="{{$allow->id}}">
                                                               {{app()->getLocale() == 'ar' ?$allow->Arabic_Name :$allow->English_Name}}
                                                            </option>
                                                            @endforeach
                                                         </select>
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUSAllow()" onclick="PLUSAllow()" step="any" id="AmountAllow" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <button type="button" onclick="InsertDataAllow()" class="btn btn-default" id="add-dataAlow"><i class="fal fa-plus"></i></button>
                                                   </td>
                                                </tr>
                                             </tbody>
                                          </table>
                                       </div>
                                       <!-- datatable start -->
                                       <div id="mobile-overflow">
                                          <table id=""
                                             class="table table-bordered table-hover table-striped w-100 mobile-width">
                                             <thead>
                                                <tr>
                                                   <th>{{trans('admin.Name')}}</th>
                                                   <th>{{trans('admin.Amount')}}</th>
                                                   <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                             </thead>
                                             <tbody id="data-dtAllow">
                                             </tbody>
                                          </table>
                                       </div>
                                       <!-- datatable end -->
                                    </div>
                                 </div>
                              </div>
                              <div class="tab-pane fade" id="tab_borders_icons-5" role="tabpanel">
                                 <div class="panel-container show">
                                    <div class="panel-content">
                                       <div id="mobile-overflow">
                                          <table
                                             class="table table-bordered table-hover table-striped w-100 mobile-width th-width">
                                             <thead>
                                                <tr>
                                                   <th>{{trans('admin.Name')}}</th>
                                                   <th>{{trans('admin.Amount')}}</th>
                                                   <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                             </thead>
                                             <tbody>
                                                <tr>
                                                   <td>
                                                      <div class="form-group">
                                                         <select onchange="PLUSDiscount()" class="form-control w-100" id="Discount">
                                                            @foreach($Discounts  as $dis)
                                                            <option value="{{$dis->id}}">
                                                               {{app()->getLocale() == 'ar' ?$dis->Arabic_Name :$dis->English_Name}}
                                                            </option>
                                                            @endforeach
                                                         </select>
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUSDiscount()" onclick="PLUSDiscount()" step="any" id="AmountDiscount" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <button type="button" onclick="InsertDataDiscount()" class="btn btn-default" id="add-dataDiscount"><i class="fal fa-plus"></i></button>
                                                   </td>
                                                </tr>
                                             </tbody>
                                          </table>
                                       </div>
                                       <!-- datatable start -->
                                       <div id="mobile-overflow">
                                          <table id=""
                                             class="table table-bordered table-hover table-striped w-100 mobile-width">
                                             <thead>
                                                <tr>
                                                   <th>{{trans('admin.Name')}}</th>
                                                   <th>{{trans('admin.Amount')}}</th>
                                                   <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                             </thead>
                                             <tbody id="data-dtDiscount">
                                             </tbody>
                                          </table>
                                       </div>
                                       <!-- datatable end -->
                                    </div>
                                 </div>
                              </div>
                              <div class="tab-pane fade" id="tab_borders_icons-6" role="tabpanel">
                                 <div class="panel-container show">
                                    <div class="panel-content">
                                       <div id="mobile-overflow">
                                          <table
                                             class="table table-bordered table-hover table-striped w-100 mobile-width th-width">
                                             <thead>
                                                <tr>
                                                   <th>{{trans('admin.From')}}</th>
                                                   <th>{{trans('admin.To')}}</th>
                                                   <th>{{trans('admin.Value')}}</th>
                                                   <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                             </thead>
                                             <tbody>
                                                <tr>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUSQuantity()" onclick="PLUSQuantity()" step="any" id="FromQ" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUSQuantity()" onclick="PLUSQuantity()" step="any" id="ToQ" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUSQuantity()" onclick="PLUSQuantity()" step="any" id="ValueQ" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <button type="button" onclick="InsertDataQuantity()" class="btn btn-default" id="add-dataQ" style="display: none"><i class="fal fa-plus"></i></button>
                                                   </td>
                                                </tr>
                                             </tbody>
                                          </table>
                                       </div>
                                       <!-- datatable start -->
                                       <div id="mobile-overflow">
                                          <table id=""
                                             class="table table-bordered table-hover table-striped w-100 mobile-width">
                                             <thead>
                                                <tr>
                                                   <th>{{trans('admin.From')}}</th>
                                                   <th>{{trans('admin.To')}}</th>
                                                   <th>{{trans('admin.Value')}}</th>
                                                   <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                             </thead>
                                             <tbody id="data-dtQ">
                                             </tbody>
                                          </table>
                                       </div>
                                       <!-- datatable end -->
                                    </div>
                                 </div>
                              </div>
                              <div class="tab-pane fade" id="tab_borders_icons-9" role="tabpanel">
                                 <div class="panel-container show">
                                    <div class="panel-content">
                                       <div id="mobile-overflow">
                                          <table
                                             class="table table-bordered table-hover table-striped w-100 mobile-width th-width">
                                             <thead>
                                                <tr>
                                                   <th>{{trans('admin.From')}}</th>
                                                   <th>{{trans('admin.To')}}</th>
                                                   <th>{{trans('admin.Discount')}}</th>
                                                   <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                             </thead>
                                             <tbody>
                                                <tr>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUSAttP()" onclick="PLUSAttP()" step="any" id="FromAttP" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUSAttP()" onclick="PLUSAttP()" step="any" id="ToAttP" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUSAttP()" onclick="PLUSAttP()" step="any" id="DiscountAttP" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <button type="button" onclick="InsertDataAttP()" class="btn btn-default" id="add-dataAttP" style="display: none"><i class="fal fa-plus"></i></button>
                                                   </td>
                                                </tr>
                                             </tbody>
                                          </table>
                                       </div>
                                       <!-- datatable start -->
                                       <div id="mobile-overflow">
                                          <table id=""
                                             class="table table-bordered table-hover table-striped w-100 mobile-width">
                                             <thead>
                                                <tr>
                                                   <th>{{trans('admin.From')}}</th>
                                                   <th>{{trans('admin.To')}}</th>
                                                   <th>{{trans('admin.Discount')}}</th>
                                                   <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                             </thead>
                                             <tbody id="data-dtAttP">
                                             </tbody>
                                          </table>
                                       </div>
                                       <!-- datatable end -->
                                    </div>
                                 </div>
                              </div>
                              <div class="tab-pane fade" id="tab_borders_icons-10" role="tabpanel">
                                 <div class="panel-container show">
                                    <div class="panel-content">
                                       <div id="mobile-overflow">
                                          <table
                                             class="table table-bordered table-hover table-striped w-100 mobile-width th-width">
                                             <thead>
                                                <tr>
                                                   <th>{{trans('admin.From')}}</th>
                                                   <th>{{trans('admin.To')}}</th>
                                                   <th>{{trans('admin.Discount')}}</th>
                                                   <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                             </thead>
                                             <tbody>
                                                <tr>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUSDepP()" onclick="PLUSDepP()" step="any" id="FromDepP" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUSDepP()" onclick="PLUSDepP()" step="any" id="ToDepP" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUSDepP()" onclick="PLUSDepP()" step="any" id="DiscountDepP" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <button type="button" onclick="InsertDataDepP()" class="btn btn-default" id="add-dataDepP" style="display: none"><i class="fal fa-plus"></i></button>
                                                   </td>
                                                </tr>
                                             </tbody>
                                          </table>
                                       </div>
                                       <!-- datatable start -->
                                       <div id="mobile-overflow">
                                          <table id=""
                                             class="table table-bordered table-hover table-striped w-100 mobile-width">
                                             <thead>
                                                <tr>
                                                   <th>{{trans('admin.From')}}</th>
                                                   <th>{{trans('admin.To')}}</th>
                                                   <th>{{trans('admin.Discount')}}</th>
                                                   <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                             </thead>
                                             <tbody id="data-dtDepP">
                                             </tbody>
                                          </table>
                                       </div>
                                       <!-- datatable end -->
                                    </div>
                                 </div>
                              </div>
                           </div>
                           <div class="form-row">
                              <div class="buttons mt-3">
                                 <button type="submit" class="btn btn-primary"><i class="fal fa-save"></i>
                                 {{trans('admin.Save')}}
                                 </button>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </form>
</main>
@endsection
@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/dropzone/dropzone.css')}}">
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/dropzone/dropzone.js')}}"></script>
<script>
   /* demo scripts for change table color */
   /* change background */
   
   
   $(document).ready(function () {
   
       $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
       $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
           var title = $(this).text();
           $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');
   
           $('input', this).on('keyup change', function () {
               if (table.column(i).search() !== this.value) {
                   table
                       .column(i)
                       .search(this.value)
                       .draw();
               }
           });
       });
   
       var table = $('#dt-basic-example').dataTable(
           {
               responsive: true,
               orderCellsTop: true,
               fixedHeader: true,
               lengthChange: false,
   
               dom: "<'row mb-3'<'col-sm-12 col-md-6 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-6 d-flex align-items-center justify-content-end'B>>" +
                   "<'row'<'col-sm-12'tr>>" +
                   "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
               buttons: [
                   {
                       extend: 'colvis',
                       text: 'Column Visibility',
                       titleAttr: 'Col visibility',
                       className: 'btn-outline-default'
                   },
                   {
                       extend: 'pdfHtml5',
                       text: 'PDF',
                       titleAttr: 'Generate PDF',
                       className: 'btn-outline-danger btn-sm mr-1'
                   },
                   {
                       extend: 'excelHtml5',
                       text: 'Excel',
                       titleAttr: 'Generate Excel',
                       className: 'btn-outline-success btn-sm mr-1'
                   },
                   {
                       extend: 'csvHtml5',
                       text: 'CSV',
                       titleAttr: 'Generate CSV',
                       className: 'btn-outline-primary btn-sm mr-1'
                   },
                   {
                       extend: 'copyHtml5',
                       text: 'Copy',
                       titleAttr: 'Copy to clipboard',
                       className: 'btn-outline-primary btn-sm mr-1'
                   },
                   {
                       extend: 'print',
                       text: 'Print',
                       titleAttr: 'Print Table',
                       className: 'btn-outline-primary btn-sm'
                   }
               ],
           });
   
       $('.js-thead-colors a').on('click', function () {
           var theadColor = $(this).attr("data-bg");
           console.log(theadColor);
           $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
       });
   
       $('.js-tbody-colors a').on('click', function () {
           var theadColor = $(this).attr("data-bg");
           console.log(theadColor);
           $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
       });
   
   });
   
</script>


<!-- Search Selecet -->
<script>
    $(document).ready(function() {
        $(function() {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State"
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm
                }
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }


 
 
            $('#EmpPaymentAccounts').select2({
    placeholder: "اختار...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllSubAccounts',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});

 
            $('#EmpReciptAccounts').select2({
    placeholder: "اختار...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllSubAccounts',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});




        });
    });

</script>


<!-- Insert Table Ratio -->
<script>
   function PLUS() {
       var from = $("#from").val();
       var to = $("#to").val();
       var salary = $("#salary").val();
       var rate = $("#rate").val();
       var type = $("#XX").val();
   
       if (from != "" && to != "" && salary != "" && rate != "" && type != "") {
           document.getElementById("add-data").style.display = "block";
       }
   
   
        if (from == "" || to == "" || salary == "" || rate == "" || type == "") {
            document.getElementById("add-data").style.display = "none";
       }
   
   
   
   
   }
</script>
<script>
   function InsertData() {
       var from = document.getElementById("from").value;
       var to = document.getElementById("to").value;
       var salary = document.getElementById("salary").value;
       var rate = document.getElementById("rate").value;
       var type =  $("#XX option:selected").text();
       var typee =  $("#XX").val();
   
   
       var table = ` <tr>
                               <td>
                           ${from}
                               </td>
                           <td>
                           ${to}
                               </td>
   
                               <td>
                               ${salary}
                              </td>
                           <td>
                               ${rate}
                              </td>
                               <td>${type}
               <input type="hidden" name="from[]" value="${from}">
   <input type="hidden" name="to[]" value="${to}">
   <input type="hidden" name="salary[]" value="${salary}">
   <input type="hidden" name="rate[]" value="${rate}">
   <input type="hidden" name="type[]" value="${type}">
   <input type="hidden" name="typee[]" value="${typee}">
                                </td>
                               <td>
                   <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                               </td>
   
                            </tr>`;
   
       document.getElementById("data-dt").innerHTML += table;
   
   
   
       $("#data-dt").on("click", "#Del", function (e) {
           $(this).closest("tr").remove();
   
       });
   }
</script>
<script>
   function bill(){
   
       var Bill_Num=$('#Bill_Num').val();
   
       if(parseFloat(Bill_Num) == 1){
   
         document.getElementById('NUMOFBILLLL').style.display='block';
       }else{
   
             document.getElementById('NUMOFBILLLL').style.display='none';
       }
   
   
   }
   
   
</script>
<!-- Insert Table Allownces -->
<script>
   function PLUSAllow() {
       var Allow = $("#Allow").val();
       var AmountAllow = $("#AmountAllow").val();
   
   
       if (Allow != "" && AmountAllow != "") {
           document.getElementById("add-dataAlow").style.display = "block";
       }
   
   
        if (Allow == "" || AmountAllow == "") {
            document.getElementById("add-dataAlow").style.display = "none";
       }
   
   
   
   
   }
   
     function InsertDataAllow() {
       var Allow = document.getElementById("Allow").value;
       var AmountAllow = document.getElementById("AmountAllow").value;
       var AllowName =  $("#Allow option:selected").text();
   
   
   
       var table = ` <tr>
                               <td>
                           ${AllowName}
                               </td>
                           <td>
                           ${AmountAllow}
               <input type="hidden" name="Allow[]" value="${Allow}">
   <input type="hidden" name="AmountAllow[]" value="${AmountAllow}">
                               </td>
   
                               <td>
                   <button id="DelAllow" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                               </td>
   
                            </tr>`;
   
       document.getElementById("data-dtAllow").innerHTML += table;
   
   
   
       $("#data-dtAllow").on("click", "#DelAllow", function (e) {
           $(this).closest("tr").remove();
   
       });
   }
</script>
<!-- Insert Table Discounts -->
<script>
   function PLUSDiscount() {
       var Discount = $("#Discount").val();
       var AmountDiscount = $("#AmountDiscount").val();
   
   
       if (Discount != "" && AmountDiscount != "") {
           document.getElementById("add-dataDiscount").style.display = "block";
       }
   
   
        if (Discount == "" || AmountDiscount == "") {
            document.getElementById("add-dataDiscount").style.display = "none";
       }
   
   
   
   
   }
   
     function InsertDataDiscount() {
       var Discount = document.getElementById("Discount").value;
       var AmountDiscount = document.getElementById("AmountDiscount").value;
       var DiscountName =  $("#Discount option:selected").text();
   
   
   
       var table = ` <tr>
                               <td>
                           ${DiscountName}
                               </td>
                           <td>
                           ${AmountDiscount}
               <input type="hidden" name="Discount[]" value="${Discount}">
   <input type="hidden" name="AmountDiscount[]" value="${AmountDiscount}">
                               </td>
   
                               <td>
                   <button id="DelDiscount" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                               </td>
   
                            </tr>`;
   
       document.getElementById("data-dtDiscount").innerHTML += table;
   
   
   
       $("#data-dtDiscount").on("click", "#DelDiscount", function (e) {
           $(this).closest("tr").remove();
   
       });
   }
</script>
<!-- Insert Table Pro Quantity -->
<script>
   function PLUSQuantity() {
       var FromQ = $("#FromQ").val();
       var ToQ = $("#ToQ").val();
       var ValueQ = $("#ValueQ").val();
   
   
       if (FromQ != "" && ToQ != "" && ValueQ != "") {
           document.getElementById("add-dataQ").style.display = "block";
       }
   
   
        if (FromQ == "" || ToQ == "" || ValueQ == "") {
            document.getElementById("add-dataQ").style.display = "none";
       }
   
   
   
   
   }
   
     function InsertDataQuantity() {
          var FromQ = $("#FromQ").val();
       var ToQ = $("#ToQ").val();
       var ValueQ = $("#ValueQ").val();
   
   
   
       var table = ` <tr>
                               <td>
                           ${FromQ}
                               </td>
                               <td>
                           ${ToQ}
                               </td>
                           <td>
                           ${ValueQ}
               <input type="hidden" name="FromQ[]" value="${FromQ}">
   <input type="hidden" name="ToQ[]" value="${ToQ}">
   <input type="hidden" name="ValueQ[]" value="${ValueQ}">
                               </td>
   
                               <td>
                   <button id="DelQ" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                               </td>
   
                            </tr>`;
   
       document.getElementById("data-dtQ").innerHTML += table;
   
      $("#FromQ").val('');
   $("#ToQ").val('');
   $("#ValueQ").val('');
   document.getElementById("add-dataQ").style.display = "none";
   
       $("#data-dtQ").on("click", "#DelQ", function (e) {
           $(this).closest("tr").remove();
   
       });
   }
</script>
<!-- Insert Table Attendence Policy -->
<script>
   function PLUSAttP() {
       var FromQ = $("#FromAttP").val();
       var ToQ = $("#ToAttP").val();
       var ValueQ = $("#DiscountAttP").val();
   
   
       if (FromQ != "" && ToQ != "" && ValueQ != "") {
           document.getElementById("add-dataAttP").style.display = "block";
       }
   
   
        if (FromQ == "" || ToQ == "" || ValueQ == "") {
            document.getElementById("add-dataAttP").style.display = "none";
       }
   
   
   
   
   }
   
     function InsertDataAttP() {
          var FromQ = $("#FromAttP").val();
       var ToQ = $("#ToAttP").val();
       var ValueQ = $("#DiscountAttP").val();
   
   
   
       var table = ` <tr>
                               <td>
                           ${FromQ}
                               </td>
                               <td>
                           ${ToQ}
                               </td>
                           <td>
                           ${ValueQ}
               <input type="hidden" name="FromAttendence[]" value="${FromQ}">
   <input type="hidden" name="ToAttendence[]" value="${ToQ}">
   <input type="hidden" name="DiscountAttendence[]" value="${ValueQ}">
                               </td>
   
                               <td>
                   <button id="DelAttP" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                               </td>
   
                            </tr>`;
   
       document.getElementById("data-dtAttP").innerHTML += table;
   
      $("#FromAttP").val('');
   $("#ToAttP").val('');
   $("#DiscountAttP").val('');
   document.getElementById("add-dataAttP").style.display = "none";
   
       $("#data-dtAttP").on("click", "#DelAttP", function (e) {
           $(this).closest("tr").remove();
   
       });
   }
</script>
<!-- Insert Table Departure Policy -->
<script>
   function PLUSDepP() {
       var FromQ = $("#FromDepP").val();
       var ToQ = $("#ToDepP").val();
       var ValueQ = $("#DiscountDepP").val();
   
   
       if (FromQ != "" && ToQ != "" && ValueQ != "") {
           document.getElementById("add-dataDepP").style.display = "block";
       }
   
   
        if (FromQ == "" || ToQ == "" || ValueQ == "") {
            document.getElementById("add-dataDepP").style.display = "none";
       }
   
   
   
   
   }
   
     function InsertDataDepP() {
          var FromQ = $("#FromDepP").val();
       var ToQ = $("#ToDepP").val();
       var ValueQ = $("#DiscountDepP").val();
   
   
   
       var table = ` <tr>
                               <td>
                           ${FromQ}
                               </td>
                               <td>
                           ${ToQ}
                               </td>
                           <td>
                           ${ValueQ}
               <input type="hidden" name="FromDeparture[]" value="${FromQ}">
   <input type="hidden" name="ToDeparture[]" value="${ToQ}">
   <input type="hidden" name="DiscountDeparture[]" value="${ValueQ}">
                               </td>
   
                               <td>
                   <button id="DelDepP" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                               </td>
   
                            </tr>`;
   
       document.getElementById("data-dtDepP").innerHTML += table;
   
      $("#FromDepP").val('');
   $("#ToDepP").val('');
   $("#DiscountDepP").val('');
   document.getElementById("add-dataDepP").style.display = "none";
   
       $("#data-dtDepP").on("click", "#DelDepP", function (e) {
           $(this).closest("tr").remove();
   
       });
   }
</script>


<!-- Shipping Value -->
<script>
function ChangeShippingCollectionType(){
    
      var ShippingCollectionType = $("#ShippingCollectionType").val();

       if (ShippingCollectionType == 0) {
           document.getElementById("ShippingCollectionValue").style.display = "block";
       }else{
         
                   document.getElementById("ShippingCollectionValue").style.display = "none";
       }
   
    


    
}


</script>

<script>
function OtherShiftChange (){
    
    var Other_Shift=$('#Other_Shift').val();
    
    
    if(Other_Shift == 'Yes'){
        
        document.getElementById('Attend2').style.display='block';
        $('#AttendValue').val('09:00:00');
          
        document.getElementById('Departure2').style.display='block';
        $('#DepValue').val('17:00:00');
       
       }else{
           
           
                  document.getElementById('Attend2').style.display='none';
        $('#AttendValue').val('');
          
        document.getElementById('Departure2').style.display='none';
        $('#DepValue').val('');
       
           
           
       }
    
}

</script>
@endpush