@extends('admin.index')
@section('content')

    <title>{{trans('admin.TicketReport')}}</title>
    <style>
        .box{
            position: relative;
            padding:20px 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            margin-top:25px;
        }
        .box h3{
            position: absolute;
            background: white;
            top: -25px;
            padding: 5px;
        }
        .nav-item{
            width:50%;
        }
        .select-border , .select2-selection--single ,.select2-selection--multiple, input[type="checkbox"]{
            border: 2px solid #584576!important;
            font-size:15px;
        }
        /* The container */
        .container {
            display: block;
            position: relative;
            padding-right: 35px;
            margin-bottom: 12px;
            cursor: pointer;
            font-size: 13px;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
        }
        /* Hide the browser's default checkbox */
        .container input {
            position: absolute;
            opacity: 0;
            cursor: pointer;
            height: 0;
            width: 0;
        }
        /* Create a custom checkbox */
        .checkmark {
            position: absolute;
            top: 0;
            right: 0;
            height: 20px;
            width: 20px;
            border-radius: 3px;
            border: 2px solid #584576;
            transition:.5s;
        }
        /* On mouse-over, add a grey background color */
        .container:hover input ~ .checkmark {
            background-color: #ccc;
            transition:.5s;
        }
        /* When the checkbox is checked, add a blue background */
        .container input:checked ~ .checkmark {
            background-color: #584576;
        }
        /* Create the checkmark/indicator (hidden when not checked) */
        .checkmark:after {
            content: "";
            position: absolute;
            display: none;
        }
        /* Show the checkmark when checked */
        .container input:checked ~ .checkmark:after {
            display: block;
        }
        /* Style the checkmark/indicator */
        .container .checkmark:after {
            left: 5px;
            top: 1px;
            width: 7px;
            height: 12px;
            border: solid white;
            border-width: 0 3px 3px 0;
            -webkit-transform: rotate(45deg);
            -ms-transform: rotate(45deg);
            transform: rotate(45deg);
        }
    </style>
    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.CRM')}}</a></li>
            <li class="breadcrumb-item active">{{trans('admin.TicketReport')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>
        <form action="{{url('TicketReportFilter')}}" method="get" enctype="multipart/form-data">
            @csrf
            @honeypot
            <div class="row">
                <div class="col-xl-12">
                    <div  class="panel">
                        <div class="panel-container show">
                            <div class="panel-content">
                                <div class="panel-container show">
                                    <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">
                                        <ul class="nav nav-tabs" role="tablist">
                                            <li class="nav-item" >
                                                <a class="nav-link active" data-toggle="tab" href="#tab_borders_icons-1" role="tab" style="background: #add8e680;"><i class="fal fa-home mr-1"></i>{{trans('admin.Filter')}}</a>
                                            </li>

                                        </ul>
                                        <div class="tab-content border border-top-0 p-3">
                                            <div class="tab-pane fade show active" id="tab_borders_icons-1" role="tabpanel">
                                                <div class="row">
                                                    <div class="col-lg-12">
                                                        <div class="row">


                                                            <div class="form-group col-md-3 col-12">
                                                                <label class="form-label" for="simpleinput">{{trans('admin.From')}}</label><span class="strick">*</span>
                                                                <input  type="date" value="{{date('Y-m-d')}}"  name="From" class="form-control  select-border" required>
                                                            </div>

                                                            <div class="form-group col-md-3 col-12">
                                                                <label class="form-label" for="simpleinput">{{trans('admin.To')}}</label><span class="strick">*</span>
                                                                <input  type="date" value="{{date('Y-m-d')}}"   name="To" class="form-control  select-border" required >
                                                            </div>

                                                       
                                                            <div class="form-group col-md-3 col-12">
                                                                <label class="form-label" for="">  {{trans('admin.Client')}}</label>

                                                                <select class="select2 form-control w-100 ; select-border"  id="Customer" name="Customer">
                                                                   <option value="">{{trans('admin.Client')}}</option>
                                                      
                                                                </select>
                                                            </div>

                                                           
                                                            <div class="form-group col-md-3 col-12">
                                                                <label class="form-label" for="">  {{trans('admin.Responsible')}}</label>

                                                                <select class="select2 form-control w-100 ; select-border"  id="Responsible" name="Responsible">
                                                                   <option value="">{{trans('admin.Responsible')}}</option>
                                                      
                                                                </select>
                                                            </div>

                                                      

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>

                                        </div>
                                        <div class="form-row">
                                            <div class="buttons mt-3">
                                                <button type="submit" class="btn btn-primary"><i class="fal fa-save"></i>
                                                    {{trans('admin.ShowReport')}}
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </main>
@endsection
@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
    <!-- Search Selecet -->
    <script>
        $(document).ready(function()
        {
            $(function()
            {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2(
                    {
                        placeholder: "Select State"
                    });
                $(".js-hide-search").select2(
                    {
                        minimumResultsForSearch: 1 / 0
                    });
                $(".js-max-length").select2(
                    {
                        maximumSelectionLength: 2,
                        placeholder: "Select maximum 2 items"
                    });
                $(".select2-placeholder").select2(
                    {
                        placeholder: "Select a state",
                        allowClear: true
                    });

                $(".js-select2-icons").select2(
                    {
                        minimumResultsForSearch: 1 / 0,
                        templateResult: icon,
                        templateSelection: icon,
                        escapeMarkup: function(elm)
                        {
                            return elm
                        }
                    });

                function icon(elm)
                {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }


                
                   $('#Responsible').select2({
    placeholder: "اختار...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllEmps',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                
                   $('#Customer').select2({
    placeholder: "اختار...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllCli',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});

 
 
                
        
        

                


            });
        });
    </script>


@endpush
