@extends('admin.index')
@section('content')
@php
use App\Models\Interviews;
use App\Models\Sales;
@endphp
  <title>{{trans('admin.MyMettings')}}</title>

  <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.CRM')}}</a></li>
                        <li class="breadcrumb-item">{{trans('admin.MyMettings')}}</li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

                    <!-- data entry -->

                    <div class="row hide-table">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2> {{trans('admin.MyMettings')}}</h2>
                                    <div class="panel-toolbar">
                                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">TableStyle</button>
                                        @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                                               <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">

                                        <!-- datatable start -->
                                        <div style="overflow:auto">
                                        <table id="dt-basic-example"
                                            class="table table-bordered table-hover table-striped ">
                                            <thead class="bg-highlight">
                                                <tr>
                                                   <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.Time')}}</th>
                                                      <th>{{trans('admin.Client')}}</th>
                                                      <th>{{trans('admin.Phone')}}</th>
                                                      <th>{{trans('admin.Metting_Type')}}</th>
                                                      <th>{{trans('admin.Previous_Interviews')}}</th>
                                                      <th>{{trans('admin.Data')}}</th>
                                                      <th>{{trans('admin.Note')}}</th>
                                                      <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                        @foreach($items as $item)
                                                <tr>
                                                    <td>{{$item->Code}}</td>
                                                    <td>{{$item->Date}}</td>
                                                    <td>{{$item->Time}}</td>
                                                    <td>
                                                        @if(!empty($item->Client()->first()->Name))
                                                     {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}
                                                        @endif
                                                    </td>

                                                                        <td>
                                                         @if(!empty($item->Client()->first()->Phone))
                                                        {{$item->Client()->first()->Phone}}
                                                        @endif

                                                        </td>

                                                    <td>
                                                  @if(!empty($item->Type()->first()->Arabic_Name))


                               {{app()->getLocale() == 'ar' ?$item->Type()->first()->Arabic_Name :$item->Type()->first()->English_Name}}
                                                @endif
                                                    </td>

                                                    <td>
                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center-open{{$item->id}}"> {{trans('admin.Previous_Interviews')}} </button>

                                                </td>
                                                               <td>
                                                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#show-data{{$item->id}}">
                                                           {{trans('admin.Data')}}
                                                        </button>
                                                    </td>
                                                                       <td>
                                                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#note{{$item->id}}">
                                                           {{trans('admin.Note')}}
                                                        </button>
                                                    </td>
                                                    <td>

                                      <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Done{{$item->id}}"><i class="fal fa-check"></i></button>


                                                    </td>
                                                </tr>
                                            @endforeach
                                           </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.Time')}}</th>
                                                      <th>{{trans('admin.Client')}}</th>
                                                      <th>{{trans('admin.Phone')}}</th>

                                                      <th>{{trans('admin.Metting_Type')}}</th>
                                                      <th>{{trans('admin.Previous_Interviews')}}</th>
                                                      <th>{{trans('admin.Data')}}</th>
                                                         <th>{{trans('admin.Note')}}</th>
                                                      <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </tfoot>

                                        </table>
                                      </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>




                </main>

       @foreach($items as $item)
       <!-- Modal Done -->
                      <div class="modal fade" id="Done{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                  <form action="{{url('Done/'.$item->id)}}" method="get">
                                <div class="modal-header">
                                    <h4 class="modal-title">



                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                     <div class="row">
                                <textarea name="StatusNote" class="form-control">

                                        {{old('StatusNote')}}
                                        </textarea>
                                        </div>
                                </div>

                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                  <button type="submit" class="btn btn-secondary" > {{trans('admin.Yes')}}</button>

                                </div>
                                </form>
                            </div>
                        </div>
                    </div>



                  <!-- Modal History-->
        <div class="modal fade" id="default-example-modal-center-open{{$item->id}}" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">

                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>

                        <div class="modal-body">
                            @php
            $Backs=Interviews::orderBy('id','desc')
            ->where('Client',$item->Client)
            ->where('Status',1)
            ->get();

                $visit=Interviews::orderBy('id','desc')
            ->where('Client',$item->Client)
             ->where('Status',1)
            ->count();

            $billNum=Sales::orderBy('id','desc')
            ->where('Client',$item->Client()->first()->Account)
            ->count();

            $billTot=Sales::orderBy('id','desc')
            ->where('Client',$item->Client()->first()->Account)
            ->get()->sum('Total_Price');

                            @endphp

                            @foreach($Backs as $bb)
                            <div class="form-row">
                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Employee')}} </label>
                                    <input type="text" value="{{app()->getLocale() == 'ar' ?$bb->Emp()->first()->Name :$bb->Emp()->first()->NameEn}}"  class="form-control" disabled>
                                </div>
                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}  </label>
                                    <input type="date" value="{{$bb->Date}}"  class="form-control" disabled>
                                </div>
                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Time')}}  </label>
                                    <input type="time" value="{{$bb->Time}}"  class="form-control" disabled>
                                </div>
                                <div class="form-group col-lg-12">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Interview_Biref')}} </label>
                                    <input type="text" value="{{$bb->StatusNote}}" class="form-control"  disabled>

                                </div>
                            </div>
                            @endforeach
                        <div class="mt-3">
                            <table id=""
                            class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                    <th> {{trans('admin.VisitNum')}}</th>
                                    <th> {{trans('admin.BillsNum')}}</th>
                                    <th> {{trans('admin.BillsTotal')}}</th>
                                </tr>
                            </thead>
                            <tbody id="">
                                <tr>
                                    <td> {{$visit}}</td>
                                    <td> {{$billNum}}</td>
                                    <td> {{$billTot}}</td>

                                </tr>
                            </tbody>
                        </table>
                        </div>
                        <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>
</div>

                    <!-- Modal show data -->
    <div class="modal fade" id="show-data{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                             {{trans('admin.Data')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
      <div style="overflow:auto;">
        <table id="" class="table table-bordered table-hover table-striped " >
                                            <thead class="bg-highlight">
                                                <tr>

                               <th>{{trans('admin.Activity')}}</th>
                                                      <th>{{trans('admin.Governrate')}}</th>
                                                      <th>{{trans('admin.City')}}</th>
                                                      <th>{{trans('admin.Client_Status')}}</th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                                <tr>
                                             <td>

                                                    @if(!empty($item->Client()->first()->Activity()->first()->Arabic_Name ))
                                                   {{app()->getLocale() == 'ar' ?$item->Client()->first()->Activity()->first()->Arabic_Name :$item->Client()->first()->Activity()->first()->English_Name}}
                                                    @endif

                                                    </td>
                                                    <td>
                                                      @if(!empty($item->Client()->first()->Governrate()->first()->Arabic_Name))
                                                         {{app()->getLocale() == 'ar' ?$item->Client()->first()->Governrate()->first()->Arabic_Name :$item->Client()->first()->Governrate()->first()->English_Name}}
                                                    @endif
                                                    </td>
                                                    <td>
                                                      @if(!empty($item->Client()->first()->City()->first()->Arabic_Name))
                                                   {{app()->getLocale() == 'ar' ?$item->Client()->first()->City()->first()->Arabic_Name :$item->Client()->first()->City()->first()->English_Name}}
                                                    @endif
                                                    </td>
                                                    <td>
                                                      @if(!empty($item->Client()->first()->ClientStatus()->first()->Arabic_Name))
                                                         {{app()->getLocale() == 'ar' ?$item->Client()->first()->ClientStatus()->first()->Arabic_Name :$item->Client()->first()->ClientStatus()->first()->English_Name}}
                                                    @endif
                                                    </td>


                                                </tr>


                                            </tbody>


                                        </table>

                                        </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>

                        </div>
                    </div>
                </div>
            </div>


                            <!-- Modal Note -->
    <div class="modal fade" id="note{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                             {{trans('admin.Note')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
    {{$item->Note}}

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>

                        </div>
                    </div>
                </div>
            </div>



  @endforeach

@endsection

@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
  <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>

    <!-- Search Selecet -->
 <script>
        $(document).ready(function()
        {
            $(function()
            {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2(
                {
                    placeholder: "Select State"
                });
                $(".js-hide-search").select2(
                {
                    minimumResultsForSearch: 1 / 0
                });
                $(".js-max-length").select2(
                {
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items"
                });
                $(".select2-placeholder").select2(
                {
                    placeholder: "Select a state",
                    allowClear: true
                });

                $(".js-select2-icons").select2(
                {
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function(elm)
                    {
                        return elm
                    }
                });

                function icon(elm)
                {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }


  $('.Client').select2({
    placeholder: "select...",
    ajax: {
        type: "GET",
        dataType: 'json',
        url: 'AllClients',
        processResults: function (data) {
          return {
            results: $.map(data, function(obj, index) {
              return { id: index, text: obj };
            })
          };

            	console.log(data);

        },
        data: function (params) {
          var query = {
            search: params.term
          };
          if (params.term == "*") query.items = [];
          return { json: JSON.stringify( query ) }
        }
    }
  });


$('.Client').on('select2:select', function (e) {
	console.log("select done", e.params.data);
});



            });
        });



    </script>

    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
@endpush
