@extends('admin.index')
@section('content')

    <title>{{trans('admin.MyFollowList')}}</title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.CRM')}}</a></li>
            <li class="breadcrumb-item active">{{trans('admin.MyFollowList')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i>{{trans('admin.MyFollowList')}}</i></span>
                        </h2>

                        <div class="panel-toolbar">

                            @include('admin.layouts.toolbar')
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <!-- datatable start -->
                            <div id="mobile-overflow">
                                <table id="dt-basic-example"
                                       class="table table-bordered table-hover table-striped w-100 mobile-width">
                                    <thead class="bg-highlight">
                                    <tr>
                                        <th>{{trans('admin.Client')}}</th>
                                        <th>{{trans('admin.Client_Phone')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    @foreach($items as $item)
                                        <tr @if($item->Status == 1) style="background-color: #0175d5; color: white" @endif>


                                            <td>

                                                @if(!empty($item->Client()->first()->Name))
                                                {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}
                                                @endif
                                            </td>
                                            <td>
                                                @if(!empty($item->Client))
                                                    @php $cust=\App\Models\Customers::where('Account',$item->Client)->latest('id')->first(); @endphp

                                                @if(!empty($cust->Phone))
                                                {{$cust->Phone}}
                                                    @endif


                                                @endif
                                            </td>
                                            <td>

                                                <a href="{{url('AddCommentFollow/'.$item->id)}}" class="btn btn-default"><i class="fal fa-check"></i></a>


                                            </td>

                                        </tr>




                                    @endforeach


                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <th>{{trans('admin.Client')}}</th>
                                        <th>{{trans('admin.Client_Phone')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                        {{$items->Links()}}
                        <!-- datatable end -->
                    </div>
                </div>
            </div>
        </div>
        </div>


    </main>



@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
    <!-- Search Selecet -->
    <script>

        $(document).ready(function () {
            $(function () {
                $(".select2").select2();

                $(".select2-placeholder-multiple").select2({
                    placeholder: "Select State",
                });
                $(".js-hide-search").select2({
                    minimumResultsForSearch: 1 / 0,
                });
                $(".js-max-length").select2({
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items",
                });
                $(".select2-placeholder").select2({
                    placeholder: "Select a state",
                    allowClear: true,
                });

                $(".js-select2-icons").select2({
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function (elm) {
                        return elm;
                    },
                });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
                }

                $(".Emp").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "AllEmps",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllEmpsJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('.Emp').empty();
                                    $.each(data, function(key, value){

                                        $('.Emp').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $(".Emp").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });

                $(".Ship").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "AllShips",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllShipsJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('.Ship').empty();
                                    $.each(data, function(key, value){

                                        $('.Ship').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $(".Ship").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });

                $(".Vend").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "AllVend",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllVendJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('.Vend').empty();
                                    $.each(data, function(key, value){

                                        $('.Vend').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $(".Vend").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });


                $(".Cli").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "AllCli",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllCliJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('.Cli').empty();
                                    $.each(data, function(key, value){

                                        $('.Cli').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $(".Cli").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });

                $(".Exe").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "AllEmps",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllEmpsJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('.Exe').empty();
                                    $.each(data, function(key, value){

                                        $('.Exe').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $(".Exe").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });





            });
        });
    </script>

@endpush

