@extends('admin.index')
@section('content')

    <title>{{trans('admin.FollowList')}}</title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.CRM')}}</a></li>
            <li class="breadcrumb-item active">{{trans('admin.FollowList')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i>{{trans('admin.FollowList')}}</i></span>
                        </h2>

                        <div class="panel-toolbar">

                            @include('admin.layouts.toolbar')
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">

                            <div class="row">

                                <div class="col-md-2">
                                    <a href="{{url('FollowListSat/'.$emp)}}" class="btn btn-primary" >{{trans('admin.Sat')}}</a>
                                </div>
                                <div class="col-md-2">
                                 <a href="{{url('FollowListSun/'.$emp)}}" class="btn btn-primary" >{{trans('admin.Sun')}}</a>
                                </div>
                                <div class="col-md-2">
                                            <a href="{{url('FollowListMon/'.$emp)}}" class="btn btn-primary" >{{trans('admin.Mon')}}</a>
                                </div>
                                <div class="col-md-2">
                    <a href="{{url('FollowListTue/'.$emp)}}" class="btn btn-primary" >{{trans('admin.Tue')}}</a>
                                </div>
                                <div class="col-md-2">
                          <a href="{{url('FollowListWed/'.$emp)}}" class="btn btn-primary">{{trans('admin.Wed')}}</a>
                                </div>
                                <div class="col-md-1">
                                    <a href="{{url('FollowListThr/'.$emp)}}" class="btn btn-primary" >{{trans('admin.Thr')}}</a>
                                </div>
                                <div class="col-md-1">
                                    <a href="{{url('FollowListFri/'.$emp)}}" class="btn btn-primary" >{{trans('admin.Fri')}}</a>
                                </div>

                            </div>

                        </div>
                        <!-- datatable end -->
                    </div>
                </div>
            </div>
        </div>
        </div>


    </main>










@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>

    <!-- Search Selecet -->
    <script>
        $(document).ready(function()
        {
            $(function()
            {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2(
                    {
                        placeholder: "Select State"
                    });
                $(".js-hide-search").select2(
                    {
                        minimumResultsForSearch: 1 / 0
                    });
                $(".js-max-length").select2(
                    {
                        maximumSelectionLength: 2,
                        placeholder: "Select maximum 2 items"
                    });
                $(".select2-placeholder").select2(
                    {
                        placeholder: "Select a state",
                        allowClear: true
                    });

                $(".js-select2-icons").select2(
                    {
                        minimumResultsForSearch: 1 / 0,
                        templateResult: icon,
                        templateSelection: icon,
                        escapeMarkup: function(elm)
                        {
                            return elm
                        }
                    });

                function icon(elm)
                {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }


                $('.Client').select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: 'json',
                        url: 'AllCli',
                        processResults: function (data) {
                            return {
                                results: $.map(data, function(obj, index) {
                                    return { id: index, text: obj };
                                })
                            };

                            console.log(data);

                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllCliJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('.Client').empty();
                                    $.each(data, function(key, value){

                                        $('.Client').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    }
                });


                $('.Client').on('select2:select', function (e) {
                    console.log("select done", e.params.data);
                });



                $('#Client').select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: 'json',
                        url: 'AllCli',
                        processResults: function (data) {
                            return {
                                results: $.map(data, function(obj, index) {
                                    return { id: index, text: obj };
                                })
                            };

                            console.log(data);

                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllCliJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('#Client').empty();
                                    $.each(data, function(key, value){

                                        $('#Client').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    }
                });


                $('#Client').on('select2:select', function (e) {
                    console.log("select done", e.params.data);
                });



            });
        });



    </script>
@endpush

