@php 
use App\Models\CommentsClients;
use App\Models\Sales; 
use App\Models\CustomerCommentsProducts; 
use App\Models\SalesOrder; 
@endphp
@extends('admin.index')
@section('content')

    <title>{{trans('admin.Customerـfollowـup_Reports')}}</title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.CRM')}}</a></li>
            <li class="breadcrumb-item active">{{trans('admin.Customerـfollowـup_Reports')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i>{{trans('admin.Customerـfollowـup_Reports')}}</i></span>
                        </h2>

                        <div class="panel-toolbar">

                        </div>
                        @include('admin.layouts.toolbar')
                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <!-- datatable start -->
                            <table 
                                   class="table table-bordered table-hover table-striped w-100">
                                <thead class="bg-highlight">
                                <tr>
                                    <th>{{trans('admin.Client')}}</th>
                                    <th>{{trans('admin.Addation_Date')}}</th>
                                    <th>{{trans('admin.Date_First_Comment')}}</th>
                                    <th>{{trans('admin.Date_First_Bill')}}</th>
                                    <th>{{trans('admin.Operation_Date')}}</th>
                                    <th>{{trans('admin.Dif_Days_Addation_Date_First_Comment')}}</th>
                                    <th>{{trans('admin.Dif_Days_Addation_Date_First_Bill')}}</th>
                                    <th>{{trans('admin.Dif_Days_Addation_Date_Operation_Date')}}</th>
                                    
                                     <th>{{trans('admin.Date_Last_Comment')}}</th>
                                     <th>{{trans('admin.First_Emp_Communcate')}}</th>
                                     <th>{{trans('admin.First_Emp_Deal')}}</th>
                                     <th>{{trans('admin.Campaign')}}</th>
                                     <th>{{trans('admin.Total_Comments')}}</th>
                                     <th>{{trans('admin.Total_Products')}}</th>
                                     <th>{{trans('admin.SalesOrders_Num')}}</th>
                                     <th>{{trans('admin.SalesBill_Num')}}</th>
                                     <th>{{trans('admin.SalesBill_Num_This_Month')}} ({{trans('admin.Total')}})</th>
                                     <th>{{trans('admin.SalesBill_Num_This_Year')}} ({{trans('admin.Total')}})</th>
                                </tr>
                                </thead>
                                <tbody>

                                @foreach($items as $item)
                                    @php
                                        $SalesOrderNum = SalesOrder::where('Client', $item->Account)->count();
                                        $SalesNum = Sales::where('Client', $item->Account)->count();
                                        $SalesNumMonth = Sales::where('Client', $item->Account)->whereBetween('Date',[date('Y-m-01'),date('Y-m-d')])->count();
                                        $SalesNumYear = Sales::where('Client', $item->Account)->whereBetween('Date',[date('Y-01-01'),date('Y-12-31')])->count();
                                        $TotalComment = CommentsClients::where('Customer', $item->id)->count();
                                        $TotalProduct = CustomerCommentsProducts::whereRelation('Comment','Customer', $item->id)->count();
                                        $firstComment = CommentsClients::where('Customer', $item->id)->orderBy('Date')->first();
                                        $firstEmp = CommentsClients::where('Customer', $item->id)->orderBy('Date')->first();
                                        $LastComment = CommentsClients::where('Customer', $item->id)->orderBy('id','desc')->first();
                                        $firstBill = Sales::where('Client', $item->Account)->oldest('Date')->first();
                                        $firstEmpBill = Sales::where('Client', $item->Account)->oldest('Date')->first();
                                    
                                                  if (!empty($firstComment)) {
                                                  $firstComment = $firstComment->Date;

                                                  } else {
                                                  $firstComment = 0;

                                                  }


                                                  if (!empty($firstEmp)) {

                                                  if(!empty($firstEmp->Responsible()->first()->Name)){
                                                  $firstEmpCom = $firstEmp->Responsible()->first()->Name;
                                                  }else{
                                                  $firstEmpCom = '';
                                                  }

                                                  } else {

                                                  $firstEmpCom = '';
                                                  }


                                                  if (!empty($firstEmpBill)) {

                                                  if(!empty($firstEmpBill->Delegate()->first()->Name)){
                                                  $firstEmpDeal = $firstEmpBill->Delegate()->first()->Name;
                                                  }else{
                                                  $firstEmpDeal = '';
                                                  }

                                                  } else {

                                                  $firstEmpDeal = '';
                                                  }


                                                  if (!empty($LastComment)) {
                                                  $LastComment = $LastComment->Date;
                                                  } else {
                                                  $LastComment = 0;
                                                  }


                                                  if (!empty($firstBill)) {
                                                  $firstBill = $firstBill->Date;
                                                  } else {
                                                  $firstBill = 0;
                                                  }


                                                  $datetime1 = new DateTime($item->Date);
                                    
                                                  if ($firstComment != 0) {
                                                  $datetime2 = new DateTime($firstComment);
                                                  $interval = $datetime1->diff($datetime2);
                                                  $daysComment = $interval->format('%a');
                                                  } else {
                                                  $daysComment = 0;
                                                  }

                                                  if ($firstBill != 0) {
                                                  $datetimeBill = new DateTime($firstBill);
                                                  $intervalBill = $datetime1->diff($datetimeBill);
                                                  $daysBill = $intervalBill->format('%a');
                                                  } else {
                                                  $daysBill = 0;
                                                  }

                                                  if (!empty($item->Operation_Date)) {
                                                  $datetimeOp = new DateTime($item->Operating_Date);
                                                  $intervalOp = $datetime1->diff($datetimeOp);
                                                  $daysOp = $intervalOp->format('%a');
                                                  } else {
                                                  $daysOp = 0;
                                                  }
                                    @endphp

                                    <tr>
                                        <td>
                                            {{app()->getLocale() == 'ar' ?$item->Name :$item->NameEn}}
                                        </td>
                                        <td>{{$item->Date}}</td>
                                        <td>{{$firstComment}}</td>
                                        <td>{{$firstBill}}</td>
                                        <td>{{$item->Operating_Date}}</td>
                                        <td>{{$daysComment}}</td>
                                        <td>{{$daysBill}}</td>
                                        <td>{{$daysOp}}</td>
                                        <td>{{$LastComment}}</td>
                                        <td>{{$firstEmpCom}}</td>
                                        <td>{{$firstEmpDeal}}</td>
                                        <td>
                                            @if(!empty($item->Campagin()->first()->Arabic_Name))
                                             {{app()->getLocale() == 'ar' ?$item->Campagin()->first()->Arabic_Name :$item->Campagin()->first()->English_Name}}
                                        @endif
                                        
                                        </td>
                                        
                                        <td>

                                     <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#TotalComment" onclick="AllComments({{ $item->id }})">{{$TotalComment}}</button>

                                        </td>        
                                        
                                        <td>

                                     <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#TotalProduct" onclick="AllProduct({{ $item->id }})">{{$TotalProduct}}</button>

                                        </td>
                                       
                                        <td>

                                     <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#SalesOrder" onclick="AllSalesOrder({{ $item->id }})">{{$SalesOrderNum}}</button>

                                        </td>
                                       
                                        <td>

                                     <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#Sales" onclick="AllSales({{ $item->id }})">{{$SalesNum}}</button>

                                        </td>
                            
                                 

                                        <td>{{$SalesNumMonth}}</td>
                                        <td>{{$SalesNumYear}}</td>
                                        


                                    </tr>
                                @endforeach
                                </tbody>
                                <tfoot>
                                <tr>
                                    <th>{{trans('admin.Client')}}</th>
                                    <th>{{trans('admin.Addation_Date')}}</th>
                                    <th>{{trans('admin.Date_First_Comment')}}</th>
                                    <th>{{trans('admin.Date_First_Bill')}}</th>
                                    <th>{{trans('admin.Operation_Date')}}</th>
                                    <th>{{trans('admin.Dif_Days_Addation_Date_First_Comment')}}</th>
                                    <th>{{trans('admin.Dif_Days_Addation_Date_First_Bill')}}</th>
                                    <th>{{trans('admin.Dif_Days_Addation_Date_Operation_Date')}}</th>
                                    
                                    <th>{{trans('admin.Date_Last_Comment')}}</th>
                                     <th>{{trans('admin.First_Emp_Communcate')}}</th>
                                     <th>{{trans('admin.First_Emp_Deal')}}</th>
                                     <th>{{trans('admin.Campaign')}}</th>
                                     <th>{{trans('admin.Total_Comments')}}</th>
                                     <th>{{trans('admin.Total_Products')}}</th>
                                     <th>{{trans('admin.SalesOrders_Num')}}</th>
                                     <th>{{trans('admin.SalesBill_Num')}}</th>
                                     <th>{{trans('admin.SalesBill_Num_This_Month')}} ({{trans('admin.Total')}})</th>
                                     <th>{{trans('admin.SalesBill_Num_This_Year')}} ({{trans('admin.Total')}})</th>
                                </tr>
                                </tfoot>
                            </table>
                            <!-- datatable end -->
                            {{$items->Links()}}
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </main>



       <div class="modal fade" id="TotalComment" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.Comments')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                           

                                                    <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                    
                                        <th>{{trans('admin.Date')}} </th>
                                        <th>{{trans('admin.Time')}} </th>
                                        <th>{{trans('admin.Comment')}} </th>
                                        <th>{{trans('admin.Responsible')}} </th>
                                        <th>{{trans('admin.Note')}} </th>
                 
                                    </tr>
                                    </thead>
                                    <tbody class="CommentsShow">

                                     
                                    </tbody>
                                </table>
                            </div>


                                        </div>
                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                </div>
                         
                                </div>

                            </div>
                        </div>
           

       <div class="modal fade" id="TotalProduct" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.Products')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                           

                                                    <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                    
                                        <th>{{trans('admin.Product')}} </th>

                 
                                    </tr>
                                    </thead>
                                    <tbody class="ProductsShow">

                                     
                                    </tbody>
                                </table>
                            </div>


                                        </div>
                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                </div>
                         
                                </div>

                            </div>
                        </div>


       
       <div class="modal fade" id="SalesOrder" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.SalesOrder')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                           

                                                    <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                    
                                        <th>{{trans('admin.Date')}} </th>
                                        <th>{{trans('admin.Code')}} </th>
                                        <th>{{trans('admin.Actions')}} </th>

                 
                                    </tr>
                                    </thead>
                                    <tbody class="SalesOrderShow">

                                     
                                    </tbody>
                                </table>
                            </div>


                                        </div>
                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                </div>
                         
                                </div>

                            </div>
                        </div>
           
         
       
       <div class="modal fade" id="Sales" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.Sales')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                           

                                                    <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                    
                                        <th>{{trans('admin.Date')}} </th>
                                        <th>{{trans('admin.Code')}} </th>
                                        <th>{{trans('admin.Actions')}} </th>

                 
                                    </tr>
                                    </thead>
                                    <tbody class="SalesShow">

                                     
                                    </tbody>
                                </table>
                            </div>


                                        </div>
                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                </div>
                         
                                </div>

                            </div>
                        </div>
           
                         

@endsection

@push('js')
    <link rel="stylesheet" media="screen, print"
          href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            exportOptions: {
                                format: {
                                    body: function ( inner, rowidx, colidx, node ) {
                                        if ($(node).children("select").length > 0) {
                                            // we are in a cell containing a "select" drop-down - so, get it:
                                            var selectNode = node.firstElementChild;
                                            var txt = selectNode.options[selectNode.selectedIndex].text;
                                            //var txt = selectNode.options[selectNode.selectedIndex].text;
                                            return txt;
                                        } else {

                                            if ($(node).children("input").length > 0) {
                                                return $(node).children("input").first().val();
                                            } else {
                                                return inner;
                                            }


                                        }
                                    }
                                }
                            },
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>



<!-- Comments -->
<script>
 function AllComments(customer){


     $.ajax({
      url:'CustomerFollowCommentsFilter',
      method:'GET',
      data:{customer:customer},
      dataType:'json',
      success:function(data)
      {
       $('.CommentsShow').html(data.table_data);
                    
      }
     })
    



 }

</script>

<!-- Products -->
<script>
 function AllProduct(customer){


     $.ajax({
      url:'CustomerFollowProductsFilter',
      method:'GET',
      data:{customer:customer},
      dataType:'json',
      success:function(data)
      {
       $('.ProductsShow').html(data.table_data);
                    
      }
     })
    



 }

</script>


<!-- Sales Order -->
<script>
 function AllSalesOrder(customer){


     $.ajax({
      url:'CustomerFollowSalesOrderShowFilter',
      method:'GET',
      data:{customer:customer},
      dataType:'json',
      success:function(data)
      {
       $('.SalesOrderShow').html(data.table_data);
                    
      }
     })
    



 }

</script>


<!-- Sales  -->
<script>
 function AllSales(customer){


     $.ajax({
      url:'CustomerFollowSalesShowFilter',
      method:'GET',
      data:{customer:customer},
      dataType:'json',
      success:function(data)
      {
       $('.SalesShow').html(data.table_data);
                    
      }
     })
    



 }

</script>



@endpush

