@extends('admin.index')
@section('content')

  <title>{{trans('admin.City')}}</title>

    <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.CRM')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('admin.City')}}</li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

                    <div class="row text-center">






                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                         <span class="fw-300"><i>{{trans('admin.City')}}</i></span>
                                    </h2>



                                    <div class="panel-toolbar">
                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg">{{trans('admin.AddNew')}}</button>
                                        <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>
                                        @include('admin.layouts.toolbar')
                                    </div>

                                </div>

                                <div class="col-xl-12 text-center" style="padding: 5px;font-size: 25px;">

                                    <h1 class="text-center">  {{app()->getLocale() == 'ar' ?$Gov->Arabic_Name :$Gov->English_Name}}</h1>

                                </div>
                                <div class="panel-container show">
                                   <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">
                                        <!-- datatable start -->
                                        <table id="dt-basic-example"
                                            class="table table-bordered table-hover table-striped w-100">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.ShippingCode')}} </th>
                                                    <th>{{trans('admin.Arabic_Name')}} </th>
                                                    <th>{{trans('admin.English_Name')}}</th>
                                                    <th>{{trans('admin.Ship_Price')}}</th>
                                                    <th>{{trans('admin.Shipping_Company')}}</th>
                                                    <th>{{trans('admin.Places')}}</th>
                                                    <th>{{trans('admin.SearchCode')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>

                                                </tr>
                                            </thead>
                                            <tbody>

                                            @foreach($items as $item)
                                                <tr>
                                                    <td>{{$item->ShippingCode}} </td>
                                                    <td>{{$item->Arabic_Name}} ( {{$item->id}} )</td>
                                                    <td>{{$item->English_Name}}</td>
                                                    <td>{{$item->Ship_Price}}</td>

                                                    <td>
                                                    @if(!empty($item->Shipping_Company()->first()->Name))


                                             {{app()->getLocale() == 'ar' ?$item->Shipping_Company()->first()->Name :$item->Shipping_Company()->first()->NameEn}}
                                                    @endif
                                                    </td>
                                                   <td>
               <a  class="btn btn-default" href="{{url('Places/'.$item->id)}}">{{trans('admin.Places')}}</a>
                                                    </td>

                                                           <td>{{$item->SearchCode}}</td>
                                                    <td class="text-center">
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>
                                                    </td>
                                                </tr>
                                             @endforeach


                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>{{trans('admin.ShippingCode')}} </th>
                                                            <th>{{trans('admin.Arabic_Name')}}</th>
                                                    <th>{{trans('admin.English_Name')}}</th>
                                                    <th>{{trans('admin.Ship_Price')}}</th>
                                                    <th>{{trans('admin.Shipping_Company')}}</th>
                                                    <th>{{trans('admin.Places')}}</th>
                                                    <th>{{trans('admin.SearchCode')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>

                                                </tr>
                                            </tfoot>
                                        </table>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Modal Add-->
               <div class="modal fade" id="default-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.AddNew')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{url('AddCity')}}" method="post">
                                        {!! csrf_field() !!}
                                              @honeypot
                                        <input type="hidden" name="Gov" value="{{$Gov->id}}">
                                        <div class="form-row">
                                        <div class="form-group col-lg-12">
                                            <label class="form-label" for="simpleinput">{{trans('admin.ShippingCode')}}</label>
                                            <input type="number" name="ShippingCode" value="{{old('ShippingCode')}}"  class="form-control" required>
                                        </div>

                                            <div class="form-group col-lg-6">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Arabic_Name')}}</label>
                                            <input type="text" name="Arabic_Name" value="{{old('Arabic_Name')}}"  class="form-control" required>
                                        </div>
                                        <div class="form-group col-lg-6">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.English_Name')}}</label>
                         <input type="text" name="English_Name"  value="{{old('English_Name')}}" class="form-control" >
                                        </div>
                                             <div class="form-group col-lg-6">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.Ship_Price')}}</label>
                         <input type="number" step="any" name="Ship_Price"  value="{{old('Ship_Price')}}" class="form-control" >
                                        </div>
                                             <div class="form-group col-lg-6">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.Shipping_Company')}}</label>
                 <select class="select2 form-control" name="Shipping_Company">
                                <option value="">{{trans('admin.Shipping_Company')}}</option>
                     @foreach($Shippings as $ship)
                     <option value="{{$ship->id}}">
                      {{app()->getLocale() == 'ar' ?$ship->Name :$ship->NameEn}}
                     </option>
                    @endforeach
                                                 </select>
                                        </div>

                                                       <div class="form-group col-lg-6">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.SearchCode')}}</label>
                         <input type="text" name="SearchCode"  value="{{old('SearchCode')}}" class="form-control" >
                                        </div>
                                        </div>
                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>



         @foreach($items as $item)
        <!-- Modal Edit-->
                    <div class="modal fade" id="default-example-modal-lg-edit{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.Edit')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{url('EditCity/'.$item->id)}}" method="post">
                                        {!! csrf_field() !!}
                                              @honeypot
                                     <input type="hidden" name="Gov" value="{{$Gov->id}}">
                                        <div class="form-row">
                                            <div class="form-group col-lg-12">
                                                <label class="form-label" for="simpleinput">{{trans('admin.ShippingCode')}}</label>
                                                <input type="number" name="ShippingCode" value="{{old('ShippingCode')}}"  class="form-control" required>
                                            </div>


                                            <div class="form-group col-lg-6">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Arabic_Name')}}</label>
                                            <input type="text" name="Arabic_Name" value="{{$item->Arabic_Name}}"  class="form-control" required>
                                        </div>
                                        <div class="form-group col-lg-6">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.English_Name')}}</label>
                          <input type="text" name="English_Name"  value="{{$item->English_Name}}" class="form-control" >
                                        </div>
                                                 <div class="form-group col-lg-6">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.Ship_Price')}}</label>
                         <input type="number" step="any" name="Ship_Price"  value="{{$item->Ship_Price}}" class="form-control" >
                                        </div>
                                             <div class="form-group col-lg-6">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.Shipping_Company')}}</label>
                 <select class="select2 form-control" name="Shipping_Company">
                                <option value="">{{trans('admin.Shipping_Company')}}</option>
                     @foreach($Shippings as $ship)
                     <option value="{{$ship->id}}" @if($ship->id == $item->Shipping_Company) selected @endif>
                         {{app()->getLocale() == 'ar' ?$ship->Name :$ship->NameEn}}
                     </option>
                    @endforeach
                                                 </select>
                                        </div>


                                                    <div class="form-group col-lg-6">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.SearchCode')}}</label>
                         <input type="text" name="SearchCode"  value="{{$item->SearchCode}}" class="form-control" >
                                        </div>

                                        </div>
                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                      <!-- Modal Delete -->
                      <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                          {{trans('admin.RUSWDT')}} <strong>     {{app()->getLocale() == 'ar' ?$item->Arabic_Name :$item->English_Name}}</strong>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                   <a href="{{url('DeleteCity/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>
        @endforeach
                </main>

@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
   <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
@endpush

