@extends('admin.index')
@section('content')
@php
use App\Models\DefaultDataShowHide;
$show=DefaultDataShowHide::orderBy('id','desc')->first();
use App\Models\AccountsDefaultData;
$Def=AccountsDefaultData::orderBy('id','desc')->first();
@endphp
<title>{{trans('admin.Edit_Payment_Voucher')}}</title>


<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Accounts')}} </a></li>
        <li class="breadcrumb-item active">{{trans('admin.Edit_Payment_Voucher')}}</li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>
    <form action="{{url('PostEditPayment_Voucher')}}" method="post">
        {!! csrf_field() !!}
        @honeypot
        <div class="row">
            <div class="col-lg-12">
                <div id="panel-2" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i> {{trans('admin.Edit_Payment_Voucher')}} </i></span>
                        </h2>
                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <div class="form-row">
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                    <input type="text" name="Old_Code" value="{{$item->Code}}" class="form-control " readonly>
                                    <input type="hidden" name="Code" value="{{$Code}}">
                                    <input type="hidden" name="ID" value="{{$item->id}}">
                                </div>
                                @if(auth()->guard('admin')->user()->emp == 0)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required>
                                </div>
                                @else

                                @if(auth()->guard('admin')->user()->Date == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required>
                                </div>
                                @else
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required readonly>
                                </div>
                                @endif

                                @endif
                                <div class="form-group col-lg-3" @if($Def->Coin_Show == 0) style="display: none" @endif>
                                    <label class="form-label" for="">{{trans('admin.Currency')}}</label>
                                    <select class="select2 form-control w-100" name="Coin" required>
                                        <option value="">{{trans('admin.Currency')}}</option>
                                        @foreach($Coins as $coin)
                                        <option value="{{$coin->id}}" @if($item->Coin == $coin->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-lg-2" @if($Def->Draw_Show == 0) style="display: none" @endif>
                                    <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                    <input type="number" step="any" name="Draw" value="{{$item->Draw}}" class="form-control" required>
                                </div>
                                <div class="form-group col-lg-3" @if($Def->Cost_Show == 0) style="display: none" @endif>
                                    <label class="form-label" for="">{{trans('admin.Cost_Center')}}</label>
                                    <select class="select2 form-control w-100" name="Cost_Center">
                                        <option value="">{{trans('admin.Cost_Center')}}</option>
                                        @foreach($CostCenters as $cost)
                                        <option value="{{$cost->id}}" @if($item->Cost_Center == $cost->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="">{{trans('admin.Responsiple')}}</label>
                                <select class="select2 form-control w-100" name="Responsiple">
                                    <option value="">{{trans('admin.Responsiple')}}</option>
                                    @foreach($Emps as $emp)
                                        <option value="{{$emp->id}}" @if($item->Responsiple == $emp->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                        </option>
                                    @endforeach
                                </select>
                            </div>


                            <input type="hidden" name="Files" value="{{$item->File}}">
                            @if($show->Show_File_PaymentVoucher == 1)
                            <div class="form-group col-lg-12">
                                <label class="form-label" for="simpleinput">{{trans('admin.File')}}</label>
                                <input type="file" name="File" class="form-control">
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">

                    <div class="panel-container show">
                        <div class="panel-content">
                            <table class="table table-bordered table-hover table-striped w-100">
                                <thead>
                                    <tr>

                                        <th> {{trans('admin.Debitor')}}</th>
                                        <th> {{trans('admin.Account_Name')}}</th>
                                        @if($Def->Sales_Bill_Show == 1)
                                            <th>{{trans('admin.Bill_Num')}}</th>
                                        @endif

                                        @if($Def->Order_Number == 1)
                                            <th>{{trans('admin.Order_Number')}}</th>
                                        @endif
                                        @if($Def->Tax_Show == 1)
                                            <th>{{trans('admin.Tax')}}</th>
                                        @endif

                                                                 @if($Def->Cost_Center_Show == 1)
                                                <th>{{trans('admin.Cost_Center')}}</th>
                                            @endif


                                        <th>{{trans('admin.Statement')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>

                                        <td>
                                            <div class="form-group">

                                                <div class="form-group">
                                                    <input onkeyup="PLUS()" type="number" step="any" id="debit" class="form-control">
                                                </div>
                                            </div>
                                        </td>

                                        <td>
                                            <div class="form-group">
                                                <select onchange="PLUS()" class="select2 form-control w-100" id="AccountCode">
                                                    <option value="">{{trans('admin.Account')}}</option>
                                        
                                                </select>

                                                <input type="hidden" id="AccountName" class="form-control">
                                                <input type="hidden" id="AccCode" class="form-control">
                                                <input type="hidden" id="AccID" class="form-control">
                                            </div>
                                        </td>

                                        @if($Def->Sales_Bill_Show == 1)
                                            <td>
                                                <input type="text" id="Bill_Num"  class="form-control ">

                                            </td>
                                        @else
                                            <input type="hidden" id="Bill_Num"  class="form-control " disabled>
                                        @endif

                                        @if($Def->Order_Number == 1)
                                            <td>
                                                <input type="text" id="Order_Number"  class="form-control ">

                                            </td>
                                        @else
                                            <input type="hidden" id="Order_Number"  class="form-control " disabled>
                                        @endif

                                        @if($Def->Tax_Show == 1)
                                            <td>
                                                <div class="form-group">
                                                    <select onchange="PLUS()" class="select2 form-control w-100" id="Tax">
                                                        @foreach($Tax as $tax)
                                                            <option value="{{$tax->id}}">

                                                                {{app()->getLocale() == 'ar' ?$tax->Name :$tax->NameEn}}
                                                            </option>
                                                        @endforeach
                                                    </select>

                                                </div>
                                            </td>
                                        @else
                                            <input type="hidden" id="Tax"  class="form-control ">

                                        @endif
                                        
                                        
                                                @if($Def->Cost_Center_Show == 1)
                                            <td>
                                                <div class="form-group">
                                                    <select onchange="PLUS()" class="select2 form-control w-100" id="CostCenter">
                                                             @foreach($CostCenters as $cost)
                                        <option value="{{$cost->id}}">
                                            {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                        </option>
                                        @endforeach
                                                    </select>

                                                </div>
                                            </td>
                                            @else
                                                <input type="hidden" id="CostCenter"  class="form-control ">

                                            @endif




                                        <td>
                                            <div class="form-group">
                                                <input type="text" onkeyup="PLUS()" id="statement" class="form-control">
                                            </div>

                                        </td>
                                        <td>
                                            <button type="button" onclick="Insert()" class="btn btn-default" id="add-data" style="display: none"><i class="fal fa-plus"></i></button>
                                        </td>

                                    </tr>
                                </tbody>
                            </table>
                            <!-- datatable start -->
                            <table id="dt-basic-example" class="table table-bordered table-hover table-striped w-100">
                                <thead>
                                    <tr>

                                        <th>{{trans('admin.Debitor')}}</th>
                                        <th>{{trans('admin.Account_Code')}}</th>
                                        <th>{{trans('admin.Account_Name')}}</th>
                                        @if($Def->Sales_Bill_Show == 1)
                                            <th>{{trans('admin.Bill_Num')}}</th>
                                        @endif
                                        @if($Def->Order_Number == 1)
                                            <th>{{trans('admin.Order_Number')}}</th>
                                        @endif
                                        @if($Def->Tax_Show == 1)
                                            <th>{{trans('admin.Tax')}}</th>
                                        @endif
                                                                 @if($Def->Cost_Center_Show == 1)
                                                <th>{{trans('admin.Cost_Center')}}</th>
                                            @endif



                                        <th>{{trans('admin.Statement')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>
                                    </tr>
                                </thead>
                                <tbody id="data-dt">

                                    @foreach($details as $det)
                                    <tr>
                                        <td class="TDeb">
                                            {{$det->Debitor}}
                                        </td>
                                        <td>

                                            @if(!empty($det->Account()->first()->Code))
                                            {{$det->Account()->first()->Code}}
                                            @endif


                                        </td>
                                        <td>

                                            @if(!empty($det->Account()->first()->Name))
                                            {{app()->getLocale() == 'ar' ?$det->Account()->first()->Name :$det->Account()->first()->NameEn}}
                                            @endif

                                        </td>
                                        @if($Def->Sales_Bill_Show == 1)
                                            <td>
                                                {{$det->Bill_Num}}
                                            </td>
                                        @endif
                                        @if($Def->Order_Number == 1)
                                            <td>
                                                {{$det->Order_Number}}
                                            </td>
                                        @endif

                                        @if($Def->Tax_Show == 1)
                                            <td>   @if(!empty($det->Tax()->first()->Name)) {{$det->Tax()->first()->Name}} @endif    </td>
                                        @endif

                                        @if($Def->Cost_Center_Show == 1)
                                            <td>   @if(!empty($det->Cost_Center()->first()->Arabic_Name)) {{$det->Cost_Center()->first()->Arabic_Name}} @endif    </td>
                                        @endif

                                        <td>
                                            {{$det->Statement}}
                                            <input type="hidden" name="Creditor[]" value="0">
                                            <input type="hidden" name="Debitor[]" value=" {{$det->Debitor}}">
                                            <input type="hidden" name="Account[]" value=" {{$det->Account}}">
                                            <input type="hidden" name="Statement[]" value="{{$det->Statement}}">
                                            <input type="hidden" name="Bill_Num[]" value="{{$det->Bill_Num}}">
                                            <input type="hidden" name="Order_Number[]" value="{{$det->Order_Number}}">
                                            <input type="hidden" name="Tax[]" value="{{$det->Tax}}">
                                            <input type="hidden" name="CostCenterTable[]" value="{{$det->Cost_Center}}">
                                        </td>
                                        <td>
                                            <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                        </td>

                                    </tr>

                                    @endforeach



                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>{{trans('admin.Debitor')}}</th>
                                        <th>{{trans('admin.Account_Code')}}</th>
                                        <th>{{trans('admin.Account_Name')}}</th>
                                        @if($Def->Sales_Bill_Show == 1)
                                            <th>{{trans('admin.Bill_Num')}}</th>
                                        @endif
                                        @if($Def->Order_Number == 1)
                                            <th>{{trans('admin.Order_Number')}}</th>
                                        @endif
                                        @if($Def->Tax_Show == 1)
                                            <th>{{trans('admin.Tax')}}</th>
                                        @endif


                                                                 @if($Def->Cost_Center_Show == 1)
                                                <th>{{trans('admin.Cost_Center')}}</th>
                                            @endif

                                        <th>{{trans('admin.Statement')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>
                                    </tr>
                                </tfoot>
                            </table>
                            <!-- datatable end -->
                            <div class="form-row">
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Total_Debitor')}}</label>
                                    <input type="text" id="totalDeb" disabled class="form-control">
                                    <input type="hidden" id="totalDebHide" name="Total_Debaitor" class="form-control">
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Notes')}}</label>
                                    <input type="text" name="Note" value="{{$item->Note}}" class="form-control">
                                </div>
                                <div class="form-group col-lg-4">
                                    <div style="width: 90%;display:inline-block;">
                                        <label class="form-label" for="">{{trans('admin.Safe')}} </label>
                                        <select class="js-data-example-ajax form-control w-100" id="Safe" onchange="safe()" name="Safe" required>
                                            <option value="{{$item->Safe}}" selected>{{$item->Safe()->first()->Name}}</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group col-lg-2">
                                    <label class="form-label"> {{trans('admin.Safe_Balance')}} </label>
                                    <button type="button" class="form-control btn btn-primary" id="SafeBalance">

                                    </button>
                                </div>
                            </div>
                            <div class="buttons mt-3">

                                <button type="submit" class="btn btn-primary"> <i class="fal fa-folder"></i> {{trans('admin.Save')}} </button>
                                <button type="button" class="btn btn-primary"><i class="fal fa-save"></i> {{trans('admin.SaveandPrint')}} </button>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</main>



<input type="hidden" id="Sales_Bill_Show" value="{{$Def->Sales_Bill_Show}}">
<input type="hidden" id="Order_Number_Show" value="{{$Def->Order_Number}}">
<input type="hidden" id="Tax_Def_Show" value="{{$Def->Tax_Show}}">
<input type="hidden" id="Cost_Center_Show" value="{{$Def->Cost_Center_Show}}">
<input type="hidden" id="RATE" value="0">
<input type="hidden" id="TYPE" value="0">
<input type="hidden" id="CODE" value="0">
<input type="hidden" id="NAME" value="0">
<input type="hidden" id="ACCOUNT" value="0">




@endsection

@push('js')

<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>


<script>
    $(document).ready(function() {


        var sumR = 0;
        $('.TDeb').each(function() {
            sumR += parseFloat($(this).text());
        });



        $('#totalDeb').val(sumR);
        $('#totalDebHide').val(sumR);





    });

</script>

<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function() {
        interval = setInterval(function() {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function() {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete
    var removeFromLocal = function() {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function() {
        //init default
        $('.js-summernote').summernote({
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks: {
                //restore from localStorage
                onInit: function(e) {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable) {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax({
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data) {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote({
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint: {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback) {
                    callback($.grep(emojis, function(item) {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item) {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item) {
                    var url = emojiUrls[item];
                    if (url) {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote({
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint: {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback) {
                    callback($.grep(this.mentions, function(item) {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item) {
                    return '@' + item;
                }
            }
        });

    });

</script>


<script>
    function Insert() {
        var debit = document.getElementById('debit').value;
        var accountCode = document.getElementById('AccCode').value;
        var accountID = document.getElementById('AccID').value;
        var accountName = document.getElementById('AccountName').value;
        var statement = document.getElementById('statement').value;
        var Sales_Bill_Show = document.getElementById('Sales_Bill_Show').value;
        var Bill_Num = document.getElementById('Bill_Num').value;
        var Tax = document.getElementById('Tax').value;
        var TaxName = $("#Tax option:selected").text();
        var CostCenter = document.getElementById('CostCenter').value;
        var CostCenterName = $("#CostCenter option:selected").text();

        var Order_Number_Show = document.getElementById('Order_Number_Show').value;
        var Order_Number = document.getElementById('Order_Number').value;
        var Tax_Def_Show = document.getElementById('Tax_Def_Show').value;
        var Cost_Center_Show = document.getElementById('Cost_Center_Show').value;

        
        


            if(parseFloat(Sales_Bill_Show) == 1){

            var show=` <td>${Bill_Num}</td> ` ;
        }else{
            var show=   ` ` ;
        }

        if(parseFloat(Order_Number_Show) == 1){

            var showOrder=` <td>${Order_Number}</td> ` ;
        }else{
            var showOrder=   ` ` ;
        }


        if(parseFloat(Tax_Def_Show) == 1){

            var showTax=` <td>${TaxName}</td> ` ;
        }else{
            var showTax=   ` ` ;
        }


        if(parseFloat(Cost_Center_Show) == 1){

            var showCost=` <td>${CostCenterName}</td> ` ;
        }else{
            var showCost=   ` ` ;
        }



        var table = ` <tr>
                                <td class="TDeb">
                            ${debit}

                                </td>

                                <td>${accountCode}</td>
                                <td>${accountName}</td>
                                   ${show}
                                    ${showOrder}
                                    ${showTax}
                                    ${showCost}
                                <td>${statement}
                <input type="hidden" name="Creditor[]" value="0">
                <input type="hidden" name="Debitor[]" value="${debit}">
    <input type="hidden" name="Account[]" value="${accountID}">
    <input type="hidden" name="Statement[]" value="${statement}">
 <input type="hidden" name="Bill_Num[]" value="${Bill_Num}">
 <input type="hidden" name="Order_Number[]" value="${Order_Number}">
 <input type="hidden" name="Tax[]" value="${Tax}">
 <input type="hidden" name="CostCenterTable[]" value="${CostCenter}">
                                 </td>
                                <td>
                    <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>




                             </tr>`;



        if(parseFloat(Tax_Def_Show) == 1) {

            var RATE=$('#RATE').val();
            var TYPE=$('#TYPE').val();
            var CODE=$('#CODE').val()
            var NAME=$('#NAME').val();
            var ACCOUNT=$('#ACCOUNT').val();

            if(TYPE == 2){
                var NewDebit=RATE ;
            }else{
                var NewDebit= debit *  (RATE/100) ;
            }


            var tableX = ` <tr>
                                <td class="TDeb">
                            ${NewDebit}

                                </td>

                                <td>${CODE}</td>
                                <td>${NAME}</td>
                                   ${show}
                                    ${showOrder}
                                    ${showTax}
                                        ${showCost}
                                <td>${statement}
                <input type="hidden" name="Creditor[]" value="0">
                <input type="hidden" name="Debitor[]" value="${NewDebit}">
    <input type="hidden" name="Account[]" value="${ACCOUNT}">
    <input type="hidden" name="Statement[]" value="${statement}">
 <input type="hidden" name="Bill_Num[]" value="${Bill_Num}">
 <input type="hidden" name="Order_Number[]" value="${Order_Number}">
 <input type="hidden" name="Tax[]" value="${Tax}">
 <input type="hidden" name="CostCenterTable[]" value="${CostCenter}">
                                 </td>
                                <td>
                    <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>




                             </tr>`;

        }

        if (accountCode != '' && accountName != '') {
            document.getElementById('data-dt').innerHTML += table;


            if(parseFloat(Tax_Def_Show) == 1) {

                if(NewDebit != 0){
                    document.getElementById('data-dt').innerHTML += tableX;
                }

            }


            $('#debit').val('');
            $('#AccountCode').val('');
            document.getElementById("add-data").style.display = "none";
        }

        var sumR = 0;
        $('.TDeb').each(function() {
            sumR += parseFloat($(this).text());
        });



        $('#totalDeb').val(sumR);
        $('#totalDebHide').val(sumR);

        var safee = $('#Safe').val();


        if (safee != null && sumR != 0) {
            document.getElementById("SHOW").style.display = "block";
        } else {

            document.getElementById("SHOW").style.display = "none";
        }




        $('#dt-basic-example #data-dt').on('click', '#Del', function(e) {
            $(this).closest('tr').remove();



            var sumR = 0;
            $('.TDeb').each(function() {
                sumR += parseFloat($(this).text());
            });



            $('#totalDeb').val(sumR);
            $('#totalDebHide').val(sumR);



            var safee = $('#Safe').val();


            if (safee != '' && sumR != 0) {
                document.getElementById("SHOW").style.display = "block";
            } else {

                document.getElementById("SHOW").style.display = "none";
            }



        })





    }

</script>

<script>
    $(document).ready(function() {

        $('#AccountCode').on('change', function() {
            var countryId = $(this).val();
            if (countryId) {
                $.ajax({
                    url: 'AccountNameFilter/' + countryId,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function() {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function(data) {
                        $.each(data, function(key, value) {

                            $('#AccCode').val(data.code);
                            $('#AccountName').val(data.name);
                            $('#AccID').val(data.ID);
                        });
                    },
                    complete: function() {
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="state"]').empty();
            }

        });

    });

</script>


<script>
    function PLUS() {

        var Dept = $('#debit').val();
        var Code = $('#AccountCode').val();

        var Tax_Def_Show = document.getElementById('Tax_Def_Show').value;
        if(parseFloat(Tax_Def_Show) == 1) {
            var Tax = document.getElementById('Tax').value;
            $.ajax({
                url: 'TaxNamePurchasesFilter/' + Tax,
                type: "GET",
                dataType: "json",
                beforeSend: function () {
                    $('#loader').css("visibility", "visible");
                },

                success: function (data) {


                    $('#RATE').val(data.rate);
                    $('#TYPE').val(data.type);
                    $('#CODE').val(data.AccountCode);
                    $('#NAME').val(data.AccountName);
                    $('#ACCOUNT').val(data.Account);


                },
                complete: function () {
                    $('#loader').css("visibility", "hidden");
                }
            });

        }



        if (Dept != '' && Code != null) {

            if (parseFloat(Dept) <= 0) {

                document.getElementById("add-data").style.display = "none";

            } else {

                document.getElementById("add-data").style.display = "block";

            }

        } else {

            document.getElementById("add-data").style.display = "none";

        }




    }

</script>

<script>
    $('#dt-basic-example #data-dt').on('click', '#Del', function(e) {
        $(this).closest('tr').remove();



        var sumR = 0;
        $('.TDeb').each(function() {
            sumR += parseFloat($(this).text());
        });



        $('#totalDeb').val(sumR);
        $('#totalDebHide').val(sumR);







    })

</script>


<script>
    $(document).ready(function() {

        $('#Safe').on('change', function() {
            var countryId = $(this).val();
            if (countryId) {
                $.ajax({
                    url: 'SafeBalanceFilter/' + countryId,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function() {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function(data) {
                        $.each(data, function(key, value) {


                            $('#SafeBalance').text(key);
                            $('#SafeBalance').text(value);
                        });
                    },
                    complete: function() {
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="state"]').empty();
            }

        });

    });

    $(document).ready(function() {

        var countryId = $('#Safe').val();
        if (countryId) {
            $.ajax({
                url: 'SafeBalanceFilter/' + countryId,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {
                    $.each(data, function(key, value) {


                        $('#SafeBalance').text(key);
                        $('#SafeBalance').text(value);
                    });
                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {

            $('select[name="state"]').empty();
        }



    });

</script>

<!-- Submit Script -->
<script>
    function safe() {


        var sumR = 0;
        $('.TDeb').each(function() {
            sumR += parseFloat($(this).text());
        });


        var safee = $('#Safe').val();


        if (safee != null && sumR != 0) {
            document.getElementById("SHOW").style.display = "block";
        } else {

            document.getElementById("SHOW").style.display = "none";
        }

    }

</script>


@if(auth()->guard('admin')->user()->emp != 0)
@if($Def->Emp_Vouchers_Accounts == 1)
<!-- Search Selecet -->
<script>
    $(document).ready(function() {
        $(function() {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State"
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm
                }
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }





            $('#Safe').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllSafes',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllSafesJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Safe').empty();
                                $.each(data, function(key, value) {

                                    $('#Safe').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('#Safe').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });

            
            
           
            $('#AccountCode').select2({
    placeholder: "اختار...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllSubAccountsSpecificEmpPay',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});

  


        });
    });

</script>
@else
<!-- Search Selecet -->
<script>
    $(document).ready(function() {
        $(function() {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State"
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm
                }
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }





            $('#Safe').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllSafes',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllSafesJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Safe').empty();
                                $.each(data, function(key, value) {

                                    $('#Safe').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('#Safe').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });

            
            
           
            $('#AccountCode').select2({
    placeholder: "اختار...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllSubAccounts',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});

  


        });
    });

</script>
@endif

@else

<!-- Search Selecet -->
<script>
    $(document).ready(function() {
        $(function() {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State"
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm
                }
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }





            $('#Safe').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllSafes',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllSafesJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Safe').empty();
                                $.each(data, function(key, value) {

                                    $('#Safe').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('#Safe').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });

            
            
           
            $('#AccountCode').select2({
    placeholder: "اختار...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllSubAccounts',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});

  


        });
    });

</script>
@endif


<script>
    $('#dt-basic-example #data-dt').on('click', '#Del', function(e) {
        $(this).closest('tr').remove();



        var sumR = 0;
        $('.TDeb').each(function() {
            sumR += parseFloat($(this).text());
        });



        $('#totalDeb').val(sumR);
        $('#totalDebHide').val(sumR);







    })

</script>

@endpush
