@extends('admin.index')
@section('content')
@php
use App\Models\AccountsDefaultData;
$Def=AccountsDefaultData::orderBy('id','desc')->first();
@endphp
<title>{{trans('admin.Edit_Journalizing')}}</title>


<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Sechdules')}} </a></li>
        <li class="breadcrumb-item active">{{trans('admin.Edit_Journalizing')}} </li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>
    <form action="{{url('PostEditJournalizing')}}" method="post">
        {!! csrf_field() !!}
        @honeypot
        <div class="row">
            <div class="col-lg-12">
                <div id="panel-2" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i> {{trans('admin.Edit_Journalizing')}} </i></span>
                        </h2>
                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <div class="form-row">
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                    <input type="text" name="Old_Code" value="{{$item->Code}}" class="form-control " readonly>
                                    <input type="hidden" name="Code" value="{{$Code}}">
                                    <input type="hidden" name="ID" value="{{$item->id}}">
                                </div>

                                @if(auth()->guard('admin')->user()->emp == 0)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required>
                                </div>
                                @else

                                @if(auth()->guard('admin')->user()->Date == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required>
                                </div>
                                @else
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required readonly>
                                </div>
                                @endif

                                @endif

                                <div class="form-group col-lg-3" @if($Def->Coin_Show == 0) style="display: none" @endif>
                                    <label class="form-label" for="">{{trans('admin.Currency')}}</label>
                                    <select class="select2 form-control w-100" name="Coin" id="CoinSelect" required>
                                        <option value="">{{trans('admin.Currency')}}</option>
                                         @if(!empty($item->Coin()->first()->Arabic_Name))            
                                  <option value="{{$item->Coin}}"  selected >
                       {{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}        
                                                </option>
                                                @endif
                                    </select>
                                </div>
                                <div class="form-group col-lg-2" @if($Def->Draw_Show == 0) style="display: none" @endif>
                                    <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                    <input type="number" step="any" name="Draw" value="{{$item->Draw}}" class="form-control" required>
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="">{{trans('admin.Branch')}}</label>
                                    <select class="select2 form-control w-100" name="Branch" id="BranchSelect">
                                        <option value=""> {{trans('admin.Branch')}}</option>
                                       @if(!empty($item->Branch()->first()->Arabic_Name))            
                                  <option value="{{$item->Branch}}"  selected >
                       {{app()->getLocale() == 'ar' ?$item->Branch()->first()->Arabic_Name :$item->Branch()->first()->English_Name}}        
                                                </option>
                                                @endif
                                           
                                    </select>
                                </div>
                                <div class="form-group col-lg-3" @if($Def->Cost_Show == 0) style="display: none" @endif>
                                    <label class="form-label" for="">{{trans('admin.Cost_Center')}}</label>
                                    <select class="select2 form-control w-100" name="Cost_Center" id="CostCenterSelect">
                                        <option value="">{{trans('admin.Cost_Center')}}</option>
                                 
                                          @if(!empty($item->Cost_Center()->first()->Arabic_Name))            
                                  <option value="{{$item->Cost_Center}}"  selected >
                       {{app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name}}        
                                                </option>
                                                @endif
                                           
                                        
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-container show">
                        <div class="panel-content">
                            <table class="table table-bordered table-hover table-striped w-100">
                                <thead>
                                    <tr>
                                        <th> {{trans('admin.Debitor')}}</th>
                                        <th> {{trans('admin.Creditor')}}</th>
                                        <th> {{trans('admin.Account_Name')}}</th>
                                        <th>{{trans('admin.Statement')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <div class="form-group">
                                                <input onkeyup="PLUS()" type="number" step="any" id="debit" class="form-control">
                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input onkeyup="PLUS()" type="number" step="any" id="creditor" class="form-control">
                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <select onchange="PLUS()" class="select2 form-control w-100" id="AccountCode">
                                                    <option value="">{{trans('admin.Account')}}</option>
                                            
                                                </select>
                                                <input type="hidden" id="AccountName" class="form-control">
                                                <input type="hidden" id="AccID" class="form-control">
                                                <input type="hidden" id="AccCode" class="form-control">
                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input type="text" onkeyup="PLUS()" id="statement" class="form-control">
                                            </div>
                                        </td>
                                        <td>
                                            <button type="button" onclick="Insert()" class="btn btn-default" id="add-data" style="display: none"><i class="fal fa-plus"></i></button>
                                        </td>

                                    </tr>
                                </tbody>
                            </table>
                            <!-- datatable start -->
                            <table id="dt-basic-example" class="table table-bordered table-hover table-striped w-100">
                                <thead>
                                    <tr>
                                        <th>{{trans('admin.Debitor')}}</th>
                                        <th>{{trans('admin.Creditor')}}</th>
                                        <th>{{trans('admin.Account_Code')}}</th>
                                        <th>{{trans('admin.Account_Name')}}</th>
                                        <th>{{trans('admin.Statement')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>
                                    </tr>
                                </thead>
                                <tbody id="data-dt">
                                    @foreach($details as $det)
                                    <tr>
                                        <td class="TDeb">
                                            {{$det->Debitor}}
                                        </td>
                                        <td class="TCred">
                                            {{$det->Creditor}}
                                        </td>
                                        <td>

                                            @if(!empty($det->Account()->first()->Code))
                                            {{$det->Account()->first()->Code}}
                                            @endif
                                        </td>
                                        <td>

                                            @if(!empty($det->Account()->first()->Name))
                                            {{app()->getLocale() == 'ar' ?$det->Account()->first()->Name :$det->Account()->first()->NameEn}}
                                            @endif

                                        </td>
                                        <td>
                                            {{$det->Statement}}
                                            <input type="hidden" name="Debitor[]" value=" {{$det->Debitor}}">
                                            <input type="hidden" name="Creditor[]" value=" {{$det->Creditor}}">
                                            <input type="hidden" name="Account[]" value=" {{$det->Account}}">
                                            <input type="hidden" name="Statement[]" value="{{$det->Statement}}">
                                        </td>
                                        <td>
                                            <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                        </td>

                                    </tr>

                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>{{trans('admin.Debitor')}}</th>
                                        <th>{{trans('admin.Creditor')}}</th>
                                        <th>{{trans('admin.Account_Code')}}</th>
                                        <th>{{trans('admin.Account_Name')}}</th>
                                        <th>{{trans('admin.Statement')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>
                                    </tr>
                                </tfoot>
                            </table>
                            <!-- datatable end -->
                            <div class="form-row">
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Total_Debitor')}}</label>
                                    <input type="text" id="totalDeb" disabled class="form-control">
                                    <input type="hidden" id="totalDebHide" name="Total_Debaitor" class="form-control">
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Total_Creditor')}}</label>
                                    <input type="text" id="totalCred" disabled class="form-control">
                                    <input type="hidden" id="totalCredHide" name="Total_Creditor" class="form-control">

                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Differnence')}} </label>
                                    <input type="text" id="Differnence" disabled class="form-control">
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Notes')}}</label>
                                    <input type="text" name="Note" value="{{$item->Note}}" class="form-control">
                                </div>

                            </div>
                            <div class="buttons mt-3" id="SHOW" style="display: none">
                                <button type="submit" class="btn btn-primary"> <i class="fal fa-folder"></i> {{trans('admin.Save')}} </button>
                                <button type="button" class="btn btn-primary"><i class="fal fa-save"></i> {{trans('admin.SaveandPrint')}} </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>



        </div>
    </form>
    <div class="row">

    </div>

</main>




@endsection


@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>


<script>
    $(document).ready(function() {
        var sumR = 0;
        $('.TDeb').each(function() {
            sumR += parseFloat($(this).text());
        });

        var sum = 0;
        $('.TCred').each(function() {
            sum += parseFloat($(this).text());
        });

        $('#totalDeb').val(sumR);
        $('#totalDebHide').val(sumR);
        $('#totalCred').val(sum);
        $('#totalCredHide').val(sum);

        var Dif = parseFloat(sumR) - parseFloat(sum);
        $('#Differnence').val(Dif);


        if (Dif == 0) {

            document.getElementById("SHOW").style.display = "block";
        } else {

            document.getElementById("SHOW").style.display = "none";

        }
    });

</script>



<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function() {
        interval = setInterval(function() {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function() {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete 
    var removeFromLocal = function() {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function() {
        //init default
        $('.js-summernote').summernote({
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks: {
                //restore from localStorage
                onInit: function(e) {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable) {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax({
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data) {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote({
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint: {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback) {
                    callback($.grep(emojis, function(item) {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item) {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item) {
                    var url = emojiUrls[item];
                    if (url) {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote({
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint: {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback) {
                    callback($.grep(this.mentions, function(item) {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item) {
                    return '@' + item;
                }
            }
        });

    });

</script>



<script>
    function Insert() {
        var debit = document.getElementById('debit').value;
        var creditor = document.getElementById('creditor').value;
        var accountCode = document.getElementById('AccCode').value;
        var accountID = document.getElementById('AccID').value;
        var accountName = document.getElementById('AccountName').value;
        var statement = document.getElementById('statement').value;

        var table = ` <tr> 
                                <td class="TDeb">
                            ${debit}

                                </td>
                                <td class="TCred">
                                ${creditor}
                               </td>
                                <td>${accountCode}</td>
                                <td>${accountName}</td>
                                <td>${statement}
                <input type="hidden" name="Debitor[]" value="${debit}">
    <input type="hidden" name="Creditor[]" value="${creditor}">
    <input type="hidden" name="Account[]" value="${accountID}">
    <input type="hidden" name="Statement[]" value="${statement}">
                                 </td>
                                <td>
                    <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>




                             </tr>`;
        document.getElementById('data-dt').innerHTML += table;


        $('#debit').val('');
        $('#creditor').val('');
        $('#AccountCode').val('');
        document.getElementById("add-data").style.display = "none";


        var sumR = 0;
        $('.TDeb').each(function() {
            sumR += parseFloat($(this).text());
        });

        var sum = 0;
        $('.TCred').each(function() {
            sum += parseFloat($(this).text());
        });

        $('#totalDeb').val(parseFloat(sumR).toFixed(2));
        $('#totalDebHide').val(parseFloat(sumR).toFixed(2));
        $('#totalCred').val(parseFloat(sum).toFixed(2));
        $('#totalCredHide').val(parseFloat(sum).toFixed(2));

        var Dif = parseFloat(sumR) - parseFloat(sum);
        $('#Differnence').val(parseFloat(Dif).toFixed(2));


        if (parseFloat(sumR).toFixed(2) == parseFloat(sum).toFixed(2)) {

            document.getElementById("SHOW").style.display = "block";
        } else {

            document.getElementById("SHOW").style.display = "none";

        }



        $('#dt-basic-example #data-dt').on('click', '#Del', function(e) {
            $(this).closest('tr').remove();



            var sumR = 0;
            $('.TDeb').each(function() {
                sumR += parseFloat($(this).text());
            });

            var sum = 0;
            $('.TCred').each(function() {
                sum += parseFloat($(this).text());
            });

            $('#totalDeb').val(parseFloat(sumR).toFixed(2));
            $('#totalDebHide').val(parseFloat(sumR).toFixed(2));
            $('#totalCred').val(parseFloat(sum).toFixed(2));
            $('#totalCredHide').val(parseFloat(sum).toFixed(2));

            var Dif = parseFloat(sumR) - parseFloat(sum);
            $('#Differnence').val(parseFloat(Dif).toFixed(2));


            if (parseFloat(sumR).toFixed(2) == parseFloat(sum).toFixed(2)) {

                document.getElementById("SHOW").style.display = "block";
            } else {

                document.getElementById("SHOW").style.display = "none";

            }





        })





    }

</script>


<script>
    $('#dt-basic-example #data-dt').on('click', '#Del', function(e) {
        $(this).closest('tr').remove();



        var sumR = 0;
        $('.TDeb').each(function() {
            sumR += parseFloat($(this).text());
        });

        var sum = 0;
        $('.TCred').each(function() {
            sum += parseFloat($(this).text());
        });

        $('#totalDeb').val(parseFloat(sumR).toFixed(2));
        $('#totalDebHide').val(parseFloat(sumR).toFixed(2));
        $('#totalCred').val(parseFloat(sum).toFixed(2));
        $('#totalCredHide').val(parseFloat(sum).toFixed(2));

        var Dif = parseFloat(sumR) - parseFloat(sum);
        $('#Differnence').val(parseFloat(Dif).toFixed(2));


        if (parseFloat(sumR).toFixed(2) == parseFloat(sum).toFixed(2)) {

            document.getElementById("SHOW").style.display = "block";
        } else {

            document.getElementById("SHOW").style.display = "none";

        }





    })

</script>


<script>
    $(document).ready(function() {

        $('#AccountCode').on('change', function() {
            var countryId = $(this).val();
            if (countryId) {
                $.ajax({
                    url: 'AccountNameFilter/' + countryId,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function() {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function(data) {
                        $.each(data, function(key, value) {

                            $('#AccCode').val(data.code);
                            $('#AccountName').val(data.name);
                            $('#AccID').val(data.ID);
                        });
                    },
                    complete: function() {
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="state"]').empty();
            }

        });

    });

</script>

<script>
    function PLUS() {

        var Dept = $('#debit').val();
        var Credt = $('#creditor').val();
        var Code = $('#AccountCode').val();


        if (Dept != 0) {

            $('#creditor').val(0);
        }


        if (Credt != 0) {

            $('#debit').val(0);
        }


        if (Dept != '' && Credt != '' && Code != null) {


            if (Dept != 0 || Credt != 0) {
                document.getElementById("add-data").style.display = "none";
            }


            if (Dept == 0 && Credt == 0) {
                document.getElementById("add-data").style.display = "none";
            }

            if (Dept == 0 && Credt != 0) {
                document.getElementById("add-data").style.display = "block";
            }

            if (Dept != 0 && Credt == 0) {
                document.getElementById("add-data").style.display = "block";
            }


            if (parseFloat(Dept) < 0) {

                document.getElementById("add-data").style.display = "none";

            }

            if (parseFloat(Credt) < 0) {

                document.getElementById("add-data").style.display = "none";

            }


        } else {

            document.getElementById("add-data").style.display = "none";

        }

    }

</script>


<!-- Search Selecet -->
<script>
    $(document).ready(function() {
        $(function() {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State"
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm
                }
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }


        
            
            $('#CoinSelect').select2({
    placeholder: "اختار...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllCoins',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});

     
            $('#BranchSelect').select2({
    placeholder: "اختار...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllBranches',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});

 
            $('#AccountCode').select2({
    placeholder: "اختار...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllSubAccounts',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});

 
              
            $('#CostCenterSelect').select2({
    placeholder: "اختار...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllCostCenter',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});





        });
    });

</script>



@endpush
