@php
use App\Models\AcccountingManual;
use App\Models\AccountsDefaultData;
$Def=AccountsDefaultData::orderBy('id','desc')->first();
@endphp
<ul>
    @foreach($Childs as $child)
    <li>
        @if($child->Type == 0)
        <span class="label label-success"><i class="fal fa-plus-circle"></i>
            {{$child->Code}} - {{app()->getLocale() == 'ar' ?$child->Name :$child->NameEn}}
        </span>

        @can('حذف حساب في الدليل المحاسبي')
        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$child->id}}"><i class="fal fa-trash-alt"></i></button>
        @endcan

        @can('تعديل حساب في الدليل المحاسبي')
        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$child->id}}"><i class="fal fa-edit"></i></button>
        @endcan



        @php $Childs=AcccountingManual::orderBy('Code','asc')->where('Parent',$child->id)->limit(100)->get(); @endphp
        @include('admin.Accounts.Childs',['Childs' => $Childs,'Groups'=>$Groups])
        @else
        <span class="label label-success">
            {{$child->Code}} - {{app()->getLocale() == 'ar' ?$child->Name :$child->NameEn}}
        </span>

        @can('حذف حساب في الدليل المحاسبي')
        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$child->id}}"><i class="fal fa-trash-alt"></i></button>
        @endcan


        @can('تعديل حساب في الدليل المحاسبي')
        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$child->id}}"><i class="fal fa-edit"></i></button>
        @endcan

        @endif
    </li>
    <!-- Modal Edit-->
    <div class="modal fade" id="default-example-modal-lg-edit{{$child->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{trans('admin.Edit')}} </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="{{url('EditAccount')}}" method="post">
                        {!! csrf_field() !!}
                        @honeypot
                        <input type="hidden" name="ID" value="{{$child->id}}">
                        <div class="form-row">
                            <div class="form-group col-lg-12">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Arabic_Name')}} </label>
                                <input type="text" name="Name" value="{{$child->Name}}" id="simpleinput" class="form-control" required>
                            </div>

                            <div class="form-group col-md-12 col-12-print">
                                <label class="form-label" for="simpleinput">{{trans('admin.English_Name')}}</label>
                                <input type="text" name="NameEn" value="{{$child->NameEn}}" id="simpleinput" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-12">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Code')}} </label>
                                <input type="text" name="Account_Code" value="{{$child->Account_Code}}" id="simpleinput" class="form-control">
                            </div>
                            <div class="form-group col-md-12">
                                <label class="form-label" for="simpleinput">{{trans('admin.Notes')}}</label>
                                <input type="text" name="Note" id="simpleinput" class="form-control" value="{{$child->Note}}">
                            </div>
                            @if($Def->Show_Group == 1)
                            <div class="form-group col-md-12">
                                <label class="form-label" for="simpleinput">{{trans('admin.Group')}}</label>
                                <select class="select2 form-control" name="Pro_Group">
                                    <option value="">{{trans('admin.Group')}}</option>
                                    @foreach($Groups as $grop)

                                    <option value="{{$grop->id}}" @if($grop->id == $child->Pro_Group) selected @endif>{{$grop->Name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            @endif

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Name')}} </button>
                            <button type="submit" class="btn btn-primary">{{trans('admin.SaveChanges')}} </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Delete -->
    <div class="modal fade" id="default-example-modal-center{{$child->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.RUSWDT')}} <strong>{{app()->getLocale() == 'ar' ?$child->Name :$child->NameEn}}</strong>
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.No')}}</button>
                    <a href="{{url('DeleteAccount/'.$child->id)}}" class="btn btn-primary">{{trans('admin.Yes')}}</a>
                </div>
            </div>
        </div>
    </div>
    @endforeach
</ul>