@extends('admin.index')
@section('content')
@php
use App\Models\AccountsDefaultData;
$Def=AccountsDefaultData::orderBy('id','desc')->first();
@endphp
<title>{{trans('admin.Assets')}}</title>
<style>
/* خلفية المودال بتدرج ألوان */
.modal-content {
    border-radius: 15px;
    box-shadow: 0 15px 40px rgba(0,0,0,0.3);
    border: none;
    background: linear-gradient(145deg, #205952, #3d8a85, #6fb1aa);
    color: #fff;
    transition: all 0.3s ease;
}

/* تأثير hover على المودال */
.modal-content:hover {
    transform: translateY(-5px);
    box-shadow: 0 20px 50px rgba(0,0,0,0.4);
}

/* عنوان المودال */
.modal-header {
    background: linear-gradient(90deg, #205952, #3d8a85);
    color: #fff;
    border-bottom: none;
    border-top-left-radius: 15px;
    border-top-right-radius: 15px;
}

/* زر الإغلاق */
.modal-header .close {
    color: #fff;
    opacity: 1;
    font-size: 1.2rem;
}

/* Body inputs */
.modal-body .form-control, 
.modal-body .select2-container--default .select2-selection--single {
    border-radius: 10px;
    border: 1px solid #ced4da;
    box-shadow: inset 0 2px 5px rgba(0,0,0,0.05);
    transition: all 0.3s ease;
}

.modal-body .form-control:focus,
.modal-body .select2-container--default .select2-selection--single:focus {
    border-color: #205952;
    box-shadow: 0 0 8px rgba(32,89,82,0.5);
    outline: none;
}

/* أزرار المودال */
.modal-footer .btn-primary {
    background: linear-gradient(90deg, #205952, #3d8a85);
    border: none;
    border-radius: 10px;
    padding: 10px 25px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
    transition: all 0.3s ease;
    color: #fff;
}

.modal-footer .btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.3);
}

/* زر الغلق الثانوي */
.modal-footer .btn-secondary {
    border-radius: 10px;
    padding: 10px 25px;
    background-color: #e0f0ef;
    border: 1px solid #ccc;
    color: #205952;
    transition: all 0.3s ease;
}

.modal-footer .btn-secondary:hover {
    background-color: #c1e3df;
}

/* إضافة subtle animation لل inputs عند التركيز */
@keyframes inputFocus {
    0% { box-shadow: inset 0 2px 5px rgba(0,0,0,0.05);}
    50% { box-shadow: inset 0 2px 10px rgba(32,89,82,0.3);}
    100% { box-shadow: inset 0 2px 5px rgba(0,0,0,0.05);}
}

.modal-body .form-control:focus {
    animation: inputFocus 0.5s ease-in-out;
}

/* تحسين Select2 */
.select2-container--default .select2-selection--single {
    height: calc(2.5rem + 2px);
    padding: 0.375rem 0.75rem;
}
</style>
<!-- the #js-page-content id is needed for some plugins to initialize -->
<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb">
        <li class="breadcrumb-item">{{trans('admin.Accounts')}}</li>
        <li class="breadcrumb-item active"> {{trans('admin.Assets')}}</li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>
    <!-- Filter -->
    <div class="panel-container show">
        <div class="panel-content">


            <form action="{{url('AssetsSechduleFilter')}}" method="get">


                <div class="form-row">
                    <div class="form-group col-md-2 col-2-print">
                        <label class="form-label" for="simpleinput">{{trans('admin.From')}}</label>
                        <input type="date" id="from" value="{{date('Y-m-d')}}" name="From" class="form-control" required>
                    </div>
                    <div class="form-group col-md-2 col-2-print">
                        <label class="form-label" for="simpleinput">{{trans('admin.To')}}</label>
                        <input type="date" id="to" value="{{date('Y-m-d')}}" name="To" class="form-control" required>
                    </div>
                    <div class="form-group col-lg-3">
                        <label class="form-label" for=""> {{trans('admin.Main_Account')}} </label>
                        <select class="js-data-example-ajax form-control w-100" name="Main_Account" id="Main_New_Account">
                        </select>
                    </div>
                    <div class="form-group col-lg-3">
                        <label class="form-label" for=""> {{trans('admin.Asset_Type')}} </label>
                        <select class="select2 form-control w-100" name="Asset_Type">
                            <option value="">{{trans('admin.Asset_Type')}} </option>
                            <option value="{{trans('admin.consumer')}}">{{trans('admin.consumer')}} </option>
                            <option value="{{trans('admin.unconsumed')}}">{{trans('admin.unconsumed')}} </option>
                        </select>
                    </div>
                    <div class="form-group col-lg-3" id="M1" style="display: none">
                        <label class="form-label" for=""> {{trans('admin.Depreciation_Method')}} </label>
                        <select class="select2 form-control w-100" name="Depreciation_Method">
                            <option value="">{{trans('admin.Depreciation_Method')}} </option>
                            <option value="{{trans('admin.Fixed')}}">{{trans('admin.Fixed')}} </option>
                            <option value="{{trans('admin.decreasing')}}">{{trans('admin.decreasing')}} </option>
                        </select>
                    </div>

                    <div class="buttons" style="margin-top: 25px;">
    <button type="submit" class="btn btn-primary"><i class="fal fa-search"></i></button>
</div>
                </div>
            </form>
        </div>
    </div>



    <div class="row">
        <div class="col-xl-12">
            <div id="panel-1" class="panel">
                <div class="panel-hdr">
                    <h2>
                        {{trans('admin.Assets')}}
                    </h2>

                    <div class="panel-toolbar">

                        @can('اضافه اصل')
                        <button type="button" class="btn btn-default btn-sm margin-btn" data-toggle="modal" data-target="#default-example-modal-center-add">
                            {{trans('admin.AddNew')}}</button>
                        @endcan

                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                            Style</button>
                        @include('admin.layouts.toolbar')
                    </div>

                </div>
                <div class="panel-container show">
                    <span id="ex"> @include('admin.layouts.messages')</span>
                    <div class="panel-content">

                        <!-- datatable start -->
                        <div id="mobile-overflow">
                            <table id="dt-basic-example" class="table table-bordered table-hover table-striped w-100 mobile-width">
                                <thead class="bg-highlight">
                                    <tr>
                                        <th>{{trans('admin.Code')}}</th>
                                        <th>{{trans('admin.Arabic_Name')}}</th>
                                        <th>{{trans('admin.English_Name')}}</th>
                                        <th> {{trans('admin.Image')}}</th>
                                        <th> {{trans('admin.Account_Code')}}</th>
                                        <th> {{trans('admin.Payment_Method')}}</th>
                                        <th> {{trans('admin.Data')}}</th>
                                        <th> {{trans('admin.Actions')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($items as $item)
                                    <tr @if($item->Delete == 1) class="deleted" @elseif($item->Sale == 1) class="sold" @endif>
                                        <td>{{$item->Code}}</td>
                                        <td>{{$item->Name}}</td>
                                        <td>{{$item->NameEn}}</td>

                                        <td><img src="{{URL::to($item->Image)}}"></td>

                                        <td>@if(!empty($item->Account()->first()->Code)){{$item->Account()->first()->Code}} @endif</td>
                                        <td>
                                            @if($item->Payment_Method == 'Cash')
                                            {{trans('admin.Cash')}}
                                            @elseif($item->Payment_Method == 'Later')
                                            {{trans('admin.Later')}}
                                            @elseif($item->Payment_Method == 'Installment')
                                            {{trans('admin.Installment')}}
                                            @elseif($item->Payment_Method == 'Check')
                                            {{trans('admin.Check')}}
                                            @endif
                                        </td>


                                        <td><button type="button" class="btn btn-primary" data-toggle="modal" data-target="#show-data{{$item->id}}">
                                                {{trans('admin.Data')}}
                                            </button>
                                        <td>

                                            @if($item->Delete == 0 and $item->Sale == 0)

                                            @can('حذف اصل')
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Delete{{$item->id}}">
                                                <i class="fal fa-trash"></i>
                                            </button>

                                            @endcan


                                            <button type="button" class="btn btn-default" style="width:65px;" data-toggle="modal" data-target="#Sale{{$item->id}}">
                                                {{trans('admin.Asset_Sale')}}
                                            </button>

                                            @endif



                                            @if($item->Delete == 1)

                                            <span class="btn btn-danger">{{trans('admin.Deleted')}}</span>
                                            @endif

                                            @if($item->Sale == 1)

                                            <span class="btn btn-success">{{trans('admin.Sold')}}</span>
                                            @endif




                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>{{trans('admin.Code')}}</th>
                                        <th>{{trans('admin.Arabic_Name')}}</th>
                                        <th>{{trans('admin.English_Name')}}</th>
                                        <th> {{trans('admin.Image')}}</th>
                                        <th> {{trans('admin.Account_Code')}}</th>
                                        <th> {{trans('admin.Payment_Method')}}</th>
                                        <th> {{trans('admin.Data')}}</th>
                                        <th> {{trans('admin.Actions')}}</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        {{$items->Links()}}
                        <!-- datatable end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<!-- Modal Add -->
<div class="modal fade" id="default-example-modal-center-add" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.AddNew')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <form action="{{url('AddAssets')}}" method="post" enctype="multipart/form-data">
                {!! csrf_field() !!}
                @honeypot
                <div class="modal-body">

                    <div class="row">
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Code')}}</label>
                            <input type="text" value="{{$Code}}" disabled class="form-control">
                            <input type="hidden" name="Code" value="{{$Code}}">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Arabic_Name')}}</label>
                            <input type="text" name="Name" value="{{old('Name')}}" class="form-control" required>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.English_Name')}}</label>
                            <input type="text" name="NameEn" value="{{old('NameEn')}}" class="form-control">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""> {{trans('admin.Main_Account')}} </label>
                            <select class="js-data-example-ajax form-control w-100" name="Main_Account" id="Main_Account" required>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""> {{trans('admin.Asset_Type')}} </label>
                            <select class="select2 form-control w-100" id="type" onchange="Appear()" name="Asset_Type" required>
                                <option value="">{{trans('admin.Asset_Type')}} </option>
                                <option value="consumer">{{trans('admin.consumer')}} </option>
                                <option value="unconsumed">{{trans('admin.unconsumed')}} </option>
                            </select>
                        </div>
                        <div class="form-group col-lg-3" id="M1" style="display: none">
                            <label class="form-label" for=""> {{trans('admin.Depreciation_Method')}} </label>
                            <select class="select2 form-control w-100" name="Depreciation_Method">
                                <option value="">{{trans('admin.Depreciation_Method')}} </option>
                                <option value="Fixed">{{trans('admin.Fixed')}} </option>
                                <option value="decreasing">{{trans('admin.decreasing')}} </option>
                            </select>
                        </div>

                        <div class="form-group col-lg-3" style="display: none">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Purchases_Date')}}</label>
                            <input type="date" name="Purchases_Date" value="{{old('Purchases_Date')}}" class="form-control">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Operation_Date')}}</label>
                            <input type="date" name="Operation_Date" value="{{old('Operation_Date')}}" class="form-control" required>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Cost')}}</label>
                            <input type="number" step="any" name="Cost" value="{{old('Cost')}}" class="form-control" required onclick="Result()" onkeyup="Result()" id="Cost">
                        </div>
                        <div class="form-group col-lg-3" id="M2" style="display: none">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Previous_Depreciation')}}</label>
                            <input type="number" step="any" name="Previous_Depreciation" value="{{old('Previous_Depreciation')}}" class="form-control" onclick="Result()" onkeyup="Result()" id="Previous_Depreciation">
                        </div>
                        <div class="form-group col-lg-3" id="M3" style="display: none">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Asset_Net')}}</label>
                            <input type="number" step="any" value="{{old('Asset_Net')}}" class="form-control" id="Asset_Net" disabled>
                            <input type="hidden" name="Asset_Net" id="Asset_NetHide">
                        </div>
                        <div class="form-group col-lg-3" id="M4" style="display: none">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Annual_Depreciation_Ratio')}}</label>
                            <input type="number" step="any" name="Annual_Depreciation_Ratio" value="{{old('Annual_Depreciation_Ratio')}}" class="form-control" onclick="Result()" onkeyup="Result()" id="Annual_Depreciation_Ratio">
                        </div>
                        <div class="form-group col-lg-3" id="M5" style="display: none">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Annual_Depreciation')}}</label>
                            <input type="number" step="any" value="{{old('Annual_Depreciation')}}" class="form-control" id="Annual_Depreciation" disabled>
                            <input type="hidden" name="Annual_Depreciation" id="Annual_DepreciationHide">
                        </div>
                        <div class="form-group col-lg-3" id="M6" style="display: none">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Life_Span')}}</label>
                            <input type="number" step="any" value="{{old('Life_Span')}}" class="form-control" id="Life_Span" disabled>
                            <input type="hidden" name="Life_Span" id="Life_SpanHide">
                        </div>

                        <div class="form-group col-lg-3" style="display: none">
                            <label class="form-label" for="">{{trans('admin.Depreciation_Expenses')}} </label>
                            <select class="js-data-example-ajax form-control w-100 AccEx" name="Depreciation_Expenses">
                            </select>
                        </div>

                        <div class="form-group col-lg-3" id="M7" style="display: none">
                            <label class="form-label" for="">{{trans('admin.Depreciation_Complex')}} </label>
                            <select class="js-data-example-ajax form-control w-100 AccCom" name="Depreciation_Complex">
                            </select>
                        </div>

                        <div class="form-group col-lg-3" id="M8" style="display: none">
                            <label class="form-label" for="">{{trans('admin.Account_Ehlak')}} </label>
                            <select class="select2 form-control w-100" name="Ehlak">
                                <option value="">{{trans('admin.Account_Ehlak')}}</option>
                                @foreach($Ehlak as $ehl)
                                <option value="{{$ehl->id}}">

                                    {{app()->getLocale() == 'ar' ?$ehl->Name :$ehl->NameEn}}
                                </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Coin')}}</label>
                            <select class="select2 form-control w-100" name="Coin" required>
                                <option value=""> {{trans('admin.Coin')}}</option>
                                @foreach($Coins as $coin)
                                <option value="{{$coin->id}}" @if($coin->id == $Def->Coin) selected @endif>

                                    {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                            <input type="text" name="Draw" value="1" class="form-control" required>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""> {{trans('admin.Cost_Center')}} </label>
                            <select class="select2 form-control w-100" name="Cost_Center">
                                <option value=""> {{trans('admin.Cost_Center')}}</option>
                                @foreach($CostCenters as $cost)
                                <option value="{{$cost->id}}">

                                    {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                </option>
                                @endforeach
                            </select>
                        </div>


                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Image')}}</label>
                            <input type="file" name="Image">
                        </div>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Branch')}}</label>
                            <select class="select2 form-control w-100" name="Branch">
                                <option value=""> {{trans('admin.Branch')}}</option>
                                @foreach($Branchs as $branch)
                                <option value="{{$branch->id}}">

                                    {{app()->getLocale() == 'ar' ?$branch->Arabic_Name :$branch->English_Name}}
                                </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Sort_Asset')}}</label>
                            <select class="select2 form-control w-100" onchange="sort()" id="Sort_Asset" name="Sort_Asset" required>
                                <option value=""> {{trans('admin.Sort_Asset')}}</option>
                                <option value="1" selected> {{trans('admin.Start_Period')}}</option>
                                <option value="2"> {{trans('admin.Purchase')}}</option>
                            </select>
                        </div>

                        <div class="form-group col-lg-3" id="VEND" style="display: none">
                            <label class="form-label" for="">{{trans('admin.Vendor')}}</label>
                            <select class="select2 form-control w-100" id="vendor" name="Vendor">

                            </select>
                        </div>

                        <div class="form-group col-lg-3" id="SAFE" style="display: none">
                            <label class="form-label" for="">{{trans('admin.Safe')}}</label>
                            <select class="select2 form-control w-100" name="Safe">
                                <option value=""> {{trans('admin.Safe')}}</option>
                                @foreach($Safes as $safe)
                                <option value="{{$safe->id}}">

                                    {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group col-lg-3" id="Payment">
                            <label class="form-label" for=""> {{trans('admin.Payment_Method')}}</label>
                            <select class="select2 form-control w-100" name="Payment_Method" id="Payment_Method">
                                <option value="Cash">{{trans('admin.Cash')}} </option>
                                <option value="Later">{{trans('admin.Later')}}</option>
                            </select>
                        </div>
                        <div class="form-group col-lg-12">
                            <label class="form-label" for="simpleinput">{{trans('admin.Notes')}}</label>
                            <input type="text" name="Note" value="{{old('Note')}}" class="form-control">
                        </div>

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                    <button type="submit" class="btn btn-primary">{{trans('admin.Save')}}</button>
                </div>
            </form>
        </div>
    </div>
</div>


@foreach($items as $item)


<!-- Modal Delete -->
<div class="modal fade" id="Delete{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered " role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Delete')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
            </div>
            <div class="modal-footer">

                <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                <a href="{{url('DeleteAssets/'.$item->id)}}" class="btn btn-primary"> {{trans('admin.Yes')}}</a>
            </div>
        </div>
    </div>
</div>
<!--modal show data-->
<div class="modal fade" id="show-data{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Data')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <div style="overflow:auto">
                    <table id="" class="table table-bordered table-hover table-striped">
                        <thead class="bg-highlight">
                            <tr>

                                <th> {{trans('admin.Asset_Type')}}</th>
                                <th> {{trans('admin.Depreciation_Method')}}</th>

                                <th> {{trans('admin.Operation_Date')}}</th>
                                <th> {{trans('admin.Cost')}}</th>
                                <th> {{trans('admin.Previous_Depreciation')}}</th>
                                <th> {{trans('admin.Asset_Net')}}</th>
                                <th> {{trans('admin.Annual_Depreciation_Ratio')}}</th>
                                <th> {{trans('admin.Annual_Depreciation')}}</th>
                                <th> {{trans('admin.Life_Span')}}</th>
                                <th> {{trans('admin.Draw')}}</th>
                                <th> {{trans('admin.Coin')}}</th>
                                <th> {{trans('admin.Cost_Center')}}</th>

                                <th> {{trans('admin.Note')}}</th>
                                <th> {{trans('admin.Branch')}}</th>
                                <!--   <th> {{trans('admin.Depreciation_Expenses')}}</th> -->
                                <th> {{trans('admin.Depreciation_Complex')}}</th>
                                <th> {{trans('admin.Sort_Asset')}}</th>
                                <th> {{trans('admin.Vendor')}}</th>
                                <th> {{trans('admin.Safe')}}</th>
                                <th> {{trans('admin.Main_Account')}}</th>

                                <th> {{trans('admin.Account_Ehlak')}}</th>
                                <th> {{trans('admin.User')}}</th>


                            </tr>
                        </thead>
                        <tbody>

                            <tr>

                                <td>


                                    {{app()->getLocale() == 'ar' ?$item->Asset_Type :$item->Asset_Type_En}}

                                </td>
                                <td>

                                    {{app()->getLocale() == 'ar' ?$item->Depreciation_Method :$item->Depreciation_Method_En}}

                                </td>

                                <td>{{$item->Operation_Date}}</td>
                                <td>{{$item->Cost}}</td>
                                <td>{{$item->Previous_Depreciation}}</td>
                                <td>{{$item->Asset_Net}}</td>
                                <td>{{$item->Annual_Depreciation_Ratio}}</td>
                                <td>{{$item->Annual_Depreciation}}</td>
                                <td>{{$item->Life_Span}}</td>
                                <td>{{$item->Draw}}</td>
                                <td>{{$item->Coin()->first()->Arabic_Name}}</td>
                                <td>
                                    @if(!empty($item->Cost_Center()->first()->Arabic_Name))

                                    {{app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name}}

                                    @endif
                                </td>

                                <td>{{$item->Note}}</td>
                                <td>
                                    @if(!empty($item->Branch()->first()->Arabic_Name))
                                    {{app()->getLocale() == 'ar' ?$item->Branch()->first()->Arabic_Name :$item->Branch()->first()->English_Name}}

                                    @endif
                                </td>
                                <!--    <td>
                                                          @if(!empty($item->Depreciation_Expenses))
                                                    {{$item->Depreciation_Expenses()->first()->Name}}
                                                    @endif
                                                       </td> -->

                                <td>
                                    @if(!empty($item->Depreciation_Complex()->first()->Name))
                                    {{$item->Depreciation_Complex()->first()->Name}}
                                    @endif
                                </td>

                                <td>
                                    @if($item->Sort_Asset == 1)
                                    {{trans('admin.Start_Period')}}
                                    @elseif($item->Sort_Asset == 2)
                                    {{trans('admin.Purchase')}}
                                    @endif
                                </td>

                                <td>
                                    @if(!empty($item->Vendor()->first()->Name))
                                    {{app()->getLocale() == 'ar' ?$item->Vendor()->first()->Name :$item->Vendor()->first()->NameEn}}

                                    @endif
                                </td>

                                <td>
                                    @if(!empty($item->Safe()->first()->Name))
                                    {{app()->getLocale() == 'ar' ?$item->Safe()->first()->Name :$item->Safe()->first()->NameEn}}

                                    @endif
                                </td>

                                <td>
                                    @if(!empty($item->Main_Account()->first()->Name))
                                    {{app()->getLocale() == 'ar' ?$item->Main_Account()->first()->Name :$item->Main_Account()->first()->NameEn}}
                                    @endif
                                </td>

                                <td>
                                    @if(!empty($item->Ehlak()->first()->Name))


                                    {{app()->getLocale() == 'ar' ?$item->Ehlak()->first()->Name :$item->Ehlak()->first()->NameEn}}
                                    @endif
                                </td>

                                <td>
                                    @if(!empty($item->User()->first()->name))
                                    {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}
                                    @endif
                                </td>


                            </tr>

                        </tbody>
                        <tfoot>
                            <tr>

                                <th> {{trans('admin.Asset_Type')}}</th>
                                <th> {{trans('admin.Depreciation_Method')}}</th>
                                <th> {{trans('admin.Purchases_Date')}}</th>
                                <th> {{trans('admin.Operation_Date')}}</th>
                                <th> {{trans('admin.Cost')}}</th>
                                <th> {{trans('admin.Previous_Depreciation')}}</th>
                                <th> {{trans('admin.Asset_Net')}}</th>
                                <th> {{trans('admin.Annual_Depreciation_Ratio')}}</th>
                                <th> {{trans('admin.Annual_Depreciation')}}</th>
                                <th> {{trans('admin.Life_Span')}}</th>
                                <th> {{trans('admin.Draw')}}</th>
                                <th> {{trans('admin.Coin')}}</th>
                                <th> {{trans('admin.Cost_Center')}}</th>

                                <th> {{trans('admin.Note')}}</th>
                                <th> {{trans('admin.Branch')}}</th>
                                <!--  <th> {{trans('admin.Depreciation_Expenses')}}</th> -->
                                <th> {{trans('admin.Depreciation_Complex')}}</th>
                                <th> {{trans('admin.Sort_Asset')}}</th>
                                <th> {{trans('admin.Vendor')}}</th>
                                <th> {{trans('admin.Safe')}}</th>
                                <th> {{trans('admin.Main_Account')}}</th>

                                <th> {{trans('admin.Account_Ehlak')}}</th>
                                <th> {{trans('admin.User')}}</th>

                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
            </div>

        </div>
    </div>
</div>

<!-- Modal Asset Sale -->
<div class="modal fade" id="Sale{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Asset_Sale')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <form action="{{url('AssetSale')}}" method="post">
                {!! csrf_field() !!}
                <div class="modal-body">
                    <div class="row">
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.CurrentAssetPrice')}}</label>
                            <input type="number" name="CurrentAssetPrice" step="any" class="form-control" required>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Amount')}}</label>
                            <input type="number" step="any" name="Amount" class="form-control" required>
                        </div>
                        <input type="hidden" name="ID" value="{{$item->id}}">
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Client')}}</label>
                            <select class="select2 form-control w-100 client" name="Client" required>

                            </select>
                        </div>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Safe')}}</label>
                            <select class="select2 form-control w-100" name="Safe" required>
                                <option value=""> {{trans('admin.Safe')}}</option>
                                @foreach($Safes as $safe)
                                <option value="{{$safe->id}}">
                                    {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}

                                </option>
                                @endforeach
                            </select>
                        </div>

                    </div>
                </div>
                <div class="modal-footer">

                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>

                </div>
            </form>
        </div>
    </div>
</div>



@endforeach

@endsection

@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script>
    //_fnFeatureHtmlLength();
    $(document).ready(function() {
        // Setup - add a text input to each footer cell
        $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
        $('#dt-basic-example thead tr:eq(1) th').each(function(i) {
            var title = $(this).text();
            $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

            $('input', this).on('keyup change', function() {
                if (table.column(i).search() !== this.value) {
                    table
                        .column(i)
                        .search(this.value)
                        .draw();
                }
            });
        });
        var table = $('#dt-basic-example').DataTable({
            // responsive: true,
            orderCellsTop: true,
            fixedHeader: true,
            lengthChange: true,

            dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

            buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'colvis',
                    text: 'Column Visibility',
                    titleAttr: 'Col visibility',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'pdfHtml5',
                    text: 'PDF',
                    titleAttr: 'Generate PDF',
                    className: 'btn-outline-danger btn-sm mr-1'
                },
                {
                    extend: 'excelHtml5',
                    text: 'Excel',
                    titleAttr: 'Generate Excel',
                    className: 'btn-outline-success btn-sm mr-1'
                },
                {
                    extend: 'csvHtml5',
                    text: 'CSV',
                    titleAttr: 'Generate CSV',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'copyHtml5',
                    text: 'Copy',
                    titleAttr: 'Copy to clipboard',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'print',
                    text: 'Print',
                    titleAttr: 'Print Table',
                    className: 'btn-outline-primary btn-sm'
                }
            ],
        });
        $('.js-thead-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
        });

        $('.js-tbody-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
        });

    });

</script>
<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function() {
        interval = setInterval(function() {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function() {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete
    var removeFromLocal = function() {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function() {
        //init default
        $('.js-summernote').summernote({
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks: {
                //restore from localStorage
                onInit: function(e) {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable) {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax({
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data) {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote({
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint: {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback) {
                    callback($.grep(emojis, function(item) {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item) {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item) {
                    var url = emojiUrls[item];
                    if (url) {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote({
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint: {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback) {
                    callback($.grep(this.mentions, function(item) {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item) {
                    return '@' + item;
                }
            }
        });

    });

</script>


<!-- Search Selecet -->
<script>
    $(document).ready(function() {
        $(function() {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State"
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm
                }
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }


            $('#Main_Account').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllMainAssetsAccounts',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllMainAssetsAccountsJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Main_Account').empty();
                                $.each(data, function(key, value) {

                                    $('#Main_Account').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('#Main_Account').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });


            $('#Main_New_Account').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllMainAssetsAccounts',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllMainAssetsAccountsJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Main_Account').empty();
                                $.each(data, function(key, value) {

                                    $('#Main_Account').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('#Main_New_Account').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });



            $('.AccEx').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllAccountsExpenses',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllAccountsExpensesJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('.AccEx').empty();
                                $.each(data, function(key, value) {

                                    $('.AccEx').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('.AccEx').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });


            $('.AccCom').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllAccountsComplex',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllAccountsComplexJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('.AccCom').empty();
                                $.each(data, function(key, value) {

                                    $('.AccCom').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('.AccCom').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });



            $("#vendor").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllVendors",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {

                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllVendorsJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#vendor').empty();
                                $.each(data, function(key, value) {

                                    $('#vendor').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#vendor").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });

            $(".client").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllClientsFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {

                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllClientsFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('.client').empty();
                                $.each(data, function(key, value) {

                                    $('.client').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $(".client").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });



        });
    });

</script>


<script>
    function Result() {

        var Cost = $('#Cost').val();
        var Previous_Depreciation = $('#Previous_Depreciation').val();
        var Annual_Depreciation_Ratio = $('#Annual_Depreciation_Ratio').val();


        var Net = parseFloat(Cost) - parseFloat(Previous_Depreciation);

        $('#Asset_Net').val(parseFloat(Net));
        $('#Asset_NetHide').val(parseFloat(Net));

        var Asset_Net = $('#Asset_Net').val();

        var i = parseFloat(Annual_Depreciation_Ratio) / 100;
        var ii = parseFloat(Cost) * parseFloat(i);

        $('#Annual_Depreciation').val(parseFloat(ii));
        $('#Annual_DepreciationHide').val(parseFloat(ii));

        var Annual_Depreciation = $('#Annual_Depreciation').val();

        var x = parseFloat(Cost) / parseFloat(Annual_Depreciation);

        $('#Life_Span').val(parseFloat(x));
        $('#Life_SpanHide').val(parseFloat(x));


    }

</script>

<script>
    function Appear() {

        var type = $('#type').val();
        if (type == "consumer") {

            document.getElementById("M1").style.display = "block";
            document.getElementById("M2").style.display = "block";
            document.getElementById("M3").style.display = "block";
            document.getElementById("M4").style.display = "block";
            document.getElementById("M5").style.display = "block";
            document.getElementById("M6").style.display = "block";
            document.getElementById("M7").style.display = "block";
            document.getElementById("M8").style.display = "block";

        } else {

            document.getElementById("M1").style.display = "none";
            document.getElementById("M2").style.display = "none";
            document.getElementById("M3").style.display = "none";
            document.getElementById("M4").style.display = "none";
            document.getElementById("M5").style.display = "none";
            document.getElementById("M6").style.display = "none";
            document.getElementById("M7").style.display = "none";
            document.getElementById("M8").style.display = "none";



        }

    }
</script>

<script>
    function sort() {
        var Sort_Asset = $('#Sort_Asset').val();

        if (Sort_Asset == 2) {

            document.getElementById("VEND").style.display = "block";
            document.getElementById("SAFE").style.display = "block";
            document.getElementById("Payment").style.display = "block";

        } else {


            document.getElementById("VEND").style.display = "none";
            document.getElementById("SAFE").style.display = "none";
            document.getElementById("Payment").style.display = "none";
        }


    }

    $(document).ready(function() {

        var Sort_Asset = $('#Sort_Asset').val();

        if (Sort_Asset == 2) {

            document.getElementById("VEND").style.display = "block";
            document.getElementById("SAFE").style.display = "block";
            document.getElementById("Payment").style.display = "block";

        } else {


            document.getElementById("VEND").style.display = "none";
            document.getElementById("SAFE").style.display = "none";
            document.getElementById("Payment").style.display = "none";
        }


    });

</script>

@endpush
