<!DOCTYPE html>
@php
use App\Models\CompanyData;
$Def=CompanyData::orderBy('id','desc')->first();
@endphp
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="description" content="Basic">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no, user-scalable=no, minimal-ui">
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="msapplication-tap-highlight" content="no">
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests" />
    <link id="vendorsbundle" rel="stylesheet" media="screen, print" href="{{asset('Admin/css/vendors.bundle.css')}}">
    <link id="appbundle" rel="stylesheet" media="screen, print" href="{{asset('Admin/css/app.bundle.css')}}">
    <link id="mytheme" rel="stylesheet" media="screen, print" href="#">
    <link id="myskin" rel="stylesheet" media="screen, print" href="{{asset('Admin/css/skins/skin-master.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/style.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/style-ar.css')}}">
    <link rel="apple-touch-icon" sizes="180x180" href="{{asset('Admin/img/favicon/apple-touch-icon.png')}}">
    <link rel="icon" type="image/png" sizes="32x32" href="{{URL::to($Def->Icon_Store)}}">
    <link rel="mask-icon" href="{{URL::to($Def->Icon_Store)}}" color="#5bbad5">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
    <title>{{trans('admin.Price_List')}}</title>
    <style>
        /* Define your custom colors */
        :root {
            --primary-color: #205952; /* Dark Teal */
            --secondary-color: #cd9b27; /* Golden Brown */
            --text-light: #f8f9fa; /* Light text for dark backgrounds */
            --text-dark: #343a40; /* Dark text for light backgrounds */
            --gradient-main: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            --gradient-reverse: linear-gradient(135deg, var(--secondary-color) 0%, var(--primary-color) 100%);
        }

        /* General Body Styles */
        body {
            font-family: 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            background: var(--gradient-main); /* Full page gradient background */
            color: var(--text-light); /* Light text on dark background */
            min-height: 100vh; /* Ensure gradient covers full height */
            margin: 0;
            display: flex;
            flex-direction: column;
        }
        .container-fluid {
            flex-grow: 1; /* Allow content to grow */
        }

        /* Header / Top Menu Section */
        .menu {
            background-color: rgba(32, 89, 82, 0.85); /* Semi-transparent primary color */
            padding: 20px 0;
            border-bottom: 1px solid rgba(205, 155, 39, 0.4); /* Border with secondary color */
            box-shadow: 0 4px 8px rgba(0,0,0,.2);
            margin-bottom: 20px;
        }

        .head-menu {
            text-align: center;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .head-menu img {
            height: 80px;
            max-width: 100%;
            animation: none;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,.3);
            object-fit: contain;
            background-color: #ffffff; /* White background for logo to stand out */
            padding: 5px;
        }

        .numbers {
            margin-top: 0;
            color: var(--text-light); /* Light text for phone numbers */
            font-size: 1rem;
            display: flex;
            flex-direction: column;
            justify-content: center;
            height: 100%;
        }

        .numbers p {
            margin-bottom: 5px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .numbers p i {
            color: var(--secondary-color); /* Secondary color for icons */
            font-size: 1.1em;
        }

        /* Filter Section */
        .filter {
            background: rgba(205, 155, 39, 0.2); /* Lighter, semi-transparent secondary color */
            padding: 15px 20px;
            border: 1px solid rgba(205, 155, 39, 0.5); /* Border with secondary color */
            border-radius: 8px;
            margin-bottom: 30px;
            box-shadow: 0 4px 10px rgba(0,0,0,.2);
        }

        .filter .form-label {
            font-weight: 600;
            color: var(--text-light); /* Light text for labels */
            margin-bottom: 8px;
        }

        .filter .form-control,
        .filter .select2-container .select2-selection--single {
            border-radius: 5px;
            border: 1px solid rgba(255,255,255,0.3); /* Lighter border for inputs */
            padding: .375rem .75rem;
            height: calc(2.25rem + 2px);
            background-color: rgba(255,255,255,0.1); /* Slightly transparent white background */
            color: var(--text-light); /* Light text in inputs */
        }
        .filter .form-control::placeholder {
            color: rgba(255,255,255,0.6); /* Lighter placeholder text */
        }
        .filter .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 2.25rem;
            color: var(--text-light);
        }
        .filter .select2-container--default .select2-selection--single .select2-selection__arrow b {
            top: 60%;
            border-color: var(--text-light) transparent transparent transparent; /* Light arrow */
        }

        /* Product Card Styles */
        .product {
            margin-top: 15px;
            background: rgba(32, 89, 82, 0.7); /* Primary color with transparency for cards */
            border: 1px solid rgba(205, 155, 39, 0.5); /* Border with secondary color */
            border-radius: 10px;
            padding: 15px;
            box-shadow: 0 4px 12px rgba(0,0,0,.3);
            transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
            display: flex;
            flex-direction: column;
            height: 100%;
            position: relative;
        }

        .product:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0,0,0,.4);
            background: rgba(205, 155, 39, 0.7); /* Secondary color on hover */
        }

        .product img {
            height: 80px;
            width: 80px;
            border-radius: 8px;
            object-fit: cover;
            cursor: pointer;
            transition: opacity 0.3s ease;
            margin-bottom: 10px;
            background-color: #ffffff; /* White background for product image */
            padding: 3px;
        }

        .product img:hover {
            opacity: 0.85;
        }

        .product h5 {
            color: var(--text-light); /* Light text for product name */
            font-size: 1.15rem;
            margin-bottom: 5px;
            line-height: 1.4;
            flex-grow: 1;
        }

        .product h6 {
            color: rgba(255,255,255,0.7); /* Slightly lighter text for unit */
            font-size: 0.9rem;
            margin-top: 5px;
            text-align: center;
        }

        .product p {
            margin-bottom: 0;
            font-size: 0.9rem;
            color: var(--text-light);
        }

        .product .price {
            color: #ffffff; /* White for price to stand out */
            font-size: 1.25rem;
            font-weight: 700;
            text-align: center;
            width: 100%;
            margin-top: 10px;
        }

        .product .btn-primary {
            color: var(--text-light);
            background-color: var(--secondary-color); /* Secondary color for buttons */
            border-color: var(--secondary-color);
            border-radius: 5px;
            font-size: 0.85rem;
            padding: 5px 10px;
            transition: background-color 0.2s ease, border-color 0.2s ease;
            width: 90%;
            margin: 0 auto;
            display: block;
        }

        .product .btn-primary:hover,
        .product .btn-primary:active,
        .product .btn-primary:focus {
            background-color: var(--primary-color); /* Primary color on hover for buttons */
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(205, 155, 39, 0.25);
        }

        /* Modal Styles (for image and description) */
        .modal-img {
            background-color: rgba(0,0,0,0.9);
        }

        .product .modal-content {
            background-color: var(--primary-color); /* Primary color background for modal content */
            border-radius: 8px;
            box-shadow: 0 5px 15px rgba(0,0,0,.5);
        }

        #caption {
            color: var(--text-light);
            font-size: 1.2rem;
        }

        .modal-img .close-img {
            color: var(--text-light);
        }

        .modal-img .close-img:hover,
        .modal-img .close-img:focus {
            color: var(--secondary-color);
        }

        /* Description Modal */
        .modal-header {
            background: var(--gradient-reverse); /* Gradient for modal header */
            color: var(--text-light);
            border-top-left-radius: 8px;
            border-top-right-radius: 8px;
            padding: 15px;
            border-bottom: none; /* Remove default border */
        }

        .modal-title {
            color: var(--text-light);
        }

        .modal-header .close {
            color: var(--text-light);
            opacity: 1;
            font-size: 1.5rem;
        }

        .modal-body {
            padding: 20px;
            color: var(--text-light); /* Light text in modal body */
            line-height: 1.6;
            background-color: var(--primary-color); /* Primary color for modal body */
            border-bottom-left-radius: 8px;
            border-bottom-right-radius: 8px;
        }

        .modal-footer {
            border-top: none; /* Remove default border */
            padding: 15px;
            background-color: var(--primary-color); /* Primary color for modal footer */
            border-bottom-left-radius: 8px;
            border-bottom-right-radius: 8px;
        }

        .modal-footer .btn-secondary {
            background-color: rgba(255,255,255,0.2);
            border-color: rgba(255,255,255,0.3);
            color: var(--text-light);
        }
        .modal-footer .btn-secondary:hover {
            background-color: rgba(255,255,255,0.3);
            border-color: rgba(255,255,255,0.4);
        }


        /* Animations (unchanged) */
        @keyframes zoom {
            from {transform: scale(0.8); opacity: 0;}
            to {transform: scale(1); opacity: 1;}
        }

        .modal-content, #caption {
            animation-name: zoom;
            animation-duration: 0.4s;
        }

        /* Responsive adjustments (minor color updates) */
        @media (max-width: 768px) {
            .numbers {
                text-align: center;
                margin-top: 15px;
            }
            .numbers p {
                justify-content: center;
            }
            .filter .form-group {
                margin-bottom: 15px;
            }
            .head-menu {
                margin-bottom: 20px;
            }
            .head-menu img {
                height: 70px;
            }
        }

        @media (max-width: 576px) {
            .product {
                padding: 10px;
            }
            .product img {
                height: 60px;
                width: 60px;
            }
            .product h5 {
                font-size: 1rem;
            }
            .product .price {
                font-size: 1.1rem;
            }
            .filter {
                padding: 10px 15px;
            }
            .modal-img .close-img {
                top: 10px;
                right: 20px;
                font-size: 30px;
            }
        }

        /* Additional styles for RTL layout if style-ar.css doesn't handle everything */
        html[dir="rtl"] .numbers p i {
            margin-right: 0;
            margin-left: 5px;
        }
        html[dir="rtl"] .product .padding-item {
            padding-left: 0;
            padding-right: initial;
        }
    </style>
</head>
<body>
    <section class="menu">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-md-4 col-sm-6">
                    <div class="numbers text-md-right text-center">
                        <p><i class="fal fa-phone"></i>{{$Def->Phone1}}</p>
                        <p><i class="fal fa-phone"></i>{{$Def->Phone2}}</p>
                    </div>
                </div>
                <div class="col-md-4 col-sm-12">
                    <div class="head-menu">
                        <img src="{{URL::to($company->Logo_Store)}}" alt="Company Logo">
                    </div>
                </div>
                <div class="col-md-4 col-sm-6">
                    <div class="numbers text-md-left text-center">
                        <p>{{$Def->Phone3}} <i class="fal fa-phone-alt"></i></p>
                        <p>{{$Def->Phone4}} <i class="fal fa-phone-alt"></i></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid mt-4">
            <div class="filter">
                <div class="row">
                    <div class="form-group col-md-4">
                        <label class="form-label" for="Brand"> {{trans('admin.Brands')}} </label>
                        <select class="select2 form-control w-100" id="Brand">
                            <option value="">{{trans('admin.Brands')}}</option>
                            @foreach($Brands as $brand)
                            <option value="{{$brand->id}}">{{app()->getLocale() == 'ar' ?$brand->Name :$brand->NameEn}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-md-4">
                        <label class="form-label" for="Group"> {{trans('admin.Groups')}} </label>
                        <select class="select2 form-control w-100" id="Group">
                            <option value="">{{trans('admin.Groups')}}</option>
                            @foreach($Groups as $group)
                            <option value="{{$group->id}}">{{app()->getLocale() == 'ar' ?$group->Name :$group->NameEn}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-md-4">
                        <label class="form-label" for="Search"> {{trans('admin.Search')}} </label>
                        <input type="text" id="Search" class="form-control" placeholder="{{trans('admin.Search_by_name')}}">
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid mt-4">
            <div class="row Data">
                @foreach($Products as $pro)
                @if($pro->Product()->first()->Store_Show == 2 or $pro->Product()->first()->Store_Show == 3)
                <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 mb-4">
                    <div class="product">
                        <div class="row no-gutters h-100">
                            <div class="col-12 text-center d-flex flex-column align-items-center justify-content-center">
                                @if(!empty($pro->Product()->first()->Image))
                                <img id="myImg{{$pro->id}}" onclick="OPEN({{$pro->id}})" src="{{URL::to($pro->Product()->first()->Image)}}" alt="{{app()->getLocale() == 'ar' ?$pro->P_Ar_Name :$pro->P_En_Name}}">
                                @else
                                <img id="myImg{{$pro->id}}" onclick="OPEN({{$pro->id}})" src="{{asset('Admin/img/demo/gallery/5.jpg')}}" alt="{{app()->getLocale() == 'ar' ?$pro->P_Ar_Name :$pro->P_En_Name}}">
                                @endif
                                <h5 class="text-truncate">{{app()->getLocale() == 'ar' ?$pro->P_Ar_Name :$pro->P_En_Name}}</h5>
                                <h6 class="text-muted">{{app()->getLocale() == 'ar' ?$pro->Unit()->first()->Name :$pro->Unit()->first()->NameEn}}</h6>
                                <p class="price">{{trans('admin.Price')}}: <span>{{$pro->Price}}</span></p>
                                <button type="button" class="btn btn-primary mt-auto" data-toggle="modal" data-target="#description{{$pro->id}}"> {{trans('admin.Desc')}}</button>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="myModal{{$pro->id}}" class="modal-img">
                    <span class="close-img" id="close{{$pro->id}}">&times;</span>
                    <img class="modal-content" id="img{{$pro->id}}" alt="">
                    <div id="caption{{$pro->id}}"></div>
                </div>

                <div class="modal fade" id="description{{$pro->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title">
                                    {{trans('admin.Desc')}} - {{app()->getLocale() == 'ar' ?$pro->P_Ar_Name :$pro->P_En_Name}}
                                </h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                </button>
                            </div>
                            <div class="modal-body">
                                @if(!empty($pro->Product()->first()->Ar_Desc))
                                {!! app()->getLocale() == 'ar' ?$pro->Product()->first()->Ar_Desc :$pro->Product()->first()->En_Desc !!}
                                @else
                                <p>{{trans('admin.No_description_available')}}</p>
                                @endif
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                            </div>
                        </div>
                    </div>
                </div>
                @endif
                @endforeach
            </div>
        </div>
    </section>
    <script src="{{asset('Admin/js/vendors.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/app.bundle.js')}}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/holder/2.9.7/holder.min.js"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        $(document).ready(function() {
            $('.select2').select2({
                placeholder: "{{trans('admin.Select_an_option')}}",
                allowClear: true,
                dropdownCssClass: 'select2-dropdown-custom-style', // Add custom class for dropdown
                selectionCssClass: 'select2-selection-custom-style' // Add custom class for selected item
            });

            // Apply custom styles to Select2 dropdown and selected items for the new color scheme
            // This needs to be done dynamically as select2 generates its own elements
            $('head').append(`
                <style>
                    .select2-dropdown-custom-style {
                        background-color: var(--primary-color);
                        border: 1px solid var(--secondary-color);
                        color: var(--text-light);
                    }
                    .select2-container--default .select2-results__option--highlighted.select2-results__option--selectable {
                        background-color: var(--secondary-color) !important;
                        color: var(--text-light) !important;
                    }
                    .select2-container--default .select2-results__option--selectable {
                        color: var(--text-light) !important;
                    }
                    .select2-selection-custom-style {
                        background-color: rgba(255,255,255,0.1) !important;
                        border: 1px solid rgba(255,255,255,0.3) !important;
                        color: var(--text-light) !important;
                    }
                    .select2-selection-custom-style .select2-selection__arrow b {
                        border-color: var(--text-light) transparent transparent transparent !important;
                    }
                </style>
            `);
        });
    </script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script>
        $(document).ready(function() {
            $('.js-summernote').summernote({
                height: 200,
                tabsize: 2,
                placeholder: "Type here...",
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['insert', ['link', 'picture']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });
        });
    </script>
    <script>
        $(document).ready(function(){
            fetch_customer_data();

            function fetch_customer_data(Brand = '', Group = '', Search = '') {
                $.ajax({
                    url: 'GUESTLISTFilter',
                    method: 'GET',
                    data: {Brand: Brand, Group: Group, Search: Search},
                    dataType: 'json',
                    success: function(data) {
                        $('.Data').html(data.table_data);
                        $('.product img').each(function() {
                            var proId = $(this).attr('id').replace('myImg', '');
                            var modal = document.getElementById('myModal' + proId);
                            var closeBtn = document.getElementById('close' + proId);
                            if (closeBtn) {
                                closeBtn.onclick = function() {
                                    modal.style.display = "none";
                                };
                            }
                        });
                    }
                });
            }

            $(document).on('change', '#Brand', function(){
                var Brand = $(this).val();
                var Group = $('#Group').val();
                var Search = $('#Search').val();
                fetch_customer_data(Brand, Group, Search);
            });

            $(document).on('change', '#Group', function(){
                var Group = $(this).val();
                var Brand = $('#Brand').val();
                var Search = $('#Search').val();
                fetch_customer_data(Brand, Group, Search);
            });

            $(document).on('keyup', '#Search', function(){
                var Search = $(this).val();
                var Group = $('#Group').val();
                var Brand = $('#Brand').val();
                fetch_customer_data(Brand, Group, Search);
            });
        });
    </script>
    <script>
        function OPEN(R) {
            var modal = document.getElementById('myModal' + R);
            var img = document.getElementById('myImg' + R);
            var modalImg = document.getElementById("img" + R);
            var captionText = document.getElementById("caption" + R);

            modal.style.display = "block";
            modalImg.src = img.src;
            captionText.innerHTML = img.alt;

            var span = document.getElementById("close" + R);
            span.onclick = function() {
                modal.style.display = "none";
            }

            modal.onclick = function(event) {
                if (event.target == modal) {
                    modal.style.display = "none";
                }
            }
        }
    </script>
</body>
</html>