--
-- PostgreSQL database dump
--

\restrict pHBcsOYj9CdMyGTyaMGl4TPxJKLt3Daruj3pGVxcMrZoTHw6lFcxjxUIdxVY2X5

-- Dumped from database version 13.22
-- Dumped by pg_dump version 13.22

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: rand(); Type: FUNCTION; Schema: public; Owner: demorabiherp_karim
--

CREATE FUNCTION public.rand() RETURNS double precision
    LANGUAGE sql
    AS $$SELECT random();$$;


ALTER FUNCTION public.rand() OWNER TO demorabiherp_karim;

--
-- Name: soundex(text); Type: FUNCTION; Schema: public; Owner: demorabiherp_karim
--

CREATE FUNCTION public.soundex(input text) RETURNS text
    LANGUAGE plpgsql IMMUTABLE STRICT COST 500
    AS $$
DECLARE
  soundex text = '';
  char text;
  symbol text;
  last_symbol text = '';
  pos int = 1;
BEGIN
  WHILE length(soundex) < 4 LOOP
    char = upper(substr(input, pos, 1));
    pos = pos + 1;
    CASE char
    WHEN '' THEN
      -- End of input string
      IF soundex = '' THEN
        RETURN '';
      ELSE
        RETURN rpad(soundex, 4, '0');
      END IF;
    WHEN 'B', 'F', 'P', 'V' THEN
      symbol = '1';
    WHEN 'C', 'G', 'J', 'K', 'Q', 'S', 'X', 'Z' THEN
      symbol = '2';
    WHEN 'D', 'T' THEN
      symbol = '3';
    WHEN 'L' THEN
      symbol = '4';
    WHEN 'M', 'N' THEN
      symbol = '5';
    WHEN 'R' THEN
      symbol = '6';
    ELSE
      -- Not a consonant; no output, but next similar consonant will be re-recorded
      symbol = '';
    END CASE;

    IF soundex = '' THEN
      -- First character; only accept strictly English ASCII characters
      IF char ~>=~ 'A' AND char ~<=~ 'Z' THEN
        soundex = char;
        last_symbol = symbol;
      END IF;
    ELSIF last_symbol != symbol THEN
      soundex = soundex || symbol;
      last_symbol = symbol;
    END IF;
  END LOOP;

  RETURN soundex;
END;
$$;


ALTER FUNCTION public.soundex(input text) OWNER TO demorabiherp_karim;

--
-- Name: substring_index(text, text, integer); Type: FUNCTION; Schema: public; Owner: demorabiherp_karim
--

CREATE FUNCTION public.substring_index(text, text, integer) RETURNS text
    LANGUAGE sql
    AS $_$SELECT array_to_string((string_to_array($1, $2)) [1:$3], $2);$_$;


ALTER FUNCTION public.substring_index(text, text, integer) OWNER TO demorabiherp_karim;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: a_v_pro_check_qties; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.a_v_pro_check_qties (
    id bigint NOT NULL,
    "Product" text,
    "AvQty" text,
    "Qty" text,
    "RequestQty" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "OriginalProduct" text,
    "NewRequestQty" text
);


ALTER TABLE public.a_v_pro_check_qties OWNER TO demorabiherp_karim;

--
-- Name: a_v_pro_check_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.a_v_pro_check_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.a_v_pro_check_qties_id_seq OWNER TO demorabiherp_karim;

--
-- Name: a_v_pro_check_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.a_v_pro_check_qties_id_seq OWNED BY public.a_v_pro_check_qties.id;


--
-- Name: abouts; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.abouts (
    id bigint NOT NULL,
    "Image" text,
    "Image_2" text,
    "Image_3" text,
    "Arabic_Title" text,
    "English_Title" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.abouts OWNER TO demorabiherp_karim;

--
-- Name: abouts_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.abouts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.abouts_id_seq OWNER TO demorabiherp_karim;

--
-- Name: abouts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.abouts_id_seq OWNED BY public.abouts.id;


--
-- Name: abstracts_contractors; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.abstracts_contractors (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Name" text,
    "Value" text,
    "Statement" text,
    "Contractor" text,
    "Project" text,
    "Edit" text,
    "Delete" text,
    "Edit_New_Code" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.abstracts_contractors OWNER TO demorabiherp_karim;

--
-- Name: abstracts_contractors_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.abstracts_contractors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.abstracts_contractors_id_seq OWNER TO demorabiherp_karim;

--
-- Name: abstracts_contractors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.abstracts_contractors_id_seq OWNED BY public.abstracts_contractors.id;


--
-- Name: acccounting_manuals; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.acccounting_manuals (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Name" text NOT NULL,
    "Type" text NOT NULL,
    "Parent" text NOT NULL,
    "Note" text,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Account_Code" text,
    "Pro_Group" text,
    "NameEn" text,
    "SearchCode" text
);


ALTER TABLE public.acccounting_manuals OWNER TO demorabiherp_karim;

--
-- Name: acccounting_manuals_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.acccounting_manuals_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.acccounting_manuals_id_seq OWNER TO demorabiherp_karim;

--
-- Name: acccounting_manuals_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.acccounting_manuals_id_seq OWNED BY public.acccounting_manuals.id;


--
-- Name: accounts_default_data; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.accounts_default_data (
    id bigint NOT NULL,
    "Draw" text,
    "Coin" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Sure_Recipts" text,
    "Show_Group" text,
    "Account_Balance" text,
    "Salary" text,
    "Commission" text,
    "Coin_Show" text,
    "Cost_Show" text,
    "Draw_Show" text,
    "Collect_Show" text,
    "Sales_Bill_Show" text,
    "Hide_Edit_Delete" text,
    "Order_Number" text,
    "Tax_Show" text,
    "Cost_Center_Show" text
);


ALTER TABLE public.accounts_default_data OWNER TO demorabiherp_karim;

--
-- Name: accounts_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.accounts_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.accounts_default_data_id_seq OWNER TO demorabiherp_karim;

--
-- Name: accounts_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.accounts_default_data_id_seq OWNED BY public.accounts_default_data.id;


--
-- Name: activites; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.activites (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.activites OWNER TO demorabiherp_karim;

--
-- Name: activites_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.activites_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.activites_id_seq OWNER TO demorabiherp_karim;

--
-- Name: activites_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.activites_id_seq OWNED BY public.activites.id;


--
-- Name: add_translates; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.add_translates (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Client" text,
    "Client_Type" text,
    "From_Lang" text,
    "To_Lang" text,
    "Company" text,
    "Num_Translted_Word" text,
    "ID_Name" text,
    "ID_Profession" text,
    "ID_Martial_Status" text,
    "Passport_Name" text,
    "Passport_Profession" text,
    "Passport_Martial_Status" text,
    "Extracted" text,
    "Extracted_Birthplace" text,
    "Extracted_Issuer" text,
    "CommercialRegistration" text,
    "Commercial_Name" text,
    "Commercial_Type" text,
    "Commercial_Start_Date" text,
    "Commercial_Number" text,
    "Commercial_Capital" text,
    "Commercial_Issuer" text,
    "Commercial_Address" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.add_translates OWNER TO demorabiherp_karim;

--
-- Name: add_translates_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.add_translates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.add_translates_id_seq OWNER TO demorabiherp_karim;

--
-- Name: add_translates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.add_translates_id_seq OWNED BY public.add_translates.id;


--
-- Name: additional_products; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.additional_products (
    id bigint NOT NULL,
    "Additional_Product" bigint,
    "Product" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.additional_products OWNER TO demorabiherp_karim;

--
-- Name: additional_products_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.additional_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.additional_products_id_seq OWNER TO demorabiherp_karim;

--
-- Name: additional_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.additional_products_id_seq OWNED BY public.additional_products.id;


--
-- Name: addressses; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.addressses (
    id bigint NOT NULL,
    "Address_Name" text,
    "Street" text,
    "Special_Mark" text,
    "Buliding" text,
    "Floor" text,
    "Flat" text,
    "Details" text,
    "Location" text,
    "Governrate" bigint,
    "City" bigint,
    "Place" bigint,
    "Customer" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Lat" text,
    "Lng" text
);


ALTER TABLE public.addressses OWNER TO demorabiherp_karim;

--
-- Name: addressses_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.addressses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.addressses_id_seq OWNER TO demorabiherp_karim;

--
-- Name: addressses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.addressses_id_seq OWNED BY public.addressses.id;


--
-- Name: admins; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.admins (
    id bigint NOT NULL,
    email character varying(191) NOT NULL,
    name text NOT NULL,
    password text NOT NULL,
    image text,
    phone text,
    hidden text DEFAULT '0'::text NOT NULL,
    emp text DEFAULT '0'::text NOT NULL,
    ship text DEFAULT '0'::text NOT NULL,
    vend text DEFAULT '0'::text NOT NULL,
    status text DEFAULT '0'::text NOT NULL,
    remember_token character varying(100),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    cli bigint DEFAULT 0,
    lat text,
    long text,
    account bigint,
    safe bigint,
    store bigint,
    type text,
    roles_name text,
    code text,
    token text,
    price_sale text,
    discount text,
    price_1 text,
    price_2 text,
    price_3 text,
    pos_pay text,
    executor text,
    cost_price text,
    price_level text,
    guest text,
    pos_stores text,
    pos_hold text,
    cost_price_purch text,
    cost_price_sales text,
    manu_order_precent text,
    pos_product text DEFAULT 0,
    "Cash" text,
    "Later" text,
    "Check" text,
    "Installment" text,
    "Cash_Visa" text,
    "Cash_Collection" text,
    "Delivery" text,
    "InstallmentCompanies" text,
    "Date" text,
    ticket_price text,
    ticket_discount text,
    "nameEn" text,
    package text,
    job_order_price text,
    "Visa_Network" text,
    bill_discount text,
    pos_safes text,
    expire text,
    expire_type text DEFAULT 0,
    attend_date text,
    bank text,
    "Apps" text
);


ALTER TABLE public.admins OWNER TO demorabiherp_karim;

--
-- Name: admins_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.admins_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.admins_id_seq OWNER TO demorabiherp_karim;

--
-- Name: admins_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.admins_id_seq OWNED BY public.admins.id;


--
-- Name: all_groups; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.all_groups (
    id bigint NOT NULL,
    "Group" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Name" text
);


ALTER TABLE public.all_groups OWNER TO demorabiherp_karim;

--
-- Name: all_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.all_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.all_groups_id_seq OWNER TO demorabiherp_karim;

--
-- Name: all_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.all_groups_id_seq OWNED BY public.all_groups.id;


--
-- Name: allowences_emps; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.allowences_emps (
    id bigint NOT NULL,
    "AmountAllow" text,
    "Allow" bigint,
    "Emp" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.allowences_emps OWNER TO demorabiherp_karim;

--
-- Name: allowences_emps_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.allowences_emps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.allowences_emps_id_seq OWNER TO demorabiherp_karim;

--
-- Name: allowences_emps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.allowences_emps_id_seq OWNED BY public.allowences_emps.id;


--
-- Name: apps_change_prices; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.apps_change_prices (
    id bigint NOT NULL,
    "App" text,
    "Product" text,
    "Price_One" text,
    "Price_Two" text,
    "Price_Three" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Barcode" text
);


ALTER TABLE public.apps_change_prices OWNER TO demorabiherp_karim;

--
-- Name: apps_change_prices_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.apps_change_prices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.apps_change_prices_id_seq OWNER TO demorabiherp_karim;

--
-- Name: apps_change_prices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.apps_change_prices_id_seq OWNED BY public.apps_change_prices.id;


--
-- Name: area_pincode_a_p_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.area_pincode_a_p_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.area_pincode_a_p_id_seq OWNER TO demorabiherp_karim;

--
-- Name: articles; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.articles (
    id bigint NOT NULL,
    "Image" text,
    "Sub_Image" text,
    "Date" text,
    "Arabic_Title" text,
    "English_Title" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.articles OWNER TO demorabiherp_karim;

--
-- Name: articles_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.articles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.articles_id_seq OWNER TO demorabiherp_karim;

--
-- Name: articles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.articles_id_seq OWNED BY public.articles.id;


--
-- Name: assembly_products; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.assembly_products (
    id bigint NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Total" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "Unit" bigint,
    "Product" bigint,
    p_id bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.assembly_products OWNER TO demorabiherp_karim;

--
-- Name: assembly_products_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.assembly_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.assembly_products_id_seq OWNER TO demorabiherp_karim;

--
-- Name: assembly_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.assembly_products_id_seq OWNED BY public.assembly_products.id;


--
-- Name: assets; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.assets (
    id bigint NOT NULL,
    "Code" text,
    "Name" text,
    "Asset_Type" text,
    "Depreciation_Method" text,
    "Purchases_Date" text,
    "Operation_Date" text,
    "Cost" text,
    "Previous_Depreciation" text,
    "Asset_Net" text,
    "Annual_Depreciation_Ratio" text,
    "Annual_Depreciation" text,
    "Life_Span" text,
    "Image" text,
    "Note" text,
    "Depreciation_Expenses" bigint,
    "Depreciation_Complex" bigint,
    "Main_Account" bigint,
    "Account" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Draw" text,
    "Coin" bigint,
    "Cost_Center" bigint,
    "Branch" bigint,
    "Sort_Asset" text,
    "Vendor" bigint,
    "Safe" bigint,
    "Ehlak" text,
    "Payment_Method" text,
    "M1" text,
    "M2" text,
    "M3" text,
    "M4" text,
    "M5" text,
    "M6" text,
    "M7" text,
    "M8" text,
    "M9" text,
    "M10" text,
    "M11" text,
    "M12" text,
    "NameEn" text,
    "Asset_Type_En" text,
    "Depreciation_Method_En" text,
    arr bigint,
    "Delete" text,
    "Sale" text,
    "Amount" text,
    "Client" text,
    "CurrentAssetPrice" text,
    "Last_Depreciation_Month" text
);


ALTER TABLE public.assets OWNER TO demorabiherp_karim;

--
-- Name: assets_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.assets_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.assets_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: assets_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.assets_arr_seq OWNED BY public.assets."Code";


--
-- Name: assets_expenses; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.assets_expenses (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Name" text NOT NULL,
    "Draw" text NOT NULL,
    "Amount" text NOT NULL,
    "Asset" bigint,
    "Safe" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.assets_expenses OWNER TO demorabiherp_karim;

--
-- Name: assets_expenses_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.assets_expenses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.assets_expenses_id_seq OWNER TO demorabiherp_karim;

--
-- Name: assets_expenses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.assets_expenses_id_seq OWNED BY public.assets_expenses.id;


--
-- Name: assets_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.assets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.assets_id_seq OWNER TO demorabiherp_karim;

--
-- Name: assets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.assets_id_seq OWNED BY public.assets.id;


--
-- Name: attend_departure_import; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.attend_departure_import (
    id bigint NOT NULL,
    "In_Time" text,
    "Out_Time" text,
    "Date" text,
    "Month" text,
    "Note" text,
    "Attend" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.attend_departure_import OWNER TO demorabiherp_karim;

--
-- Name: attend_departure_import_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.attend_departure_import_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attend_departure_import_id_seq OWNER TO demorabiherp_karim;

--
-- Name: attend_departure_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.attend_departure_import_id_seq OWNED BY public.attend_departure_import.id;


--
-- Name: attendance_emps; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.attendance_emps (
    id bigint NOT NULL,
    "In_Time" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Note" text,
    "Attend" bigint,
    "Emp" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.attendance_emps OWNER TO demorabiherp_karim;

--
-- Name: attendance_emps_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.attendance_emps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attendance_emps_id_seq OWNER TO demorabiherp_karim;

--
-- Name: attendance_emps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.attendance_emps_id_seq OWNED BY public.attendance_emps.id;


--
-- Name: attendances; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.attendances (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Note" text,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text,
    arr bigint
);


ALTER TABLE public.attendances OWNER TO demorabiherp_karim;

--
-- Name: attendances_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.attendances_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attendances_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: attendances_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.attendances_arr_seq OWNED BY public.attendances."Code";


--
-- Name: attendances_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.attendances_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attendances_id_seq OWNER TO demorabiherp_karim;

--
-- Name: attendances_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.attendances_id_seq OWNED BY public.attendances.id;


--
-- Name: attendence_policy_emps; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.attendence_policy_emps (
    id bigint NOT NULL,
    "From" text,
    "To" text,
    "Discount" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.attendence_policy_emps OWNER TO demorabiherp_karim;

--
-- Name: attendence_policy_emps_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.attendence_policy_emps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attendence_policy_emps_id_seq OWNER TO demorabiherp_karim;

--
-- Name: attendence_policy_emps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.attendence_policy_emps_id_seq OWNED BY public.attendence_policy_emps.id;


--
-- Name: barcode_products; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.barcode_products (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Code" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Group" text
);


ALTER TABLE public.barcode_products OWNER TO demorabiherp_karim;

--
-- Name: barcode_products_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.barcode_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.barcode_products_id_seq OWNER TO demorabiherp_karim;

--
-- Name: barcode_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.barcode_products_id_seq OWNED BY public.barcode_products.id;


--
-- Name: barcode_settings; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.barcode_settings (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Name" text NOT NULL,
    "Type" text NOT NULL,
    "Direction" text NOT NULL,
    "Width" text NOT NULL,
    "Height" text NOT NULL,
    "Padding_L" text NOT NULL,
    "Padding_R" text NOT NULL,
    "Padding_T" text NOT NULL,
    "Padding_B" text NOT NULL,
    "Margin_L" text NOT NULL,
    "Margin_R" text NOT NULL,
    "Margin_T" text NOT NULL,
    "Margin_B" text NOT NULL,
    "Barcode_Width" text NOT NULL,
    "Barcode_Height" text NOT NULL,
    "Font_Size" text NOT NULL,
    "Line_Height" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Height_Logo" character varying,
    "Width_Logo" character varying,
    "NameEn" text,
    arr bigint
);


ALTER TABLE public.barcode_settings OWNER TO demorabiherp_karim;

--
-- Name: barcode_settings_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.barcode_settings_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.barcode_settings_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: barcode_settings_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.barcode_settings_arr_seq OWNED BY public.barcode_settings.arr;


--
-- Name: barcode_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.barcode_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.barcode_settings_id_seq OWNER TO demorabiherp_karim;

--
-- Name: barcode_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.barcode_settings_id_seq OWNED BY public.barcode_settings.id;


--
-- Name: barcode_shows; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.barcode_shows (
    id bigint NOT NULL,
    "Company_Name" text,
    "Product_Name" text,
    "Product_Price" text,
    "Unit" text,
    "Coin" text,
    "Group" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Code" text,
    "Logo" text
);


ALTER TABLE public.barcode_shows OWNER TO demorabiherp_karim;

--
-- Name: barcode_shows_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.barcode_shows_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.barcode_shows_id_seq OWNER TO demorabiherp_karim;

--
-- Name: barcode_shows_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.barcode_shows_id_seq OWNED BY public.barcode_shows.id;


--
-- Name: befroe_footers; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.befroe_footers (
    id bigint NOT NULL,
    "Image" text NOT NULL,
    "Arabic_Title" text NOT NULL,
    "Arabic_Desc" text NOT NULL,
    "English_Title" text NOT NULL,
    "English_Desc" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.befroe_footers OWNER TO demorabiherp_karim;

--
-- Name: befroe_footers_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.befroe_footers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.befroe_footers_id_seq OWNER TO demorabiherp_karim;

--
-- Name: befroe_footers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.befroe_footers_id_seq OWNED BY public.befroe_footers.id;


--
-- Name: beneftis_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.beneftis_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.beneftis_types OWNER TO demorabiherp_karim;

--
-- Name: beneftis_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.beneftis_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.beneftis_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: beneftis_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.beneftis_types_id_seq OWNED BY public.beneftis_types.id;


--
-- Name: bones_sales_petrols; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.bones_sales_petrols (
    id bigint NOT NULL,
    "Bone_Amount" text NOT NULL,
    "Bone" bigint,
    "SalesPetrol" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.bones_sales_petrols OWNER TO demorabiherp_karim;

--
-- Name: bones_sales_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.bones_sales_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.bones_sales_petrols_id_seq OWNER TO demorabiherp_karim;

--
-- Name: bones_sales_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.bones_sales_petrols_id_seq OWNED BY public.bones_sales_petrols.id;


--
-- Name: bones_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.bones_types (
    id bigint NOT NULL,
    "Name" text,
    "Account" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.bones_types OWNER TO demorabiherp_karim;

--
-- Name: bones_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.bones_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.bones_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: bones_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.bones_types_id_seq OWNED BY public.bones_types.id;


--
-- Name: borrowas; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.borrowas (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Amount" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Safe" bigint NOT NULL,
    "Emp" bigint,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Delete" text DEFAULT 0
);


ALTER TABLE public.borrowas OWNER TO demorabiherp_karim;

--
-- Name: borrowas_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.borrowas_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.borrowas_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: borrowas_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.borrowas_arr_seq OWNED BY public.borrowas."Code";


--
-- Name: borrowas_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.borrowas_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.borrowas_id_seq OWNER TO demorabiherp_karim;

--
-- Name: borrowas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.borrowas_id_seq OWNED BY public.borrowas.id;


--
-- Name: branches; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.branches (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Letter" text,
    "Code" text,
    "Location" text,
    "Budget" text
);


ALTER TABLE public.branches OWNER TO demorabiherp_karim;

--
-- Name: branches_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.branches_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.branches_id_seq OWNER TO demorabiherp_karim;

--
-- Name: branches_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.branches_id_seq OWNED BY public.branches.id;


--
-- Name: brands; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.brands (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Note" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Image" text,
    "Sales_Show" text,
    "Store_Show" text,
    "NameEn" text,
    "Sales_Precet" text DEFAULT 0
);


ALTER TABLE public.brands OWNER TO demorabiherp_karim;

--
-- Name: brands_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.brands_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.brands_id_seq OWNER TO demorabiherp_karim;

--
-- Name: brands_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.brands_id_seq OWNED BY public.brands.id;


--
-- Name: campaigns; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.campaigns (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Platform" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.campaigns OWNER TO demorabiherp_karim;

--
-- Name: campaigns_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.campaigns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.campaigns_id_seq OWNER TO demorabiherp_karim;

--
-- Name: campaigns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.campaigns_id_seq OWNED BY public.campaigns.id;


--
-- Name: capital_increases; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.capital_increases (
    id bigint NOT NULL,
    "Date" text,
    "Month" text,
    "Value" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.capital_increases OWNER TO demorabiherp_karim;

--
-- Name: capital_increases_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.capital_increases_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.capital_increases_id_seq OWNER TO demorabiherp_karim;

--
-- Name: capital_increases_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.capital_increases_id_seq OWNED BY public.capital_increases.id;


--
-- Name: capitals; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.capitals (
    id bigint NOT NULL,
    "Authorized_Capital" text,
    "Source_Capital" text,
    "Shares_Number" text,
    "Nominal_Value_of_Shares" text,
    "Actual_Share_Value" text,
    "Actual_Capital" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Working_Capital" text,
    "New_Shares_Number" text,
    "Capital_Increase" text,
    "New_Source_Capital" text,
    "Total_Investment" text
);


ALTER TABLE public.capitals OWNER TO demorabiherp_karim;

--
-- Name: capitals_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.capitals_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.capitals_id_seq OWNER TO demorabiherp_karim;

--
-- Name: capitals_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.capitals_id_seq OWNED BY public.capitals.id;


--
-- Name: car_shippings; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.car_shippings (
    id bigint NOT NULL,
    "Name" text,
    "Max_Load" text,
    "Delegate" text,
    "Driver" text,
    "Car_Number" text,
    "Color" text,
    "Lisence_Expire_Date" text,
    "GPS_Num" text,
    "Car_Type" text,
    "Car_Statue" text,
    "Insurance" text,
    "Ownership" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Cost_Center" text,
    "Rent_Amount" text,
    "Deal_Type" text,
    "Deal_Amount" text,
    "Account" text,
    "AccountMerit" text,
    "Minimum" text
);


ALTER TABLE public.car_shippings OWNER TO demorabiherp_karim;

--
-- Name: car_shippings_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.car_shippings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.car_shippings_id_seq OWNER TO demorabiherp_karim;

--
-- Name: car_shippings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.car_shippings_id_seq OWNED BY public.car_shippings.id;


--
-- Name: cars_sales_petrols; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.cars_sales_petrols (
    id bigint NOT NULL,
    "Car_Amount" text NOT NULL,
    "Car" bigint,
    "SalesPetrol" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.cars_sales_petrols OWNER TO demorabiherp_karim;

--
-- Name: cars_sales_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.cars_sales_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cars_sales_petrols_id_seq OWNER TO demorabiherp_karim;

--
-- Name: cars_sales_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.cars_sales_petrols_id_seq OWNED BY public.cars_sales_petrols.id;


--
-- Name: cart_stores; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.cart_stores (
    id bigint NOT NULL,
    "Name" text,
    "NameEn" text,
    "V_Name" text,
    "VV_Name" text,
    "P_Code" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "Image" text,
    "Total" text,
    "User" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Product" text
);


ALTER TABLE public.cart_stores OWNER TO demorabiherp_karim;

--
-- Name: cart_stores_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.cart_stores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cart_stores_id_seq OWNER TO demorabiherp_karim;

--
-- Name: cart_stores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.cart_stores_id_seq OWNED BY public.cart_stores.id;


--
-- Name: chat_issues; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.chat_issues (
    id bigint NOT NULL,
    "Name" text,
    "Date" text,
    "Time" text,
    "Desc" text,
    "Image" text,
    "Issue" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text,
    "Appear" text
);


ALTER TABLE public.chat_issues OWNER TO demorabiherp_karim;

--
-- Name: chat_issues_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.chat_issues_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.chat_issues_id_seq OWNER TO demorabiherp_karim;

--
-- Name: chat_issues_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.chat_issues_id_seq OWNED BY public.chat_issues.id;


--
-- Name: checks_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.checks_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.checks_types OWNER TO demorabiherp_karim;

--
-- Name: checks_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.checks_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.checks_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: checks_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.checks_types_id_seq OWNED BY public.checks_types.id;


--
-- Name: cities; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.cities (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Gov" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Ship_Price" text,
    "Shipping_Company" text,
    "SearchCode" text,
    "ShippingCode" text
);


ALTER TABLE public.cities OWNER TO demorabiherp_karim;

--
-- Name: cities_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.cities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cities_id_seq OWNER TO demorabiherp_karim;

--
-- Name: cities_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.cities_id_seq OWNED BY public.cities.id;


--
-- Name: client_account_statement_column_sechdules; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.client_account_statement_column_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ShiftCode" text,
    "Executor" text
);


ALTER TABLE public.client_account_statement_column_sechdules OWNER TO demorabiherp_karim;

--
-- Name: client_account_statement_column_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.client_account_statement_column_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_account_statement_column_sechdules_id_seq OWNER TO demorabiherp_karim;

--
-- Name: client_account_statement_column_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.client_account_statement_column_sechdules_id_seq OWNED BY public.client_account_statement_column_sechdules.id;


--
-- Name: client_account_statement_columns; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.client_account_statement_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ShiftCode" text,
    "Executor" text
);


ALTER TABLE public.client_account_statement_columns OWNER TO demorabiherp_karim;

--
-- Name: client_account_statement_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.client_account_statement_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_account_statement_columns_id_seq OWNER TO demorabiherp_karim;

--
-- Name: client_account_statement_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.client_account_statement_columns_id_seq OWNED BY public.client_account_statement_columns.id;


--
-- Name: client_filters; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.client_filters (
    id bigint NOT NULL,
    "Product" text NOT NULL,
    "Code" text,
    "Name" text,
    "VName" text,
    "VVName" text,
    "V1" text,
    "V2" text,
    "Qty" text,
    "Price" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Client" text
);


ALTER TABLE public.client_filters OWNER TO demorabiherp_karim;

--
-- Name: client_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.client_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_filters_id_seq OWNER TO demorabiherp_karim;

--
-- Name: client_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.client_filters_id_seq OWNED BY public.client_filters.id;


--
-- Name: client_sales_petrols; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.client_sales_petrols (
    id bigint NOT NULL,
    "Customer_Amount" text NOT NULL,
    "Customer" bigint,
    "SalesPetrol" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.client_sales_petrols OWNER TO demorabiherp_karim;

--
-- Name: client_sales_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.client_sales_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_sales_petrols_id_seq OWNER TO demorabiherp_karim;

--
-- Name: client_sales_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.client_sales_petrols_id_seq OWNED BY public.client_sales_petrols.id;


--
-- Name: client_statuses; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.client_statuses (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.client_statuses OWNER TO demorabiherp_karim;

--
-- Name: client_statuses_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.client_statuses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_statuses_id_seq OWNER TO demorabiherp_karim;

--
-- Name: client_statuses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.client_statuses_id_seq OWNED BY public.client_statuses.id;


--
-- Name: clients_statements_column_sechdules; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.clients_statements_column_sechdules (
    id bigint NOT NULL,
    "Account_Code" text,
    "Account_Name" text,
    "Debiator_Before" text,
    "Creditor_Before" text,
    "Total_Debitor" text,
    "Total_Creditor" text,
    "Debitor_Balance" text,
    "Creditor_Balance" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.clients_statements_column_sechdules OWNER TO demorabiherp_karim;

--
-- Name: clients_statements_column_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.clients_statements_column_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.clients_statements_column_sechdules_id_seq OWNER TO demorabiherp_karim;

--
-- Name: clients_statements_column_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.clients_statements_column_sechdules_id_seq OWNED BY public.clients_statements_column_sechdules.id;


--
-- Name: clients_statements_columns; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.clients_statements_columns (
    id bigint NOT NULL,
    "Account_Code" text,
    "Account_Name" text,
    "Debiator_Before" text,
    "Creditor_Before" text,
    "Total_Debitor" text,
    "Total_Creditor" text,
    "Debitor_Balance" text,
    "Creditor_Balance" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.clients_statements_columns OWNER TO demorabiherp_karim;

--
-- Name: clients_statements_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.clients_statements_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.clients_statements_columns_id_seq OWNER TO demorabiherp_karim;

--
-- Name: clients_statements_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.clients_statements_columns_id_seq OWNED BY public.clients_statements_columns.id;


--
-- Name: coins; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.coins (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Draw" text,
    "Symbol" text,
    "Code" text
);


ALTER TABLE public.coins OWNER TO demorabiherp_karim;

--
-- Name: coins_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.coins_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.coins_id_seq OWNER TO demorabiherp_karim;

--
-- Name: coins_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.coins_id_seq OWNED BY public.coins.id;


--
-- Name: comments; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.comments (
    id bigint NOT NULL,
    "Comment" text NOT NULL,
    "Date" text NOT NULL,
    "Product" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.comments OWNER TO demorabiherp_karim;

--
-- Name: comments_clients; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.comments_clients (
    id bigint NOT NULL,
    "Comment" text,
    "Responsible" bigint,
    "Customer" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "CommentEn" text,
    "Code" text,
    "Date" text,
    "Rate" text,
    "Visit_Cost" text,
    "Note" text,
    "Time" text,
    "Type" text,
    lat text,
    lng text,
    "Voice" text
);


ALTER TABLE public.comments_clients OWNER TO demorabiherp_karim;

--
-- Name: comments_clients_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.comments_clients_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.comments_clients_id_seq OWNER TO demorabiherp_karim;

--
-- Name: comments_clients_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.comments_clients_id_seq OWNED BY public.comments_clients.id;


--
-- Name: comments_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.comments_id_seq OWNER TO demorabiherp_karim;

--
-- Name: comments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.comments_id_seq OWNED BY public.comments.id;


--
-- Name: company_cars; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.company_cars (
    id bigint NOT NULL,
    "Name" text,
    "Number" text,
    "Account" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.company_cars OWNER TO demorabiherp_karim;

--
-- Name: company_cars_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.company_cars_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.company_cars_id_seq OWNER TO demorabiherp_karim;

--
-- Name: company_cars_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.company_cars_id_seq OWNED BY public.company_cars.id;


--
-- Name: company_data; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.company_data (
    id bigint NOT NULL,
    "Name" text,
    "Phone1" text,
    "Phone2" text,
    "Address" text,
    "Commercial_Record" text,
    "Tax_File_Number" text,
    "Logo" text,
    "Icon" text,
    "Print_Text" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Print_Text_Footer" text,
    "Seal" text,
    "Print_Text_Footer_Sales" text,
    "Name_Sales_Bill" text,
    "Name_Sales_Order_Bill" text,
    "Print_Text_Footer_Quote" text,
    "Name_Quote_Bill" text,
    "Print_Text_Footer_Secretariat" text,
    "Logo_Store" text,
    "Phone3" text,
    "Phone4" text,
    "Icon_Store" text,
    "View" text,
    "Tax_Registration_Number" text,
    "Tax_activity_code" text,
    work_nature text,
    "Governrate" text,
    "City" text,
    "Place" text,
    "Nationality" text,
    "Buliding_Num" text,
    "Street" text,
    "Postal_Code" text,
    tax_magistrate text,
    "Client_ID" text,
    "Serial_Client_ID" text,
    "Version_Type" text,
    "Computer_SN" text,
    "Invoice_Type" text,
    "Floor" text,
    "Room" text,
    "Landmark" text,
    "Add_Info" text,
    "Print_Text_Footer_Manufacturing" text,
    "POS_Version" text,
    "Path" text,
    "DB_Backup" text,
    "NameEn" text,
    "Print_Text_En" text,
    "Print_Text_Footer_En" text,
    "Print_Text_Footer_Manufacturing_En" text,
    "Print_Text_Footer_Sales_En" text,
    "Print_Text_Footer_Quote_En" text,
    "Print_Text_Footer_Secretariat_En" text,
    "Name_Sales_Bill_En" text,
    "Name_Sales_Order_Bill_En" text,
    "Name_Quote_Bill_En" text,
    "AddressEn" text,
    "HomeMainScreen" text,
    "PDF" text,
    "Email" text,
    "Location" text,
    "Bill_View" text,
    "Font_Type" text,
    "Welcome_Arabic_Word_App" text,
    "Welcome_English_Word_App" text,
    "Domain" text,
    "Serial_App" text,
    "Attend_Lat" text,
    "Attend_Lng" text,
    "Attend_Space" text,
    "Attend_Time_Before" text,
    "Attend_Time_After" text,
    "Departure_Time_Before" text,
    "Departure_Time_After" text,
    "Verfification_Time" text,
    "Organaziation_Common_Name" text,
    "Organaziation_Name" text,
    "Organaziation_Tax_ID" text,
    "Organaziation_Address" text,
    "Organaziation_Department" text,
    "Organaziation_Category" text,
    "ZATCA_Production" text,
    "OTP_Status" text DEFAULT 0,
    "Use_Zatca" text DEFAULT 0,
    "Backup_Time" text,
    "Purchases_Print_View" text,
    "Purchases_Order_Print_View" text,
    "Sales_Order_Print_View" text,
    "Quote_Print_View" text
);


ALTER TABLE public.company_data OWNER TO demorabiherp_karim;

--
-- Name: company_data_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.company_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.company_data_id_seq OWNER TO demorabiherp_karim;

--
-- Name: company_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.company_data_id_seq OWNED BY public.company_data.id;


--
-- Name: compare_prices_columns; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.compare_prices_columns (
    id bigint NOT NULL,
    "Date" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Credit" text,
    "Group" text,
    "Brand" text,
    "Store" text,
    "User" text,
    "Safe" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.compare_prices_columns OWNER TO demorabiherp_karim;

--
-- Name: compare_prices_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.compare_prices_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.compare_prices_columns_id_seq OWNER TO demorabiherp_karim;

--
-- Name: compare_prices_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.compare_prices_columns_id_seq OWNED BY public.compare_prices_columns.id;


--
-- Name: compare_prices_columns_sechdules; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.compare_prices_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Credit" text,
    "Group" text,
    "Brand" text,
    "Store" text,
    "User" text,
    "Safe" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.compare_prices_columns_sechdules OWNER TO demorabiherp_karim;

--
-- Name: compare_prices_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.compare_prices_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.compare_prices_columns_sechdules_id_seq OWNER TO demorabiherp_karim;

--
-- Name: compare_prices_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.compare_prices_columns_sechdules_id_seq OWNED BY public.compare_prices_columns_sechdules.id;


--
-- Name: compare_prices_filter_twos; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.compare_prices_filter_twos (
    id bigint NOT NULL,
    "Date" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Current" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "Unit" text,
    "Group" text,
    "Store" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "User" text,
    "CostIn" text,
    "CostOut" text,
    "CostCurrent" text,
    "CostOneIn" text,
    "CostOneOut" text,
    "CostOneCurrent" text,
    "QTY" text,
    "Brand" text,
    "Safe" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.compare_prices_filter_twos OWNER TO demorabiherp_karim;

--
-- Name: compare_prices_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.compare_prices_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.compare_prices_filter_twos_id_seq OWNER TO demorabiherp_karim;

--
-- Name: compare_prices_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.compare_prices_filter_twos_id_seq OWNED BY public.compare_prices_filter_twos.id;


--
-- Name: compare_prices_filters; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.compare_prices_filters (
    id bigint NOT NULL,
    "Date" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Current" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "Unit" text,
    "Group" text,
    "Store" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "User" text,
    "CostIn" text,
    "CostOut" text,
    "CostCurrent" text,
    "CostOneIn" text,
    "CostOneOut" text,
    "CostOneCurrent" text,
    "QTY" text,
    "Brand" text,
    "Safe" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.compare_prices_filters OWNER TO demorabiherp_karim;

--
-- Name: compare_prices_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.compare_prices_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.compare_prices_filters_id_seq OWNER TO demorabiherp_karim;

--
-- Name: compare_prices_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.compare_prices_filters_id_seq OWNED BY public.compare_prices_filters.id;


--
-- Name: compares; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.compares (
    id bigint NOT NULL,
    "Product" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.compares OWNER TO demorabiherp_karim;

--
-- Name: compares_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.compares_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.compares_id_seq OWNER TO demorabiherp_karim;

--
-- Name: compares_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.compares_id_seq OWNED BY public.compares.id;


--
-- Name: competitors; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.competitors (
    id bigint NOT NULL,
    "Facebook" character varying(191),
    "Twitter" character varying(191),
    "Instagram" character varying(191),
    "Name" character varying(191),
    "Country" text,
    "Whatsapp" character varying(191),
    "Addtional_Link" character varying(191),
    "Phone" character varying(191),
    "Pinterest" character varying(191),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text,
    "Website" text
);


ALTER TABLE public.competitors OWNER TO demorabiherp_karim;

--
-- Name: competitors_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.competitors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.competitors_id_seq OWNER TO demorabiherp_karim;

--
-- Name: competitors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.competitors_id_seq OWNED BY public.competitors.id;


--
-- Name: consist_maintainces; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.consist_maintainces (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "Exp_Date" text,
    "Store" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "Maintaince" text,
    "TDiscount" text,
    "Group" text,
    "Brand" text,
    "Code" text,
    "Date" text,
    "Note" text,
    "Serial_Num" text,
    "Total_Price" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_Cost" text,
    "Total_Bf_Taxes" text,
    "Total_Taxes" text,
    "Draw" text,
    "Company" text,
    "Device_Type" text,
    "Device_Case" text,
    "Coin" text,
    "Cost_Center" text,
    "Account" text,
    "User" text,
    "Status" text,
    "Pattern_Image" text,
    "Time" text,
    "Payment_Method" text,
    "Password" text,
    "Pay" text,
    "Eng_Note" text,
    "Reason" text,
    "Report_Client" text,
    "Work" text,
    "StoreMain" text,
    "Eng" text,
    "Recipient" text,
    "Branch" text,
    "RefuseReason" text,
    "NoteRecived" text,
    "Returned" text,
    "CustomerGroup" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.consist_maintainces OWNER TO demorabiherp_karim;

--
-- Name: consist_maintainces_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.consist_maintainces_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.consist_maintainces_id_seq OWNER TO demorabiherp_karim;

--
-- Name: consist_maintainces_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.consist_maintainces_id_seq OWNED BY public.consist_maintainces.id;


--
-- Name: consists; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.consists (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Darw" text NOT NULL,
    "Products_Number" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Account" bigint NOT NULL,
    "Store" bigint,
    "Coin" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Time" text,
    "Branch" text,
    arr bigint,
    "Delete" text DEFAULT 0
);


ALTER TABLE public.consists OWNER TO demorabiherp_karim;

--
-- Name: consists_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.consists_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.consists_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: consists_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.consists_arr_seq OWNED BY public.consists.arr;


--
-- Name: consists_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.consists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.consists_id_seq OWNER TO demorabiherp_karim;

--
-- Name: consists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.consists_id_seq OWNED BY public.consists.id;


--
-- Name: contact_u_s; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.contact_u_s (
    id bigint NOT NULL,
    "Map" text,
    "Arabic_Title" text,
    "English_Title" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    "Opening_Hours" text,
    "Phone1" text,
    "Phone2" text,
    "Phone_Header" text,
    "Email" text,
    "Arabic_Address" text,
    "English_Address" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.contact_u_s OWNER TO demorabiherp_karim;

--
-- Name: contact_u_s_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.contact_u_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.contact_u_s_id_seq OWNER TO demorabiherp_karim;

--
-- Name: contact_u_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.contact_u_s_id_seq OWNED BY public.contact_u_s.id;


--
-- Name: contract_statuses; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.contract_statuses (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.contract_statuses OWNER TO demorabiherp_karim;

--
-- Name: contract_statuses_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.contract_statuses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.contract_statuses_id_seq OWNER TO demorabiherp_karim;

--
-- Name: contract_statuses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.contract_statuses_id_seq OWNED BY public.contract_statuses.id;


--
-- Name: contractors_real_projects; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.contractors_real_projects (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Expenses_Account" text,
    "Merit_Account" text,
    "Project" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.contractors_real_projects OWNER TO demorabiherp_karim;

--
-- Name: contractors_real_projects_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.contractors_real_projects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.contractors_real_projects_id_seq OWNER TO demorabiherp_karim;

--
-- Name: contractors_real_projects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.contractors_real_projects_id_seq OWNED BY public.contractors_real_projects.id;


--
-- Name: cost_centers; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.cost_centers (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Parent" text DEFAULT 0,
    "Type" text DEFAULT 0
);


ALTER TABLE public.cost_centers OWNER TO demorabiherp_karim;

--
-- Name: cost_centers_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.cost_centers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cost_centers_id_seq OWNER TO demorabiherp_karim;

--
-- Name: cost_centers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.cost_centers_id_seq OWNED BY public.cost_centers.id;


--
-- Name: counters_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.counters_types (
    id bigint NOT NULL,
    "Name" text,
    "Current_Read" text,
    "Store" bigint,
    "Product" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.counters_types OWNER TO demorabiherp_karim;

--
-- Name: counters_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.counters_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.counters_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: counters_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.counters_types_id_seq OWNED BY public.counters_types.id;


--
-- Name: countris; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.countris (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text NOT NULL,
    "Flag" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Safe" text,
    "Coin" text,
    "Store" text,
    "Code" text,
    "SearchCode" text
);


ALTER TABLE public.countris OWNER TO demorabiherp_karim;

--
-- Name: countris_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.countris_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.countris_id_seq OWNER TO demorabiherp_karim;

--
-- Name: countris_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.countris_id_seq OWNED BY public.countris.id;


--
-- Name: coupon_codes; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.coupon_codes (
    id bigint NOT NULL,
    "Code" text,
    "Amount" text,
    "Status" text,
    "Num" text,
    "Used" text,
    "Expire" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.coupon_codes OWNER TO demorabiherp_karim;

--
-- Name: coupon_codes_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.coupon_codes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.coupon_codes_id_seq OWNER TO demorabiherp_karim;

--
-- Name: coupon_codes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.coupon_codes_id_seq OWNED BY public.coupon_codes.id;


--
-- Name: courses; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.courses (
    id bigint NOT NULL,
    "Code" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    "Category" text,
    "Lec_Num" text,
    "Hours" text,
    "Subject" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Note" text
);


ALTER TABLE public.courses OWNER TO demorabiherp_karim;

--
-- Name: courses_categories; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.courses_categories (
    id bigint NOT NULL,
    "Image" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.courses_categories OWNER TO demorabiherp_karim;

--
-- Name: courses_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.courses_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.courses_categories_id_seq OWNER TO demorabiherp_karim;

--
-- Name: courses_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.courses_categories_id_seq OWNED BY public.courses_categories.id;


--
-- Name: courses_halls; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.courses_halls (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Chairs_Num" text,
    "Wiifii" text,
    "Air_Condition" text,
    "Place" text,
    "Number" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.courses_halls OWNER TO demorabiherp_karim;

--
-- Name: courses_halls_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.courses_halls_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.courses_halls_id_seq OWNER TO demorabiherp_karim;

--
-- Name: courses_halls_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.courses_halls_id_seq OWNED BY public.courses_halls.id;


--
-- Name: courses_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.courses_id_seq OWNER TO demorabiherp_karim;

--
-- Name: courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.courses_id_seq OWNED BY public.courses.id;


--
-- Name: courses_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.courses_types (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.courses_types OWNER TO demorabiherp_karim;

--
-- Name: courses_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.courses_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.courses_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: courses_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.courses_types_id_seq OWNED BY public.courses_types.id;


--
-- Name: crm_default_data; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.crm_default_data (
    id bigint NOT NULL,
    "Price_Level" text,
    "Governrate" bigint,
    "City" bigint,
    "Responsible" bigint,
    "Activity" bigint,
    "Campagin" bigint,
    "ClientStatus" bigint,
    "Platforms" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Client_Delegate" text DEFAULT 0,
    "Nationality" text,
    "ClientGroup" text
);


ALTER TABLE public.crm_default_data OWNER TO demorabiherp_karim;

--
-- Name: crm_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.crm_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.crm_default_data_id_seq OWNER TO demorabiherp_karim;

--
-- Name: crm_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.crm_default_data_id_seq OWNED BY public.crm_default_data.id;


--
-- Name: custom_prints; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.custom_prints (
    id bigint NOT NULL,
    "Sales_Print_Type" text,
    "Sales_Bill_Code" text,
    "Sales_Date" text,
    "Sales_Coin" text,
    "Sales_Draw" text,
    "Sales_Payment_Method" text,
    "Sales_Status" text,
    "Sales_Executor" text,
    "Sales_Refernce_Number" text,
    "Sales_Safe" text,
    "Sales_Client" text,
    "Sales_Delegate" text,
    "Sales_Store" text,
    "Sales_User" text,
    "Sales_Cost_Center" text,
    "Sales_Notes" text,
    "Sales_Pro_Code" text,
    "Sales_Pro_Name" text,
    "Sales_Pro_Unit" text,
    "Sales_Pro_Qty" text,
    "Sales_Pro_Price" text,
    "Sales_Pro_Discount" text,
    "Sales_Pro_Total_Bf_Tax" text,
    "Sales_Pro_Total_Tax" text,
    "Sales_Pro_Total" text,
    "Sales_Pro_Store" text,
    "Sales_Pro_Desc" text,
    "Sales_Pro_Exp_Date" text,
    "Sales_Pro_Weight" text,
    "Sales_Pro_Patch_Number" text,
    "Sales_Product_Numbers" text,
    "Sales_Total_Qty" text,
    "Sales_Total_Discount" text,
    "Sales_Total_Bf_Taxes" text,
    "Sales_Total_Taxes" text,
    "Sales_Total_Price" text,
    "Sales_Paid" text,
    "Sales_Residual" text,
    "Sales_Taknet" text,
    "Sales_Credit" text,
    "Sales_Barcode" text,
    "Sales_Text" text,
    "Sales_Seal" text,
    "Purch_Print_Type" text,
    "Purch_Bill_Code" text,
    "Purch_Date" text,
    "Purch_Vendor_Bill_Date" text,
    "Purch_Coin" text,
    "Purch_Draw" text,
    "Purch_Payment_Method" text,
    "Purch_Status" text,
    "Purch_Refernce_Number" text,
    "Purch_Safe" text,
    "Purch_Vendor" text,
    "Purch_Delegate" text,
    "Purch_Store" text,
    "Purch_User" text,
    "Purch_Cost_Center" text,
    "Purch_Notes" text,
    "Purch_Pro_Code" text,
    "Purch_Pro_Name" text,
    "Purch_Pro_Unit" text,
    "Purch_Pro_Qty" text,
    "Purch_Pro_Price" text,
    "Purch_Pro_Discount" text,
    "Purch_Pro_Total_Bf_Tax" text,
    "Purch_Pro_Total_Tax" text,
    "Purch_Pro_Total" text,
    "Purch_Pro_Store" text,
    "Purch_Pro_Exp_Date" text,
    "Purch_Product_Numbers" text,
    "Purch_Total_Qty" text,
    "Purch_Total_Discount" text,
    "Purch_Total_Bf_Taxes" text,
    "Purch_Total_Taxes" text,
    "Purch_Total_Price" text,
    "Purch_Paid" text,
    "Purch_Residual" text,
    "Purch_Taknet" text,
    "Purch_Credit" text,
    "Purch_Barcode" text,
    "Purch_Text" text,
    "Purch_Seal" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Sales_Client_Phone" text,
    "Sales_Resdiual" text,
    "Sales_Total_Return" text,
    "Sales_Client_Address" text,
    "Sales_Pro_Total_Net" text,
    "Purch_Pro_Total_Net" text
);


ALTER TABLE public.custom_prints OWNER TO demorabiherp_karim;

--
-- Name: custom_prints_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.custom_prints_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.custom_prints_id_seq OWNER TO demorabiherp_karim;

--
-- Name: custom_prints_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.custom_prints_id_seq OWNED BY public.custom_prints.id;


--
-- Name: customer_comments_products; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.customer_comments_products (
    id bigint NOT NULL,
    "Product" bigint NOT NULL,
    "Comment" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.customer_comments_products OWNER TO demorabiherp_karim;

--
-- Name: customer_comments_products_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.customer_comments_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customer_comments_products_id_seq OWNER TO demorabiherp_karim;

--
-- Name: customer_comments_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.customer_comments_products_id_seq OWNED BY public.customer_comments_products.id;


--
-- Name: customer_follow_ups; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.customer_follow_ups (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Client" text,
    "Subject" text,
    "Rate" text,
    "Emp" text,
    "Visit_Cost" text,
    "Note" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.customer_follow_ups OWNER TO demorabiherp_karim;

--
-- Name: customer_follow_ups_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.customer_follow_ups_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customer_follow_ups_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: customer_follow_ups_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.customer_follow_ups_arr_seq OWNED BY public.customer_follow_ups.arr;


--
-- Name: customer_follow_ups_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.customer_follow_ups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customer_follow_ups_id_seq OWNER TO demorabiherp_karim;

--
-- Name: customer_follow_ups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.customer_follow_ups_id_seq OWNED BY public.customer_follow_ups.id;


--
-- Name: customers; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.customers (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text,
    "Name" text NOT NULL,
    "Price_Level" text,
    "Phone" text,
    email text,
    password text,
    "ID_Number" text,
    "Address" text,
    "Qualifications" text,
    "Birthdate" text,
    "Social_Status" text,
    "Passport_Number" text,
    "Company_Name" text,
    "Commercial_Registration_No" text,
    "Tax_Card_No" text,
    "Bank_Account" text,
    "Image" text,
    "Next_Time" text,
    "Executions_Status" text,
    "Governrate" bigint,
    "City" bigint,
    "Responsible" bigint,
    "Activity" bigint,
    "Campagin" bigint,
    "ClientStatus" bigint,
    "Account" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Platform" bigint,
    "Contract_Start" text,
    "Contract_End" text,
    code text,
    country text,
    "Tax_Registration_Number" text,
    "Tax_activity_code" text,
    work_nature text,
    "Buliding_Num" text,
    "Street" text,
    "Postal_Code" text,
    tax_magistrate text,
    "Floor" text,
    "Room" text,
    "Landmark" text,
    "Add_Info" text,
    "Phone2" text,
    "Phone3" text,
    "Phone4" text,
    "Warranty" text,
    "Group" bigint,
    "Place" bigint,
    "Nationality" bigint,
    "Product" bigint,
    token text,
    "NameEn" text,
    arr bigint,
    "SearchCode" text,
    "Credit_Limit" text,
    "Respon_Person" text,
    "Respon_Person_Phone" text,
    "Operating_Date" text,
    "Activation_Serial" text,
    "Activation_Code" text,
    "Repayment_Period" text,
    "SecurityInquiry" text,
    "ReasonSecurityInquiry" text,
    "FieldInquiry" text,
    "ResonFieldInquiry" text,
    "Lat" text,
    "Lang" text,
    "Guarantor" text
);


ALTER TABLE public.customers OWNER TO demorabiherp_karim;

--
-- Name: customers_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.customers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: customers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.customers_arr_seq OWNED BY public.customers.arr;


--
-- Name: customers_files; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.customers_files (
    id bigint NOT NULL,
    "File" text NOT NULL,
    "Customer" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.customers_files OWNER TO demorabiherp_karim;

--
-- Name: customers_files_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.customers_files_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_files_id_seq OWNER TO demorabiherp_karim;

--
-- Name: customers_files_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.customers_files_id_seq OWNED BY public.customers_files.id;


--
-- Name: customers_groups; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.customers_groups (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Discount" text
);


ALTER TABLE public.customers_groups OWNER TO demorabiherp_karim;

--
-- Name: customers_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.customers_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_groups_id_seq OWNER TO demorabiherp_karim;

--
-- Name: customers_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.customers_groups_id_seq OWNED BY public.customers_groups.id;


--
-- Name: customers_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.customers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_id_seq OWNER TO demorabiherp_karim;

--
-- Name: customers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.customers_id_seq OWNED BY public.customers.id;


--
-- Name: customers_rate_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.customers_rate_types (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.customers_rate_types OWNER TO demorabiherp_karim;

--
-- Name: customers_rate_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.customers_rate_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_rate_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: customers_rate_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.customers_rate_types_id_seq OWNED BY public.customers_rate_types.id;


--
-- Name: customers_tickets; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.customers_tickets (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Problem" text NOT NULL,
    "Status" text NOT NULL,
    "Bill_Number" text,
    "Responsible" bigint,
    "Customer" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ProblemEn" text,
    arr bigint,
    "TicketIssues" text,
    "Date" text
);


ALTER TABLE public.customers_tickets OWNER TO demorabiherp_karim;

--
-- Name: customers_tickets_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.customers_tickets_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_tickets_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: customers_tickets_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.customers_tickets_arr_seq OWNED BY public.customers_tickets.arr;


--
-- Name: customers_tickets_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.customers_tickets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_tickets_id_seq OWNER TO demorabiherp_karim;

--
-- Name: customers_tickets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.customers_tickets_id_seq OWNED BY public.customers_tickets.id;


--
-- Name: deducations_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.deducations_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.deducations_types OWNER TO demorabiherp_karim;

--
-- Name: deducations_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.deducations_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.deducations_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: deducations_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.deducations_types_id_seq OWNED BY public.deducations_types.id;


--
-- Name: deductions; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.deductions (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Amount" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Emp" bigint,
    "Coin" bigint NOT NULL,
    "Type" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.deductions OWNER TO demorabiherp_karim;

--
-- Name: deductions_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.deductions_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.deductions_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: deductions_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.deductions_arr_seq OWNED BY public.deductions.arr;


--
-- Name: deductions_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.deductions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.deductions_id_seq OWNER TO demorabiherp_karim;

--
-- Name: deductions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.deductions_id_seq OWNED BY public.deductions.id;


--
-- Name: default_data_show_hides; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.default_data_show_hides (
    id bigint NOT NULL,
    "Status" text,
    "Shipping_Company" text,
    "Vendor_Date" text,
    "Expire_Date" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Coin" text,
    "Draw" text,
    "Delegate_Sale" text,
    "Delegate_Purchase" text,
    "Note" text,
    "Refrence_Number" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Cost_Center" text,
    "Branch" text,
    "Serial_Num" text,
    "Pass" text,
    "Pattern_Image" text,
    "Barcode_Print" text,
    "Unit_Print" text,
    "Total_BF_Print" text,
    "Discount_Print" text,
    "Tax_Print" text,
    "A5" text,
    "A4" text,
    "CM8" text,
    "Group_Brand" text,
    "Patch_Number" text,
    "Manufacturing_Model_Shortcomings" text,
    "Search_Typical" text,
    "Validity_Product" text,
    "Executor_Sale" text,
    "Totuch_Screen" text,
    "Tax_POS" text,
    "TotalDiscountPrint" text,
    "TotalTaxPrint" text,
    "ProductsNumber" text,
    "TotalQtyPrint" text,
    "Credit" text,
    "Barcode" text,
    "Taknet" text,
    "Address" text,
    "Phone1" text,
    "Phone2" text,
    "Phone3" text,
    "Phone4" text,
    "Text" text,
    "Seal" text,
    "Code_Report" text,
    "Unit" text,
    "Refrence_Number_Print" text,
    "Icon_Payment_Recipt" text,
    "SearchCode" text,
    "TaxOnTotal" text,
    "TotalBfTax" text,
    "AvQty" text,
    "Disc" text,
    "Tax" text,
    "Store" text,
    "TaxBill" text,
    "Change_Way_Stores_Transfer" text,
    "Note_POS" text,
    "Open_Drawer" text,
    client_delivery text,
    "POS_RecivedDate" text,
    "POS_Barcode" text,
    "POS_Qty" text,
    "Show_File_InsurancePaper" text,
    "Show_File_Checks" text,
    "Show_File_Purchases" text,
    "Show_File_Sales" text,
    "Show_File_PaymentVoucher" text,
    "Show_File_ReciptVoucher" text,
    "Show_File_TransferStores" text,
    "Thickness_Print" text,
    "Height_Print" text,
    "Thickness" text,
    "Height" text,
    "Items_Guide_Store_Show" text,
    "Sales_Pro_Desc" text,
    "Show_Barcode" text,
    "Show_Net" text,
    "Show_Unit" text,
    "Show_Total" text,
    "ChassisNumber" text,
    "MotorNumber" text,
    "Shipping_Price" text,
    "OpenInputTransferSales" text DEFAULT 0
);


ALTER TABLE public.default_data_show_hides OWNER TO demorabiherp_karim;

--
-- Name: default_data_show_hides_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.default_data_show_hides_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.default_data_show_hides_id_seq OWNER TO demorabiherp_karim;

--
-- Name: default_data_show_hides_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.default_data_show_hides_id_seq OWNED BY public.default_data_show_hides.id;


--
-- Name: delivery_apps; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.delivery_apps (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Type" text,
    "Account" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.delivery_apps OWNER TO demorabiherp_karim;

--
-- Name: delivery_apps_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.delivery_apps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.delivery_apps_id_seq OWNER TO demorabiherp_karim;

--
-- Name: delivery_apps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.delivery_apps_id_seq OWNED BY public.delivery_apps.id;


--
-- Name: depaarture_policy_emps; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.depaarture_policy_emps (
    id bigint NOT NULL,
    "From" text,
    "To" text,
    "Discount" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.depaarture_policy_emps OWNER TO demorabiherp_karim;

--
-- Name: depaarture_policy_emps_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.depaarture_policy_emps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.depaarture_policy_emps_id_seq OWNER TO demorabiherp_karim;

--
-- Name: depaarture_policy_emps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.depaarture_policy_emps_id_seq OWNED BY public.depaarture_policy_emps.id;


--
-- Name: departure_emps; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.departure_emps (
    id bigint NOT NULL,
    "In_Time" text NOT NULL,
    "Out_Time" text NOT NULL,
    "Hours_Number" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Note" text,
    "Departure" bigint,
    "Emp" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Disc_Late" text,
    "Disc_Early" text
);


ALTER TABLE public.departure_emps OWNER TO demorabiherp_karim;

--
-- Name: departure_emps_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.departure_emps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.departure_emps_id_seq OWNER TO demorabiherp_karim;

--
-- Name: departure_emps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.departure_emps_id_seq OWNED BY public.departure_emps.id;


--
-- Name: departures; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.departures (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Note" text,
    "Attend" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.departures OWNER TO demorabiherp_karim;

--
-- Name: departures_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.departures_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.departures_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: departures_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.departures_arr_seq OWNED BY public.departures.arr;


--
-- Name: departures_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.departures_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.departures_id_seq OWNER TO demorabiherp_karim;

--
-- Name: departures_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.departures_id_seq OWNED BY public.departures.id;


--
-- Name: desvice_cases; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.desvice_cases (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.desvice_cases OWNER TO demorabiherp_karim;

--
-- Name: desvice_cases_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.desvice_cases_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.desvice_cases_id_seq OWNER TO demorabiherp_karim;

--
-- Name: desvice_cases_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.desvice_cases_id_seq OWNED BY public.desvice_cases.id;


--
-- Name: device_descrips; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.device_descrips (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Sort" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.device_descrips OWNER TO demorabiherp_karim;

--
-- Name: device_descrips_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.device_descrips_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.device_descrips_id_seq OWNER TO demorabiherp_karim;

--
-- Name: device_descrips_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.device_descrips_id_seq OWNED BY public.device_descrips.id;


--
-- Name: devices_typesies; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.devices_typesies (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Company" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.devices_typesies OWNER TO demorabiherp_karim;

--
-- Name: devices_typesies_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.devices_typesies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.devices_typesies_id_seq OWNER TO demorabiherp_karim;

--
-- Name: devices_typesies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.devices_typesies_id_seq OWNED BY public.devices_typesies.id;


--
-- Name: disclaimers; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.disclaimers (
    id bigint NOT NULL,
    "Date" text,
    "File" text,
    "Emp" text,
    "Note" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.disclaimers OWNER TO demorabiherp_karim;

--
-- Name: disclaimers_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.disclaimers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.disclaimers_id_seq OWNER TO demorabiherp_karim;

--
-- Name: disclaimers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.disclaimers_id_seq OWNED BY public.disclaimers.id;


--
-- Name: discounts_emps; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.discounts_emps (
    id bigint NOT NULL,
    "AmountDiscount" text,
    "Discount" bigint,
    "Emp" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.discounts_emps OWNER TO demorabiherp_karim;

--
-- Name: discounts_emps_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.discounts_emps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.discounts_emps_id_seq OWNER TO demorabiherp_karim;

--
-- Name: discounts_emps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.discounts_emps_id_seq OWNED BY public.discounts_emps.id;


--
-- Name: domains; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.domains (
    id integer NOT NULL,
    domain character varying(255) NOT NULL,
    tenant_id character varying(191) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.domains OWNER TO demorabiherp_karim;

--
-- Name: domains_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.domains_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.domains_id_seq OWNER TO demorabiherp_karim;

--
-- Name: domains_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.domains_id_seq OWNED BY public.domains.id;


--
-- Name: emp_covenants; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.emp_covenants (
    id bigint NOT NULL,
    "Emp" text,
    "Date" text,
    "Name" text,
    "Price" text,
    "Reason" text,
    "Life_Expectancy" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_covenants OWNER TO demorabiherp_karim;

--
-- Name: emp_covenants_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.emp_covenants_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_covenants_id_seq OWNER TO demorabiherp_karim;

--
-- Name: emp_covenants_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.emp_covenants_id_seq OWNED BY public.emp_covenants.id;


--
-- Name: emp_excs; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.emp_excs (
    id bigint NOT NULL,
    "Name" text,
    "Account" text,
    "Emp_Type" text,
    "Salary" text,
    "Phone" text,
    "Job" text,
    "Department" text,
    "Store1" text,
    "Store2" text,
    "Store3" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_excs OWNER TO demorabiherp_karim;

--
-- Name: emp_excs_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.emp_excs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_excs_id_seq OWNER TO demorabiherp_karim;

--
-- Name: emp_excs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.emp_excs_id_seq OWNED BY public.emp_excs.id;


--
-- Name: emp_installment_details; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.emp_installment_details (
    id bigint NOT NULL,
    "Date" text,
    "Value" text,
    "Status" text,
    "Emp" bigint,
    "Install" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_installment_details OWNER TO demorabiherp_karim;

--
-- Name: emp_installment_details_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.emp_installment_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_installment_details_id_seq OWNER TO demorabiherp_karim;

--
-- Name: emp_installment_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.emp_installment_details_id_seq OWNED BY public.emp_installment_details.id;


--
-- Name: emp_installments; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.emp_installments (
    id bigint NOT NULL,
    "Amount" text NOT NULL,
    "Years_Number" text NOT NULL,
    "First_Date" text NOT NULL,
    "Install" text NOT NULL,
    "Install_Numbers" text NOT NULL,
    "Status" text NOT NULL,
    "Emp" bigint,
    "Loan" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_installments OWNER TO demorabiherp_karim;

--
-- Name: emp_installments_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.emp_installments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_installments_id_seq OWNER TO demorabiherp_karim;

--
-- Name: emp_installments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.emp_installments_id_seq OWNED BY public.emp_installments.id;


--
-- Name: emp_mails; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.emp_mails (
    id bigint NOT NULL,
    "Message" text,
    "Emp" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_mails OWNER TO demorabiherp_karim;

--
-- Name: emp_mails_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.emp_mails_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_mails_id_seq OWNER TO demorabiherp_karim;

--
-- Name: emp_mails_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.emp_mails_id_seq OWNED BY public.emp_mails.id;


--
-- Name: emp_movements; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.emp_movements (
    id bigint NOT NULL,
    "Date" text,
    "Time" text,
    "Emp" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_movements OWNER TO demorabiherp_karim;

--
-- Name: emp_movements_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.emp_movements_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_movements_id_seq OWNER TO demorabiherp_karim;

--
-- Name: emp_movements_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.emp_movements_id_seq OWNED BY public.emp_movements.id;


--
-- Name: emp_p_o_s_stores; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.emp_p_o_s_stores (
    id bigint NOT NULL,
    "Emp" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Store" text
);


ALTER TABLE public.emp_p_o_s_stores OWNER TO demorabiherp_karim;

--
-- Name: emp_p_o_s_stores_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.emp_p_o_s_stores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_p_o_s_stores_id_seq OWNER TO demorabiherp_karim;

--
-- Name: emp_p_o_s_stores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.emp_p_o_s_stores_id_seq OWNED BY public.emp_p_o_s_stores.id;


--
-- Name: emp_ratios; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.emp_ratios (
    id bigint NOT NULL,
    "Salary" text NOT NULL,
    "Type" text NOT NULL,
    "Emp" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Typee" text,
    "From" integer,
    "To" integer,
    "Rate" numeric(8,2)
);


ALTER TABLE public.emp_ratios OWNER TO demorabiherp_karim;

--
-- Name: emp_ratios_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.emp_ratios_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_ratios_id_seq OWNER TO demorabiherp_karim;

--
-- Name: emp_ratios_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.emp_ratios_id_seq OWNED BY public.emp_ratios.id;


--
-- Name: emp_safes; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.emp_safes (
    id bigint NOT NULL,
    "Safe" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_safes OWNER TO demorabiherp_karim;

--
-- Name: emp_safes_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.emp_safes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_safes_id_seq OWNER TO demorabiherp_karim;

--
-- Name: emp_safes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.emp_safes_id_seq OWNED BY public.emp_safes.id;


--
-- Name: empassies; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.empassies (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Arabic_Address" text,
    "English_Address" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.empassies OWNER TO demorabiherp_karim;

--
-- Name: empassies_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.empassies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.empassies_id_seq OWNER TO demorabiherp_karim;

--
-- Name: empassies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.empassies_id_seq OWNED BY public.empassies.id;


--
-- Name: empassy_reserve_dates; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.empassy_reserve_dates (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Client" text,
    "Purpose" text,
    "Empassy" text,
    "Booking_Date" text,
    "Cost" text,
    "Pay" text,
    "Residual" text,
    "Safe" text,
    "Draw" text,
    "Coin" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.empassy_reserve_dates OWNER TO demorabiherp_karim;

--
-- Name: empassy_reserve_dates_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.empassy_reserve_dates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.empassy_reserve_dates_id_seq OWNER TO demorabiherp_karim;

--
-- Name: empassy_reserve_dates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.empassy_reserve_dates_id_seq OWNED BY public.empassy_reserve_dates.id;


--
-- Name: employesses; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.employesses (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Name" text NOT NULL,
    "Emp_Type" text,
    "Salary" text,
    "Attendence" text,
    "Departure" text,
    "Hours_Numbers" text,
    "Days_Numbers" text,
    "Day_Price" text,
    "Precentage_of_Sales" text,
    "Precentage_of_Profits" text,
    "Image" text,
    "Bank_Account" text,
    "Qualifications" text,
    "Address" text,
    "Social_Status" text,
    "ID_Number" text,
    "Contract_Start" text,
    "Contract_End" text,
    "Phone" text,
    "Phone2" text,
    "Email" text,
    "Password" text,
    "Job" bigint,
    "Department" bigint,
    "Account" bigint,
    "Account_Emp" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Note" text,
    "Precentage_of_Execution" text,
    "Covenant" bigint,
    "Commission" bigint,
    "Price_Level" text,
    "Bill_Num" text,
    "NumbersOfBill" text,
    "EmpSort" text DEFAULT 1,
    "CV" text,
    "ID_Image" text,
    "Criminal_status" text,
    "Contract" text,
    health_certificate text,
    "Search_Card" text,
    "Recruitment_certificate" text,
    employee_profile text,
    duration_criminal_investigation text,
    "Birthdate" text,
    "Attitude_recruiting" text,
    "Job_Number" text,
    date_resignation text,
    "Living" text,
    "Branch" text,
    "Level" text,
    "Religion" text,
    "Insurance_salary" text,
    "Insurance_companies" text,
    "Previous_experience" text,
    "Nationality" text,
    "MonthlyTarget" text,
    "QuarterTarget" text,
    "SemiTarget" text,
    "YearlyTarget" text,
    "IDExpireDate" text,
    "LicensExpireDate" text,
    "PassportExpireDate" text,
    "Merit" text,
    "Pro_Group" text,
    "NameEn" text,
    arr bigint,
    "SearchCode" text,
    "Active" text DEFAULT 1,
    "Delete" text DEFAULT 0,
    "Attendence2" text,
    "Departure2" text,
    "ShippingCollectionType" text,
    "ShippingCollectionValue" text,
    "Other_Shift" text
);


ALTER TABLE public.employesses OWNER TO demorabiherp_karim;

--
-- Name: employesses_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.employesses_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.employesses_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: employesses_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.employesses_arr_seq OWNED BY public.employesses.arr;


--
-- Name: employesses_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.employesses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.employesses_id_seq OWNER TO demorabiherp_karim;

--
-- Name: employesses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.employesses_id_seq OWNED BY public.employesses.id;


--
-- Name: employment_levels; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.employment_levels (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.employment_levels OWNER TO demorabiherp_karim;

--
-- Name: employment_levels_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.employment_levels_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.employment_levels_id_seq OWNER TO demorabiherp_karim;

--
-- Name: employment_levels_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.employment_levels_id_seq OWNED BY public.employment_levels.id;


--
-- Name: emps_producation_points; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.emps_producation_points (
    id bigint NOT NULL,
    "Month" text,
    "Point" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Date" text
);


ALTER TABLE public.emps_producation_points OWNER TO demorabiherp_karim;

--
-- Name: emps_producation_points_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.emps_producation_points_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emps_producation_points_id_seq OWNER TO demorabiherp_karim;

--
-- Name: emps_producation_points_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.emps_producation_points_id_seq OWNED BY public.emps_producation_points.id;


--
-- Name: emps_producation_quantities; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.emps_producation_quantities (
    id bigint NOT NULL,
    "FromQ" text,
    "ToQ" text,
    "ValueQ" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emps_producation_quantities OWNER TO demorabiherp_karim;

--
-- Name: emps_producation_quantities_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.emps_producation_quantities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emps_producation_quantities_id_seq OWNER TO demorabiherp_karim;

--
-- Name: emps_producation_quantities_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.emps_producation_quantities_id_seq OWNED BY public.emps_producation_quantities.id;


--
-- Name: entitlements; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.entitlements (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Amount" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Emp" bigint,
    "Coin" bigint NOT NULL,
    "Type" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.entitlements OWNER TO demorabiherp_karim;

--
-- Name: entitlements_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.entitlements_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.entitlements_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: entitlements_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.entitlements_arr_seq OWNED BY public.entitlements.arr;


--
-- Name: entitlements_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.entitlements_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.entitlements_id_seq OWNER TO demorabiherp_karim;

--
-- Name: entitlements_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.entitlements_id_seq OWNED BY public.entitlements.id;


--
-- Name: events; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.events (
    id bigint NOT NULL,
    "Start_Date" text,
    "End_Date" text,
    "Event_Ar_Name" text,
    "Event_En_Name" text,
    "Type" text,
    "Type_ID" text,
    "Type_Code" text,
    "Emp" text,
    "Client" text,
    "Product" text,
    "Customer" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.events OWNER TO demorabiherp_karim;

--
-- Name: events_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.events_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.events_id_seq OWNER TO demorabiherp_karim;

--
-- Name: events_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.events_id_seq OWNED BY public.events.id;


--
-- Name: examinations_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.examinations_types (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Allow_From" text NOT NULL,
    "Allow_To" text NOT NULL,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.examinations_types OWNER TO demorabiherp_karim;

--
-- Name: examinations_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.examinations_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.examinations_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: examinations_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.examinations_types_id_seq OWNED BY public.examinations_types.id;


--
-- Name: exchange_commissions; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.exchange_commissions (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text,
    "Note" text,
    "Return_Maintaince" text,
    "Draw" text NOT NULL,
    "Amount" text NOT NULL,
    "Commision" text NOT NULL,
    "Pre_Sales" text NOT NULL,
    "Pre_Execu" text NOT NULL,
    "Safe" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Emp" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Exchange_Commision" text,
    "Collection" text,
    "Delete" text DEFAULT 0
);


ALTER TABLE public.exchange_commissions OWNER TO demorabiherp_karim;

--
-- Name: exchange_commissions_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.exchange_commissions_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.exchange_commissions_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: exchange_commissions_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.exchange_commissions_arr_seq OWNED BY public.exchange_commissions."Code";


--
-- Name: exchange_commissions_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.exchange_commissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.exchange_commissions_id_seq OWNER TO demorabiherp_karim;

--
-- Name: exchange_commissions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.exchange_commissions_id_seq OWNED BY public.exchange_commissions.id;


--
-- Name: execute_job_order_models; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.execute_job_order_models (
    id bigint NOT NULL,
    "Model" text,
    "Qty" text,
    "Total_Cost" text,
    "Outcome" text,
    "Execute" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.execute_job_order_models OWNER TO demorabiherp_karim;

--
-- Name: execute_job_order_models_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.execute_job_order_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.execute_job_order_models_id_seq OWNER TO demorabiherp_karim;

--
-- Name: execute_job_order_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.execute_job_order_models_id_seq OWNED BY public.execute_job_order_models.id;


--
-- Name: execute_job_order_workmanships; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.execute_job_order_workmanships (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "TDiscount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "Store" text,
    "Product" text,
    "Unit" text,
    "Execute" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Net" text
);


ALTER TABLE public.execute_job_order_workmanships OWNER TO demorabiherp_karim;

--
-- Name: execute_job_order_workmanships_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.execute_job_order_workmanships_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.execute_job_order_workmanships_id_seq OWNER TO demorabiherp_karim;

--
-- Name: execute_job_order_workmanships_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.execute_job_order_workmanships_id_seq OWNED BY public.execute_job_order_workmanships.id;


--
-- Name: execute_job_orders; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.execute_job_orders (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Note" text,
    "Client" text,
    "Executor" text,
    "Delegate" text,
    "RecivedDate" text,
    "Recipient" text,
    "Order" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Transfer" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0,
    "Current_Credit" text,
    "Model" text,
    "Status" text DEFAULT 0
);


ALTER TABLE public.execute_job_orders OWNER TO demorabiherp_karim;

--
-- Name: execute_job_orders_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.execute_job_orders_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.execute_job_orders_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: execute_job_orders_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.execute_job_orders_arr_seq OWNED BY public.execute_job_orders."Code";


--
-- Name: execute_job_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.execute_job_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.execute_job_orders_id_seq OWNER TO demorabiherp_karim;

--
-- Name: execute_job_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.execute_job_orders_id_seq OWNED BY public.execute_job_orders.id;


--
-- Name: executing_receiving_secretariats; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.executing_receiving_secretariats (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Qty" text,
    "Total" text,
    "Model" text,
    "User" text,
    "Time" text,
    "Branch" text,
    "StoreIn" text,
    "StoreOut" text,
    "Client" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Workmanship_Price" text
);


ALTER TABLE public.executing_receiving_secretariats OWNER TO demorabiherp_karim;

--
-- Name: executing_receiving_secretariats_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.executing_receiving_secretariats_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.executing_receiving_secretariats_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: executing_receiving_secretariats_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.executing_receiving_secretariats_arr_seq OWNED BY public.executing_receiving_secretariats.arr;


--
-- Name: executing_receiving_secretariats_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.executing_receiving_secretariats_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.executing_receiving_secretariats_id_seq OWNER TO demorabiherp_karim;

--
-- Name: executing_receiving_secretariats_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.executing_receiving_secretariats_id_seq OWNED BY public.executing_receiving_secretariats.id;


--
-- Name: executing_receivings; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.executing_receivings (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Qty" text NOT NULL,
    "Total" text NOT NULL,
    "Model" bigint NOT NULL,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text,
    "Time" text,
    "StoreIn" text,
    "StoreOut" text,
    "Sort" text,
    "Vendor" text,
    "Cost_Workmentship" text,
    "Total_Workmentship" text,
    arr bigint
);


ALTER TABLE public.executing_receivings OWNER TO demorabiherp_karim;

--
-- Name: executing_receivings_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.executing_receivings_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.executing_receivings_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: executing_receivings_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.executing_receivings_arr_seq OWNED BY public.executing_receivings.arr;


--
-- Name: executing_receivings_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.executing_receivings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.executing_receivings_id_seq OWNER TO demorabiherp_karim;

--
-- Name: executing_receivings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.executing_receivings_id_seq OWNED BY public.executing_receivings.id;


--
-- Name: executor_filters; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.executor_filters (
    id bigint NOT NULL,
    "Product" text NOT NULL,
    "Code" text,
    "Name" text,
    "VName" text,
    "VVName" text,
    "V1" text,
    "V2" text,
    "Qty" text,
    "Price" text,
    "Total" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.executor_filters OWNER TO demorabiherp_karim;

--
-- Name: executor_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.executor_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.executor_filters_id_seq OWNER TO demorabiherp_karim;

--
-- Name: executor_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.executor_filters_id_seq OWNED BY public.executor_filters.id;


--
-- Name: expenses_list_column_sechdules; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.expenses_list_column_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code_Type" text,
    "Statement" text,
    "Debitor" text,
    "Cost_Center" text,
    "Coin" text,
    "User" text,
    "Account" text,
    "Branch" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.expenses_list_column_sechdules OWNER TO demorabiherp_karim;

--
-- Name: expenses_list_column_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.expenses_list_column_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.expenses_list_column_sechdules_id_seq OWNER TO demorabiherp_karim;

--
-- Name: expenses_list_column_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.expenses_list_column_sechdules_id_seq OWNED BY public.expenses_list_column_sechdules.id;


--
-- Name: expenses_list_columns; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.expenses_list_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code_Type" text,
    "Statement" text,
    "Debitor" text,
    "Cost_Center" text,
    "Coin" text,
    "User" text,
    "Account" text,
    "Branch" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.expenses_list_columns OWNER TO demorabiherp_karim;

--
-- Name: expenses_list_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.expenses_list_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.expenses_list_columns_id_seq OWNER TO demorabiherp_karim;

--
-- Name: expenses_list_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.expenses_list_columns_id_seq OWNED BY public.expenses_list_columns.id;


--
-- Name: expenses_type_projects; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.expenses_type_projects (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Project" text,
    "Account" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.expenses_type_projects OWNER TO demorabiherp_karim;

--
-- Name: expenses_type_projects_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.expenses_type_projects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.expenses_type_projects_id_seq OWNER TO demorabiherp_karim;

--
-- Name: expenses_type_projects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.expenses_type_projects_id_seq OWNED BY public.expenses_type_projects.id;


--
-- Name: expire_date_qties; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.expire_date_qties (
    id bigint NOT NULL,
    "Qty" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "PP_Code" text,
    "PPP_Code" text,
    "PPPP_Code" text,
    "V_Name" text,
    "VV_Name" text,
    "Store" text,
    "Unit" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "Low_Unit" text,
    "Exp_Date" text,
    "Group" text,
    "Brand" text,
    "Branch" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Hold_Qty" text DEFAULT 0
);


ALTER TABLE public.expire_date_qties OWNER TO demorabiherp_karim;

--
-- Name: expire_date_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.expire_date_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.expire_date_qties_id_seq OWNER TO demorabiherp_karim;

--
-- Name: expire_date_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.expire_date_qties_id_seq OWNED BY public.expire_date_qties.id;


--
-- Name: export_checks; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.export_checks (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Check_Num" text,
    "Due_Date" text NOT NULL,
    "Amount" text NOT NULL,
    "Status" text DEFAULT '0'::text NOT NULL,
    "Reason" text,
    "Check_Type" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Account" bigint NOT NULL,
    "Bank" bigint NOT NULL,
    "Pay_Account" bigint NOT NULL,
    "Bene_Account" bigint,
    "User" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "File" text,
    arr bigint,
    "Image" text,
    "Signture_Name" text,
    "Bank_Branch" text,
    "Edit" text,
    "Edit_New_Code" text,
    "Delete" text,
    "BankSafe_Account" text,
    "Transfer" text
);


ALTER TABLE public.export_checks OWNER TO demorabiherp_karim;

--
-- Name: export_checks_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.export_checks_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.export_checks_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: export_checks_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.export_checks_arr_seq OWNED BY public.export_checks."Code";


--
-- Name: export_checks_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.export_checks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.export_checks_id_seq OWNER TO demorabiherp_karim;

--
-- Name: export_checks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.export_checks_id_seq OWNED BY public.export_checks.id;


--
-- Name: f_a_q_s; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.f_a_q_s (
    id bigint NOT NULL,
    "Arabic_Question" text NOT NULL,
    "English_Question" text NOT NULL,
    "Arabic_Answer" text NOT NULL,
    "English_Answer" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.f_a_q_s OWNER TO demorabiherp_karim;

--
-- Name: f_a_q_s_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.f_a_q_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.f_a_q_s_id_seq OWNER TO demorabiherp_karim;

--
-- Name: f_a_q_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.f_a_q_s_id_seq OWNED BY public.f_a_q_s.id;


--
-- Name: failed_jobs; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.failed_jobs (
    id bigint NOT NULL,
    uuid character varying(191) NOT NULL,
    connection text NOT NULL,
    queue text NOT NULL,
    payload text NOT NULL,
    exception text NOT NULL,
    failed_at timestamp(0) without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.failed_jobs OWNER TO demorabiherp_karim;

--
-- Name: failed_jobs_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.failed_jobs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.failed_jobs_id_seq OWNER TO demorabiherp_karim;

--
-- Name: failed_jobs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.failed_jobs_id_seq OWNED BY public.failed_jobs.id;


--
-- Name: faults_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.faults_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Note" text,
    "Amount" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.faults_types OWNER TO demorabiherp_karim;

--
-- Name: faults_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.faults_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.faults_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: faults_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.faults_types_id_seq OWNED BY public.faults_types.id;


--
-- Name: fifo_qties; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.fifo_qties (
    id bigint NOT NULL,
    "Qty" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "PP_Code" text,
    "PPP_Code" text,
    "PPPP_Code" text,
    "V_Name" text,
    "VV_Name" text,
    "Cost_Price" text,
    "Store" text,
    "Unit" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "Low_Unit" text,
    "Exp_Date" text,
    "SearchCode1" text,
    "SearchCode2" text,
    "Group" text,
    "Brand" text,
    "Branch" text,
    "Purchases_Date" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Original_Qty" text,
    "Hold_Qty" text DEFAULT 0
);


ALTER TABLE public.fifo_qties OWNER TO demorabiherp_karim;

--
-- Name: fifo_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.fifo_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.fifo_qties_id_seq OWNER TO demorabiherp_karim;

--
-- Name: fifo_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.fifo_qties_id_seq OWNED BY public.fifo_qties.id;


--
-- Name: firewall_ips; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.firewall_ips (
    id integer NOT NULL,
    ip character varying(191) NOT NULL,
    log_id integer,
    blocked boolean DEFAULT true NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone
);


ALTER TABLE public.firewall_ips OWNER TO demorabiherp_karim;

--
-- Name: firewall_logs_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.firewall_logs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.firewall_logs_id_seq OWNER TO demorabiherp_karim;

--
-- Name: firewall_logs; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.firewall_logs (
    id integer DEFAULT nextval('public.firewall_logs_id_seq'::regclass) NOT NULL,
    ip character varying(191) NOT NULL,
    level character varying(191) DEFAULT 'medium'::character varying NOT NULL,
    middleware character varying(191) NOT NULL,
    user_id integer,
    url text,
    referrer character varying(191),
    request text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone
);


ALTER TABLE public.firewall_logs OWNER TO demorabiherp_karim;

--
-- Name: follow_lists; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.follow_lists (
    id bigint NOT NULL,
    "Emp" text,
    "Day" text,
    "Time" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.follow_lists OWNER TO demorabiherp_karim;

--
-- Name: follow_lists_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.follow_lists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.follow_lists_id_seq OWNER TO demorabiherp_karim;

--
-- Name: follow_lists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.follow_lists_id_seq OWNED BY public.follow_lists.id;


--
-- Name: general_dailies; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.general_dailies (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Type" text NOT NULL,
    "Debitor" text NOT NULL,
    "Creditor" text NOT NULL,
    "Statement" text,
    "Draw" text NOT NULL,
    "Debitor_Coin" text NOT NULL,
    "Creditor_Coin" text NOT NULL,
    "Account" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    userr bigint,
    "Code_Type" text,
    "Branch" text,
    "TypeEn" text,
    arr bigint
);


ALTER TABLE public.general_dailies OWNER TO demorabiherp_karim;

--
-- Name: general_dailies_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.general_dailies_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.general_dailies_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: general_dailies_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.general_dailies_arr_seq OWNED BY public.general_dailies.arr;


--
-- Name: general_dailies_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.general_dailies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.general_dailies_id_seq OWNER TO demorabiherp_karim;

--
-- Name: general_dailies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.general_dailies_id_seq OWNED BY public.general_dailies.id;


--
-- Name: goods_product_projects; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.goods_product_projects (
    id bigint NOT NULL,
    "Goods" text,
    "Product" text,
    "P_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Unit" text,
    "Qty" text,
    "AvQty" text,
    "Price" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.goods_product_projects OWNER TO demorabiherp_karim;

--
-- Name: goods_product_projects_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.goods_product_projects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.goods_product_projects_id_seq OWNER TO demorabiherp_karim;

--
-- Name: goods_product_projects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.goods_product_projects_id_seq OWNED BY public.goods_product_projects.id;


--
-- Name: goods_projects; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.goods_projects (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Store" text,
    "Cost_Center" text,
    "Responsible" text,
    "Safe" text,
    "Coin" text,
    "Draw" text,
    "Note" text,
    "Project" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Price" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.goods_projects OWNER TO demorabiherp_karim;

--
-- Name: goods_projects_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.goods_projects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.goods_projects_id_seq OWNER TO demorabiherp_karim;

--
-- Name: goods_projects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.goods_projects_id_seq OWNED BY public.goods_projects.id;


--
-- Name: governrates; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.governrates (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Country" text,
    "SearchCode" text
);


ALTER TABLE public.governrates OWNER TO demorabiherp_karim;

--
-- Name: governrates_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.governrates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.governrates_id_seq OWNER TO demorabiherp_karim;

--
-- Name: governrates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.governrates_id_seq OWNED BY public.governrates.id;


--
-- Name: group_filters; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.group_filters (
    id bigint NOT NULL,
    "Product" text NOT NULL,
    "Code" text,
    "Name" text,
    "VName" text,
    "VVName" text,
    "V1" text,
    "V2" text,
    "Qty" text,
    "Price" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.group_filters OWNER TO demorabiherp_karim;

--
-- Name: group_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.group_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.group_filters_id_seq OWNER TO demorabiherp_karim;

--
-- Name: group_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.group_filters_id_seq OWNED BY public.group_filters.id;


--
-- Name: holidays; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.holidays (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Num_of_Days" text NOT NULL,
    "Start_Date" text NOT NULL,
    "Discount" text NOT NULL,
    "Status" text NOT NULL,
    "Note" text,
    "Emp" bigint,
    "Type" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.holidays OWNER TO demorabiherp_karim;

--
-- Name: holidays_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.holidays_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.holidays_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: holidays_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.holidays_arr_seq OWNED BY public.holidays.arr;


--
-- Name: holidays_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.holidays_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.holidays_id_seq OWNER TO demorabiherp_karim;

--
-- Name: holidays_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.holidays_id_seq OWNED BY public.holidays.id;


--
-- Name: holidays_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.holidays_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Days" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "From_Date" text,
    "To_Date" text
);


ALTER TABLE public.holidays_types OWNER TO demorabiherp_karim;

--
-- Name: holidays_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.holidays_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.holidays_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: holidays_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.holidays_types_id_seq OWNED BY public.holidays_types.id;


--
-- Name: home_e_com_designs; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.home_e_com_designs (
    id bigint NOT NULL,
    "Slider_BG_Type" text,
    "Slider_BG_Image" text,
    "Slider_BG_Color" text,
    "Slider_Button_BG_Color" text,
    "Slider_Button_Txt_Color" text,
    "Slider_Button_Hover_BG_Color" text,
    "Slider_Button_Hover_Txt_Color" text,
    "Slider_Title_Txt_Color" text,
    "Slider_Desc_Txt_Color" text,
    "Ads_Top_Img_First_BG_Color" text,
    "Ads_Top_Img_First_Before_BG_Color" text,
    "Ads_Top_Img_Second_BG_Color" text,
    "Ads_Top_Img_Second_Before_BG_Color" text,
    "Ads_Top_Img_Button_BG_Color" text,
    "Ads_Top_Img_Button_Txt_Color" text,
    "Ads_Top_Img_Button_Hover_BG_Color" text,
    "Ads_Top_Img_Button_Hover_Txt_Color" text,
    "Support_Icons_BG_Color" text,
    "Support_Icons_Txt_Color" text,
    "Support_Icons_Color" text,
    "Ads_Bootom_Imgs_BG_Color" text,
    "Ads_Bootom_Imgs_Middle_BG_Color" text,
    "Ads_Bootom_Imgs_Button_BG_Color" text,
    "Ads_Bootom_Imgs_Button_Txt_Color" text,
    "Ads_Bootom_Imgs_Button_Hover_BG_Color" text,
    "Ads_Bootom_Imgs_Button_Hover_Txt_Color" text,
    "Partners_BG_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.home_e_com_designs OWNER TO demorabiherp_karim;

--
-- Name: home_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.home_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.home_e_com_designs_id_seq OWNER TO demorabiherp_karim;

--
-- Name: home_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.home_e_com_designs_id_seq OWNED BY public.home_e_com_designs.id;


--
-- Name: home_product_e_com_designs; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.home_product_e_com_designs (
    id bigint NOT NULL,
    "Special_Offer_Title_BG_Color" text,
    "Special_Offer_Title_Txt_Color" text,
    "Special_Offer_Product_BG_Color" text,
    "Special_Offer_Product_Border_Color" text,
    "Special_Offer_Product_Txt_Color" text,
    "Special_Offer_Product_Price_Color" text,
    "Special_Offer_Product_Rate_Color" text,
    "Best_Sellers_Title_BG_Color" text,
    "Best_Sellers_Title_Txt_Color" text,
    "Best_Sellers_Category_Txt_Color" text,
    "Best_Sellers_Category_Active_Txt_Color" text,
    "Best_Sellers_Product_BG_Color" text,
    "Best_Sellers_Product_Group_BG_Color" text,
    "Best_Sellers_Product_Group_Txt_Color" text,
    "Best_Sellers_Product_Group_Hover_BG_Color" text,
    "Best_Sellers_Product_Group_Hover_Txt_Color" text,
    "Best_Sellers_Product_Icon_BG_Color" text,
    "Best_Sellers_Product_Icon_Txt_Color" text,
    "Best_Sellers_Product_Icon_Hover_BG_Color" text,
    "Best_Sellers_Product_Icon_Hover_Txt_Color" text,
    "Best_Sellers_Product_Txt_Color" text,
    "Best_Sellers_Product_Price_Color" text,
    "Best_Sellers_Product_Rate_Color" text,
    "New_Arrivals_Title_BG_Color" text,
    "New_Arrivals_Title_Txt_Color" text,
    "New_Arrivals_Product_BG_Color" text,
    "New_Arrivals_Product_Group_BG_Color" text,
    "New_Arrivals_Product_Group_Txt_Color" text,
    "New_Arrivals_Product_Group_Hover_BG_Color" text,
    "New_Arrivals_Product_Group_Hover_Txt_Color" text,
    "New_Arrivals_Product_Icon_BG_Color" text,
    "New_Arrivals_Product_Icon_Txt_Color" text,
    "New_Arrivals_Product_Icon_Hover_BG_Color" text,
    "New_Arrivals_Product_Icon_Hover_Txt_Color" text,
    "New_Arrivals_Product_Txt_Color" text,
    "New_Arrivals_Product_Price_Color" text,
    "New_Arrivals_Product_Hover_Price_Color" text,
    "New_Arrivals_Product_Rate_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Special_Offer_Product_Txt_Hover_Color" text
);


ALTER TABLE public.home_product_e_com_designs OWNER TO demorabiherp_karim;

--
-- Name: home_product_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.home_product_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.home_product_e_com_designs_id_seq OWNER TO demorabiherp_karim;

--
-- Name: home_product_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.home_product_e_com_designs_id_seq OWNED BY public.home_product_e_com_designs.id;


--
-- Name: import_new_prods; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.import_new_prods (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Type" text NOT NULL,
    "Group" text NOT NULL,
    "Brand" text,
    "Unit" text NOT NULL,
    "Rate" text NOT NULL,
    "Barcode" text NOT NULL,
    "Price_1" text NOT NULL,
    "Price_2" text,
    "Price_3" text,
    "Def" text NOT NULL,
    "Num" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Code_Type" text,
    "World_Code" text,
    "Weight" text,
    "Search_Code" text
);


ALTER TABLE public.import_new_prods OWNER TO demorabiherp_karim;

--
-- Name: import_new_prods_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.import_new_prods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.import_new_prods_id_seq OWNER TO demorabiherp_karim;

--
-- Name: import_new_prods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.import_new_prods_id_seq OWNED BY public.import_new_prods.id;


--
-- Name: import_new_prods_starts; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.import_new_prods_starts (
    id bigint NOT NULL,
    "Name" text,
    "Type" text,
    "Group" text,
    "Brand" text,
    "Unit" text,
    "Rate" text,
    "Barcode" text,
    "Price_1" text,
    "Price_2" text,
    "Price_3" text,
    "Def" text,
    "Num" text,
    "Store" text,
    "Qty" text,
    "CostPrice" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Code_Type" text,
    "World_Code" text,
    "Weight" text,
    "Search_Code" text
);


ALTER TABLE public.import_new_prods_starts OWNER TO demorabiherp_karim;

--
-- Name: import_new_prods_starts_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.import_new_prods_starts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.import_new_prods_starts_id_seq OWNER TO demorabiherp_karim;

--
-- Name: import_new_prods_starts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.import_new_prods_starts_id_seq OWNED BY public.import_new_prods_starts.id;


--
-- Name: in_out_logs; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.in_out_logs (
    id bigint NOT NULL,
    user_id integer NOT NULL,
    in_time time(0) without time zone,
    out_time time(0) without time zone,
    time_calc double precision,
    date date,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.in_out_logs OWNER TO demorabiherp_karim;

--
-- Name: in_out_logs_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.in_out_logs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.in_out_logs_id_seq OWNER TO demorabiherp_karim;

--
-- Name: in_out_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.in_out_logs_id_seq OWNED BY public.in_out_logs.id;


--
-- Name: incom_checks; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.incom_checks (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Check_Num" text NOT NULL,
    "Due_Date" text NOT NULL,
    "Amount" text NOT NULL,
    "Status" text DEFAULT '0'::text NOT NULL,
    "Reason" text,
    "Check_Type" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Account" bigint NOT NULL,
    "Bank" bigint NOT NULL,
    "Arrest_Account" bigint NOT NULL,
    "Bene_Account" bigint,
    "User" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "File" text,
    arr bigint,
    "Image" text,
    "Signture_Name" text,
    "Bank_Branch" text,
    "Edit" text,
    "Edit_New_Code" text,
    "Delete" text,
    "BankSafe_Account" text,
    "Transfer" text
);


ALTER TABLE public.incom_checks OWNER TO demorabiherp_karim;

--
-- Name: incom_checks_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.incom_checks_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.incom_checks_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: incom_checks_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.incom_checks_arr_seq OWNED BY public.incom_checks."Code";


--
-- Name: incom_checks_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.incom_checks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.incom_checks_id_seq OWNER TO demorabiherp_karim;

--
-- Name: incom_checks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.incom_checks_id_seq OWNED BY public.incom_checks.id;


--
-- Name: incom_manufacturing_models; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.incom_manufacturing_models (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text NOT NULL,
    "P_En_Name" text NOT NULL,
    "Qty" text NOT NULL,
    "Cost" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Depreciation" text NOT NULL,
    "Depreciation_Qty" text NOT NULL,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "Unit" bigint,
    "Model" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Precent" text
);


ALTER TABLE public.incom_manufacturing_models OWNER TO demorabiherp_karim;

--
-- Name: incom_manufacturing_models_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.incom_manufacturing_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.incom_manufacturing_models_id_seq OWNER TO demorabiherp_karim;

--
-- Name: incom_manufacturing_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.incom_manufacturing_models_id_seq OWNED BY public.incom_manufacturing_models.id;


--
-- Name: incom_manufacturing_secretariat_models; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.incom_manufacturing_secretariat_models (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Precent" text,
    "Qty" text,
    "Cost" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Total_Tax" text,
    "Depreciation" text,
    "Depreciation_Qty" text,
    "Store" text,
    "Product" text,
    "Unit" text,
    "Model" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.incom_manufacturing_secretariat_models OWNER TO demorabiherp_karim;

--
-- Name: incom_manufacturing_secretariat_models_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.incom_manufacturing_secretariat_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.incom_manufacturing_secretariat_models_id_seq OWNER TO demorabiherp_karim;

--
-- Name: incom_manufacturing_secretariat_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.incom_manufacturing_secretariat_models_id_seq OWNED BY public.incom_manufacturing_secretariat_models.id;


--
-- Name: install_companies_sales_bills_columns; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.install_companies_sales_bills_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "ShiftCode" text,
    "Executor" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Client" text,
    "InstallCompany" text,
    "ContractNumber" text,
    "PayFees" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Av_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Total_BF_Tax" text,
    "Tax" text,
    "Total" text,
    "Group" text,
    "Brand" text,
    "Exp_Date" text,
    "Product_Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.install_companies_sales_bills_columns OWNER TO demorabiherp_karim;

--
-- Name: install_companies_sales_bills_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.install_companies_sales_bills_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.install_companies_sales_bills_columns_id_seq OWNER TO demorabiherp_karim;

--
-- Name: install_companies_sales_bills_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.install_companies_sales_bills_columns_id_seq OWNED BY public.install_companies_sales_bills_columns.id;


--
-- Name: install_companies_sales_bills_columns_sechdules; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.install_companies_sales_bills_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "ShiftCode" text,
    "Executor" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Client" text,
    "InstallCompany" text,
    "ContractNumber" text,
    "PayFees" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Av_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Total_BF_Tax" text,
    "Tax" text,
    "Total" text,
    "Group" text,
    "Brand" text,
    "Exp_Date" text,
    "Product_Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.install_companies_sales_bills_columns_sechdules OWNER TO demorabiherp_karim;

--
-- Name: install_companies_sales_bills_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.install_companies_sales_bills_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.install_companies_sales_bills_columns_sechdules_id_seq OWNER TO demorabiherp_karim;

--
-- Name: install_companies_sales_bills_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.install_companies_sales_bills_columns_sechdules_id_seq OWNED BY public.install_companies_sales_bills_columns_sechdules.id;


--
-- Name: installment_companies; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.installment_companies (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Logo" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Account" text,
    "NakdyaAccount" text
);


ALTER TABLE public.installment_companies OWNER TO demorabiherp_karim;

--
-- Name: installment_companies_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.installment_companies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.installment_companies_id_seq OWNER TO demorabiherp_karim;

--
-- Name: installment_companies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.installment_companies_id_seq OWNED BY public.installment_companies.id;


--
-- Name: installment_companies_ratios; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.installment_companies_ratios (
    id bigint NOT NULL,
    "From" text,
    "To" text,
    "Service_Fee" text,
    "Company_Precent" text,
    "Company" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.installment_companies_ratios OWNER TO demorabiherp_karim;

--
-- Name: installment_companies_ratios_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.installment_companies_ratios_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.installment_companies_ratios_id_seq OWNER TO demorabiherp_karim;

--
-- Name: installment_companies_ratios_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.installment_companies_ratios_id_seq OWNED BY public.installment_companies_ratios.id;


--
-- Name: installment_dates; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.installment_dates (
    id bigint NOT NULL,
    "Date" text,
    "Value" text,
    "Status" text,
    "Client" bigint NOT NULL,
    "Install" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.installment_dates OWNER TO demorabiherp_karim;

--
-- Name: installment_dates_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.installment_dates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.installment_dates_id_seq OWNER TO demorabiherp_karim;

--
-- Name: installment_dates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.installment_dates_id_seq OWNED BY public.installment_dates.id;


--
-- Name: installments; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.installments (
    id bigint NOT NULL,
    presenter text,
    annual_interest text,
    monthly_installment text,
    "Years_Number" text,
    total text,
    "installment_Num" text,
    "Date_First_installment" text,
    "Residual" text,
    "Status" text,
    "Client" bigint NOT NULL,
    "Sales" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.installments OWNER TO demorabiherp_karim;

--
-- Name: installments_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.installments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.installments_id_seq OWNER TO demorabiherp_karim;

--
-- Name: installments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.installments_id_seq OWNED BY public.installments.id;


--
-- Name: insurance_companies; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.insurance_companies (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.insurance_companies OWNER TO demorabiherp_karim;

--
-- Name: insurance_companies_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.insurance_companies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.insurance_companies_id_seq OWNER TO demorabiherp_karim;

--
-- Name: insurance_companies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.insurance_companies_id_seq OWNED BY public.insurance_companies.id;


--
-- Name: insurance_papers; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.insurance_papers (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Due_Date" text NOT NULL,
    "Amount" text NOT NULL,
    "Status" text DEFAULT '0'::text NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Account" bigint NOT NULL,
    "Bank" bigint,
    arr bigint,
    "User" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "From" text,
    "To" text,
    "File" text,
    "FromEn" text,
    "ToEn" text,
    "Delete" text
);


ALTER TABLE public.insurance_papers OWNER TO demorabiherp_karim;

--
-- Name: insurance_papers_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.insurance_papers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.insurance_papers_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: insurance_papers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.insurance_papers_arr_seq OWNED BY public.insurance_papers."Code";


--
-- Name: insurance_papers_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.insurance_papers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.insurance_papers_id_seq OWNER TO demorabiherp_karim;

--
-- Name: insurance_papers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.insurance_papers_id_seq OWNED BY public.insurance_papers.id;


--
-- Name: interviews; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.interviews (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Time" text NOT NULL,
    "Status" text DEFAULT '0'::text NOT NULL,
    "Rate" text DEFAULT '0'::text NOT NULL,
    "Note" text,
    "Emp" bigint,
    "Client" bigint,
    "Type" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "StatusNote" text
);


ALTER TABLE public.interviews OWNER TO demorabiherp_karim;

--
-- Name: interviews_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.interviews_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.interviews_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: interviews_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.interviews_arr_seq OWNED BY public.interviews.arr;


--
-- Name: interviews_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.interviews_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.interviews_id_seq OWNER TO demorabiherp_karim;

--
-- Name: interviews_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.interviews_id_seq OWNED BY public.interviews.id;


--
-- Name: interviews_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.interviews_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.interviews_types OWNER TO demorabiherp_karim;

--
-- Name: interviews_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.interviews_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.interviews_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: interviews_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.interviews_types_id_seq OWNED BY public.interviews_types.id;


--
-- Name: intros; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.intros (
    id bigint NOT NULL,
    "Arabic_About" text,
    "English_About" text,
    "Phone_1" text,
    "Phone_2" text,
    "Phone_3" text,
    "Phone_4" text,
    "Arabic_Terms" text,
    "English_Terms" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Arabic_Privacy" text,
    "English_Privacy" text
);


ALTER TABLE public.intros OWNER TO demorabiherp_karim;

--
-- Name: intros_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.intros_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.intros_id_seq OWNER TO demorabiherp_karim;

--
-- Name: intros_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.intros_id_seq OWNED BY public.intros.id;


--
-- Name: inventories; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.inventories (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Total_Dificit" text NOT NULL,
    "Total_Excess" text NOT NULL,
    "Total_Dificit_Price" text NOT NULL,
    "Total_Excess_Price" text NOT NULL,
    "Account_Excess" bigint NOT NULL,
    "Account_Dificit" bigint NOT NULL,
    "Store" bigint,
    "Coin" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Note" text,
    "Settle" character varying DEFAULT 0,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0
);


ALTER TABLE public.inventories OWNER TO demorabiherp_karim;

--
-- Name: inventories_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.inventories_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.inventories_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: inventories_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.inventories_arr_seq OWNED BY public.inventories.arr;


--
-- Name: inventories_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.inventories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.inventories_id_seq OWNER TO demorabiherp_karim;

--
-- Name: inventories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.inventories_id_seq OWNED BY public.inventories.id;


--
-- Name: investors; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.investors (
    id bigint NOT NULL,
    "Date" text,
    "Name" text,
    "Investment_Value" text,
    "Safe" text,
    "Draw" text,
    "Coin" text,
    "Profit_Precent" text,
    "Investment_Period" text,
    "Liquidation_Time" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "End_Date" text,
    "Account" text,
    "Due_Account" text,
    "Expenses_Account" text
);


ALTER TABLE public.investors OWNER TO demorabiherp_karim;

--
-- Name: investors_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.investors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.investors_id_seq OWNER TO demorabiherp_karim;

--
-- Name: investors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.investors_id_seq OWNED BY public.investors.id;


--
-- Name: issues; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.issues (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Time" text,
    "Client" text,
    "Link" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.issues OWNER TO demorabiherp_karim;

--
-- Name: issues_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.issues_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.issues_id_seq OWNER TO demorabiherp_karim;

--
-- Name: issues_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.issues_id_seq OWNED BY public.issues.id;


--
-- Name: items_groups; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.items_groups (
    id bigint NOT NULL,
    "Code" text,
    "Name" text NOT NULL,
    "Type" text NOT NULL,
    "Parent" text NOT NULL,
    "Note" text,
    "Image" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Discount" text,
    "Store_Show" text,
    "Sales_Show" text,
    "NameEn" text,
    "Printer" text,
    "Arrange" bigint,
    "Sales_Precet" text DEFAULT 0
);


ALTER TABLE public.items_groups OWNER TO demorabiherp_karim;

--
-- Name: items_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.items_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.items_groups_id_seq OWNER TO demorabiherp_karim;

--
-- Name: items_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.items_groups_id_seq OWNED BY public.items_groups.id;


--
-- Name: itineraries; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.itineraries (
    id bigint NOT NULL,
    "Emp" text,
    "Day" text,
    "Time" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.itineraries OWNER TO demorabiherp_karim;

--
-- Name: itineraries_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.itineraries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.itineraries_id_seq OWNER TO demorabiherp_karim;

--
-- Name: itineraries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.itineraries_id_seq OWNED BY public.itineraries.id;


--
-- Name: itinerary_visits; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.itinerary_visits (
    id bigint NOT NULL,
    "Emp" text,
    "Date" text,
    "Day" text,
    "Time" text,
    "Status" text,
    "Note" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.itinerary_visits OWNER TO demorabiherp_karim;

--
-- Name: itinerary_visits_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.itinerary_visits_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.itinerary_visits_id_seq OWNER TO demorabiherp_karim;

--
-- Name: itinerary_visits_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.itinerary_visits_id_seq OWNED BY public.itinerary_visits.id;


--
-- Name: job_orders; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.job_orders (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Payment_Method" text,
    "Status" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Safe" text,
    "ShipStatus" text,
    "Client" text,
    "Executor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Later_Due" text,
    "Later_Collection" text,
    "TaxBill" text,
    "TaxCode" text,
    "ProfitPrecent" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "ProfitTax" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Total_Cost" text,
    "DiscountTax" text,
    "RecivedDate" text,
    "Recipient" text,
    "RecivedVoucherCode" text,
    "TransferOrder" text,
    "ExecuteOrder" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0,
    "Current_Credit" text,
    "Execute" text
);


ALTER TABLE public.job_orders OWNER TO demorabiherp_karim;

--
-- Name: job_orders_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.job_orders_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.job_orders_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: job_orders_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.job_orders_arr_seq OWNED BY public.job_orders."Code";


--
-- Name: job_orders_executors; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.job_orders_executors (
    id bigint NOT NULL,
    "Product" text,
    "Executor" text,
    "Order" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.job_orders_executors OWNER TO demorabiherp_karim;

--
-- Name: job_orders_executors_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.job_orders_executors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.job_orders_executors_id_seq OWNER TO demorabiherp_karim;

--
-- Name: job_orders_executors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.job_orders_executors_id_seq OWNED BY public.job_orders_executors.id;


--
-- Name: job_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.job_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.job_orders_id_seq OWNER TO demorabiherp_karim;

--
-- Name: job_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.job_orders_id_seq OWNED BY public.job_orders.id;


--
-- Name: jobs_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.jobs_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.jobs_types OWNER TO demorabiherp_karim;

--
-- Name: jobs_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.jobs_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.jobs_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: jobs_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.jobs_types_id_seq OWNED BY public.jobs_types.id;


--
-- Name: journalizing_details; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.journalizing_details (
    id bigint NOT NULL,
    "Debitor" text NOT NULL,
    "Creditor" text NOT NULL,
    "Account" bigint NOT NULL,
    "Joun_ID" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Statement" text
);


ALTER TABLE public.journalizing_details OWNER TO demorabiherp_karim;

--
-- Name: journalizing_details_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.journalizing_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.journalizing_details_id_seq OWNER TO demorabiherp_karim;

--
-- Name: journalizing_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.journalizing_details_id_seq OWNED BY public.journalizing_details.id;


--
-- Name: journalizings; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.journalizings (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Debaitor" character varying,
    "Total_Creditor" character varying,
    "Note" character varying,
    "Type" character varying,
    "Code_Type" text,
    "Branch" bigint,
    "Status" text,
    "TypeEn" text,
    arr bigint,
    "Edit" text,
    "Edit_New_Code" text,
    "Delete" text,
    "Transfer" text
);


ALTER TABLE public.journalizings OWNER TO demorabiherp_karim;

--
-- Name: journalizings_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.journalizings_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.journalizings_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: journalizings_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.journalizings_arr_seq OWNED BY public.journalizings.arr;


--
-- Name: journalizings_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.journalizings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.journalizings_id_seq OWNER TO demorabiherp_karim;

--
-- Name: journalizings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.journalizings_id_seq OWNED BY public.journalizings.id;


--
-- Name: languages; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.languages (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.languages OWNER TO demorabiherp_karim;

--
-- Name: languages_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.languages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.languages_id_seq OWNER TO demorabiherp_karim;

--
-- Name: languages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.languages_id_seq OWNED BY public.languages.id;


--
-- Name: loan_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.loan_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.loan_types OWNER TO demorabiherp_karim;

--
-- Name: loan_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.loan_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.loan_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: loan_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.loan_types_id_seq OWNED BY public.loan_types.id;


--
-- Name: loans; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.loans (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Amount" text NOT NULL,
    "Years_Number" text NOT NULL,
    "First_Date" text NOT NULL,
    "Install" text NOT NULL,
    "Install_Numbers" text NOT NULL,
    "Note" text,
    "Draw" text NOT NULL,
    "Safe" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Emp" bigint,
    "Type" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Delete" text DEFAULT 0
);


ALTER TABLE public.loans OWNER TO demorabiherp_karim;

--
-- Name: loans_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.loans_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.loans_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: loans_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.loans_arr_seq OWNED BY public.loans.arr;


--
-- Name: loans_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.loans_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.loans_id_seq OWNER TO demorabiherp_karim;

--
-- Name: loans_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.loans_id_seq OWNED BY public.loans.id;


--
-- Name: login_sliders; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.login_sliders (
    id bigint NOT NULL,
    "Image" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.login_sliders OWNER TO demorabiherp_karim;

--
-- Name: login_sliders_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.login_sliders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.login_sliders_id_seq OWNER TO demorabiherp_karim;

--
-- Name: login_sliders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.login_sliders_id_seq OWNED BY public.login_sliders.id;


--
-- Name: main_e_com_designs; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.main_e_com_designs (
    id bigint NOT NULL,
    "Font_Type" text,
    "Pagination_BG_Color" text,
    "Pagination_Txt_Color" text,
    "Pagination_Active_BG_Color" text,
    "Pagination_Active_Txt_Color" text,
    "Body_BG_Type" text,
    "Body_BG_Image" text,
    "Body_BG_Color" text,
    "Sub_Page_BG_Color" text,
    "Breadcumb_BG_Color" text,
    "Breadcumb_Txt_Color" text,
    "Modal_BG_Color" text,
    "Modal_Txt_Color" text,
    "Modal_Button_BG_Color" text,
    "Modal_Button_Txt_Color" text,
    "Table_Header_BG_Color" text,
    "Table_Header_Txt_Color" text,
    "Table_Body_BG_Color" text,
    "Table_Body_Txt_Color" text,
    "Table_Button_BG_Color" text,
    "Table_Button_Txt_Color" text,
    "CopyRights_Txt_Color" text,
    "CopyRights_Klar_Txt_Color" text,
    "CopyRights_Klar_Hover_Txt_Color" text,
    "Preloader_BG_Color" text,
    "Preloader_Small_Circle_Color" text,
    "Preloader_Large_Circle_Color" text,
    "Footer_Title_Color" text,
    "Footer_Txt_Color" text,
    "Footer_Social_Color" text,
    "Footer_Social_Hover_BG_Color" text,
    "Footer_Social_Hover_Txt_Color" text,
    "Header_Top_BG_Color" text,
    "Header_Top_Txt_Color" text,
    "Header_Top_Txt_Hover_Color" text,
    "Header_Middle_BG_Color" text,
    "Header_Middle_Icon_Color" text,
    "Header_Middle_Icon_Hover_Color" text,
    "Header_SearchBar_BG_Color" text,
    "Header_SearchBar_Txt_Color" text,
    "Header_SearchBar_Icon_BG_Color" text,
    "Header_SearchBar_Icon_Txt_Color" text,
    "Header_SearchBar_Icon_Hover_BG_Color" text,
    "Header_SearchBar_Icon_Hover_Txt_Color" text,
    "Navbar_BG_Color" text,
    "Navbar_Txt_Color" text,
    "Navbar_Hover_BG_Color" text,
    "Navbar_Hover_Txt_Color" text,
    "Navbar_Category_BG_Color" text,
    "Navbar_Category_Txt_Color" text,
    "Navbar_Category_Box_BG_Color" text,
    "Navbar_Category_Box_Txt_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Footer_Social_BG_Color" text,
    "Footer_Txt_Hover_Color" text
);


ALTER TABLE public.main_e_com_designs OWNER TO demorabiherp_karim;

--
-- Name: main_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.main_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.main_e_com_designs_id_seq OWNER TO demorabiherp_karim;

--
-- Name: main_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.main_e_com_designs_id_seq OWNED BY public.main_e_com_designs.id;


--
-- Name: maintainc_bills; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.maintainc_bills (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Note" text,
    "Serial_Num" text,
    "Draw" text NOT NULL,
    "Company" bigint,
    "Device_Type" bigint,
    "Device_Case" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "Account" bigint,
    "User" bigint,
    arr bigint,
    "Recipt" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Store" bigint,
    "Total_Price_Errors" text,
    "Totaal" text,
    "Safe" bigint
);


ALTER TABLE public.maintainc_bills OWNER TO demorabiherp_karim;

--
-- Name: maintainc_bills_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.maintainc_bills_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.maintainc_bills_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: maintainc_bills_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.maintainc_bills_arr_seq OWNED BY public.maintainc_bills.arr;


--
-- Name: maintainc_bills_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.maintainc_bills_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.maintainc_bills_id_seq OWNER TO demorabiherp_karim;

--
-- Name: maintainc_bills_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.maintainc_bills_id_seq OWNED BY public.maintainc_bills.id;


--
-- Name: maintaince_colors; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.maintaince_colors (
    id bigint NOT NULL,
    "Refuse" text,
    "Reported_Client" text,
    "Refused_Client" text,
    "Edited" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.maintaince_colors OWNER TO demorabiherp_karim;

--
-- Name: maintaince_colors_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.maintaince_colors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.maintaince_colors_id_seq OWNER TO demorabiherp_karim;

--
-- Name: maintaince_colors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.maintaince_colors_id_seq OWNED BY public.maintaince_colors.id;


--
-- Name: maintaince_default_data; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.maintaince_default_data (
    id bigint NOT NULL,
    "Company" text,
    "Device_Type" text,
    "Device_Case" text,
    "Coin" text,
    "Cost_Center" text,
    "Draw" text,
    "Client" text,
    "Sure" text,
    "Eng" text,
    "Recipient" text,
    "Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.maintaince_default_data OWNER TO demorabiherp_karim;

--
-- Name: maintaince_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.maintaince_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.maintaince_default_data_id_seq OWNER TO demorabiherp_karim;

--
-- Name: maintaince_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.maintaince_default_data_id_seq OWNED BY public.maintaince_default_data.id;


--
-- Name: manu_store_counts; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.manu_store_counts (
    id bigint NOT NULL,
    "Store" text NOT NULL,
    "Total" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.manu_store_counts OWNER TO demorabiherp_karim;

--
-- Name: manu_store_counts_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.manu_store_counts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manu_store_counts_id_seq OWNER TO demorabiherp_karim;

--
-- Name: manu_store_counts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.manu_store_counts_id_seq OWNED BY public.manu_store_counts.id;


--
-- Name: manufacture_companies; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.manufacture_companies (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.manufacture_companies OWNER TO demorabiherp_karim;

--
-- Name: manufacture_companies_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.manufacture_companies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacture_companies_id_seq OWNER TO demorabiherp_karim;

--
-- Name: manufacture_companies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.manufacture_companies_id_seq OWNED BY public.manufacture_companies.id;


--
-- Name: manufacturing_default_data; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.manufacturing_default_data (
    id bigint NOT NULL,
    "Coin" text,
    "Draw" text,
    "Hall" text,
    "Manu_Type" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Executing_Qty" text
);


ALTER TABLE public.manufacturing_default_data OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.manufacturing_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_default_data_id_seq OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.manufacturing_default_data_id_seq OWNED BY public.manufacturing_default_data.id;


--
-- Name: manufacturing_executions; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.manufacturing_executions (
    id bigint NOT NULL,
    "Code" text,
    "NewCode" text,
    "Date" text,
    "Manu_Order_Code" text,
    "Manu_Order_Date" text,
    "Recived_Date" text,
    "Manu_Request_Code" text,
    "Outcome_Name" text,
    "Outcome_Code" text,
    "Outcome_Qty" text,
    "Except_Qty" text,
    "Outcome_Unit" text,
    "Outcome_Store" text,
    "Patch_Number" text,
    "Manu_Order_ID" bigint,
    "Production_Manager" bigint,
    "Quality_Manager" bigint,
    "Model" bigint,
    "Note" text,
    "Status" text,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.manufacturing_executions OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_executions_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.manufacturing_executions_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_executions_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_executions_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.manufacturing_executions_arr_seq OWNED BY public.manufacturing_executions.arr;


--
-- Name: manufacturing_executions_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.manufacturing_executions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_executions_id_seq OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_executions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.manufacturing_executions_id_seq OWNED BY public.manufacturing_executions.id;


--
-- Name: manufacturing_halls; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.manufacturing_halls (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.manufacturing_halls OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_halls_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.manufacturing_halls_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_halls_id_seq OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_halls_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.manufacturing_halls_id_seq OWNED BY public.manufacturing_halls.id;


--
-- Name: manufacturing_models; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.manufacturing_models (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Name" text NOT NULL,
    "Time" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Discount" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Hall" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text DEFAULT 1,
    "NameEn" text,
    "Incom_Store" text,
    "Outcom_Store" text,
    "Workmanship_Price" text
);


ALTER TABLE public.manufacturing_models OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_models_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.manufacturing_models_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_models_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_models_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.manufacturing_models_arr_seq OWNED BY public.manufacturing_models."Code";


--
-- Name: manufacturing_models_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.manufacturing_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_models_id_seq OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.manufacturing_models_id_seq OWNED BY public.manufacturing_models.id;


--
-- Name: manufacturing_orders; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.manufacturing_orders (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Model" text,
    "Name_Outcome" text,
    "Except_Qty" text,
    "Total_Required_Qty" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text,
    "For_Client" text,
    "Client" bigint,
    "Client_Phone" text,
    "Client_Address" text,
    "Delegate" bigint,
    arr bigint,
    "Delegate_Phone" text,
    "Recived_Date" text,
    "Manufacture_Request_Code" bigint,
    "NewCode" text,
    "Recipient" text
);


ALTER TABLE public.manufacturing_orders OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_orders_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.manufacturing_orders_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_orders_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_orders_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.manufacturing_orders_arr_seq OWNED BY public.manufacturing_orders.arr;


--
-- Name: manufacturing_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.manufacturing_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_orders_id_seq OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.manufacturing_orders_id_seq OWNED BY public.manufacturing_orders.id;


--
-- Name: manufacturing_requests; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.manufacturing_requests (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Recived_Date" text,
    "Client_Phone" text,
    "Client_Address" text,
    "Client" bigint NOT NULL,
    "Delegate" bigint,
    "Delegate_Phone" text,
    "Payment_Method" text,
    "Later_Due" text,
    "Note" text,
    "Status" text,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Store" bigint
);


ALTER TABLE public.manufacturing_requests OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_requests_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.manufacturing_requests_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_requests_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_requests_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.manufacturing_requests_arr_seq OWNED BY public.manufacturing_requests.arr;


--
-- Name: manufacturing_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.manufacturing_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_requests_id_seq OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.manufacturing_requests_id_seq OWNED BY public.manufacturing_requests.id;


--
-- Name: manufacturing_secretariat_models; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.manufacturing_secretariat_models (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Name" text,
    "Time" text,
    "Draw" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Hall" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Type" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text,
    arr bigint,
    "Incom_Store" text DEFAULT 0,
    "Outcom_Store" text DEFAULT 0
);


ALTER TABLE public.manufacturing_secretariat_models OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_secretariat_models_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.manufacturing_secretariat_models_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_secretariat_models_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_secretariat_models_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.manufacturing_secretariat_models_arr_seq OWNED BY public.manufacturing_secretariat_models.arr;


--
-- Name: manufacturing_secretariat_models_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.manufacturing_secretariat_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_secretariat_models_id_seq OWNER TO demorabiherp_karim;

--
-- Name: manufacturing_secretariat_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.manufacturing_secretariat_models_id_seq OWNED BY public.manufacturing_secretariat_models.id;


--
-- Name: measuerments; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.measuerments (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Note" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Code" text,
    "NameEn" text
);


ALTER TABLE public.measuerments OWNER TO demorabiherp_karim;

--
-- Name: measuerments_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.measuerments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.measuerments_id_seq OWNER TO demorabiherp_karim;

--
-- Name: measuerments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.measuerments_id_seq OWNED BY public.measuerments.id;


--
-- Name: migrations_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.migrations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 2147483647
    CACHE 1;


ALTER TABLE public.migrations_id_seq OWNER TO demorabiherp_karim;

--
-- Name: migrations; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.migrations (
    id integer DEFAULT nextval('public.migrations_id_seq'::regclass) NOT NULL,
    migration character varying(191),
    batch integer
);


ALTER TABLE public.migrations OWNER TO demorabiherp_karim;

--
-- Name: missions; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.missions (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Start_Date" text NOT NULL,
    "End_Date" text NOT NULL,
    "Duration" text NOT NULL,
    "Value" text NOT NULL,
    "Status" text NOT NULL,
    "File" text,
    "Desc" text,
    "Task_Owner" bigint,
    "Observer" bigint,
    "Project" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.missions OWNER TO demorabiherp_karim;

--
-- Name: missions_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.missions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.missions_id_seq OWNER TO demorabiherp_karim;

--
-- Name: missions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.missions_id_seq OWNED BY public.missions.id;


--
-- Name: model_has_permissions; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.model_has_permissions (
    permission_id bigint NOT NULL,
    model_type character varying(191) NOT NULL,
    model_id bigint NOT NULL
);


ALTER TABLE public.model_has_permissions OWNER TO demorabiherp_karim;

--
-- Name: model_has_roles; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.model_has_roles (
    role_id bigint NOT NULL,
    model_type character varying(191) NOT NULL,
    model_id bigint NOT NULL
);


ALTER TABLE public.model_has_roles OWNER TO demorabiherp_karim;

--
-- Name: module_settings_nums; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.module_settings_nums (
    id bigint NOT NULL,
    "Branch_Select" text,
    "Branch_Num" text,
    "Store_Select" text,
    "Store_Num" text,
    "Users_Select" text,
    "Users_Num" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "System" text,
    "Expire_Date" text,
    "Type" text,
    "Price" text,
    "Edit_System" text,
    "Delete_System" text,
    "Fingerprint" text,
    "Fingerprint_IP" text,
    "Fingerprint_Name" text,
    "Fingerprint_Attendence" text
);


ALTER TABLE public.module_settings_nums OWNER TO demorabiherp_karim;

--
-- Name: module_settings_nums_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.module_settings_nums_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.module_settings_nums_id_seq OWNER TO demorabiherp_karim;

--
-- Name: module_settings_nums_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.module_settings_nums_id_seq OWNED BY public.module_settings_nums.id;


--
-- Name: modules; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.modules (
    id bigint NOT NULL,
    "Capital" text,
    "Accounts" text,
    "Stores" text,
    "CRM" text,
    "HR" text,
    "Manufacturing" text,
    "Maintenance" text,
    "Secretariat" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Petrol" text,
    "ECommerce" text,
    "Shipping" text DEFAULT 0,
    "Bill_Electronic" text,
    "Hotels" text,
    "Resturant" text,
    "Traning_Center" text,
    "Translate" text,
    "Real_States" text DEFAULT 0
);


ALTER TABLE public.modules OWNER TO demorabiherp_karim;

--
-- Name: modules_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.modules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.modules_id_seq OWNER TO demorabiherp_karim;

--
-- Name: modules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.modules_id_seq OWNED BY public.modules.id;


--
-- Name: more_products_halls; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.more_products_halls (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "CostPrice" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "Store" text,
    "Product" text,
    "Exp_Date" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "SalesOrder" text,
    "Pro_Note" text,
    "KitchenEnd" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.more_products_halls OWNER TO demorabiherp_karim;

--
-- Name: more_products_halls_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.more_products_halls_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.more_products_halls_id_seq OWNER TO demorabiherp_karim;

--
-- Name: more_products_halls_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.more_products_halls_id_seq OWNED BY public.more_products_halls.id;


--
-- Name: most_sales_products_column_sechdules; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.most_sales_products_column_sechdules (
    id bigint NOT NULL,
    "Product_Code" text,
    "Product_Name" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total" text,
    "Store" text,
    "Date" text,
    "Unit" text,
    "Safe" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.most_sales_products_column_sechdules OWNER TO demorabiherp_karim;

--
-- Name: most_sales_products_column_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.most_sales_products_column_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.most_sales_products_column_sechdules_id_seq OWNER TO demorabiherp_karim;

--
-- Name: most_sales_products_column_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.most_sales_products_column_sechdules_id_seq OWNED BY public.most_sales_products_column_sechdules.id;


--
-- Name: most_sales_products_columns; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.most_sales_products_columns (
    id bigint NOT NULL,
    "Product_Code" text,
    "Product_Name" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total" text,
    "Store" text,
    "Date" text,
    "Unit" text,
    "Safe" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.most_sales_products_columns OWNER TO demorabiherp_karim;

--
-- Name: most_sales_products_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.most_sales_products_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.most_sales_products_columns_id_seq OWNER TO demorabiherp_karim;

--
-- Name: most_sales_products_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.most_sales_products_columns_id_seq OWNED BY public.most_sales_products_columns.id;


--
-- Name: msg_rqsts; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.msg_rqsts (
    id bigint NOT NULL,
    "Name" text,
    "Email" text,
    "Phone" text,
    "Subject" text,
    "Msg" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.msg_rqsts OWNER TO demorabiherp_karim;

--
-- Name: msg_rqsts_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.msg_rqsts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.msg_rqsts_id_seq OWNER TO demorabiherp_karim;

--
-- Name: msg_rqsts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.msg_rqsts_id_seq OWNED BY public.msg_rqsts.id;


--
-- Name: my_follow_lists; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.my_follow_lists (
    id bigint NOT NULL,
    "Date" text,
    "Emp" text,
    "Day" text,
    "Status" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.my_follow_lists OWNER TO demorabiherp_karim;

--
-- Name: my_follow_lists_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.my_follow_lists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.my_follow_lists_id_seq OWNER TO demorabiherp_karim;

--
-- Name: my_follow_lists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.my_follow_lists_id_seq OWNED BY public.my_follow_lists.id;


--
-- Name: new_shipping_categories; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.new_shipping_categories (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Code" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.new_shipping_categories OWNER TO demorabiherp_karim;

--
-- Name: new_shipping_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.new_shipping_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.new_shipping_categories_id_seq OWNER TO demorabiherp_karim;

--
-- Name: new_shipping_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.new_shipping_categories_id_seq OWNED BY public.new_shipping_categories.id;


--
-- Name: new_shipping_rqst_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.new_shipping_rqst_types (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.new_shipping_rqst_types OWNER TO demorabiherp_karim;

--
-- Name: new_shipping_rqst_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.new_shipping_rqst_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.new_shipping_rqst_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: new_shipping_rqst_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.new_shipping_rqst_types_id_seq OWNED BY public.new_shipping_rqst_types.id;


--
-- Name: new_shipping_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.new_shipping_types (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Code" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.new_shipping_types OWNER TO demorabiherp_karim;

--
-- Name: new_shipping_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.new_shipping_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.new_shipping_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: new_shipping_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.new_shipping_types_id_seq OWNED BY public.new_shipping_types.id;


--
-- Name: notifications; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.notifications (
    id bigint NOT NULL,
    "Date" text,
    "Status" text,
    "Noti_Ar_Name" text,
    "Noti_En_Name" text,
    "Type" text,
    "Type_Code" text,
    "Emp" text,
    "Client" text,
    "Product" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Store" text,
    "Safe" text,
    "TypeEn" text
);


ALTER TABLE public.notifications OWNER TO demorabiherp_karim;

--
-- Name: notifications_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.notifications_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.notifications_id_seq OWNER TO demorabiherp_karim;

--
-- Name: notifications_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.notifications_id_seq OWNED BY public.notifications.id;


--
-- Name: opening_entries; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.opening_entries (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Total_Debaitor" text NOT NULL,
    "Total_Creditor" text NOT NULL,
    "Note" text,
    "Capital" text NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "SecAccount" bigint,
    "Status" text,
    "Edit" text,
    "Edit_New_Code" text,
    "Delete" text
);


ALTER TABLE public.opening_entries OWNER TO demorabiherp_karim;

--
-- Name: opening_entries_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.opening_entries_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.opening_entries_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: opening_entries_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.opening_entries_arr_seq OWNED BY public.opening_entries.arr;


--
-- Name: opening_entries_details; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.opening_entries_details (
    id bigint NOT NULL,
    "Debitor" text NOT NULL,
    "Creditor" text NOT NULL,
    "Statement" text,
    "Account" bigint NOT NULL,
    "OP_ID" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.opening_entries_details OWNER TO demorabiherp_karim;

--
-- Name: opening_entries_details_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.opening_entries_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.opening_entries_details_id_seq OWNER TO demorabiherp_karim;

--
-- Name: opening_entries_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.opening_entries_details_id_seq OWNED BY public.opening_entries_details.id;


--
-- Name: opening_entries_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.opening_entries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.opening_entries_id_seq OWNER TO demorabiherp_karim;

--
-- Name: opening_entries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.opening_entries_id_seq OWNED BY public.opening_entries.id;


--
-- Name: order_pays; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.order_pays (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Responsible" text,
    "Account" text,
    "Amount" text,
    "Note" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.order_pays OWNER TO demorabiherp_karim;

--
-- Name: order_pays_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.order_pays_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.order_pays_id_seq OWNER TO demorabiherp_karim;

--
-- Name: order_pays_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.order_pays_id_seq OWNED BY public.order_pays.id;


--
-- Name: outcom_manufacturing_models; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.outcom_manufacturing_models (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text NOT NULL,
    "P_En_Name" text NOT NULL,
    "Qty" text NOT NULL,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "Unit" bigint,
    "Model" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Cost" text,
    "SmallQty" text,
    "SmallCode" text
);


ALTER TABLE public.outcom_manufacturing_models OWNER TO demorabiherp_karim;

--
-- Name: outcom_manufacturing_models_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.outcom_manufacturing_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.outcom_manufacturing_models_id_seq OWNER TO demorabiherp_karim;

--
-- Name: outcom_manufacturing_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.outcom_manufacturing_models_id_seq OWNED BY public.outcom_manufacturing_models.id;


--
-- Name: outcome_manufacturing_secretariat_models; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.outcome_manufacturing_secretariat_models (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Qty" text,
    "SmallQty" text,
    "SmallCode" text,
    "Store" text,
    "Product" text,
    "Unit" text,
    "Model" text,
    "Cost" text,
    "Workmanship_Price" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.outcome_manufacturing_secretariat_models OWNER TO demorabiherp_karim;

--
-- Name: outcome_manufacturing_secretariat_models_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.outcome_manufacturing_secretariat_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.outcome_manufacturing_secretariat_models_id_seq OWNER TO demorabiherp_karim;

--
-- Name: outcome_manufacturing_secretariat_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.outcome_manufacturing_secretariat_models_id_seq OWNED BY public.outcome_manufacturing_secretariat_models.id;


--
-- Name: over_times; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.over_times (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Hour" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.over_times OWNER TO demorabiherp_karim;

--
-- Name: over_times_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.over_times_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.over_times_id_seq OWNER TO demorabiherp_karim;

--
-- Name: over_times_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.over_times_id_seq OWNED BY public.over_times.id;


--
-- Name: pack_prems; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.pack_prems (
    id bigint NOT NULL,
    package text,
    premission text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.pack_prems OWNER TO demorabiherp_karim;

--
-- Name: pack_prems_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.pack_prems_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pack_prems_id_seq OWNER TO demorabiherp_karim;

--
-- Name: pack_prems_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.pack_prems_id_seq OWNED BY public.pack_prems.id;


--
-- Name: packages; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.packages (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.packages OWNER TO demorabiherp_karim;

--
-- Name: packages_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.packages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.packages_id_seq OWNER TO demorabiherp_karim;

--
-- Name: packages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.packages_id_seq OWNED BY public.packages.id;


--
-- Name: partners; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.partners (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Shares_Number" text NOT NULL,
    "Nominal_Value_of_Shares" text,
    "Actual_Share_Value" text,
    "Profits_Precentage" text,
    "Profits" text,
    "Withdraw_Profits" text,
    "Remaining_Profits" text,
    "Account" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Gary_Account" text,
    "Recent_Profit_Account" text,
    "Stage_Profit_Account" text,
    "First_Partner_Share" text,
    "Now_Partner_Share" text,
    "Capital_Increase_Rate" text,
    "Capital_Increase_Value" text,
    "Partnership_Ratio" text
);


ALTER TABLE public.partners OWNER TO demorabiherp_karim;

--
-- Name: partners_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.partners_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.partners_id_seq OWNER TO demorabiherp_karim;

--
-- Name: partners_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.partners_id_seq OWNED BY public.partners.id;


--
-- Name: password_resets; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.password_resets (
    email character varying(191) NOT NULL,
    token character varying(191) NOT NULL,
    created_at timestamp(0) without time zone
);


ALTER TABLE public.password_resets OWNER TO demorabiherp_karim;

--
-- Name: pay_profit_investors; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.pay_profit_investors (
    id bigint NOT NULL,
    "Date" text,
    "Profit" text,
    "Investor" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.pay_profit_investors OWNER TO demorabiherp_karim;

--
-- Name: pay_profit_investors_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.pay_profit_investors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pay_profit_investors_id_seq OWNER TO demorabiherp_karim;

--
-- Name: pay_profit_investors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.pay_profit_investors_id_seq OWNED BY public.pay_profit_investors.id;


--
-- Name: pay_salaries; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.pay_salaries (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Salary" text NOT NULL,
    "Pre_Sales" text,
    "Pre_Execu" text,
    "Deduction" text NOT NULL,
    "Entitlement" text NOT NULL,
    "Borrow" text NOT NULL,
    "Overtime" text,
    "Attendence_Hours" text,
    "Attendence" text,
    "Loan" text,
    "Holidays" text,
    "Resduial_Salary" text,
    "Note" text,
    "Draw" text NOT NULL,
    "Safe" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Emp" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Attendence_Discount" text,
    "Holiday_Discount" text,
    "Settlements" text,
    "Later_Sales_Bill" text,
    "Allowances" text,
    "Discounts" text,
    "ProducationPoints" text,
    "DiscountLate" text,
    "DiscountDeparture" text,
    "Shipping_Precent" text,
    "Delete" text DEFAULT 0
);


ALTER TABLE public.pay_salaries OWNER TO demorabiherp_karim;

--
-- Name: pay_salaries_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.pay_salaries_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pay_salaries_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: pay_salaries_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.pay_salaries_arr_seq OWNED BY public.pay_salaries."Code";


--
-- Name: pay_salaries_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.pay_salaries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pay_salaries_id_seq OWNER TO demorabiherp_karim;

--
-- Name: pay_salaries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.pay_salaries_id_seq OWNED BY public.pay_salaries.id;


--
-- Name: payment_voucher_details; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.payment_voucher_details (
    id bigint NOT NULL,
    "Debitor" text NOT NULL,
    "Statement" text,
    "Account" bigint NOT NULL,
    "PV_ID" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Date" text,
    "Time" text,
    "Cost_Center" text,
    "Coin" text,
    "User" text,
    "Branch" text,
    "Safe" text,
    "Bill_Num" text,
    "Order_Number" text,
    "Tax" text
);


ALTER TABLE public.payment_voucher_details OWNER TO demorabiherp_karim;

--
-- Name: payment_voucher_details_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.payment_voucher_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.payment_voucher_details_id_seq OWNER TO demorabiherp_karim;

--
-- Name: payment_voucher_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.payment_voucher_details_id_seq OWNED BY public.payment_voucher_details.id;


--
-- Name: payment_vouchers; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.payment_vouchers (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Total_Debaitor" text NOT NULL,
    "Note" text,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Safe" bigint NOT NULL,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Shift" text,
    "Store" text,
    "User" text,
    "Branch" text,
    "Status" text,
    "File" text,
    "Edit" text,
    "Edit_New_Code" text,
    "Delete" text,
    "Responsiple" text,
    "Project" text
);


ALTER TABLE public.payment_vouchers OWNER TO demorabiherp_karim;

--
-- Name: payment_vouchers_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.payment_vouchers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.payment_vouchers_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: payment_vouchers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.payment_vouchers_arr_seq OWNED BY public.payment_vouchers.arr;


--
-- Name: payment_vouchers_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.payment_vouchers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.payment_vouchers_id_seq OWNER TO demorabiherp_karim;

--
-- Name: payment_vouchers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.payment_vouchers_id_seq OWNED BY public.payment_vouchers.id;


--
-- Name: paymentss_products_real_projects; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.paymentss_products_real_projects (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "CostPrice" text,
    "Discount" text,
    "TDiscount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "TotCostNew" text,
    "Total_Net" text,
    "Store" text,
    "Product" text,
    "Unit" text,
    "Payment" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Pro_Desc" text
);


ALTER TABLE public.paymentss_products_real_projects OWNER TO demorabiherp_karim;

--
-- Name: paymentss_products_real_projects_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.paymentss_products_real_projects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.paymentss_products_real_projects_id_seq OWNER TO demorabiherp_karim;

--
-- Name: paymentss_products_real_projects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.paymentss_products_real_projects_id_seq OWNED BY public.paymentss_products_real_projects.id;


--
-- Name: paymentss_real_projects; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.paymentss_real_projects (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Time" text,
    "Branch" text,
    "Draw" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Total_Cost" text,
    "Total_Net" text,
    "DiscountBill" text,
    "Pay" text,
    "Safe" text,
    "Client" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Edit" text,
    "Delete" text,
    "Edit_New_Code" text,
    "Project" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.paymentss_real_projects OWNER TO demorabiherp_karim;

--
-- Name: paymentss_real_projects_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.paymentss_real_projects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.paymentss_real_projects_id_seq OWNER TO demorabiherp_karim;

--
-- Name: paymentss_real_projects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.paymentss_real_projects_id_seq OWNED BY public.paymentss_real_projects.id;


--
-- Name: permission_to_exchange_goods; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.permission_to_exchange_goods (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Total_Discount" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Account" bigint NOT NULL,
    "Store" bigint NOT NULL,
    "To_Store" bigint,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0,
    "DiscountBill" text DEFAULT 0
);


ALTER TABLE public.permission_to_exchange_goods OWNER TO demorabiherp_karim;

--
-- Name: permission_to_exchange_goods_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.permission_to_exchange_goods_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permission_to_exchange_goods_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: permission_to_exchange_goods_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.permission_to_exchange_goods_arr_seq OWNED BY public.permission_to_exchange_goods.arr;


--
-- Name: permission_to_exchange_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.permission_to_exchange_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permission_to_exchange_goods_id_seq OWNER TO demorabiherp_karim;

--
-- Name: permission_to_exchange_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.permission_to_exchange_goods_id_seq OWNED BY public.permission_to_exchange_goods.id;


--
-- Name: permission_to_recived_goods; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.permission_to_recived_goods (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Total_Discount" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Account" bigint NOT NULL,
    "Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "To_Store" bigint,
    "Status" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0,
    "DiscountBill" text DEFAULT 0
);


ALTER TABLE public.permission_to_recived_goods OWNER TO demorabiherp_karim;

--
-- Name: permission_to_recived_goods_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.permission_to_recived_goods_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permission_to_recived_goods_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: permission_to_recived_goods_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.permission_to_recived_goods_arr_seq OWNED BY public.permission_to_recived_goods.arr;


--
-- Name: permission_to_recived_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.permission_to_recived_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permission_to_recived_goods_id_seq OWNER TO demorabiherp_karim;

--
-- Name: permission_to_recived_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.permission_to_recived_goods_id_seq OWNED BY public.permission_to_recived_goods.id;


--
-- Name: permissions; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.permissions (
    id bigint NOT NULL,
    name character varying(191) NOT NULL,
    guard_name character varying(191) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Parent" text,
    "Main" text,
    "nameEn" text,
    "Package" text
);


ALTER TABLE public.permissions OWNER TO demorabiherp_karim;

--
-- Name: permissions_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permissions_id_seq OWNER TO demorabiherp_karim;

--
-- Name: permissions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.permissions_id_seq OWNED BY public.permissions.id;


--
-- Name: places; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.places (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Ship_Price" text,
    "City" bigint,
    "Delivery" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "SearchCode" text
);


ALTER TABLE public.places OWNER TO demorabiherp_karim;

--
-- Name: places_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.places_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.places_id_seq OWNER TO demorabiherp_karim;

--
-- Name: places_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.places_id_seq OWNED BY public.places.id;


--
-- Name: platforms; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.platforms (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.platforms OWNER TO demorabiherp_karim;

--
-- Name: platforms_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.platforms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.platforms_id_seq OWNER TO demorabiherp_karim;

--
-- Name: platforms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.platforms_id_seq OWNED BY public.platforms.id;


--
-- Name: polices; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.polices (
    id bigint NOT NULL,
    "Arabic_Desc" text NOT NULL,
    "English_Desc" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.polices OWNER TO demorabiherp_karim;

--
-- Name: polices_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.polices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.polices_id_seq OWNER TO demorabiherp_karim;

--
-- Name: polices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.polices_id_seq OWNED BY public.polices.id;


--
-- Name: pro_details_imgs; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.pro_details_imgs (
    id bigint NOT NULL,
    "Image" text NOT NULL,
    "Arabic_Title" text NOT NULL,
    "Arabic_Desc" text NOT NULL,
    "English_Title" text NOT NULL,
    "English_Desc" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.pro_details_imgs OWNER TO demorabiherp_karim;

--
-- Name: pro_details_imgs_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.pro_details_imgs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pro_details_imgs_id_seq OWNER TO demorabiherp_karim;

--
-- Name: pro_details_imgs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.pro_details_imgs_id_seq OWNED BY public.pro_details_imgs.id;


--
-- Name: pro_notes; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.pro_notes (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.pro_notes OWNER TO demorabiherp_karim;

--
-- Name: pro_notes_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.pro_notes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pro_notes_id_seq OWNER TO demorabiherp_karim;

--
-- Name: pro_notes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.pro_notes_id_seq OWNED BY public.pro_notes.id;


--
-- Name: product_details_e_com_designs; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_details_e_com_designs (
    id bigint NOT NULL,
    "Title_Color" text,
    "Txt_Color" text,
    "Price_Color" text,
    "Rate_Color" text,
    "Select_BG_Color" text,
    "Select_Txt_Color" text,
    "Qty_BG_Color" text,
    "Qty_Txt_Color" text,
    "Qty_Input_BG_Color" text,
    "Qty_Input_Txt_Color" text,
    "Comment_Input_BG_Color" text,
    "Comment_Button_BG_Color" text,
    "Comment_Button_Txt_Color" text,
    "Comment_Button_BG_Hover_Color" text,
    "Comment_Button_Txt_Hover_Color" text,
    "Related_Title_BG_Color" text,
    "Related_Title_Txt_Color" text,
    "Related_Product_BG_Color" text,
    "Related_Product_Group_BG_Color" text,
    "Related_Product_Group_Txt_Color" text,
    "Related_Product_Group_Hover_BG_Color" text,
    "Related_Product_Group_Hover_Txt_Color" text,
    "Related_Product_Icon_BG_Color" text,
    "Related_Product_Icon_Txt_Color" text,
    "Related_Product_Icon_Hover_BG_Color" text,
    "Related_Product_Icon_Hover_Txt_Color" text,
    "Related_Product_Txt_Color" text,
    "Related_Product_Price_Color" text,
    "Related_Product_Hover_Price_Color" text,
    "Related_Product_Rate_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_details_e_com_designs OWNER TO demorabiherp_karim;

--
-- Name: product_details_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_details_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_details_e_com_designs_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_details_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_details_e_com_designs_id_seq OWNED BY public.product_details_e_com_designs.id;


--
-- Name: product_executing_receiving_secretariats; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_executing_receiving_secretariats (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Qty" text,
    "Dep" text,
    "Price" text,
    "Workmanship_Price" text,
    "Total" text,
    "StoreIn" text,
    "StoreOut" text,
    "Product" text,
    "Unit" text,
    "Executing" text,
    type text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_executing_receiving_secretariats OWNER TO demorabiherp_karim;

--
-- Name: product_executing_receiving_secretariats_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_executing_receiving_secretariats_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_executing_receiving_secretariats_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_executing_receiving_secretariats_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_executing_receiving_secretariats_id_seq OWNED BY public.product_executing_receiving_secretariats.id;


--
-- Name: product_inventories; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_inventories (
    id bigint NOT NULL,
    "Av_Qty" text NOT NULL,
    "Inventory" text NOT NULL,
    "Deficit" text NOT NULL,
    "Excess" text NOT NULL,
    "Inv_ID" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "P_Code" text,
    "Price" text,
    "TotalExcessP" text,
    "TotalDificitP" text,
    "Exp_Date" text
);


ALTER TABLE public.product_inventories OWNER TO demorabiherp_karim;

--
-- Name: product_inventories_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_inventories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_inventories_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_inventories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_inventories_id_seq OWNED BY public.product_inventories.id;


--
-- Name: product_job_orders; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_job_orders (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "TDiscount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "Store" text,
    "Length" text,
    "Width" text,
    "Height" text,
    "Thickness" text,
    "Size" text,
    "Product" text,
    "Unit" text,
    "Order" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Executor" text
);


ALTER TABLE public.product_job_orders OWNER TO demorabiherp_karim;

--
-- Name: product_job_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_job_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_job_orders_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_job_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_job_orders_id_seq OWNED BY public.product_job_orders.id;


--
-- Name: product_maintainc_bills; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_maintainc_bills (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text NOT NULL,
    "AvQty" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Maintaince" bigint NOT NULL,
    "TDiscount" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    "Date" text
);


ALTER TABLE public.product_maintainc_bills OWNER TO demorabiherp_karim;

--
-- Name: product_maintainc_bills_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_maintainc_bills_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_maintainc_bills_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_maintainc_bills_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_maintainc_bills_id_seq OWNED BY public.product_maintainc_bills.id;


--
-- Name: product_manufacturing_executions; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_manufacturing_executions (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text NOT NULL,
    "P_En_Name" text NOT NULL,
    "Qty" text NOT NULL,
    "Precent" text,
    "RequiredQty" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "Unit" bigint,
    "ManuExecution" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Patch_Number" text
);


ALTER TABLE public.product_manufacturing_executions OWNER TO demorabiherp_karim;

--
-- Name: product_manufacturing_executions_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_manufacturing_executions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_manufacturing_executions_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_manufacturing_executions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_manufacturing_executions_id_seq OWNED BY public.product_manufacturing_executions.id;


--
-- Name: product_moves; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_moves (
    id bigint NOT NULL,
    "Date" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Current" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "Unit" bigint,
    "Group" bigint,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "CostIn" text,
    "CostOut" text,
    "CostCurrent" text,
    "QTY" text,
    "Brand" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    "Delegate" text,
    "Payment_Method" text,
    "Safe" bigint,
    "TypeEn" text,
    "Delete" text DEFAULT 0,
    "Edit" text DEFAULT 0,
    "Edit_New_Code" text
);


ALTER TABLE public.product_moves OWNER TO demorabiherp_karim;

--
-- Name: product_moves_columns; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_moves_columns (
    id bigint NOT NULL,
    "Date" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Credit" text,
    "Group" text,
    "Brand" text,
    "Store" text,
    "User" text,
    "Safe" text,
    "Branch" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_moves_columns OWNER TO demorabiherp_karim;

--
-- Name: product_moves_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_moves_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_moves_columns_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_moves_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_moves_columns_id_seq OWNED BY public.product_moves_columns.id;


--
-- Name: product_moves_columns_sechdules; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_moves_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Credit" text,
    "Group" text,
    "Brand" text,
    "Store" text,
    "User" text,
    "Safe" text,
    "Branch" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_moves_columns_sechdules OWNER TO demorabiherp_karim;

--
-- Name: product_moves_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_moves_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_moves_columns_sechdules_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_moves_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_moves_columns_sechdules_id_seq OWNED BY public.product_moves_columns_sechdules.id;


--
-- Name: product_moves_filter_twos; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_moves_filter_twos (
    id bigint NOT NULL,
    "Date" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Current" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "Unit" text,
    "Group" text,
    "Store" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "User" text,
    "CostIn" text,
    "CostOut" text,
    "CostCurrent" text,
    "CostOneIn" text,
    "CostOneOut" text,
    "CostOneCurrent" text,
    "QTY" text,
    "Brand" text,
    "Safe" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_moves_filter_twos OWNER TO demorabiherp_karim;

--
-- Name: product_moves_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_moves_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_moves_filter_twos_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_moves_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_moves_filter_twos_id_seq OWNED BY public.product_moves_filter_twos.id;


--
-- Name: product_moves_filters; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_moves_filters (
    id bigint NOT NULL,
    "Date" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Current" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "Unit" text,
    "Group" text,
    "Store" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "User" text,
    "CostIn" text,
    "CostOut" text,
    "CostCurrent" text,
    "CostOneIn" text,
    "CostOneOut" text,
    "CostOneCurrent" text,
    "QTY" text,
    "Brand" text,
    "Safe" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_moves_filters OWNER TO demorabiherp_karim;

--
-- Name: product_moves_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_moves_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_moves_filters_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_moves_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_moves_filters_id_seq OWNED BY public.product_moves_filters.id;


--
-- Name: product_moves_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_moves_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_moves_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_moves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_moves_id_seq OWNED BY public.product_moves.id;


--
-- Name: product_quote_images; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_quote_images (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text NOT NULL,
    "P_En_Name" text NOT NULL,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "QuoteImage" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "TDiscount" text,
    "Original_Qty" text,
    "AvQty" text,
    "Store" text,
    "Exp_Date" text,
    "Total_Wight" text,
    "UnitRate" text,
    weight text,
    "SalesProDesc" text,
    "TotCostNew" text,
    "SmallQty" text,
    "SmallCode" text,
    "CostPrice" text,
    "Date" text,
    "Patch_Number" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    "Pro_Note" text,
    "SubVID" text,
    "Total_Net" text
);


ALTER TABLE public.product_quote_images OWNER TO demorabiherp_karim;

--
-- Name: product_quote_images_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_quote_images_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_quote_images_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_quote_images_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_quote_images_id_seq OWNED BY public.product_quote_images.id;


--
-- Name: product_return_without_bills; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_return_without_bills (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "SmallCode" text,
    "Qty" text,
    "SmallQty" text,
    "Price" text,
    "Cost" text,
    "Discount" text,
    "TDiscount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "Total_Cost" text,
    "Store" text,
    "Exp_Date" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "Date" text,
    "Code" text,
    "Refernce_Number" text,
    "Safe" text,
    "Vendor" text,
    "Delegate" text,
    "Coin" text,
    "User" text,
    "Cost_Center" text,
    "Type" text,
    "Payment_Method" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Bill" bigint,
    "Product" bigint
);


ALTER TABLE public.product_return_without_bills OWNER TO demorabiherp_karim;

--
-- Name: product_return_without_bills_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_return_without_bills_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_return_without_bills_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_return_without_bills_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_return_without_bills_id_seq OWNED BY public.product_return_without_bills.id;


--
-- Name: product_sales; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_sales (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text NOT NULL,
    "AvQty" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Sales" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Date" text,
    "Code" text,
    "Delegate" bigint,
    "Client" bigint,
    "Executor" bigint,
    "Refernce_Number" text,
    "Type" text,
    "Cost_Center" bigint,
    "User" bigint,
    "Coin" bigint,
    "Safe" bigint,
    "Ship" bigint,
    "Patch_Number" text,
    "Later_Collection" text DEFAULT 1,
    "SmallQty" text,
    "SmallCode" text,
    "TDiscount" text,
    "CostPrice" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    "Status" text,
    "CustomerGroup" text,
    "Payment_Method" text,
    "CoinCode" text,
    "CoinRate" text,
    "CoinPrice" text,
    "AmountEGP" text,
    "SalesTotal" text,
    "DiscountAmount" text,
    "NetTotal" text,
    "TaxType" text,
    "TaxAmount" text,
    "TaxSubType" text,
    "TaxRate" text,
    "TotalBill" text,
    "TypeEn" text,
    "Pro_Note" text,
    "SubVID" text,
    "Total_Wight" text,
    "UnitRate" text,
    weight text,
    "SalesProDesc" text,
    "TotCostNew" text,
    "Total_Net" text
);


ALTER TABLE public.product_sales OWNER TO demorabiherp_karim;

--
-- Name: product_sales_gifts; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_sales_gifts (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "CostPrice" text,
    "Total" text,
    "TotCost" text,
    "Store" text,
    "Exp_Date" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "Gift" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Product" text
);


ALTER TABLE public.product_sales_gifts OWNER TO demorabiherp_karim;

--
-- Name: product_sales_gifts_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_sales_gifts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_sales_gifts_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_sales_gifts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_sales_gifts_id_seq OWNED BY public.product_sales_gifts.id;


--
-- Name: product_sales_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_sales_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_sales_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_sales_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_sales_id_seq OWNED BY public.product_sales.id;


--
-- Name: product_sales_orders; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_sales_orders (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text NOT NULL,
    "AvQty" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "SalesOrder" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Patch_Number" text,
    "TDiscount" text,
    "CostPrice" text,
    "Pro_Note" text,
    "SubVID" text,
    "Total_Wight" text,
    "UnitRate" text,
    weight text,
    "SalesProDesc" text,
    "TotCostNew" text,
    "SmallQty" text,
    "SmallCode" text,
    "Date" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    "Total_Net" text
);


ALTER TABLE public.product_sales_orders OWNER TO demorabiherp_karim;

--
-- Name: product_sales_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_sales_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_sales_orders_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_sales_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_sales_orders_id_seq OWNED BY public.product_sales_orders.id;


--
-- Name: product_sales_subscribes; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_sales_subscribes (
    id bigint NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Product_Code" text,
    "V_Name" text,
    "VV_Name" text,
    "Price" text,
    "Total" text,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Subscribe" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Sub_Date" text,
    "Sub_Type" text
);


ALTER TABLE public.product_sales_subscribes OWNER TO demorabiherp_karim;

--
-- Name: product_sales_subscribes_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_sales_subscribes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_sales_subscribes_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_sales_subscribes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_sales_subscribes_id_seq OWNED BY public.product_sales_subscribes.id;


--
-- Name: product_settlements; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_settlements (
    id bigint NOT NULL,
    "Av_Qty" text NOT NULL,
    "Inventory" text NOT NULL,
    "Deficit" text NOT NULL,
    "Excess" text NOT NULL,
    "Set_ID" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "P_Code" text,
    "Price" text,
    "TotalDificitP" text,
    "TotalExcessP" text,
    "Store" bigint,
    "User" bigint,
    "Coin" bigint,
    "Date" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Exp_Date" text
);


ALTER TABLE public.product_settlements OWNER TO demorabiherp_karim;

--
-- Name: product_settlements_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_settlements_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_settlements_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_settlements_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_settlements_id_seq OWNED BY public.product_settlements.id;


--
-- Name: product_type_defaults; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_type_defaults (
    id bigint NOT NULL,
    "Type" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_type_defaults OWNER TO demorabiherp_karim;

--
-- Name: product_type_defaults_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_type_defaults_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_type_defaults_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_type_defaults_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_type_defaults_id_seq OWNED BY public.product_type_defaults.id;


--
-- Name: product_units; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.product_units (
    id bigint NOT NULL,
    "Rate" text NOT NULL,
    "Barcode" text NOT NULL,
    "Price" text NOT NULL,
    "Price_Two" text,
    "Price_Three" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Type" text,
    "Unit" bigint,
    "Product" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Def" character varying DEFAULT 0,
    "Brand" text,
    "Group" text
);


ALTER TABLE public.product_units OWNER TO demorabiherp_karim;

--
-- Name: product_units_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.product_units_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_units_id_seq OWNER TO demorabiherp_karim;

--
-- Name: product_units_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.product_units_id_seq OWNED BY public.product_units.id;


--
-- Name: products; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products (
    id bigint NOT NULL,
    "P_Type" text NOT NULL,
    "P_Ar_Name" text NOT NULL,
    "P_En_Name" text,
    "Brand" bigint,
    "Group" bigint NOT NULL,
    "Image" text,
    "Minimum" text,
    "Maximum" text,
    "Length" text,
    "Width" text,
    "Height" text,
    "Weight" text,
    "Saller_Point" text,
    "Customer_Point" text,
    "Tax" bigint NOT NULL,
    "Validity" text,
    "Days_Notify" text,
    "Ar_Desc" text,
    "En_Desc" text,
    "Ar_Spec" text,
    "En_Spec" text,
    "Store_Show" text,
    "Store_Type" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Sub_Cost" character varying,
    subscribe_type bigint,
    "Cas_No" text,
    "HSN" text,
    "Uni_Code" text,
    "Image2" text,
    "Offer" text,
    "OfferPrice" text,
    rate text,
    "Code_Type" text,
    "World_Code" text,
    "Origin_Number" text,
    "Origin_Country" text,
    "SearchCode1" text,
    "SearchCode2" text,
    "Space" text,
    "Storage" text,
    "Processor" text,
    "Camera" text,
    "Screen" text,
    "OS" text,
    "Battery" text,
    "Warranty" text,
    "Color" text,
    "Category" text,
    "Model" text,
    "Guess_Price" text,
    "Arrange" bigint,
    "Added" text,
    "Offer_Start_Date" text,
    "Offer_End_Date" text,
    "English_Brief_Desc" text,
    "Arabic_Brief_Desc" text,
    "Show_Other_Store" text,
    "Calories" text,
    "Thickness" text,
    "Maximum_Sales_Qty" text,
    "Delete" text DEFAULT 0,
    "Cost_Price" text DEFAULT 0,
    "Faveorite" text DEFAULT 0,
    "Bonus" text DEFAULT 0
);


ALTER TABLE public.products OWNER TO demorabiherp_karim;

--
-- Name: products_consists; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_consists (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text,
    "Consist" text,
    "Price" text,
    "Total" text,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Consist_ID" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Exp_Date" text
);


ALTER TABLE public.products_consists OWNER TO demorabiherp_karim;

--
-- Name: products_consists_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_consists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_consists_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_consists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_consists_id_seq OWNED BY public.products_consists.id;


--
-- Name: products_executing_receivings; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_executing_receivings (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text NOT NULL,
    "P_En_Name" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Total" text NOT NULL,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "Unit" bigint,
    "Executing" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    type text,
    "Dep" text
);


ALTER TABLE public.products_executing_receivings OWNER TO demorabiherp_karim;

--
-- Name: products_executing_receivings_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_executing_receivings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_executing_receivings_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_executing_receivings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_executing_receivings_id_seq OWNED BY public.products_executing_receivings.id;


--
-- Name: products_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_id_seq OWNED BY public.products.id;


--
-- Name: products_manufacturing_orders; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_manufacturing_orders (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Store_Qty" text,
    "Required_Qty" text,
    "Qty" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "ManuOrder" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Precent" text
);


ALTER TABLE public.products_manufacturing_orders OWNER TO demorabiherp_karim;

--
-- Name: products_manufacturing_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_manufacturing_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_manufacturing_orders_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_manufacturing_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_manufacturing_orders_id_seq OWNED BY public.products_manufacturing_orders.id;


--
-- Name: products_manufacturing_requests; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_manufacturing_requests (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Request" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.products_manufacturing_requests OWNER TO demorabiherp_karim;

--
-- Name: products_manufacturing_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_manufacturing_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_manufacturing_requests_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_manufacturing_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_manufacturing_requests_id_seq OWNED BY public.products_manufacturing_requests.id;


--
-- Name: products_permission_to_exchange_goods; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_permission_to_exchange_goods (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text NOT NULL,
    "AvQty" text NOT NULL,
    "Qty" text NOT NULL,
    "Date" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "To_Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Exchange" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "CostPrice" text,
    "TDiscount" text,
    "Patch_Number" text,
    "Pro_Note" text,
    "SubVID" text,
    "Total_Wight" text,
    "UnitRate" text,
    weight text,
    "SalesProDesc" text,
    "TotCostNew" text,
    "SmallQty" text,
    "SmallCode" text,
    "Total_Net" text
);


ALTER TABLE public.products_permission_to_exchange_goods OWNER TO demorabiherp_karim;

--
-- Name: products_permission_to_exchange_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_permission_to_exchange_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_permission_to_exchange_goods_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_permission_to_exchange_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_permission_to_exchange_goods_id_seq OWNED BY public.products_permission_to_exchange_goods.id;


--
-- Name: products_permission_to_recived_goods; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_permission_to_recived_goods (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text NOT NULL,
    "AvQty" text NOT NULL,
    "Qty" text NOT NULL,
    "Date" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Recived" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "To_Store" bigint,
    "TDiscount" text,
    "SmallCode" text,
    "SmallQty" text,
    "Total_Net" text
);


ALTER TABLE public.products_permission_to_recived_goods OWNER TO demorabiherp_karim;

--
-- Name: products_permission_to_recived_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_permission_to_recived_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_permission_to_recived_goods_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_permission_to_recived_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_permission_to_recived_goods_id_seq OWNED BY public.products_permission_to_recived_goods.id;


--
-- Name: products_purchase_petrols; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_purchase_petrols (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Qty" text,
    "Price" text,
    "Total" text,
    "Store" bigint,
    "Product" bigint,
    "Unit" bigint,
    "Petrol" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "SmallCode" text,
    "SmallQty" text
);


ALTER TABLE public.products_purchase_petrols OWNER TO demorabiherp_karim;

--
-- Name: products_purchase_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_purchase_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_purchase_petrols_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_purchase_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_purchase_petrols_id_seq OWNED BY public.products_purchase_petrols.id;


--
-- Name: products_purchases; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_purchases (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Total_Tax" text,
    "Exp_Date" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Purchase" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Date" text,
    "Code" text,
    "Refernce_Number" text,
    "Safe" bigint,
    "Vendor" bigint,
    "Delegate" bigint,
    "Coin" bigint,
    "User" bigint,
    "Cost_Center" bigint,
    "Type" text,
    "Ship" bigint,
    "SmallQty" text,
    "SmallCode" text,
    "TDiscount" text,
    "Payment_Method" text,
    "TypeEn" text,
    "Total_Net" text,
    "ChassisNumber" text,
    "MotorNumber" text
);


ALTER TABLE public.products_purchases OWNER TO demorabiherp_karim;

--
-- Name: products_purchases_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_purchases_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_purchases_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_purchases_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_purchases_id_seq OWNED BY public.products_purchases.id;


--
-- Name: products_purchases_orders; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_purchases_orders (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "P_Order" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Tax" text,
    "Exp_Date" text,
    "Date" text,
    "Vendor" bigint,
    "TDiscount" text,
    "SmallCode" text,
    "SmallQty" text,
    "Code" text,
    "Refernce_Number" text,
    "Safe" text,
    "Delegate" text,
    "Coin" text,
    "User" text,
    "Cost_Center" text,
    "Type" text,
    "Ship" text,
    "Payment_Method" text,
    "Total_Net" text,
    "ChassisNumber" text,
    "MotorNumber" text
);


ALTER TABLE public.products_purchases_orders OWNER TO demorabiherp_karim;

--
-- Name: products_purchases_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_purchases_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_purchases_orders_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_purchases_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_purchases_orders_id_seq OWNED BY public.products_purchases_orders.id;


--
-- Name: products_qties; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_qties (
    id bigint NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text,
    "Price" text,
    "Pro_Stores" bigint,
    "Store" bigint,
    "Unit" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Low_Unit" bigint,
    "Original" text,
    "Patch_Number" text,
    "PP_Code" text,
    "PPP_Code" text,
    "PPPP_Code" text,
    "Exp_Date" text,
    "Price_Sale" text,
    "SearchCode1" text,
    "SearchCode2" text,
    "Group" text,
    "Brand" text,
    "Branch" text,
    "TotalCost" text,
    "Hold_Qty" text DEFAULT 0,
    "ChassisNumber" text,
    "MotorNumber" text
);


ALTER TABLE public.products_qties OWNER TO demorabiherp_karim;

--
-- Name: products_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_qties_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_qties_id_seq OWNED BY public.products_qties.id;


--
-- Name: products_quotes; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_quotes (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "S_Quote" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Tax" text,
    "Exp_Date" text,
    "Patch_Number" text,
    "TDiscount" text,
    "Total_Wight" text,
    "UnitRate" text,
    weight text,
    "SalesProDesc" text,
    "TotCostNew" text,
    "SmallQty" text,
    "SmallCode" text,
    "CostPrice" text,
    "Date" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    "Pro_Note" text,
    "SubVID" text,
    "Total_Net" text
);


ALTER TABLE public.products_quotes OWNER TO demorabiherp_karim;

--
-- Name: products_quotes_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_quotes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_quotes_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_quotes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_quotes_id_seq OWNED BY public.products_quotes.id;


--
-- Name: products_return_maintaince_bills; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_return_maintaince_bills (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text NOT NULL,
    "AvQty" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Return" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Recived_Qty" text,
    "Out" text,
    "Date" text,
    "User" bigint,
    "Eng" bigint,
    "Brand" bigint,
    "Group" bigint,
    "Branch" bigint,
    "Recipient" bigint
);


ALTER TABLE public.products_return_maintaince_bills OWNER TO demorabiherp_karim;

--
-- Name: products_return_maintaince_bills_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_return_maintaince_bills_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_return_maintaince_bills_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_return_maintaince_bills_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_return_maintaince_bills_id_seq OWNED BY public.products_return_maintaince_bills.id;


--
-- Name: products_secretariat_export_goods; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_secretariat_export_goods (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text,
    "Date" text,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Export" bigint,
    "Store" bigint NOT NULL,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Note" text,
    "RecivedQty" text,
    "Impotence" text,
    "Price" text,
    "Total" text
);


ALTER TABLE public.products_secretariat_export_goods OWNER TO demorabiherp_karim;

--
-- Name: products_secretariat_export_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_secretariat_export_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_secretariat_export_goods_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_secretariat_export_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_secretariat_export_goods_id_seq OWNED BY public.products_secretariat_export_goods.id;


--
-- Name: products_secretariat_import_goods; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_secretariat_import_goods (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text,
    "Date" text,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Import" bigint,
    "Unit" bigint,
    "Store" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.products_secretariat_import_goods OWNER TO demorabiherp_karim;

--
-- Name: products_secretariat_import_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_secretariat_import_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_secretariat_import_goods_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_secretariat_import_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_secretariat_import_goods_id_seq OWNED BY public.products_secretariat_import_goods.id;


--
-- Name: products_shortcomings; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_shortcomings (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Av_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Shortmings" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Tax" text,
    "Exp_Date" text,
    "TDiscount" text,
    "Original_Qty" text,
    "SmallCode" text,
    "SmallQty" text,
    "Date" text,
    "Code" text,
    "Refernce_Number" text,
    "Safe" text,
    "Vendor" text,
    "Delegate" text,
    "Coin" text,
    "User" text,
    "Cost_Center" text,
    "Type" text,
    "Ship" text,
    "Payment_Method" text,
    "Total_Net" text
);


ALTER TABLE public.products_shortcomings OWNER TO demorabiherp_karim;

--
-- Name: products_shortcomings_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_shortcomings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_shortcomings_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_shortcomings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_shortcomings_id_seq OWNED BY public.products_shortcomings.id;


--
-- Name: products_start_periods; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_start_periods (
    id bigint NOT NULL,
    "P_Code" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Total" text NOT NULL,
    "Old_Qty" text NOT NULL,
    "Exp_Date" text,
    "SP_ID" bigint,
    "Unit" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Date" text,
    "User" bigint,
    "Store" bigint,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Patch_Number" text,
    "SmallQty" text,
    "SmallCode" text
);


ALTER TABLE public.products_start_periods OWNER TO demorabiherp_karim;

--
-- Name: products_start_periods_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_start_periods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_start_periods_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_start_periods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_start_periods_id_seq OWNED BY public.products_start_periods.id;


--
-- Name: products_stores; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_stores (
    id bigint NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "V_Name" text,
    "VV_Name" text,
    "Exp_Date" text,
    "Product" bigint,
    "Store" bigint,
    "V1" bigint,
    "V2" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.products_stores OWNER TO demorabiherp_karim;

--
-- Name: products_stores_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_stores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_stores_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_stores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_stores_id_seq OWNED BY public.products_stores.id;


--
-- Name: products_stores_transfers; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_stores_transfers (
    id bigint NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "P_Code" text,
    "Price" text,
    "Av_Qty" text,
    "Trans_Qty" text,
    "Total" text,
    "ST_ID" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "To_Store" text,
    "OldPrice" text,
    "SmallTrans_Qty" text,
    "SmallCode" text,
    "Original_Trans_Qty" text,
    "CostPrice" text,
    "Exp_Date" text
);


ALTER TABLE public.products_stores_transfers OWNER TO demorabiherp_karim;

--
-- Name: products_stores_transfers_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_stores_transfers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_stores_transfers_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_stores_transfers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_stores_transfers_id_seq OWNED BY public.products_stores_transfers.id;


--
-- Name: products_viras; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.products_viras (
    id bigint NOT NULL,
    "Cost" text,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.products_viras OWNER TO demorabiherp_karim;

--
-- Name: products_viras_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.products_viras_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_viras_id_seq OWNER TO demorabiherp_karim;

--
-- Name: products_viras_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.products_viras_id_seq OWNED BY public.products_viras.id;


--
-- Name: profit_sales_product_column_sechdulrs; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.profit_sales_product_column_sechdulrs (
    id bigint NOT NULL,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Qty" text,
    "Price" text,
    "Cost" text,
    "Profit" text,
    "Store" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.profit_sales_product_column_sechdulrs OWNER TO demorabiherp_karim;

--
-- Name: profit_sales_product_column_sechdulrs_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.profit_sales_product_column_sechdulrs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.profit_sales_product_column_sechdulrs_id_seq OWNER TO demorabiherp_karim;

--
-- Name: profit_sales_product_column_sechdulrs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.profit_sales_product_column_sechdulrs_id_seq OWNED BY public.profit_sales_product_column_sechdulrs.id;


--
-- Name: profit_sales_product_columns; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.profit_sales_product_columns (
    id bigint NOT NULL,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Qty" text,
    "Price" text,
    "Cost" text,
    "Profit" text,
    "Store" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.profit_sales_product_columns OWNER TO demorabiherp_karim;

--
-- Name: profit_sales_product_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.profit_sales_product_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.profit_sales_product_columns_id_seq OWNER TO demorabiherp_karim;

--
-- Name: profit_sales_product_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.profit_sales_product_columns_id_seq OWNED BY public.profit_sales_product_columns.id;


--
-- Name: project_statuses; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.project_statuses (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.project_statuses OWNER TO demorabiherp_karim;

--
-- Name: project_statuses_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.project_statuses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.project_statuses_id_seq OWNER TO demorabiherp_karim;

--
-- Name: project_statuses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.project_statuses_id_seq OWNED BY public.project_statuses.id;


--
-- Name: project_teams; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.project_teams (
    id bigint NOT NULL,
    "Member" bigint,
    "Project" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.project_teams OWNER TO demorabiherp_karim;

--
-- Name: project_teams_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.project_teams_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.project_teams_id_seq OWNER TO demorabiherp_karim;

--
-- Name: project_teams_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.project_teams_id_seq OWNED BY public.project_teams.id;


--
-- Name: projects; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.projects (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Start_Date" text NOT NULL,
    "End_Date" text NOT NULL,
    "Duration" text NOT NULL,
    "Value" text NOT NULL,
    "File" text,
    "Client" bigint NOT NULL,
    "Manager" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text DEFAULT 0,
    "NameEn" text
);


ALTER TABLE public.projects OWNER TO demorabiherp_karim;

--
-- Name: projects_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.projects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.projects_id_seq OWNER TO demorabiherp_karim;

--
-- Name: projects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.projects_id_seq OWNED BY public.projects.id;


--
-- Name: purch_bills_columns; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.purch_bills_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Vendor" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Total_BF_Tax" text,
    "Tax" text,
    "Total" text,
    "Group" text,
    "Brand" text,
    "Exp_Date" text,
    "Product_Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Rate" text,
    "Name_Width" text
);


ALTER TABLE public.purch_bills_columns OWNER TO demorabiherp_karim;

--
-- Name: purch_bills_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.purch_bills_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purch_bills_columns_id_seq OWNER TO demorabiherp_karim;

--
-- Name: purch_bills_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.purch_bills_columns_id_seq OWNED BY public.purch_bills_columns.id;


--
-- Name: purch_bills_columns_sechdules; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.purch_bills_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Vendor" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Total_BF_Tax" text,
    "Tax" text,
    "Total" text,
    "Group" text,
    "Brand" text,
    "Exp_Date" text,
    "Product_Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Rate" text,
    "Name_Width" text
);


ALTER TABLE public.purch_bills_columns_sechdules OWNER TO demorabiherp_karim;

--
-- Name: purch_bills_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.purch_bills_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purch_bills_columns_sechdules_id_seq OWNER TO demorabiherp_karim;

--
-- Name: purch_bills_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.purch_bills_columns_sechdules_id_seq OWNED BY public.purch_bills_columns_sechdules.id;


--
-- Name: purch_bills_filter_twos; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.purch_bills_filter_twos (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Payment_Method" text,
    "Status" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Safe" text,
    "Vendor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Ship" text,
    "Later_Due" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Type" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.purch_bills_filter_twos OWNER TO demorabiherp_karim;

--
-- Name: purch_bills_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.purch_bills_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purch_bills_filter_twos_id_seq OWNER TO demorabiherp_karim;

--
-- Name: purch_bills_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.purch_bills_filter_twos_id_seq OWNED BY public.purch_bills_filter_twos.id;


--
-- Name: purch_bills_filters; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.purch_bills_filters (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Payment_Method" text,
    "Status" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Safe" text,
    "Vendor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Ship" text,
    "Later_Due" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Type" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.purch_bills_filters OWNER TO demorabiherp_karim;

--
-- Name: purch_bills_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.purch_bills_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purch_bills_filters_id_seq OWNER TO demorabiherp_karim;

--
-- Name: purch_bills_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.purch_bills_filters_id_seq OWNED BY public.purch_bills_filters.id;


--
-- Name: purchase_petrols; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.purchase_petrols (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Later_Due" text,
    "Vendor_Bill_Date" text,
    "Refernce_Number" text,
    "Draw" text,
    "Payment_Method" text,
    "Note" text,
    "File" text,
    "Car_Number" text,
    "Delivery_Method" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Pay" text,
    "Full" text,
    "Vendor" bigint,
    "Coin" bigint,
    "Safe" bigint,
    "CompanyCar" bigint,
    "Store" bigint,
    "Recipient" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Number" text
);


ALTER TABLE public.purchase_petrols OWNER TO demorabiherp_karim;

--
-- Name: purchase_petrols_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.purchase_petrols_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchase_petrols_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: purchase_petrols_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.purchase_petrols_arr_seq OWNED BY public.purchase_petrols.arr;


--
-- Name: purchase_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.purchase_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchase_petrols_id_seq OWNER TO demorabiherp_karim;

--
-- Name: purchase_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.purchase_petrols_id_seq OWNED BY public.purchase_petrols.id;


--
-- Name: purchases; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.purchases (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Payment_Method" text NOT NULL,
    "Status" text NOT NULL,
    "Vendor_Bill_Date" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "P_Order_Num" text,
    "Safe" bigint NOT NULL,
    "Vendor" bigint NOT NULL,
    "Delegate" bigint,
    "Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Ship" bigint,
    "Check_Type" bigint,
    "Check_Number" text,
    "Due_Date" text,
    "ShipStatus" text DEFAULT 0,
    "Later_Due" text,
    "Sent" text,
    "TaxBill" text DEFAULT 0,
    "TaxCode" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "File" text,
    "Current_Credit" text,
    "Residual" text,
    "Total_Net" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text,
    "DiscountBill" text DEFAULT 0
);


ALTER TABLE public.purchases OWNER TO demorabiherp_karim;

--
-- Name: purchases_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.purchases_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchases_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: purchases_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.purchases_arr_seq OWNED BY public.purchases.arr;


--
-- Name: purchases_default_data; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.purchases_default_data (
    id bigint NOT NULL,
    "Payment_Method" text,
    "Status" text,
    "V_and_C" text,
    "Safe" bigint,
    "Vendor" bigint,
    "Delegate" bigint,
    "Store" bigint,
    "Coin" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Brand" text,
    "Group" text,
    "English_Name" text,
    "Expire" text,
    "Empp" text,
    "Quality_Qty" text,
    "Discount" text,
    "Hide_Product" text,
    "Hide_Edit_Delete" text,
    "Duplicate_Items" text
);


ALTER TABLE public.purchases_default_data OWNER TO demorabiherp_karim;

--
-- Name: purchases_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.purchases_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchases_default_data_id_seq OWNER TO demorabiherp_karim;

--
-- Name: purchases_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.purchases_default_data_id_seq OWNED BY public.purchases_default_data.id;


--
-- Name: purchases_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.purchases_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchases_id_seq OWNER TO demorabiherp_karim;

--
-- Name: purchases_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.purchases_id_seq OWNED BY public.purchases.id;


--
-- Name: purchases_orders; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.purchases_orders (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Payment_Method" text,
    "Status" text,
    "Vendor_Bill_Date" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "P_Order_Num" text,
    "Safe" bigint,
    "Vendor" bigint,
    "Delegate" bigint,
    "Store" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ToPurch" text DEFAULT 0,
    "Quality" text DEFAULT 0,
    "Quality_Note" text,
    "Quantity" text DEFAULT 0,
    "Quantity_Note" text,
    "Purchases_Date" text,
    "ShipStatus" text,
    "Ship" text,
    "Check_Type" text,
    "Due_Date" text,
    "Check_Number" text,
    "Later_Due" text,
    "Sent" text,
    "TaxBill" text,
    "TaxCode" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "File" text,
    "Current_Credit" text,
    "Residual" text,
    "Total_Net" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text,
    "DiscountBill" text DEFAULT 0
);


ALTER TABLE public.purchases_orders OWNER TO demorabiherp_karim;

--
-- Name: purchases_orders_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.purchases_orders_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchases_orders_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: purchases_orders_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.purchases_orders_arr_seq OWNED BY public.purchases_orders.arr;


--
-- Name: purchases_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.purchases_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchases_orders_id_seq OWNER TO demorabiherp_karim;

--
-- Name: purchases_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.purchases_orders_id_seq OWNED BY public.purchases_orders.id;


--
-- Name: purpose_travel; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.purpose_travel (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.purpose_travel OWNER TO demorabiherp_karim;

--
-- Name: purpose_travel_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.purpose_travel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purpose_travel_id_seq OWNER TO demorabiherp_karim;

--
-- Name: purpose_travel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.purpose_travel_id_seq OWNED BY public.purpose_travel.id;


--
-- Name: q_r_s; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.q_r_s (
    id bigint NOT NULL,
    "QR" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.q_r_s OWNER TO demorabiherp_karim;

--
-- Name: q_r_s_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.q_r_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.q_r_s_id_seq OWNER TO demorabiherp_karim;

--
-- Name: q_r_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.q_r_s_id_seq OWNED BY public.q_r_s.id;


--
-- Name: qualities; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.qualities (
    id bigint NOT NULL,
    "Code" text,
    "Execution_Code" text,
    "Date" text,
    "Outcome_Name" text,
    "Outcome_Code" text,
    "Outcome_Qty" text,
    "Except_Qty" text,
    "Outcome_Unit" text,
    "Outcome_Store" text,
    "Production_Manager" bigint,
    "Quality_Manager" bigint,
    "ManuExecution" bigint NOT NULL,
    "Note" text,
    "Status" text,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.qualities OWNER TO demorabiherp_karim;

--
-- Name: qualities_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.qualities_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.qualities_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: qualities_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.qualities_arr_seq OWNED BY public.qualities.arr;


--
-- Name: qualities_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.qualities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.qualities_id_seq OWNER TO demorabiherp_karim;

--
-- Name: qualities_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.qualities_id_seq OWNED BY public.qualities.id;


--
-- Name: quality_details; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.quality_details (
    id bigint NOT NULL,
    "Exmine_Type" text,
    "Exmine_Unit" text,
    "Exmine_Allow_From" text,
    "Exmine_Allow_To" text,
    "Result" text,
    "Accept" text,
    "Exmine" bigint,
    "Quality" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.quality_details OWNER TO demorabiherp_karim;

--
-- Name: quality_details_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.quality_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quality_details_id_seq OWNER TO demorabiherp_karim;

--
-- Name: quality_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.quality_details_id_seq OWNED BY public.quality_details.id;


--
-- Name: quote_images; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.quote_images (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Payment_Method" text NOT NULL,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Total_Discount" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Client" text NOT NULL,
    "User" text NOT NULL,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Pay" text,
    "Safe" text,
    "Executor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    presenter text,
    annual_interest text,
    monthly_installment text,
    "Years_Number" text,
    total text,
    "installment_Num" text,
    "Date_First_installment" text,
    "Later_Due" text,
    "Sale_Date" text,
    "Total_Wight_Bill" text,
    "ToSales" text,
    "Shipping" text,
    "Delivery_Status" text,
    "Order_Type" text,
    "ProfitPrecent" text,
    "InstallCompany" text,
    "ContractNumber" text,
    "PayFees" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Time" text,
    "TaxBill" text,
    "TaxCode" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "Check_Type" text,
    "Due_Date" text,
    "Check_Number" text,
    "Shift_Code" text,
    "Client_Address" text,
    "Delivery" text,
    "ProfitTax" text,
    "Branch" text,
    "CustomerGroup" text,
    "Total_Cost" text,
    "File" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text,
    "Total_Net" text,
    "Residual" text,
    "Current_Credit" text,
    "DiscountTax" text,
    "Draw" text,
    "Status" text,
    "Refernce_Number" text,
    "Ship" text,
    "DiscountBill" text DEFAULT 0,
    "Client_Accept" text DEFAULT 0,
    "Done" text DEFAULT 0,
    "EMP_Quote" text
);


ALTER TABLE public.quote_images OWNER TO demorabiherp_karim;

--
-- Name: quote_images_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.quote_images_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quote_images_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: quote_images_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.quote_images_arr_seq OWNED BY public.quote_images.arr;


--
-- Name: quote_images_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.quote_images_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quote_images_id_seq OWNER TO demorabiherp_karim;

--
-- Name: quote_images_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.quote_images_id_seq OWNED BY public.quote_images.id;


--
-- Name: quotes; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.quotes (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Payment_Method" text NOT NULL,
    "Status" text NOT NULL,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Safe" bigint NOT NULL,
    "Client" bigint NOT NULL,
    "Delegate" bigint,
    "Executor" bigint,
    "Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    presenter text,
    annual_interest text,
    monthly_installment text,
    "Years_Number" text,
    total text,
    "installment_Num" text,
    "Date_First_installment" text,
    "Later_Due" text,
    "Sale_Date" text,
    "Total_Wight_Bill" text,
    "ToSales" text,
    "Shipping" text,
    "Delivery_Status" text,
    "Order_Type" text,
    "ProfitPrecent" text,
    "InstallCompany" text,
    "ContractNumber" text,
    "PayFees" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Time" text,
    "TaxBill" text,
    "TaxCode" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "Check_Type" text,
    "Due_Date" text,
    "Check_Number" text,
    "Shift_Code" text,
    "Client_Address" text,
    "Delivery" text,
    "ProfitTax" text,
    "Branch" text,
    "CustomerGroup" text,
    "Total_Cost" text,
    "File" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text,
    "Total_Net" text,
    "Residual" text,
    "Current_Credit" text,
    "DiscountTax" text,
    "Ship" text,
    "DiscountBill" text DEFAULT 0,
    "Shipping_Price" text
);


ALTER TABLE public.quotes OWNER TO demorabiherp_karim;

--
-- Name: quotes_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.quotes_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quotes_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: quotes_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.quotes_arr_seq OWNED BY public.quotes.arr;


--
-- Name: quotes_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.quotes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quotes_id_seq OWNER TO demorabiherp_karim;

--
-- Name: quotes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.quotes_id_seq OWNED BY public.quotes.id;


--
-- Name: rabih_education; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.rabih_education (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Video" text,
    "Package" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.rabih_education OWNER TO demorabiherp_karim;

--
-- Name: rabih_education_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.rabih_education_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rabih_education_id_seq OWNER TO demorabiherp_karim;

--
-- Name: rabih_education_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.rabih_education_id_seq OWNED BY public.rabih_education.id;


--
-- Name: rates; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.rates (
    id bigint NOT NULL,
    "Rate" text NOT NULL,
    "Product" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.rates OWNER TO demorabiherp_karim;

--
-- Name: rates_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.rates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rates_id_seq OWNER TO demorabiherp_karim;

--
-- Name: rates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.rates_id_seq OWNED BY public.rates.id;


--
-- Name: real_sate_projects; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.real_sate_projects (
    id bigint NOT NULL,
    "Code" text,
    "Name" text,
    "Start_Date" text,
    "End_Date" text,
    "Period" text,
    "Value" text,
    "Expect_Cost" text,
    "Expect_Profit" text,
    "Project_File" text,
    "Contract_File" text,
    "Contract_Type" text,
    "Completed" text,
    "Account" text,
    "Goods_Account" text,
    "Client" text,
    "Client_Account" text,
    "Manager" text,
    "Reponsible" text,
    "Store" text,
    "Contract_Status" text,
    "Project_Status" text,
    "Cost_Center" text,
    "Governrate" text,
    "City" text,
    "Place" text,
    "Location" text,
    "Address_Details" text,
    "Coin" text,
    "Draw" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Contractor_Account" text
);


ALTER TABLE public.real_sate_projects OWNER TO demorabiherp_karim;

--
-- Name: real_sate_projects_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.real_sate_projects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.real_sate_projects_id_seq OWNER TO demorabiherp_karim;

--
-- Name: real_sate_projects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.real_sate_projects_id_seq OWNED BY public.real_sate_projects.id;


--
-- Name: real_sate_projects_payments; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.real_sate_projects_payments (
    id bigint NOT NULL,
    "Date" text,
    "Value" text,
    "Status" text,
    "Project" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.real_sate_projects_payments OWNER TO demorabiherp_karim;

--
-- Name: real_sate_projects_payments_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.real_sate_projects_payments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.real_sate_projects_payments_id_seq OWNER TO demorabiherp_karim;

--
-- Name: real_sate_projects_payments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.real_sate_projects_payments_id_seq OWNED BY public.real_sate_projects_payments.id;


--
-- Name: real_state_default_data; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.real_state_default_data (
    id bigint NOT NULL,
    "Draw" text,
    "Coin" text,
    "Safe" text,
    "Contract_Type" text,
    "Manager" text,
    "Reponsible" text,
    "Store" text,
    "Contract_Status" text,
    "Project_Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.real_state_default_data OWNER TO demorabiherp_karim;

--
-- Name: real_state_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.real_state_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.real_state_default_data_id_seq OWNER TO demorabiherp_karim;

--
-- Name: real_state_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.real_state_default_data_id_seq OWNED BY public.real_state_default_data.id;


--
-- Name: reasons; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.reasons (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.reasons OWNER TO demorabiherp_karim;

--
-- Name: reasons_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.reasons_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reasons_id_seq OWNER TO demorabiherp_karim;

--
-- Name: reasons_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.reasons_id_seq OWNED BY public.reasons.id;


--
-- Name: recipt_maintaince_errors; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.recipt_maintaince_errors (
    id bigint NOT NULL,
    "Recipt" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Error" bigint NOT NULL,
    "Recived" text DEFAULT 0,
    "Eng" text DEFAULT 0
);


ALTER TABLE public.recipt_maintaince_errors OWNER TO demorabiherp_karim;

--
-- Name: recipt_maintaince_errors_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.recipt_maintaince_errors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipt_maintaince_errors_id_seq OWNER TO demorabiherp_karim;

--
-- Name: recipt_maintaince_errors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.recipt_maintaince_errors_id_seq OWNED BY public.recipt_maintaince_errors.id;


--
-- Name: recipt_maintainces; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.recipt_maintainces (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Note" text,
    "Serial_Num" text,
    "Total" text NOT NULL,
    "Draw" text NOT NULL,
    "Company" bigint,
    "Device_Type" bigint,
    "Device_Case" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "Account" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text DEFAULT 0,
    "Pattern_Image" text,
    "Time" text,
    "Password" text,
    "Pay" text,
    "Eng_Note" text,
    "Reason" text,
    "Report_Client" text,
    "Work" text,
    "Store" bigint,
    "Eng" bigint,
    "Recipient" bigint,
    "Branch" bigint,
    "Payment_Method" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_Bf_Taxes" text,
    "Total_Taxes" text,
    "RefuseReason" text,
    "NoteRecived" text,
    "Returned" text DEFAULT 0,
    "CustomerGroup" text,
    "Total_Cost" text
);


ALTER TABLE public.recipt_maintainces OWNER TO demorabiherp_karim;

--
-- Name: recipt_maintainces_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.recipt_maintainces_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipt_maintainces_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: recipt_maintainces_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.recipt_maintainces_arr_seq OWNED BY public.recipt_maintainces.arr;


--
-- Name: recipt_maintainces_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.recipt_maintainces_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipt_maintainces_id_seq OWNER TO demorabiherp_karim;

--
-- Name: recipt_maintainces_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.recipt_maintainces_id_seq OWNED BY public.recipt_maintainces.id;


--
-- Name: recipt_voucher_details; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.recipt_voucher_details (
    id bigint NOT NULL,
    "Creditor" text NOT NULL,
    "Statement" text,
    "Account" bigint NOT NULL,
    "RV_ID" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Bill_Num" text
);


ALTER TABLE public.recipt_voucher_details OWNER TO demorabiherp_karim;

--
-- Name: recipt_voucher_details_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.recipt_voucher_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipt_voucher_details_id_seq OWNER TO demorabiherp_karim;

--
-- Name: recipt_voucher_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.recipt_voucher_details_id_seq OWNED BY public.recipt_voucher_details.id;


--
-- Name: recipt_vouchers; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.recipt_vouchers (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Total_Creditor" text NOT NULL,
    "Note" text,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Safe" bigint NOT NULL,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Store" text,
    "Shift" text,
    "User" text,
    "Status" text,
    "File" text,
    "Collector" text,
    "Edit" text,
    "Delete" text,
    "Edit_New_Code" text,
    "Sales_Bill" text
);


ALTER TABLE public.recipt_vouchers OWNER TO demorabiherp_karim;

--
-- Name: recipt_vouchers_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.recipt_vouchers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipt_vouchers_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: recipt_vouchers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.recipt_vouchers_arr_seq OWNED BY public.recipt_vouchers."Code";


--
-- Name: recipt_vouchers_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.recipt_vouchers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipt_vouchers_id_seq OWNER TO demorabiherp_karim;

--
-- Name: recipt_vouchers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.recipt_vouchers_id_seq OWNED BY public.recipt_vouchers.id;


--
-- Name: recipts_sales_petrols; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.recipts_sales_petrols (
    id bigint NOT NULL,
    "Recipt_Amount" text NOT NULL,
    "Recipt" bigint,
    "SalesPetrol" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.recipts_sales_petrols OWNER TO demorabiherp_karim;

--
-- Name: recipts_sales_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.recipts_sales_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipts_sales_petrols_id_seq OWNER TO demorabiherp_karim;

--
-- Name: recipts_sales_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.recipts_sales_petrols_id_seq OWNED BY public.recipts_sales_petrols.id;


--
-- Name: recipts_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.recipts_types (
    id bigint NOT NULL,
    "Name" text,
    "Account" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.recipts_types OWNER TO demorabiherp_karim;

--
-- Name: recipts_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.recipts_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipts_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: recipts_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.recipts_types_id_seq OWNED BY public.recipts_types.id;


--
-- Name: recived_purch_products; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.recived_purch_products (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "Recived_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Total_Tax" text,
    "Exp_Date" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Recived" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.recived_purch_products OWNER TO demorabiherp_karim;

--
-- Name: recived_purch_products_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.recived_purch_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_purch_products_id_seq OWNER TO demorabiherp_karim;

--
-- Name: recived_purch_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.recived_purch_products_id_seq OWNED BY public.recived_purch_products.id;


--
-- Name: recived_purchts; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.recived_purchts (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Total_Trans_Qty" text NOT NULL,
    "Total_Trans_Value" text NOT NULL,
    "Purchase" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "User" bigint,
    arr bigint
);


ALTER TABLE public.recived_purchts OWNER TO demorabiherp_karim;

--
-- Name: recived_purchts_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.recived_purchts_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_purchts_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: recived_purchts_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.recived_purchts_arr_seq OWNED BY public.recived_purchts.arr;


--
-- Name: recived_purchts_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.recived_purchts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_purchts_id_seq OWNER TO demorabiherp_karim;

--
-- Name: recived_purchts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.recived_purchts_id_seq OWNED BY public.recived_purchts.id;


--
-- Name: recived_sales; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.recived_sales (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Total_Trans_Qty" text NOT NULL,
    "Total_Trans_Value" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Sales" bigint NOT NULL,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "User" bigint
);


ALTER TABLE public.recived_sales OWNER TO demorabiherp_karim;

--
-- Name: recived_sales_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.recived_sales_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_sales_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: recived_sales_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.recived_sales_arr_seq OWNED BY public.recived_sales.arr;


--
-- Name: recived_sales_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.recived_sales_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_sales_id_seq OWNER TO demorabiherp_karim;

--
-- Name: recived_sales_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.recived_sales_id_seq OWNED BY public.recived_sales.id;


--
-- Name: recived_sales_products; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.recived_sales_products (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "Recived_Qty" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Total_Tax" text,
    "Exp_Date" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Recived" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.recived_sales_products OWNER TO demorabiherp_karim;

--
-- Name: recived_sales_products_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.recived_sales_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_sales_products_id_seq OWNER TO demorabiherp_karim;

--
-- Name: recived_sales_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.recived_sales_products_id_seq OWNED BY public.recived_sales_products.id;


--
-- Name: recived_shipment_goods; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.recived_shipment_goods (
    id bigint NOT NULL,
    "Shipment_ID" text,
    "Code" text,
    "Barcode" text,
    "Total_Weight" text,
    "Total_Pieces" text,
    "Total_Cost" text,
    "Client" text,
    "RecivedShipment" text,
    "Status" text,
    "Unloading_Goods_ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "PayShip" text
);


ALTER TABLE public.recived_shipment_goods OWNER TO demorabiherp_karim;

--
-- Name: recived_shipment_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.recived_shipment_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_shipment_goods_id_seq OWNER TO demorabiherp_karim;

--
-- Name: recived_shipment_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.recived_shipment_goods_id_seq OWNED BY public.recived_shipment_goods.id;


--
-- Name: recived_shipments; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.recived_shipments (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Time" text,
    "Safe" text,
    "Coin" text,
    "Draw" text,
    "Store" text,
    "Delegate" text,
    "Driver" text,
    "Total_Pieces" text,
    "Total_Weight" text,
    "Total_Cost" text,
    "Count_Shipmets" text,
    "Status" text,
    "User" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text,
    "Residual" text
);


ALTER TABLE public.recived_shipments OWNER TO demorabiherp_karim;

--
-- Name: recived_shipments_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.recived_shipments_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_shipments_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: recived_shipments_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.recived_shipments_arr_seq OWNED BY public.recived_shipments."Code";


--
-- Name: recived_shipments_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.recived_shipments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_shipments_id_seq OWNER TO demorabiherp_karim;

--
-- Name: recived_shipments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.recived_shipments_id_seq OWNED BY public.recived_shipments.id;


--
-- Name: reg_courses; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.reg_courses (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Hall" text,
    "Reserve_Course" text,
    "Teacher" text,
    "Teacher_Attend" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Teacher_Attend_From" text,
    "Teacher_Attend_To" text,
    "Teacher_Time" text
);


ALTER TABLE public.reg_courses OWNER TO demorabiherp_karim;

--
-- Name: reg_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.reg_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reg_courses_id_seq OWNER TO demorabiherp_karim;

--
-- Name: reg_courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.reg_courses_id_seq OWNED BY public.reg_courses.id;


--
-- Name: reg_courses_students; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.reg_courses_students (
    id bigint NOT NULL,
    "Student" text,
    "Attend" text,
    "Date" text,
    "Reg" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.reg_courses_students OWNER TO demorabiherp_karim;

--
-- Name: reg_courses_students_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.reg_courses_students_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reg_courses_students_id_seq OWNER TO demorabiherp_karim;

--
-- Name: reg_courses_students_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.reg_courses_students_id_seq OWNED BY public.reg_courses_students.id;


--
-- Name: reg_over_times; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.reg_over_times (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Amount" text NOT NULL,
    "Hours_Number" text NOT NULL,
    "Hour_Rate" text NOT NULL,
    "Total_Hours" text NOT NULL,
    "Hour_Cost" text NOT NULL,
    "Note" text,
    "Emp" bigint,
    "Type" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.reg_over_times OWNER TO demorabiherp_karim;

--
-- Name: reg_over_times_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.reg_over_times_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reg_over_times_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: reg_over_times_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.reg_over_times_arr_seq OWNED BY public.reg_over_times.arr;


--
-- Name: reg_over_times_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.reg_over_times_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reg_over_times_id_seq OWNER TO demorabiherp_karim;

--
-- Name: reg_over_times_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.reg_over_times_id_seq OWNED BY public.reg_over_times.id;


--
-- Name: remove_products_halls; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.remove_products_halls (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "CostPrice" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "Store" text,
    "Product" text,
    "Exp_Date" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "SalesOrder" text,
    "Pro_Note" text,
    "KitchenEnd" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.remove_products_halls OWNER TO demorabiherp_karim;

--
-- Name: remove_products_halls_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.remove_products_halls_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.remove_products_halls_id_seq OWNER TO demorabiherp_karim;

--
-- Name: remove_products_halls_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.remove_products_halls_id_seq OWNED BY public.remove_products_halls.id;


--
-- Name: reports_settings; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.reports_settings (
    id bigint NOT NULL,
    "Product_Info" text,
    "Product_Order_Limit" text,
    "ReportStartPeriodProducts" text,
    "SettlementsReports" text,
    "StoresCost" text,
    "StoresInventory" text,
    "Collection_Delegates" text,
    "Sales_Delegates" text,
    "StagnantItems" text,
    "ItemsMoves" text,
    "StoresBalancesTwo" text,
    "NetPurchases" text,
    "NetSales" text,
    "ClientSales" text,
    "ExecutorSales" text,
    "InstallmentReport" text,
    "ExpiredProucts" text,
    "StoresSalesDetails" text,
    "TotalNetPurchases" text,
    "TotalNetSales" text,
    "Profits" text,
    "Shifts" text,
    "Shifts_Details" text,
    "DailyClosing" text,
    "Products" text,
    "DailyShifts" text,
    "ExpensesReport" text,
    "DailyProducts" text,
    "EmployeeCommissionDiscounts" text,
    "VendorPricesReport" text,
    "DailyMoves" text,
    "GroupsSales" text,
    "VendorPurchases" text,
    "ExceptProfits" text,
    "DelegateSalesDetails" text,
    "CreditStores" text,
    "ProductProfits" text,
    "ExceptProductProfits" text,
    "SalesBills" text,
    "PurchasesBills" text,
    "StoresMovesReport" text,
    "StoresTransferReport" text,
    "SafesTransferReport" text,
    "CompareSalesPrice" text,
    "ProductMoveDetails" text,
    "MostSalesProducts" text,
    "ProfitSalesProduct" text,
    "ClientAccountStatement" text,
    "ClientsStatement" text,
    "VendorAccountStatement" text,
    "VendorsStatement" text,
    "EmpGoals" text,
    "InventorySerial" text,
    "TotalExpensesSafes" text,
    "SubIncomList" text,
    "ExpensesList" text,
    "StoresBalances" text,
    "StoresBalancesCat" text,
    "ItemCost" text,
    "StoresInventoryy" text,
    "DelegateSalesDetailss" text,
    "ProfitDelegateSalesDetails" text,
    "InstallmentCompaniesSales" text,
    "StoresCosts" text,
    "DailyClosingDetails" text,
    "SalesProsMoreDetails" text,
    "StagnantItemss" text,
    "SalesCustomersGroups" text,
    "BrandsSales" text,
    "Customer_Debts" text,
    "Vendor_Debts" text,
    "MaintanceSalesReport" text,
    "Maintenance_Tune" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ProfitGroupsReport" text,
    "IncomListReport" text,
    "AssemblyProQties" text
);


ALTER TABLE public.reports_settings OWNER TO demorabiherp_karim;

--
-- Name: reports_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.reports_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reports_settings_id_seq OWNER TO demorabiherp_karim;

--
-- Name: reports_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.reports_settings_id_seq OWNED BY public.reports_settings.id;


--
-- Name: reservations; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.reservations (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "From" text,
    "To" text,
    "Amount" text,
    "Checkout" text,
    "Expire" text,
    "Draw" text,
    "Client" bigint,
    "Safe" bigint,
    "Coin" bigint,
    "Room" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "User" text,
    "Note" text
);


ALTER TABLE public.reservations OWNER TO demorabiherp_karim;

--
-- Name: reservations_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.reservations_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reservations_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: reservations_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.reservations_arr_seq OWNED BY public.reservations.arr;


--
-- Name: reservations_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.reservations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reservations_id_seq OWNER TO demorabiherp_karim;

--
-- Name: reservations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.reservations_id_seq OWNED BY public.reservations.id;


--
-- Name: reserve_course_days; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.reserve_course_days (
    id bigint NOT NULL,
    "Day" text,
    "Reserve" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "From_Time" text,
    "To_Time" text
);


ALTER TABLE public.reserve_course_days OWNER TO demorabiherp_karim;

--
-- Name: reserve_course_days_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.reserve_course_days_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reserve_course_days_id_seq OWNER TO demorabiherp_karim;

--
-- Name: reserve_course_days_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.reserve_course_days_id_seq OWNED BY public.reserve_course_days.id;


--
-- Name: reserve_course_students; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.reserve_course_students (
    id bigint NOT NULL,
    "Student" text,
    "Pay" text,
    "Cost" text,
    "Residual" text,
    "Constraint" text,
    "Reserve" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Dollar_Value" text
);


ALTER TABLE public.reserve_course_students OWNER TO demorabiherp_karim;

--
-- Name: reserve_course_students_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.reserve_course_students_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reserve_course_students_id_seq OWNER TO demorabiherp_karim;

--
-- Name: reserve_course_students_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.reserve_course_students_id_seq OWNED BY public.reserve_course_students.id;


--
-- Name: reserve_courses; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.reserve_courses (
    id bigint NOT NULL,
    "Code" text,
    "Course" text,
    "Start_Date" text,
    "End_Date" text,
    "Course_Type" text,
    "Teacher" text,
    "Required_Number" text,
    "Certificate" text,
    "Cost" text,
    "Total_Required" text,
    "Status" text,
    "Days" text,
    "Time" text,
    "Total_Paid" text,
    "Total_Num" text,
    "Total_Cost" text,
    "Safe" text,
    "Draw" text,
    "Coin" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Hall" text
);


ALTER TABLE public.reserve_courses OWNER TO demorabiherp_karim;

--
-- Name: reserve_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.reserve_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reserve_courses_id_seq OWNER TO demorabiherp_karim;

--
-- Name: reserve_courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.reserve_courses_id_seq OWNED BY public.reserve_courses.id;


--
-- Name: resignation_requests; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resignation_requests (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Resignation_Date" text,
    "File" text,
    "Emp" text,
    "Note" text,
    "Status" text,
    "Reason" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resignation_requests OWNER TO demorabiherp_karim;

--
-- Name: resignation_requests_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resignation_requests_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resignation_requests_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: resignation_requests_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resignation_requests_arr_seq OWNED BY public.resignation_requests."Code";


--
-- Name: resignation_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resignation_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resignation_requests_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resignation_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resignation_requests_id_seq OWNED BY public.resignation_requests.id;


--
-- Name: resturant_abouts; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_abouts (
    id bigint NOT NULL,
    "Image_1" text,
    "Image_2" text,
    "Title_Image" text,
    "Arabic_Title" text,
    "English_Title" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_abouts OWNER TO demorabiherp_karim;

--
-- Name: resturant_abouts_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_abouts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_abouts_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_abouts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_abouts_id_seq OWNED BY public.resturant_abouts.id;


--
-- Name: resturant_blogs; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_blogs (
    id bigint NOT NULL,
    "Image" text,
    "Sub_Image" text,
    "Date" text,
    "Arabic_Title" text,
    "English_Title" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_blogs OWNER TO demorabiherp_karim;

--
-- Name: resturant_blogs_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_blogs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_blogs_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_blogs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_blogs_id_seq OWNED BY public.resturant_blogs.id;


--
-- Name: resturant_cart_check_styles; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_cart_check_styles (
    id bigint NOT NULL,
    "Cart_BG_Type" text,
    "Cart_BG_Image" text,
    "Cart_BG_Color" text,
    "Cart_Title_Color" text,
    "Cart_Txt_Color" text,
    "Cart_Top_Image" text,
    "Cart_Box_BG" text,
    "Cart_Box_Border" text,
    "Cart_Table_Color" text,
    "Cart_Table_BG" text,
    "Cart_Btn_BG" text,
    "Cart_Btn_Color" text,
    "Checkout_Image" text,
    "Checkout_Title_Color" text,
    "Checkout_BG_Type" text,
    "Checkout_BG_Image" text,
    "Checkout_BG_Color" text,
    "Checkout_Box_BG" text,
    "Checkout_Box_Border" text,
    "Checkout_Input_BG" text,
    "Checkout_Input_Color" text,
    "Checkout_Btn_Color" text,
    "Checkout_Btn_BG" text,
    "Checkout_Txt_Color" text,
    "Checkout_Txt_Hover_Color" text,
    "Checkout_Price_Color" text,
    "MyAccount_BG_Type" text,
    "MyAccount_BG_Image" text,
    "MyAccount_BG_Color" text,
    "MyAccount_Box_BG" text,
    "MyAccount_Box_Border" text,
    "MyAccount_Table_BG" text,
    "MyAccount_Table_Color" text,
    "MyAccount_Table_Head_BG" text,
    "MyAccount_Table_Head_Color" text,
    "MyAccount_Txt_Color" text,
    "MyAccount_Btn_BG" text,
    "MyAccount_Btn_Color" text,
    "MyAccount_Input_BG" text,
    "MyAccount_Input_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Collapse_BG" text,
    "Collapse_Border" text,
    "Collapse_Color" text
);


ALTER TABLE public.resturant_cart_check_styles OWNER TO demorabiherp_karim;

--
-- Name: resturant_cart_check_styles_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_cart_check_styles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_cart_check_styles_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_cart_check_styles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_cart_check_styles_id_seq OWNED BY public.resturant_cart_check_styles.id;


--
-- Name: resturant_carts; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_carts (
    id bigint NOT NULL,
    "Product" text,
    "Name" text,
    "NameEn" text,
    "V_ID" text,
    "P_Code" text,
    "Qty" text,
    "Price" text,
    "Image" text,
    "Total" text,
    "User" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_carts OWNER TO demorabiherp_karim;

--
-- Name: resturant_carts_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_carts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_carts_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_carts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_carts_id_seq OWNED BY public.resturant_carts.id;


--
-- Name: resturant_cupon_codes; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_cupon_codes (
    id bigint NOT NULL,
    "Code" text,
    "Amount" text,
    "Status" text,
    "Num" text,
    "Used" text,
    "Expire" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_cupon_codes OWNER TO demorabiherp_karim;

--
-- Name: resturant_cupon_codes_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_cupon_codes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_cupon_codes_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_cupon_codes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_cupon_codes_id_seq OWNED BY public.resturant_cupon_codes.id;


--
-- Name: resturant_galleries; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_galleries (
    id bigint NOT NULL,
    "Image" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_galleries OWNER TO demorabiherp_karim;

--
-- Name: resturant_galleries_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_galleries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_galleries_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_galleries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_galleries_id_seq OWNED BY public.resturant_galleries.id;


--
-- Name: resturant_homes; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_homes (
    id bigint NOT NULL,
    "Image_1" text,
    "Image_2" text,
    "Image_3" text,
    "Image_4" text,
    "Title_Image" text,
    "Arabic_Title" text,
    "English_Title" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "English_Sub_Title" text,
    "Arabic_Sub_Title" text,
    "Year" text
);


ALTER TABLE public.resturant_homes OWNER TO demorabiherp_karim;

--
-- Name: resturant_homes_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_homes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_homes_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_homes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_homes_id_seq OWNED BY public.resturant_homes.id;


--
-- Name: resturant_index_style_i_i_s; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_index_style_i_i_s (
    id bigint NOT NULL,
    "About_Body_BG_Type" text,
    "About_Body_BG_Image" text,
    "About_Body_BG_Color" text,
    "About_Txt_Color" text,
    "Gallery_Border_Color" text,
    "Reviews_Image_1" text,
    "Reviews_Image_2" text,
    "Reviews_Nxt_Prev_Color" text,
    "Reviews_Nxt_Prev_BG" text,
    "Reviews_Nxt_Prev_Border" text,
    "Reviews_Txt_Color" text,
    "Reviews_Body_BG_Type" text,
    "Reviews_Body_BG_Image" text,
    "Reviews_Body_BG_Color" text,
    "Reservations_Body_BG_Type" text,
    "Reservations_Body_BG_Image" text,
    "Reservations_Body_BG_Color" text,
    "Reservations_Box_BG" text,
    "Reservations_Input_BG" text,
    "Reservations_Input_Color" text,
    "Reservations_Btn_Color" text,
    "Reservations_Btn_BG" text,
    "Blogs_Home_Body_BG_Type" text,
    "Blogs_Home_Body_BG_Image" text,
    "Blogs_Home_Body_BG_Color" text,
    "Blogs_Home_Box_BG_Color" text,
    "Blogs_Home_Box_Border_Color" text,
    "Blogs_Home_Txt_Color" text,
    "Blogs_Home_Txt_Hover_Color" text,
    "Blogs_Home_Btn_BG" text,
    "Blogs_Home_Btn_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_index_style_i_i_s OWNER TO demorabiherp_karim;

--
-- Name: resturant_index_style_i_i_s_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_index_style_i_i_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_index_style_i_i_s_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_index_style_i_i_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_index_style_i_i_s_id_seq OWNED BY public.resturant_index_style_i_i_s.id;


--
-- Name: resturant_index_style_i_s; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_index_style_i_s (
    id bigint NOT NULL,
    "Home_1_Nxt_Prev_Color" text,
    "Home_1_Nxt_Prev_BG" text,
    "Home_1_Nxt_Prev_Border" text,
    "Home_2_Image_1" text,
    "Home_2_Image_2" text,
    "Home_2_Image_Arrow" text,
    "Home_2_Number_BG" text,
    "Home_2_Image_Border" text,
    "Home_2_Number_Color" text,
    "Category_Bar_BG" text,
    "Category_Bar_Color" text,
    "Video_Section_Body_BG_Type" text,
    "Video_Section_Body_BG_Image" text,
    "Video_Section_Body_BG_Color" text,
    "Video_Section_Image_1" text,
    "Video_Section_Image_2" text,
    "Menu_Index_Body_BG_Type" text,
    "Menu_Index_Body_BG_Image" text,
    "Menu_Index_Body_BG_Color" text,
    "Menu_Index_Txt_Color" text,
    "Menu_Index_Txt_Hover_Color" text,
    "Menu_Index_Btn_BG" text,
    "Menu_Index_Btn_Txt_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Icon_Image" text
);


ALTER TABLE public.resturant_index_style_i_s OWNER TO demorabiherp_karim;

--
-- Name: resturant_index_style_i_s_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_index_style_i_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_index_style_i_s_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_index_style_i_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_index_style_i_s_id_seq OWNED BY public.resturant_index_style_i_s.id;


--
-- Name: resturant_menu_styles; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_menu_styles (
    id bigint NOT NULL,
    "Menu_1_BG_Type" text,
    "Menu_1_BG_Image" text,
    "Menu_1_BG_Color" text,
    "Menu_1_Image" text,
    "Menu_1_Icon_Image" text,
    "Menu_1_Title" text,
    "Menu_1_Bar_BG" text,
    "Menu_1_Bar_Color" text,
    "Menu_1_Btn_BG" text,
    "Menu_1_Btn_Color" text,
    "Menu_1_Icon_Color" text,
    "Menu_1_Icon_Hover_Color" text,
    "Menu_1_Icon_Active_Color" text,
    "Menu_1_Price_Color" text,
    "Menu_1_Offer_Price_Color" text,
    "Menu_2_Gallery_Border" text,
    "Menu_2_BG_Type" text,
    "Menu_2_BG_Image" text,
    "Menu_2_BG_Color" text,
    "Menu_2_Title" text,
    "Menu_2_Category_Color" text,
    "Menu_2_Category_Hover_Color" text,
    "Menu_2_Category_Active_Color" text,
    "Menu_2_Lines_Color" text,
    "Menu_2_Btn_BG" text,
    "Menu_2_Btn_Color" text,
    "Menu_2_Name_BG" text,
    "Menu_2_Name_Color" text,
    "Menu_2_Icon_Color" text,
    "Menu_2_Icon_Hover_Color" text,
    "Menu_2_Icon_Active_Color" text,
    "Menu_2_Price_Color" text,
    "Menu_2_Offer_Price_Color" text,
    "Menu_3_BG_Type" text,
    "Menu_3_BG_Image" text,
    "Menu_3_BG_Color" text,
    "Menu_3_Image" text,
    "Menu_3_Icon_Image" text,
    "Menu_3_Title" text,
    "Menu_3_Category_Color" text,
    "Menu_3_Category_Hover_Color" text,
    "Menu_3_Category_Active_Color" text,
    "Menu_3_Box_BG" text,
    "Menu_3_Box_Color" text,
    "Menu_3_Btn_BG" text,
    "Menu_3_Btn_Color" text,
    "Menu_3_Icon_Color" text,
    "Menu_3_Icon_Hover_Color" text,
    "Menu_3_Icon_Active_Color" text,
    "Menu_3_Price_Color" text,
    "Menu_3_Offer_Price_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_menu_styles OWNER TO demorabiherp_karim;

--
-- Name: resturant_menu_styles_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_menu_styles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_menu_styles_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_menu_styles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_menu_styles_id_seq OWNED BY public.resturant_menu_styles.id;


--
-- Name: resturant_nav_foot_styles; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_nav_foot_styles (
    id bigint NOT NULL,
    "Navbar_BG" text,
    "Navbar_Txt_Color" text,
    "Navbar_Txt_Hover_Color" text,
    "Navbar_Btn_BG" text,
    "Navbar_Btn_Color" text,
    "Navbar_Sub_Menu_BG" text,
    "Navbar_Sub_Menu_Color" text,
    "Footer_BG_Type" text,
    "Footer_BG_Color" text,
    "Footer_BG_Image" text,
    "Footer_Title_Color" text,
    "Footer_Txt_Color" text,
    "Footer_Social_Color" text,
    "Footer_Social_Hover_Color" text,
    "Footer_CopyRight_Color" text,
    "Footer_CopyRight_Company_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_nav_foot_styles OWNER TO demorabiherp_karim;

--
-- Name: resturant_nav_foot_styles_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_nav_foot_styles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_nav_foot_styles_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_nav_foot_styles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_nav_foot_styles_id_seq OWNED BY public.resturant_nav_foot_styles.id;


--
-- Name: resturant_privacies; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_privacies (
    id bigint NOT NULL,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_privacies OWNER TO demorabiherp_karim;

--
-- Name: resturant_privacies_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_privacies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_privacies_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_privacies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_privacies_id_seq OWNED BY public.resturant_privacies.id;


--
-- Name: resturant_reservations; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_reservations (
    id bigint NOT NULL,
    "Name" text,
    "Phone" text,
    "Persons" text,
    "Date" text,
    "Time" text,
    "Message" text,
    "Approve" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_reservations OWNER TO demorabiherp_karim;

--
-- Name: resturant_reservations_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_reservations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_reservations_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_reservations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_reservations_id_seq OWNED BY public.resturant_reservations.id;


--
-- Name: resturant_reviews; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_reviews (
    id bigint NOT NULL,
    "Image" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_reviews OWNER TO demorabiherp_karim;

--
-- Name: resturant_reviews_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_reviews_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_reviews_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_reviews_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_reviews_id_seq OWNED BY public.resturant_reviews.id;


--
-- Name: resturant_sliders; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_sliders (
    id bigint NOT NULL,
    "Status" text,
    "Arabic_Title" text,
    "English_Title" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    "Image" text,
    "Type" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_sliders OWNER TO demorabiherp_karim;

--
-- Name: resturant_sliders_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_sliders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_sliders_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_sliders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_sliders_id_seq OWNED BY public.resturant_sliders.id;


--
-- Name: resturant_socials; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_socials (
    id bigint NOT NULL,
    "Facebook" text,
    "Twitter" text,
    "Instagram" text,
    "Youtube" text,
    "Snapchat" text,
    "Whatsapp" text,
    "Google_Plus" text,
    "LinkedIn" text,
    "Pinterest" text,
    "Telegram" text,
    "iOS" text,
    "Android" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_socials OWNER TO demorabiherp_karim;

--
-- Name: resturant_socials_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_socials_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_socials_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_socials_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_socials_id_seq OWNED BY public.resturant_socials.id;


--
-- Name: resturant_styles; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_styles (
    id bigint NOT NULL,
    "Font" text,
    "Home" text,
    "Menu" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Reviews" text,
    "Privacy" text,
    "Terms" text,
    "Gallery" text,
    "Blogs" text,
    "Cart" text,
    "PDF" text,
    "Reservations" text,
    "Body_BG_Type" text,
    "Modal_Txt_Color" text,
    "Modal_BG_Color" text,
    "Pagination_Active_Txt_Color" text,
    "Pagination_Active_BG_Color" text,
    "Pagination_Txt_Color" text,
    "Pagination_BG_Color" text,
    "Body_Title_Color" text,
    "Modal_Button_Txt_Color" text,
    "Modal_Button_BG_Color" text,
    "Form_Input_Txt_Color" text,
    "Form_Input_BG" text,
    "Form_Txt_Hover_Color" text,
    "Form_Txt_Color" text,
    "Form_Box_Border_Color" text,
    "Form_Box_BG" text,
    "Preloader_Circle_3_Color" text,
    "Preloader_Circle_2_Color" text,
    "Preloader_Circle_1_Color" text,
    "Form_Btn_Txt_Color" text,
    "Form_Btn_BG" text,
    "Body_BG_Image" text,
    "Body_BG_Color" text
);


ALTER TABLE public.resturant_styles OWNER TO demorabiherp_karim;

--
-- Name: resturant_styles_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_styles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_styles_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_styles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_styles_id_seq OWNED BY public.resturant_styles.id;


--
-- Name: resturant_sup_page_styles; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_sup_page_styles (
    id bigint NOT NULL,
    "Blogs_BG_Type" text,
    "Blogs_BG_Image" text,
    "Blogs_BG_Color" text,
    "Blogs_Title_Color" text,
    "Blogs_Top_Image" text,
    "Blogs_Box_BG" text,
    "Blogs_Box_Border" text,
    "Blogs_Box_Txt_Color" text,
    "Blogs_Box_Txt_Hover_Color" text,
    "Blogs_Btn_Color" text,
    "Blogs_Btn_BG" text,
    "Blogs_Details_Box_BG" text,
    "Blogs_Details_Box_Border" text,
    "Blogs_Details_Box_Txt_Color" text,
    "Reviews_Top_Image" text,
    "Reviews_Title_Color" text,
    "Reviews_BG_Type" text,
    "Reviews_BG_Image" text,
    "Reviews_BG_Color" text,
    "Reviews_Box_BG" text,
    "Reviews_Box_Border" text,
    "Reviews_Icon_Color" text,
    "Gallery_Top_Image" text,
    "Gallery_Title_Color" text,
    "Gallery__BG_Type" text,
    "Gallery__BG_Image" text,
    "Gallery__BG_Color" text,
    "Terms_Privacy_Top_Image" text,
    "Terms_Privacy_Title_Color" text,
    "Terms_Privacy_Box_BG" text,
    "Terms_Privacy_Box_Border" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_sup_page_styles OWNER TO demorabiherp_karim;

--
-- Name: resturant_sup_page_styles_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_sup_page_styles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_sup_page_styles_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_sup_page_styles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_sup_page_styles_id_seq OWNED BY public.resturant_sup_page_styles.id;


--
-- Name: resturant_tables; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_tables (
    id bigint NOT NULL,
    "Table_Number" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Place_Ar" text,
    "Place_En" text,
    "Chairs_Num" text,
    "QR" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_tables OWNER TO demorabiherp_karim;

--
-- Name: resturant_tables_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_tables_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_tables_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_tables_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_tables_id_seq OWNED BY public.resturant_tables.id;


--
-- Name: resturant_terms; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_terms (
    id bigint NOT NULL,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_terms OWNER TO demorabiherp_karim;

--
-- Name: resturant_terms_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_terms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_terms_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_terms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_terms_id_seq OWNED BY public.resturant_terms.id;


--
-- Name: resturant_video_sections; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.resturant_video_sections (
    id bigint NOT NULL,
    "BG_Image" text,
    "Icon" text,
    "Title_Image" text,
    "Video_Link" text,
    "Image_1" text,
    "Image_2" text,
    "Image_3" text,
    "Image_4" text,
    "Number_1" text,
    "Number_2" text,
    "Number_3" text,
    "Number_4" text,
    "Arabic_Title_1" text,
    "Arabic_Title_2" text,
    "Arabic_Title_3" text,
    "Arabic_Title_4" text,
    "English_Title_1" text,
    "English_Title_2" text,
    "English_Title_3" text,
    "English_Title_4" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_video_sections OWNER TO demorabiherp_karim;

--
-- Name: resturant_video_sections_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.resturant_video_sections_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_video_sections_id_seq OWNER TO demorabiherp_karim;

--
-- Name: resturant_video_sections_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.resturant_video_sections_id_seq OWNED BY public.resturant_video_sections.id;


--
-- Name: return_maintaince_bills; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.return_maintaince_bills (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Note" text,
    "Serial_Num" text,
    "Pattern_Image" text,
    "Time" text,
    "Payment_Method" text,
    "Password" text,
    "Pay" text,
    "Work" text,
    "Total" text,
    "Total_Cost" text,
    "Cost_Precent" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_Bf_Taxes" text,
    "Total_Taxes" text,
    "Draw" text,
    "Bill" text,
    "Company" bigint,
    "Device_Type" bigint,
    "Device_Case" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "Account" bigint,
    "Store" bigint,
    "Eng" bigint,
    "Recipient" bigint,
    "Branch" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "CustomerGroup" text,
    "Total_Talf" text
);


ALTER TABLE public.return_maintaince_bills OWNER TO demorabiherp_karim;

--
-- Name: return_maintaince_bills_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.return_maintaince_bills_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_maintaince_bills_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: return_maintaince_bills_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.return_maintaince_bills_arr_seq OWNED BY public.return_maintaince_bills.arr;


--
-- Name: return_maintaince_bills_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.return_maintaince_bills_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_maintaince_bills_id_seq OWNER TO demorabiherp_karim;

--
-- Name: return_maintaince_bills_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.return_maintaince_bills_id_seq OWNED BY public.return_maintaince_bills.id;


--
-- Name: return_products_stores_transfers; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.return_products_stores_transfers (
    id bigint NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "P_Code" text,
    "Price" text,
    "OldPrice" text,
    "Av_Qty" text,
    "SmallCode" text,
    "ReturnQty" text,
    "Trans_Qty" text,
    "Original_Trans_Qty" text,
    "SmallTrans_Qty" text,
    "Total" text,
    "ST_ID" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "To_Store" text,
    "CostPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.return_products_stores_transfers OWNER TO demorabiherp_karim;

--
-- Name: return_products_stores_transfers_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.return_products_stores_transfers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_products_stores_transfers_id_seq OWNER TO demorabiherp_karim;

--
-- Name: return_products_stores_transfers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.return_products_stores_transfers_id_seq OWNED BY public.return_products_stores_transfers.id;


--
-- Name: return_purch_bills_filter_twos; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.return_purch_bills_filter_twos (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Total_Return_Qty" text,
    "Total_Return_Value" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Discount" text,
    "Purchase" text,
    "Pay" text,
    "Payment_Method" text,
    "User" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Refernce_Number" text,
    "Safe" text,
    "Vendor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "Ship" text,
    "Later_Due" text,
    "Type" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.return_purch_bills_filter_twos OWNER TO demorabiherp_karim;

--
-- Name: return_purch_bills_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.return_purch_bills_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_purch_bills_filter_twos_id_seq OWNER TO demorabiherp_karim;

--
-- Name: return_purch_bills_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.return_purch_bills_filter_twos_id_seq OWNED BY public.return_purch_bills_filter_twos.id;


--
-- Name: return_purch_bills_filters; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.return_purch_bills_filters (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Total_Return_Qty" text,
    "Total_Return_Value" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Discount" text,
    "Purchase" text,
    "Pay" text,
    "Payment_Method" text,
    "User" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Refernce_Number" text,
    "Safe" text,
    "Vendor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "Ship" text,
    "Later_Due" text,
    "Type" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.return_purch_bills_filters OWNER TO demorabiherp_karim;

--
-- Name: return_purch_bills_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.return_purch_bills_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_purch_bills_filters_id_seq OWNER TO demorabiherp_karim;

--
-- Name: return_purch_bills_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.return_purch_bills_filters_id_seq OWNED BY public.return_purch_bills_filters.id;


--
-- Name: return_purch_products; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.return_purch_products (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "Return_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Total_Tax" text,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Return" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Date" text,
    "Code" text,
    "Refernce_Number" text,
    "Safe" bigint,
    "Vendor" bigint,
    "Delegate" bigint,
    "Coin" bigint,
    "User" bigint,
    "Cost_Center" bigint,
    "Type" text,
    "Ship" bigint,
    "TDiscount" text,
    "TypeEn" text
);


ALTER TABLE public.return_purch_products OWNER TO demorabiherp_karim;

--
-- Name: return_purch_products_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.return_purch_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_purch_products_id_seq OWNER TO demorabiherp_karim;

--
-- Name: return_purch_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.return_purch_products_id_seq OWNED BY public.return_purch_products.id;


--
-- Name: return_purches; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.return_purches (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Total_Return_Qty" text NOT NULL,
    "Total_Return_Value" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Purchase" bigint NOT NULL,
    "User" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Pay" text,
    "Payment_Method" text,
    "TDiscount" text,
    "Total_Discount" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Refernce_Number" text,
    "Later_Due" text,
    "Cost_Center" bigint,
    "Safe" bigint,
    "Vendor" bigint,
    "Delegate" bigint,
    "Store" bigint,
    "Coin" bigint,
    arr bigint,
    "Ship" bigint,
    "Delete" text DEFAULT 0,
    "Edit" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0
);


ALTER TABLE public.return_purches OWNER TO demorabiherp_karim;

--
-- Name: return_purches_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.return_purches_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_purches_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: return_purches_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.return_purches_arr_seq OWNED BY public.return_purches.arr;


--
-- Name: return_purches_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.return_purches_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_purches_id_seq OWNER TO demorabiherp_karim;

--
-- Name: return_purches_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.return_purches_id_seq OWNED BY public.return_purches.id;


--
-- Name: return_sales; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.return_sales (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Total_Return_Qty" text NOT NULL,
    "Total_Return_Value" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Sales" bigint NOT NULL,
    "User" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Pay" text,
    "Payment_Method" text,
    "TDiscount" text,
    "Total_Discount" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Refernce_Number" text,
    "Executor" text,
    "Later_Due" text,
    "InstallCompany" text,
    "Delivery" text,
    "TaxBill" text,
    "TaxCode" text,
    uuid text,
    "longId" text,
    "hashKey" text,
    "submissionId" text,
    "Sent" text,
    "Safe" bigint,
    "Cost_Center" bigint,
    "Client" bigint,
    "Delegate" bigint,
    "Store" bigint,
    "Coin" bigint,
    arr bigint,
    "Ship" bigint,
    "Edit" text,
    "Delete" text,
    "Edit_New_Code" text,
    "Current_Credit" text,
    "Cost" text,
    "TotalCost" text
);


ALTER TABLE public.return_sales OWNER TO demorabiherp_karim;

--
-- Name: return_sales_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.return_sales_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_sales_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: return_sales_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.return_sales_arr_seq OWNED BY public.return_sales.arr;


--
-- Name: return_sales_bills_filter_twos; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.return_sales_bills_filter_twos (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Total_Return_Qty" text,
    "Total_Return_Value" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Discount" text,
    "Sales" text,
    "Pay" text,
    "Payment_Method" text,
    "User" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Refernce_Number" text,
    "Safe" text,
    "Client" text,
    "Executor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "Ship" text,
    "Later_Due" text,
    "InstallCompany" text,
    "Delivery" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ID" text,
    "Type" text
);


ALTER TABLE public.return_sales_bills_filter_twos OWNER TO demorabiherp_karim;

--
-- Name: return_sales_bills_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.return_sales_bills_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_sales_bills_filter_twos_id_seq OWNER TO demorabiherp_karim;

--
-- Name: return_sales_bills_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.return_sales_bills_filter_twos_id_seq OWNED BY public.return_sales_bills_filter_twos.id;


--
-- Name: return_sales_bills_filters; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.return_sales_bills_filters (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Total_Return_Qty" text,
    "Total_Return_Value" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Discount" text,
    "Sales" text,
    "Pay" text,
    "Payment_Method" text,
    "User" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Refernce_Number" text,
    "Safe" text,
    "Client" text,
    "Executor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "Ship" text,
    "Later_Due" text,
    "InstallCompany" text,
    "Delivery" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text,
    "ID" text
);


ALTER TABLE public.return_sales_bills_filters OWNER TO demorabiherp_karim;

--
-- Name: return_sales_bills_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.return_sales_bills_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_sales_bills_filters_id_seq OWNER TO demorabiherp_karim;

--
-- Name: return_sales_bills_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.return_sales_bills_filters_id_seq OWNED BY public.return_sales_bills_filters.id;


--
-- Name: return_sales_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.return_sales_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_sales_id_seq OWNER TO demorabiherp_karim;

--
-- Name: return_sales_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.return_sales_id_seq OWNED BY public.return_sales.id;


--
-- Name: return_sales_products; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.return_sales_products (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "Recived_Qty" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Total_Tax" text,
    "Exp_Date" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Return" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Code" text,
    "Type" text,
    "Cost_Center" bigint,
    "User" bigint,
    "Delegate" bigint,
    "Executor" bigint,
    "Safe" bigint,
    "Coin" bigint,
    "Date" text,
    "Client" bigint,
    "Refernce_Number" text,
    "Ship" bigint,
    "Patch_Number" text,
    "CoinCode" text,
    "CoinPrice" text,
    "CoinRate" text,
    "AmountEGP" text,
    "DiscountAmount" text,
    "TaxType" text,
    "TaxAmount" text,
    "TaxSubType" text,
    "TaxRate" text,
    "TotalBill" text,
    "SalesTotal" text,
    "NetTotal" text
);


ALTER TABLE public.return_sales_products OWNER TO demorabiherp_karim;

--
-- Name: return_sales_products_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.return_sales_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_sales_products_id_seq OWNER TO demorabiherp_karim;

--
-- Name: return_sales_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.return_sales_products_id_seq OWNED BY public.return_sales_products.id;


--
-- Name: return_stors_transfers; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.return_stors_transfers (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Total" text,
    "TotalQty" text,
    "Note" text,
    "From_Store" text,
    "To_Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Status" text,
    "Ship" text,
    "CostShip" text,
    "RecivedShip" text,
    "OldQty" text,
    "Edit" text,
    "Delegate" text,
    "Time" text,
    "Branch" text,
    "Total_Cost" text,
    "TypeTransfer" text,
    "Cost_Store" text,
    "OriginalID" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.return_stors_transfers OWNER TO demorabiherp_karim;

--
-- Name: return_stors_transfers_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.return_stors_transfers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_stors_transfers_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: return_stors_transfers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.return_stors_transfers_arr_seq OWNED BY public.return_stors_transfers.arr;


--
-- Name: return_stors_transfers_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.return_stors_transfers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_stors_transfers_id_seq OWNER TO demorabiherp_karim;

--
-- Name: return_stors_transfers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.return_stors_transfers_id_seq OWNED BY public.return_stors_transfers.id;


--
-- Name: return_without_bills; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.return_without_bills (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Payment_Method" text,
    "Status" text,
    "Vendor_Bill_Date" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Total_Cost" text,
    "Pay" text,
    "Safe" text,
    "Vendor" text,
    "Deficit_Account" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Due_Date" text,
    "Later_Due" text,
    "TaxBill" text,
    "TaxCode" text,
    "Time" text,
    "Branch" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Delete" text DEFAULT 0,
    "Current_Credit" text
);


ALTER TABLE public.return_without_bills OWNER TO demorabiherp_karim;

--
-- Name: return_without_bills_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.return_without_bills_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_without_bills_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: return_without_bills_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.return_without_bills_arr_seq OWNED BY public.return_without_bills."Code";


--
-- Name: return_without_bills_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.return_without_bills_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_without_bills_id_seq OWNER TO demorabiherp_karim;

--
-- Name: return_without_bills_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.return_without_bills_id_seq OWNED BY public.return_without_bills.id;


--
-- Name: role_has_permissions; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.role_has_permissions (
    permission_id bigint NOT NULL,
    role_id bigint NOT NULL
);


ALTER TABLE public.role_has_permissions OWNER TO demorabiherp_karim;

--
-- Name: roles; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.roles (
    id bigint NOT NULL,
    name character varying(191) NOT NULL,
    guard_name character varying(191) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "nameEn" text
);


ALTER TABLE public.roles OWNER TO demorabiherp_karim;

--
-- Name: roles_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.roles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.roles_id_seq OWNER TO demorabiherp_karim;

--
-- Name: roles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.roles_id_seq OWNED BY public.roles.id;


--
-- Name: room_reservations; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.room_reservations (
    id bigint NOT NULL,
    "Date" text,
    "Room" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.room_reservations OWNER TO demorabiherp_karim;

--
-- Name: room_reservations_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.room_reservations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.room_reservations_id_seq OWNER TO demorabiherp_karim;

--
-- Name: room_reservations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.room_reservations_id_seq OWNED BY public.room_reservations.id;


--
-- Name: rooms; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.rooms (
    id bigint NOT NULL,
    "Code" text,
    "Floor" text,
    "Bulding_Name" text,
    "Adults_Num" text,
    "Childs_Num" text,
    "Beds_Num" text,
    "Desc" text,
    "Price" text,
    "Reserved" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "RoomsType" text,
    "DescEn" text
);


ALTER TABLE public.rooms OWNER TO demorabiherp_karim;

--
-- Name: rooms_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.rooms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rooms_id_seq OWNER TO demorabiherp_karim;

--
-- Name: rooms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.rooms_id_seq OWNED BY public.rooms.id;


--
-- Name: rooms_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.rooms_types (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.rooms_types OWNER TO demorabiherp_karim;

--
-- Name: rooms_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.rooms_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rooms_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: rooms_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.rooms_types_id_seq OWNED BY public.rooms_types.id;


--
-- Name: safe_transfer_columns; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.safe_transfer_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Amount" text,
    "From_Safe" text,
    "To_Safe" text,
    "User" text,
    "Coin" text,
    "Cost_Center" text,
    "Note" text,
    "Delegate" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.safe_transfer_columns OWNER TO demorabiherp_karim;

--
-- Name: safe_transfer_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.safe_transfer_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safe_transfer_columns_id_seq OWNER TO demorabiherp_karim;

--
-- Name: safe_transfer_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.safe_transfer_columns_id_seq OWNED BY public.safe_transfer_columns.id;


--
-- Name: safe_transfer_columns_sechdules; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.safe_transfer_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Amount" text,
    "From_Safe" text,
    "To_Safe" text,
    "User" text,
    "Coin" text,
    "Cost_Center" text,
    "Note" text,
    "Delegate" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.safe_transfer_columns_sechdules OWNER TO demorabiherp_karim;

--
-- Name: safe_transfer_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.safe_transfer_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safe_transfer_columns_sechdules_id_seq OWNER TO demorabiherp_karim;

--
-- Name: safe_transfer_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.safe_transfer_columns_sechdules_id_seq OWNED BY public.safe_transfer_columns_sechdules.id;


--
-- Name: safe_transfer_filter_twos; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.safe_transfer_filter_twos (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Amount" text,
    "Note" text,
    "From_Safe" text,
    "To_Safe" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Status" text,
    "File" text,
    "OldAmount" text,
    "Edit" text,
    "Delegate" text,
    "Time" text,
    "ID" text,
    "Type" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.safe_transfer_filter_twos OWNER TO demorabiherp_karim;

--
-- Name: safe_transfer_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.safe_transfer_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safe_transfer_filter_twos_id_seq OWNER TO demorabiherp_karim;

--
-- Name: safe_transfer_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.safe_transfer_filter_twos_id_seq OWNED BY public.safe_transfer_filter_twos.id;


--
-- Name: safe_transfer_filters; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.safe_transfer_filters (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Amount" text,
    "Note" text,
    "From_Safe" text,
    "To_Safe" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Status" text,
    "File" text,
    "OldAmount" text,
    "Edit" text,
    "Delegate" text,
    "Time" text,
    "ID" text,
    "Type" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.safe_transfer_filters OWNER TO demorabiherp_karim;

--
-- Name: safe_transfer_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.safe_transfer_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safe_transfer_filters_id_seq OWNER TO demorabiherp_karim;

--
-- Name: safe_transfer_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.safe_transfer_filters_id_seq OWNED BY public.safe_transfer_filters.id;


--
-- Name: safe_transfers; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.safe_transfers (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Amount" text NOT NULL,
    "Note" text,
    "From_Safe" bigint NOT NULL,
    "To_Safe" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text DEFAULT 0,
    "File" text,
    "OldAmount" text,
    "Edit" text,
    "Time" text,
    "Delegate" bigint,
    arr bigint,
    "Branch" bigint
);


ALTER TABLE public.safe_transfers OWNER TO demorabiherp_karim;

--
-- Name: safe_transfers_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.safe_transfers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safe_transfers_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: safe_transfers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.safe_transfers_arr_seq OWNED BY public.safe_transfers."Code";


--
-- Name: safe_transfers_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.safe_transfers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safe_transfers_id_seq OWNER TO demorabiherp_karim;

--
-- Name: safe_transfers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.safe_transfers_id_seq OWNED BY public.safe_transfers.id;


--
-- Name: safes_banks; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.safes_banks (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Name" text NOT NULL,
    "Type" text NOT NULL,
    "Note" text,
    "Account" bigint NOT NULL,
    "User" bigint NOT NULL,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text,
    "Service_Fee" text,
    "NameEn" text
);


ALTER TABLE public.safes_banks OWNER TO demorabiherp_karim;

--
-- Name: safes_banks_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.safes_banks_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safes_banks_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: safes_banks_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.safes_banks_arr_seq OWNED BY public.safes_banks."Code";


--
-- Name: safes_banks_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.safes_banks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safes_banks_id_seq OWNER TO demorabiherp_karim;

--
-- Name: safes_banks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.safes_banks_id_seq OWNED BY public.safes_banks.id;


--
-- Name: sales; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.sales (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Payment_Method" text NOT NULL,
    "Status" text NOT NULL,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    presenter text,
    annual_interest text,
    monthly_installment text,
    "Years_Number" text,
    total text,
    "installment_Num" text,
    "Date_First_installment" text,
    "Quote" text,
    "SalesOrder" text,
    "Safe" bigint NOT NULL,
    "Client" bigint NOT NULL,
    "Delegate" bigint,
    "Executor" bigint,
    "Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Ship" bigint,
    arr bigint,
    "Check_Type" bigint,
    "Check_Number" text,
    "Due_Date" text,
    "ShipStatus" text DEFAULT 0,
    "Cash" text,
    "Visa" text,
    "Sale_Type" text,
    "Hold" text,
    "Shift_Code" text,
    emp bigint,
    "Store_Code" text,
    "Later_Due" text,
    "Later_Collection" text DEFAULT 1,
    "Client_Address" text,
    "Delivery" text,
    "Delivery_Status" text,
    "Sale_User" text,
    "Sent" text,
    "TaxBill" text DEFAULT 0,
    "TaxCode" text,
    "ProfitPrecent" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "ProfitTax" text DEFAULT 0,
    "ContractNumber" text,
    "PayFees" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Total_Cost" text,
    uuid text,
    "longId" text,
    "hashKey" text,
    "submissionId" text,
    "statusBill" text,
    "DiscountTax" text,
    "RecivedDate" text,
    "InstallCompany" bigint,
    "File" text,
    "ResturantOrderType" text,
    "DeliveryTime" text,
    "RecivedOrderTime" text,
    "RecivedOrder" text,
    "KitchenEndTime" text,
    "KitchenEnd" text,
    "Witer" text,
    "TakeawayTime" text,
    "TakeawayStatus" text,
    "Table" bigint,
    "Total_Wight_Bill" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text,
    "Total_Net" text,
    "Residual" text,
    "Current_Credit" text,
    "DiscountBill" text DEFAULT 0,
    "ServiceType" text,
    "ServiceFees" text,
    "ServiceValue" text,
    bill_lat text,
    bill_lng text,
    "App" bigint,
    "Shipping_Price" text
);


ALTER TABLE public.sales OWNER TO demorabiherp_karim;

--
-- Name: sales_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sales_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: sales_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sales_arr_seq OWNED BY public.sales.arr;


--
-- Name: sales_bills_columns; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.sales_bills_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "ShiftCode" text,
    "Executor" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Av_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Total_BF_Tax" text,
    "Tax" text,
    "Total" text,
    "Group" text,
    "Brand" text,
    "Exp_Date" text,
    "Product_Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Client" text,
    "Rate" text,
    "Name_Width" text
);


ALTER TABLE public.sales_bills_columns OWNER TO demorabiherp_karim;

--
-- Name: sales_bills_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sales_bills_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_bills_columns_id_seq OWNER TO demorabiherp_karim;

--
-- Name: sales_bills_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sales_bills_columns_id_seq OWNED BY public.sales_bills_columns.id;


--
-- Name: sales_bills_columns_sechdules; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.sales_bills_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "ShiftCode" text,
    "Executor" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Av_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Total_BF_Tax" text,
    "Tax" text,
    "Total" text,
    "Group" text,
    "Brand" text,
    "Exp_Date" text,
    "Product_Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Client" text,
    "Rate" text,
    "Name_Width" text
);


ALTER TABLE public.sales_bills_columns_sechdules OWNER TO demorabiherp_karim;

--
-- Name: sales_bills_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sales_bills_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_bills_columns_sechdules_id_seq OWNER TO demorabiherp_karim;

--
-- Name: sales_bills_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sales_bills_columns_sechdules_id_seq OWNED BY public.sales_bills_columns_sechdules.id;


--
-- Name: sales_bills_filter_twos; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.sales_bills_filter_twos (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Payment_Method" text,
    "Status" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Safe" text,
    "Client" text,
    "Executor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Ship" text,
    "Shift_Code" text,
    "Later_Due" text,
    "Later_Collection" text,
    "Delivery" text,
    "ProfitPrecent" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "ProfitTax" text,
    "InstallCompany" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ID" text,
    "Type" text
);


ALTER TABLE public.sales_bills_filter_twos OWNER TO demorabiherp_karim;

--
-- Name: sales_bills_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sales_bills_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_bills_filter_twos_id_seq OWNER TO demorabiherp_karim;

--
-- Name: sales_bills_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sales_bills_filter_twos_id_seq OWNED BY public.sales_bills_filter_twos.id;


--
-- Name: sales_bills_filters; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.sales_bills_filters (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Payment_Method" text,
    "Status" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Safe" text,
    "Client" text,
    "Executor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Ship" text,
    "Shift_Code" text,
    "Later_Due" text,
    "Later_Collection" text,
    "Delivery" text,
    "ProfitPrecent" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "ProfitTax" text,
    "InstallCompany" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text,
    "ID" text
);


ALTER TABLE public.sales_bills_filters OWNER TO demorabiherp_karim;

--
-- Name: sales_bills_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sales_bills_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_bills_filters_id_seq OWNER TO demorabiherp_karim;

--
-- Name: sales_bills_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sales_bills_filters_id_seq OWNED BY public.sales_bills_filters.id;


--
-- Name: sales_default_data; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.sales_default_data (
    id bigint NOT NULL,
    "Payment_Method" text,
    "Status" text,
    "V_and_C" text,
    "Mainus" text,
    "Price_Sale" text,
    "Safe" bigint,
    "Client" bigint,
    "Delegate" bigint,
    "Store" bigint,
    "Coin" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Brand" text,
    "Group" text,
    "English_Name" text,
    "Expire" text,
    "Draw" text,
    "Shift_Pass" text,
    "Empp" text,
    "Discount" text,
    "Delivery" text,
    "Execute_Precent" text,
    "StoresQty" text,
    "DelegateEmp" text,
    "TaxType" text,
    "DiscountTaxShow" text,
    "SalesOrderType" text,
    "ECommercceSaleType" text,
    "Kitchen_Order" text,
    "Waiter" text,
    "Hall_Service_Type" text,
    "Hall_Service_Precent" text,
    "CountryResturantWebsite" text,
    "Bank" text,
    "Country" text,
    "SalesLowCostPrice" text,
    "ShowJobOrders" text,
    "LimitSalesQty" text,
    "Total_Wight_Bill" text,
    "Duplicate_Items" text,
    "ExecuteEmp" text,
    "Hide_Product" text,
    "Choice_Collector_POS" text,
    "Hide_Discount_POS" text,
    "Hide_Edit_Delete" text,
    "Daily_Clients" text,
    "Location_Conditon" text,
    "Show_Image_Print" text,
    "InstallmentSystem" text DEFAULT 0,
    "Ecommerce_Sales" text DEFAULT 1,
    "Use_Max_Discount_Group" text,
    "ResturantDeliveryDirect" text
);


ALTER TABLE public.sales_default_data OWNER TO demorabiherp_karim;

--
-- Name: sales_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sales_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_default_data_id_seq OWNER TO demorabiherp_karim;

--
-- Name: sales_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sales_default_data_id_seq OWNED BY public.sales_default_data.id;


--
-- Name: sales_fifo_qties; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.sales_fifo_qties (
    id bigint NOT NULL,
    "Sales_Qty" text,
    "Sales_ID" text,
    "Fifo_ID" text,
    "Store" text,
    "Product" text,
    "Cost_Price" text,
    "Purchases_Date" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sales_fifo_qties OWNER TO demorabiherp_karim;

--
-- Name: sales_fifo_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sales_fifo_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_fifo_qties_id_seq OWNER TO demorabiherp_karim;

--
-- Name: sales_fifo_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sales_fifo_qties_id_seq OWNED BY public.sales_fifo_qties.id;


--
-- Name: sales_gifts; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.sales_gifts (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Total_Cost" text,
    "Client" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "Edit" text DEFAULT '0'::text,
    "Delete" text DEFAULT '0'::text,
    "Edit_New_Code" text,
    "User" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Account" text
);


ALTER TABLE public.sales_gifts OWNER TO demorabiherp_karim;

--
-- Name: sales_gifts_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sales_gifts_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_gifts_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: sales_gifts_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sales_gifts_arr_seq OWNED BY public.sales_gifts."Code";


--
-- Name: sales_gifts_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sales_gifts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_gifts_id_seq OWNER TO demorabiherp_karim;

--
-- Name: sales_gifts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sales_gifts_id_seq OWNED BY public.sales_gifts.id;


--
-- Name: sales_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sales_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_id_seq OWNER TO demorabiherp_karim;

--
-- Name: sales_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sales_id_seq OWNED BY public.sales.id;


--
-- Name: sales_maint_fifo_qties; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.sales_maint_fifo_qties (
    id bigint NOT NULL,
    "Sales_Qty" text,
    "Sales_ID" text,
    "Fifo_ID" text,
    "Store" text,
    "Product" text,
    "Cost_Price" text,
    "Purchases_Date" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sales_maint_fifo_qties OWNER TO demorabiherp_karim;

--
-- Name: sales_maint_fifo_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sales_maint_fifo_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_maint_fifo_qties_id_seq OWNER TO demorabiherp_karim;

--
-- Name: sales_maint_fifo_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sales_maint_fifo_qties_id_seq OWNED BY public.sales_maint_fifo_qties.id;


--
-- Name: sales_orders; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.sales_orders (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Payment_Method" text NOT NULL,
    "Status" text NOT NULL,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    presenter text,
    annual_interest text,
    monthly_installment text,
    "Years_Number" text,
    total text,
    "installment_Num" text,
    "Date_First_installment" text,
    "Quote" text,
    "Safe" bigint NOT NULL,
    "Client" bigint NOT NULL,
    "Delegate" bigint,
    "Executor" bigint,
    "Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ToSales" text DEFAULT 0,
    "Hold" text DEFAULT 0,
    "Later_Due" text,
    "Sale_Date" text,
    "CuponCode" text,
    "Shipping" text,
    "Delivery_Status" text,
    "Order_Type" text,
    "Name" text,
    "Email" text,
    "Phone" text,
    "OtherPhone" text,
    "Address_Name" text,
    "Special_MarkAdd" text,
    "StreetAdd" text,
    "BulidingAdd" text,
    "FloorAdd" text,
    "FlatAdd" text,
    "Governrate" text,
    "City" text,
    "Place" text,
    "LocationAdd" text,
    "Address_DetailsAdd" text,
    "ProfitPrecent" text,
    "InstallCompany" text,
    "ContractNumber" text,
    "PayFees" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Cancel_Order" text,
    "Time" text,
    "Delegate_Recived" text,
    "Delegate_Recived_Time" text,
    "To_Sales_Time" text,
    "Cancel_Order_Time" text,
    "Hold_Qty" text,
    "ResturantOrderType" text,
    "DeliveryTime" text,
    "RecivedOrderTime" text,
    "RecivedOrder" text,
    "KitchenEndTime" text,
    "KitchenEnd" text,
    "Witer" text,
    "TakeawayStatus" text,
    "TakeawayTime" text,
    "Table" bigint,
    "Total_Wight_Bill" text,
    "TaxBill" text,
    "TaxCode" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "Check_Type" text,
    "Due_Date" text,
    "Check_Number" text,
    "Shift_Code" text,
    "Client_Address" text,
    "Delivery" text,
    "ProfitTax" text,
    "Branch" text,
    "CustomerGroup" text,
    "Total_Cost" text,
    "File" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0,
    "Total_Net" text,
    "Residual" text,
    "DiscountTax" text,
    "Current_Credit" text,
    "Ship" text,
    "DiscountBill" text DEFAULT 0,
    "Shipping_Price" text
);


ALTER TABLE public.sales_orders OWNER TO demorabiherp_karim;

--
-- Name: sales_orders_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sales_orders_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_orders_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: sales_orders_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sales_orders_arr_seq OWNED BY public.sales_orders.arr;


--
-- Name: sales_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sales_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_orders_id_seq OWNER TO demorabiherp_karim;

--
-- Name: sales_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sales_orders_id_seq OWNED BY public.sales_orders.id;


--
-- Name: sales_petrols; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.sales_petrols (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Note" text,
    "Counter_Name" text,
    "Pervious_Read" text,
    "Petrol_Name" text,
    "Current_Raed" text,
    "Value" text,
    "Total" text,
    "Consumption" text,
    "Cash" text,
    "Calibers" text,
    "Counter" bigint,
    "Coin" bigint,
    "Safe" bigint,
    "Store" bigint,
    "Recipient" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sales_petrols OWNER TO demorabiherp_karim;

--
-- Name: sales_petrols_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sales_petrols_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_petrols_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: sales_petrols_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sales_petrols_arr_seq OWNED BY public.sales_petrols.arr;


--
-- Name: sales_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sales_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_petrols_id_seq OWNER TO demorabiherp_karim;

--
-- Name: sales_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sales_petrols_id_seq OWNED BY public.sales_petrols.id;


--
-- Name: sales_serial; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sales_serial
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_serial OWNER TO demorabiherp_karim;

--
-- Name: sales_subscribes; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.sales_subscribes (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Payment_Method" text,
    "Later_Due" text,
    "Product_Numbers" text,
    "Total_Price" text,
    "Notes" text,
    "Coin" bigint,
    "Delegate" bigint,
    "Account" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Safe" bigint,
    "Delete" text DEFAULT 0,
    "Edit" text DEFAULT 0,
    "Edit_New_Code" text,
    "Current_Credit" text
);


ALTER TABLE public.sales_subscribes OWNER TO demorabiherp_karim;

--
-- Name: sales_subscribes_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sales_subscribes_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_subscribes_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: sales_subscribes_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sales_subscribes_arr_seq OWNED BY public.sales_subscribes.arr;


--
-- Name: sales_subscribes_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sales_subscribes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_subscribes_id_seq OWNER TO demorabiherp_karim;

--
-- Name: sales_subscribes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sales_subscribes_id_seq OWNED BY public.sales_subscribes.id;


--
-- Name: scientific_materials; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.scientific_materials (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.scientific_materials OWNER TO demorabiherp_karim;

--
-- Name: scientific_materials_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.scientific_materials_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.scientific_materials_id_seq OWNER TO demorabiherp_karim;

--
-- Name: scientific_materials_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.scientific_materials_id_seq OWNED BY public.scientific_materials.id;


--
-- Name: secretariat_export_goods; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.secretariat_export_goods (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Account" bigint NOT NULL,
    "Store" bigint NOT NULL,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text DEFAULT 0,
    "StoreGoods" text,
    "Total_Recived_Qty" text,
    "Total_Price" text,
    "Draw" text,
    "Coin" text,
    "Safe" text
);


ALTER TABLE public.secretariat_export_goods OWNER TO demorabiherp_karim;

--
-- Name: secretariat_export_goods_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.secretariat_export_goods_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.secretariat_export_goods_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: secretariat_export_goods_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.secretariat_export_goods_arr_seq OWNED BY public.secretariat_export_goods."Code";


--
-- Name: secretariat_export_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.secretariat_export_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.secretariat_export_goods_id_seq OWNER TO demorabiherp_karim;

--
-- Name: secretariat_export_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.secretariat_export_goods_id_seq OWNED BY public.secretariat_export_goods.id;


--
-- Name: secretariat_import_goods; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.secretariat_import_goods (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Account" bigint NOT NULL,
    "Store" bigint NOT NULL,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.secretariat_import_goods OWNER TO demorabiherp_karim;

--
-- Name: secretariat_import_goods_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.secretariat_import_goods_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.secretariat_import_goods_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: secretariat_import_goods_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.secretariat_import_goods_arr_seq OWNED BY public.secretariat_import_goods.arr;


--
-- Name: secretariat_import_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.secretariat_import_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.secretariat_import_goods_id_seq OWNER TO demorabiherp_karim;

--
-- Name: secretariat_import_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.secretariat_import_goods_id_seq OWNED BY public.secretariat_import_goods.id;


--
-- Name: secretariat_qties; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.secretariat_qties (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Store" bigint NOT NULL,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "PP_Code" text,
    "PPP_Code" text,
    "PPPP_Code" text
);


ALTER TABLE public.secretariat_qties OWNER TO demorabiherp_karim;

--
-- Name: secretariat_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.secretariat_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.secretariat_qties_id_seq OWNER TO demorabiherp_karim;

--
-- Name: secretariat_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.secretariat_qties_id_seq OWNED BY public.secretariat_qties.id;


--
-- Name: secretariat_stores; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.secretariat_stores (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.secretariat_stores OWNER TO demorabiherp_karim;

--
-- Name: secretariat_stores_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.secretariat_stores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.secretariat_stores_id_seq OWNER TO demorabiherp_karim;

--
-- Name: secretariat_stores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.secretariat_stores_id_seq OWNED BY public.secretariat_stores.id;


--
-- Name: select_a_p_i_s; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.select_a_p_i_s (
    id bigint NOT NULL,
    id_ text NOT NULL,
    name text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.select_a_p_i_s OWNER TO demorabiherp_karim;

--
-- Name: select_a_p_i_s_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.select_a_p_i_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.select_a_p_i_s_id_seq OWNER TO demorabiherp_karim;

--
-- Name: select_a_p_i_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.select_a_p_i_s_id_seq OWNED BY public.select_a_p_i_s.id;


--
-- Name: server_d_b_s; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.server_d_b_s (
    id bigint NOT NULL,
    "DB_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.server_d_b_s OWNER TO demorabiherp_karim;

--
-- Name: server_d_b_s_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.server_d_b_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.server_d_b_s_id_seq OWNER TO demorabiherp_karim;

--
-- Name: server_d_b_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.server_d_b_s_id_seq OWNED BY public.server_d_b_s.id;


--
-- Name: settlements; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.settlements (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Total_Dificit" text NOT NULL,
    "Total_Excess" text NOT NULL,
    "Total_Dificit_Price" text NOT NULL,
    "Total_Excess_Price" text NOT NULL,
    "Inv_ID" bigint,
    "Account_Excess" bigint NOT NULL,
    "Account_Dificit" bigint NOT NULL,
    "Store" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Note" text,
    "Time" text,
    "Branch" text
);


ALTER TABLE public.settlements OWNER TO demorabiherp_karim;

--
-- Name: settlements_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.settlements_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.settlements_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: settlements_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.settlements_arr_seq OWNED BY public.settlements.arr;


--
-- Name: settlements_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.settlements_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.settlements_id_seq OWNER TO demorabiherp_karim;

--
-- Name: settlements_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.settlements_id_seq OWNED BY public.settlements.id;


--
-- Name: shifts; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shifts (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Note" text,
    "Total_Cash" text DEFAULT 0,
    "Total_Later" text DEFAULT 0,
    "Total_Visa" text DEFAULT 0,
    "Total" text DEFAULT 0,
    "Pass" text,
    "Emp" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Close" text,
    "Amount" text,
    "Total_Recipt" text DEFAULT 0,
    "Total_Payment" text DEFAULT 0,
    "Store" text,
    "Safe" text,
    "Total_Later_Not_Paid" text DEFAULT 0,
    "Total_Later_Paid" text DEFAULT 0,
    "Total_Installment" text DEFAULT 0,
    "Total_Checks" text DEFAULT 0,
    "Total_Delivery" text DEFAULT 0,
    "Total_Installment_Companies" text DEFAULT 0,
    "Close_Date" text,
    "Open_Amount" text,
    "Open_Note" text,
    "Apps" text DEFAULT 0
);


ALTER TABLE public.shifts OWNER TO demorabiherp_karim;

--
-- Name: shifts_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shifts_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shifts_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: shifts_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shifts_arr_seq OWNED BY public.shifts.arr;


--
-- Name: shifts_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shifts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shifts_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shifts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shifts_id_seq OWNED BY public.shifts.id;


--
-- Name: shipment_moves; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shipment_moves (
    id bigint NOT NULL,
    "Code" text,
    "Barcode" text,
    "Date" text,
    "Time" text,
    "Sender" text,
    "Sender_Name" text,
    "Reciver" text,
    "Reciver_Name" text,
    "Status" text,
    "Status_Code" text,
    "Delegate" text,
    "Driver" text,
    "Note" text,
    "User" text,
    "Shipment_ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Shipment_Dist_ID" text,
    "Shipment_Unload_ID" text,
    "Shipment_Recived_ID" text
);


ALTER TABLE public.shipment_moves OWNER TO demorabiherp_karim;

--
-- Name: shipment_moves_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipment_moves_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_moves_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shipment_moves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipment_moves_id_seq OWNED BY public.shipment_moves.id;


--
-- Name: shipment_receipts; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shipment_receipts (
    id bigint NOT NULL,
    "Recived_Store" text,
    "Code" text,
    "Date" text,
    "Total_Cash" text,
    "Total_Later" text,
    "Total_Price" text,
    "Tickets_Numbers" text,
    "Status" text,
    "ShippingList" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipment_receipts OWNER TO demorabiherp_karim;

--
-- Name: shipment_receipts_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipment_receipts_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_receipts_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: shipment_receipts_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipment_receipts_arr_seq OWNED BY public.shipment_receipts.arr;


--
-- Name: shipment_receipts_clients; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shipment_receipts_clients (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "ShipmentReceipts" text,
    "ShipmentReceiptsList" text,
    "Total_Price" text,
    "Total_Qty" text,
    "Pay" text,
    "Payment_Method" text,
    "Safe" text,
    "Coin" text,
    "Draw" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipment_receipts_clients OWNER TO demorabiherp_karim;

--
-- Name: shipment_receipts_clients_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipment_receipts_clients_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_receipts_clients_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: shipment_receipts_clients_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipment_receipts_clients_arr_seq OWNED BY public.shipment_receipts_clients.arr;


--
-- Name: shipment_receipts_clients_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipment_receipts_clients_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_receipts_clients_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shipment_receipts_clients_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipment_receipts_clients_id_seq OWNED BY public.shipment_receipts_clients.id;


--
-- Name: shipment_receipts_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipment_receipts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_receipts_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shipment_receipts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipment_receipts_id_seq OWNED BY public.shipment_receipts.id;


--
-- Name: shipment_receipts_lists; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shipment_receipts_lists (
    id bigint NOT NULL,
    "Shipping_List" text,
    "Code" text,
    "Sender_Name" text,
    "Addressees_Name" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Payment_Method" text,
    "Notes" text,
    "Ticket" text,
    "ShipmentReceipts" text,
    "Status" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipment_receipts_lists OWNER TO demorabiherp_karim;

--
-- Name: shipment_receipts_lists_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipment_receipts_lists_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_receipts_lists_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: shipment_receipts_lists_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipment_receipts_lists_arr_seq OWNED BY public.shipment_receipts_lists.arr;


--
-- Name: shipment_receipts_lists_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipment_receipts_lists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_receipts_lists_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shipment_receipts_lists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipment_receipts_lists_id_seq OWNED BY public.shipment_receipts_lists.id;


--
-- Name: shipment_requests; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shipment_requests (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Time" text,
    "Status" text,
    "Pieces_Num" text,
    "Desc" text,
    "Weight" text,
    "Length" text,
    "Width" text,
    "Height" text,
    "Note" text,
    "Payment_Method" text,
    "Breakable" text,
    "Delivery_To_Others" text,
    "Opening_Package" text,
    "Sender_Name" text,
    "Sender_Governorate" text,
    "Sender_City" text,
    "Sender_Place" text,
    "Sender_Address" text,
    "Sender_Phone1" text,
    "Sender_Phone2" text,
    "Sender_Location" text,
    "Receiver_Name" text,
    "Receiver_Governorate" text,
    "Receiver_City" text,
    "Receiver_Place" text,
    "Receiver_Address" text,
    "Receiver_Phone1" text,
    "Receiver_Phone2" text,
    "Receiver_Location" text,
    "Delegate" text,
    "Sender" text,
    "Received" text,
    "Shipment_Cost" text,
    "Total" text,
    "User" text,
    "Pay" text,
    "Safe" text,
    "Coin" text,
    "Draw" text,
    "Transfer" text DEFAULT '0'::text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipment_requests OWNER TO demorabiherp_karim;

--
-- Name: shipment_requests_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipment_requests_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_requests_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: shipment_requests_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipment_requests_arr_seq OWNED BY public.shipment_requests."Code";


--
-- Name: shipment_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipment_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_requests_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shipment_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipment_requests_id_seq OWNED BY public.shipment_requests.id;


--
-- Name: shipments; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shipments (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Time" text,
    "Arrival_Date" text,
    "Arrival_Time" text,
    "Barcode" text,
    "Status" text DEFAULT '0'::text,
    "Pieces_Num" text,
    "Desc" text,
    "Reference_Num" text,
    "Weight" text,
    "Length" text,
    "Width" text,
    "Height" text,
    "Note" text,
    "Shipment_Class" text,
    "Payment_Method" text,
    "Breakable" text,
    "Delivery_To_Others" text,
    "Shipping_Costs_Included" text,
    "Opening_Package" text,
    "Sender_Name" text,
    "Sender_Governorate" text,
    "Sender_City" text,
    "Sender_Place" text,
    "Sender_Address" text,
    "Sender_Phone1" text,
    "Sender_Phone2" text,
    "Sender_Location" text,
    "Receiver_Name" text,
    "Receiver_Governorate" text,
    "Receiver_City" text,
    "Receiver_Place" text,
    "Receiver_Address" text,
    "Receiver_Phone1" text,
    "Receiver_Phone2" text,
    "Receiver_Location" text,
    "Delegate" text,
    "Driver" text,
    "Sender" text,
    "Received" text,
    "Shipment_Type" text,
    "Shipment_Rqst_Type" text,
    "Shipment_Category" text,
    "Shipment_Cost" text,
    "Goods_Cost" text,
    "Delivery_Cost" text,
    "Overload_Weight_Cost" text,
    "Collection_Commission" text,
    "Delivery_Commission" text,
    "Return_Cost" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "User" text,
    "Pay" text,
    "Insurance" text,
    "Safe" text,
    "Coin" text,
    "Draw" text,
    "Store" text,
    "Car" text,
    "ToStore" text
);


ALTER TABLE public.shipments OWNER TO demorabiherp_karim;

--
-- Name: shipments_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipments_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipments_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: shipments_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipments_arr_seq OWNED BY public.shipments."Code";


--
-- Name: shipments_distribution_goods; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shipments_distribution_goods (
    id bigint NOT NULL,
    "Shipment_ID" text,
    "Code" text,
    "Total_Weight" text,
    "Total_Cost" text,
    "ShipmentsDistribution" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Barcode" text,
    "Total_Pieces" text,
    "Status" text DEFAULT 0
);


ALTER TABLE public.shipments_distribution_goods OWNER TO demorabiherp_karim;

--
-- Name: shipments_distribution_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipments_distribution_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipments_distribution_goods_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shipments_distribution_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipments_distribution_goods_id_seq OWNED BY public.shipments_distribution_goods.id;


--
-- Name: shipments_distribution_workers; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shipments_distribution_workers (
    id bigint NOT NULL,
    "Worker" text,
    "ShipmentsDistribution" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipments_distribution_workers OWNER TO demorabiherp_karim;

--
-- Name: shipments_distribution_workers_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipments_distribution_workers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipments_distribution_workers_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shipments_distribution_workers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipments_distribution_workers_id_seq OWNED BY public.shipments_distribution_workers.id;


--
-- Name: shipments_distributions; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shipments_distributions (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Time" text,
    "Safe" text,
    "Coin" text,
    "Draw" text,
    "FromStore" text,
    "ToStore" text,
    "Car" text,
    "Delegate" text,
    "Driver" text,
    "Total_Pieces" text,
    "Total_Weight" text,
    "Total_Cost" text,
    "Status" text,
    "User" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Count_Shipmets" text
);


ALTER TABLE public.shipments_distributions OWNER TO demorabiherp_karim;

--
-- Name: shipments_distributions_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipments_distributions_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipments_distributions_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: shipments_distributions_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipments_distributions_arr_seq OWNED BY public.shipments_distributions."Code";


--
-- Name: shipments_distributions_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipments_distributions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipments_distributions_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shipments_distributions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipments_distributions_id_seq OWNED BY public.shipments_distributions.id;


--
-- Name: shipments_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipments_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shipments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipments_id_seq OWNED BY public.shipments.id;


--
-- Name: shipping_companies; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shipping_companies (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Phone" text,
    "Tax_Card" text,
    "Commercial_Register" text,
    "Account" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.shipping_companies OWNER TO demorabiherp_karim;

--
-- Name: shipping_companies_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipping_companies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_companies_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shipping_companies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipping_companies_id_seq OWNED BY public.shipping_companies.id;


--
-- Name: shipping_defaults; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shipping_defaults (
    id bigint NOT NULL,
    "Breakable" text,
    "Coin" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Safe" text,
    "Payment_Method" text,
    "Shipment_Class" text,
    "Opening_Package" text,
    "Shipment_Type" text,
    "Shipment_Category" text,
    "Delivery_To_Others" text,
    "Shipping_Costs_Included" text,
    "Insurance" text,
    "Draw" text,
    "Store" text
);


ALTER TABLE public.shipping_defaults OWNER TO demorabiherp_karim;

--
-- Name: shipping_defaults_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipping_defaults_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_defaults_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shipping_defaults_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipping_defaults_id_seq OWNED BY public.shipping_defaults.id;


--
-- Name: shipping_list_tickets; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shipping_list_tickets (
    id bigint NOT NULL,
    "Shipping_List" text,
    "Code" text,
    "Sender_Name" text,
    "Addressees_Name" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Payment_Method" text,
    "Notes" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Ticket" text
);


ALTER TABLE public.shipping_list_tickets OWNER TO demorabiherp_karim;

--
-- Name: shipping_list_tickets_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipping_list_tickets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_list_tickets_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shipping_list_tickets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipping_list_tickets_id_seq OWNED BY public.shipping_list_tickets.id;


--
-- Name: shipping_lists; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shipping_lists (
    id bigint NOT NULL,
    "Ticket_Store" text,
    "Driver" text,
    "Car_Store" text,
    "Travel_Area" text,
    "Access_Area" text,
    "Date_Travel" text,
    "Date_Arrival" text,
    "Car_Number" text,
    "Code" text,
    "Date" text,
    "Total_Cash" text,
    "Total_Later" text,
    "Total_Price" text,
    "Tickets_Numbers" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text
);


ALTER TABLE public.shipping_lists OWNER TO demorabiherp_karim;

--
-- Name: shipping_lists_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipping_lists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_lists_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shipping_lists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipping_lists_id_seq OWNED BY public.shipping_lists.id;


--
-- Name: shipping_orders; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shipping_orders (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Weight" text,
    "Number" text,
    "Goods_Price" text,
    "Shipping_Price" text,
    "Total" text,
    "Breakable" text,
    "Note" text,
    "Draw" text,
    "Coin" text,
    "Cost_Center" text,
    "Vend" text,
    "Cli" text,
    "Open" text,
    "Paid" text,
    "Ship_Sort" text,
    "Adderss" text,
    "Requests" text,
    "Sure" text,
    "Safe" text,
    "Residual" text,
    "Emp_Note" text,
    "Shipping_Delegate" text,
    "Cancel" text,
    "Cancel_Note" text,
    "Cancel_Pay" text,
    "Cancel_Not_Pay" text,
    "Vendor_Shipping" text,
    "Request_Done" text,
    "Status" bigint,
    "Type" bigint,
    "Delegate" bigint,
    "Vendor" bigint,
    "Client" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipping_orders OWNER TO demorabiherp_karim;

--
-- Name: shipping_orders_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipping_orders_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_orders_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: shipping_orders_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipping_orders_arr_seq OWNED BY public.shipping_orders.arr;


--
-- Name: shipping_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipping_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_orders_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shipping_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipping_orders_id_seq OWNED BY public.shipping_orders.id;


--
-- Name: shipping_prices; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shipping_prices (
    id bigint NOT NULL,
    "Place" text,
    "City" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "From" integer,
    "To" integer,
    "Price" numeric(8,2)
);


ALTER TABLE public.shipping_prices OWNER TO demorabiherp_karim;

--
-- Name: shipping_prices_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipping_prices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_prices_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shipping_prices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipping_prices_id_seq OWNED BY public.shipping_prices.id;


--
-- Name: shipping_statuses; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shipping_statuses (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Color" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipping_statuses OWNER TO demorabiherp_karim;

--
-- Name: shipping_statuses_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipping_statuses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_statuses_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shipping_statuses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipping_statuses_id_seq OWNED BY public.shipping_statuses.id;


--
-- Name: shipping_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shipping_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipping_types OWNER TO demorabiherp_karim;

--
-- Name: shipping_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shipping_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shipping_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shipping_types_id_seq OWNED BY public.shipping_types.id;


--
-- Name: shortcomings; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.shortcomings (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Payment_Method" text NOT NULL,
    "Status" text NOT NULL,
    "Vendor_Bill_Date" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Total_Discount" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Pay" text,
    "ToPurch" text,
    "Safe" bigint NOT NULL,
    "Vendor" bigint NOT NULL,
    "Delegate" bigint NOT NULL,
    "Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Purch_Date" text,
    "Purch_Reason" text,
    "ShipStatus" text,
    "P_Order_Num" text,
    "Ship" text,
    "Check_Type" text,
    "Due_Date" text,
    "Check_Number" text,
    "Later_Due" text,
    "Sent" text,
    "TaxBill" text,
    "TaxCode" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "File" text,
    "Current_Credit" text,
    "Residual" text,
    "Total_Net" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text
);


ALTER TABLE public.shortcomings OWNER TO demorabiherp_karim;

--
-- Name: shortcomings_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shortcomings_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shortcomings_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: shortcomings_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shortcomings_arr_seq OWNED BY public.shortcomings.arr;


--
-- Name: shortcomings_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.shortcomings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shortcomings_id_seq OWNER TO demorabiherp_karim;

--
-- Name: shortcomings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.shortcomings_id_seq OWNED BY public.shortcomings.id;


--
-- Name: show_print_defaults; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.show_print_defaults (
    id bigint NOT NULL,
    "CompanyName" text NOT NULL,
    "ProductName" text NOT NULL,
    "ProductPrice" text NOT NULL,
    "Coin" text NOT NULL,
    "Unit" text NOT NULL,
    "Group" text NOT NULL,
    "Code" text NOT NULL,
    "Logo" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.show_print_defaults OWNER TO demorabiherp_karim;

--
-- Name: show_print_defaults_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.show_print_defaults_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.show_print_defaults_id_seq OWNER TO demorabiherp_karim;

--
-- Name: show_print_defaults_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.show_print_defaults_id_seq OWNED BY public.show_print_defaults.id;


--
-- Name: social_media; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.social_media (
    id bigint NOT NULL,
    "Facebook" character varying(191),
    "Twitter" character varying(191),
    "Instagram" character varying(191),
    "Youtube" character varying(191),
    "Snapchat" character varying(191),
    "Whatsapp" character varying(191),
    "Google_Plus" character varying(191),
    "LinkedIn" character varying(191),
    "Pinterest" character varying(191),
    "Telegram" character varying(191),
    "iOS" character varying(191),
    "Android" character varying(191),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.social_media OWNER TO demorabiherp_karim;

--
-- Name: social_media_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.social_media_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.social_media_id_seq OWNER TO demorabiherp_karim;

--
-- Name: social_media_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.social_media_id_seq OWNED BY public.social_media.id;


--
-- Name: special_cases; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.special_cases (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Discount" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.special_cases OWNER TO demorabiherp_karim;

--
-- Name: special_cases_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.special_cases_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.special_cases_id_seq OWNER TO demorabiherp_karim;

--
-- Name: special_cases_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.special_cases_id_seq OWNED BY public.special_cases.id;


--
-- Name: spend_profits; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.spend_profits (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Amount" text NOT NULL,
    "Remaining_Profit" text NOT NULL,
    "Partner" bigint NOT NULL,
    "Safe" bigint NOT NULL,
    "Coin" bigint,
    "Cost_Center" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Payment_Method" text
);


ALTER TABLE public.spend_profits OWNER TO demorabiherp_karim;

--
-- Name: spend_profits_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.spend_profits_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.spend_profits_id_seq OWNER TO demorabiherp_karim;

--
-- Name: spend_profits_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.spend_profits_id_seq OWNED BY public.spend_profits.id;


--
-- Name: start_periods; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.start_periods (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Total_Products" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Store" bigint,
    "Coin" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Time" text,
    "Branch" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0
);


ALTER TABLE public.start_periods OWNER TO demorabiherp_karim;

--
-- Name: start_periods_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.start_periods_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.start_periods_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: start_periods_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.start_periods_arr_seq OWNED BY public.start_periods."Code";


--
-- Name: start_periods_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.start_periods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.start_periods_id_seq OWNER TO demorabiherp_karim;

--
-- Name: start_periods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.start_periods_id_seq OWNED BY public.start_periods.id;


--
-- Name: store_count_sales; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.store_count_sales (
    id bigint NOT NULL,
    "Store" text NOT NULL,
    "Total" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Tax" text
);


ALTER TABLE public.store_count_sales OWNER TO demorabiherp_karim;

--
-- Name: store_count_sales_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.store_count_sales_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.store_count_sales_id_seq OWNER TO demorabiherp_karim;

--
-- Name: store_count_sales_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.store_count_sales_id_seq OWNED BY public.store_count_sales.id;


--
-- Name: store_counts; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.store_counts (
    id bigint NOT NULL,
    "Store" text NOT NULL,
    "Total" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Tax" text
);


ALTER TABLE public.store_counts OWNER TO demorabiherp_karim;

--
-- Name: store_counts_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.store_counts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.store_counts_id_seq OWNER TO demorabiherp_karim;

--
-- Name: store_counts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.store_counts_id_seq OWNED BY public.store_counts.id;


--
-- Name: store_transfer_filter_twos; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.store_transfer_filter_twos (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Total" text,
    "TotalQty" text,
    "Note" text,
    "From_Store" text,
    "To_Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Status" text,
    "Ship" text,
    "CostShip" text,
    "RecivedShip" text,
    "OldQty" text,
    "Edit" text,
    "Delegate" text,
    "Time" text,
    "Type" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.store_transfer_filter_twos OWNER TO demorabiherp_karim;

--
-- Name: store_transfer_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.store_transfer_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.store_transfer_filter_twos_id_seq OWNER TO demorabiherp_karim;

--
-- Name: store_transfer_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.store_transfer_filter_twos_id_seq OWNED BY public.store_transfer_filter_twos.id;


--
-- Name: store_transfer_filters; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.store_transfer_filters (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Total" text,
    "TotalQty" text,
    "Note" text,
    "From_Store" text,
    "To_Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Status" text,
    "Ship" text,
    "CostShip" text,
    "RecivedShip" text,
    "OldQty" text,
    "Edit" text,
    "Delegate" text,
    "Time" text,
    "Type" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.store_transfer_filters OWNER TO demorabiherp_karim;

--
-- Name: store_transfer_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.store_transfer_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.store_transfer_filters_id_seq OWNER TO demorabiherp_karim;

--
-- Name: store_transfer_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.store_transfer_filters_id_seq OWNED BY public.store_transfer_filters.id;


--
-- Name: stores; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.stores (
    id bigint NOT NULL,
    "Date" text NOT NULL,
    "Time" text NOT NULL,
    "Name" text NOT NULL,
    "Phone" text,
    "Address" text,
    "Account" bigint NOT NULL,
    "User" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Code" text,
    "Branch" bigint,
    "Letter" text,
    "Account_Client" text,
    "NameEn" text
);


ALTER TABLE public.stores OWNER TO demorabiherp_karim;

--
-- Name: stores_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.stores_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: stores_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.stores_arr_seq OWNED BY public.stores."Code";


--
-- Name: stores_default_data; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.stores_default_data (
    id bigint NOT NULL,
    "Group" bigint,
    "Unit" bigint,
    "Tax" bigint,
    "Coin" bigint,
    "Account_Excess" bigint,
    "Account_Dificit" bigint,
    "Store" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text,
    "Style" text,
    "StoresTarnsferPrice" text,
    "Guide_Product_Cost" text,
    "Client_Store_Account" text,
    "Show_Ship" text,
    "StoresTarnsferHide" text,
    "CodeType" text,
    "ReturnStoresTransfer" text,
    "Cost_Price" text,
    "Hide_Product" text,
    "StartPeriod_Show_Product" text,
    "Fictitious_Quantities" text,
    "Qty_With_Add_Product" text
);


ALTER TABLE public.stores_default_data OWNER TO demorabiherp_karim;

--
-- Name: stores_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.stores_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_default_data_id_seq OWNER TO demorabiherp_karim;

--
-- Name: stores_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.stores_default_data_id_seq OWNED BY public.stores_default_data.id;


--
-- Name: stores_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.stores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_id_seq OWNER TO demorabiherp_karim;

--
-- Name: stores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.stores_id_seq OWNED BY public.stores.id;


--
-- Name: stores_moves; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.stores_moves (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Branch" text,
    "Type" text,
    "Note" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Ship" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Store" bigint,
    "Cost_Center" bigint,
    "User" bigint,
    "Coin" bigint,
    "Account" bigint,
    "Safe" bigint,
    "TypeEn" text,
    "Delete" text DEFAULT 0,
    "Edit" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0
);


ALTER TABLE public.stores_moves OWNER TO demorabiherp_karim;

--
-- Name: stores_moves_columns; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.stores_moves_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Branch" text,
    "Store" text,
    "Safe" text,
    "Type" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Note" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Account" text,
    "Ship" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.stores_moves_columns OWNER TO demorabiherp_karim;

--
-- Name: stores_moves_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.stores_moves_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_moves_columns_id_seq OWNER TO demorabiherp_karim;

--
-- Name: stores_moves_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.stores_moves_columns_id_seq OWNED BY public.stores_moves_columns.id;


--
-- Name: stores_moves_columns_sechdules; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.stores_moves_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Branch" text,
    "Store" text,
    "Safe" text,
    "Type" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Note" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Account" text,
    "Ship" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.stores_moves_columns_sechdules OWNER TO demorabiherp_karim;

--
-- Name: stores_moves_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.stores_moves_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_moves_columns_sechdules_id_seq OWNER TO demorabiherp_karim;

--
-- Name: stores_moves_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.stores_moves_columns_sechdules_id_seq OWNED BY public.stores_moves_columns_sechdules.id;


--
-- Name: stores_moves_filter_twos; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.stores_moves_filter_twos (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Branch" text,
    "Store" text,
    "Safe" text,
    "Type" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Note" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Account" text,
    "Ship" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.stores_moves_filter_twos OWNER TO demorabiherp_karim;

--
-- Name: stores_moves_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.stores_moves_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_moves_filter_twos_id_seq OWNER TO demorabiherp_karim;

--
-- Name: stores_moves_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.stores_moves_filter_twos_id_seq OWNED BY public.stores_moves_filter_twos.id;


--
-- Name: stores_moves_filters; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.stores_moves_filters (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Branch" text,
    "Store" text,
    "Safe" text,
    "Type" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Note" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Account" text,
    "Ship" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.stores_moves_filters OWNER TO demorabiherp_karim;

--
-- Name: stores_moves_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.stores_moves_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_moves_filters_id_seq OWNER TO demorabiherp_karim;

--
-- Name: stores_moves_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.stores_moves_filters_id_seq OWNED BY public.stores_moves_filters.id;


--
-- Name: stores_moves_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.stores_moves_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_moves_id_seq OWNER TO demorabiherp_karim;

--
-- Name: stores_moves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.stores_moves_id_seq OWNED BY public.stores_moves.id;


--
-- Name: stores_transfer_columns; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.stores_transfer_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Amount" text,
    "From_Store" text,
    "To_Store" text,
    "User" text,
    "Coin" text,
    "Shipping" text,
    "Note" text,
    "Delegate" text,
    "Product_Name" text,
    "Product_Code" text,
    "Group" text,
    "Brand" text,
    "Qty" text,
    "Price" text,
    "Trans_Qty" text,
    "Unit" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.stores_transfer_columns OWNER TO demorabiherp_karim;

--
-- Name: stores_transfer_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.stores_transfer_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_transfer_columns_id_seq OWNER TO demorabiherp_karim;

--
-- Name: stores_transfer_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.stores_transfer_columns_id_seq OWNED BY public.stores_transfer_columns.id;


--
-- Name: stores_transfer_columns_sechdules; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.stores_transfer_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Amount" text,
    "From_Store" text,
    "To_Store" text,
    "User" text,
    "Coin" text,
    "Shipping" text,
    "Note" text,
    "Delegate" text,
    "Product_Name" text,
    "Product_Code" text,
    "Group" text,
    "Brand" text,
    "Qty" text,
    "Price" text,
    "Trans_Qty" text,
    "Unit" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.stores_transfer_columns_sechdules OWNER TO demorabiherp_karim;

--
-- Name: stores_transfer_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.stores_transfer_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_transfer_columns_sechdules_id_seq OWNER TO demorabiherp_karim;

--
-- Name: stores_transfer_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.stores_transfer_columns_sechdules_id_seq OWNED BY public.stores_transfer_columns_sechdules.id;


--
-- Name: stors_transfers; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.stors_transfers (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Total" text NOT NULL,
    "Note" text,
    "From_Store" bigint NOT NULL,
    "To_Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "TotalQty" text,
    "Status" text DEFAULT 0,
    "CostShip" text,
    "RecivedShip" text,
    "OldQty" text,
    "Edit" text,
    "Time" text,
    "Branch" text,
    "Total_Cost" text,
    "TypeTransfer" text,
    "Cost_Store" text,
    "Delegate" bigint,
    "Ship" bigint,
    "File" text,
    "Edit_t" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0
);


ALTER TABLE public.stors_transfers OWNER TO demorabiherp_karim;

--
-- Name: stors_transfers_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.stors_transfers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stors_transfers_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: stors_transfers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.stors_transfers_arr_seq OWNED BY public.stors_transfers.arr;


--
-- Name: stors_transfers_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.stors_transfers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stors_transfers_id_seq OWNER TO demorabiherp_karim;

--
-- Name: stors_transfers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.stors_transfers_id_seq OWNED BY public.stors_transfers.id;


--
-- Name: student_groups; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.student_groups (
    id bigint NOT NULL,
    "Image" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.student_groups OWNER TO demorabiherp_karim;

--
-- Name: student_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.student_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_groups_id_seq OWNER TO demorabiherp_karim;

--
-- Name: student_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.student_groups_id_seq OWNED BY public.student_groups.id;


--
-- Name: student_importants; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.student_importants (
    id bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Student" text,
    "Course" text
);


ALTER TABLE public.student_importants OWNER TO demorabiherp_karim;

--
-- Name: student_importants_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.student_importants_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_importants_id_seq OWNER TO demorabiherp_karim;

--
-- Name: student_importants_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.student_importants_id_seq OWNED BY public.student_importants.id;


--
-- Name: students; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.students (
    id bigint NOT NULL,
    "Code" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Group" text,
    "Phone1" text,
    "Phone2" text,
    "Dad_Phone" text,
    "Mom_Phone" text,
    "Special_Case" text,
    "Case" text,
    "Email" text,
    "Whatsapp" text,
    "Age" text,
    "Gov" text,
    "City" text,
    "Place" text,
    "Nationality" text,
    "Address" text,
    "Profession" text,
    "Ntional_ID" text,
    "Account" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.students OWNER TO demorabiherp_karim;

--
-- Name: students_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.students_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.students_id_seq OWNER TO demorabiherp_karim;

--
-- Name: students_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.students_id_seq OWNED BY public.students.id;


--
-- Name: sub_images; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.sub_images (
    id bigint NOT NULL,
    "Image" text NOT NULL,
    "Product" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sub_images OWNER TO demorabiherp_karim;

--
-- Name: sub_images_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sub_images_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sub_images_id_seq OWNER TO demorabiherp_karim;

--
-- Name: sub_images_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sub_images_id_seq OWNED BY public.sub_images.id;


--
-- Name: sub_virables; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.sub_virables (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "V_ID" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.sub_virables OWNER TO demorabiherp_karim;

--
-- Name: sub_virables_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sub_virables_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sub_virables_id_seq OWNER TO demorabiherp_karim;

--
-- Name: sub_virables_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sub_virables_id_seq OWNED BY public.sub_virables.id;


--
-- Name: subscribe_types; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.subscribe_types (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.subscribe_types OWNER TO demorabiherp_karim;

--
-- Name: subscribe_types_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.subscribe_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.subscribe_types_id_seq OWNER TO demorabiherp_karim;

--
-- Name: subscribe_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.subscribe_types_id_seq OWNED BY public.subscribe_types.id;


--
-- Name: sup_pages_e_com_designs; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.sup_pages_e_com_designs (
    id bigint NOT NULL,
    "About_Title_Color" text,
    "About_Txt_Color" text,
    "Blogs_Title_Color" text,
    "Blogs_Txt_Color" text,
    "Blogs_Hover_Txt_Color" text,
    "Contact_Title_Color" text,
    "Contact_Txt_Color" text,
    "Contact_Form_Input_Border_Color" text,
    "Contact_Form_Input_Txt_Color" text,
    "Contact_Form_Button_BG_Color" text,
    "Contact_Form_Button_Txt_Color" text,
    "Contact_Form_Button_Hover_BG_Color" text,
    "Contact_Form_Button_Hover_Txt_Color" text,
    "Faq_Title_Color" text,
    "Faq_Q_BG_Color" text,
    "Faq_Q_Txt_Color" text,
    "Faq_A_Line_Color" text,
    "Faq_A_BG_Color" text,
    "Faq_A_Txt_Color" text,
    "MyAccount_Box_BG_Color" text,
    "MyAccount_Box_Button_BG_Color" text,
    "MyAccount_Box_Button_Txt_Color" text,
    "MyAccount_Box_Button_Hover_BG_Color" text,
    "MyAccount_Box_Button_Hover_Txt_Color" text,
    "MyAccount_Box_Input_Border_Color" text,
    "MyAccount_Box_Input_Txt_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sup_pages_e_com_designs OWNER TO demorabiherp_karim;

--
-- Name: sup_pages_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sup_pages_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sup_pages_e_com_designs_id_seq OWNER TO demorabiherp_karim;

--
-- Name: sup_pages_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sup_pages_e_com_designs_id_seq OWNED BY public.sup_pages_e_com_designs.id;


--
-- Name: sup_pages_part_two_e_com_designs; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.sup_pages_part_two_e_com_designs (
    id bigint NOT NULL,
    "Shop_Product_BG_Color" text,
    "Shop_Product_Group_BG_Color" text,
    "Shop_Product_Group_Txt_Color" text,
    "Shop_Product_Group_Hover_BG_Color" text,
    "Shop_Product_Group_Hover_Txt_Color" text,
    "Shop_Product_Icon_BG_Color" text,
    "Shop_Product_Icon_Txt_Color" text,
    "Shop_Product_Icon_Hover_BG_Color" text,
    "Shop_Product_Icon_Hover_Txt_Color" text,
    "Shop_Product_Txt_Color" text,
    "Shop_Product_Price_Color" text,
    "Shop_Product_Rate_Color" text,
    "Shop_Filter_Title_Color" text,
    "Shop_Filter_Txt_Color" text,
    "Shop_Filter_Search_BG_Color" text,
    "Shop_Filter_Search_Icon_BG_Color" text,
    "Shop_Filter_Search_Icon_Txt_Color" text,
    "Shop_Filter_Search_Icon_BG_Hover_Color" text,
    "Shop_Filter_Search_Icon_Txt_Hover_Color" text,
    "Cart_Button_BG_Color" text,
    "Cart_Button_Txt_Color" text,
    "Cart_Button_BG_Hover_Color" text,
    "Cart_Button_Txt_Hover_Color" text,
    "Cart_Box_BG_Color" text,
    "Cart_Box_Title_Color" text,
    "Cart_Box_Txt_Color" text,
    "Cart_Box_Button_BG_Color" text,
    "Cart_Box_Button_Txt_Color" text,
    "Cart_Box_Button_BG_Hover_Color" text,
    "Cart_Box_Button_Txt_Hover_Color" text,
    "Cart_Cupon_Button_BG_Color" text,
    "Cart_Cupon_Button_Txt_Color" text,
    "Cart_Cupon_Button_BG_Hover_Color" text,
    "Cart_Cupon_Button_Txt_Hover_Color" text,
    "Cart_Cupon_Input_BG_Color" text,
    "Checkout_Box_BG_Color" text,
    "Checkout_Box_Title_Color" text,
    "Checkout_Box_Txt_Color" text,
    "Checkout_Box_Button_BG_Color" text,
    "Checkout_Box_Button_Txt_Color" text,
    "Checkout_Box_Button_BG_Hover_Color" text,
    "Checkout_Box_Button_Txt_Hover_Color" text,
    "Checkout_Head_BG_Color" text,
    "Checkout_Head_Txt_Color" text,
    "Checkout_Input_BG_Color" text,
    "Checkout_Input_Txt_Color" text,
    "Reg_Login_Form_Box_BG_Color" text,
    "Reg_Login_Form_Box_Title_Color" text,
    "Reg_Login_Form_Box_Txt_Color" text,
    "Reg_Login_Form_Box_Txt_Hover_Color" text,
    "Reg_Login_Form_Box_Input_Border_Color" text,
    "Reg_Login_Form_Box_Button_BG_Color" text,
    "Reg_Login_Form_Box_Button_Txt_Color" text,
    "Reg_Login_Form_Box_Button_BG_Hover_Color" text,
    "Reg_Login_Form_Box_Button_Txt_Hover_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sup_pages_part_two_e_com_designs OWNER TO demorabiherp_karim;

--
-- Name: sup_pages_part_two_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sup_pages_part_two_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sup_pages_part_two_e_com_designs_id_seq OWNER TO demorabiherp_karim;

--
-- Name: sup_pages_part_two_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sup_pages_part_two_e_com_designs_id_seq OWNED BY public.sup_pages_part_two_e_com_designs.id;


--
-- Name: sup_pages_wish_comp_e_com_designs; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.sup_pages_wish_comp_e_com_designs (
    id bigint NOT NULL,
    "Wish_Title_BG_Color" text,
    "Wish_Title_Txt_Color" text,
    "Wish_Box_BG_Color" text,
    "Wish_Box_Border_Color" text,
    "Wish_Box_Border_Type" text,
    "Wish_Box_Txt_Color" text,
    "Wish_Box_Button_BG_Color" text,
    "Wish_Box_Button_Txt_Color" text,
    "Wish_Box_Button_BG_Hover_Color" text,
    "Wish_Box_Button_Txt_Hover_Color" text,
    "Compare_Box_BG_Color" text,
    "Compare_Box_Txt_Color" text,
    "Compare_Box_Price_Hover_Color" text,
    "Compare_Box_Delete_Txt_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sup_pages_wish_comp_e_com_designs OWNER TO demorabiherp_karim;

--
-- Name: sup_pages_wish_comp_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.sup_pages_wish_comp_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sup_pages_wish_comp_e_com_designs_id_seq OWNER TO demorabiherp_karim;

--
-- Name: sup_pages_wish_comp_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.sup_pages_wish_comp_e_com_designs_id_seq OWNED BY public.sup_pages_wish_comp_e_com_designs.id;


--
-- Name: taxes; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.taxes (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Name" text NOT NULL,
    "Rate" text NOT NULL,
    "Type" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Hide" character varying DEFAULT 0,
    "Account" bigint,
    arr bigint,
    "CodeTax" text,
    "SubType" text,
    "NameEn" text
);


ALTER TABLE public.taxes OWNER TO demorabiherp_karim;

--
-- Name: taxes_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.taxes_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.taxes_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: taxes_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.taxes_arr_seq OWNED BY public.taxes.arr;


--
-- Name: taxes_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.taxes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.taxes_id_seq OWNER TO demorabiherp_karim;

--
-- Name: taxes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.taxes_id_seq OWNED BY public.taxes.id;


--
-- Name: teachers; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.teachers (
    id bigint NOT NULL,
    "Code" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Image" text,
    "Work_Type" text,
    "Hour_Price" text,
    "Qualification" text,
    "Qualification_Attach" text,
    "National_ID" text,
    "National_ID_Attach" text,
    "CV" text,
    "Nationality" text,
    "Gov" text,
    "City" text,
    "Place" text,
    "Address" text,
    "Age" text,
    "Phone1" text,
    "Phone2" text,
    "Whatsapp" text,
    "Facebook" text,
    "Instagram" text,
    "Linked" text,
    "Telegram" text,
    "Arabic_Bio" text,
    "English_Bio" text,
    "Marital_Status" text,
    "Account" text,
    "Covenant" text,
    "Commission" text,
    "Merit" text,
    "Account_Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.teachers OWNER TO demorabiherp_karim;

--
-- Name: teachers_groups; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.teachers_groups (
    id bigint NOT NULL,
    "Teacher" text,
    "Group" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.teachers_groups OWNER TO demorabiherp_karim;

--
-- Name: teachers_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.teachers_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.teachers_groups_id_seq OWNER TO demorabiherp_karim;

--
-- Name: teachers_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.teachers_groups_id_seq OWNED BY public.teachers_groups.id;


--
-- Name: teachers_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.teachers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.teachers_id_seq OWNER TO demorabiherp_karim;

--
-- Name: teachers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.teachers_id_seq OWNED BY public.teachers.id;


--
-- Name: teachers_subjects; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.teachers_subjects (
    id bigint NOT NULL,
    "Teacher" text,
    "Subject" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.teachers_subjects OWNER TO demorabiherp_karim;

--
-- Name: teachers_subjects_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.teachers_subjects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.teachers_subjects_id_seq OWNER TO demorabiherp_karim;

--
-- Name: teachers_subjects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.teachers_subjects_id_seq OWNED BY public.teachers_subjects.id;


--
-- Name: tenants; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.tenants (
    id character varying(191) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    data json
);


ALTER TABLE public.tenants OWNER TO demorabiherp_karim;

--
-- Name: tenants_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.tenants_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tenants_id_seq OWNER TO demorabiherp_karim;

--
-- Name: tenants_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.tenants_id_seq OWNED BY public.tenants.id;


--
-- Name: terms; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.terms (
    id bigint NOT NULL,
    "Arabic_Desc" text NOT NULL,
    "English_Desc" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.terms OWNER TO demorabiherp_karim;

--
-- Name: terms_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.terms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.terms_id_seq OWNER TO demorabiherp_karim;

--
-- Name: terms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.terms_id_seq OWNED BY public.terms.id;


--
-- Name: terms_maintainces; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.terms_maintainces (
    id bigint NOT NULL,
    "Desc_Work" text NOT NULL,
    "Desc_Not_Work" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Desc_Work_En" text,
    "Desc_Not_Work_En" text
);


ALTER TABLE public.terms_maintainces OWNER TO demorabiherp_karim;

--
-- Name: terms_maintainces_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.terms_maintainces_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.terms_maintainces_id_seq OWNER TO demorabiherp_karim;

--
-- Name: terms_maintainces_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.terms_maintainces_id_seq OWNED BY public.terms_maintainces.id;


--
-- Name: testclients; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.testclients (
    id bigint NOT NULL,
    "Name" text,
    "Governrate" text,
    "City" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.testclients OWNER TO demorabiherp_karim;

--
-- Name: testclients_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.testclients_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.testclients_id_seq OWNER TO demorabiherp_karim;

--
-- Name: testclients_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.testclients_id_seq OWNED BY public.testclients.id;


--
-- Name: ticekt_issues; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.ticekt_issues (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.ticekt_issues OWNER TO demorabiherp_karim;

--
-- Name: ticekt_issues_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.ticekt_issues_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ticekt_issues_id_seq OWNER TO demorabiherp_karim;

--
-- Name: ticekt_issues_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.ticekt_issues_id_seq OWNED BY public.ticekt_issues.id;


--
-- Name: ticket_products; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.ticket_products (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Price" text,
    "Weight" text,
    "Length" text,
    "Width" text,
    "Height" text,
    "Qty" text,
    "Unit" text,
    "Total" text,
    "Store" text,
    "Product" text,
    "Ticket" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.ticket_products OWNER TO demorabiherp_karim;

--
-- Name: ticket_products_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.ticket_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ticket_products_id_seq OWNER TO demorabiherp_karim;

--
-- Name: ticket_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.ticket_products_id_seq OWNED BY public.ticket_products.id;


--
-- Name: tickets; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.tickets (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Payment_Method" text,
    "Sender_Name" text,
    "Sender_Address" text,
    "Sender_Phone" text,
    "Addressees_Name" text,
    "Addressees_Address" text,
    "Addressees_Phone" text,
    "Notes" text,
    "Sub_Total" text,
    "Discount" text,
    "Total" text,
    "Store" text,
    "Safe" text,
    "Recived" text,
    "Selected" text,
    "Coin" text,
    "Draw" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Access_Area" text,
    "TicketIssues" text
);


ALTER TABLE public.tickets OWNER TO demorabiherp_karim;

--
-- Name: tickets_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.tickets_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tickets_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: tickets_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.tickets_arr_seq OWNED BY public.tickets.arr;


--
-- Name: tickets_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.tickets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tickets_id_seq OWNER TO demorabiherp_karim;

--
-- Name: tickets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.tickets_id_seq OWNED BY public.tickets.id;


--
-- Name: translation_tourism_companies; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.translation_tourism_companies (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Precent" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.translation_tourism_companies OWNER TO demorabiherp_karim;

--
-- Name: translation_tourism_companies_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.translation_tourism_companies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.translation_tourism_companies_id_seq OWNER TO demorabiherp_karim;

--
-- Name: translation_tourism_companies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.translation_tourism_companies_id_seq OWNED BY public.translation_tourism_companies.id;


--
-- Name: translte_modules; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.translte_modules (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Lang" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.translte_modules OWNER TO demorabiherp_karim;

--
-- Name: translte_modules_details; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.translte_modules_details (
    id bigint NOT NULL,
    "Arabic_Text" text,
    "Translate_Text" text,
    "Module" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.translte_modules_details OWNER TO demorabiherp_karim;

--
-- Name: translte_modules_details_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.translte_modules_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.translte_modules_details_id_seq OWNER TO demorabiherp_karim;

--
-- Name: translte_modules_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.translte_modules_details_id_seq OWNED BY public.translte_modules_details.id;


--
-- Name: translte_modules_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.translte_modules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.translte_modules_id_seq OWNER TO demorabiherp_karim;

--
-- Name: translte_modules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.translte_modules_id_seq OWNED BY public.translte_modules.id;


--
-- Name: transltors; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.transltors (
    id bigint NOT NULL,
    "Original_Name" text NOT NULL,
    "New_Arabic_Name" text NOT NULL,
    "New_English_Name" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.transltors OWNER TO demorabiherp_karim;

--
-- Name: transltors_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.transltors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transltors_id_seq OWNER TO demorabiherp_karim;

--
-- Name: transltors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.transltors_id_seq OWNED BY public.transltors.id;


--
-- Name: unloading_shipments; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.unloading_shipments (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Time" text,
    "Safe" text,
    "Coin" text,
    "Draw" text,
    "FromStore" text,
    "ToStore" text,
    "Car" text,
    "Delegate" text,
    "Driver" text,
    "Total_Pieces" text,
    "Total_Weight" text,
    "Total_Cost" text,
    "Count_Shipmets" text,
    "Status" text,
    "User" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ShipmentsDistributionCode" text
);


ALTER TABLE public.unloading_shipments OWNER TO demorabiherp_karim;

--
-- Name: unloading_shipments_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.unloading_shipments_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.unloading_shipments_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: unloading_shipments_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.unloading_shipments_arr_seq OWNED BY public.unloading_shipments."Code";


--
-- Name: unloading_shipments_goods; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.unloading_shipments_goods (
    id bigint NOT NULL,
    "Shipment_ID" text,
    "Code" text,
    "Total_Weight" text,
    "Total_Cost" text,
    "Total_Pieces" text,
    "ShipmentsUnloading" bigint,
    "Status" text DEFAULT 0,
    "Dist_Goods_ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Barcode" text
);


ALTER TABLE public.unloading_shipments_goods OWNER TO demorabiherp_karim;

--
-- Name: unloading_shipments_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.unloading_shipments_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.unloading_shipments_goods_id_seq OWNER TO demorabiherp_karim;

--
-- Name: unloading_shipments_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.unloading_shipments_goods_id_seq OWNED BY public.unloading_shipments_goods.id;


--
-- Name: unloading_shipments_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.unloading_shipments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.unloading_shipments_id_seq OWNER TO demorabiherp_karim;

--
-- Name: unloading_shipments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.unloading_shipments_id_seq OWNED BY public.unloading_shipments.id;


--
-- Name: unloading_shipments_workers; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.unloading_shipments_workers (
    id bigint NOT NULL,
    "Worker" text,
    "ShipmentsUnloading" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.unloading_shipments_workers OWNER TO demorabiherp_karim;

--
-- Name: unloading_shipments_workers_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.unloading_shipments_workers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.unloading_shipments_workers_id_seq OWNER TO demorabiherp_karim;

--
-- Name: unloading_shipments_workers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.unloading_shipments_workers_id_seq OWNED BY public.unloading_shipments_workers.id;


--
-- Name: update_values_investors; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.update_values_investors (
    id bigint NOT NULL,
    "Date" text,
    "Valye" text,
    "Investor" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.update_values_investors OWNER TO demorabiherp_karim;

--
-- Name: update_values_investors_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.update_values_investors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.update_values_investors_id_seq OWNER TO demorabiherp_karim;

--
-- Name: update_values_investors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.update_values_investors_id_seq OWNED BY public.update_values_investors.id;


--
-- Name: upload_accountings; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.upload_accountings (
    id bigint NOT NULL,
    "Name" text,
    "Type" text,
    "Parent" text,
    "Note" text,
    "User" text,
    "Account_Code" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.upload_accountings OWNER TO demorabiherp_karim;

--
-- Name: upload_accountings_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.upload_accountings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.upload_accountings_id_seq OWNER TO demorabiherp_karim;

--
-- Name: upload_accountings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.upload_accountings_id_seq OWNED BY public.upload_accountings.id;


--
-- Name: users_moves; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.users_moves (
    id bigint NOT NULL,
    "User" bigint NOT NULL,
    "Date" text NOT NULL,
    "Time" text NOT NULL,
    "Screen" text NOT NULL,
    "Type" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Explain" text,
    "ScreenEn" text,
    "TypeEn" text,
    "ExplainEn" text
);


ALTER TABLE public.users_moves OWNER TO demorabiherp_karim;

--
-- Name: users_moves_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.users_moves_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.users_moves_id_seq OWNER TO demorabiherp_karim;

--
-- Name: users_moves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.users_moves_id_seq OWNED BY public.users_moves.id;


--
-- Name: v_a_prices; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.v_a_prices (
    id bigint NOT NULL,
    "Price" text,
    "MainV" bigint,
    "SubV" bigint,
    "Product" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Offer_Price" text,
    "Added" text,
    "VAProductID" text
);


ALTER TABLE public.v_a_prices OWNER TO demorabiherp_karim;

--
-- Name: v_a_prices_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.v_a_prices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.v_a_prices_id_seq OWNER TO demorabiherp_karim;

--
-- Name: v_a_prices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.v_a_prices_id_seq OWNED BY public.v_a_prices.id;


--
-- Name: v_a_products; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.v_a_products (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Unit" text,
    "Product" bigint,
    "ProductID" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.v_a_products OWNER TO demorabiherp_karim;

--
-- Name: v_a_products_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.v_a_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.v_a_products_id_seq OWNER TO demorabiherp_karim;

--
-- Name: v_a_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.v_a_products_id_seq OWNED BY public.v_a_products.id;


--
-- Name: v_a_qties; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.v_a_qties (
    id bigint NOT NULL,
    "Qty" text,
    "MainV" bigint,
    "SubV" bigint,
    "Product" bigint,
    "ProductID" bigint,
    "VAProductID" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.v_a_qties OWNER TO demorabiherp_karim;

--
-- Name: v_a_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.v_a_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.v_a_qties_id_seq OWNER TO demorabiherp_karim;

--
-- Name: v_a_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.v_a_qties_id_seq OWNED BY public.v_a_qties.id;


--
-- Name: vendor_account_statement_column_sechdules; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.vendor_account_statement_column_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Vendor" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ShiftCode" text,
    "Executor" text
);


ALTER TABLE public.vendor_account_statement_column_sechdules OWNER TO demorabiherp_karim;

--
-- Name: vendor_account_statement_column_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.vendor_account_statement_column_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendor_account_statement_column_sechdules_id_seq OWNER TO demorabiherp_karim;

--
-- Name: vendor_account_statement_column_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.vendor_account_statement_column_sechdules_id_seq OWNED BY public.vendor_account_statement_column_sechdules.id;


--
-- Name: vendor_account_statement_columns; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.vendor_account_statement_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Vendor" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ShiftCode" text,
    "Executor" text
);


ALTER TABLE public.vendor_account_statement_columns OWNER TO demorabiherp_karim;

--
-- Name: vendor_account_statement_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.vendor_account_statement_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendor_account_statement_columns_id_seq OWNER TO demorabiherp_karim;

--
-- Name: vendor_account_statement_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.vendor_account_statement_columns_id_seq OWNED BY public.vendor_account_statement_columns.id;


--
-- Name: vendor_filters; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.vendor_filters (
    id bigint NOT NULL,
    "Product" text NOT NULL,
    "Code" text,
    "Name" text,
    "VName" text,
    "VVName" text,
    "V1" text,
    "V2" text,
    "Qty" text,
    "Price" text,
    "Total" text,
    "Vendor" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.vendor_filters OWNER TO demorabiherp_karim;

--
-- Name: vendor_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.vendor_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendor_filters_id_seq OWNER TO demorabiherp_karim;

--
-- Name: vendor_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.vendor_filters_id_seq OWNED BY public.vendor_filters.id;


--
-- Name: vendor_products; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.vendor_products (
    id bigint NOT NULL,
    "Product_Name" text,
    "Product_Weight" text,
    "Product_Height" text,
    "Product_Length" text,
    "Product_Width" text,
    "Qty" text,
    "Price" text,
    "Vendor" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.vendor_products OWNER TO demorabiherp_karim;

--
-- Name: vendor_products_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.vendor_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendor_products_id_seq OWNER TO demorabiherp_karim;

--
-- Name: vendor_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.vendor_products_id_seq OWNED BY public.vendor_products.id;


--
-- Name: vendors; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.vendors (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Name" text NOT NULL,
    "Phone" text,
    "Phone2" text,
    "Commercial_Register" text,
    "Tax_Card" text,
    "Price_Level" text,
    "Account" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Tax_Registration_Number" text,
    "Tax_activity_code" text,
    work_nature text,
    "Buliding_Num" text,
    "Street" text,
    "Postal_Code" text,
    tax_magistrate text,
    "Floor" text,
    "Room" text,
    "Landmark" text,
    "Add_Info" text,
    "City" bigint,
    "Place" bigint,
    "Nationality" bigint,
    "Responsible" bigint,
    "Pro_Group" bigint,
    "Brand" bigint,
    "Governrate" bigint,
    "NameEn" text,
    "SearchCode" text,
    "Credit_Limit" text,
    "Monthly_Target" text DEFAULT 0,
    "Quarterly_Target" text DEFAULT 0,
    "Yearly_Target" text DEFAULT 0
);


ALTER TABLE public.vendors OWNER TO demorabiherp_karim;

--
-- Name: vendors_arr_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.vendors_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendors_arr_seq OWNER TO demorabiherp_karim;

--
-- Name: vendors_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.vendors_arr_seq OWNED BY public.vendors.arr;


--
-- Name: vendors_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.vendors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendors_id_seq OWNER TO demorabiherp_karim;

--
-- Name: vendors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.vendors_id_seq OWNED BY public.vendors.id;


--
-- Name: vendors_statements_column_sechdules; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.vendors_statements_column_sechdules (
    id bigint NOT NULL,
    "Account_Code" text,
    "Account_Name" text,
    "Debiator_Before" text,
    "Creditor_Before" text,
    "Total_Debitor" text,
    "Total_Creditor" text,
    "Debitor_Balance" text,
    "Creditor_Balance" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.vendors_statements_column_sechdules OWNER TO demorabiherp_karim;

--
-- Name: vendors_statements_column_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.vendors_statements_column_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendors_statements_column_sechdules_id_seq OWNER TO demorabiherp_karim;

--
-- Name: vendors_statements_column_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.vendors_statements_column_sechdules_id_seq OWNED BY public.vendors_statements_column_sechdules.id;


--
-- Name: vendors_statements_columns; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.vendors_statements_columns (
    id bigint NOT NULL,
    "Account_Code" text,
    "Account_Name" text,
    "Debiator_Before" text,
    "Creditor_Before" text,
    "Total_Debitor" text,
    "Total_Creditor" text,
    "Debitor_Balance" text,
    "Creditor_Balance" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.vendors_statements_columns OWNER TO demorabiherp_karim;

--
-- Name: vendors_statements_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.vendors_statements_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendors_statements_columns_id_seq OWNER TO demorabiherp_karim;

--
-- Name: vendors_statements_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.vendors_statements_columns_id_seq OWNED BY public.vendors_statements_columns.id;


--
-- Name: virables; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.virables (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.virables OWNER TO demorabiherp_karim;

--
-- Name: virables_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.virables_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.virables_id_seq OWNER TO demorabiherp_karim;

--
-- Name: virables_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.virables_id_seq OWNED BY public.virables.id;


--
-- Name: vouchers; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.vouchers (
    id bigint NOT NULL,
    "Draw" text,
    "Coin" text,
    "Safe" text,
    "Debitor" text,
    "Creditor" text,
    "Account" text,
    "Statement" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.vouchers OWNER TO demorabiherp_karim;

--
-- Name: vouchers_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.vouchers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vouchers_id_seq OWNER TO demorabiherp_karim;

--
-- Name: vouchers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.vouchers_id_seq OWNED BY public.vouchers.id;


--
-- Name: web_sliders; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.web_sliders (
    id bigint NOT NULL,
    "Status" character varying(191) NOT NULL,
    "Arabic_Title" text NOT NULL,
    "English_Title" text NOT NULL,
    "Arabic_Desc" text NOT NULL,
    "English_Desc" text NOT NULL,
    "Image" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text
);


ALTER TABLE public.web_sliders OWNER TO demorabiherp_karim;

--
-- Name: web_sliders_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.web_sliders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.web_sliders_id_seq OWNER TO demorabiherp_karim;

--
-- Name: web_sliders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.web_sliders_id_seq OWNED BY public.web_sliders.id;


--
-- Name: wishlists; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.wishlists (
    id bigint NOT NULL,
    "Product" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.wishlists OWNER TO demorabiherp_karim;

--
-- Name: wishlists_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.wishlists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.wishlists_id_seq OWNER TO demorabiherp_karim;

--
-- Name: wishlists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.wishlists_id_seq OWNED BY public.wishlists.id;


--
-- Name: work_departments; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.work_departments (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Parent" text,
    "Budget" text
);


ALTER TABLE public.work_departments OWNER TO demorabiherp_karim;

--
-- Name: work_departments_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.work_departments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.work_departments_id_seq OWNER TO demorabiherp_karim;

--
-- Name: work_departments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.work_departments_id_seq OWNED BY public.work_departments.id;


--
-- Name: workers_sales_petrols; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.workers_sales_petrols (
    id bigint NOT NULL,
    "Worker" bigint,
    "SalesPetrol" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.workers_sales_petrols OWNER TO demorabiherp_karim;

--
-- Name: workers_sales_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.workers_sales_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.workers_sales_petrols_id_seq OWNER TO demorabiherp_karim;

--
-- Name: workers_sales_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.workers_sales_petrols_id_seq OWNED BY public.workers_sales_petrols.id;


--
-- Name: zkteco_devices; Type: TABLE; Schema: public; Owner: demorabiherp_karim
--

CREATE TABLE public.zkteco_devices (
    id bigint NOT NULL,
    ip inet NOT NULL,
    port character varying(10) NOT NULL,
    model_name character varying(191) NOT NULL,
    status smallint DEFAULT '0'::smallint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.zkteco_devices OWNER TO demorabiherp_karim;

--
-- Name: zkteco_devices_id_seq; Type: SEQUENCE; Schema: public; Owner: demorabiherp_karim
--

CREATE SEQUENCE public.zkteco_devices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.zkteco_devices_id_seq OWNER TO demorabiherp_karim;

--
-- Name: zkteco_devices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: demorabiherp_karim
--

ALTER SEQUENCE public.zkteco_devices_id_seq OWNED BY public.zkteco_devices.id;


--
-- Name: a_v_pro_check_qties id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.a_v_pro_check_qties ALTER COLUMN id SET DEFAULT nextval('public.a_v_pro_check_qties_id_seq'::regclass);


--
-- Name: abouts id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.abouts ALTER COLUMN id SET DEFAULT nextval('public.abouts_id_seq'::regclass);


--
-- Name: abstracts_contractors id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.abstracts_contractors ALTER COLUMN id SET DEFAULT nextval('public.abstracts_contractors_id_seq'::regclass);


--
-- Name: acccounting_manuals id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.acccounting_manuals ALTER COLUMN id SET DEFAULT nextval('public.acccounting_manuals_id_seq'::regclass);


--
-- Name: accounts_default_data id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.accounts_default_data ALTER COLUMN id SET DEFAULT nextval('public.accounts_default_data_id_seq'::regclass);


--
-- Name: activites id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.activites ALTER COLUMN id SET DEFAULT nextval('public.activites_id_seq'::regclass);


--
-- Name: add_translates id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.add_translates ALTER COLUMN id SET DEFAULT nextval('public.add_translates_id_seq'::regclass);


--
-- Name: additional_products id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.additional_products ALTER COLUMN id SET DEFAULT nextval('public.additional_products_id_seq'::regclass);


--
-- Name: addressses id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.addressses ALTER COLUMN id SET DEFAULT nextval('public.addressses_id_seq'::regclass);


--
-- Name: admins id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.admins ALTER COLUMN id SET DEFAULT nextval('public.admins_id_seq'::regclass);


--
-- Name: all_groups id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.all_groups ALTER COLUMN id SET DEFAULT nextval('public.all_groups_id_seq'::regclass);


--
-- Name: allowences_emps id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.allowences_emps ALTER COLUMN id SET DEFAULT nextval('public.allowences_emps_id_seq'::regclass);


--
-- Name: apps_change_prices id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.apps_change_prices ALTER COLUMN id SET DEFAULT nextval('public.apps_change_prices_id_seq'::regclass);


--
-- Name: articles id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.articles ALTER COLUMN id SET DEFAULT nextval('public.articles_id_seq'::regclass);


--
-- Name: assembly_products id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.assembly_products ALTER COLUMN id SET DEFAULT nextval('public.assembly_products_id_seq'::regclass);


--
-- Name: assets id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.assets ALTER COLUMN id SET DEFAULT nextval('public.assets_id_seq'::regclass);


--
-- Name: assets Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.assets ALTER COLUMN "Code" SET DEFAULT nextval('public.assets_arr_seq'::regclass);


--
-- Name: assets_expenses id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.assets_expenses ALTER COLUMN id SET DEFAULT nextval('public.assets_expenses_id_seq'::regclass);


--
-- Name: attend_departure_import id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.attend_departure_import ALTER COLUMN id SET DEFAULT nextval('public.attend_departure_import_id_seq'::regclass);


--
-- Name: attendance_emps id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.attendance_emps ALTER COLUMN id SET DEFAULT nextval('public.attendance_emps_id_seq'::regclass);


--
-- Name: attendances id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.attendances ALTER COLUMN id SET DEFAULT nextval('public.attendances_id_seq'::regclass);


--
-- Name: attendances Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.attendances ALTER COLUMN "Code" SET DEFAULT nextval('public.attendances_arr_seq'::regclass);


--
-- Name: attendence_policy_emps id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.attendence_policy_emps ALTER COLUMN id SET DEFAULT nextval('public.attendence_policy_emps_id_seq'::regclass);


--
-- Name: barcode_products id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.barcode_products ALTER COLUMN id SET DEFAULT nextval('public.barcode_products_id_seq'::regclass);


--
-- Name: barcode_settings id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.barcode_settings ALTER COLUMN id SET DEFAULT nextval('public.barcode_settings_id_seq'::regclass);


--
-- Name: barcode_settings Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.barcode_settings ALTER COLUMN "Code" SET DEFAULT nextval('public.barcode_settings_arr_seq'::regclass);


--
-- Name: barcode_shows id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.barcode_shows ALTER COLUMN id SET DEFAULT nextval('public.barcode_shows_id_seq'::regclass);


--
-- Name: befroe_footers id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.befroe_footers ALTER COLUMN id SET DEFAULT nextval('public.befroe_footers_id_seq'::regclass);


--
-- Name: beneftis_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.beneftis_types ALTER COLUMN id SET DEFAULT nextval('public.beneftis_types_id_seq'::regclass);


--
-- Name: bones_sales_petrols id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.bones_sales_petrols ALTER COLUMN id SET DEFAULT nextval('public.bones_sales_petrols_id_seq'::regclass);


--
-- Name: bones_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.bones_types ALTER COLUMN id SET DEFAULT nextval('public.bones_types_id_seq'::regclass);


--
-- Name: borrowas id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.borrowas ALTER COLUMN id SET DEFAULT nextval('public.borrowas_id_seq'::regclass);


--
-- Name: borrowas Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.borrowas ALTER COLUMN "Code" SET DEFAULT nextval('public.borrowas_arr_seq'::regclass);


--
-- Name: branches id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.branches ALTER COLUMN id SET DEFAULT nextval('public.branches_id_seq'::regclass);


--
-- Name: brands id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.brands ALTER COLUMN id SET DEFAULT nextval('public.brands_id_seq'::regclass);


--
-- Name: campaigns id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.campaigns ALTER COLUMN id SET DEFAULT nextval('public.campaigns_id_seq'::regclass);


--
-- Name: capital_increases id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.capital_increases ALTER COLUMN id SET DEFAULT nextval('public.capital_increases_id_seq'::regclass);


--
-- Name: capitals id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.capitals ALTER COLUMN id SET DEFAULT nextval('public.capitals_id_seq'::regclass);


--
-- Name: car_shippings id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.car_shippings ALTER COLUMN id SET DEFAULT nextval('public.car_shippings_id_seq'::regclass);


--
-- Name: cars_sales_petrols id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.cars_sales_petrols ALTER COLUMN id SET DEFAULT nextval('public.cars_sales_petrols_id_seq'::regclass);


--
-- Name: cart_stores id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.cart_stores ALTER COLUMN id SET DEFAULT nextval('public.cart_stores_id_seq'::regclass);


--
-- Name: chat_issues id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.chat_issues ALTER COLUMN id SET DEFAULT nextval('public.chat_issues_id_seq'::regclass);


--
-- Name: checks_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.checks_types ALTER COLUMN id SET DEFAULT nextval('public.checks_types_id_seq'::regclass);


--
-- Name: cities id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.cities ALTER COLUMN id SET DEFAULT nextval('public.cities_id_seq'::regclass);


--
-- Name: client_account_statement_column_sechdules id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.client_account_statement_column_sechdules ALTER COLUMN id SET DEFAULT nextval('public.client_account_statement_column_sechdules_id_seq'::regclass);


--
-- Name: client_account_statement_columns id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.client_account_statement_columns ALTER COLUMN id SET DEFAULT nextval('public.client_account_statement_columns_id_seq'::regclass);


--
-- Name: client_filters id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.client_filters ALTER COLUMN id SET DEFAULT nextval('public.client_filters_id_seq'::regclass);


--
-- Name: client_sales_petrols id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.client_sales_petrols ALTER COLUMN id SET DEFAULT nextval('public.client_sales_petrols_id_seq'::regclass);


--
-- Name: client_statuses id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.client_statuses ALTER COLUMN id SET DEFAULT nextval('public.client_statuses_id_seq'::regclass);


--
-- Name: clients_statements_column_sechdules id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.clients_statements_column_sechdules ALTER COLUMN id SET DEFAULT nextval('public.clients_statements_column_sechdules_id_seq'::regclass);


--
-- Name: clients_statements_columns id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.clients_statements_columns ALTER COLUMN id SET DEFAULT nextval('public.clients_statements_columns_id_seq'::regclass);


--
-- Name: coins id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.coins ALTER COLUMN id SET DEFAULT nextval('public.coins_id_seq'::regclass);


--
-- Name: comments id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.comments ALTER COLUMN id SET DEFAULT nextval('public.comments_id_seq'::regclass);


--
-- Name: comments_clients id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.comments_clients ALTER COLUMN id SET DEFAULT nextval('public.comments_clients_id_seq'::regclass);


--
-- Name: company_cars id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.company_cars ALTER COLUMN id SET DEFAULT nextval('public.company_cars_id_seq'::regclass);


--
-- Name: company_data id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.company_data ALTER COLUMN id SET DEFAULT nextval('public.company_data_id_seq'::regclass);


--
-- Name: compare_prices_columns id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.compare_prices_columns ALTER COLUMN id SET DEFAULT nextval('public.compare_prices_columns_id_seq'::regclass);


--
-- Name: compare_prices_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.compare_prices_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.compare_prices_columns_sechdules_id_seq'::regclass);


--
-- Name: compare_prices_filter_twos id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.compare_prices_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.compare_prices_filter_twos_id_seq'::regclass);


--
-- Name: compare_prices_filters id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.compare_prices_filters ALTER COLUMN id SET DEFAULT nextval('public.compare_prices_filters_id_seq'::regclass);


--
-- Name: compares id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.compares ALTER COLUMN id SET DEFAULT nextval('public.compares_id_seq'::regclass);


--
-- Name: competitors id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.competitors ALTER COLUMN id SET DEFAULT nextval('public.competitors_id_seq'::regclass);


--
-- Name: consist_maintainces id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.consist_maintainces ALTER COLUMN id SET DEFAULT nextval('public.consist_maintainces_id_seq'::regclass);


--
-- Name: consists id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.consists ALTER COLUMN id SET DEFAULT nextval('public.consists_id_seq'::regclass);


--
-- Name: consists Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.consists ALTER COLUMN "Code" SET DEFAULT nextval('public.consists_arr_seq'::regclass);


--
-- Name: contact_u_s id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.contact_u_s ALTER COLUMN id SET DEFAULT nextval('public.contact_u_s_id_seq'::regclass);


--
-- Name: contract_statuses id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.contract_statuses ALTER COLUMN id SET DEFAULT nextval('public.contract_statuses_id_seq'::regclass);


--
-- Name: contractors_real_projects id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.contractors_real_projects ALTER COLUMN id SET DEFAULT nextval('public.contractors_real_projects_id_seq'::regclass);


--
-- Name: cost_centers id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.cost_centers ALTER COLUMN id SET DEFAULT nextval('public.cost_centers_id_seq'::regclass);


--
-- Name: counters_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.counters_types ALTER COLUMN id SET DEFAULT nextval('public.counters_types_id_seq'::regclass);


--
-- Name: countris id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.countris ALTER COLUMN id SET DEFAULT nextval('public.countris_id_seq'::regclass);


--
-- Name: coupon_codes id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.coupon_codes ALTER COLUMN id SET DEFAULT nextval('public.coupon_codes_id_seq'::regclass);


--
-- Name: courses id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.courses ALTER COLUMN id SET DEFAULT nextval('public.courses_id_seq'::regclass);


--
-- Name: courses_categories id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.courses_categories ALTER COLUMN id SET DEFAULT nextval('public.courses_categories_id_seq'::regclass);


--
-- Name: courses_halls id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.courses_halls ALTER COLUMN id SET DEFAULT nextval('public.courses_halls_id_seq'::regclass);


--
-- Name: courses_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.courses_types ALTER COLUMN id SET DEFAULT nextval('public.courses_types_id_seq'::regclass);


--
-- Name: crm_default_data id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.crm_default_data ALTER COLUMN id SET DEFAULT nextval('public.crm_default_data_id_seq'::regclass);


--
-- Name: custom_prints id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.custom_prints ALTER COLUMN id SET DEFAULT nextval('public.custom_prints_id_seq'::regclass);


--
-- Name: customer_comments_products id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.customer_comments_products ALTER COLUMN id SET DEFAULT nextval('public.customer_comments_products_id_seq'::regclass);


--
-- Name: customer_follow_ups id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.customer_follow_ups ALTER COLUMN id SET DEFAULT nextval('public.customer_follow_ups_id_seq'::regclass);


--
-- Name: customer_follow_ups Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.customer_follow_ups ALTER COLUMN "Code" SET DEFAULT nextval('public.customer_follow_ups_arr_seq'::regclass);


--
-- Name: customers id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.customers ALTER COLUMN id SET DEFAULT nextval('public.customers_id_seq'::regclass);


--
-- Name: customers Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.customers ALTER COLUMN "Code" SET DEFAULT nextval('public.customers_arr_seq'::regclass);


--
-- Name: customers_files id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.customers_files ALTER COLUMN id SET DEFAULT nextval('public.customers_files_id_seq'::regclass);


--
-- Name: customers_groups id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.customers_groups ALTER COLUMN id SET DEFAULT nextval('public.customers_groups_id_seq'::regclass);


--
-- Name: customers_rate_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.customers_rate_types ALTER COLUMN id SET DEFAULT nextval('public.customers_rate_types_id_seq'::regclass);


--
-- Name: customers_tickets id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.customers_tickets ALTER COLUMN id SET DEFAULT nextval('public.customers_tickets_id_seq'::regclass);


--
-- Name: customers_tickets Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.customers_tickets ALTER COLUMN "Code" SET DEFAULT nextval('public.customers_tickets_arr_seq'::regclass);


--
-- Name: deducations_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.deducations_types ALTER COLUMN id SET DEFAULT nextval('public.deducations_types_id_seq'::regclass);


--
-- Name: deductions id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.deductions ALTER COLUMN id SET DEFAULT nextval('public.deductions_id_seq'::regclass);


--
-- Name: deductions Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.deductions ALTER COLUMN "Code" SET DEFAULT nextval('public.deductions_arr_seq'::regclass);


--
-- Name: default_data_show_hides id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.default_data_show_hides ALTER COLUMN id SET DEFAULT nextval('public.default_data_show_hides_id_seq'::regclass);


--
-- Name: delivery_apps id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.delivery_apps ALTER COLUMN id SET DEFAULT nextval('public.delivery_apps_id_seq'::regclass);


--
-- Name: depaarture_policy_emps id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.depaarture_policy_emps ALTER COLUMN id SET DEFAULT nextval('public.depaarture_policy_emps_id_seq'::regclass);


--
-- Name: departure_emps id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.departure_emps ALTER COLUMN id SET DEFAULT nextval('public.departure_emps_id_seq'::regclass);


--
-- Name: departures id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.departures ALTER COLUMN id SET DEFAULT nextval('public.departures_id_seq'::regclass);


--
-- Name: departures Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.departures ALTER COLUMN "Code" SET DEFAULT nextval('public.departures_arr_seq'::regclass);


--
-- Name: desvice_cases id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.desvice_cases ALTER COLUMN id SET DEFAULT nextval('public.desvice_cases_id_seq'::regclass);


--
-- Name: device_descrips id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.device_descrips ALTER COLUMN id SET DEFAULT nextval('public.device_descrips_id_seq'::regclass);


--
-- Name: devices_typesies id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.devices_typesies ALTER COLUMN id SET DEFAULT nextval('public.devices_typesies_id_seq'::regclass);


--
-- Name: disclaimers id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.disclaimers ALTER COLUMN id SET DEFAULT nextval('public.disclaimers_id_seq'::regclass);


--
-- Name: discounts_emps id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.discounts_emps ALTER COLUMN id SET DEFAULT nextval('public.discounts_emps_id_seq'::regclass);


--
-- Name: domains id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.domains ALTER COLUMN id SET DEFAULT nextval('public.domains_id_seq'::regclass);


--
-- Name: emp_covenants id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.emp_covenants ALTER COLUMN id SET DEFAULT nextval('public.emp_covenants_id_seq'::regclass);


--
-- Name: emp_excs id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.emp_excs ALTER COLUMN id SET DEFAULT nextval('public.emp_excs_id_seq'::regclass);


--
-- Name: emp_installment_details id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.emp_installment_details ALTER COLUMN id SET DEFAULT nextval('public.emp_installment_details_id_seq'::regclass);


--
-- Name: emp_installments id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.emp_installments ALTER COLUMN id SET DEFAULT nextval('public.emp_installments_id_seq'::regclass);


--
-- Name: emp_mails id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.emp_mails ALTER COLUMN id SET DEFAULT nextval('public.emp_mails_id_seq'::regclass);


--
-- Name: emp_movements id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.emp_movements ALTER COLUMN id SET DEFAULT nextval('public.emp_movements_id_seq'::regclass);


--
-- Name: emp_p_o_s_stores id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.emp_p_o_s_stores ALTER COLUMN id SET DEFAULT nextval('public.emp_p_o_s_stores_id_seq'::regclass);


--
-- Name: emp_ratios id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.emp_ratios ALTER COLUMN id SET DEFAULT nextval('public.emp_ratios_id_seq'::regclass);


--
-- Name: emp_safes id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.emp_safes ALTER COLUMN id SET DEFAULT nextval('public.emp_safes_id_seq'::regclass);


--
-- Name: empassies id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.empassies ALTER COLUMN id SET DEFAULT nextval('public.empassies_id_seq'::regclass);


--
-- Name: empassy_reserve_dates id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.empassy_reserve_dates ALTER COLUMN id SET DEFAULT nextval('public.empassy_reserve_dates_id_seq'::regclass);


--
-- Name: employesses id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.employesses ALTER COLUMN id SET DEFAULT nextval('public.employesses_id_seq'::regclass);


--
-- Name: employesses Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.employesses ALTER COLUMN "Code" SET DEFAULT nextval('public.employesses_arr_seq'::regclass);


--
-- Name: employment_levels id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.employment_levels ALTER COLUMN id SET DEFAULT nextval('public.employment_levels_id_seq'::regclass);


--
-- Name: emps_producation_points id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.emps_producation_points ALTER COLUMN id SET DEFAULT nextval('public.emps_producation_points_id_seq'::regclass);


--
-- Name: emps_producation_quantities id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.emps_producation_quantities ALTER COLUMN id SET DEFAULT nextval('public.emps_producation_quantities_id_seq'::regclass);


--
-- Name: entitlements id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.entitlements ALTER COLUMN id SET DEFAULT nextval('public.entitlements_id_seq'::regclass);


--
-- Name: entitlements Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.entitlements ALTER COLUMN "Code" SET DEFAULT nextval('public.entitlements_arr_seq'::regclass);


--
-- Name: events id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.events ALTER COLUMN id SET DEFAULT nextval('public.events_id_seq'::regclass);


--
-- Name: examinations_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.examinations_types ALTER COLUMN id SET DEFAULT nextval('public.examinations_types_id_seq'::regclass);


--
-- Name: exchange_commissions id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.exchange_commissions ALTER COLUMN id SET DEFAULT nextval('public.exchange_commissions_id_seq'::regclass);


--
-- Name: exchange_commissions Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.exchange_commissions ALTER COLUMN "Code" SET DEFAULT nextval('public.exchange_commissions_arr_seq'::regclass);


--
-- Name: execute_job_order_models id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.execute_job_order_models ALTER COLUMN id SET DEFAULT nextval('public.execute_job_order_models_id_seq'::regclass);


--
-- Name: execute_job_order_workmanships id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.execute_job_order_workmanships ALTER COLUMN id SET DEFAULT nextval('public.execute_job_order_workmanships_id_seq'::regclass);


--
-- Name: execute_job_orders id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.execute_job_orders ALTER COLUMN id SET DEFAULT nextval('public.execute_job_orders_id_seq'::regclass);


--
-- Name: execute_job_orders Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.execute_job_orders ALTER COLUMN "Code" SET DEFAULT nextval('public.execute_job_orders_arr_seq'::regclass);


--
-- Name: executing_receiving_secretariats id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.executing_receiving_secretariats ALTER COLUMN id SET DEFAULT nextval('public.executing_receiving_secretariats_id_seq'::regclass);


--
-- Name: executing_receiving_secretariats Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.executing_receiving_secretariats ALTER COLUMN "Code" SET DEFAULT nextval('public.executing_receiving_secretariats_arr_seq'::regclass);


--
-- Name: executing_receivings id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.executing_receivings ALTER COLUMN id SET DEFAULT nextval('public.executing_receivings_id_seq'::regclass);


--
-- Name: executing_receivings Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.executing_receivings ALTER COLUMN "Code" SET DEFAULT nextval('public.executing_receivings_arr_seq'::regclass);


--
-- Name: executor_filters id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.executor_filters ALTER COLUMN id SET DEFAULT nextval('public.executor_filters_id_seq'::regclass);


--
-- Name: expenses_list_column_sechdules id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.expenses_list_column_sechdules ALTER COLUMN id SET DEFAULT nextval('public.expenses_list_column_sechdules_id_seq'::regclass);


--
-- Name: expenses_list_columns id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.expenses_list_columns ALTER COLUMN id SET DEFAULT nextval('public.expenses_list_columns_id_seq'::regclass);


--
-- Name: expenses_type_projects id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.expenses_type_projects ALTER COLUMN id SET DEFAULT nextval('public.expenses_type_projects_id_seq'::regclass);


--
-- Name: expire_date_qties id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.expire_date_qties ALTER COLUMN id SET DEFAULT nextval('public.expire_date_qties_id_seq'::regclass);


--
-- Name: export_checks id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.export_checks ALTER COLUMN id SET DEFAULT nextval('public.export_checks_id_seq'::regclass);


--
-- Name: export_checks Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.export_checks ALTER COLUMN "Code" SET DEFAULT nextval('public.export_checks_arr_seq'::regclass);


--
-- Name: f_a_q_s id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.f_a_q_s ALTER COLUMN id SET DEFAULT nextval('public.f_a_q_s_id_seq'::regclass);


--
-- Name: failed_jobs id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.failed_jobs ALTER COLUMN id SET DEFAULT nextval('public.failed_jobs_id_seq'::regclass);


--
-- Name: faults_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.faults_types ALTER COLUMN id SET DEFAULT nextval('public.faults_types_id_seq'::regclass);


--
-- Name: fifo_qties id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.fifo_qties ALTER COLUMN id SET DEFAULT nextval('public.fifo_qties_id_seq'::regclass);


--
-- Name: follow_lists id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.follow_lists ALTER COLUMN id SET DEFAULT nextval('public.follow_lists_id_seq'::regclass);


--
-- Name: general_dailies id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.general_dailies ALTER COLUMN id SET DEFAULT nextval('public.general_dailies_id_seq'::regclass);


--
-- Name: general_dailies Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.general_dailies ALTER COLUMN "Code" SET DEFAULT nextval('public.general_dailies_arr_seq'::regclass);


--
-- Name: goods_product_projects id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.goods_product_projects ALTER COLUMN id SET DEFAULT nextval('public.goods_product_projects_id_seq'::regclass);


--
-- Name: goods_projects id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.goods_projects ALTER COLUMN id SET DEFAULT nextval('public.goods_projects_id_seq'::regclass);


--
-- Name: governrates id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.governrates ALTER COLUMN id SET DEFAULT nextval('public.governrates_id_seq'::regclass);


--
-- Name: group_filters id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.group_filters ALTER COLUMN id SET DEFAULT nextval('public.group_filters_id_seq'::regclass);


--
-- Name: holidays id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.holidays ALTER COLUMN id SET DEFAULT nextval('public.holidays_id_seq'::regclass);


--
-- Name: holidays Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.holidays ALTER COLUMN "Code" SET DEFAULT nextval('public.holidays_arr_seq'::regclass);


--
-- Name: holidays_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.holidays_types ALTER COLUMN id SET DEFAULT nextval('public.holidays_types_id_seq'::regclass);


--
-- Name: home_e_com_designs id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.home_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.home_e_com_designs_id_seq'::regclass);


--
-- Name: home_product_e_com_designs id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.home_product_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.home_product_e_com_designs_id_seq'::regclass);


--
-- Name: import_new_prods id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.import_new_prods ALTER COLUMN id SET DEFAULT nextval('public.import_new_prods_id_seq'::regclass);


--
-- Name: import_new_prods_starts id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.import_new_prods_starts ALTER COLUMN id SET DEFAULT nextval('public.import_new_prods_starts_id_seq'::regclass);


--
-- Name: in_out_logs id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.in_out_logs ALTER COLUMN id SET DEFAULT nextval('public.in_out_logs_id_seq'::regclass);


--
-- Name: incom_checks id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.incom_checks ALTER COLUMN id SET DEFAULT nextval('public.incom_checks_id_seq'::regclass);


--
-- Name: incom_checks Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.incom_checks ALTER COLUMN "Code" SET DEFAULT nextval('public.incom_checks_arr_seq'::regclass);


--
-- Name: incom_manufacturing_models id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.incom_manufacturing_models ALTER COLUMN id SET DEFAULT nextval('public.incom_manufacturing_models_id_seq'::regclass);


--
-- Name: incom_manufacturing_secretariat_models id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.incom_manufacturing_secretariat_models ALTER COLUMN id SET DEFAULT nextval('public.incom_manufacturing_secretariat_models_id_seq'::regclass);


--
-- Name: install_companies_sales_bills_columns id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.install_companies_sales_bills_columns ALTER COLUMN id SET DEFAULT nextval('public.install_companies_sales_bills_columns_id_seq'::regclass);


--
-- Name: install_companies_sales_bills_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.install_companies_sales_bills_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.install_companies_sales_bills_columns_sechdules_id_seq'::regclass);


--
-- Name: installment_companies id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.installment_companies ALTER COLUMN id SET DEFAULT nextval('public.installment_companies_id_seq'::regclass);


--
-- Name: installment_companies_ratios id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.installment_companies_ratios ALTER COLUMN id SET DEFAULT nextval('public.installment_companies_ratios_id_seq'::regclass);


--
-- Name: installment_dates id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.installment_dates ALTER COLUMN id SET DEFAULT nextval('public.installment_dates_id_seq'::regclass);


--
-- Name: installments id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.installments ALTER COLUMN id SET DEFAULT nextval('public.installments_id_seq'::regclass);


--
-- Name: insurance_companies id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.insurance_companies ALTER COLUMN id SET DEFAULT nextval('public.insurance_companies_id_seq'::regclass);


--
-- Name: insurance_papers id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.insurance_papers ALTER COLUMN id SET DEFAULT nextval('public.insurance_papers_id_seq'::regclass);


--
-- Name: insurance_papers Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.insurance_papers ALTER COLUMN "Code" SET DEFAULT nextval('public.insurance_papers_arr_seq'::regclass);


--
-- Name: interviews id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.interviews ALTER COLUMN id SET DEFAULT nextval('public.interviews_id_seq'::regclass);


--
-- Name: interviews Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.interviews ALTER COLUMN "Code" SET DEFAULT nextval('public.interviews_arr_seq'::regclass);


--
-- Name: interviews_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.interviews_types ALTER COLUMN id SET DEFAULT nextval('public.interviews_types_id_seq'::regclass);


--
-- Name: intros id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.intros ALTER COLUMN id SET DEFAULT nextval('public.intros_id_seq'::regclass);


--
-- Name: inventories id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.inventories ALTER COLUMN id SET DEFAULT nextval('public.inventories_id_seq'::regclass);


--
-- Name: inventories Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.inventories ALTER COLUMN "Code" SET DEFAULT nextval('public.inventories_arr_seq'::regclass);


--
-- Name: investors id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.investors ALTER COLUMN id SET DEFAULT nextval('public.investors_id_seq'::regclass);


--
-- Name: issues id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.issues ALTER COLUMN id SET DEFAULT nextval('public.issues_id_seq'::regclass);


--
-- Name: items_groups id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.items_groups ALTER COLUMN id SET DEFAULT nextval('public.items_groups_id_seq'::regclass);


--
-- Name: itineraries id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.itineraries ALTER COLUMN id SET DEFAULT nextval('public.itineraries_id_seq'::regclass);


--
-- Name: itinerary_visits id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.itinerary_visits ALTER COLUMN id SET DEFAULT nextval('public.itinerary_visits_id_seq'::regclass);


--
-- Name: job_orders id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.job_orders ALTER COLUMN id SET DEFAULT nextval('public.job_orders_id_seq'::regclass);


--
-- Name: job_orders Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.job_orders ALTER COLUMN "Code" SET DEFAULT nextval('public.job_orders_arr_seq'::regclass);


--
-- Name: job_orders_executors id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.job_orders_executors ALTER COLUMN id SET DEFAULT nextval('public.job_orders_executors_id_seq'::regclass);


--
-- Name: jobs_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.jobs_types ALTER COLUMN id SET DEFAULT nextval('public.jobs_types_id_seq'::regclass);


--
-- Name: journalizing_details id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.journalizing_details ALTER COLUMN id SET DEFAULT nextval('public.journalizing_details_id_seq'::regclass);


--
-- Name: journalizings id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.journalizings ALTER COLUMN id SET DEFAULT nextval('public.journalizings_id_seq'::regclass);


--
-- Name: journalizings Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.journalizings ALTER COLUMN "Code" SET DEFAULT nextval('public.journalizings_arr_seq'::regclass);


--
-- Name: languages id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.languages ALTER COLUMN id SET DEFAULT nextval('public.languages_id_seq'::regclass);


--
-- Name: loan_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.loan_types ALTER COLUMN id SET DEFAULT nextval('public.loan_types_id_seq'::regclass);


--
-- Name: loans id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.loans ALTER COLUMN id SET DEFAULT nextval('public.loans_id_seq'::regclass);


--
-- Name: loans Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.loans ALTER COLUMN "Code" SET DEFAULT nextval('public.loans_arr_seq'::regclass);


--
-- Name: login_sliders id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.login_sliders ALTER COLUMN id SET DEFAULT nextval('public.login_sliders_id_seq'::regclass);


--
-- Name: main_e_com_designs id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.main_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.main_e_com_designs_id_seq'::regclass);


--
-- Name: maintainc_bills id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.maintainc_bills ALTER COLUMN id SET DEFAULT nextval('public.maintainc_bills_id_seq'::regclass);


--
-- Name: maintainc_bills Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.maintainc_bills ALTER COLUMN "Code" SET DEFAULT nextval('public.maintainc_bills_arr_seq'::regclass);


--
-- Name: maintaince_colors id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.maintaince_colors ALTER COLUMN id SET DEFAULT nextval('public.maintaince_colors_id_seq'::regclass);


--
-- Name: maintaince_default_data id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.maintaince_default_data ALTER COLUMN id SET DEFAULT nextval('public.maintaince_default_data_id_seq'::regclass);


--
-- Name: manu_store_counts id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.manu_store_counts ALTER COLUMN id SET DEFAULT nextval('public.manu_store_counts_id_seq'::regclass);


--
-- Name: manufacture_companies id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.manufacture_companies ALTER COLUMN id SET DEFAULT nextval('public.manufacture_companies_id_seq'::regclass);


--
-- Name: manufacturing_default_data id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.manufacturing_default_data ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_default_data_id_seq'::regclass);


--
-- Name: manufacturing_executions id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.manufacturing_executions ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_executions_id_seq'::regclass);


--
-- Name: manufacturing_executions Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.manufacturing_executions ALTER COLUMN "Code" SET DEFAULT nextval('public.manufacturing_executions_arr_seq'::regclass);


--
-- Name: manufacturing_halls id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.manufacturing_halls ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_halls_id_seq'::regclass);


--
-- Name: manufacturing_models id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.manufacturing_models ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_models_id_seq'::regclass);


--
-- Name: manufacturing_models Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.manufacturing_models ALTER COLUMN "Code" SET DEFAULT nextval('public.manufacturing_models_arr_seq'::regclass);


--
-- Name: manufacturing_orders id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.manufacturing_orders ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_orders_id_seq'::regclass);


--
-- Name: manufacturing_orders Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.manufacturing_orders ALTER COLUMN "Code" SET DEFAULT nextval('public.manufacturing_orders_arr_seq'::regclass);


--
-- Name: manufacturing_requests id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.manufacturing_requests ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_requests_id_seq'::regclass);


--
-- Name: manufacturing_requests Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.manufacturing_requests ALTER COLUMN "Code" SET DEFAULT nextval('public.manufacturing_requests_arr_seq'::regclass);


--
-- Name: manufacturing_secretariat_models id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.manufacturing_secretariat_models ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_secretariat_models_id_seq'::regclass);


--
-- Name: manufacturing_secretariat_models Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.manufacturing_secretariat_models ALTER COLUMN "Code" SET DEFAULT nextval('public.manufacturing_secretariat_models_arr_seq'::regclass);


--
-- Name: measuerments id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.measuerments ALTER COLUMN id SET DEFAULT nextval('public.measuerments_id_seq'::regclass);


--
-- Name: missions id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.missions ALTER COLUMN id SET DEFAULT nextval('public.missions_id_seq'::regclass);


--
-- Name: module_settings_nums id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.module_settings_nums ALTER COLUMN id SET DEFAULT nextval('public.module_settings_nums_id_seq'::regclass);


--
-- Name: modules id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.modules ALTER COLUMN id SET DEFAULT nextval('public.modules_id_seq'::regclass);


--
-- Name: more_products_halls id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.more_products_halls ALTER COLUMN id SET DEFAULT nextval('public.more_products_halls_id_seq'::regclass);


--
-- Name: most_sales_products_column_sechdules id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.most_sales_products_column_sechdules ALTER COLUMN id SET DEFAULT nextval('public.most_sales_products_column_sechdules_id_seq'::regclass);


--
-- Name: most_sales_products_columns id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.most_sales_products_columns ALTER COLUMN id SET DEFAULT nextval('public.most_sales_products_columns_id_seq'::regclass);


--
-- Name: msg_rqsts id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.msg_rqsts ALTER COLUMN id SET DEFAULT nextval('public.msg_rqsts_id_seq'::regclass);


--
-- Name: my_follow_lists id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.my_follow_lists ALTER COLUMN id SET DEFAULT nextval('public.my_follow_lists_id_seq'::regclass);


--
-- Name: new_shipping_categories id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.new_shipping_categories ALTER COLUMN id SET DEFAULT nextval('public.new_shipping_categories_id_seq'::regclass);


--
-- Name: new_shipping_rqst_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.new_shipping_rqst_types ALTER COLUMN id SET DEFAULT nextval('public.new_shipping_rqst_types_id_seq'::regclass);


--
-- Name: new_shipping_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.new_shipping_types ALTER COLUMN id SET DEFAULT nextval('public.new_shipping_types_id_seq'::regclass);


--
-- Name: notifications id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.notifications ALTER COLUMN id SET DEFAULT nextval('public.notifications_id_seq'::regclass);


--
-- Name: opening_entries id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.opening_entries ALTER COLUMN id SET DEFAULT nextval('public.opening_entries_id_seq'::regclass);


--
-- Name: opening_entries Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.opening_entries ALTER COLUMN "Code" SET DEFAULT nextval('public.opening_entries_arr_seq'::regclass);


--
-- Name: opening_entries_details id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.opening_entries_details ALTER COLUMN id SET DEFAULT nextval('public.opening_entries_details_id_seq'::regclass);


--
-- Name: order_pays id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.order_pays ALTER COLUMN id SET DEFAULT nextval('public.order_pays_id_seq'::regclass);


--
-- Name: outcom_manufacturing_models id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.outcom_manufacturing_models ALTER COLUMN id SET DEFAULT nextval('public.outcom_manufacturing_models_id_seq'::regclass);


--
-- Name: outcome_manufacturing_secretariat_models id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.outcome_manufacturing_secretariat_models ALTER COLUMN id SET DEFAULT nextval('public.outcome_manufacturing_secretariat_models_id_seq'::regclass);


--
-- Name: over_times id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.over_times ALTER COLUMN id SET DEFAULT nextval('public.over_times_id_seq'::regclass);


--
-- Name: pack_prems id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.pack_prems ALTER COLUMN id SET DEFAULT nextval('public.pack_prems_id_seq'::regclass);


--
-- Name: packages id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.packages ALTER COLUMN id SET DEFAULT nextval('public.packages_id_seq'::regclass);


--
-- Name: partners id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.partners ALTER COLUMN id SET DEFAULT nextval('public.partners_id_seq'::regclass);


--
-- Name: pay_profit_investors id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.pay_profit_investors ALTER COLUMN id SET DEFAULT nextval('public.pay_profit_investors_id_seq'::regclass);


--
-- Name: pay_salaries id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.pay_salaries ALTER COLUMN id SET DEFAULT nextval('public.pay_salaries_id_seq'::regclass);


--
-- Name: pay_salaries Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.pay_salaries ALTER COLUMN "Code" SET DEFAULT nextval('public.pay_salaries_arr_seq'::regclass);


--
-- Name: payment_voucher_details id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.payment_voucher_details ALTER COLUMN id SET DEFAULT nextval('public.payment_voucher_details_id_seq'::regclass);


--
-- Name: payment_vouchers id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.payment_vouchers ALTER COLUMN id SET DEFAULT nextval('public.payment_vouchers_id_seq'::regclass);


--
-- Name: payment_vouchers Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.payment_vouchers ALTER COLUMN "Code" SET DEFAULT nextval('public.payment_vouchers_arr_seq'::regclass);


--
-- Name: paymentss_products_real_projects id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.paymentss_products_real_projects ALTER COLUMN id SET DEFAULT nextval('public.paymentss_products_real_projects_id_seq'::regclass);


--
-- Name: paymentss_real_projects id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.paymentss_real_projects ALTER COLUMN id SET DEFAULT nextval('public.paymentss_real_projects_id_seq'::regclass);


--
-- Name: permission_to_exchange_goods id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.permission_to_exchange_goods ALTER COLUMN id SET DEFAULT nextval('public.permission_to_exchange_goods_id_seq'::regclass);


--
-- Name: permission_to_exchange_goods Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.permission_to_exchange_goods ALTER COLUMN "Code" SET DEFAULT nextval('public.permission_to_exchange_goods_arr_seq'::regclass);


--
-- Name: permission_to_recived_goods id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.permission_to_recived_goods ALTER COLUMN id SET DEFAULT nextval('public.permission_to_recived_goods_id_seq'::regclass);


--
-- Name: permission_to_recived_goods Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.permission_to_recived_goods ALTER COLUMN "Code" SET DEFAULT nextval('public.permission_to_recived_goods_arr_seq'::regclass);


--
-- Name: permissions id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.permissions ALTER COLUMN id SET DEFAULT nextval('public.permissions_id_seq'::regclass);


--
-- Name: places id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.places ALTER COLUMN id SET DEFAULT nextval('public.places_id_seq'::regclass);


--
-- Name: platforms id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.platforms ALTER COLUMN id SET DEFAULT nextval('public.platforms_id_seq'::regclass);


--
-- Name: polices id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.polices ALTER COLUMN id SET DEFAULT nextval('public.polices_id_seq'::regclass);


--
-- Name: pro_details_imgs id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.pro_details_imgs ALTER COLUMN id SET DEFAULT nextval('public.pro_details_imgs_id_seq'::regclass);


--
-- Name: pro_notes id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.pro_notes ALTER COLUMN id SET DEFAULT nextval('public.pro_notes_id_seq'::regclass);


--
-- Name: product_details_e_com_designs id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_details_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.product_details_e_com_designs_id_seq'::regclass);


--
-- Name: product_executing_receiving_secretariats id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_executing_receiving_secretariats ALTER COLUMN id SET DEFAULT nextval('public.product_executing_receiving_secretariats_id_seq'::regclass);


--
-- Name: product_inventories id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_inventories ALTER COLUMN id SET DEFAULT nextval('public.product_inventories_id_seq'::regclass);


--
-- Name: product_job_orders id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_job_orders ALTER COLUMN id SET DEFAULT nextval('public.product_job_orders_id_seq'::regclass);


--
-- Name: product_maintainc_bills id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_maintainc_bills ALTER COLUMN id SET DEFAULT nextval('public.product_maintainc_bills_id_seq'::regclass);


--
-- Name: product_manufacturing_executions id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_manufacturing_executions ALTER COLUMN id SET DEFAULT nextval('public.product_manufacturing_executions_id_seq'::regclass);


--
-- Name: product_moves id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_moves ALTER COLUMN id SET DEFAULT nextval('public.product_moves_id_seq'::regclass);


--
-- Name: product_moves_columns id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_moves_columns ALTER COLUMN id SET DEFAULT nextval('public.product_moves_columns_id_seq'::regclass);


--
-- Name: product_moves_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_moves_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.product_moves_columns_sechdules_id_seq'::regclass);


--
-- Name: product_moves_filter_twos id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_moves_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.product_moves_filter_twos_id_seq'::regclass);


--
-- Name: product_moves_filters id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_moves_filters ALTER COLUMN id SET DEFAULT nextval('public.product_moves_filters_id_seq'::regclass);


--
-- Name: product_quote_images id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_quote_images ALTER COLUMN id SET DEFAULT nextval('public.product_quote_images_id_seq'::regclass);


--
-- Name: product_return_without_bills id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_return_without_bills ALTER COLUMN id SET DEFAULT nextval('public.product_return_without_bills_id_seq'::regclass);


--
-- Name: product_sales id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_sales ALTER COLUMN id SET DEFAULT nextval('public.product_sales_id_seq'::regclass);


--
-- Name: product_sales_gifts id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_sales_gifts ALTER COLUMN id SET DEFAULT nextval('public.product_sales_gifts_id_seq'::regclass);


--
-- Name: product_sales_orders id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_sales_orders ALTER COLUMN id SET DEFAULT nextval('public.product_sales_orders_id_seq'::regclass);


--
-- Name: product_sales_subscribes id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_sales_subscribes ALTER COLUMN id SET DEFAULT nextval('public.product_sales_subscribes_id_seq'::regclass);


--
-- Name: product_settlements id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_settlements ALTER COLUMN id SET DEFAULT nextval('public.product_settlements_id_seq'::regclass);


--
-- Name: product_type_defaults id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_type_defaults ALTER COLUMN id SET DEFAULT nextval('public.product_type_defaults_id_seq'::regclass);


--
-- Name: product_units id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.product_units ALTER COLUMN id SET DEFAULT nextval('public.product_units_id_seq'::regclass);


--
-- Name: products id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products ALTER COLUMN id SET DEFAULT nextval('public.products_id_seq'::regclass);


--
-- Name: products_consists id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_consists ALTER COLUMN id SET DEFAULT nextval('public.products_consists_id_seq'::regclass);


--
-- Name: products_executing_receivings id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_executing_receivings ALTER COLUMN id SET DEFAULT nextval('public.products_executing_receivings_id_seq'::regclass);


--
-- Name: products_manufacturing_orders id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_manufacturing_orders ALTER COLUMN id SET DEFAULT nextval('public.products_manufacturing_orders_id_seq'::regclass);


--
-- Name: products_manufacturing_requests id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_manufacturing_requests ALTER COLUMN id SET DEFAULT nextval('public.products_manufacturing_requests_id_seq'::regclass);


--
-- Name: products_permission_to_exchange_goods id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_permission_to_exchange_goods ALTER COLUMN id SET DEFAULT nextval('public.products_permission_to_exchange_goods_id_seq'::regclass);


--
-- Name: products_permission_to_recived_goods id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_permission_to_recived_goods ALTER COLUMN id SET DEFAULT nextval('public.products_permission_to_recived_goods_id_seq'::regclass);


--
-- Name: products_purchase_petrols id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_purchase_petrols ALTER COLUMN id SET DEFAULT nextval('public.products_purchase_petrols_id_seq'::regclass);


--
-- Name: products_purchases id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_purchases ALTER COLUMN id SET DEFAULT nextval('public.products_purchases_id_seq'::regclass);


--
-- Name: products_purchases_orders id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_purchases_orders ALTER COLUMN id SET DEFAULT nextval('public.products_purchases_orders_id_seq'::regclass);


--
-- Name: products_qties id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_qties ALTER COLUMN id SET DEFAULT nextval('public.products_qties_id_seq'::regclass);


--
-- Name: products_quotes id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_quotes ALTER COLUMN id SET DEFAULT nextval('public.products_quotes_id_seq'::regclass);


--
-- Name: products_return_maintaince_bills id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_return_maintaince_bills ALTER COLUMN id SET DEFAULT nextval('public.products_return_maintaince_bills_id_seq'::regclass);


--
-- Name: products_secretariat_export_goods id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_secretariat_export_goods ALTER COLUMN id SET DEFAULT nextval('public.products_secretariat_export_goods_id_seq'::regclass);


--
-- Name: products_secretariat_import_goods id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_secretariat_import_goods ALTER COLUMN id SET DEFAULT nextval('public.products_secretariat_import_goods_id_seq'::regclass);


--
-- Name: products_shortcomings id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_shortcomings ALTER COLUMN id SET DEFAULT nextval('public.products_shortcomings_id_seq'::regclass);


--
-- Name: products_start_periods id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_start_periods ALTER COLUMN id SET DEFAULT nextval('public.products_start_periods_id_seq'::regclass);


--
-- Name: products_stores id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_stores ALTER COLUMN id SET DEFAULT nextval('public.products_stores_id_seq'::regclass);


--
-- Name: products_stores_transfers id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_stores_transfers ALTER COLUMN id SET DEFAULT nextval('public.products_stores_transfers_id_seq'::regclass);


--
-- Name: products_viras id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.products_viras ALTER COLUMN id SET DEFAULT nextval('public.products_viras_id_seq'::regclass);


--
-- Name: profit_sales_product_column_sechdulrs id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.profit_sales_product_column_sechdulrs ALTER COLUMN id SET DEFAULT nextval('public.profit_sales_product_column_sechdulrs_id_seq'::regclass);


--
-- Name: profit_sales_product_columns id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.profit_sales_product_columns ALTER COLUMN id SET DEFAULT nextval('public.profit_sales_product_columns_id_seq'::regclass);


--
-- Name: project_statuses id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.project_statuses ALTER COLUMN id SET DEFAULT nextval('public.project_statuses_id_seq'::regclass);


--
-- Name: project_teams id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.project_teams ALTER COLUMN id SET DEFAULT nextval('public.project_teams_id_seq'::regclass);


--
-- Name: projects id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.projects ALTER COLUMN id SET DEFAULT nextval('public.projects_id_seq'::regclass);


--
-- Name: purch_bills_columns id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.purch_bills_columns ALTER COLUMN id SET DEFAULT nextval('public.purch_bills_columns_id_seq'::regclass);


--
-- Name: purch_bills_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.purch_bills_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.purch_bills_columns_sechdules_id_seq'::regclass);


--
-- Name: purch_bills_filter_twos id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.purch_bills_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.purch_bills_filter_twos_id_seq'::regclass);


--
-- Name: purch_bills_filters id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.purch_bills_filters ALTER COLUMN id SET DEFAULT nextval('public.purch_bills_filters_id_seq'::regclass);


--
-- Name: purchase_petrols id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.purchase_petrols ALTER COLUMN id SET DEFAULT nextval('public.purchase_petrols_id_seq'::regclass);


--
-- Name: purchase_petrols Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.purchase_petrols ALTER COLUMN "Code" SET DEFAULT nextval('public.purchase_petrols_arr_seq'::regclass);


--
-- Name: purchases id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.purchases ALTER COLUMN id SET DEFAULT nextval('public.purchases_id_seq'::regclass);


--
-- Name: purchases Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.purchases ALTER COLUMN "Code" SET DEFAULT nextval('public.purchases_arr_seq'::regclass);


--
-- Name: purchases_default_data id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.purchases_default_data ALTER COLUMN id SET DEFAULT nextval('public.purchases_default_data_id_seq'::regclass);


--
-- Name: purchases_orders id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.purchases_orders ALTER COLUMN id SET DEFAULT nextval('public.purchases_orders_id_seq'::regclass);


--
-- Name: purchases_orders Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.purchases_orders ALTER COLUMN "Code" SET DEFAULT nextval('public.purchases_orders_arr_seq'::regclass);


--
-- Name: purpose_travel id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.purpose_travel ALTER COLUMN id SET DEFAULT nextval('public.purpose_travel_id_seq'::regclass);


--
-- Name: q_r_s id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.q_r_s ALTER COLUMN id SET DEFAULT nextval('public.q_r_s_id_seq'::regclass);


--
-- Name: qualities id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.qualities ALTER COLUMN id SET DEFAULT nextval('public.qualities_id_seq'::regclass);


--
-- Name: qualities Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.qualities ALTER COLUMN "Code" SET DEFAULT nextval('public.qualities_arr_seq'::regclass);


--
-- Name: quality_details id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.quality_details ALTER COLUMN id SET DEFAULT nextval('public.quality_details_id_seq'::regclass);


--
-- Name: quote_images id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.quote_images ALTER COLUMN id SET DEFAULT nextval('public.quote_images_id_seq'::regclass);


--
-- Name: quote_images Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.quote_images ALTER COLUMN "Code" SET DEFAULT nextval('public.quote_images_arr_seq'::regclass);


--
-- Name: quotes id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.quotes ALTER COLUMN id SET DEFAULT nextval('public.quotes_id_seq'::regclass);


--
-- Name: quotes Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.quotes ALTER COLUMN "Code" SET DEFAULT nextval('public.quotes_arr_seq'::regclass);


--
-- Name: rabih_education id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.rabih_education ALTER COLUMN id SET DEFAULT nextval('public.rabih_education_id_seq'::regclass);


--
-- Name: rates id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.rates ALTER COLUMN id SET DEFAULT nextval('public.rates_id_seq'::regclass);


--
-- Name: real_sate_projects id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.real_sate_projects ALTER COLUMN id SET DEFAULT nextval('public.real_sate_projects_id_seq'::regclass);


--
-- Name: real_sate_projects_payments id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.real_sate_projects_payments ALTER COLUMN id SET DEFAULT nextval('public.real_sate_projects_payments_id_seq'::regclass);


--
-- Name: real_state_default_data id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.real_state_default_data ALTER COLUMN id SET DEFAULT nextval('public.real_state_default_data_id_seq'::regclass);


--
-- Name: reasons id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.reasons ALTER COLUMN id SET DEFAULT nextval('public.reasons_id_seq'::regclass);


--
-- Name: recipt_maintaince_errors id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.recipt_maintaince_errors ALTER COLUMN id SET DEFAULT nextval('public.recipt_maintaince_errors_id_seq'::regclass);


--
-- Name: recipt_maintainces id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.recipt_maintainces ALTER COLUMN id SET DEFAULT nextval('public.recipt_maintainces_id_seq'::regclass);


--
-- Name: recipt_maintainces Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.recipt_maintainces ALTER COLUMN "Code" SET DEFAULT nextval('public.recipt_maintainces_arr_seq'::regclass);


--
-- Name: recipt_voucher_details id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.recipt_voucher_details ALTER COLUMN id SET DEFAULT nextval('public.recipt_voucher_details_id_seq'::regclass);


--
-- Name: recipt_vouchers id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.recipt_vouchers ALTER COLUMN id SET DEFAULT nextval('public.recipt_vouchers_id_seq'::regclass);


--
-- Name: recipt_vouchers Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.recipt_vouchers ALTER COLUMN "Code" SET DEFAULT nextval('public.recipt_vouchers_arr_seq'::regclass);


--
-- Name: recipts_sales_petrols id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.recipts_sales_petrols ALTER COLUMN id SET DEFAULT nextval('public.recipts_sales_petrols_id_seq'::regclass);


--
-- Name: recipts_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.recipts_types ALTER COLUMN id SET DEFAULT nextval('public.recipts_types_id_seq'::regclass);


--
-- Name: recived_purch_products id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.recived_purch_products ALTER COLUMN id SET DEFAULT nextval('public.recived_purch_products_id_seq'::regclass);


--
-- Name: recived_purchts id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.recived_purchts ALTER COLUMN id SET DEFAULT nextval('public.recived_purchts_id_seq'::regclass);


--
-- Name: recived_purchts Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.recived_purchts ALTER COLUMN "Code" SET DEFAULT nextval('public.recived_purchts_arr_seq'::regclass);


--
-- Name: recived_sales id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.recived_sales ALTER COLUMN id SET DEFAULT nextval('public.recived_sales_id_seq'::regclass);


--
-- Name: recived_sales Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.recived_sales ALTER COLUMN "Code" SET DEFAULT nextval('public.recived_sales_arr_seq'::regclass);


--
-- Name: recived_sales_products id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.recived_sales_products ALTER COLUMN id SET DEFAULT nextval('public.recived_sales_products_id_seq'::regclass);


--
-- Name: recived_shipment_goods id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.recived_shipment_goods ALTER COLUMN id SET DEFAULT nextval('public.recived_shipment_goods_id_seq'::regclass);


--
-- Name: recived_shipments id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.recived_shipments ALTER COLUMN id SET DEFAULT nextval('public.recived_shipments_id_seq'::regclass);


--
-- Name: recived_shipments Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.recived_shipments ALTER COLUMN "Code" SET DEFAULT nextval('public.recived_shipments_arr_seq'::regclass);


--
-- Name: reg_courses id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.reg_courses ALTER COLUMN id SET DEFAULT nextval('public.reg_courses_id_seq'::regclass);


--
-- Name: reg_courses_students id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.reg_courses_students ALTER COLUMN id SET DEFAULT nextval('public.reg_courses_students_id_seq'::regclass);


--
-- Name: reg_over_times id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.reg_over_times ALTER COLUMN id SET DEFAULT nextval('public.reg_over_times_id_seq'::regclass);


--
-- Name: reg_over_times Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.reg_over_times ALTER COLUMN "Code" SET DEFAULT nextval('public.reg_over_times_arr_seq'::regclass);


--
-- Name: remove_products_halls id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.remove_products_halls ALTER COLUMN id SET DEFAULT nextval('public.remove_products_halls_id_seq'::regclass);


--
-- Name: reports_settings id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.reports_settings ALTER COLUMN id SET DEFAULT nextval('public.reports_settings_id_seq'::regclass);


--
-- Name: reservations id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.reservations ALTER COLUMN id SET DEFAULT nextval('public.reservations_id_seq'::regclass);


--
-- Name: reservations Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.reservations ALTER COLUMN "Code" SET DEFAULT nextval('public.reservations_arr_seq'::regclass);


--
-- Name: reserve_course_days id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.reserve_course_days ALTER COLUMN id SET DEFAULT nextval('public.reserve_course_days_id_seq'::regclass);


--
-- Name: reserve_course_students id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.reserve_course_students ALTER COLUMN id SET DEFAULT nextval('public.reserve_course_students_id_seq'::regclass);


--
-- Name: reserve_courses id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.reserve_courses ALTER COLUMN id SET DEFAULT nextval('public.reserve_courses_id_seq'::regclass);


--
-- Name: resignation_requests id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resignation_requests ALTER COLUMN id SET DEFAULT nextval('public.resignation_requests_id_seq'::regclass);


--
-- Name: resignation_requests Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resignation_requests ALTER COLUMN "Code" SET DEFAULT nextval('public.resignation_requests_arr_seq'::regclass);


--
-- Name: resturant_abouts id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_abouts ALTER COLUMN id SET DEFAULT nextval('public.resturant_abouts_id_seq'::regclass);


--
-- Name: resturant_blogs id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_blogs ALTER COLUMN id SET DEFAULT nextval('public.resturant_blogs_id_seq'::regclass);


--
-- Name: resturant_cart_check_styles id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_cart_check_styles ALTER COLUMN id SET DEFAULT nextval('public.resturant_cart_check_styles_id_seq'::regclass);


--
-- Name: resturant_carts id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_carts ALTER COLUMN id SET DEFAULT nextval('public.resturant_carts_id_seq'::regclass);


--
-- Name: resturant_cupon_codes id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_cupon_codes ALTER COLUMN id SET DEFAULT nextval('public.resturant_cupon_codes_id_seq'::regclass);


--
-- Name: resturant_galleries id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_galleries ALTER COLUMN id SET DEFAULT nextval('public.resturant_galleries_id_seq'::regclass);


--
-- Name: resturant_homes id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_homes ALTER COLUMN id SET DEFAULT nextval('public.resturant_homes_id_seq'::regclass);


--
-- Name: resturant_index_style_i_i_s id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_index_style_i_i_s ALTER COLUMN id SET DEFAULT nextval('public.resturant_index_style_i_i_s_id_seq'::regclass);


--
-- Name: resturant_index_style_i_s id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_index_style_i_s ALTER COLUMN id SET DEFAULT nextval('public.resturant_index_style_i_s_id_seq'::regclass);


--
-- Name: resturant_menu_styles id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_menu_styles ALTER COLUMN id SET DEFAULT nextval('public.resturant_menu_styles_id_seq'::regclass);


--
-- Name: resturant_nav_foot_styles id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_nav_foot_styles ALTER COLUMN id SET DEFAULT nextval('public.resturant_nav_foot_styles_id_seq'::regclass);


--
-- Name: resturant_privacies id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_privacies ALTER COLUMN id SET DEFAULT nextval('public.resturant_privacies_id_seq'::regclass);


--
-- Name: resturant_reservations id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_reservations ALTER COLUMN id SET DEFAULT nextval('public.resturant_reservations_id_seq'::regclass);


--
-- Name: resturant_reviews id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_reviews ALTER COLUMN id SET DEFAULT nextval('public.resturant_reviews_id_seq'::regclass);


--
-- Name: resturant_sliders id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_sliders ALTER COLUMN id SET DEFAULT nextval('public.resturant_sliders_id_seq'::regclass);


--
-- Name: resturant_socials id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_socials ALTER COLUMN id SET DEFAULT nextval('public.resturant_socials_id_seq'::regclass);


--
-- Name: resturant_styles id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_styles ALTER COLUMN id SET DEFAULT nextval('public.resturant_styles_id_seq'::regclass);


--
-- Name: resturant_sup_page_styles id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_sup_page_styles ALTER COLUMN id SET DEFAULT nextval('public.resturant_sup_page_styles_id_seq'::regclass);


--
-- Name: resturant_tables id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_tables ALTER COLUMN id SET DEFAULT nextval('public.resturant_tables_id_seq'::regclass);


--
-- Name: resturant_terms id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_terms ALTER COLUMN id SET DEFAULT nextval('public.resturant_terms_id_seq'::regclass);


--
-- Name: resturant_video_sections id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.resturant_video_sections ALTER COLUMN id SET DEFAULT nextval('public.resturant_video_sections_id_seq'::regclass);


--
-- Name: return_maintaince_bills id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.return_maintaince_bills ALTER COLUMN id SET DEFAULT nextval('public.return_maintaince_bills_id_seq'::regclass);


--
-- Name: return_maintaince_bills Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.return_maintaince_bills ALTER COLUMN "Code" SET DEFAULT nextval('public.return_maintaince_bills_arr_seq'::regclass);


--
-- Name: return_products_stores_transfers id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.return_products_stores_transfers ALTER COLUMN id SET DEFAULT nextval('public.return_products_stores_transfers_id_seq'::regclass);


--
-- Name: return_purch_bills_filter_twos id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.return_purch_bills_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.return_purch_bills_filter_twos_id_seq'::regclass);


--
-- Name: return_purch_bills_filters id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.return_purch_bills_filters ALTER COLUMN id SET DEFAULT nextval('public.return_purch_bills_filters_id_seq'::regclass);


--
-- Name: return_purch_products id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.return_purch_products ALTER COLUMN id SET DEFAULT nextval('public.return_purch_products_id_seq'::regclass);


--
-- Name: return_purches id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.return_purches ALTER COLUMN id SET DEFAULT nextval('public.return_purches_id_seq'::regclass);


--
-- Name: return_purches Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.return_purches ALTER COLUMN "Code" SET DEFAULT nextval('public.return_purches_arr_seq'::regclass);


--
-- Name: return_sales id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.return_sales ALTER COLUMN id SET DEFAULT nextval('public.return_sales_id_seq'::regclass);


--
-- Name: return_sales Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.return_sales ALTER COLUMN "Code" SET DEFAULT nextval('public.return_sales_arr_seq'::regclass);


--
-- Name: return_sales_bills_filter_twos id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.return_sales_bills_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.return_sales_bills_filter_twos_id_seq'::regclass);


--
-- Name: return_sales_bills_filters id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.return_sales_bills_filters ALTER COLUMN id SET DEFAULT nextval('public.return_sales_bills_filters_id_seq'::regclass);


--
-- Name: return_sales_products id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.return_sales_products ALTER COLUMN id SET DEFAULT nextval('public.return_sales_products_id_seq'::regclass);


--
-- Name: return_stors_transfers id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.return_stors_transfers ALTER COLUMN id SET DEFAULT nextval('public.return_stors_transfers_id_seq'::regclass);


--
-- Name: return_stors_transfers Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.return_stors_transfers ALTER COLUMN "Code" SET DEFAULT nextval('public.return_stors_transfers_arr_seq'::regclass);


--
-- Name: return_without_bills id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.return_without_bills ALTER COLUMN id SET DEFAULT nextval('public.return_without_bills_id_seq'::regclass);


--
-- Name: return_without_bills Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.return_without_bills ALTER COLUMN "Code" SET DEFAULT nextval('public.return_without_bills_arr_seq'::regclass);


--
-- Name: roles id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.roles ALTER COLUMN id SET DEFAULT nextval('public.roles_id_seq'::regclass);


--
-- Name: room_reservations id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.room_reservations ALTER COLUMN id SET DEFAULT nextval('public.room_reservations_id_seq'::regclass);


--
-- Name: rooms id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.rooms ALTER COLUMN id SET DEFAULT nextval('public.rooms_id_seq'::regclass);


--
-- Name: rooms_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.rooms_types ALTER COLUMN id SET DEFAULT nextval('public.rooms_types_id_seq'::regclass);


--
-- Name: safe_transfer_columns id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.safe_transfer_columns ALTER COLUMN id SET DEFAULT nextval('public.safe_transfer_columns_id_seq'::regclass);


--
-- Name: safe_transfer_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.safe_transfer_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.safe_transfer_columns_sechdules_id_seq'::regclass);


--
-- Name: safe_transfer_filter_twos id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.safe_transfer_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.safe_transfer_filter_twos_id_seq'::regclass);


--
-- Name: safe_transfer_filters id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.safe_transfer_filters ALTER COLUMN id SET DEFAULT nextval('public.safe_transfer_filters_id_seq'::regclass);


--
-- Name: safe_transfers id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.safe_transfers ALTER COLUMN id SET DEFAULT nextval('public.safe_transfers_id_seq'::regclass);


--
-- Name: safe_transfers Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.safe_transfers ALTER COLUMN "Code" SET DEFAULT nextval('public.safe_transfers_arr_seq'::regclass);


--
-- Name: safes_banks id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.safes_banks ALTER COLUMN id SET DEFAULT nextval('public.safes_banks_id_seq'::regclass);


--
-- Name: safes_banks Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.safes_banks ALTER COLUMN "Code" SET DEFAULT nextval('public.safes_banks_arr_seq'::regclass);


--
-- Name: sales id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sales ALTER COLUMN id SET DEFAULT nextval('public.sales_id_seq'::regclass);


--
-- Name: sales Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sales ALTER COLUMN "Code" SET DEFAULT nextval('public.sales_arr_seq'::regclass);


--
-- Name: sales_bills_columns id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sales_bills_columns ALTER COLUMN id SET DEFAULT nextval('public.sales_bills_columns_id_seq'::regclass);


--
-- Name: sales_bills_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sales_bills_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.sales_bills_columns_sechdules_id_seq'::regclass);


--
-- Name: sales_bills_filter_twos id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sales_bills_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.sales_bills_filter_twos_id_seq'::regclass);


--
-- Name: sales_bills_filters id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sales_bills_filters ALTER COLUMN id SET DEFAULT nextval('public.sales_bills_filters_id_seq'::regclass);


--
-- Name: sales_default_data id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sales_default_data ALTER COLUMN id SET DEFAULT nextval('public.sales_default_data_id_seq'::regclass);


--
-- Name: sales_fifo_qties id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sales_fifo_qties ALTER COLUMN id SET DEFAULT nextval('public.sales_fifo_qties_id_seq'::regclass);


--
-- Name: sales_gifts id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sales_gifts ALTER COLUMN id SET DEFAULT nextval('public.sales_gifts_id_seq'::regclass);


--
-- Name: sales_gifts Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sales_gifts ALTER COLUMN "Code" SET DEFAULT nextval('public.sales_gifts_arr_seq'::regclass);


--
-- Name: sales_maint_fifo_qties id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sales_maint_fifo_qties ALTER COLUMN id SET DEFAULT nextval('public.sales_maint_fifo_qties_id_seq'::regclass);


--
-- Name: sales_orders id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sales_orders ALTER COLUMN id SET DEFAULT nextval('public.sales_orders_id_seq'::regclass);


--
-- Name: sales_orders Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sales_orders ALTER COLUMN "Code" SET DEFAULT nextval('public.sales_orders_arr_seq'::regclass);


--
-- Name: sales_petrols id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sales_petrols ALTER COLUMN id SET DEFAULT nextval('public.sales_petrols_id_seq'::regclass);


--
-- Name: sales_petrols Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sales_petrols ALTER COLUMN "Code" SET DEFAULT nextval('public.sales_petrols_arr_seq'::regclass);


--
-- Name: sales_subscribes id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sales_subscribes ALTER COLUMN id SET DEFAULT nextval('public.sales_subscribes_id_seq'::regclass);


--
-- Name: sales_subscribes Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sales_subscribes ALTER COLUMN "Code" SET DEFAULT nextval('public.sales_subscribes_arr_seq'::regclass);


--
-- Name: scientific_materials id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.scientific_materials ALTER COLUMN id SET DEFAULT nextval('public.scientific_materials_id_seq'::regclass);


--
-- Name: secretariat_export_goods id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.secretariat_export_goods ALTER COLUMN id SET DEFAULT nextval('public.secretariat_export_goods_id_seq'::regclass);


--
-- Name: secretariat_export_goods Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.secretariat_export_goods ALTER COLUMN "Code" SET DEFAULT nextval('public.secretariat_export_goods_arr_seq'::regclass);


--
-- Name: secretariat_import_goods id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.secretariat_import_goods ALTER COLUMN id SET DEFAULT nextval('public.secretariat_import_goods_id_seq'::regclass);


--
-- Name: secretariat_import_goods Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.secretariat_import_goods ALTER COLUMN "Code" SET DEFAULT nextval('public.secretariat_import_goods_arr_seq'::regclass);


--
-- Name: secretariat_qties id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.secretariat_qties ALTER COLUMN id SET DEFAULT nextval('public.secretariat_qties_id_seq'::regclass);


--
-- Name: secretariat_stores id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.secretariat_stores ALTER COLUMN id SET DEFAULT nextval('public.secretariat_stores_id_seq'::regclass);


--
-- Name: select_a_p_i_s id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.select_a_p_i_s ALTER COLUMN id SET DEFAULT nextval('public.select_a_p_i_s_id_seq'::regclass);


--
-- Name: server_d_b_s id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.server_d_b_s ALTER COLUMN id SET DEFAULT nextval('public.server_d_b_s_id_seq'::regclass);


--
-- Name: settlements id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.settlements ALTER COLUMN id SET DEFAULT nextval('public.settlements_id_seq'::regclass);


--
-- Name: settlements Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.settlements ALTER COLUMN "Code" SET DEFAULT nextval('public.settlements_arr_seq'::regclass);


--
-- Name: shifts id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shifts ALTER COLUMN id SET DEFAULT nextval('public.shifts_id_seq'::regclass);


--
-- Name: shifts Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shifts ALTER COLUMN "Code" SET DEFAULT nextval('public.shifts_arr_seq'::regclass);


--
-- Name: shipment_moves id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipment_moves ALTER COLUMN id SET DEFAULT nextval('public.shipment_moves_id_seq'::regclass);


--
-- Name: shipment_receipts id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipment_receipts ALTER COLUMN id SET DEFAULT nextval('public.shipment_receipts_id_seq'::regclass);


--
-- Name: shipment_receipts Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipment_receipts ALTER COLUMN "Code" SET DEFAULT nextval('public.shipment_receipts_arr_seq'::regclass);


--
-- Name: shipment_receipts_clients id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipment_receipts_clients ALTER COLUMN id SET DEFAULT nextval('public.shipment_receipts_clients_id_seq'::regclass);


--
-- Name: shipment_receipts_clients Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipment_receipts_clients ALTER COLUMN "Code" SET DEFAULT nextval('public.shipment_receipts_clients_arr_seq'::regclass);


--
-- Name: shipment_receipts_lists id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipment_receipts_lists ALTER COLUMN id SET DEFAULT nextval('public.shipment_receipts_lists_id_seq'::regclass);


--
-- Name: shipment_receipts_lists Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipment_receipts_lists ALTER COLUMN "Code" SET DEFAULT nextval('public.shipment_receipts_lists_arr_seq'::regclass);


--
-- Name: shipment_requests id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipment_requests ALTER COLUMN id SET DEFAULT nextval('public.shipment_requests_id_seq'::regclass);


--
-- Name: shipment_requests Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipment_requests ALTER COLUMN "Code" SET DEFAULT nextval('public.shipment_requests_arr_seq'::regclass);


--
-- Name: shipments id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipments ALTER COLUMN id SET DEFAULT nextval('public.shipments_id_seq'::regclass);


--
-- Name: shipments Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipments ALTER COLUMN "Code" SET DEFAULT nextval('public.shipments_arr_seq'::regclass);


--
-- Name: shipments_distribution_goods id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipments_distribution_goods ALTER COLUMN id SET DEFAULT nextval('public.shipments_distribution_goods_id_seq'::regclass);


--
-- Name: shipments_distribution_workers id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipments_distribution_workers ALTER COLUMN id SET DEFAULT nextval('public.shipments_distribution_workers_id_seq'::regclass);


--
-- Name: shipments_distributions id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipments_distributions ALTER COLUMN id SET DEFAULT nextval('public.shipments_distributions_id_seq'::regclass);


--
-- Name: shipments_distributions Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipments_distributions ALTER COLUMN "Code" SET DEFAULT nextval('public.shipments_distributions_arr_seq'::regclass);


--
-- Name: shipping_companies id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipping_companies ALTER COLUMN id SET DEFAULT nextval('public.shipping_companies_id_seq'::regclass);


--
-- Name: shipping_defaults id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipping_defaults ALTER COLUMN id SET DEFAULT nextval('public.shipping_defaults_id_seq'::regclass);


--
-- Name: shipping_list_tickets id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipping_list_tickets ALTER COLUMN id SET DEFAULT nextval('public.shipping_list_tickets_id_seq'::regclass);


--
-- Name: shipping_lists id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipping_lists ALTER COLUMN id SET DEFAULT nextval('public.shipping_lists_id_seq'::regclass);


--
-- Name: shipping_orders id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipping_orders ALTER COLUMN id SET DEFAULT nextval('public.shipping_orders_id_seq'::regclass);


--
-- Name: shipping_orders Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipping_orders ALTER COLUMN "Code" SET DEFAULT nextval('public.shipping_orders_arr_seq'::regclass);


--
-- Name: shipping_prices id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipping_prices ALTER COLUMN id SET DEFAULT nextval('public.shipping_prices_id_seq'::regclass);


--
-- Name: shipping_statuses id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipping_statuses ALTER COLUMN id SET DEFAULT nextval('public.shipping_statuses_id_seq'::regclass);


--
-- Name: shipping_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shipping_types ALTER COLUMN id SET DEFAULT nextval('public.shipping_types_id_seq'::regclass);


--
-- Name: shortcomings id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shortcomings ALTER COLUMN id SET DEFAULT nextval('public.shortcomings_id_seq'::regclass);


--
-- Name: shortcomings Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.shortcomings ALTER COLUMN "Code" SET DEFAULT nextval('public.shortcomings_arr_seq'::regclass);


--
-- Name: show_print_defaults id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.show_print_defaults ALTER COLUMN id SET DEFAULT nextval('public.show_print_defaults_id_seq'::regclass);


--
-- Name: social_media id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.social_media ALTER COLUMN id SET DEFAULT nextval('public.social_media_id_seq'::regclass);


--
-- Name: special_cases id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.special_cases ALTER COLUMN id SET DEFAULT nextval('public.special_cases_id_seq'::regclass);


--
-- Name: spend_profits id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.spend_profits ALTER COLUMN id SET DEFAULT nextval('public.spend_profits_id_seq'::regclass);


--
-- Name: start_periods id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.start_periods ALTER COLUMN id SET DEFAULT nextval('public.start_periods_id_seq'::regclass);


--
-- Name: start_periods Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.start_periods ALTER COLUMN "Code" SET DEFAULT nextval('public.start_periods_arr_seq'::regclass);


--
-- Name: store_count_sales id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.store_count_sales ALTER COLUMN id SET DEFAULT nextval('public.store_count_sales_id_seq'::regclass);


--
-- Name: store_counts id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.store_counts ALTER COLUMN id SET DEFAULT nextval('public.store_counts_id_seq'::regclass);


--
-- Name: store_transfer_filter_twos id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.store_transfer_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.store_transfer_filter_twos_id_seq'::regclass);


--
-- Name: store_transfer_filters id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.store_transfer_filters ALTER COLUMN id SET DEFAULT nextval('public.store_transfer_filters_id_seq'::regclass);


--
-- Name: stores id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.stores ALTER COLUMN id SET DEFAULT nextval('public.stores_arr_seq'::regclass);


--
-- Name: stores Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.stores ALTER COLUMN "Code" SET DEFAULT nextval('public.stores_id_seq'::regclass);


--
-- Name: stores_default_data id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.stores_default_data ALTER COLUMN id SET DEFAULT nextval('public.stores_default_data_id_seq'::regclass);


--
-- Name: stores_moves id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.stores_moves ALTER COLUMN id SET DEFAULT nextval('public.stores_moves_id_seq'::regclass);


--
-- Name: stores_moves_columns id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.stores_moves_columns ALTER COLUMN id SET DEFAULT nextval('public.stores_moves_columns_id_seq'::regclass);


--
-- Name: stores_moves_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.stores_moves_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.stores_moves_columns_sechdules_id_seq'::regclass);


--
-- Name: stores_moves_filter_twos id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.stores_moves_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.stores_moves_filter_twos_id_seq'::regclass);


--
-- Name: stores_moves_filters id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.stores_moves_filters ALTER COLUMN id SET DEFAULT nextval('public.stores_moves_filters_id_seq'::regclass);


--
-- Name: stores_transfer_columns id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.stores_transfer_columns ALTER COLUMN id SET DEFAULT nextval('public.stores_transfer_columns_id_seq'::regclass);


--
-- Name: stores_transfer_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.stores_transfer_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.stores_transfer_columns_sechdules_id_seq'::regclass);


--
-- Name: stors_transfers id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.stors_transfers ALTER COLUMN id SET DEFAULT nextval('public.stors_transfers_id_seq'::regclass);


--
-- Name: stors_transfers Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.stors_transfers ALTER COLUMN "Code" SET DEFAULT nextval('public.stors_transfers_arr_seq'::regclass);


--
-- Name: student_groups id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.student_groups ALTER COLUMN id SET DEFAULT nextval('public.student_groups_id_seq'::regclass);


--
-- Name: student_importants id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.student_importants ALTER COLUMN id SET DEFAULT nextval('public.student_importants_id_seq'::regclass);


--
-- Name: students id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.students ALTER COLUMN id SET DEFAULT nextval('public.students_id_seq'::regclass);


--
-- Name: sub_images id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sub_images ALTER COLUMN id SET DEFAULT nextval('public.sub_images_id_seq'::regclass);


--
-- Name: sub_virables id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sub_virables ALTER COLUMN id SET DEFAULT nextval('public.sub_virables_id_seq'::regclass);


--
-- Name: subscribe_types id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.subscribe_types ALTER COLUMN id SET DEFAULT nextval('public.subscribe_types_id_seq'::regclass);


--
-- Name: sup_pages_e_com_designs id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sup_pages_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.sup_pages_e_com_designs_id_seq'::regclass);


--
-- Name: sup_pages_part_two_e_com_designs id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sup_pages_part_two_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.sup_pages_part_two_e_com_designs_id_seq'::regclass);


--
-- Name: sup_pages_wish_comp_e_com_designs id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.sup_pages_wish_comp_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.sup_pages_wish_comp_e_com_designs_id_seq'::regclass);


--
-- Name: taxes id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.taxes ALTER COLUMN id SET DEFAULT nextval('public.taxes_id_seq'::regclass);


--
-- Name: taxes Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.taxes ALTER COLUMN "Code" SET DEFAULT nextval('public.taxes_arr_seq'::regclass);


--
-- Name: teachers id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.teachers ALTER COLUMN id SET DEFAULT nextval('public.teachers_id_seq'::regclass);


--
-- Name: teachers_groups id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.teachers_groups ALTER COLUMN id SET DEFAULT nextval('public.teachers_groups_id_seq'::regclass);


--
-- Name: teachers_subjects id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.teachers_subjects ALTER COLUMN id SET DEFAULT nextval('public.teachers_subjects_id_seq'::regclass);


--
-- Name: terms id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.terms ALTER COLUMN id SET DEFAULT nextval('public.terms_id_seq'::regclass);


--
-- Name: terms_maintainces id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.terms_maintainces ALTER COLUMN id SET DEFAULT nextval('public.terms_maintainces_id_seq'::regclass);


--
-- Name: testclients id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.testclients ALTER COLUMN id SET DEFAULT nextval('public.testclients_id_seq'::regclass);


--
-- Name: ticekt_issues id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.ticekt_issues ALTER COLUMN id SET DEFAULT nextval('public.ticekt_issues_id_seq'::regclass);


--
-- Name: ticket_products id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.ticket_products ALTER COLUMN id SET DEFAULT nextval('public.ticket_products_id_seq'::regclass);


--
-- Name: tickets id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.tickets ALTER COLUMN id SET DEFAULT nextval('public.tickets_id_seq'::regclass);


--
-- Name: tickets Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.tickets ALTER COLUMN "Code" SET DEFAULT nextval('public.tickets_arr_seq'::regclass);


--
-- Name: translation_tourism_companies id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.translation_tourism_companies ALTER COLUMN id SET DEFAULT nextval('public.translation_tourism_companies_id_seq'::regclass);


--
-- Name: translte_modules id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.translte_modules ALTER COLUMN id SET DEFAULT nextval('public.translte_modules_id_seq'::regclass);


--
-- Name: translte_modules_details id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.translte_modules_details ALTER COLUMN id SET DEFAULT nextval('public.translte_modules_details_id_seq'::regclass);


--
-- Name: transltors id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.transltors ALTER COLUMN id SET DEFAULT nextval('public.transltors_id_seq'::regclass);


--
-- Name: unloading_shipments id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.unloading_shipments ALTER COLUMN id SET DEFAULT nextval('public.unloading_shipments_id_seq'::regclass);


--
-- Name: unloading_shipments Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.unloading_shipments ALTER COLUMN "Code" SET DEFAULT nextval('public.unloading_shipments_arr_seq'::regclass);


--
-- Name: unloading_shipments_goods id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.unloading_shipments_goods ALTER COLUMN id SET DEFAULT nextval('public.unloading_shipments_goods_id_seq'::regclass);


--
-- Name: unloading_shipments_workers id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.unloading_shipments_workers ALTER COLUMN id SET DEFAULT nextval('public.unloading_shipments_workers_id_seq'::regclass);


--
-- Name: update_values_investors id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.update_values_investors ALTER COLUMN id SET DEFAULT nextval('public.update_values_investors_id_seq'::regclass);


--
-- Name: upload_accountings id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.upload_accountings ALTER COLUMN id SET DEFAULT nextval('public.upload_accountings_id_seq'::regclass);


--
-- Name: users_moves id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.users_moves ALTER COLUMN id SET DEFAULT nextval('public.users_moves_id_seq'::regclass);


--
-- Name: v_a_prices id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.v_a_prices ALTER COLUMN id SET DEFAULT nextval('public.v_a_prices_id_seq'::regclass);


--
-- Name: v_a_products id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.v_a_products ALTER COLUMN id SET DEFAULT nextval('public.v_a_products_id_seq'::regclass);


--
-- Name: v_a_qties id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.v_a_qties ALTER COLUMN id SET DEFAULT nextval('public.v_a_qties_id_seq'::regclass);


--
-- Name: vendor_account_statement_column_sechdules id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.vendor_account_statement_column_sechdules ALTER COLUMN id SET DEFAULT nextval('public.vendor_account_statement_column_sechdules_id_seq'::regclass);


--
-- Name: vendor_account_statement_columns id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.vendor_account_statement_columns ALTER COLUMN id SET DEFAULT nextval('public.vendor_account_statement_columns_id_seq'::regclass);


--
-- Name: vendor_filters id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.vendor_filters ALTER COLUMN id SET DEFAULT nextval('public.vendor_filters_id_seq'::regclass);


--
-- Name: vendor_products id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.vendor_products ALTER COLUMN id SET DEFAULT nextval('public.vendor_products_id_seq'::regclass);


--
-- Name: vendors id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.vendors ALTER COLUMN id SET DEFAULT nextval('public.vendors_id_seq'::regclass);


--
-- Name: vendors Code; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.vendors ALTER COLUMN "Code" SET DEFAULT nextval('public.vendors_arr_seq'::regclass);


--
-- Name: vendors_statements_column_sechdules id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.vendors_statements_column_sechdules ALTER COLUMN id SET DEFAULT nextval('public.vendors_statements_column_sechdules_id_seq'::regclass);


--
-- Name: vendors_statements_columns id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.vendors_statements_columns ALTER COLUMN id SET DEFAULT nextval('public.vendors_statements_columns_id_seq'::regclass);


--
-- Name: virables id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.virables ALTER COLUMN id SET DEFAULT nextval('public.virables_id_seq'::regclass);


--
-- Name: vouchers id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.vouchers ALTER COLUMN id SET DEFAULT nextval('public.vouchers_id_seq'::regclass);


--
-- Name: web_sliders id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.web_sliders ALTER COLUMN id SET DEFAULT nextval('public.web_sliders_id_seq'::regclass);


--
-- Name: wishlists id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.wishlists ALTER COLUMN id SET DEFAULT nextval('public.wishlists_id_seq'::regclass);


--
-- Name: work_departments id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.work_departments ALTER COLUMN id SET DEFAULT nextval('public.work_departments_id_seq'::regclass);


--
-- Name: workers_sales_petrols id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.workers_sales_petrols ALTER COLUMN id SET DEFAULT nextval('public.workers_sales_petrols_id_seq'::regclass);


--
-- Name: zkteco_devices id; Type: DEFAULT; Schema: public; Owner: demorabiherp_karim
--

ALTER TABLE ONLY public.zkteco_devices ALTER COLUMN id SET DEFAULT nextval('public.zkteco_devices_id_seq'::regclass);


--
-- Data for Name: a_v_pro_check_qties; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.a_v_pro_check_qties (id, "Product", "AvQty", "Qty", "RequestQty", created_at, updated_at, "OriginalProduct", "NewRequestQty") FROM stdin;
\.


--
-- Data for Name: abouts; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.abouts (id, "Image", "Image_2", "Image_3", "Arabic_Title", "English_Title", "Arabic_Desc", "English_Desc", created_at, updated_at) FROM stdin;
1	AboutImages/bTiXmoIvZgg7T3RUX9Y1.jpeg	AboutImages/NqfSP0j3p9wn3n5X4N3s.jpeg	AboutImages/DdpthioSZUZlqRR1szE9.jpeg	BELLE MULTIPURPOSE BOOTSTRAP 4 HTML TEMPLATE	BELLE MULTIPURPOSE BOOTSTRAP 4 HTML TEMPLATE	SED UT PERSPICIATIS UNDE OMNIS ISTE NATUS ERROR\r\n\nSed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, On the other hand, we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment, so blinded by desire, that they cannot foresee the pain.\r\n\nsimple and easy to distinguish. In a free hour, when our power of choice is untrammelled and when nothing prevents our being able to do what we like best, every pleasure is to be welcomed and every pain avoided. But in certain circumstances and owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted.\r\n\nABOUT ANNIMEX WEB\r\n\nLorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.\r\n\nSed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.\r\n\nAt vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.	SED UT PERSPICIATIS UNDE OMNIS ISTE NATUS ERROR\r\n\nSed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, On the other hand, we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment, so blinded by desire, that they cannot foresee the pain.\r\n\nsimple and easy to distinguish. In a free hour, when our power of choice is untrammelled and when nothing prevents our being able to do what we like best, every pleasure is to be welcomed and every pain avoided. But in certain circumstances and owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted.\r\n\nABOUT ANNIMEX WEB\r\n\nLorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.\r\n\nSed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.\r\n\nAt vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.	\N	2022-06-04 15:13:12
\.


--
-- Data for Name: abstracts_contractors; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.abstracts_contractors (id, "Code", "Date", "Name", "Value", "Statement", "Contractor", "Project", "Edit", "Delete", "Edit_New_Code", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: acccounting_manuals; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.acccounting_manuals (id, "Code", "Name", "Type", "Parent", "Note", "User", created_at, updated_at, "Account_Code", "Pro_Group", "NameEn", "SearchCode") FROM stdin;
824	606	مصروفات البيع و التوزيع	0	20	\N	1	2022-04-13 19:11:41	2022-10-18 22:42:48	75	\N	Selling and Distribution Expenses	\N
826	403	تحصيل دليفري	1	18	\N	11	2022-05-15 16:52:32	2022-10-18 22:42:47	57	\N	Delivery Service Collection	\N
2523	20102	مورد افتراضي	1	37	\N	11	2024-02-09 00:08:40	2024-02-09 00:08:40	\N	\N	Default Vendor	\N
119	205	مجمع الاهلاك	0	16	\N	1	2021-10-02 08:23:41	2024-02-14 23:12:23	41	\N	Asset Depreciation Accumulator	\N
852	607	رسوم بنوك	0	20	\N	11	2022-11-03 07:48:29	2022-11-03 07:48:29	٠	\N	Bank Fees	\N
853	608	مصاريف شركات التقسيط	0	20	\N	11	2022-11-03 07:49:34	2022-11-03 07:49:34	0	\N	Installment Companies Expenses	\N
854	60701	رسوم خدمه	1	852	\N	11	2022-11-03 07:49:52	2022-11-03 07:49:52	0	\N	Service Charges	\N
856	404	إيردات اخري	0	18	\N	11	2022-11-03 07:55:13	2022-11-03 07:55:13	0	\N	Other Revenues	\N
888	1020103	شركات التقسيط	0	23	\N	11	2022-11-03 07:54:02	2022-11-03 07:54:02	0	\N	Installment Companies	\N
2497	6060204	تكلفه مصنعيه	1	55	\N	11	2022-12-21 02:46:32	2022-12-21 02:46:32	0	\N	Manufacturing Cost	\N
2498	6060205	تالف الصيانه	1	55	\N	11	2023-01-16 18:58:53	2023-01-16 18:58:53	0	\N	Maintenance Damaged	\N
2503	6060107	مندوب مبيعات افتراضي  عموله 	1	164	\N	11	2024-02-08 23:52:53	2024-02-08 23:54:43	\N	\N	Default Sales  Commission 	\N
2505	20401	مندوب مبيعات افتراضي  استحقاق 	1	43	\N	11	2024-02-08 23:52:53	2024-02-08 23:54:43	\N	\N	Default Sales  Merit 	\N
2513	20403	مهندس افتراضي  استحقاق 	1	43	\N	11	2024-02-08 23:56:24	2024-02-08 23:56:24	\N	\N	Default Eng  Merit 	\N
2518	60113	نادل افتراضي	1	53	\N	11	2024-02-08 23:58:21	2024-02-08 23:58:21	\N	\N	Default Waiter	\N
2502	60109	مندوب مبيعات افتراضي	1	53	\N	11	2024-02-08 23:52:53	2024-02-08 23:54:43	\N	\N	Default Sales	\N
2504	102040108	مندوب مبيعات افتراضي  عهده 	1	121	\N	11	2024-02-08 23:52:53	2024-02-08 23:54:43	\N	\N	Default Sales  Custody 	\N
2510	60111	مهندس افتراضي	1	53	\N	11	2024-02-08 23:56:24	2024-02-08 23:56:24	\N	\N	Default Eng	\N
2511	6060109	مهندس افتراضي  عموله 	1	164	\N	11	2024-02-08 23:56:24	2024-02-08 23:56:24	\N	\N	Default Eng  Commission 	\N
2512	102040110	مهندس افتراضي  عهده 	1	121	\N	11	2024-02-08 23:56:24	2024-02-08 23:56:24	\N	\N	Default Eng  Custody 	\N
2519	6060111	نادل افتراضي  عموله 	1	164	\N	11	2024-02-08 23:58:21	2024-02-08 23:58:21	\N	\N	Default Waiter  Commission 	\N
2520	102040112	نادل افتراضي  عهده 	1	121	\N	11	2024-02-08 23:58:21	2024-02-08 23:58:21	\N	\N	Default Waiter  Custody 	\N
2521	20405	نادل افتراضي  استحقاق 	1	43	\N	11	2024-02-08 23:58:21	2024-02-08 23:58:21	\N	\N	Default Waiter  Merit 	\N
2496	405	ايراد مصنعية	1	18	\N	11	2022-12-21 02:46:07	2024-02-14 23:15:25	0	\N	Manufacturing Revenue	\N
895	40401	ايردات رسوم الخدمة	1	856	\N	11	2022-11-03 07:55:46	2024-02-14 23:15:43	0	\N	Service Charges Revenues	\N
2527	209	استحقاق مستثمرين	0	16	\N	11	2024-11-05 12:49:22	2024-11-05 12:49:22	\N	\N	Investors' Eligibility	\N
57	6060202	كهرباء	1	55	\N	1	2021-06-16 01:26:56	2022-10-18 22:42:48	85	\N	Electricity	\N
58	6060203	مصروفات ضيافه	1	55	\N	1	2021-06-16 01:41:37	2022-10-18 22:42:48	86	\N	Hosting Expenses	\N
70	10206	وسيط المخازن	0	22	\N	1	2021-07-16 12:00:41	2022-10-18 22:42:47	29	\N	Intermediate Warehouse Account	\N
71	1020601	وسيط المخازن	1	70	\N	1	2021-07-16 12:01:10	2022-10-18 22:42:47	30	\N	Intermediate Warehouse Account	\N
97	603	شركات الشحن	0	20	\N	1	2021-08-08 10:48:13	2022-10-18 22:42:48	70	\N	Freight Companies	\N
112	20202	بدون ضريبة	1	39	\N	1	2021-08-23 00:16:53	2022-10-18 22:42:47	37	\N	Without Taxes	\N
121	1020401	العهد	0	26	\N	1	2021-10-02 08:24:25	2022-10-18 22:42:47	18	\N	Custody	\N
122	10102	الأثاث المكتبي	0	21	\N	1	2021-10-02 08:25:42	2022-10-18 22:42:47	3	\N	Office Furniture	\N
136	303	الارباح و الخسائر	0	17	\N	1	2021-10-09 12:10:07	2022-10-18 22:42:47	47	\N	Profits and Losses	\N
139	30301	الارباح الحالية	0	136	\N	1	2021-10-13 17:36:17	2022-10-18 22:42:47	48	\N	Current Profits	\N
140	30302	الارباح الرأس مالية	0	136	\N	1	2021-10-13 17:36:41	2022-10-18 22:42:47	49	\N	Capital Profits	\N
141	30303	الارباح المرحلة	0	136	\N	1	2021-10-13 17:37:01	2022-10-18 22:42:47	50	\N	Retained Earnings	\N
147	103	اصول اخري	0	15	\N	1	2021-10-14 17:02:03	2022-10-18 22:42:47	31	\N	Other Assets	\N
148	207	خصوم طويلة الاجل	0	16	\N	1	2021-10-14 17:02:50	2022-10-18 22:42:47	42	\N	Long-Term Liabilities	\N
164	60601	عمولات الموظفين	0	824	\N	1	2021-10-28 09:42:04	2022-10-18 22:42:48	76	\N	Employee Commissions	\N
206	402	خصم مكتسب	1	18	\N	1	2022-02-16 22:01:22	2022-10-18 22:42:47	56	\N	Earned Discount	\N
15	1	الأصول	0	0	\N	1	\N	\N	0	\N	Assets	\N
2499	1020503	مخزن الطلبات	1	27	\N	11	2023-08-30 11:11:31	2023-08-30 11:11:31	\N	\N	Requests Store	\N
16	2	الخصوم	0	0	\N	1	2021-06-16 00:29:12	2022-10-18 22:42:47	32	\N	Liabilities	\N
17	3	حقوق الملكية	0	0	\N	1	2021-06-16 00:29:32	2022-10-18 22:42:47	43	\N	Shareholders equity	\N
18	4	الايرادات	0	0	\N	1	2021-06-16 00:29:56	2022-10-18 22:42:47	51	\N	Revenues	\N
19	5	تكلفة المبيعات	0	0	\N	1	2021-06-16 00:30:22	2022-10-18 22:42:48	58	\N	Cost Of Goods Sold (COGS)	\N
20	6	المصروفات	0	0	\N	1	2021-06-16 00:30:50	2022-10-18 22:42:48	60	\N	Expenses	\N
21	101	أصول ثابتة	0	15	\N	1	2021-06-16 00:31:46	2022-10-18 22:42:47	2	\N	Fixed Assets	\N
22	102	أصول متداولة	0	15	\N	1	2021-06-16 00:32:28	2022-10-18 22:42:47	4	\N	Current Assets	\N
23	10201	النقدية وما في حكمها	0	22	\N	1	2021-06-16 00:34:14	2022-10-18 22:42:47	5	\N	All kinds of cash	\N
24	10202	العملاء	0	22	\N	1	2021-06-16 00:34:53	2022-10-18 22:42:47	11	\N	Customers	\N
25	10203	أوراق قبض	0	22	\N	1	2021-06-16 00:36:12	2022-10-18 22:42:47	15	\N	Notes Receivable	\N
26	10204	مدينين	0	22	\N	1	2021-06-16 00:37:03	2022-10-18 22:42:47	17	\N	Debtors	\N
27	10205	المخزون	0	22	\N	1	2021-06-16 00:37:44	2022-10-18 22:42:47	26	\N	Inventory	\N
28	1020101	الخزينة	0	23	\N	1	2021-06-16 00:38:47	2022-10-18 22:42:47	6	\N	Cash Fund	\N
29	1020102	نقدية بالبنك	0	23	\N	1	2021-06-16 00:40:04	2022-10-18 22:42:47	8	\N	Bank cash	\N
35	1020301	أوراق قبض	1	25	\N	1	2021-06-16 00:46:08	2022-10-18 22:42:47	16	\N	Notes Receivable	\N
37	201	الموردين	0	16	\N	1	2021-06-16 01:12:06	2022-10-18 22:42:47	33	\N	Suppliers	\N
39	202	الضرائب	0	16	\N	1	2021-06-16 01:13:20	2022-10-18 22:42:47	35	\N	Taxes	\N
2525	20501	مجمع اهلاك الاثاث المكتبي	1	119	\N	11	2024-02-14 23:13:11	2024-02-14 23:13:11	0	\N	مجمع اهلاك الاثاث المكتبي	\N
41	203	أوراق دفع	0	16	\N	1	2021-06-16 01:14:38	2022-10-18 22:42:47	38	\N	Notes Payable	\N
42	20301	أوراق دفع	1	41	\N	1	2021-06-16 01:15:16	2022-10-18 22:42:47	39	\N	Notes Payable	\N
43	204	دائنين	0	16	\N	1	2021-06-16 01:15:57	2022-10-18 22:42:47	40	\N	Creditors	\N
44	301	رأس المال	0	17	\N	1	2021-06-16 01:16:55	2022-10-18 22:42:47	44	\N	Capital	\N
45	30101	رأس المال	1	44	\N	1	2021-06-16 01:17:44	2022-10-18 22:42:47	45	\N	Capital	\N
46	302	جاري الشركاء	0	17	\N	1	2021-06-16 01:18:34	2022-10-18 22:42:47	46	\N	Partners Current Account	\N
47	401	إيرادات المبيعات	0	18	\N	1	2021-06-16 01:19:32	2022-10-18 22:42:47	52	\N	Sales Revenue	\N
48	40101	المبيعات	1	47	\N	1	2021-06-16 01:20:15	2022-10-18 22:42:47	53	\N	Sales	\N
49	40102	مردودات المبيعات	1	47	\N	1	2021-06-16 01:20:45	2022-10-18 22:42:47	54	\N	Sales Return	\N
50	60401	خصم مسموح به	1	851	\N	1	2021-06-16 01:21:13	2022-10-18 22:42:48	72	\N	Allowed Discount	\N
51	40104	خدمة صالة	1	47	\N	1	2021-06-16 01:21:57	2022-10-18 22:42:47	55	\N	Lounge Service	\N
52	501	تكلفه بضاعه مباعه	1	19	\N	1	2021-06-16 01:23:13	2022-10-18 22:42:48	59	\N	Cost Of Goods Sold (COGS)	\N
53	601	المرتبات والأجور	0	20	\N	1	2021-06-16 01:24:33	2022-10-18 22:42:48	61	\N	Salaries and Wages	\N
54	60101	الموظفين	0	53	\N	1	2021-06-16 01:25:07	2022-10-18 22:42:48	62	\N	Employees	\N
55	60602	مصروفات التشغيل	0	824	\N	1	2021-06-16 01:25:48	2022-10-18 22:42:48	83	\N	Operating Expenses	\N
56	6060201	الإيجار	1	55	\N	1	2021-06-16 01:26:20	2022-10-18 22:42:48	84	\N	Rentals	\N
188	60501	مصروف اهلاك الاثاث المكتبي	1	120	\N	1	2021-12-29 11:16:16	2024-02-14 23:14:32	74	\N	New Depreciation	\N
2526	208	المستثمرين	0	16	\N	11	2024-11-05 12:49:01	2024-11-05 12:49:01	\N	\N	Investors	\N
2506	60110	مندوب مشتريات افتراضي	1	53	\N	11	2024-02-08 23:54:06	2024-02-08 23:55:02	\N	\N	Default Purchaser	\N
2522	1020205	عميل افتراضي	1	24	\N	11	2024-02-09 00:08:02	2024-02-09 00:08:02	\N	\N	Default Customer	\N
825	602	مصروفات عمومية وادارية	0	20	\N	1	2022-04-13 19:12:04	2022-10-18 22:42:48	69	\N	General and Administrative Expenses	\N
30	102010101	الخزينة الرئيسية	1	28	\N	1	2021-06-16 00:41:19	2024-02-09 00:18:47	7	\N	Main Safe	\N
830	1020402	حساب معايره	1	26	\N	11	2022-05-21 01:12:14	2022-10-18 22:42:47	25	\N	Calibrated Account	\N
2508	102040109	مندوب مشتريات افتراضي  عهده 	1	121	\N	11	2024-02-08 23:54:07	2024-02-08 23:55:02	\N	\N	Default Purchaser  Custody 	\N
851	604	خصم مسموح به	0	20	\N	1	\N	2022-10-18 22:42:48	71	\N	Allowed Discount	\N
2500	1020504	المخزن الرئيسي	1	27	\N	11	2024-02-08 23:43:55	2024-02-08 23:43:55	\N	\N	Main Store	\N
2501	1020204	المخزن الرئيسي   عميل مخزن 	1	24	\N	11	2024-02-08 23:43:55	2024-02-08 23:43:55	\N	\N	Main Store    Store Client 	\N
2507	6060108	مندوب مشتريات افتراضي  عموله 	1	164	\N	11	2024-02-08 23:54:07	2024-02-08 23:55:02	\N	\N	Default Purchaser  Commission 	\N
2509	20402	مندوب مشتريات افتراضي  استحقاق 	1	43	\N	11	2024-02-08 23:54:07	2024-02-08 23:55:02	\N	\N	Default Purchaser  Merit 	\N
2514	60112	مندوب توصيل افتراضي	1	53	\N	11	2024-02-08 23:57:46	2024-02-08 23:57:46	\N	\N	Default Delivery	\N
2515	6060110	مندوب توصيل افتراضي  عموله 	1	164	\N	11	2024-02-08 23:57:46	2024-02-08 23:57:46	\N	\N	Default Delivery  Commission 	\N
2516	102040111	مندوب توصيل افتراضي  عهده 	1	121	\N	11	2024-02-08 23:57:46	2024-02-08 23:57:46	\N	\N	Default Delivery  Custody 	\N
2517	20404	مندوب توصيل افتراضي  استحقاق 	1	43	\N	11	2024-02-08 23:57:46	2024-02-08 23:57:46	\N	\N	Default Delivery  Merit 	\N
32	102010201	البنك الاهلي	1	29	\N	1	2021-06-16 00:42:58	2024-02-09 00:20:06	9	\N	SNB	\N
2524	60301	زاجل	1	97	\N	11	2024-02-09 00:41:56	2024-02-09 00:41:56	\N	\N	Zagel	\N
40	20201	القيمة المضافة	1	39	\N	1	2021-06-16 01:13:49	2024-02-14 23:10:57	36	\N	VAT	\N
120	605	مصروفات الاهلاك	0	20	\N	1	2021-10-02 08:23:55	2024-02-14 23:13:50	73	\N	Depreciation	\N
2528	304	مصروفات ارباح مستثمرين	0	17	\N	11	2024-11-05 12:49:39	2024-11-13 08:56:22	0	\N	Investors' Dividend Expenses	\N
2529	609	مصاريف مشاريع	0	20	\N	11	2025-02-19 14:49:54	2025-02-19 14:49:54	\N	\N	مصاريف مشاريع	\N
2530	210	استحقاق المقاولين	0	16	\N	11	2025-03-09 13:19:33	2025-03-09 13:19:33	\N	\N	استحقاق المقاولين	\N
2531	610	تطبيقات التوصيل	0	20	\N	11	2025-04-25 13:48:29	2025-04-25 13:48:29	\N	\N	Delivery App	\N
2532	60603	مصاريف السيارات	0	824	\N	11	2025-08-21 06:50:32	2025-08-21 06:50:32	\N	\N	مصاريف السيارات	\N
2533	211	استحقاق سيارات الشحن	0	16	\N	11	2025-08-22 18:27:51	2025-08-22 18:27:51	\N	\N	استحقاق سيارات الشحن	\N
2534	6060206	مصاريف الشحنة	1	55	\N	11	2025-08-22 18:48:23	2025-08-22 18:48:23	\N	\N	مصاريف الشحنة	\N
2535	1020206	بسنت	1	24	\N	1	2025-10-02 14:29:56	2025-10-02 14:29:56	\N	\N	بسنت	\N
2536	60114	طيار 1	1	53	\N	11	2025-10-02 15:22:50	2025-10-02 15:22:50	\N	\N	طيار 1	\N
2537	6060112	طيار 1  عموله 	1	164	\N	11	2025-10-02 15:22:50	2025-10-02 15:22:50	\N	\N	طيار 1  Commission 	\N
2538	102040113	طيار 1  عهده 	1	121	\N	11	2025-10-02 15:22:50	2025-10-02 15:22:50	\N	\N	طيار 1  Custody 	\N
2539	20406	طيار 1  استحقاق 	1	43	\N	11	2025-10-02 15:22:50	2025-10-02 15:22:50	\N	\N	طيار 1  Merit 	\N
2540	60115	طيار 2	1	53	\N	11	2025-10-02 15:22:59	2025-10-02 15:22:59	\N	\N	طيار 2	\N
2541	6060113	طيار 2  عموله 	1	164	\N	11	2025-10-02 15:22:59	2025-10-02 15:22:59	\N	\N	طيار 2  Commission 	\N
2542	102040114	طيار 2  عهده 	1	121	\N	11	2025-10-02 15:22:59	2025-10-02 15:22:59	\N	\N	طيار 2  Custody 	\N
2543	20407	طيار 2  استحقاق 	1	43	\N	11	2025-10-02 15:22:59	2025-10-02 15:22:59	\N	\N	طيار 2  Merit 	\N
2544	60116	طيار 3	1	53	\N	11	2025-10-02 15:23:09	2025-10-02 15:23:09	\N	\N	طيار 3	\N
2545	6060114	طيار 3  عموله 	1	164	\N	11	2025-10-02 15:23:09	2025-10-02 15:23:09	\N	\N	طيار 3  Commission 	\N
2546	102040115	طيار 3  عهده 	1	121	\N	11	2025-10-02 15:23:09	2025-10-02 15:23:09	\N	\N	طيار 3  Custody 	\N
2547	20408	طيار 3  استحقاق 	1	43	\N	11	2025-10-02 15:23:09	2025-10-02 15:23:09	\N	\N	طيار 3  Merit 	\N
2548	60117	طيار 4	1	53	\N	11	2025-10-02 15:23:17	2025-10-02 15:23:17	\N	\N	طيار 4	\N
2549	6060115	طيار 4  عموله 	1	164	\N	11	2025-10-02 15:23:17	2025-10-02 15:23:17	\N	\N	طيار 4  Commission 	\N
2550	102040116	طيار 4  عهده 	1	121	\N	11	2025-10-02 15:23:17	2025-10-02 15:23:17	\N	\N	طيار 4  Custody 	\N
2551	20409	طيار 4  استحقاق 	1	43	\N	11	2025-10-02 15:23:17	2025-10-02 15:23:17	\N	\N	طيار 4  Merit 	\N
2552	60118	طيار 5	1	53	\N	11	2025-10-02 15:23:32	2025-10-02 15:23:32	\N	\N	طيار 5	\N
2553	6060116	طيار 5  عموله 	1	164	\N	11	2025-10-02 15:23:32	2025-10-02 15:23:32	\N	\N	طيار 5  Commission 	\N
2554	102040117	طيار 5  عهده 	1	121	\N	11	2025-10-02 15:23:32	2025-10-02 15:23:32	\N	\N	طيار 5  Custody 	\N
2555	20410	طيار 5  استحقاق 	1	43	\N	11	2025-10-02 15:23:32	2025-10-02 15:23:32	\N	\N	طيار 5  Merit 	\N
2556	60119	بياع 1	1	53	\N	11	2025-10-02 15:26:06	2025-10-02 15:26:06	\N	\N	بياع 1	\N
2557	6060117	بياع 1  عموله 	1	164	\N	11	2025-10-02 15:26:06	2025-10-02 15:26:06	\N	\N	بياع 1  Commission 	\N
2558	102040118	بياع 1  عهده 	1	121	\N	11	2025-10-02 15:26:06	2025-10-02 15:26:06	\N	\N	بياع 1  Custody 	\N
2559	20411	بياع 1  استحقاق 	1	43	\N	11	2025-10-02 15:26:06	2025-10-02 15:26:06	\N	\N	بياع 1  Merit 	\N
2560	60120	بياع 2	1	53	\N	11	2025-10-02 15:26:10	2025-10-02 15:26:10	\N	\N	بياع 2	\N
2561	6060118	بياع 2  عموله 	1	164	\N	11	2025-10-02 15:26:10	2025-10-02 15:26:10	\N	\N	بياع 2  Commission 	\N
2562	102040119	بياع 2  عهده 	1	121	\N	11	2025-10-02 15:26:10	2025-10-02 15:26:10	\N	\N	بياع 2  Custody 	\N
2563	20412	بياع 2  استحقاق 	1	43	\N	11	2025-10-02 15:26:10	2025-10-02 15:26:10	\N	\N	بياع 2  Merit 	\N
2564	60121	بياع 3	1	53	\N	11	2025-10-02 15:26:15	2025-10-02 15:26:15	\N	\N	بياع 3	\N
2565	6060119	بياع 3  عموله 	1	164	\N	11	2025-10-02 15:26:15	2025-10-02 15:26:15	\N	\N	بياع 3  Commission 	\N
2566	102040120	بياع 3  عهده 	1	121	\N	11	2025-10-02 15:26:15	2025-10-02 15:26:15	\N	\N	بياع 3  Custody 	\N
2567	20413	بياع 3  استحقاق 	1	43	\N	11	2025-10-02 15:26:15	2025-10-02 15:26:15	\N	\N	بياع 3  Merit 	\N
2568	60122	بياع 4	1	53	\N	11	2025-10-02 15:26:19	2025-10-02 15:26:19	\N	\N	بياع 4	\N
2569	6060120	بياع 4  عموله 	1	164	\N	11	2025-10-02 15:26:19	2025-10-02 15:26:19	\N	\N	بياع 4  Commission 	\N
2570	102040121	بياع 4  عهده 	1	121	\N	11	2025-10-02 15:26:19	2025-10-02 15:26:19	\N	\N	بياع 4  Custody 	\N
2571	20414	بياع 4  استحقاق 	1	43	\N	11	2025-10-02 15:26:19	2025-10-02 15:26:19	\N	\N	بياع 4  Merit 	\N
2572	1020207	احمد	1	24	\N	1	2025-10-02 15:35:26	2025-10-02 15:35:26	\N	\N	احمد	\N
2573	60123	بائع 6	1	53	\N	11	2025-10-02 15:38:17	2025-10-02 15:38:17	\N	\N	بائع 6	\N
2574	6060121	بائع 6  عموله 	1	164	\N	11	2025-10-02 15:38:17	2025-10-02 15:38:17	\N	\N	بائع 6  Commission 	\N
2575	102040122	بائع 6  عهده 	1	121	\N	11	2025-10-02 15:38:17	2025-10-02 15:38:17	\N	\N	بائع 6  Custody 	\N
2576	20415	بائع 6  استحقاق 	1	43	\N	11	2025-10-02 15:38:17	2025-10-02 15:38:17	\N	\N	بائع 6  Merit 	\N
2577	1020208	عمر	1	24	\N	61	2025-10-02 17:16:25	2025-10-02 17:16:25	\N	\N	Omar	\N
2578	60124	موظف 1	1	53	\N	11	2025-10-02 17:31:30	2025-10-02 17:36:24	\N	\N	موظف 1	\N
2580	102040123	موظف 1  عهده 	1	121	\N	11	2025-10-02 17:31:30	2025-10-02 17:36:24	\N	\N	موظف 1  Custody 	\N
2579	6060122	موظف 1  عموله 	1	164	\N	11	2025-10-02 17:31:30	2025-10-02 17:36:24	\N	\N	موظف 1  Commission 	\N
2581	20416	موظف 1  استحقاق 	1	43	\N	11	2025-10-02 17:31:30	2025-10-02 17:36:24	\N	\N	موظف 1  Merit 	\N
2582	60125	موظف 10	1	53	\N	11	2025-10-02 17:39:00	2025-10-02 17:39:00	\N	\N	موظف 10	\N
2583	6060123	موظف 10  عموله 	1	164	\N	11	2025-10-02 17:39:00	2025-10-02 17:39:00	\N	\N	موظف 10  Commission 	\N
2584	102040124	موظف 10  عهده 	1	121	\N	11	2025-10-02 17:39:00	2025-10-02 17:39:00	\N	\N	موظف 10  Custody 	\N
2585	20417	موظف 10  استحقاق 	1	43	\N	11	2025-10-02 17:39:00	2025-10-02 17:39:00	\N	\N	موظف 10  Merit 	\N
2587	104	اصل 1	1	15	..	1	2025-10-04 17:19:48	2025-10-04 17:19:48	1	\N	اصل 1	\N
2588	1020104	خزنة هبه	1	23	\N	1	2025-10-04 17:20:21	2025-10-04 17:20:21	1	\N	خزنة هبه	\N
2589	611	موظف 1	1	20	\N	1	2025-10-04 17:24:54	2025-10-04 17:24:54	1	\N	موظف 1	\N
2592	1020505	مخزن العبور	1	27	\N	1	2025-10-06 13:06:11	2025-10-06 13:06:11	\N	\N	مخزن العبور	\N
2593	1020506	مخزن اسكندرية	1	27	\N	1	2025-10-06 13:08:46	2025-10-06 13:09:30	\N	\N	مخزن اسكندرية	\N
2594	60302	سائق 1	1	97	\N	1	2025-10-06 13:22:37	2025-10-06 13:22:37	\N	\N	سائق 1	\N
2595	6060124	سائق 1  عموله 	1	164	\N	1	2025-10-06 13:22:37	2025-10-06 13:22:37	\N	\N	سائق 1  Commission 	\N
2596	102040125	سائق 1  عهده 	1	121	\N	1	2025-10-06 13:22:37	2025-10-06 13:22:37	\N	\N	سائق 1  Custody 	\N
2597	20418	سائق 1  استحقاق 	1	43	\N	1	2025-10-06 13:22:37	2025-10-06 13:22:37	\N	\N	سائق 1  Merit 	\N
2598	60126	سائق 2	1	53	\N	1	2025-10-06 13:24:21	2025-10-06 13:24:21	\N	\N	سائق 2	\N
2599	6060125	سائق 2  عموله 	1	164	\N	1	2025-10-06 13:24:21	2025-10-06 13:24:21	\N	\N	سائق 2  Commission 	\N
2600	102040126	سائق 2  عهده 	1	121	\N	1	2025-10-06 13:24:21	2025-10-06 13:24:21	\N	\N	سائق 2  Custody 	\N
2601	20419	سائق 2  استحقاق 	1	43	\N	1	2025-10-06 13:24:21	2025-10-06 13:24:21	\N	\N	سائق 2  Merit 	\N
2602	60127	سائق 2	1	53	\N	1	2025-10-06 13:25:15	2025-10-06 13:25:15	\N	\N	سائق 2	\N
2603	6060126	سائق 2  عموله 	1	164	\N	1	2025-10-06 13:25:15	2025-10-06 13:25:15	\N	\N	سائق 2  Commission 	\N
2604	102040127	سائق 2  عهده 	1	121	\N	1	2025-10-06 13:25:15	2025-10-06 13:25:15	\N	\N	سائق 2  Custody 	\N
2605	20420	سائق 2  استحقاق 	1	43	\N	1	2025-10-06 13:25:15	2025-10-06 13:25:15	\N	\N	سائق 2  Merit 	\N
2606	60128	سائق 3	1	53	\N	1	2025-10-06 13:26:16	2025-10-06 13:26:16	\N	\N	سائق 3	\N
2607	6060127	سائق 3  عموله 	1	164	\N	1	2025-10-06 13:26:16	2025-10-06 13:26:16	\N	\N	سائق 3  Commission 	\N
2608	102040128	سائق 3  عهده 	1	121	\N	1	2025-10-06 13:26:16	2025-10-06 13:26:16	\N	\N	سائق 3  Custody 	\N
2609	20421	سائق 3  استحقاق 	1	43	\N	1	2025-10-06 13:26:16	2025-10-06 13:26:16	\N	\N	سائق 3  Merit 	\N
2610	60129	سائق 4	1	53	\N	1	2025-10-06 13:26:47	2025-10-06 13:26:47	\N	\N	سائق 4	\N
2611	6060128	سائق 4  عموله 	1	164	\N	1	2025-10-06 13:26:47	2025-10-06 13:26:47	\N	\N	سائق 4  Commission 	\N
2612	102040129	سائق 4  عهده 	1	121	\N	1	2025-10-06 13:26:47	2025-10-06 13:26:47	\N	\N	سائق 4  Custody 	\N
2613	20422	سائق 4  استحقاق 	1	43	\N	1	2025-10-06 13:26:47	2025-10-06 13:26:47	\N	\N	سائق 4  Merit 	\N
2614	60130	سائق 5	1	53	\N	1	2025-10-06 13:27:18	2025-10-06 13:27:18	\N	\N	سائق 5	\N
2590	1020210	بسنت سامح	1	24	\N	11	2025-10-06 12:41:12	2025-10-18 17:11:17	\N	\N	هند حسني	\N
2591	1020211	هبة هاني	1	24	\N	11	2025-10-06 12:41:46	2025-10-18 17:11:30	\N	\N	بهبة	\N
2615	6060129	سائق 5  عموله 	1	164	\N	1	2025-10-06 13:27:18	2025-10-06 13:27:18	\N	\N	سائق 5  Commission 	\N
2616	102040130	سائق 5  عهده 	1	121	\N	1	2025-10-06 13:27:18	2025-10-06 13:27:18	\N	\N	سائق 5  Custody 	\N
2617	20423	سائق 5  استحقاق 	1	43	\N	1	2025-10-06 13:27:18	2025-10-06 13:27:18	\N	\N	سائق 5  Merit 	\N
2618	60131	عامل 1	1	53	\N	1	2025-10-06 13:28:18	2025-10-06 13:28:18	\N	\N	عامل 1	\N
2619	6060130	عامل 1  عموله 	1	164	\N	1	2025-10-06 13:28:18	2025-10-06 13:28:18	\N	\N	عامل 1  Commission 	\N
2620	102040131	عامل 1  عهده 	1	121	\N	1	2025-10-06 13:28:18	2025-10-06 13:28:18	\N	\N	عامل 1  Custody 	\N
2621	20424	عامل 1  استحقاق 	1	43	\N	1	2025-10-06 13:28:18	2025-10-06 13:28:18	\N	\N	عامل 1  Merit 	\N
2622	60132	عامل 2	1	53	\N	1	2025-10-06 13:28:51	2025-10-06 13:28:51	\N	\N	عامل 2	\N
2623	6060131	عامل 2  عموله 	1	164	\N	1	2025-10-06 13:28:51	2025-10-06 13:28:51	\N	\N	عامل 2  Commission 	\N
2624	102040132	عامل 2  عهده 	1	121	\N	1	2025-10-06 13:28:51	2025-10-06 13:28:51	\N	\N	عامل 2  Custody 	\N
2625	20425	عامل 2  استحقاق 	1	43	\N	1	2025-10-06 13:28:51	2025-10-06 13:28:51	\N	\N	عامل 2  Merit 	\N
2626	60133	عامل 3	1	53	\N	1	2025-10-06 13:29:20	2025-10-06 13:29:20	\N	\N	عامل 3	\N
2627	6060132	عامل 3  عموله 	1	164	\N	1	2025-10-06 13:29:20	2025-10-06 13:29:20	\N	\N	عامل 3  Commission 	\N
2628	102040133	عامل 3  عهده 	1	121	\N	1	2025-10-06 13:29:20	2025-10-06 13:29:20	\N	\N	عامل 3  Custody 	\N
2629	20426	عامل 3  استحقاق 	1	43	\N	1	2025-10-06 13:29:20	2025-10-06 13:29:20	\N	\N	عامل 3  Merit 	\N
2630	60134	عامل 4	1	53	\N	1	2025-10-06 13:29:43	2025-10-06 13:29:43	\N	\N	عامل 4	\N
2631	6060133	عامل 4  عموله 	1	164	\N	1	2025-10-06 13:29:43	2025-10-06 13:29:43	\N	\N	عامل 4  Commission 	\N
2632	102040134	عامل 4  عهده 	1	121	\N	1	2025-10-06 13:29:43	2025-10-06 13:29:43	\N	\N	عامل 4  Custody 	\N
2633	20427	عامل 4  استحقاق 	1	43	\N	1	2025-10-06 13:29:43	2025-10-06 13:29:43	\N	\N	عامل 4  Merit 	\N
2634	60135	عامل 5	1	53	\N	1	2025-10-06 13:30:07	2025-10-06 13:30:07	\N	\N	عامل 5	\N
2635	6060134	عامل 5  عموله 	1	164	\N	1	2025-10-06 13:30:07	2025-10-06 13:30:07	\N	\N	عامل 5  Commission 	\N
2636	102040135	عامل 5  عهده 	1	121	\N	1	2025-10-06 13:30:07	2025-10-06 13:30:07	\N	\N	عامل 5  Custody 	\N
2637	20428	عامل 5  استحقاق 	1	43	\N	1	2025-10-06 13:30:07	2025-10-06 13:30:07	\N	\N	عامل 5  Merit 	\N
2638	60136	احمد	1	53	\N	1	2025-10-07 11:34:37	2025-10-07 11:34:37	\N	\N	احمد	\N
2639	6060135	احمد  عموله 	1	164	\N	1	2025-10-07 11:34:37	2025-10-07 11:34:37	\N	\N	احمد  Commission 	\N
2640	102040136	احمد  عهده 	1	121	\N	1	2025-10-07 11:34:37	2025-10-07 11:34:37	\N	\N	احمد  Custody 	\N
2641	20429	احمد  استحقاق 	1	43	\N	1	2025-10-07 11:34:37	2025-10-07 11:34:37	\N	\N	احمد  Merit 	\N
2642	60137	تامر	1	53	\N	1	2025-10-07 11:34:55	2025-10-07 11:34:55	\N	\N	تامر	\N
2643	6060136	تامر  عموله 	1	164	\N	1	2025-10-07 11:34:55	2025-10-07 11:34:55	\N	\N	تامر  Commission 	\N
2644	102040137	تامر  عهده 	1	121	\N	1	2025-10-07 11:34:55	2025-10-07 11:34:55	\N	\N	تامر  Custody 	\N
2645	20430	تامر  استحقاق 	1	43	\N	1	2025-10-07 11:34:55	2025-10-07 11:34:55	\N	\N	تامر  Merit 	\N
2646	6060301	سيارة 1	1	2532	\N	1	2025-10-07 11:36:11	2025-10-07 11:36:11	\N	\N	سيارة 1	\N
2647	21101	استحقاق سيارة 1	1	2533	\N	1	2025-10-07 11:36:11	2025-10-07 11:36:11	\N	\N	Accrualسيارة 1	\N
2648	6060302	سيارة2	1	2532	\N	1	2025-10-07 11:37:19	2025-10-07 11:37:19	\N	\N	سيارة2	\N
2649	21102	استحقاق سيارة2	1	2533	\N	1	2025-10-07 11:37:19	2025-10-07 11:37:19	\N	\N	Accrualسيارة2	\N
2650	6060303	سيارة 3	1	2532	\N	1	2025-10-07 11:38:11	2025-10-07 11:38:11	\N	\N	سيارة 3	\N
2651	21103	استحقاق سيارة 3	1	2533	\N	1	2025-10-07 11:38:11	2025-10-07 11:38:11	\N	\N	Accrualسيارة 3	\N
2652	60138	محمد	1	53	\N	1	2025-10-07 14:38:35	2025-10-07 14:38:35	\N	\N	محمد	\N
2653	6060137	محمد  عموله 	1	164	\N	1	2025-10-07 14:38:35	2025-10-07 14:38:35	\N	\N	محمد  Commission 	\N
2654	102040138	محمد  عهده 	1	121	\N	1	2025-10-07 14:38:35	2025-10-07 14:38:35	\N	\N	محمد  Custody 	\N
2655	20431	محمد  استحقاق 	1	43	\N	1	2025-10-07 14:38:35	2025-10-07 14:38:35	\N	\N	محمد  Merit 	\N
2656	60139	خالد	1	53	\N	1	2025-10-07 14:44:34	2025-10-07 14:44:34	\N	\N	خالد	\N
2657	6060138	خالد  عموله 	1	164	\N	1	2025-10-07 14:44:34	2025-10-07 14:44:34	\N	\N	خالد  Commission 	\N
2659	20432	خالد  استحقاق 	1	43	\N	1	2025-10-07 14:44:34	2025-10-07 14:44:34	\N	\N	خالد  Merit 	\N
2660	60140	محمود	1	53	\N	1	2025-10-07 14:44:54	2025-10-07 14:44:54	\N	\N	محمود	\N
2661	6060139	محمود  عموله 	1	164	\N	1	2025-10-07 14:44:54	2025-10-07 14:44:54	\N	\N	محمود  Commission 	\N
2662	102040140	محمود  عهده 	1	121	\N	1	2025-10-07 14:44:54	2025-10-07 14:44:54	\N	\N	محمود  Custody 	\N
2663	20433	محمود  استحقاق 	1	43	\N	1	2025-10-07 14:44:54	2025-10-07 14:44:54	\N	\N	محمود  Merit 	\N
2664	6060304	سيارة 4	1	2532	\N	1	2025-10-07 14:46:00	2025-10-07 14:46:00	\N	\N	سيارة 4	\N
2665	21104	استحقاق سيارة 4	1	2533	\N	1	2025-10-07 14:46:00	2025-10-07 14:46:00	\N	\N	Accrualسيارة 4	\N
2666	1020507	مخزن الغردقة	1	27	\N	11	2025-10-07 15:40:12	2025-10-07 15:40:12	\N	\N	مخزن الغردقة	\N
2669	60141	مندوب 1	1	53	\N	11	2025-10-07 15:54:56	2025-10-07 15:54:56	\N	\N	مندوب 1	\N
2670	6060140	مندوب 1  عموله 	1	164	\N	11	2025-10-07 15:54:56	2025-10-07 15:54:56	\N	\N	مندوب 1  Commission 	\N
2671	102040141	مندوب 1  عهده 	1	121	\N	11	2025-10-07 15:54:56	2025-10-07 15:54:56	\N	\N	مندوب 1  Custody 	\N
2672	20434	مندوب 1  استحقاق 	1	43	\N	11	2025-10-07 15:54:56	2025-10-07 15:54:56	\N	\N	مندوب 1  Merit 	\N
2673	60142	مندوب قيمة	1	53	\N	11	2025-10-08 13:45:26	2025-10-08 13:53:37	\N	\N	مندوب قيمة	\N
2739	1020230	فارس 2	1	24	\N	1	2025-10-15 13:29:13	2025-10-15 13:29:13	\N	\N	فارس 2	\N
2740	1020231	تامر	1	24	\N	1	2025-10-15 13:32:07	2025-10-15 13:32:07	\N	\N	تامر	\N
2741	1020232	تصنيع	1	24	\N	1	2025-10-15 14:33:26	2025-10-15 14:33:26	\N	\N	تصنيع	\N
2742	1020233	تيست	1	24	\N	60	2025-10-16 15:08:49	2025-10-16 15:08:49	\N	\N	Henry	\N
2743	1020234	تيست	1	24	\N	60	2025-10-16 15:09:55	2025-10-16 15:09:55	\N	\N	Henry	\N
2744	1020235	تيست 2	1	24	\N	60	2025-10-16 15:17:02	2025-10-16 15:17:02	\N	\N	تيست 2	\N
2668	1020213	هاجر مجدي	1	24	\N	11	2025-10-07 15:42:38	2025-10-18 17:12:02	\N	\N	هبة 100	\N
2658	102040139	19	1	121	\N	1	2025-10-07 14:44:34	2025-10-25 02:26:16	\N	\N	19	\N
2675	102040142	مندوب قيمة  عهده 	1	121	\N	11	2025-10-08 13:45:26	2025-10-08 13:53:37	\N	\N	مندوب قيمة  Custody 	\N
2674	6060141	مندوب قيمة  عموله 	1	164	\N	11	2025-10-08 13:45:26	2025-10-08 13:53:37	\N	\N	مندوب قيمة  Commission 	\N
2676	20435	مندوب قيمة  استحقاق 	1	43	\N	11	2025-10-08 13:45:26	2025-10-08 13:53:37	\N	\N	مندوب قيمة  Merit 	\N
2691	102040145	سائق نسبة  عهده 	1	121	\N	11	2025-10-08 13:47:02	2025-10-08 14:11:37	\N	\N	سائق نسبة  Custody 	\N
2690	6060144	سائق نسبة  عموله 	1	164	\N	11	2025-10-08 13:47:02	2025-10-08 14:11:37	\N	\N	سائق نسبة  Commission 	\N
2692	20438	سائق نسبة  استحقاق 	1	43	\N	11	2025-10-08 13:47:02	2025-10-08 14:11:37	\N	\N	سائق نسبة  Merit 	\N
2713	1020512	مخزن الهدايا 2	1	27	\N	11	2025-10-13 22:37:36	2025-10-13 22:37:36	\N	\N	مخزن الهدايا 2	\N
2685	60144	سائق قيمة	1	53	\N	11	2025-10-08 13:46:43	2025-10-08 13:55:19	\N	\N	سائق قيمة	\N
2687	102040144	سائق قيمة  عهده 	1	121	\N	11	2025-10-08 13:46:43	2025-10-08 13:55:19	\N	\N	سائق قيمة  Custody 	\N
2686	6060143	سائق قيمة  عموله 	1	164	\N	11	2025-10-08 13:46:43	2025-10-08 13:55:19	\N	\N	سائق قيمة  Commission 	\N
2688	20437	سائق قيمة  استحقاق 	1	43	\N	11	2025-10-08 13:46:43	2025-10-08 13:55:19	\N	\N	سائق قيمة  Merit 	\N
2714	1020513	مخزن الهدايا 3	1	27	\N	11	2025-10-13 22:37:50	2025-10-13 22:37:50	\N	\N	مخزن الهدايا 3	\N
2715	60148	هدايا 1	1	53	\N	11	2025-10-13 22:45:42	2025-10-13 22:45:42	\N	\N	هدايا 1	\N
2716	6060147	هدايا 1  عموله 	1	164	\N	11	2025-10-13 22:45:42	2025-10-13 22:45:42	\N	\N	هدايا 1  Commission 	\N
2717	102040148	هدايا 1  عهده 	1	121	\N	11	2025-10-13 22:45:42	2025-10-13 22:45:42	\N	\N	هدايا 1  Custody 	\N
2701	6060305	سيارة الشركة	1	2532	\N	11	2025-10-08 13:56:02	2025-10-08 13:56:02	\N	\N	سيارة الشركة	\N
2702	21105	استحقاق سيارة الشركة	1	2533	\N	11	2025-10-08 13:56:02	2025-10-08 13:56:02	\N	\N	Accrualسيارة الشركة	\N
2703	6060306	سارة مؤجرة	1	2532	\N	11	2025-10-08 13:56:40	2025-10-08 13:56:40	\N	\N	سارة مؤجرة	\N
2704	21106	استحقاق سارة مؤجرة	1	2533	\N	11	2025-10-08 13:56:40	2025-10-08 13:56:40	\N	\N	Accrualسارة مؤجرة	\N
2705	6060307	سيارة سائق بقيمة	1	2532	\N	11	2025-10-08 13:57:13	2025-10-08 13:57:13	\N	\N	سيارة سائق بقيمة	\N
2706	21107	استحقاق سيارة سائق بقيمة	1	2533	\N	11	2025-10-08 13:57:13	2025-10-08 13:57:13	\N	\N	Accrualسيارة سائق بقيمة	\N
2707	6060308	سيارة سائق بنسبة	1	2532	\N	11	2025-10-08 13:57:53	2025-10-08 13:57:53	\N	\N	سيارة سائق بنسبة	\N
2708	21108	استحقاق سيارة سائق بنسبة	1	2533	\N	11	2025-10-08 13:57:53	2025-10-08 13:57:53	\N	\N	Accrualسيارة سائق بنسبة	\N
2681	60143	مندوب نسبة	1	53	\N	11	2025-10-08 13:46:28	2025-10-08 14:11:24	\N	\N	مندوب نسبة	\N
2683	102040143	مندوب نسبة  عهده 	1	121	\N	11	2025-10-08 13:46:28	2025-10-08 14:11:24	\N	\N	مندوب نسبة  Custody 	\N
2682	6060142	مندوب نسبة  عموله 	1	164	\N	11	2025-10-08 13:46:28	2025-10-08 14:11:24	\N	\N	مندوب نسبة  Commission 	\N
2684	20436	مندوب نسبة  استحقاق 	1	43	\N	11	2025-10-08 13:46:28	2025-10-08 14:11:24	\N	\N	مندوب نسبة  Merit 	\N
2689	60145	سائق نسبة	1	53	\N	11	2025-10-08 13:47:02	2025-10-08 14:11:37	\N	\N	سائق نسبة	\N
2718	20441	هدايا 1  استحقاق 	1	43	\N	11	2025-10-13 22:45:42	2025-10-13 22:45:42	\N	\N	هدايا 1  Merit 	\N
2720	1020215	كريم جديد	1	24	\N	62	2025-10-15 10:02:24	2025-10-15 10:02:24	\N	\N	كريم جديد	\N
2693	60146	عامل قيمة	1	53	\N	11	2025-10-08 13:47:18	2025-10-08 14:16:44	\N	\N	عامل قيمة	\N
2695	102040146	عامل قيمة  عهده 	1	121	\N	11	2025-10-08 13:47:18	2025-10-08 14:16:44	\N	\N	عامل قيمة  Custody 	\N
2694	6060145	عامل قيمة  عموله 	1	164	\N	11	2025-10-08 13:47:18	2025-10-08 14:16:44	\N	\N	عامل قيمة  Commission 	\N
2696	20439	عامل قيمة  استحقاق 	1	43	\N	11	2025-10-08 13:47:18	2025-10-08 14:16:44	\N	\N	عامل قيمة  Merit 	\N
2697	60147	عامل نسبة	1	53	\N	11	2025-10-08 13:47:37	2025-10-08 14:16:59	\N	\N	عامل نسبة	\N
2699	102040147	عامل نسبة  عهده 	1	121	\N	11	2025-10-08 13:47:37	2025-10-08 14:16:59	\N	\N	عامل نسبة  Custody 	\N
2698	6060146	عامل نسبة  عموله 	1	164	\N	11	2025-10-08 13:47:37	2025-10-08 14:16:59	\N	\N	عامل نسبة  Commission 	\N
2700	20440	عامل نسبة  استحقاق 	1	43	\N	11	2025-10-08 13:47:37	2025-10-08 14:16:59	\N	\N	عامل نسبة  Merit 	\N
2709	1020508	المخزن	1	27	\N	11	2025-10-13 22:36:32	2025-10-13 22:36:32	\N	\N	المخزن	\N
2710	1020509	المخزن الفرعي	1	27	\N	11	2025-10-13 22:36:52	2025-10-13 22:36:52	\N	\N	المخزن الفرعي	\N
2711	1020510	مخزن نقطة البيع	1	27	\N	11	2025-10-13 22:37:09	2025-10-13 22:37:09	\N	\N	مخزن نقطة البيع	\N
2712	1020511	مخزن الهدايا 1	1	27	\N	11	2025-10-13 22:37:23	2025-10-13 22:37:23	\N	\N	مخزن الهدايا 1	\N
2721	102010202	بنك مصر	1	29	\N	62	2025-10-15 11:42:22	2025-10-15 11:42:22	\N	\N	bank maser	\N
2722	102010203	البنك التجاري الدولي	1	29	\N	62	2025-10-15 11:43:31	2025-10-15 11:43:31	\N	\N	bank cib	\N
2723	102010204	بنك البركه	1	29	\N	62	2025-10-15 11:44:54	2025-10-15 11:44:54	\N	\N	bank elbarka	\N
2724	102010102	خزينة دولار	1	28	\N	62	2025-10-15 11:48:40	2025-10-15 11:48:40	\N	\N	USD	\N
2725	1020216	بسنت 200	1	24	\N	11	2025-10-15 12:02:33	2025-10-15 12:02:33	\N	\N	Basanet 200	\N
2726	1020217	بسنت 300	1	24	\N	11	2025-10-15 12:20:58	2025-10-15 12:20:58	\N	\N	Basanet 300	\N
2727	1020218	14	1	24	\N	11	2025-10-15 12:21:38	2025-10-15 12:21:38	\N	\N	14	\N
2728	1020219	15	1	24	\N	11	2025-10-15 12:21:42	2025-10-15 12:21:42	\N	\N	15	\N
2729	1020220	16	1	24	\N	11	2025-10-15 12:21:47	2025-10-15 12:21:47	\N	\N	16	\N
2730	1020221	17	1	24	\N	11	2025-10-15 12:21:51	2025-10-15 12:21:51	\N	\N	17	\N
2731	1020222	18	1	24	\N	11	2025-10-15 12:21:55	2025-10-15 12:21:55	\N	\N	18	\N
2732	1020223	19	1	24	\N	11	2025-10-15 12:22:00	2025-10-15 12:22:00	\N	\N	19	\N
2734	1020225	بسنت 1000	1	24	\N	11	2025-10-15 12:24:18	2025-10-15 12:24:18	\N	\N	Basanet 1000	\N
2733	1020224	بسنت 20	1	24	\N	11	2025-10-15 12:22:07	2025-10-15 12:27:39	\N	\N	20 Basanet	\N
2735	1020226	119	1	24	\N	62	2025-10-15 12:30:19	2025-10-15 12:30:19	\N	\N	119	\N
2736	1020227	تجربه	1	24	\N	60	2025-10-15 12:32:07	2025-10-15 12:32:07	\N	\N	تجربه	\N
2737	1020228	فارس	1	24	\N	1	2025-10-15 12:42:31	2025-10-15 12:42:31	\N	\N	فارس	\N
2738	1020229	هاني	1	24	\N	1	2025-10-15 12:44:17	2025-10-15 12:44:17	\N	\N	هاني	\N
2746	1020237	محمد راجي	1	24	\N	61	2025-10-16 16:18:48	2025-10-16 16:18:48	\N	\N	محمد راجي	\N
2745	1020236	مسفر عبد الله	1	24	\N	61	2025-10-16 16:18:00	2025-10-16 16:19:12	\N	\N	مسفر عبد الله	\N
2747	1020238	فواز حمد	1	24	\N	61	2025-10-16 16:20:01	2025-10-16 16:20:01	\N	\N	فواز حمد	\N
2748	1020239	كريم حلمي	1	24	\N	61	2025-10-16 16:20:32	2025-10-16 16:20:32	\N	\N	كريم حلمي	\N
2749	1020240	رانيا فهد	1	24	\N	61	2025-10-16 16:21:13	2025-10-16 16:21:13	\N	\N	رانيا فهد	\N
2750	1020241	بسمه رجب	1	24	\N	61	2025-10-16 16:21:53	2025-10-16 16:21:53	\N	\N	بسمه رجب	\N
2751	1020242	هاجر	1	24	\N	63	2025-10-16 18:26:12	2025-10-16 18:26:12	\N	\N	هاجر	\N
2752	1020243	هاجر 2	1	24	\N	66	2025-10-16 21:26:35	2025-10-16 21:26:35	\N	\N	هاجر 2	\N
2753	1020244	هاجر 3	1	24	\N	66	2025-10-16 21:37:01	2025-10-16 21:37:01	\N	\N	هاجر 3	\N
2586	1020209	محمد حامد	1	24	\N	61	2025-10-02 18:23:29	2025-10-18 17:10:38	\N	\N	عميل جديد	\N
2667	1020212	داليا عماد	1	24	\N	11	2025-10-07 15:42:13	2025-10-18 17:11:46	\N	\N	بسنت 100	\N
2719	1020214	مها أحمد	1	24	\N	62	2025-10-13 23:34:33	2025-10-18 17:12:20	\N	\N	محمود	\N
2754	60604	احمد عادل	1	824	\N	62	2025-10-19 23:05:24	2025-10-19 23:05:24	\N	\N	Ahmed adel	\N
2755	6060148	احمد عادل  عموله 	1	164	\N	62	2025-10-19 23:05:24	2025-10-19 23:05:24	\N	\N	Ahmed adel  Commission 	\N
2756	102040149	احمد عادل  عهده 	1	121	\N	62	2025-10-19 23:05:24	2025-10-19 23:05:24	\N	\N	Ahmed adel  Custody 	\N
2757	20442	احمد عادل  استحقاق 	1	43	\N	62	2025-10-19 23:05:24	2025-10-19 23:05:24	\N	\N	Ahmed adel  Merit 	\N
2758	20103	الرواد	1	37	\N	75	2025-10-20 17:39:26	2025-10-20 17:39:26	\N	\N	الرواد	\N
2759	20104	الرواد	1	37	\N	75	2025-10-20 17:39:43	2025-10-20 17:39:43	\N	\N	الرواد	\N
2760	20105	الرواد	1	37	\N	75	2025-10-20 17:40:40	2025-10-20 17:40:40	\N	\N	الرواد	\N
2789	1010301	سيارة تويوتا كرولا	1	2788	\N	61	2025-10-22 22:23:45	2025-10-22 22:23:45	10103001	\N	سيارة تويوتا كرولا	\N
2790	60150	كامل	1	53	\N	11	2025-10-23 10:56:49	2025-10-23 10:56:49	\N	\N	كامل	\N
2791	6060150	كامل  عموله 	1	164	\N	11	2025-10-23 10:56:49	2025-10-23 10:56:49	\N	\N	كامل  Commission 	\N
2792	102040151	كامل  عهده 	1	121	\N	11	2025-10-23 10:56:49	2025-10-23 10:56:49	\N	\N	كامل  Custody 	\N
2762	102010205	البنك الوطنى	1	29	\N	61	2025-10-20 23:23:55	2025-10-20 23:23:55	102010205)	\N	NBK	\N
2763	102010103	خزنة المعرض	1	28	\N	61	2025-10-20 23:26:33	2025-10-20 23:26:33	102010103	\N	خزنة المعرض	\N
2764	102010104	خزنة النثريات	1	28	\N	61	2025-10-20 23:28:17	2025-10-20 23:28:17	\N	\N	خزنة النثريات	\N
2770	1020246	فتحي الصعيدي	1	24	\N	75	2025-10-21 12:43:43	2025-10-21 12:43:43	\N	\N	F	\N
2766	60149	هاجر مجدي	1	53	\N	1	2025-10-21 12:37:33	2025-10-21 13:13:38	\N	\N	هاجر	\N
2768	102040150	هاجر مجدي  عهده 	1	121	\N	1	2025-10-21 12:37:33	2025-10-21 13:13:38	\N	\N	هاجر  Custody 	\N
2767	6060149	هاجر مجدي  عموله 	1	164	\N	1	2025-10-21 12:37:33	2025-10-21 13:13:38	\N	\N	هاجر  Commission 	\N
2769	20443	هاجر مجدي  استحقاق 	1	43	\N	1	2025-10-21 12:37:33	2025-10-21 13:13:38	\N	\N	هاجر  Merit 	\N
2771	102010206	انستا باي	1	29	\N	1	2025-10-21 13:14:15	2025-10-21 13:14:15	\N	\N	انستا باي	\N
2765	1020245	أميرة منصور	1	24	\N	1	2025-10-21 12:36:54	2025-10-21 13:27:51	\N	\N	أميرة منصور	\N
2772	1020247	عمر النشرتي	1	24	\N	62	2025-10-21 16:21:49	2025-10-21 16:21:49	\N	\N	عمر النشرتي	\N
2773	1020248	عمر النشرتي	1	24	\N	62	2025-10-21 16:32:50	2025-10-21 16:32:50	\N	\N	عمر النشرتي	\N
2775	1020249	النشرتي	1	24	\N	62	2025-10-21 16:46:01	2025-10-21 16:46:01	\N	\N	النشرتي	\N
2776	1020250	نشرتي 1	1	24	\N	60	2025-10-21 16:47:56	2025-10-21 16:47:56	\N	\N	نشرتي 1	\N
2779	1020252	حسن	1	24	\N	62	2025-10-21 17:56:04	2025-10-21 17:56:04	\N	\N	حسن	\N
2780	1020253	أمير 5	1	24	\N	60	2025-10-21 17:56:16	2025-10-21 17:56:16	\N	\N	أمير 5	\N
2793	20444	كامل  استحقاق 	1	43	\N	11	2025-10-23 10:56:49	2025-10-23 10:56:49	\N	\N	كامل  Merit 	\N
2777	1020251	امير	1	24	\N	1	2025-10-21 17:46:01	2025-10-21 18:44:05	\N	\N	amir	\N
2781	1020254	احمد	1	24	\N	62	2025-10-21 18:46:09	2025-10-21 18:46:09	\N	\N	احمد	\N
2782	1020255	محمد	1	24	\N	62	2025-10-21 18:49:32	2025-10-21 18:49:32	\N	\N	محمد	\N
2783	1020256	هاجر 500	1	24	\N	11	2025-10-21 18:51:49	2025-10-21 18:51:49	\N	\N	هاجر 500	\N
2784	1020257	رضا	1	24	\N	62	2025-10-21 18:52:06	2025-10-21 18:52:06	\N	\N	رضا	\N
2786	1020259	حسن 2	1	24	\N	62	2025-10-22 11:35:50	2025-10-22 11:35:50	\N	\N	حسن 2	\N
2787	1020260	هنري	1	24	\N	61	2025-10-22 14:27:08	2025-10-22 14:27:08	\N	\N	Henry	\N
2788	10103	السيارات	0	21	\N	61	2025-10-22 22:14:39	2025-10-22 22:17:08	10103	\N	السيارات	\N
2785	1020258	حسام	1	24	\N	61	2025-10-21 22:35:21	2025-10-23 17:06:24	\N	\N	حسام	\N
2794	1020261	ايميل	1	24	\N	60	2025-10-25 02:28:58	2025-10-25 02:28:58	\N	\N	ايميل	\N
2795	1020262	تجربه ايميل	1	24	\N	62	2025-10-25 02:31:18	2025-10-25 02:31:18	\N	\N	تجربه ايميل	\N
2796	1020263	كريم حلمي	1	24	\N	63	2025-10-25 08:55:39	2025-10-25 08:55:39	\N	\N	كريم حلمي	\N
2797	612	الفواتير	0	20	\N	1	2025-10-26 14:58:48	2025-10-26 14:58:48	\N	\N	الفواتير	\N
2798	61201	فاتورة كهرباء	1	2797	\N	1	2025-10-26 14:59:19	2025-10-26 14:59:19	\N	\N	فاتورة كهرباء	\N
2799	1020264	عماد الدين	1	24	\N	1	2025-10-26 15:07:53	2025-10-26 15:07:53	\N	\N	Emad El Din	\N
\.


--
-- Data for Name: accounts_default_data; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.accounts_default_data (id, "Draw", "Coin", created_at, updated_at, "Sure_Recipts", "Show_Group", "Account_Balance", "Salary", "Commission", "Coin_Show", "Cost_Show", "Draw_Show", "Collect_Show", "Sales_Bill_Show", "Hide_Edit_Delete", "Order_Number", "Tax_Show", "Cost_Center_Show") FROM stdin;
2	1	4	2021-08-13 16:44:14	2025-10-26 15:29:15	0	0	1	2	2	1	0	1	0	0	0	1	0	0
\.


--
-- Data for Name: activites; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.activites (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
8	تجاري	Commercial	2022-04-13 02:50:04	2024-02-09 00:52:30
9	صناعي	صناعي	2025-10-02 15:24:13	2025-10-02 15:24:13
10	مطعم	مطعم	2025-10-26 14:53:21	2025-10-26 14:53:21
11	فندق	فندق	2025-10-26 14:53:32	2025-10-26 14:53:32
12	فيلا	فيلا	2025-10-26 14:53:45	2025-10-26 14:53:45
13	مجمع سكني	مجمع سكني	2025-10-26 14:54:01	2025-10-26 14:54:01
\.


--
-- Data for Name: add_translates; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.add_translates (id, "Code", "Date", "Client", "Client_Type", "From_Lang", "To_Lang", "Company", "Num_Translted_Word", "ID_Name", "ID_Profession", "ID_Martial_Status", "Passport_Name", "Passport_Profession", "Passport_Martial_Status", "Extracted", "Extracted_Birthplace", "Extracted_Issuer", "CommercialRegistration", "Commercial_Name", "Commercial_Type", "Commercial_Start_Date", "Commercial_Number", "Commercial_Capital", "Commercial_Issuer", "Commercial_Address", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: additional_products; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.additional_products (id, "Additional_Product", "Product", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: addressses; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.addressses (id, "Address_Name", "Street", "Special_Mark", "Buliding", "Floor", "Flat", "Details", "Location", "Governrate", "City", "Place", "Customer", created_at, updated_at, "Lat", "Lng") FROM stdin;
15	عنوان البيت	الشعراوي	بجوار المسجد	105	102	502	32 شارع ميدان التحرير أسفل كوبري القائد محمد ابراهيم الي حرر سيناء العظيمة سنة 1973 ميلادي في العاشر من رمضان	\N	2	1	6	4	2025-10-02 17:16:25	2025-10-02 17:16:25	\N	\N
55	ععللل	ييييييييي	\N	\N	\N	\N	\N	\N	2	1	6	18	2025-10-23 11:51:28	2025-10-23 12:33:29	\N	\N
58	ررررررر	\N	\N	\N	\N	\N	\N	\N	2	1	6	18	2025-10-23 14:41:43	2025-10-23 14:41:43	\N	\N
18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	11	2025-10-15 10:02:24	2025-10-15 10:02:24	\N	\N
19	عنوان العمل	11	55	22	33	44	77	66	2	1	6	12	2025-10-15 12:02:33	2025-10-15 12:02:33	\N	\N
20	البيت	101	105	102	103	104	107	106	2	1	6	13	2025-10-15 12:20:58	2025-10-15 12:20:58	\N	\N
23	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	22	2025-10-15 12:30:19	2025-10-15 12:30:19	\N	\N
24	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	23	2025-10-15 12:32:07	2025-10-15 12:32:07	\N	\N
25	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	29	2025-10-16 15:08:49	2025-10-16 15:08:49	\N	\N
26	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	30	2025-10-16 15:09:55	2025-10-16 15:09:55	\N	\N
27	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	31	2025-10-16 15:17:02	2025-10-16 15:17:02	\N	\N
28	عنوان العمل	\N	\N	\N	\N	\N	\N	\N	2	1	6	33	2025-10-16 16:18:48	2025-10-16 16:18:48	\N	\N
29	عنوان البيت	\N	\N	\N	\N	\N	\N	\N	5	9	5	32	2025-10-16 16:19:12	2025-10-16 16:19:12	\N	\N
30	عنوان الشاليه	\N	\N	\N	\N	\N	\N	\N	5	9	5	34	2025-10-16 16:20:01	2025-10-16 16:20:01	\N	\N
31	عنوان العمل	\N	\N	\N	\N	\N	\N	\N	5	9	5	35	2025-10-16 16:20:32	2025-10-16 16:20:32	\N	\N
32	عنوان البيت	\N	\N	\N	\N	\N	\N	\N	7	11	8	36	2025-10-16 16:21:13	2025-10-16 16:21:13	\N	\N
33	عنوان العمل	\N	\N	\N	\N	\N	\N	\N	5	9	5	37	2025-10-16 16:21:53	2025-10-16 16:21:53	\N	\N
34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	39	2025-10-16 21:26:35	2025-10-16 21:26:35	\N	\N
35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	40	2025-10-16 21:37:01	2025-10-16 21:37:01	\N	\N
36	عنوان البيت 1	شارع الشباب	بجوار شركة براعة	502	5	503	عمارة 502 شارع الشباب بجوار محل عصير قصب التيسير	\N	2	1	6	5	2025-10-18 17:10:38	2025-10-18 17:10:38	\N	\N
37	العنوان الرئيسي	القاهرة	بجوار المسجد	500	5	10	كتابة العنوان بالتفصيل الممل	\N	5	9	5	10	2025-10-18 17:12:20	2025-10-18 17:12:20	\N	\N
38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	43	2025-10-21 16:21:49	2025-10-21 16:21:49	\N	\N
39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	44	2025-10-21 16:32:50	2025-10-21 16:32:50	\N	\N
40	\N	\N	\N	\N	\N	\N	\N	\N	6	10	5	45	2025-10-21 16:46:01	2025-10-21 16:46:01	\N	\N
41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	46	2025-10-21 16:47:56	2025-10-21 16:47:56	\N	\N
42	العبور	1	١	١	١	١	.........	\N	2	11	8	48	2025-10-21 17:56:04	2025-10-21 17:56:04	30.254224	31.4699163
43	عنوان البريد	الشعرواي	بجوار المسجد	100	11	101	العنوان بالتفصيل	\N	7	11	13	49	2025-10-21 17:56:16	2025-10-21 17:56:16	30.254223	31.4699042
45	عنوان البيت	5	5	5	5	5	5	5	7	11	8	47	2025-10-21 18:44:05	2025-10-21 18:44:05	\N	\N
46	العبور	١	١	١	١	١	١١	\N	2	11	9	50	2025-10-21 18:46:09	2025-10-21 18:46:09	30.254221	31.469911
47	العبور	١	١	١	١	١	٠٠٠٠	\N	7	11	9	51	2025-10-21 18:49:32	2025-10-21 18:49:32	30.25422	31.4699124
48	العبور	١	١	١	١	١	١١١١	\N	2	11	9	53	2025-10-21 18:52:06	2025-10-21 18:52:06	30.2542284	31.4699109
21	البيت	11	55	22	33	44	\N	66	2	1	6	21	2025-10-15 12:24:18	2025-10-23 17:44:29	30.774654	31.0227437
53	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	55	2025-10-22 11:35:50	2025-10-22 11:35:50	\N	\N
54	العنوان	تاريخ	\N	\N	\N	\N	\N	\N	7	11	9	20	2025-10-23 11:38:17	2025-10-23 11:38:17	\N	\N
59	ءسءءء	\N	\N	\N	\N	\N	\N	\N	2	1	6	18	2025-10-23 14:46:25	2025-10-23 14:46:25	37.4219983	-122.084
64	\N	\N	\N	\N	\N	\N	\N	\N	2	1	6	57	2025-10-25 02:28:58	2025-10-25 02:28:58	\N	\N
65	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	58	2025-10-25 02:31:18	2025-10-25 02:31:18	\N	\N
63	55	55	55	55	55	55	5555555	55	5	9	5	54	2025-10-23 17:06:24	2025-10-23 17:06:24	\N	\N
62	عنوان العمل	شارع طه حسين	بجوار محل عصير القصب	5008	1	203	\N	\N	2	1	6	54	2025-10-23 17:06:24	2025-10-23 17:07:34	30.2542282	31.4699148
66	تجربه	\N	\N	\N	\N	\N	\N	\N	6	10	7	24	2025-10-25 03:12:08	2025-10-25 03:12:12	30.7746511	31.0227159
57	1	\N	\N	\N	\N	\N	\N	\N	2	1	6	19	2025-10-23 12:15:13	2025-10-23 17:38:32	30.7746525	31.0227391
22	البيت	11	55	22	33	44	\N	66	2	1	6	20	2025-10-15 12:27:39	2025-10-25 03:40:52	37.4219983	-122.084
14	احمد	\N	\N	\N	\N	\N	\N	\N	2	1	6	1	2025-10-02 16:47:27	2025-10-25 03:41:25	37.4219983	-122.084
67	عنوان العمل	الشعراوي	بجوار ميدان براعة	508	5	506	العنوان بالتفصيل \n5 شارع	\N	7	11	8	54	2025-10-25 08:51:40	2025-10-25 08:51:40	24.7434998	46.8379486
68	عنوان المنزل	التحلية	بجوار شركة رابح	800	1	101	العنوان	\N	5	9	5	59	2025-10-25 08:55:39	2025-10-25 08:55:39	24.743457	46.837941
56	تيست	عررر	زززز	غغ	غغ	ثقق	تجربه العنوان بالتفصيل	\N	9	13	12	20	2025-10-23 12:08:52	2025-10-25 15:30:00	5555.0	22222.0
69	فيلا 1	التحلية	بجوار محل كذا	500	1	1	\N	\N	5	9	5	60	2025-10-26 15:07:53	2025-10-26 15:07:53	\N	\N
70	فيلا 2	الأمير فواز	بجوار مسجد الصحابة	709	2	5	\N	\N	10	14	14	60	2025-10-26 15:07:53	2025-10-26 15:07:53	\N	\N
\.


--
-- Data for Name: admins; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.admins (id, email, name, password, image, phone, hidden, emp, ship, vend, status, remember_token, created_at, updated_at, cli, lat, long, account, safe, store, type, roles_name, code, token, price_sale, discount, price_1, price_2, price_3, pos_pay, executor, cost_price, price_level, guest, pos_stores, pos_hold, cost_price_purch, cost_price_sales, manu_order_precent, pos_product, "Cash", "Later", "Check", "Installment", "Cash_Visa", "Cash_Collection", "Delivery", "InstallmentCompanies", "Date", ticket_price, ticket_discount, "nameEn", package, job_order_price, "Visa_Network", bill_discount, pos_safes, expire, expire_type, attend_date, bank, "Apps") FROM stdin;
45	GuestO@test.com	Guest	$2y$10$0DrRyqpJGzxh8sY5lqK8g.u4XXo9VNUUx24bqWiGuFCGidiEF6EvO	AdminsImages/FCad1Zo5eARHkj6f1DwJ.png	23123	1	0	0	0	0	\N	2021-12-14 17:23:09	2024-12-04 22:09:46	0	\N	\N	0	\N	\N	Admin	Guest	\N	\N	0	0	\N	\N	\N	0	\N	0	1	1	0	0	0	0	0	0	\N	\N	\N	\N	\N	\N	\N	\N	0	0	0	1	1	0	\N	0	0	\N	0	\N	\N	\N
46	GuestTw@test.com	Guest T	$2y$10$PvmLA3AHV4DfzXMI2Y3HP.Is4Ulyd0NZU9dasKtR.J4kOOgYxO7EK	AdminsImages/ql9kcuPqE6pjB743YQBg.png	12313	1	0	0	0	0	\N	2021-12-14 17:24:12	2024-12-04 22:09:57	0	\N	\N	0	\N	\N	Admin	Guest	\N	\N	0	0	\N	\N	\N	0	\N	0	2	1	0	0	0	0	0	0	\N	\N	\N	\N	\N	\N	\N	\N	0	0	0	2	1	0	\N	0	0	\N	0	\N	\N	\N
47	GuestTh@test.com	GuestTh	$2y$10$AhaiV.Ao3D236mryP91C4uF.2C/7Ri33vHNN1nn6dF9M1/YCM8vn2	AdminsImages/C1WJh3cJRQs8sOwJarNc.png	31123	1	0	0	0	0	\N	2021-12-14 17:24:51	2024-12-04 22:10:07	0	\N	\N	0	\N	\N	Admin	Guest	\N	\N	0	0	\N	\N	\N	0	\N	0	3	1	0	0	0	0	0	0	\N	\N	\N	\N	\N	\N	\N	\N	0	0	0	3	1	0	\N	0	0	\N	0	\N	\N	\N
59	support@rabih.com	Support	$2y$10$KsfE6rtZQAyfCeLnkhHjtOULZ8gAwLi8b23eGoWKLDl3ZKX8KUQzG	\N	\N	1	0	0	0	0	\N	2025-05-12 09:11:50	2025-10-02 14:30:24	0	\N	\N	0	\N	\N	Admin	Owner	\N	\N	0	0	\N	\N	\N	0	\N	0	\N	\N	0	0	0	0	0	0	\N	\N	\N	\N	\N	\N	\N	\N	0	0	0	Support	10	0	\N	0	0	\N	0	\N	\N	\N
66	b@1	بياع 1	$2y$10$B4vcOOAEe0hhhfEDBfdd4OfZ1VXUAoR6/w8QMTmBH7HPFBDCl9K8O	\N	\N	0	48	0	0	0	\N	2025-10-02 15:57:29	2025-10-15 17:04:06	0	\N	\N	53	30	21	Emp	Owner	\N	xD7iQjOdK3wWVIi4vlL5bR90FDepPsU8XePNcaVNNEgv48ord8db0fEqvDpjgjRESM4jBqS4DUfdQDdLMDVdGYxP7t3xhXjPEhVT	1	1	1	1	1	1	48	1	\N	\N	1	1	1	1	1	1	1	1	\N	\N	1	1	1	\N	1	1	1	بياع 1	10	1	\N	1	1	\N	\N	\N	32	1
65	t@5	طيار 5	$2y$10$NY.fT19BNqv07n2.Qc6a1ebp/nymSeW0ci8CbzUy6tqxgySYVwIxe	\N	\N	0	47	0	0	0	\N	2025-10-02 15:56:03	2025-10-02 15:57:40	0	\N	\N	53	30	21	Emp	Owner	\N	\N	1	1	1	1	1	1	47	1	\N	\N	1	1	1	1	1	1	1	1	\N	\N	1	1	1	\N	1	1	1	طيار 5	10	1	\N	1	1	\N	\N	\N	32	1
64	t@4	طيار 4	$2y$10$6xLZWI0UVry7GBGSzN91juIkC2fmxJc3Dapztfiy0A3qomzZsbRei	\N	\N	0	46	0	0	0	\N	2025-10-02 15:51:52	2025-10-02 15:57:49	0	\N	\N	53	30	21	Emp	Owner	\N	\N	1	1	1	1	1	1	46	1	\N	\N	1	1	1	1	1	1	1	\N	\N	\N	1	\N	1	\N	1	1	1	طيار 4	10	1	1	1	1	\N	\N	\N	32	1
61	t@2	طيار 2	$2y$10$KGMOr8a8aKlWQj52oGPSlO/4LaV7EGREUBiG3ilRBSUo9kTabZPRG	\N	\N	0	44	0	0	0	\N	2025-10-02 15:44:19	2025-10-25 09:06:29	0	29.338426	48.0333889	53	30	21	\N	Owner	\N	DXUuzrIRQF5zdBPH0r2reiWmRIDJPeeOkeX31E9AlQHiBWZbnkxk1A0y6AwwhCNwLqd7lQMxq0YeFCSmYsJtywH6WnH19weybdo4	1	1	1	\N	1	1	44	1	\N	\N	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	طيار 2	1	1	1	1	1	\N	0	2025-10-07	32	1
70	b@6	بياع 6	$2y$10$TxoDrxBFs5XLJP6uP9zSHOqvbcaGm3A1i4uxjCt2Y7cls95rp61.q	\N	\N	0	52	0	0	0	\N	2025-10-02 16:02:36	2025-10-02 16:02:48	0	\N	\N	53	30	21	Emp	Owner	\N	\N	1	1	1	1	1	1	52	1	\N	\N	1	1	1	1	1	1	1	1	\N	\N	1	1	1	\N	1	1	1	بياع 6	10	1	1	1	1	\N	\N	\N	32	1
67	b@2	بياع 2	$2y$10$aFw2LlqkeETg/wjt3wLhFuJ8TBRYlFNJyEMXoHe3ABXcjrZloJyWi	\N	\N	0	49	0	0	0	\N	2025-10-02 15:59:26	2025-10-02 16:02:56	0	\N	\N	53	30	21	Emp	Owner	\N	\N	1	1	1	1	1	1	49	1	\N	\N	1	1	1	1	1	1	1	1	\N	\N	1	1	1	\N	1	1	1	بياع 2	10	1	1	1	1	\N	\N	\N	32	1
68	b@3	بياع 3	$2y$10$qGkAxIKwEpC0Xph6LdLt5.WzU6REEoJPPd7qDUP6k5U3XG40VBp56	\N	\N	0	50	0	0	0	\N	2025-10-02 16:00:28	2025-10-02 16:03:04	0	\N	\N	53	30	21	Emp	Owner	\N	\N	1	1	1	1	1	1	50	1	\N	\N	1	1	1	1	1	1	1	1	\N	\N	1	1	1	\N	1	1	1	بياع 3	10	1	\N	1	1	\N	\N	\N	32	1
69	b@4	بياع 4	$2y$10$phWvDP1ptQHcj3Lu5VnGDevBxZn3z5rWdAXI.S52vGdwsOziAPISy	\N	\N	0	51	0	0	0	\N	2025-10-02 16:01:36	2025-10-02 16:03:13	0	\N	\N	53	30	21	Emp	Owner	\N	\N	1	1	1	1	1	1	51	1	\N	\N	1	1	1	1	1	1	1	1	\N	\N	1	1	1	\N	1	1	1	بياع 4	10	1	\N	1	1	\N	\N	\N	32	1
75	sayd@rabih.com	سدي	$2y$10$mX/b774Z8CDbpmkCymk4iu9J6Ur2IU9W/kveF9Q0WzwxyI/w3bOn2	\N	\N	0	0	0	0	0	\N	2025-10-20 12:25:30	2025-10-20 12:25:30	0	\N	\N	0	\N	\N	Admin	Owner	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	سدي	1	\N	\N	\N	\N	\N	0	\N	\N	\N
71	m@m	موظف 1	$2y$10$I6WvbiR2fS7gFw0ebze7T.kZ2X9aWko6sUstVsrgZQr.YDmtOBvtK	\N	\N	0	53	0	0	0	\N	2025-10-02 17:32:30	2025-10-02 17:39:13	0	\N	\N	53	30	21	Emp	Owner	\N	\N	1	1	\N	1	1	1	53	1	\N	\N	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	موظف 1	1	1	1	1	1	\N	0	2025-10-02	30	1
60	t@1	طيار 1	$2y$10$lcC3GeOHR0fzFTZGu/Vb5uD0s9L.54s4VFajcFHIe6R2u3nobDacO	\N	\N	0	43	0	0	0	\N	2025-10-02 15:39:39	2025-10-25 03:40:24	0	\N	\N	53	30	21	Emp	Owner	\N	oJrzWnhZylpfrLfAkLe0qzENUSTLIiV01kC5tp1cxvP5gJptpMhpQF3XhaExWYkhfPtYvRY3cnn2QudpxRYtp5ddFh4i4kZT58yF	1	1	1	1	\N	1	43	1	\N	\N	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	0	0	كريم حلمي	1	1	1	1	1	\N	0	\N	30	1
63	t@3	طيار 3	$2y$10$WiVFeyh30Ak0SlVr/FQHO.4IBDfZPH4o1.aQiwTau2xHhxltLnfN.	\N	\N	0	45	0	0	0	\N	2025-10-02 15:50:27	2025-10-25 07:52:28	0	\N	\N	53	30	21	Emp	Owner	\N	2vTzUowOxsEiNPWC74MuzRfSopKLMhrfitixfkReCXjMyzfo4dEMcv9eDuEI0A4BBl414dfLw9C6SIYS1CnghJCnThBJURRrgnMX	1	1	1	1	1	1	45	1	\N	\N	1	1	1	1	1	1	1	1	\N	\N	1	1	1	\N	1	1	1	طيار 3	10	1	1	1	1	\N	\N	\N	32	1
62	b@r	براعة	$2y$10$x92to3n3mMrF0vbSmZsf9OLqQHxTgiEAt9t.C8q6kerlQdl0zA2Ka	\N	\N	0	38	0	0	0	\N	2025-10-02 15:46:29	2025-10-25 02:12:00	0	30.2542227	31.4699179	53	30	21	Emp	Owner	\N	TddK3Rucq0Sqvis6dDn3olcIFPbrfXAgFJrpHFBQCbPOo5356RuxsWnOGi9oCvcFnqZh7QOM1GmYhF2VQ6Dt0GIlZ8wgqKTOanK4	1	1	1	1	1	1	38	1	\N	\N	1	1	1	1	1	1	1	1	\N	\N	1	1	1	\N	1	1	1	براعة	10	1	1	1	1	\N	\N	\N	32	1
74	h1@h1	هدايا 1	$2y$10$3W96KLbQUdZinkSoEI3tV.rZMm0EdNh1uCjrx5XaRgbifSd9xn9Ky	\N	\N	0	79	0	0	0	\N	2025-10-13 22:48:54	2025-10-24 00:48:51	0	30.2568326	31.4792479	53	30	7	Emp	Owner	\N	dChHN4ophnQc7wXB8GuF7YT70tFSUZXKDFiVDnf4WzRA7JehKuIMlUEMAsTMHRn5TYJnX2nU92p3CaRmXFm2c6LfH7e3D92hrulw	1	1	1	1	\N	1	79	0	\N	\N	0	1	0	0	0	1	1	1	\N	\N	\N	\N	\N	\N	1	0	0	هدايا 1	1	0	\N	1	0	\N	0	\N	32	\N
72	mm@mm	موظف 10	$2y$10$XZa8EBGF42HfN74aD13ELOuEgWfTAqrnIctmAK.VGgL9orPtp8fWu	\N	\N	0	54	0	0	0	\N	2025-10-02 17:40:11	2025-10-04 17:45:03	0	\N	\N	53	30	21	Emp	Owner	\N	\N	1	1	1	1	1	1	54	1	\N	\N	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	موظف 10	1	1	1	1	1	\N	0	2025-10-02	32	1
73	heba@rabih.com	هبه	$2y$10$/VXBgN5dAz.yEn1fmaXaZeHHKBYn810xxNBf6lQkjYMpnqjj20jja	\N	\N	0	0	0	0	0	\N	2025-10-11 19:56:26	2025-10-11 19:56:26	0	\N	\N	0	\N	\N	Admin	Owner	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	Heba	1	\N	\N	\N	\N	\N	0	\N	\N	\N
76	k1@k1	كامل	$2y$10$sFP2ywO6mSTNWx1YSa486.UGijLI2MSbU2rIokMlwwA5ZT53tV/Y.	\N	\N	0	82	0	0	0	\N	2025-10-23 10:58:16	2025-10-25 03:10:24	0	\N	\N	53	30	21	Emp	بدون جدول الزيارات	\N	a77vFkauek0AbQTM3AKirf36vznVNIOpWFVOtTp8XPL0KsTWPpozPqx9He6pyovUIZxuTweTrKJbpheP8ROjFU2z6w57AEbyan0F	1	1	1	1	1	1	82	1	\N	\N	0	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	Kamil	1	1	1	1	0	\N	0	\N	32	1
11	Klar@test.com	Admin	$2y$10$QnqbBX6.vzR3f.jtAVDl9.grQaOWASw8IxcoJcma4GX0nFaJ3GJga	AdminsImages/zUmg7MdzbQVBLGEt0WE7.png	01062201060	1	0	0	0	0	\N	2021-08-08 10:29:23	2025-10-17 15:59:31	0	\N	\N	0	\N	\N	Admin	Owner	\N	\N	0	0	\N	\N	\N	0	\N	0	\N	\N	0	0	0	0	0	0	\N	\N	\N	\N	\N	\N	\N	\N	0	0	0	Admin	11	0	\N	0	0	\N	0	\N	\N	\N
1	admin@rabih.com	Admin	$2y$10$Du3oWudJWDmcAAOj0NvRR.7skrwMZvaOm2WiChLu68irl.aH5eRZu	AdminsImages/PDk0eltFIlYtSRmI0XwM.png	01062201060	1	0	0	0	0	\N	\N	2025-10-17 15:59:42	0	\N	\N	0	\N	\N	Admin	Owner	\N	\N	0	0	\N	\N	\N	0	\N	0	\N	\N	0	0	0	0	0	0	\N	\N	\N	\N	\N	\N	\N	\N	0	0	0	Admin	11	0	\N	0	0	\N	0	\N	\N	\N
\.


--
-- Data for Name: all_groups; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.all_groups (id, "Group", created_at, updated_at, "Name") FROM stdin;
\.


--
-- Data for Name: allowences_emps; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.allowences_emps (id, "AmountAllow", "Allow", "Emp", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: apps_change_prices; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.apps_change_prices (id, "App", "Product", "Price_One", "Price_Two", "Price_Three", created_at, updated_at, "Barcode") FROM stdin;
\.


--
-- Data for Name: articles; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.articles (id, "Image", "Sub_Image", "Date", "Arabic_Title", "English_Title", "Arabic_Desc", "English_Desc", created_at, updated_at) FROM stdin;
1	ArticlesImages/Tc4BdtjP1euOSuW9OmoC.jpeg	ArticlesImages/8pWQWSpnZFPjdliv8uuk.jpeg	May 02, 2017	It's all about how you wear	It's all about how you wear	On sait depuis longtemps que travailler avec du texte lisible et contenant du sens est source de distractions, et empêche de se concentrer sur la mise en page elle-même. L'avantage du Lorem Ipsum sur un texte générique comme 'Du texte. Du texte. Du texte.' est qu'il possède une distribution de lettres plus ou moins normale, et en tout cas comparable avec celle du français standard. De nombreuses suites logicielles de.\r\n\nLorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.\r\n\nSample Text Listing\r\n\nDonec et lacus mattis ipsum feugiat interdum non id sapien.\r\n\nQuisque et mauris eget nisi vestibulum rhoncus molestie a ante.\r\n\nCurabitur pulvinar ex at tempus sodales.\r\n\nMauris efficitur magna quis lectus lobortis venenatis.\r\n\nNunc id enim eget augue molestie lobortis in a purus.\r\n\nDonec maximus quam at lectus bibendum, non suscipit nunc tristique.\r\n\nThe standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.	On sait depuis longtemps que travailler avec du texte lisible et contenant du sens est source de distractions, et empêche de se concentrer sur la mise en page elle-même. L'avantage du Lorem Ipsum sur un texte générique comme 'Du texte. Du texte. Du texte.' est qu'il possède une distribution de lettres plus ou moins normale, et en tout cas comparable avec celle du français standard. De nombreuses suites logicielles de.\r\n\nLorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.\r\n\nSample Text Listing\r\n\nDonec et lacus mattis ipsum feugiat interdum non id sapien.\r\n\nQuisque et mauris eget nisi vestibulum rhoncus molestie a ante.\r\n\nCurabitur pulvinar ex at tempus sodales.\r\n\nMauris efficitur magna quis lectus lobortis venenatis.\r\n\nNunc id enim eget augue molestie lobortis in a purus.\r\n\nDonec maximus quam at lectus bibendum, non suscipit nunc tristique.\r\n\nThe standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.	2022-06-04 15:34:21	2022-06-04 15:34:21
2	ArticlesImages/hFg38z7lhXhdL5p3YGS4.jpeg	ArticlesImages/0JIkTM2ovwsZJsVLPTag.jpeg	May 02, 2017	IT'S ALL ABOUT HOW YOU WEAR	IT'S ALL ABOUT HOW YOU WEAR	qweqweqwe	qweqeqweqwe	2022-06-06 20:02:53	2022-06-06 20:02:53
\.


--
-- Data for Name: assembly_products; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.assembly_products (id, "Qty", "Price", "Total", "P_Ar_Name", "P_En_Name", "P_Code", "Unit", "Product", p_id, created_at, updated_at) FROM stdin;
1	1	100	100	خشب	خشب	290622	10	3	4	2025-10-02 14:37:48	2025-10-02 14:37:48
2	1	100	100	عصير	عصير	189705	10	1	4	2025-10-02 14:37:48	2025-10-02 14:37:48
3	3	100	300	رمان	رمان	653520	10	7	8	2025-10-02 14:41:06	2025-10-02 14:41:06
4	2	100	200	عصير	عصير	189705	10	1	8	2025-10-02 14:41:06	2025-10-02 14:41:06
\.


--
-- Data for Name: assets; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.assets (id, "Code", "Name", "Asset_Type", "Depreciation_Method", "Purchases_Date", "Operation_Date", "Cost", "Previous_Depreciation", "Asset_Net", "Annual_Depreciation_Ratio", "Annual_Depreciation", "Life_Span", "Image", "Note", "Depreciation_Expenses", "Depreciation_Complex", "Main_Account", "Account", "User", created_at, updated_at, "Draw", "Coin", "Cost_Center", "Branch", "Sort_Asset", "Vendor", "Safe", "Ehlak", "Payment_Method", "M1", "M2", "M3", "M4", "M5", "M6", "M7", "M8", "M9", "M10", "M11", "M12", "NameEn", "Asset_Type_En", "Depreciation_Method_En", arr, "Delete", "Sale", "Amount", "Client", "CurrentAssetPrice", "Last_Depreciation_Month") FROM stdin;
\.


--
-- Data for Name: assets_expenses; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.assets_expenses (id, "Code", "Date", "Name", "Draw", "Amount", "Asset", "Safe", "Coin", "Cost_Center", "User", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: attend_departure_import; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.attend_departure_import (id, "In_Time", "Out_Time", "Date", "Month", "Note", "Attend", "Emp", created_at, updated_at) FROM stdin;
1	7:30	16:30	01-01-2024	45292	\N	3	33	\N	\N
2	8:30	17:30	01-01-2024	45292	\N	3	34	\N	\N
\.


--
-- Data for Name: attendance_emps; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.attendance_emps (id, "In_Time", "Date", "Month", "Note", "Attend", "Emp", created_at, updated_at) FROM stdin;
7	17:34	2025-10-02	2025-10	\N	3	53	2025-10-02 17:34:32	2025-10-02 17:34:32
8	17:44	2025-10-02	2025-10	\N	3	54	2025-10-02 17:44:08	2025-10-02 17:44:08
9	17:10	2025-10-07	2025-10	\N	4	44	2025-10-07 17:10:30	2025-10-07 17:10:30
\.


--
-- Data for Name: attendances; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.attendances (id, "Code", "Date", "Month", "Note", "User", created_at, updated_at, "Status", arr) FROM stdin;
3	1	2025-10-02	2025-10	\N	1	\N	\N	1	\N
4	2	2025-10-07	2025-10	\N	1	\N	\N	1	\N
\.


--
-- Data for Name: attendence_policy_emps; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.attendence_policy_emps (id, "From", "To", "Discount", "Emp", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: barcode_products; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.barcode_products (id, "Name", "Code", "Qty", "Price", "Product", "V1", "V2", "Unit", created_at, updated_at, "Group") FROM stdin;
\.


--
-- Data for Name: barcode_settings; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.barcode_settings (id, "Code", "Name", "Type", "Direction", "Width", "Height", "Padding_L", "Padding_R", "Padding_T", "Padding_B", "Margin_L", "Margin_R", "Margin_T", "Margin_B", "Barcode_Width", "Barcode_Height", "Font_Size", "Line_Height", created_at, updated_at, "Height_Logo", "Width_Logo", "NameEn", arr) FROM stdin;
6	2	الطباعة الافتراضية	2	1	3.8	2.5	.5	.5	.5	.5	.5	.5	.5	.5	3	0.5	6	4	2022-03-09 09:57:35	2024-02-09 00:42:34	0	0	Default Print	\N
\.


--
-- Data for Name: barcode_shows; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.barcode_shows (id, "Company_Name", "Product_Name", "Product_Price", "Unit", "Coin", "Group", created_at, updated_at, "Code", "Logo") FROM stdin;
1	1	\N	\N	\N	\N	\N	2022-03-31 18:05:19	2022-03-31 18:05:19	\N	\N
2	1	1	\N	\N	\N	\N	2022-03-31 18:05:19	2022-03-31 18:05:19	\N	\N
3	1	1	1	\N	\N	\N	2022-03-31 18:05:19	2022-03-31 18:05:19	\N	\N
4	1	1	1	\N	\N	\N	2022-03-31 18:05:19	2022-03-31 18:05:19	1	\N
\.


--
-- Data for Name: befroe_footers; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.befroe_footers (id, "Image", "Arabic_Title", "Arabic_Desc", "English_Title", "English_Desc", created_at, updated_at) FROM stdin;
2	<i class="icon anm anm-credit-card-front-r"></i>	SECURE PAYMENTS	All payment are Secured and trusted.	SECURE PAYMENTS	All payment are Secured and trusted.	\N	2022-06-04 19:54:42
3	<i class="icon anm anm-comments-l"></i>	ONLINE SUPPORT	We support online 24/7 on day	ONLINE SUPPORT	We support online 24/7 on day	\N	2022-06-04 19:55:04
4	<i class="icon anm anm-dollar-sign-r"></i>	MONEY GUARANTEE	30 days money back guarantee	MONEY GUARANTEE	30 days money back guarantee	\N	2022-06-04 19:55:16
5	<i class="icon anm anm-truck-l"></i>	FREE SHIPPING & RETURN	Free shipping on all US orders	FREE SHIPPING & RETURN	Free shipping on all US orders	\N	2022-06-04 19:55:29
\.


--
-- Data for Name: beneftis_types; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.beneftis_types (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: bones_sales_petrols; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.bones_sales_petrols (id, "Bone_Amount", "Bone", "SalesPetrol", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: bones_types; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.bones_types (id, "Name", "Account", created_at, updated_at, "NameEn") FROM stdin;
\.


--
-- Data for Name: borrowas; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.borrowas (id, "Code", "Date", "Month", "Amount", "Draw", "Note", "Safe", "Emp", "Coin", "Cost_Center", "User", arr, created_at, updated_at, "Delete") FROM stdin;
\.


--
-- Data for Name: branches; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.branches (id, "Arabic_Name", "English_Name", created_at, updated_at, "Letter", "Code", "Location", "Budget") FROM stdin;
3	الفرع الرئيسي	main Branch	2022-10-18 22:34:33	2024-02-09 00:17:43	\N	\N	\N	\N
\.


--
-- Data for Name: brands; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.brands (id, "Name", "Note", created_at, updated_at, "Image", "Sales_Show", "Store_Show", "NameEn", "Sales_Precet") FROM stdin;
17	الماركة الافتراضية	\N	2022-06-06 19:15:43	2024-02-09 00:27:02	BrandsImages/5hcSrdUnrIK1AmXf3s61.png	1	3	Default Brand	0
23	بن ابو عوف	\N	2025-10-26 15:24:58	2025-10-26 15:24:58	\N	0	0	بن ابو عوف	0
\.


--
-- Data for Name: campaigns; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.campaigns (id, "Arabic_Name", "English_Name", "Platform", created_at, updated_at) FROM stdin;
7	حملة 2024	حملة 2024	8	2022-04-13 02:50:33	2024-02-09 00:51:37
8	حمله 10/2025	حمله 10/2025	8	2025-10-02 15:26:13	2025-10-02 15:26:13
9	SEO 10	SEO 10	10	2025-10-26 14:56:50	2025-10-26 14:56:50
10	PPC 9	PPC 9	10	2025-10-26 14:57:01	2025-10-26 14:57:01
\.


--
-- Data for Name: capital_increases; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.capital_increases (id, "Date", "Month", "Value", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: capitals; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.capitals (id, "Authorized_Capital", "Source_Capital", "Shares_Number", "Nominal_Value_of_Shares", "Actual_Share_Value", "Actual_Capital", created_at, updated_at, "Working_Capital", "New_Shares_Number", "Capital_Increase", "New_Source_Capital", "Total_Investment") FROM stdin;
1	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2	100000	150000	10	15000	15000	150000	2021-10-13 15:36:23	2021-10-13 15:36:23	\N	\N	\N	\N	\N
\.


--
-- Data for Name: car_shippings; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.car_shippings (id, "Name", "Max_Load", "Delegate", "Driver", "Car_Number", "Color", "Lisence_Expire_Date", "GPS_Num", "Car_Type", "Car_Statue", "Insurance", "Ownership", created_at, updated_at, "Cost_Center", "Rent_Amount", "Deal_Type", "Deal_Amount", "Account", "AccountMerit", "Minimum") FROM stdin;
1	سيارة 1	5000	38	66	15236	#000000	\N	\N	BoxTruck	Good	No	ToCompany	2025-10-07 11:36:11	2025-10-07 11:36:11	4	\N	\N	\N	2646	2647	3000
2	سيارة2	6000	38	60	49872	#4c4baa	\N	\N	FlatbedTruck	New	No	Rented	2025-10-07 11:37:19	2025-10-07 11:37:19	\N	4000	\N	\N	2648	2649	4000
3	سيارة 3	4000	38	59	15887	#8ea82e	\N	\N	SmallCargoVan	HalfGood	Yes	DriverOwne	2025-10-07 11:38:11	2025-10-07 11:38:11	\N	\N	Precent	20	2650	2651	2000
4	سيارة 4	1000	38	70	445454	#000000	\N	\N	SmallCargoVan	Good	No	ToCompany	2025-10-07 14:46:00	2025-10-07 14:46:00	4	\N	\N	\N	2664	2665	800
5	سيارة الشركة	1000	72	75	1000	#000000	\N	\N	LightPickupTruck	Good	Yes	ToCompany	2025-10-08 13:56:02	2025-10-08 13:56:02	4	\N	\N	\N	2701	2702	1000
6	سارة مؤجرة	1000	72	75	1000	#000000	\N	\N	Lorry	Good	No	Rented	2025-10-08 13:56:40	2025-10-08 13:56:40	\N	1000	\N	\N	2703	2704	1000
7	سيارة سائق بقيمة	1000	72	75	1000	#000000	\N	\N	SmallCargoVan	Good	No	DriverOwne	2025-10-08 13:57:13	2025-10-08 13:57:13	\N	\N	ConstantValue	1000	2705	2706	1000
8	سيارة سائق بنسبة	1000	72	75	1000	#000000	\N	\N	Lorry	New	Yes	DriverOwne	2025-10-08 13:57:53	2025-10-08 13:57:53	\N	\N	Precent	5	2707	2708	1000
\.


--
-- Data for Name: cars_sales_petrols; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.cars_sales_petrols (id, "Car_Amount", "Car", "SalesPetrol", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: cart_stores; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.cart_stores (id, "Name", "NameEn", "V_Name", "VV_Name", "P_Code", "AvQty", "Qty", "Price", "Image", "Total", "User", created_at, updated_at, "Product") FROM stdin;
\.


--
-- Data for Name: chat_issues; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.chat_issues (id, "Name", "Date", "Time", "Desc", "Image", "Issue", created_at, updated_at, "Type", "Appear") FROM stdin;
30	Admin	2024-02-04	09-37 PM	\N	AdminsImages/H1fQroGeALye9kfwlLOJ.png	9	2024-02-04 21:37:45	2024-02-04 21:37:45	1	\N
31	Admin	2024-02-04	09-41 PM	\N	AdminsImages/ZUWBoib7IOGJVz5bRYO7.png	9	2024-02-04 21:41:18	2024-02-04 21:41:18	1	\N
\.


--
-- Data for Name: checks_types; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.checks_types (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
4	مسطر	Underlined	2022-05-24 00:44:58	2024-02-09 00:22:37
\.


--
-- Data for Name: cities; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.cities (id, "Arabic_Name", "English_Name", "Gov", created_at, updated_at, "Ship_Price", "Shipping_Company", "SearchCode", "ShippingCode") FROM stdin;
9	الرياض	Riyadh	5	2024-02-09 00:56:49	2024-02-09 00:56:49	1	5	\N	\N
10	فيصل	فيصل	6	2025-10-02 15:23:11	2025-10-02 15:23:11	0	\N	\N	1
12	فيصل	فيصل	8	2025-10-06 13:25:42	2025-10-06 13:25:42	100	\N	\N	5
1	مدينة نصر	Nasr City	2	2021-07-25 23:46:59	2025-10-06 14:07:09	7	5	\N	7
13	الغردقة	الغردقة	9	2025-10-07 15:37:46	2025-10-07 15:37:46	50	\N	\N	5
11	مدينة العبور	مدينة العبور	7	2025-10-06 12:33:25	2025-10-07 15:38:34	30	\N	\N	30
14	جدة	جدة	10	2025-10-26 14:52:28	2025-10-26 14:52:28	0	\N	\N	1
\.


--
-- Data for Name: client_account_statement_column_sechdules; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.client_account_statement_column_sechdules (id, "Date", "Code", "Time", "Refrence_Number", "Branch", "Store", "Payment_Method", "Safe", "Type", "Shipping", "Cost_Center", "User", "Coin", "Due_Date", "Delegate", "Note", "Total_Return", "Total_Price", "Total_Discount", "Total_Tax", "Total_Net", "Paid", "Residual", "Client", created_at, updated_at, "ShiftCode", "Executor") FROM stdin;
1	1	1	\N	\N	\N	1	1	1	1	\N	\N	\N	\N	\N	\N	1	\N	1	1	1	1	1	\N	1	\N	2025-10-20 16:03:07	\N	\N
\.


--
-- Data for Name: client_account_statement_columns; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.client_account_statement_columns (id, "Date", "Code", "Time", "Refrence_Number", "Branch", "Store", "Payment_Method", "Safe", "Type", "Shipping", "Cost_Center", "User", "Coin", "Due_Date", "Delegate", "Note", "Total_Return", "Total_Price", "Total_Discount", "Total_Tax", "Total_Net", "Paid", "Residual", "Client", created_at, updated_at, "ShiftCode", "Executor") FROM stdin;
1	1	1	0	0	0	1	1	1	1	0	0	0	0	0	0	1	0	1	1	1	1	1	0	1	\N	2025-10-07 16:26:03	0	0
\.


--
-- Data for Name: client_filters; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.client_filters (id, "Product", "Code", "Name", "VName", "VVName", "V1", "V2", "Qty", "Price", "Total", created_at, updated_at, "Client") FROM stdin;
\.


--
-- Data for Name: client_sales_petrols; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.client_sales_petrols (id, "Customer_Amount", "Customer", "SalesPetrol", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: client_statuses; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.client_statuses (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
5	عميل مهم	VIP	2022-03-08 01:33:27	2024-02-09 00:51:55
4	محتمل	Perhaps	2022-02-18 01:19:26	2024-02-09 00:52:13
6	عميل غير محتمل	عميل غير محتمل	2025-10-02 15:24:51	2025-10-02 15:24:51
7	عميل صامت	عميل صامت	2025-10-26 14:54:24	2025-10-26 14:54:24
8	عميل مؤدب	عميل مؤدب	2025-10-26 14:54:48	2025-10-26 14:54:48
\.


--
-- Data for Name: clients_statements_column_sechdules; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.clients_statements_column_sechdules (id, "Account_Code", "Account_Name", "Debiator_Before", "Creditor_Before", "Total_Debitor", "Total_Creditor", "Debitor_Balance", "Creditor_Balance", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	\N	2025-10-25 08:16:14
\.


--
-- Data for Name: clients_statements_columns; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.clients_statements_columns (id, "Account_Code", "Account_Name", "Debiator_Before", "Creditor_Before", "Total_Debitor", "Total_Creditor", "Debitor_Balance", "Creditor_Balance", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	\N	2022-10-17 13:08:16
\.


--
-- Data for Name: coins; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.coins (id, "Arabic_Name", "English_Name", created_at, updated_at, "Draw", "Symbol", "Code") FROM stdin;
7	دولار	Dollar	2024-02-09 00:21:32	2024-02-09 00:21:32	3.75	$	$
4	ريال سعودي	SAR	2021-06-16 01:47:03	2024-02-09 00:21:54	1	SAR	1
8	دينار كويتى	denar kuwaity	2025-10-14 00:03:07	2025-10-14 00:03:22	1	kwd	\N
9	يورو	EUR	2025-10-20 23:30:45	2025-10-20 23:30:45	60	EUR	\N
1	جنيه مصري	Egyptian Pound	2021-06-14 15:44:02	2025-10-22 12:38:12	55	EGP	EUR
10	دولار 0	.	2025-10-26 15:28:03	2025-10-26 15:28:03	50	.	\N
\.


--
-- Data for Name: comments; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.comments (id, "Comment", "Date", "Product", "User", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: comments_clients; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.comments_clients (id, "Comment", "Responsible", "Customer", created_at, updated_at, "CommentEn", "Code", "Date", "Rate", "Visit_Cost", "Note", "Time", "Type", lat, lng, "Voice") FROM stdin;
2	...	38	2	2025-10-02 15:36:22	2025-10-02 15:36:22	...	1	2025-10-02	1	\N	\N	15:36:22	5	\N	\N	\N
3	شكرا	38	1	2025-10-15 04:08:54	2025-10-15 04:08:54	thanks	2	2025-10-15	\N	\N	\N	04:08:54	\N	\N	\N	\N
4	التعليق بالعربية	48	25	2025-10-15 16:38:31	2025-10-15 16:38:31	التعليق بالإنجليزية	3	2025-10-15	1	100	ملاحظات	16:38:31	5	\N	\N	\N
5	111111111111111111111111111111111111111111111111	40	25	2025-10-15 16:41:59	2025-10-15 16:41:59	2222222222222222222222222222222222222222222222	4	2025-10-15	1	100	11111	16:41:59	8	\N	\N	\N
6	..	38	25	2025-10-15 16:45:01	2025-10-15 16:45:01	...	5	2025-10-15	\N	\N	\N	16:45:01	\N	\N	\N	\N
7	تيست	38	5	2025-10-16 16:29:53	2025-10-16 16:29:53	test	6	2025-10-16	\N	\N	\N	16:29:53	\N	\N	\N	\N
8	uu	38	6	2025-10-16 16:57:37	2025-10-16 16:57:37	gg	7	2025-10-16	\N	\N	\N	16:57:37	\N	\N	\N	\N
9	1111111111111	38	2	2025-10-16 17:30:06	2025-10-16 17:30:06	11111111111	8	2025-10-16	1	1	1	17:30:06	8	\N	\N	\N
10	555555555555	40	2	2025-10-16 17:30:24	2025-10-16 17:30:24	555555	9	2025-10-16	1	5	5	17:30:24	6	\N	\N	\N
11	999999	40	2	2025-10-16 17:30:48	2025-10-16 17:30:48	9999	10	2025-10-16	1	9	9	17:30:48	4	\N	\N	\N
12	التعليق بالعربيه	48	2	2025-10-16 18:05:42	2025-10-16 18:05:42	التعليق بالانجليزيه	11	2025-10-16	1	100	ملاحظات	18:05:42	5	\N	\N	\N
13	تعليق عربي	48	38	2025-10-16 21:55:54	2025-10-16 21:55:54	تعليق انجليزي	12	2025-10-16	1	1	ملاحظات	21:55:54	\N	30.0471	31.238400000000002	\N
14	تعليق عربي	38	38	2025-10-16 21:56:52	2025-10-16 21:56:52	تعليق انجليزي	12	2025-10-16	1	10	ملاحظات	21:56:52	7	\N	\N	\N
15	تيستت	38	17	2025-10-21 17:03:41	2025-10-21 17:03:41	testt	13	2025-10-21	1	500	\N	17:03:41	5	30.0747	31.266	\N
16	؟......	38	47	2025-10-21 18:24:12	2025-10-21 18:24:12	.......	14	2025-10-21	1	1	..	18:24:12	5	30.1162	31.3075	\N
17	التعليق بالعربيه	38	54	2025-10-22 10:10:29	2025-10-22 10:10:29	التعليق بالانجليزيه	15	2025-10-22	1	100	ملاحظات	10:10:29	5	\N	\N	\N
18	التعليق بالعربيه التعليق بالعربيه التعليق بالعربيه التعليق بالعربيه التعليق بالعربيه التعليق بالعربيه التعليق بالعربيه التعليق بالعربيه التعليق بالعربيه التعليق بالعربيه التعليق بالعربيه التعليق بالعربيه التعليق بالعربيه التعليق بالعربيه التعليق بالعربيه التعليق بالعربيه	54	54	2025-10-22 11:22:28	2025-10-22 11:22:28	التعليق بالانجليزيه التعليق بالانجليزيه التعليق بالانجليزيه التعليق بالانجليزيه التعليق بالانجليزيه التعليق بالانجليزيه التعليق بالانجليزيه التعليق بالانجليزيه التعليق بالانجليزيه التعليق بالانجليزيه التعليق بالانجليزيه التعليق بالانجليزيه التعليق بالانجليزيه التعليق بالانجليزيه	16	2025-10-22	1	500	ملاحظات ملاحظات ملاحظات ملاحظات ملاحظات ملاحظات	11:22:28	7	\N	\N	\N
20	تعليق عربي	44	54	2025-10-22 11:30:26	2025-10-22 11:30:26	تعليق انجليزي	18	2025-10-22	1	2000	ملاحظات	11:30:26	3	30.1054	31.2967	\N
22	3333333333333	82	54	2025-10-23 13:06:43	2025-10-23 13:06:43	33333333333	20	2025-10-23	\N	\N	\N	13:06:43	\N	\N	\N	\N
23	999	38	54	2025-10-23 13:13:53	2025-10-23 13:13:53	999	21	2025-10-23	\N	\N	\N	13:13:53	5	\N	\N	\N
28	222222222	38	18	2025-10-23 13:38:08	2025-10-23 13:38:08	22222222222	25	2025-10-23	1	\N	\N	13:38:08	4	\N	\N	\N
30	lm;l	43	20	2025-10-23 13:55:10	2025-10-23 13:55:10	;mllml	26	2025-10-23	1	88	llm	13:55:10	8	30.0817	31.2731	\N
31	,;,;	43	20	2025-10-23 14:01:27	2025-10-23 14:01:27	klnmmkl	27	2025-10-23	1	500	l,,,	14:01:27	8	30.0819	31.2734	\N
32	sddvsv	43	20	2025-10-23 14:05:05	2025-10-23 14:05:31	sddvsv	28	2025-10-23	1	100	gfd	14:05:05	8	\N	\N	\N
33	ظنظظ	43	21	2025-10-23 15:31:41	2025-10-23 15:31:41	غغغغغ	29	2025-10-23	1	٣٠٠	للل	15:31:41	8	30.0988	31.290100000000002	\N
34	قققف	43	21	2025-10-23 15:37:29	2025-10-23 15:37:29	لللل	30	2025-10-23	1	٧٨٨٨	غغغغغ	15:37:29	8	30.0671	31.2587	AdminsImages/9NC0YYvW3y8sHHzmmmjK.m4a
36	جيد	38	21	2025-10-23 15:44:50	2025-10-23 15:44:50	Good customer	31	2025-10-23	\N	\N	\N	15:44:50	\N	\N	\N	AdminsImages/UtRizAarr5vfh8rlwrGv.m4a
37	تعليق عربي	44	54	2025-10-23 16:27:05	2025-10-23 16:27:05	تعليق انجليزي	32	2025-10-23	1	1000	ملاحظات	16:27:05	8	30.1435	31.3348	AdminsImages/dItAuL2ReF9r9bMRFkas.m4a
42	انا كلمت العميل وقال	45	54	2025-10-25 08:49:38	2025-10-25 08:49:38	called	36	2025-10-25	1	00	ملاحظات	08:49:38	3	30.1068	31.2981	AdminsImages/AFHNW248OIqvwvf0vlqP.m4a
39	33333	82	54	2025-10-23 17:15:51	2025-10-23 17:15:51	2222	33	2025-10-23	1	100	١١	17:15:51	3	30.1079	31.299200000000003	AdminsImages/sc7TNCes4b5xTd5VanRE.m4a
40	vdv	43	20	2025-10-25 02:48:06	2025-10-25 02:48:06	vvvc	34	2025-10-25	1	00	\N	02:48:06	8	30.0978	31.2894	AdminsImages/vLLWZBeC9ATxdWTSubb1.m4a
41	تجربه	82	22	2025-10-25 03:11:18	2025-10-25 03:11:18	تجربه	35	2025-10-25	1	500	\N	03:11:18	8	30.0567	31.248	AdminsImages/K1ItdftwlIkwzRvbDKS4.m4a
43	اوك	44	26	2025-10-25 14:42:53	2025-10-25 14:42:53	cc	37	2025-10-25	1	00	ملاحظات	14:42:53	8	30.0549	31.2462	AdminsImages/Otd1MBUuWruZ1NQyUbpu.m4a
44	انا كلمته وشرحت	45	20	2025-10-26 00:02:59	2025-10-26 00:02:59	تتتتت	38	2025-10-26	1	\N	ملاحظات	00:02:59	4	30.0631	31.2544	AdminsImages/wIPVKeyUKqMaw3xSpxmy.m4a
45	انا تواصلت مع العميل وطلب عرض سعر	82	60	2025-10-26 15:14:25	2025-10-26 15:14:25	انا تواصلت مع العميل وطلب عرض سعر	39	2025-10-26	1	\N	\N	15:14:25	4	\N	\N	\N
46	انا قدمت له عرض سعر رقم 500	80	60	2025-10-26 15:15:05	2025-10-26 15:15:05	انا قدمت له عرض سعر رقم 500	40	2025-10-26	2	\N	\N	15:15:05	3	\N	\N	\N
47	تم التنفيذ وووووووووووووووووووووووووو	82	60	2025-10-26 15:15:41	2025-10-26 15:15:41	تم التنفيذ وووووووووووووووووووووووووو	41	2025-10-26	1	\N	\N	15:15:41	3	\N	\N	\N
\.


--
-- Data for Name: company_cars; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.company_cars (id, "Name", "Number", "Account", created_at, updated_at, "NameEn") FROM stdin;
\.


--
-- Data for Name: company_data; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.company_data (id, "Name", "Phone1", "Phone2", "Address", "Commercial_Record", "Tax_File_Number", "Logo", "Icon", "Print_Text", created_at, updated_at, "Print_Text_Footer", "Seal", "Print_Text_Footer_Sales", "Name_Sales_Bill", "Name_Sales_Order_Bill", "Print_Text_Footer_Quote", "Name_Quote_Bill", "Print_Text_Footer_Secretariat", "Logo_Store", "Phone3", "Phone4", "Icon_Store", "View", "Tax_Registration_Number", "Tax_activity_code", work_nature, "Governrate", "City", "Place", "Nationality", "Buliding_Num", "Street", "Postal_Code", tax_magistrate, "Client_ID", "Serial_Client_ID", "Version_Type", "Computer_SN", "Invoice_Type", "Floor", "Room", "Landmark", "Add_Info", "Print_Text_Footer_Manufacturing", "POS_Version", "Path", "DB_Backup", "NameEn", "Print_Text_En", "Print_Text_Footer_En", "Print_Text_Footer_Manufacturing_En", "Print_Text_Footer_Sales_En", "Print_Text_Footer_Quote_En", "Print_Text_Footer_Secretariat_En", "Name_Sales_Bill_En", "Name_Sales_Order_Bill_En", "Name_Quote_Bill_En", "AddressEn", "HomeMainScreen", "PDF", "Email", "Location", "Bill_View", "Font_Type", "Welcome_Arabic_Word_App", "Welcome_English_Word_App", "Domain", "Serial_App", "Attend_Lat", "Attend_Lng", "Attend_Space", "Attend_Time_Before", "Attend_Time_After", "Departure_Time_Before", "Departure_Time_After", "Verfification_Time", "Organaziation_Common_Name", "Organaziation_Name", "Organaziation_Tax_ID", "Organaziation_Address", "Organaziation_Department", "Organaziation_Category", "ZATCA_Production", "OTP_Status", "Use_Zatca", "Backup_Time", "Purchases_Print_View", "Purchases_Order_Print_View", "Sales_Order_Print_View", "Quote_Print_View") FROM stdin;
1	رابح	\N	\N	العبور	1234	1234	LogoImages/JwtnZ3GGKPjj3Cs8gXnd.png	IconImages/yBuepMOMAOAM1Eh1MYOQ.png	تشرفنا بزيارتكم	2021-08-13 16:30:58	2025-10-21 14:12:33	تشرفنا بزيارتكم	LogoImages/DrZ9IR5TvZPjwUv5GUWp.png	تشرفنا بزيارتكم	فاتورة مبيعات	امر بيع	تشرفنا بزيارتكم	عرض سعر	تشرفنا بزيارتكم	LogoImages/iaLvA02ROEZLiea1P36v.png	\N	\N	LogoImages/RNAkRyg1QTzZ72j6hT2a.png	1	1	1	P	2	1	6	2	1	1	1	1	1	1	1.0	1	Experimental	1	1	1	1	تشرفنا بزيارتكم	1	1	1	RABIH	Welcome	Welcome	Welcome	Welcome	Welcome	Welcome	Sales Invoice	Sales Order	Quotation	\N	1	LogoImages/K0Imk4FNDQ7SbQsECsZf.png	info@baraah.com	<iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d452.9142716996173!2d46.6578223!3d24.750415!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3e2ee30fcda81b0f%3A0xd2fad773e3b6b328!2sRoyal%20Suits!5e0!3m2!1sen!2seg!4v1707426597227!5m2!1sen!2seg" width="400" height="300" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>	1	8	\N	\N	\N	\N	30.2540389	31.4676674	5000	500	500	500	500	1	\N	\N	\N	\N	\N	\N	false	\N	No	1	Default	Default	Default	Default
\.


--
-- Data for Name: compare_prices_columns; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.compare_prices_columns (id, "Date", "Product_Code", "Product_Name", "Unit", "Type", "Bill_Num", "Incom", "Outcom", "Credit", "Group", "Brand", "Store", "User", "Safe", "Branch", "SalePrice", "ProductPrice", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	\N	2022-10-09 18:47:57
\.


--
-- Data for Name: compare_prices_columns_sechdules; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.compare_prices_columns_sechdules (id, "Date", "Product_Code", "Product_Name", "Unit", "Type", "Bill_Num", "Incom", "Outcom", "Credit", "Group", "Brand", "Store", "User", "Safe", "Branch", "SalePrice", "ProductPrice", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	\N	2022-10-09 18:48:22
\.


--
-- Data for Name: compare_prices_filter_twos; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.compare_prices_filter_twos (id, "Date", "Type", "Bill_Num", "Incom", "Outcom", "Current", "P_Ar_Name", "P_En_Name", "P_Code", "Unit", "Group", "Store", "Product", "V1", "V2", "User", "CostIn", "CostOut", "CostCurrent", "CostOneIn", "CostOneOut", "CostOneCurrent", "QTY", "Brand", "Safe", "Branch", "SalePrice", "ProductPrice", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: compare_prices_filters; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.compare_prices_filters (id, "Date", "Type", "Bill_Num", "Incom", "Outcom", "Current", "P_Ar_Name", "P_En_Name", "P_Code", "Unit", "Group", "Store", "Product", "V1", "V2", "User", "CostIn", "CostOut", "CostCurrent", "CostOneIn", "CostOneOut", "CostOneCurrent", "QTY", "Brand", "Safe", "Branch", "SalePrice", "ProductPrice", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: compares; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.compares (id, "Product", "User", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: competitors; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.competitors (id, "Facebook", "Twitter", "Instagram", "Name", "Country", "Whatsapp", "Addtional_Link", "Phone", "Pinterest", created_at, updated_at, "NameEn", "Website") FROM stdin;
\.


--
-- Data for Name: consist_maintainces; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.consist_maintainces (id, "Product_Code", "P_Ar_Name", "P_En_Name", "V_Name", "VV_Name", "Original_Qty", "AvQty", "Qty", "Price", "Discount", "Tax", "Total_Bf_Tax", "Total_Tax", "Total", "Exp_Date", "Store", "Product", "V1", "V2", "Unit", "Maintaince", "TDiscount", "Group", "Brand", "Code", "Date", "Note", "Serial_Num", "Total_Price", "Product_Numbers", "Total_Qty", "Total_Discount", "Total_Cost", "Total_Bf_Taxes", "Total_Taxes", "Draw", "Company", "Device_Type", "Device_Case", "Coin", "Cost_Center", "Account", "User", "Status", "Pattern_Image", "Time", "Payment_Method", "Password", "Pay", "Eng_Note", "Reason", "Report_Client", "Work", "StoreMain", "Eng", "Recipient", "Branch", "RefuseReason", "NoteRecived", "Returned", "CustomerGroup", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: consists; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.consists (id, "Code", "Date", "Darw", "Products_Number", "Total_Qty", "Total_Price", "Account", "Store", "Coin", "User", created_at, updated_at, "Time", "Branch", arr, "Delete") FROM stdin;
\.


--
-- Data for Name: contact_u_s; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.contact_u_s (id, "Map", "Arabic_Title", "English_Title", "Arabic_Desc", "English_Desc", "Opening_Hours", "Phone1", "Phone2", "Phone_Header", "Email", "Arabic_Address", "English_Address", created_at, updated_at) FROM stdin;
1	www.google.com/maps/embed?pb	DROP US A LINE	DROP US A LINE	Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500	Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500	Mon - Sat : 9am - 11pm	01062201060	0105206971	01062201060	info@klarapps.com	Cairo,Egypt	Cairo,Egypt	\N	2022-06-04 15:27:21
\.


--
-- Data for Name: contract_statuses; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.contract_statuses (id, "Arabic_Name", "English_Name", "Color", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: contractors_real_projects; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.contractors_real_projects (id, "Arabic_Name", "English_Name", "Expenses_Account", "Merit_Account", "Project", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: cost_centers; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.cost_centers (id, "Arabic_Name", "English_Name", created_at, updated_at, "Parent", "Type") FROM stdin;
4	مركز تكلفة	Cost Center	2022-02-18 01:22:58	2024-02-09 00:22:59	0	0
\.


--
-- Data for Name: counters_types; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.counters_types (id, "Name", "Current_Read", "Store", "Product", created_at, updated_at, "NameEn") FROM stdin;
\.


--
-- Data for Name: countris; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.countris (id, "Arabic_Name", "English_Name", "Flag", created_at, updated_at, "Safe", "Coin", "Store", "Code", "SearchCode") FROM stdin;
2	مصر	Egypt	CountriesImages/0YNgesTQQDPJblD7725Y.png	2022-06-04 19:37:49	2024-02-09 00:53:35	30	1	21	\N	\N
3	السعوديه	Saudi Arabia	CountriesImages/pgME9vgrOAqViEVToi4i.png	2022-06-04 19:39:05	2024-02-09 00:53:46	32	4	21	\N	\N
\.


--
-- Data for Name: coupon_codes; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.coupon_codes (id, "Code", "Amount", "Status", "Num", "Used", "Expire", created_at, updated_at) FROM stdin;
1	224466	100	0	3	2	2022-06-30	2022-06-04 15:19:31	2022-06-10 02:33:22
\.


--
-- Data for Name: courses; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.courses (id, "Code", "Arabic_Name", "English_Name", "Arabic_Desc", "English_Desc", "Category", "Lec_Num", "Hours", "Subject", created_at, updated_at, "Note") FROM stdin;
1	1	Course 1	Course 1	Course 1	Course 1	1	8	100	1	2024-01-21 00:37:23	2024-01-21 00:38:01	\N
\.


--
-- Data for Name: courses_categories; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.courses_categories (id, "Image", "Arabic_Name", "English_Name", "Arabic_Desc", "English_Desc", created_at, updated_at) FROM stdin;
1	CoursesCategoryImages/5CCMF4VEBCKWsSvv9ej3.png	فئة ١	فئة ١	فئة ١	فئة ١	2024-01-19 10:58:18	2024-01-19 10:58:18
\.


--
-- Data for Name: courses_halls; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.courses_halls (id, "Arabic_Name", "English_Name", "Chairs_Num", "Wiifii", "Air_Condition", "Place", "Number", created_at, updated_at) FROM stdin;
1	قاعة ١	قاعة ١	\N	1	1	\N	1	2024-01-19 11:02:53	2024-01-19 11:02:53
\.


--
-- Data for Name: courses_types; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.courses_types (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
1	خاص	خاص	2024-01-19 11:00:19	2024-01-19 11:00:19
2	VIP	VIP	2024-01-19 11:00:30	2024-01-19 11:00:30
3	مجموعة	مجموعة	2024-01-19 11:00:42	2024-01-19 11:00:42
\.


--
-- Data for Name: crm_default_data; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.crm_default_data (id, "Price_Level", "Governrate", "City", "Responsible", "Activity", "Campagin", "ClientStatus", "Platforms", created_at, updated_at, "Client_Delegate", "Nationality", "ClientGroup") FROM stdin;
3	1	5	9	38	8	7	5	8	2022-04-13 02:52:58	2025-10-25 12:35:08	0	3	3
\.


--
-- Data for Name: custom_prints; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.custom_prints (id, "Sales_Print_Type", "Sales_Bill_Code", "Sales_Date", "Sales_Coin", "Sales_Draw", "Sales_Payment_Method", "Sales_Status", "Sales_Executor", "Sales_Refernce_Number", "Sales_Safe", "Sales_Client", "Sales_Delegate", "Sales_Store", "Sales_User", "Sales_Cost_Center", "Sales_Notes", "Sales_Pro_Code", "Sales_Pro_Name", "Sales_Pro_Unit", "Sales_Pro_Qty", "Sales_Pro_Price", "Sales_Pro_Discount", "Sales_Pro_Total_Bf_Tax", "Sales_Pro_Total_Tax", "Sales_Pro_Total", "Sales_Pro_Store", "Sales_Pro_Desc", "Sales_Pro_Exp_Date", "Sales_Pro_Weight", "Sales_Pro_Patch_Number", "Sales_Product_Numbers", "Sales_Total_Qty", "Sales_Total_Discount", "Sales_Total_Bf_Taxes", "Sales_Total_Taxes", "Sales_Total_Price", "Sales_Paid", "Sales_Residual", "Sales_Taknet", "Sales_Credit", "Sales_Barcode", "Sales_Text", "Sales_Seal", "Purch_Print_Type", "Purch_Bill_Code", "Purch_Date", "Purch_Vendor_Bill_Date", "Purch_Coin", "Purch_Draw", "Purch_Payment_Method", "Purch_Status", "Purch_Refernce_Number", "Purch_Safe", "Purch_Vendor", "Purch_Delegate", "Purch_Store", "Purch_User", "Purch_Cost_Center", "Purch_Notes", "Purch_Pro_Code", "Purch_Pro_Name", "Purch_Pro_Unit", "Purch_Pro_Qty", "Purch_Pro_Price", "Purch_Pro_Discount", "Purch_Pro_Total_Bf_Tax", "Purch_Pro_Total_Tax", "Purch_Pro_Total", "Purch_Pro_Store", "Purch_Pro_Exp_Date", "Purch_Product_Numbers", "Purch_Total_Qty", "Purch_Total_Discount", "Purch_Total_Bf_Taxes", "Purch_Total_Taxes", "Purch_Total_Price", "Purch_Paid", "Purch_Residual", "Purch_Taknet", "Purch_Credit", "Purch_Barcode", "Purch_Text", "Purch_Seal", created_at, updated_at, "Sales_Client_Phone", "Sales_Resdiual", "Sales_Total_Return", "Sales_Client_Address", "Sales_Pro_Total_Net", "Purch_Pro_Total_Net") FROM stdin;
1	2	1	1	0	0	0	0	1	0	0	1	1	0	0	0	0	1	1	0	1	1	0	0	0	1	0	0	0	0	0	0	0	0	0	1	1	0	0	0	0	1	1	0	2	1	1	0	0	0	0	0	0	0	1	1	0	0	0	1	1	1	0	1	1	0	0	0	1	0	0	0	0	0	0	1	1	0	0	0	1	1	1	0	2024-04-14 16:57:48	2025-10-21 13:32:10	0	0	0	0	0	0
\.


--
-- Data for Name: customer_comments_products; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.customer_comments_products (id, "Product", "Comment", created_at, updated_at) FROM stdin;
1	3	4	2025-10-15 16:38:31	2025-10-15 16:38:31
2	4	4	2025-10-15 16:38:31	2025-10-15 16:38:31
3	3	9	2025-10-16 17:30:06	2025-10-16 17:30:06
4	7	10	2025-10-16 17:30:24	2025-10-16 17:30:24
5	4	11	2025-10-16 17:30:48	2025-10-16 17:30:48
6	15	11	2025-10-16 17:30:48	2025-10-16 17:30:48
7	3	12	2025-10-16 18:05:42	2025-10-16 18:05:42
8	10	12	2025-10-16 18:05:42	2025-10-16 18:05:42
9	15	12	2025-10-16 18:05:42	2025-10-16 18:05:42
10	3	14	2025-10-16 21:56:52	2025-10-16 21:56:52
11	7	14	2025-10-16 21:56:52	2025-10-16 21:56:52
12	4	17	2025-10-22 10:10:29	2025-10-22 10:10:29
13	7	17	2025-10-22 10:10:29	2025-10-22 10:10:29
14	19	17	2025-10-22 10:10:29	2025-10-22 10:10:29
15	3	18	2025-10-22 11:22:28	2025-10-22 11:22:28
16	2	18	2025-10-22 11:22:28	2025-10-22 11:22:28
17	7	18	2025-10-22 11:22:28	2025-10-22 11:22:28
18	4	18	2025-10-22 11:22:28	2025-10-22 11:22:28
19	10	18	2025-10-22 11:22:28	2025-10-22 11:22:28
20	13	18	2025-10-22 11:22:28	2025-10-22 11:22:28
21	14	18	2025-10-22 11:22:28	2025-10-22 11:22:28
22	15	18	2025-10-22 11:22:28	2025-10-22 11:22:28
23	19	18	2025-10-22 11:22:28	2025-10-22 11:22:28
24	21	18	2025-10-22 11:22:28	2025-10-22 11:22:28
25	3	22	2025-10-23 13:06:43	2025-10-23 13:06:43
26	10	22	2025-10-23 13:06:43	2025-10-23 13:06:43
27	3	23	2025-10-23 13:13:53	2025-10-23 13:13:53
29	4	28	2025-10-23 13:38:08	2025-10-23 13:38:08
30	4	33	2025-10-23 15:31:41	2025-10-23 15:31:41
31	6	34	2025-10-23 15:37:29	2025-10-23 15:37:29
32	7	34	2025-10-23 15:37:29	2025-10-23 15:37:29
34	3	37	2025-10-23 16:27:05	2025-10-23 16:27:05
35	2	37	2025-10-23 16:27:05	2025-10-23 16:27:05
36	1	37	2025-10-23 16:27:05	2025-10-23 16:27:05
43	1	39	2025-10-23 17:15:51	2025-10-23 17:15:51
44	2	39	2025-10-23 17:15:51	2025-10-23 17:15:51
45	4	39	2025-10-23 17:15:51	2025-10-23 17:15:51
46	5	39	2025-10-23 17:15:51	2025-10-23 17:15:51
47	3	39	2025-10-23 17:15:51	2025-10-23 17:15:51
48	4	40	2025-10-25 02:48:06	2025-10-25 02:48:06
49	4	41	2025-10-25 03:11:18	2025-10-25 03:11:18
50	5	42	2025-10-25 08:49:38	2025-10-25 08:49:38
51	10	42	2025-10-25 08:49:38	2025-10-25 08:49:38
52	4	43	2025-10-25 14:42:53	2025-10-25 14:42:53
53	5	43	2025-10-25 14:42:53	2025-10-25 14:42:53
54	2	44	2025-10-26 00:02:59	2025-10-26 00:02:59
55	23	45	2025-10-26 15:14:25	2025-10-26 15:14:25
56	13	45	2025-10-26 15:14:25	2025-10-26 15:14:25
57	3	46	2025-10-26 15:15:05	2025-10-26 15:15:05
\.


--
-- Data for Name: customer_follow_ups; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.customer_follow_ups (id, "Code", "Date", "Client", "Subject", "Rate", "Emp", "Visit_Cost", "Note", arr, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: customers; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.customers (id, "Code", "Date", "Name", "Price_Level", "Phone", email, password, "ID_Number", "Address", "Qualifications", "Birthdate", "Social_Status", "Passport_Number", "Company_Name", "Commercial_Registration_No", "Tax_Card_No", "Bank_Account", "Image", "Next_Time", "Executions_Status", "Governrate", "City", "Responsible", "Activity", "Campagin", "ClientStatus", "Account", "User", created_at, updated_at, "Platform", "Contract_Start", "Contract_End", code, country, "Tax_Registration_Number", "Tax_activity_code", work_nature, "Buliding_Num", "Street", "Postal_Code", tax_magistrate, "Floor", "Room", "Landmark", "Add_Info", "Phone2", "Phone3", "Phone4", "Warranty", "Group", "Place", "Nationality", "Product", token, "NameEn", arr, "SearchCode", "Credit_Limit", "Respon_Person", "Respon_Person_Phone", "Operating_Date", "Activation_Serial", "Activation_Code", "Repayment_Period", "SecurityInquiry", "ReasonSecurityInquiry", "FieldInquiry", "ResonFieldInquiry", "Lat", "Lang", "Guarantor") FROM stdin;
20	20	2025-10-15	بسنت 20	2	010	b@b	\N	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	2	1	38	9	8	5	2733	11	2025-10-15 12:22:07	2025-10-15 12:27:39	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	2	3	4	\N	3	6	2	\N	\N	20 Basanet	\N	2002	\N	\N	\N	2025-10-01	101010101010	20202020202020	30	0	\N	0	\N	\N	\N	6
22	22	2025-10-15	119	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2735	62	2025-10-15 12:30:19	2025-10-15 12:30:19	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	119	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
23	23	2025-10-15	تجربه	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	43	\N	\N	\N	2736	60	2025-10-15 12:32:07	2025-10-15 12:32:07	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	تجربه	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
24	24	2025-10-15	فارس	2	01215151545	a@a	\N	\N	المملكة العربية السعودية	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	2	1	40	9	\N	4	2737	1	2025-10-15 12:42:31	2025-10-15 12:42:31	9	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	6	2	\N	\N	فارس	\N	\N	\N	\N	\N	\N	\N	\N	30	0	\N	0	\N	\N	\N	1
25	25	2025-10-15	هاني	3	4547878	t@r	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	8	12	39	9	7	6	2738	1	2025-10-15 12:44:17	2025-10-15 12:44:17	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	10	2	\N	\N	هاني	\N	\N	\N	\N	\N	\N	\N	\N	30	0	\N	0	\N	\N	\N	3
26	26	2025-10-15	فارس 2	1	33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2739	1	2025-10-15 13:29:13	2025-10-15 13:29:13	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	فارس 2	\N	\N	\N	\N	\N	\N	\N	\N	30	0	\N	0	\N	\N	\N	\N
27	27	2025-10-15	تامر	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2740	1	2025-10-15 13:32:07	2025-10-15 13:32:07	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	تامر	\N	\N	\N	\N	\N	\N	\N	\N	30	0	\N	0	\N	\N	\N	\N
1	1	2024-02-09	عميل افتراضي	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2522	11	2024-02-09 00:08:02	2025-10-15 17:01:07	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	Default Customer	\N	\N	\N	\N	\N	\N	\N	\N	\N	2	\N	1	\N	\N	\N	\N
30	30	2025-10-16	تيست	مستوي 3	1234	\N	\N	\N	sharm sheikh	\N	\N	\N	\N	company	\N	\N	\N	\N	\N	\N	\N	\N	43	\N	\N	\N	2743	60	2025-10-16 15:09:55	2025-10-16 15:09:55	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	35346	\N	\N	\N	\N	\N	\N	\N	\N	Henry	\N	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
31	31	2025-10-16	تيست 2	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	43	\N	\N	\N	2744	60	2025-10-16 15:17:02	2025-10-16 15:17:02	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	تيست 2	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
4	4	2025-10-02	عمر	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	44	\N	\N	\N	2577	61	2025-10-02 17:16:25	2025-10-16 15:55:17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	Omar	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	\N	0	\N	\N	\N	\N
2	2	2025-10-02	بسنت	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2535	1	2025-10-02 14:29:56	2025-10-16 15:52:23	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	بسنت	\N	\N	\N	\N	\N	\N	\N	\N	30	1	\N	0	\N	\N	\N	\N
3	3	2025-10-02	احمد	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	6	10	38	9	8	4	2572	1	2025-10-02 15:35:26	2025-10-16 15:52:42	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	7	2	\N	\N	احمد	\N	\N	\N	\N	\N	\N	\N	\N	30	1	\N	1	\N	\N	\N	\N
33	33	2025-10-16	محمد راجي	1	0123456789	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	44	8	7	5	2746	61	2025-10-16 16:18:48	2025-10-16 16:18:48	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	محمد راجي	\N	\N	\N	\N	\N	\N	\N	\N	30	0	\N	0	\N	\N	\N	\N
32	32	2025-10-16	مسفر عبد الله	1	0550600937	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	5	9	44	8	7	5	2745	61	2025-10-16 16:18:00	2025-10-16 16:19:12	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	5	2	\N	\N	مسفر عبد الله	\N	\N	\N	\N	\N	\N	\N	\N	30	0	\N	0	\N	\N	\N	\N
34	34	2025-10-16	فواز حمد	1	0555555555	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	44	8	7	5	2747	61	2025-10-16 16:20:01	2025-10-16 16:20:01	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	فواز حمد	\N	\N	\N	\N	\N	\N	\N	\N	30	0	\N	0	\N	\N	\N	\N
35	35	2025-10-16	كريم حلمي	1	0550600937	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	44	8	7	5	2748	61	2025-10-16 16:20:32	2025-10-16 16:20:32	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	كريم حلمي	\N	\N	\N	\N	\N	\N	\N	\N	30	0	\N	0	\N	\N	\N	\N
36	36	2025-10-16	رانيا فهد	1	0550000000	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	44	8	7	5	2749	61	2025-10-16 16:21:13	2025-10-16 16:21:13	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	رانيا فهد	\N	\N	\N	\N	\N	\N	\N	\N	30	0	\N	0	\N	\N	\N	\N
37	37	2025-10-16	بسمه رجب	1	0560000000	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	44	8	7	5	2750	61	2025-10-16 16:21:53	2025-10-16 16:21:53	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	بسمه رجب	\N	\N	\N	\N	\N	\N	\N	\N	30	0	\N	0	\N	\N	\N	\N
5	5	2025-10-02	محمد حامد	1	0550600937	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	44	\N	7	\N	2586	11	2025-10-02 18:23:29	2025-10-18 17:10:38	\N	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	\N	\N	\N	عميل جديد	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
7	7	2025-10-06	هبة هاني	1	01030335860	\N	\N	\N	الجامع الكبير	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	7	11	\N	\N	7	\N	2591	11	2025-10-06 12:41:46	2025-10-18 17:11:30	\N	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	010000	\N	\N	\N	3	8	\N	\N	\N	بهبة	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
8	8	2025-10-07	داليا عماد	1	01062201060	\N	\N	\N	5656565656	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	7	11	\N	\N	7	\N	2667	11	2025-10-07 15:42:13	2025-10-18 17:11:46	\N	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	13	\N	\N	\N	بسنت 100	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
9	9	2025-10-07	هاجر مجدي	1	01270501000	\N	\N	\N	9989898	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	9	13	\N	\N	7	\N	2668	11	2025-10-07 15:42:38	2025-10-18 17:12:02	\N	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	12	\N	\N	\N	هبة 100	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
13	13	2025-10-15	بسنت 300	2	010520	b@b	\N	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	7	11	38	9	8	5	2726	11	2025-10-15 12:20:58	2025-10-18 22:19:53	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	2	3	4	Yes	3	8	2	3	\N	Basanet 300	\N	202	\N	\N	\N	2025-10-01	11	22	30	2	\N	2	كدا	\N	\N	6
11	11	2025-10-15	كريم جديد	\N	\N	kk@kk	\N	\N	ا	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2720	62	2025-10-15 10:02:24	2025-10-18 22:12:17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	كريم جديد	\N	100	\N	\N	\N	\N	\N	\N	\N	1	\N	1	\N	\N	\N	\N
14	14	2025-10-15	14	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2727	11	2025-10-15 12:21:38	2025-10-18 22:24:27	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	14	\N	\N	\N	\N	\N	\N	\N	\N	30	1	\N	2	ظظ	\N	\N	\N
15	15	2025-10-15	15	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2728	11	2025-10-15 12:21:42	2025-10-18 22:29:58	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	15	\N	\N	\N	\N	\N	\N	\N	\N	30	1	\N	2	....	\N	\N	\N
16	16	2025-10-15	16	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2729	11	2025-10-15 12:21:47	2025-10-18 22:31:45	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	16	\N	\N	\N	\N	\N	\N	\N	\N	30	1	\N	2	ddd	\N	\N	\N
17	17	2025-10-15	17	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2730	11	2025-10-15 12:21:51	2025-10-21 18:14:31	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	17	\N	\N	\N	\N	\N	\N	\N	\N	30	1	\N	2	\N	\N	\N	\N
28	28	2025-10-15	تصنيع	1	201066056841	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	4	2741	1	2025-10-15 14:33:26	2025-10-21 20:48:27	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	تصنيع	\N	\N	\N	\N	\N	\N	\N	\N	30	1	\N	2	\N	\N	\N	\N
18	18	2025-10-23	تصحيح	1	٦٦٦٦٦٦	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	5	9	38	8	7	5	2731	11	2025-10-15 12:21:55	2025-10-23 14:38:30	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	3	5	2	10	\N	\N	\N	1515	\N	\N	\N	\N	\N	\N	30	0	\N	0	\N	\N	\N	\N
21	21	2025-10-25	بسنت 1000	2	010	omar@gmail	\N	\N	\N	44	2025-10-01	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	\N	\N	2734	11	2025-10-15 12:24:18	2025-10-25 01:58:48	\N	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	2	3	4	\N	3	\N	2	\N	\N	\N	\N	1000	33	\N	\N	\N	\N	\N	30	0	\N	0	\N	\N	\N	\N
29	29	2025-10-25	عمر النشرتي	1	1234	omarelnasherty@gmail.com	\N	\N	sharm sheikh	\N	\N	\N	\N	company	\N	\N	\N	\N	\N	\N	\N	\N	43	\N	\N	\N	2742	60	2025-10-16 15:08:49	2025-10-25 02:22:18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	35346	\N	\N	\N	\N	\N	\N	\N	\N	Henry	\N	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
19	19	2025-10-25	19	1	1234	omarelnasherty@gmail.com	\N	\N	sharm sheikh	\N	\N	\N	\N	company	\N	\N	\N	\N	\N	potential_client	\N	\N	38	\N	\N	\N	2732	11	2025-10-15 12:22:00	2025-10-25 02:26:16	\N	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	35346	\N	\N	\N	\N	\N	2	\N	\N	19	\N	5233	\N	\N	\N	\N	\N	\N	30	0	\N	0	\N	\N	\N	\N
38	38	2025-10-16	هاجر	1	01270501000	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	45	8	7	5	2751	63	2025-10-16 18:26:12	2025-10-16 18:27:39	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	هاجر	\N	5005	\N	\N	\N	\N	\N	\N	30	2	مزاجي كده	2	مالكش دعوة	\N	\N	\N
39	39	2025-10-16	هاجر 2	\N	\N	\N	\N	\N	العنوان بالتفصيل الممل	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	48	\N	\N	\N	2752	66	2025-10-16 21:26:35	2025-10-16 21:26:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	هاجر 2	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
40	40	2025-10-16	هاجر 3	\N	\N	hager3@hager.com	\N	\N	العنوان بالتفصيل الممل	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	48	\N	\N	\N	2753	66	2025-10-16 21:37:01	2025-10-16 21:37:43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	02	\N	\N	\N	\N	\N	\N	\N	\N	هاجر 3	\N	6001	\N	\N	\N	\N	\N	\N	\N	1	\N	1	\N	\N	\N	\N
6	6	2025-10-06	بسنت سامح	1	01005206971	\N	\N	\N	415 555	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	2	1	\N	\N	7	\N	2590	11	2025-10-06 12:41:12	2025-10-18 17:11:17	\N	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	011	\N	\N	\N	3	6	\N	\N	\N	هند حسني	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
10	10	2025-10-13	مها أحمد	1	05600002530	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	\N	7	\N	2719	11	2025-10-13 23:34:33	2025-10-18 17:12:20	\N	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	\N	\N	\N	محمود	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
12	12	2025-10-15	بسنت 200	2	01005206971	basent@rabiherp.com	\N	\N	شارع الشعراوي	\N	2025-10-01	\N	\N	\N	1	2	\N	\N	\N	pending	7	11	38	9	8	4	2725	11	2025-10-15 12:02:33	2025-10-18 22:17:23	8	\N	\N	\N	\N	3	4	P	\N	\N	\N	\N	\N	\N	\N	\N	010	012	013	Yes	3	8	2	7	\N	Basanet 200	\N	206	\N	\N	\N	2025-10-01	12	34	30	1	\N	2	كدا	\N	\N	6
42	42	2025-10-21	فتحي الصعيدي	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2770	75	2025-10-21 12:43:43	2025-10-21 12:43:43	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	F	\N	\N	\N	\N	\N	\N	\N	\N	30	0	\N	0	\N	\N	\N	\N
41	41	2025-10-21	أميرة منصور	1	01113492390	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2765	1	2025-10-21 12:36:54	2025-10-21 13:27:51	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	أميرة منصور	\N	\N	\N	\N	\N	\N	\N	\N	30	0	\N	0	\N	\N	\N	\N
44	44	2025-10-21	عمر النشرتي	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2773	62	2025-10-21 16:32:50	2025-10-21 16:32:50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	\N	\N	\N	عمر النشرتي	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
45	45	2025-10-25	النشرتي	1	0102404444	ااااااارررر	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	9	38	8	7	5	2775	62	2025-10-21 16:46:01	2025-10-25 02:08:52	8	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	3	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	\N	2	كدا	\N	\N	\N
46	46	2025-10-21	نشرتي 1	مستوي 3	0120000	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	43	\N	\N	\N	2776	60	2025-10-21 16:47:56	2025-10-21 16:47:56	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	نشرتي 1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
49	49	2025-10-21	أمير 5	3	01119300303	a5@h	\N	\N	\N	\N	\N	\N	\N	\N	12345	\N	\N	\N	\N	\N	7	11	43	9	8	4	2780	60	2025-10-21 17:56:16	2025-10-21 17:56:16	8	\N	\N	\N	\N	12345 it	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	2	3	4	1	3	13	\N	\N	\N	أمير 5	\N	6060	\N	\N	\N	2025-10-01T00:00:00.000	123456	505005	\N	\N	\N	\N	\N	\N	\N	32
48	48	2025-10-21	حسن	2	123456	h@h	\N	\N	\N	\N	\N	\N	\N	\N	123578	\N	\N	\N	\N	\N	2	11	38	8	7	4	2779	62	2025-10-21 17:56:04	2025-10-21 18:06:44	8	\N	\N	\N	\N	135789	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	12366545	13398786	42368422	\N	3	8	\N	1	\N	حسن	\N	١	\N	\N	\N	2025-10-21T00:00:00.000	124678	134	\N	1	\N	2	999999999999	\N	\N	24
43	43	2025-10-25	عمر النشرتي	1	1234	omarelnasherty@gmail.com	\N	\N	sharm sheikh	\N	\N	\N	\N	company	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2772	62	2025-10-21 16:21:49	2025-10-25 02:13:17	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	35346	\N	\N	\N	\N	\N	\N	\N	\N	Henry	\N	5	\N	\N	\N	\N	\N	\N	\N	1	\N	2	تجربة	\N	\N	\N
57	57	2025-10-25	ايميل	1	٤٤٤٤٤	omartest	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	2	1	43	8	7	5	2794	60	2025-10-25 02:28:58	2025-10-25 02:28:58	8	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	6	\N	\N	\N	ايميل	\N	8155	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
47	47	2025-10-21	امير	1	123456789	a@h	\N	\N	العبور	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2777	11	2025-10-21 17:46:01	2025-10-21 18:44:05	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	amir	\N	666666	\N	\N	\N	\N	\N	\N	30	1	\N	2	12345	\N	\N	\N
50	50	2025-10-21	احمد	1	123456	a@a	\N	\N	\N	\N	\N	\N	\N	\N	23578	\N	\N	\N	\N	\N	2	11	38	8	7	5	2781	62	2025-10-21 18:46:09	2025-10-21 18:46:09	8	\N	\N	\N	\N	135789	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	12357	126688	139841	1	3	9	\N	4	\N	احمد	\N	٢	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	25
51	51	2025-10-21	محمد	1	01119300300	m@m	\N	\N	\N	\N	\N	\N	\N	\N	١٢٤٧	\N	\N	\N	\N	\N	7	11	38	9	7	4	2782	62	2025-10-21 18:49:32	2025-10-21 18:49:32	8	\N	\N	\N	\N	١٣٦٨	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	01119300301	01119300302	01119300304	\N	3	9	\N	4	\N	محمد	\N	٣	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	25
52	52	2025-10-21	هاجر 500	1	01062201061	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2783	11	2025-10-21 18:51:49	2025-10-21 18:51:49	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	01062201062	01062201063	01062201064	\N	3	\N	2	\N	\N	هاجر 500	\N	\N	\N	\N	\N	\N	\N	\N	30	0	\N	0	\N	\N	\N	\N
53	53	2025-10-21	رضا	1	01119300300	r@r	\N	\N	\N	\N	\N	\N	\N	\N	١٢٣٥٦	\N	\N	\N	\N	\N	2	11	38	8	8	5	2784	62	2025-10-21 18:52:06	2025-10-21 18:52:06	8	\N	\N	\N	\N	١٣٥٦٧	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	01119300301	01119300302	01119300304	\N	3	9	\N	4	\N	رضا	\N	١	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	24
58	58	2025-10-25	تجربه ايميل	مستوي 3	0120000	تجربه ايميل	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2795	62	2025-10-25 02:31:18	2025-10-25 02:31:18	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	تجربه ايميل	\N	59090	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
59	59	2025-10-25	كريم حلمي	1	0550600937	karim@karim.com	\N	\N	\N	\N	\N	\N	\N	\N	555	\N	\N	\N	\N	\N	5	9	45	9	8	5	2796	63	2025-10-25 08:55:39	2025-10-25 08:55:39	8	\N	\N	\N	\N	666	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	010	013	014	1	3	5	\N	8	\N	كريم حلمي	\N	4006	\N	\N	\N	2025-10-01T00:00:00.000	22	55	\N	\N	\N	\N	\N	\N	\N	\N
55	55	2025-10-22	حسن 2	2	123456	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	9	\N	\N	2786	62	2025-10-22 11:35:50	2025-10-22 11:35:50	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	\N	\N	\N	حسن 2	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
56	56	2025-10-22	هنري	1	1234	\N	\N	\N	sharm sheikh	\N	\N	\N	\N	company	\N	\N	\N	\N	\N	\N	\N	\N	44	\N	\N	\N	2787	61	2025-10-22 14:27:08	2025-10-22 14:27:08	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	35346	\N	\N	\N	\N	\N	\N	\N	\N	Henry	\N	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
54	54	2025-10-21	حسام	3	010123456789	hj@hj	\N	\N	\N	\N	\N	\N	\N	\N	55	\N	\N	\N	\N	important	7	11	44	9	8	5	2785	11	2025-10-21 22:35:21	2025-10-23 17:06:24	8	\N	\N	\N	\N	66	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	22	33	44	Yes	3	8	\N	1	\N	حسام	\N	5008	\N	\N	\N	2025-10-01	55	88	\N	1	\N	1	\N	\N	\N	9
60	60	2025-10-26	عماد الدين	1	055555	emad@emad.com	\N	\N	تفصيل	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	10	14	38	12	9	8	2799	1	2025-10-26 15:07:53	2025-10-26 15:12:21	10	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	Yes	5	15	2	3	\N	Emad El Din	\N	9000	\N	\N	\N	\N	\N	\N	30	1	\N	1	\N	\N	\N	\N
\.


--
-- Data for Name: customers_files; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.customers_files (id, "File", "Customer", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: customers_groups; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.customers_groups (id, "Arabic_Name", "English_Name", created_at, updated_at, "Discount") FROM stdin;
3	مجموعة عامة	General Group	\N	\N	0
4	الأرشيف	الأرشيف	2025-10-26 14:58:24	2025-10-26 14:58:24	0
5	الجدد	الجدد	2025-10-26 14:58:40	2025-10-26 14:58:40	0
\.


--
-- Data for Name: customers_rate_types; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.customers_rate_types (id, "Arabic_Name", "English_Name", "Color", created_at, updated_at) FROM stdin;
1	ممتاز	.	#75d369	2025-10-02 15:25:29	2025-10-02 15:25:29
2	جيد جداُ	جيد جداُ	#de1212	2025-10-26 14:55:28	2025-10-26 14:55:28
3	ضعيف	2	#876b1c	2025-10-26 14:55:43	2025-10-26 14:55:43
\.


--
-- Data for Name: customers_tickets; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.customers_tickets (id, "Code", "Problem", "Status", "Bill_Number", "Responsible", "Customer", "User", created_at, updated_at, "ProblemEn", arr, "TicketIssues", "Date") FROM stdin;
1	1	مشكلة كبيرة جدا	2	5	76	1	11	2025-10-12 15:57:55	2025-10-15 03:33:54	مشكلة كبيرة جدا	\N	1	2025-10-12
3	3	المشكلة بالعربية	1	39	48	25	11	2025-10-15 16:49:30	2025-10-15 16:49:30	English Problem	\N	1	2025-10-15
4	4	المشكله بالعربيه	1	40	48	28	11	2025-10-15 16:55:19	2025-10-15 16:55:19	المشكله بالانجليزيه	\N	1	2025-10-15
2	2	ffffffff	2	\N	38	1	62	2025-10-15 03:59:03	2025-10-15 04:03:18	we have a problem	\N	1	2025-10-15
5	5	..mmm	1	1	38	27	62	2025-10-15 16:56:29	2025-10-15 16:56:29	...	\N	1	2025-10-15
6	6	تست	1	1	38	2	62	2025-10-16 17:49:52	2025-10-16 17:49:52	test	\N	1	2025-10-16
7	7	تست	2	20	38	5	62	2025-10-16 17:52:21	2025-10-16 18:03:47	test	\N	1	2025-10-16
9	8	وصف المشكلة	2	53	48	38	66	2025-10-16 21:41:07	2025-10-16 22:02:04	مشكلة عربي	\N	1	2025-10-16
11	9	مشكله	2	39	38	25	62	2025-10-18 23:32:37	2025-10-18 23:32:51	problem	\N	1	2025-10-18
12	10	22222	1	\N	38	47	62	2025-10-21 18:11:41	2025-10-21 18:11:41	2222	\N	1	2025-10-21
13	11	٢٣٣٤٤	1	65	38	47	62	2025-10-21 18:17:58	2025-10-21 18:17:58	١٣٤٥٦	\N	1	2025-10-21
14	12	2222	1	\N	43	48	60	2025-10-21 18:21:07	2025-10-21 18:21:07	2222	\N	1	2025-10-21
15	12	8888888	1	66	38	47	11	2025-10-21 18:22:59	2025-10-21 18:22:59	333333333	\N	1	2025-10-21
17	14	المشكله بالعربيه	1	67	45	54	11	2025-10-22 10:11:45	2025-10-22 10:11:45	المشكله بالانجليزيه	\N	1	2025-10-22
16	13	المشكله بالعربيه	2	67	38	54	11	2025-10-22 10:09:55	2025-10-22 10:12:15	المشكله بالانجليزيه	\N	1	2025-10-22
18	15	....	1	67	38	54	62	2025-10-22 11:11:28	2025-10-22 11:11:28	.....	\N	1	2025-10-22
19	15	المشكله بالعربيه	1	67	40	54	11	2025-10-22 11:11:41	2025-10-22 11:11:41	المشكله بالانجليزيه	\N	1	2025-10-22
20	16	.....	1	67	38	54	62	2025-10-22 11:12:20	2025-10-22 11:12:20	٩٩٩٩٩	\N	1	2025-10-22
22	18	دددد	2	67	38	54	62	2025-10-22 11:13:38	2025-10-22 11:14:31	٦٦٦٦	\N	1	2025-10-22
24	20	مشكله كبيره	1	4	38	20	62	2025-10-23 13:17:09	2025-10-23 13:17:09	Big Problem	\N	\N	2025-10-23
25	21	9888888	1	67	82	54	76	2025-10-23 17:08:40	2025-10-23 17:09:36	مشكلة 1	\N	1	2025-10-23
26	22	العميل يشتكي من كذا	2	67	45	54	63	2025-10-25 08:46:58	2025-10-25 08:47:21	Customers	\N	1	2025-10-25
27	23	تسريب غاز	2	74	80	60	1	2025-10-26 15:20:16	2025-10-26 15:21:11	تسريب غاز	\N	1	2025-10-26
\.


--
-- Data for Name: deducations_types; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.deducations_types (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: deductions; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.deductions (id, "Code", "Date", "Month", "Amount", "Draw", "Note", "Emp", "Coin", "Type", "User", arr, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: default_data_show_hides; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.default_data_show_hides (id, "Status", "Shipping_Company", "Vendor_Date", "Expire_Date", "Total_BF_Taxes", "Total_Taxes", "Coin", "Draw", "Delegate_Sale", "Delegate_Purchase", "Note", "Refrence_Number", created_at, updated_at, "Cost_Center", "Branch", "Serial_Num", "Pass", "Pattern_Image", "Barcode_Print", "Unit_Print", "Total_BF_Print", "Discount_Print", "Tax_Print", "A5", "A4", "CM8", "Group_Brand", "Patch_Number", "Manufacturing_Model_Shortcomings", "Search_Typical", "Validity_Product", "Executor_Sale", "Totuch_Screen", "Tax_POS", "TotalDiscountPrint", "TotalTaxPrint", "ProductsNumber", "TotalQtyPrint", "Credit", "Barcode", "Taknet", "Address", "Phone1", "Phone2", "Phone3", "Phone4", "Text", "Seal", "Code_Report", "Unit", "Refrence_Number_Print", "Icon_Payment_Recipt", "SearchCode", "TaxOnTotal", "TotalBfTax", "AvQty", "Disc", "Tax", "Store", "TaxBill", "Change_Way_Stores_Transfer", "Note_POS", "Open_Drawer", client_delivery, "POS_RecivedDate", "POS_Barcode", "POS_Qty", "Show_File_InsurancePaper", "Show_File_Checks", "Show_File_Purchases", "Show_File_Sales", "Show_File_PaymentVoucher", "Show_File_ReciptVoucher", "Show_File_TransferStores", "Thickness_Print", "Height_Print", "Thickness", "Height", "Items_Guide_Store_Show", "Sales_Pro_Desc", "Show_Barcode", "Show_Net", "Show_Unit", "Show_Total", "ChassisNumber", "MotorNumber", "Shipping_Price", "OpenInputTransferSales") FROM stdin;
1	0	0	0	0	0	0	1	1	1	0	0	0	2021-12-07 14:08:32	2025-10-26 15:34:32	0	0	0	0	0	0	1	0	1	0	0	1	1	0	1	1	0	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	1	1	1	0	0	1	1
\.


--
-- Data for Name: delivery_apps; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.delivery_apps (id, "Arabic_Name", "English_Name", "Type", "Account", "Status", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: depaarture_policy_emps; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.depaarture_policy_emps (id, "From", "To", "Discount", "Emp", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: departure_emps; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.departure_emps (id, "In_Time", "Out_Time", "Hours_Number", "Date", "Month", "Note", "Departure", "Emp", created_at, updated_at, "Disc_Late", "Disc_Early") FROM stdin;
7	17:34	17:36	0.03	2025-10-02	2025-10	\N	2	53	2025-10-02 17:36:41	2025-10-02 17:36:41	0	0
8	17:10	23:44	6.57	2025-10-07	2025-10	\N	3	44	2025-10-13 23:44:32	2025-10-13 23:44:32	0	0
\.


--
-- Data for Name: departures; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.departures (id, "Code", "Date", "Month", "Note", "Attend", "User", arr, created_at, updated_at) FROM stdin;
2	1	2025-10-02	2025-10	\N	3	1	\N	\N	\N
3	2	2025-10-07	2025-10	\N	4	1	\N	\N	\N
\.


--
-- Data for Name: desvice_cases; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.desvice_cases (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
3	جديد	New	2022-02-18 01:21:48	2024-02-09 01:04:51
\.


--
-- Data for Name: device_descrips; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.device_descrips (id, "Arabic_Name", "English_Name", "Sort", created_at, updated_at) FROM stdin;
8	جديد	New	0	2022-04-13 02:50:50	2022-04-13 02:50:50
9	مستعمل	Used	1	2022-06-20 21:54:53	2022-06-20 21:54:53
\.


--
-- Data for Name: devices_typesies; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.devices_typesies (id, "Arabic_Name", "English_Name", "Company", created_at, updated_at) FROM stdin;
6	Oppo	Oppo	14	2022-04-13 02:50:40	2022-04-13 02:50:40
\.


--
-- Data for Name: disclaimers; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.disclaimers (id, "Date", "File", "Emp", "Note", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: discounts_emps; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.discounts_emps (id, "AmountDiscount", "Discount", "Emp", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: domains; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.domains (id, domain, tenant_id, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_covenants; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.emp_covenants (id, "Emp", "Date", "Name", "Price", "Reason", "Life_Expectancy", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_excs; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.emp_excs (id, "Name", "Account", "Emp_Type", "Salary", "Phone", "Job", "Department", "Store1", "Store2", "Store3", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_installment_details; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.emp_installment_details (id, "Date", "Value", "Status", "Emp", "Install", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_installments; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.emp_installments (id, "Amount", "Years_Number", "First_Date", "Install", "Install_Numbers", "Status", "Emp", "Loan", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_mails; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.emp_mails (id, "Message", "Emp", "Status", created_at, updated_at) FROM stdin;
1	كيف حالك	79	0	2025-10-13 23:20:50	2025-10-13 23:20:50
\.


--
-- Data for Name: emp_movements; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.emp_movements (id, "Date", "Time", "Emp", "Status", created_at, updated_at) FROM stdin;
1	2025-10-02	17:34	53	1	2025-10-02 17:34:32	2025-10-02 17:34:32
2	2025-10-02	17:34	53	1	2025-10-02 17:34:35	2025-10-02 17:34:35
3	2025-10-02	17:35	53	1	2025-10-02 17:35:16	2025-10-02 17:35:16
4	2025-10-02	17:35	53	1	2025-10-02 17:35:16	2025-10-02 17:35:16
5	2025-10-02	17:36	53	1	2025-10-02 17:36:31	2025-10-02 17:36:31
6	2025-10-02	17:44	54	1	2025-10-02 17:44:08	2025-10-02 17:44:08
7	2025-10-02	17:44	54	1	2025-10-02 17:44:11	2025-10-02 17:44:11
8	2025-10-02	17:46	54	1	2025-10-02 17:46:17	2025-10-02 17:46:17
9	2025-10-02	17:46	54	1	2025-10-02 17:46:17	2025-10-02 17:46:17
10	2025-10-02	17:51	54	0	2025-10-02 17:51:48	2025-10-02 17:51:48
11	2025-10-02	17:57	54	0	2025-10-02 17:57:31	2025-10-02 17:57:31
12	2025-10-02	18:02	54	0	2025-10-02 18:02:50	2025-10-02 18:02:50
13	2025-10-02	18:11	54	0	2025-10-02 18:11:34	2025-10-02 18:11:34
14	2025-10-02	18:13	54	0	2025-10-02 18:13:34	2025-10-02 18:13:34
15	2025-10-02	18:19	54	0	2025-10-02 18:19:15	2025-10-02 18:19:15
16	2025-10-02	18:19	54	0	2025-10-02 18:19:15	2025-10-02 18:19:15
17	2025-10-02	18:24	54	0	2025-10-02 18:24:47	2025-10-02 18:24:47
18	2025-10-02	18:30	54	0	2025-10-02 18:30:19	2025-10-02 18:30:19
19	2025-10-02	18:30	54	0	2025-10-02 18:30:19	2025-10-02 18:30:19
20	2025-10-02	18:35	54	0	2025-10-02 18:35:27	2025-10-02 18:35:27
21	2025-10-02	18:40	54	0	2025-10-02 18:40:54	2025-10-02 18:40:54
22	2025-10-02	18:46	54	0	2025-10-02 18:46:34	2025-10-02 18:46:34
23	2025-10-02	18:50	54	0	2025-10-02 18:50:36	2025-10-02 18:50:36
24	2025-10-02	18:56	54	0	2025-10-02 18:56:10	2025-10-02 18:56:10
25	2025-10-02	18:57	54	0	2025-10-02 18:57:29	2025-10-02 18:57:29
26	2025-10-02	19:03	54	0	2025-10-02 19:03:13	2025-10-02 19:03:13
27	2025-10-02	19:04	54	0	2025-10-02 19:04:17	2025-10-02 19:04:17
28	2025-10-02	19:09	54	0	2025-10-02 19:09:19	2025-10-02 19:09:19
29	2025-10-02	19:14	54	0	2025-10-02 19:14:53	2025-10-02 19:14:53
30	2025-10-02	19:20	54	0	2025-10-02 19:20:52	2025-10-02 19:20:52
31	2025-10-02	19:21	54	0	2025-10-02 19:21:56	2025-10-02 19:21:56
32	2025-10-02	19:27	54	0	2025-10-02 19:27:41	2025-10-02 19:27:41
33	2025-10-02	19:33	54	0	2025-10-02 19:33:44	2025-10-02 19:33:44
34	2025-10-02	19:40	54	0	2025-10-02 19:40:28	2025-10-02 19:40:28
35	2025-10-02	19:40	54	0	2025-10-02 19:40:28	2025-10-02 19:40:28
36	2025-10-02	19:45	54	0	2025-10-02 19:45:41	2025-10-02 19:45:41
37	2025-10-02	19:51	54	0	2025-10-02 19:51:17	2025-10-02 19:51:17
38	2025-10-02	19:51	54	0	2025-10-02 19:51:17	2025-10-02 19:51:17
39	2025-10-02	19:56	54	0	2025-10-02 19:56:19	2025-10-02 19:56:19
40	2025-10-02	20:01	54	0	2025-10-02 20:01:33	2025-10-02 20:01:33
41	2025-10-02	20:07	54	0	2025-10-02 20:07:26	2025-10-02 20:07:26
42	2025-10-02	20:08	54	0	2025-10-02 20:08:43	2025-10-02 20:08:43
43	2025-10-02	20:13	54	0	2025-10-02 20:13:47	2025-10-02 20:13:47
44	2025-10-02	20:19	54	0	2025-10-02 20:19:02	2025-10-02 20:19:02
45	2025-10-02	20:24	54	0	2025-10-02 20:24:35	2025-10-02 20:24:35
46	2025-10-02	20:29	54	0	2025-10-02 20:29:02	2025-10-02 20:29:02
47	2025-10-02	20:34	54	0	2025-10-02 20:34:05	2025-10-02 20:34:05
48	2025-10-02	20:39	54	0	2025-10-02 20:39:05	2025-10-02 20:39:05
49	2025-10-02	20:44	54	0	2025-10-02 20:44:05	2025-10-02 20:44:05
50	2025-10-02	20:49	54	0	2025-10-02 20:49:07	2025-10-02 20:49:07
51	2025-10-02	20:54	54	0	2025-10-02 20:54:08	2025-10-02 20:54:08
52	2025-10-02	20:59	54	0	2025-10-02 20:59:06	2025-10-02 20:59:06
53	2025-10-02	21:04	54	0	2025-10-02 21:04:08	2025-10-02 21:04:08
54	2025-10-02	21:09	54	0	2025-10-02 21:09:14	2025-10-02 21:09:14
55	2025-10-02	21:14	54	0	2025-10-02 21:14:24	2025-10-02 21:14:24
56	2025-10-02	21:19	54	0	2025-10-02 21:19:39	2025-10-02 21:19:39
57	2025-10-02	21:25	54	0	2025-10-02 21:25:19	2025-10-02 21:25:19
58	2025-10-02	21:26	54	0	2025-10-02 21:26:34	2025-10-02 21:26:34
59	2025-10-02	21:32	54	0	2025-10-02 21:32:15	2025-10-02 21:32:15
60	2025-10-02	21:34	54	0	2025-10-02 21:34:07	2025-10-02 21:34:07
61	2025-10-07	17:10	44	1	2025-10-07 17:10:30	2025-10-07 17:10:30
62	2025-10-07	17:10	44	1	2025-10-07 17:10:32	2025-10-07 17:10:32
63	2025-10-07	17:11	44	1	2025-10-07 17:11:32	2025-10-07 17:11:32
64	2025-10-07	17:13	44	1	2025-10-07 17:13:06	2025-10-07 17:13:06
65	2025-10-07	17:13	44	1	2025-10-07 17:13:07	2025-10-07 17:13:07
66	2025-10-07	17:15	44	1	2025-10-07 17:15:21	2025-10-07 17:15:21
67	2025-10-13	23:43	44	1	2025-10-13 23:43:47	2025-10-13 23:43:47
\.


--
-- Data for Name: emp_p_o_s_stores; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.emp_p_o_s_stores (id, "Emp", created_at, updated_at, "Store") FROM stdin;
19	38	2024-02-08 23:54:43	2024-02-08 23:54:43	21
20	39	2024-02-08 23:55:02	2024-02-08 23:55:02	21
21	40	2024-02-08 23:56:24	2024-02-08 23:56:24	21
22	41	2024-02-08 23:57:46	2024-02-08 23:57:46	21
23	42	2024-02-08 23:58:21	2024-02-08 23:58:21	21
24	43	2025-10-02 15:22:50	2025-10-02 15:22:50	21
25	44	2025-10-02 15:22:59	2025-10-02 15:22:59	21
26	45	2025-10-02 15:23:09	2025-10-02 15:23:09	21
27	46	2025-10-02 15:23:17	2025-10-02 15:23:17	21
28	47	2025-10-02 15:23:32	2025-10-02 15:23:32	21
29	48	2025-10-02 15:26:06	2025-10-02 15:26:06	21
30	49	2025-10-02 15:26:10	2025-10-02 15:26:10	21
31	50	2025-10-02 15:26:15	2025-10-02 15:26:15	21
32	51	2025-10-02 15:26:19	2025-10-02 15:26:19	21
33	52	2025-10-02 15:38:17	2025-10-02 15:38:17	21
35	53	2025-10-02 17:36:24	2025-10-02 17:36:24	21
36	54	2025-10-02 17:39:00	2025-10-02 17:39:00	21
37	55	2025-10-06 13:22:37	2025-10-06 13:22:37	21
38	56	2025-10-06 13:24:21	2025-10-06 13:24:21	21
39	57	2025-10-06 13:25:15	2025-10-06 13:25:15	21
40	58	2025-10-06 13:26:16	2025-10-06 13:26:16	21
41	59	2025-10-06 13:26:47	2025-10-06 13:26:47	21
42	60	2025-10-06 13:27:18	2025-10-06 13:27:18	21
43	61	2025-10-06 13:28:18	2025-10-06 13:28:18	21
44	62	2025-10-06 13:28:51	2025-10-06 13:28:51	21
45	63	2025-10-06 13:29:20	2025-10-06 13:29:20	21
46	64	2025-10-06 13:29:43	2025-10-06 13:29:43	21
47	65	2025-10-06 13:30:07	2025-10-06 13:30:07	21
48	66	2025-10-07 11:34:37	2025-10-07 11:34:37	21
49	67	2025-10-07 11:34:55	2025-10-07 11:34:55	21
50	68	2025-10-07 14:38:35	2025-10-07 14:38:35	21
51	69	2025-10-07 14:44:34	2025-10-07 14:44:34	21
52	70	2025-10-07 14:44:54	2025-10-07 14:44:54	21
53	71	2025-10-07 15:54:56	2025-10-07 15:54:56	21
61	72	2025-10-08 13:53:37	2025-10-08 13:53:37	21
63	75	2025-10-08 13:55:19	2025-10-08 13:55:19	21
65	74	2025-10-08 14:11:24	2025-10-08 14:11:24	21
66	76	2025-10-08 14:11:37	2025-10-08 14:11:37	21
68	77	2025-10-08 14:16:44	2025-10-08 14:16:44	21
69	78	2025-10-08 14:16:59	2025-10-08 14:16:59	21
70	79	2025-10-13 22:45:42	2025-10-13 22:45:42	21
71	80	2025-10-19 23:05:24	2025-10-19 23:05:24	2
73	81	2025-10-21 13:13:38	2025-10-21 13:13:38	21
74	82	2025-10-23 10:56:49	2025-10-23 10:56:49	21
\.


--
-- Data for Name: emp_ratios; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.emp_ratios (id, "Salary", "Type", "Emp", created_at, updated_at, "Typee", "From", "To", "Rate") FROM stdin;
25	100	النسبة من الشحن	74	2025-10-08 14:11:24	2025-10-08 14:11:24	4	0	10000000	15.00
26	100	النسبة من الشحن	76	2025-10-08 14:11:37	2025-10-08 14:11:37	4	0	10000000	15.00
28	100	النسبة من الشحن	78	2025-10-08 14:16:59	2025-10-08 14:16:59	4	0	10000000	15.00
\.


--
-- Data for Name: emp_safes; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.emp_safes (id, "Safe", "Emp", created_at, updated_at) FROM stdin;
1	30	43	2025-10-02 15:22:50	2025-10-02 15:22:50
2	30	44	2025-10-02 15:22:59	2025-10-02 15:22:59
3	30	45	2025-10-02 15:23:09	2025-10-02 15:23:09
4	30	46	2025-10-02 15:23:17	2025-10-02 15:23:17
5	30	47	2025-10-02 15:23:32	2025-10-02 15:23:32
6	30	48	2025-10-02 15:26:06	2025-10-02 15:26:06
7	30	49	2025-10-02 15:26:10	2025-10-02 15:26:10
8	30	50	2025-10-02 15:26:15	2025-10-02 15:26:15
9	30	51	2025-10-02 15:26:19	2025-10-02 15:26:19
10	30	52	2025-10-02 15:38:17	2025-10-02 15:38:17
12	30	53	2025-10-02 17:36:24	2025-10-02 17:36:24
13	30	54	2025-10-02 17:39:00	2025-10-02 17:39:00
14	30	55	2025-10-06 13:22:37	2025-10-06 13:22:37
15	30	56	2025-10-06 13:24:21	2025-10-06 13:24:21
16	30	57	2025-10-06 13:25:15	2025-10-06 13:25:15
17	30	58	2025-10-06 13:26:16	2025-10-06 13:26:16
18	30	59	2025-10-06 13:26:47	2025-10-06 13:26:47
19	30	60	2025-10-06 13:27:18	2025-10-06 13:27:18
20	30	61	2025-10-06 13:28:18	2025-10-06 13:28:18
21	30	62	2025-10-06 13:28:51	2025-10-06 13:28:51
22	30	63	2025-10-06 13:29:20	2025-10-06 13:29:20
23	30	64	2025-10-06 13:29:43	2025-10-06 13:29:43
24	30	65	2025-10-06 13:30:07	2025-10-06 13:30:07
25	30	66	2025-10-07 11:34:37	2025-10-07 11:34:37
26	30	67	2025-10-07 11:34:55	2025-10-07 11:34:55
27	30	68	2025-10-07 14:38:35	2025-10-07 14:38:35
28	30	69	2025-10-07 14:44:34	2025-10-07 14:44:34
29	30	70	2025-10-07 14:44:54	2025-10-07 14:44:54
30	30	71	2025-10-07 15:54:56	2025-10-07 15:54:56
38	30	72	2025-10-08 13:53:37	2025-10-08 13:53:37
40	30	75	2025-10-08 13:55:19	2025-10-08 13:55:19
42	30	74	2025-10-08 14:11:24	2025-10-08 14:11:24
43	30	76	2025-10-08 14:11:37	2025-10-08 14:11:37
45	30	77	2025-10-08 14:16:44	2025-10-08 14:16:44
46	30	78	2025-10-08 14:16:59	2025-10-08 14:16:59
47	30	79	2025-10-13 22:45:42	2025-10-13 22:45:42
48	30	80	2025-10-19 23:05:24	2025-10-19 23:05:24
50	30	81	2025-10-21 13:13:38	2025-10-21 13:13:38
51	30	82	2025-10-23 10:56:49	2025-10-23 10:56:49
\.


--
-- Data for Name: empassies; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.empassies (id, "Arabic_Name", "English_Name", "Arabic_Address", "English_Address", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: empassy_reserve_dates; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.empassy_reserve_dates (id, "Code", "Date", "Client", "Purpose", "Empassy", "Booking_Date", "Cost", "Pay", "Residual", "Safe", "Draw", "Coin", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: employesses; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.employesses (id, "Code", "Name", "Emp_Type", "Salary", "Attendence", "Departure", "Hours_Numbers", "Days_Numbers", "Day_Price", "Precentage_of_Sales", "Precentage_of_Profits", "Image", "Bank_Account", "Qualifications", "Address", "Social_Status", "ID_Number", "Contract_Start", "Contract_End", "Phone", "Phone2", "Email", "Password", "Job", "Department", "Account", "Account_Emp", "User", created_at, updated_at, "Note", "Precentage_of_Execution", "Covenant", "Commission", "Price_Level", "Bill_Num", "NumbersOfBill", "EmpSort", "CV", "ID_Image", "Criminal_status", "Contract", health_certificate, "Search_Card", "Recruitment_certificate", employee_profile, duration_criminal_investigation, "Birthdate", "Attitude_recruiting", "Job_Number", date_resignation, "Living", "Branch", "Level", "Religion", "Insurance_salary", "Insurance_companies", "Previous_experience", "Nationality", "MonthlyTarget", "QuarterTarget", "SemiTarget", "YearlyTarget", "IDExpireDate", "LicensExpireDate", "PassportExpireDate", "Merit", "Pro_Group", "NameEn", arr, "SearchCode", "Active", "Delete", "Attendence2", "Departure2", "ShippingCollectionType", "ShippingCollectionValue", "Other_Shift") FROM stdin;
38	5	مندوب مبيعات افتراضي	Saller	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	4	6	53	2502	11	2024-02-08 23:52:53	2024-02-08 23:54:43	\N	\N	2504	2503	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2505	\N	Default Sales	\N	\N	1	0	\N	\N	\N	\N	\N
39	6	مندوب مشتريات افتراضي	Buyer	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2506	11	2024-02-08 23:54:06	2024-02-08 23:55:02	\N	\N	2508	2507	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2509	\N	Default Purchaser	\N	\N	1	0	\N	\N	\N	\N	\N
40	7	مهندس افتراضي	Engineer	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	7	26	53	2510	11	2024-02-08 23:56:24	2024-02-08 23:56:24	\N	\N	2512	2511	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2513	\N	Default Eng	\N	\N	1	0	\N	\N	\N	\N	\N
41	8	مندوب توصيل افتراضي	Delivery	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	21	53	2514	11	2024-02-08 23:57:46	2024-02-08 23:57:46	\N	\N	2516	2515	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2517	\N	Default Delivery	\N	\N	1	0	\N	\N	\N	\N	\N
42	9	نادل افتراضي	Waiter	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	21	53	2518	11	2024-02-08 23:58:21	2024-02-08 23:58:21	\N	\N	2520	2519	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2521	\N	Default Waiter	\N	\N	1	0	\N	\N	\N	\N	\N
43	1	طيار 1	Delivery	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2536	11	2025-10-02 15:22:50	2025-10-02 15:22:50	\N	\N	2538	2537	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2539	\N	طيار 1	\N	\N	1	0	\N	\N	\N	\N	No
44	2	طيار 2	Delivery	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2540	11	2025-10-02 15:22:59	2025-10-02 15:22:59	\N	\N	2542	2541	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2543	\N	طيار 2	\N	\N	1	0	\N	\N	\N	\N	No
45	3	طيار 3	Delivery	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2544	11	2025-10-02 15:23:09	2025-10-02 15:23:09	\N	\N	2546	2545	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2547	\N	طيار 3	\N	\N	1	0	\N	\N	\N	\N	No
46	4	طيار 4	Delivery	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2548	11	2025-10-02 15:23:17	2025-10-02 15:23:17	\N	\N	2550	2549	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2551	\N	طيار 4	\N	\N	1	0	\N	\N	\N	\N	No
47	5	طيار 5	Delivery	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2552	11	2025-10-02 15:23:32	2025-10-02 15:23:32	\N	\N	2554	2553	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2555	\N	طيار 5	\N	\N	1	0	\N	\N	\N	\N	No
48	6	بياع 1	Manager	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2556	11	2025-10-02 15:26:06	2025-10-02 15:26:06	\N	\N	2558	2557	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2559	\N	بياع 1	\N	\N	1	0	\N	\N	\N	\N	No
49	7	بياع 2	Manager	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2560	11	2025-10-02 15:26:10	2025-10-02 15:26:10	\N	\N	2562	2561	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2563	\N	بياع 2	\N	\N	1	0	\N	\N	\N	\N	No
50	8	بياع 3	Manager	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2564	11	2025-10-02 15:26:15	2025-10-02 15:26:15	\N	\N	2566	2565	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2567	\N	بياع 3	\N	\N	1	0	\N	\N	\N	\N	No
51	9	بياع 4	Manager	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2568	11	2025-10-02 15:26:19	2025-10-02 15:26:19	\N	\N	2570	2569	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2571	\N	بياع 4	\N	\N	1	0	\N	\N	\N	\N	No
52	10	بائع 6	Manager	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2573	11	2025-10-02 15:38:17	2025-10-02 15:38:17	\N	\N	2575	2574	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2576	\N	بائع 6	\N	\N	1	0	\N	\N	\N	\N	No
53	11	موظف 1	Manager	1	17:30	17:40	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2578	11	2025-10-02 17:31:30	2025-10-02 17:36:24	\N	\N	2580	2579	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2581	\N	موظف 1	\N	\N	1	0	\N	\N	0	\N	No
54	12	موظف 10	Manager	1	17:40	22:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2582	11	2025-10-02 17:39:00	2025-10-02 17:39:00	\N	\N	2584	2583	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2585	\N	موظف 10	\N	\N	1	0	\N	\N	\N	\N	No
55	13	سائق 1	Driver	0	09:00:00	17:00:00	240	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	26	97	2594	1	2025-10-06 13:22:37	2025-10-06 13:22:37	\N	\N	2596	2595	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	\N	\N	\N	\N	0	0	0	0	\N	\N	\N	2597	\N	سائق 1	\N	\N	1	0	\N	\N	0	20	No
56	14	سائق 2	Driver	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	26	53	2598	1	2025-10-06 13:24:21	2025-10-06 13:24:21	\N	\N	2600	2599	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2601	\N	سائق 2	\N	\N	1	0	\N	\N	1	\N	No
57	15	سائق 2	Driver	1	09:00	17:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	26	53	2602	1	2025-10-06 13:25:15	2025-10-06 13:25:15	\N	\N	2604	2603	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2605	\N	سائق 2	\N	\N	1	0	\N	\N	0	30	No
58	16	سائق 3	Driver	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	26	53	2606	1	2025-10-06 13:26:16	2025-10-06 13:26:16	\N	\N	2608	2607	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	7	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2609	\N	سائق 3	\N	\N	1	0	\N	\N	0	\N	No
59	17	سائق 4	Driver	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	26	53	2610	1	2025-10-06 13:26:47	2025-10-06 13:26:47	\N	\N	2612	2611	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2613	\N	سائق 4	\N	\N	1	0	\N	\N	0	\N	No
60	18	سائق 5	Driver	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	26	53	2614	1	2025-10-06 13:27:18	2025-10-06 13:27:18	\N	\N	2616	2615	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	9	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2617	\N	سائق 5	\N	\N	1	0	\N	\N	0	50	No
61	19	عامل 1	Worker	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	26	53	2618	1	2025-10-06 13:28:18	2025-10-06 13:28:18	\N	\N	2620	2619	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2621	\N	عامل 1	\N	\N	1	0	\N	\N	0	10	No
62	20	عامل 2	Worker	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	26	53	2622	1	2025-10-06 13:28:51	2025-10-06 13:28:51	\N	\N	2624	2623	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2625	\N	عامل 2	\N	\N	1	0	\N	\N	0	20	No
63	21	عامل 3	Worker	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	26	53	2626	1	2025-10-06 13:29:20	2025-10-06 13:29:20	\N	\N	2628	2627	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2629	\N	عامل 3	\N	\N	1	0	\N	\N	0	30	No
64	22	عامل 4	Worker	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	26	53	2630	1	2025-10-06 13:29:43	2025-10-06 13:29:43	\N	\N	2632	2631	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2633	\N	عامل 4	\N	\N	1	0	\N	\N	0	40	No
65	23	عامل 5	Worker	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	26	53	2634	1	2025-10-06 13:30:07	2025-10-06 13:30:07	\N	\N	2636	2635	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2637	\N	عامل 5	\N	\N	1	0	\N	\N	0	50	No
66	24	احمد	Driver	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2638	1	2025-10-07 11:34:37	2025-10-07 11:34:37	\N	\N	2640	2639	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2641	\N	احمد	\N	\N	1	0	\N	\N	0	50	No
67	25	تامر	Worker	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2642	1	2025-10-07 11:34:55	2025-10-07 11:34:55	\N	\N	2644	2643	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2645	\N	تامر	\N	\N	1	0	\N	\N	\N	\N	No
68	26	محمد	Worker	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2652	1	2025-10-07 14:38:35	2025-10-07 14:38:35	\N	\N	2654	2653	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2655	\N	محمد	\N	\N	1	0	\N	\N	0	100	No
69	27	خالد	Worker	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2656	1	2025-10-07 14:44:34	2025-10-07 14:44:34	\N	\N	2658	2657	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2659	\N	خالد	\N	\N	1	0	\N	\N	0	100	No
70	28	محمود	Driver	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2660	1	2025-10-07 14:44:54	2025-10-07 14:44:54	\N	\N	2662	2661	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2663	\N	محمود	\N	\N	1	0	\N	\N	0	100	No
71	29	مندوب 1	Saller	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2669	11	2025-10-07 15:54:56	2025-10-07 15:54:56	\N	\N	2671	2670	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2672	\N	مندوب 1	\N	\N	1	0	\N	\N	0	10	No
74	32	مندوب نسبة	Saller	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2681	11	2025-10-08 13:46:28	2025-10-08 14:11:24	\N	\N	2683	2682	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2684	\N	مندوب نسبة	\N	\N	1	0	\N	\N	1	\N	No
72	30	مندوب قيمة	Saller	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2673	11	2025-10-08 13:45:26	2025-10-08 13:53:37	\N	\N	2675	2674	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2676	\N	مندوب قيمة	\N	\N	1	0	\N	\N	0	10	No
75	33	سائق قيمة	Driver	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2685	11	2025-10-08 13:46:43	2025-10-08 13:55:19	\N	\N	2687	2686	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2688	\N	سائق قيمة	\N	\N	1	0	\N	\N	0	10	No
76	34	سائق نسبة	Driver	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2689	11	2025-10-08 13:47:02	2025-10-08 14:11:37	\N	\N	2691	2690	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2692	\N	سائق نسبة	\N	\N	1	0	\N	\N	1	\N	No
77	35	عامل قيمة	Worker	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2693	11	2025-10-08 13:47:18	2025-10-08 14:16:44	\N	\N	2695	2694	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2696	\N	عامل قيمة	\N	\N	1	0	\N	\N	0	10	No
78	36	عامل نسبة	Worker	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2697	11	2025-10-08 13:47:37	2025-10-08 14:16:59	\N	\N	2699	2698	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2700	\N	عامل نسبة	\N	\N	1	0	\N	\N	1	\N	No
79	37	هدايا 1	Manager	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2715	11	2025-10-13 22:45:42	2025-10-13 22:45:42	\N	\N	2717	2716	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2718	\N	هدايا 1	\N	\N	1	0	\N	\N	\N	\N	No
80	38	احمد عادل	Saller	11000	09:00:00	17:00	8	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	4	21	824	2754	62	2025-10-19 23:05:24	2025-10-19 23:05:24	\N	\N	2756	2755	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	271993	\N	\N	\N	\N	\N	\N	\N	\N	\N	1000000	3000000	6000000	12000000	\N	\N	\N	2757	33	Ahmed adel	\N	\N	1	0	\N	\N	1	\N	No
81	39	هاجر مجدي	Saller	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2766	1	2025-10-21 12:37:33	2025-10-21 13:13:38	\N	\N	2768	2767	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2769	\N	هاجر	\N	\N	1	0	\N	\N	0	\N	No
82	40	كامل	Manager	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2790	11	2025-10-23 10:56:49	2025-10-23 10:56:49	\N	\N	2792	2791	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2793	\N	كامل	\N	\N	1	0	\N	\N	\N	\N	No
\.


--
-- Data for Name: employment_levels; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.employment_levels (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emps_producation_points; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.emps_producation_points (id, "Month", "Point", "Emp", created_at, updated_at, "Date") FROM stdin;
\.


--
-- Data for Name: emps_producation_quantities; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.emps_producation_quantities (id, "FromQ", "ToQ", "ValueQ", "Emp", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: entitlements; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.entitlements (id, "Code", "Date", "Month", "Amount", "Draw", "Note", "Emp", "Coin", "Type", "User", arr, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: events; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.events (id, "Start_Date", "End_Date", "Event_Ar_Name", "Event_En_Name", "Type", "Type_ID", "Type_Code", "Emp", "Client", "Product", "Customer", created_at, updated_at) FROM stdin;
22	2025-10-31	2025-10-31	صرف شيك صادر	Cashing an exporting check	شيك صادر	\N	1	\N	2641	\N	\N	2025-10-19 13:19:01	2025-10-19 13:19:01
23	2025-10-24	2025-10-24	وصل امانة	Insurance Paper	وصل امانة	\N	1	\N	2505	\N	\N	2025-10-19 13:21:32	2025-10-19 13:21:32
24	2025-10-23	2025-10-23	تسليم امر شغل	Job Order Recived	امر شغل	\N	1	38	2535	\N	\N	2025-10-21 12:41:47	2025-10-21 12:41:47
\.


--
-- Data for Name: examinations_types; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.examinations_types (id, "Name", "Allow_From", "Allow_To", "Unit", created_at, updated_at, "NameEn") FROM stdin;
\.


--
-- Data for Name: exchange_commissions; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.exchange_commissions (id, "Code", "Date", "Month", "Note", "Return_Maintaince", "Draw", "Amount", "Commision", "Pre_Sales", "Pre_Execu", "Safe", "Coin", "Cost_Center", "Emp", "User", arr, created_at, updated_at, "Total_Exchange_Commision", "Collection", "Delete") FROM stdin;
\.


--
-- Data for Name: execute_job_order_models; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.execute_job_order_models (id, "Model", "Qty", "Total_Cost", "Outcome", "Execute", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: execute_job_order_workmanships; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.execute_job_order_workmanships (id, "Product_Code", "P_Ar_Name", "P_En_Name", "Qty", "Price", "Discount", "TDiscount", "Tax", "Total_Bf_Tax", "Total_Tax", "Total", "Store", "Product", "Unit", "Execute", created_at, updated_at, "Total_Net") FROM stdin;
\.


--
-- Data for Name: execute_job_orders; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.execute_job_orders (id, "Code", "Date", "Note", "Client", "Executor", "Delegate", "RecivedDate", "Recipient", "Order", created_at, updated_at, "Transfer", "Edit", "Delete", "Edit_New_Code", "Current_Credit", "Model", "Status") FROM stdin;
1	1	2025-10-21	\N	2535	\N	38	2025-10-23	\N	1	\N	\N	\N	0	0	0	\N	\N	0
\.


--
-- Data for Name: executing_receiving_secretariats; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.executing_receiving_secretariats (id, "Code", "Date", "Qty", "Total", "Model", "User", "Time", "Branch", "StoreIn", "StoreOut", "Client", arr, created_at, updated_at, "Total_Workmanship_Price") FROM stdin;
\.


--
-- Data for Name: executing_receivings; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.executing_receivings (id, "Code", "Date", "Qty", "Total", "Model", "User", created_at, updated_at, "Branch", "Time", "StoreIn", "StoreOut", "Sort", "Vendor", "Cost_Workmentship", "Total_Workmentship", arr) FROM stdin;
\.


--
-- Data for Name: executor_filters; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.executor_filters (id, "Product", "Code", "Name", "VName", "VVName", "V1", "V2", "Qty", "Price", "Total", "Emp", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: expenses_list_column_sechdules; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.expenses_list_column_sechdules (id, "Date", "Code_Type", "Statement", "Debitor", "Cost_Center", "Coin", "User", "Account", "Branch", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	1	\N	2025-10-20 17:16:01
\.


--
-- Data for Name: expenses_list_columns; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.expenses_list_columns (id, "Date", "Code_Type", "Statement", "Debitor", "Cost_Center", "Coin", "User", "Account", "Branch", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	1	\N	2022-10-17 21:37:09
\.


--
-- Data for Name: expenses_type_projects; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.expenses_type_projects (id, "Arabic_Name", "English_Name", "Project", "Account", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: expire_date_qties; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.expire_date_qties (id, "Qty", "P_Ar_Name", "P_En_Name", "P_Code", "PP_Code", "PPP_Code", "PPPP_Code", "V_Name", "VV_Name", "Store", "Unit", "Product", "V1", "V2", "Low_Unit", "Exp_Date", "Group", "Brand", "Branch", created_at, updated_at, "Hold_Qty") FROM stdin;
\.


--
-- Data for Name: export_checks; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.export_checks (id, "Code", "Date", "Draw", "Note", "Check_Num", "Due_Date", "Amount", "Status", "Reason", "Check_Type", "Coin", "Cost_Center", "Account", "Bank", "Pay_Account", "Bene_Account", "User", created_at, updated_at, "File", arr, "Image", "Signture_Name", "Bank_Branch", "Edit", "Edit_New_Code", "Delete", "BankSafe_Account", "Transfer") FROM stdin;
1	1	2025-10-19	1	\N	100	2025-10-31	1000	0	\N	4	1	\N	2641	2721	42	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
\.


--
-- Data for Name: f_a_q_s; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.f_a_q_s (id, "Arabic_Question", "English_Question", "Arabic_Answer", "English_Answer", created_at, updated_at) FROM stdin;
1	What is Lorem Ipsum?	What is Lorem Ipsum?	Nullam sed neque luctus, maximus diam sed, facilisis orci. Nunc ultricies neque a aliquam sollicitudin. Vivamus sit amet finibus sapien. Duis est dui, sodales nec pretium a, interdum in lacus. Sed et est vel velit vestibulum tincidunt non a felis. Phasellus convallis, diam eu facilisis tincidunt, ex nibh vulputate dolor, eu maximus massa libero vel eros. In vulputate metus lacus, eu vehicula dolor feugiat id. Nulla vitae nisl in ex consequat porttitor vel a lectus. Vestibulum viverra in velit ac consequat. Nullam porta nulla eu dignissim cursus.	Nullam sed neque luctus, maximus diam sed, facilisis orci. Nunc ultricies neque a aliquam sollicitudin. Vivamus sit amet finibus sapien. Duis est dui, sodales nec pretium a, interdum in lacus. Sed et est vel velit vestibulum tincidunt non a felis. Phasellus convallis, diam eu facilisis tincidunt, ex nibh vulputate dolor, eu maximus massa libero vel eros. In vulputate metus lacus, eu vehicula dolor feugiat id. Nulla vitae nisl in ex consequat porttitor vel a lectus. Vestibulum viverra in velit ac consequat. Nullam porta nulla eu dignissim cursus.	2022-06-04 19:39:45	2022-06-04 19:39:45
2	Why do we use it?	Why do we use it?	Cras non gravida urna. Ut venenatis nulla in tellus lobortis, vel mollis lectus condimentum. Duis elementum sapien purus, et sagittis nulla efficitur in. Phasellus vitae eros sed nisi fringilla auctor nec quis nunc. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Pellentesque rutrum faucibus nibh vitae fermentum. Aliquam commodo sem sit amet malesuada consectetur. Ut sit amet vestibulum diam. Etiam quis dictum turpis, eget condimentum velit. Sed cursus odio dapibus, consectetur massa sit amet, fringilla purus.	Cras non gravida urna. Ut venenatis nulla in tellus lobortis, vel mollis lectus condimentum. Duis elementum sapien purus, et sagittis nulla efficitur in. Phasellus vitae eros sed nisi fringilla auctor nec quis nunc. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Pellentesque rutrum faucibus nibh vitae fermentum. Aliquam commodo sem sit amet malesuada consectetur. Ut sit amet vestibulum diam. Etiam quis dictum turpis, eget condimentum velit. Sed cursus odio dapibus, consectetur massa sit amet, fringilla purus.	2022-06-04 19:40:14	2022-06-04 19:40:14
\.


--
-- Data for Name: failed_jobs; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.failed_jobs (id, uuid, connection, queue, payload, exception, failed_at) FROM stdin;
\.


--
-- Data for Name: faults_types; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.faults_types (id, "Arabic_Name", "English_Name", "Note", "Amount", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: fifo_qties; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.fifo_qties (id, "Qty", "P_Ar_Name", "P_En_Name", "P_Code", "PP_Code", "PPP_Code", "PPPP_Code", "V_Name", "VV_Name", "Cost_Price", "Store", "Unit", "Product", "V1", "V2", "Low_Unit", "Exp_Date", "SearchCode1", "SearchCode2", "Group", "Brand", "Branch", "Purchases_Date", created_at, updated_at, "Original_Qty", "Hold_Qty") FROM stdin;
\.


--
-- Data for Name: firewall_ips; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.firewall_ips (id, ip, log_id, blocked, created_at, updated_at, deleted_at) FROM stdin;
\.


--
-- Data for Name: firewall_logs; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.firewall_logs (id, ip, level, middleware, user_id, url, referrer, request, created_at, updated_at, deleted_at) FROM stdin;
1	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/Login	http://localhost:8888/laravel/ERP/public/AdminLogin	_token=Wh8VUBPPpctrwoHMRWnx1DvypLmxzN1uDIRM22YQ&valid_from=eyJpdiI6IktLMytNc0RnSDlXNC9GdDFndC81ckE9PSIsInZhbHVlIjoielhlUVNtU21YMGtzNE9NSEkrK3Q4dz09IiwibWFjIjoiMTJiMjY5MzIwMGM3YTY4YTEyOGMwOTIyOTM4ZDZkYWVhNzQwOGFmMzZiNDYxODNjMWZmODdlNGNjMWU0M2IzNSJ9&email=Admin@test.com&password=******	2022-02-08 09:54:21	2022-02-08 09:54:21	\N
2	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/Login	http://localhost:8888/laravel/ERP/public/AdminLogin	_token=mCKNd0b5SqhsbzCncHR1Zsg4pppOjFi3miWeyJTo&valid_from=eyJpdiI6IklFWlVxK2pZRCsyUHhZNHd2ZzBWUFE9PSIsInZhbHVlIjoibFQvN1dsb0lreTJFT2FSNHoydkRiQT09IiwibWFjIjoiMjNhODUxNWM3ZjUyZGRlZTAwNWUxMmQyZThjZTJjOWMyOGFhNDdiM2Q5MWI0MjI3ZWY4YTcwZThlODVjZDVlMSIsInRhZyI6IiJ9&email=Klar@test.com&password=******	2022-06-01 15:04:13	2022-06-01 15:04:13	\N
3	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/Login	http://localhost:8888/laravel/ERP/public/AdminLogin	_token=mCKNd0b5SqhsbzCncHR1Zsg4pppOjFi3miWeyJTo&valid_from=eyJpdiI6InJVNDBPK3J5QWRlcXJCdnc4cTNKc2c9PSIsInZhbHVlIjoiVnhMQUpZanRXdldjYVd1RTZVcDJCUT09IiwibWFjIjoiMTIyMjZmNWY3OTczZjVmMmUwNmViYjBiMTNiYzU0OTQzN2IwNzUyYjkxZGJhMTM1ZTE4OWYwNjJhNDI1MDAxYSIsInRhZyI6IiJ9&email=Klar@test.com&password=******	2022-06-01 15:04:26	2022-06-01 15:04:26	\N
4	::1	medium	rfi	11	http://localhost:8888/laravel/ERP/public/ContactUSUpdate/1	http://localhost:8888/laravel/ERP/public/ContactUS	_token=cMggGWc3GiRQ9RpsUo0yM0WTatiVJrHf9VyvpkkA&valid_from=eyJpdiI6IkgyZEx5V3BDUzBsa1pLcExjUjlhb0E9PSIsInZhbHVlIjoiTmF5UFh0a0lOYXhuS2ErY1h5Mzc4Zz09IiwibWFjIjoiMGQxYzYxMGEyMjlhMWM5NDJhODM2NmJmMDY2NTQ4ZDZjOTk4OTNhYzQyNmU1M2E1NTc0YmJmY2IxNzg3ZGViYyIsInRhZyI6IiJ9&Arabic_Title=DROP US A LINE&English_Title=DROP US A LINE&Arabic_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&English_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&Opening_Hours=Mon - Sat : 9am - 11pm&Phone1=440000000&Phone2=440000000&Phone_Header=440000000&Email=sales@yousite.com&Arabic_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&English_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&Map=<iframe src="https://www.google.com/maps/embed?pb=" height="350" allowfullscreen></iframe>	2022-06-04 15:25:25	2022-06-04 15:25:25	\N
5	::1	medium	rfi	11	http://localhost:8888/laravel/ERP/public/ContactUSUpdate/1	http://localhost:8888/laravel/ERP/public/ContactUS	_token=cMggGWc3GiRQ9RpsUo0yM0WTatiVJrHf9VyvpkkA&valid_from=eyJpdiI6IkFZZ280WjQ2anpsZ2ZrLy94R3BXYUE9PSIsInZhbHVlIjoiZnRtZjQwU0JWRGs4K2dndm5ZRlRpUT09IiwibWFjIjoiZjM3ZmFkMzUyNmZkYmRlNWVhOWUwZDdjNGM1ZDRmNjg4ZGZkYzQ4MzUyOGMzZTZjZDBjMjNiNjM4NjRmZTRiZSIsInRhZyI6IiJ9&Arabic_Title=DROP US A LINE&English_Title=DROP US A LINE&Arabic_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&English_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&Opening_Hours=Mon - Sat : 9am - 11pm&Phone1=440000000&Phone2=440000000&Phone_Header=440000000&Email=sales@yousite.com&Arabic_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&English_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&Map=<iframe src="https://www.google.com/maps/embed?pb=" height="350" allowfullscreen></iframe>	2022-06-04 15:25:53	2022-06-04 15:25:53	\N
6	::1	medium	rfi	11	http://localhost:8888/laravel/ERP/public/ContactUSUpdate/1	http://localhost:8888/laravel/ERP/public/ContactUS	_token=cMggGWc3GiRQ9RpsUo0yM0WTatiVJrHf9VyvpkkA&valid_from=eyJpdiI6IkFZZ280WjQ2anpsZ2ZrLy94R3BXYUE9PSIsInZhbHVlIjoiZnRtZjQwU0JWRGs4K2dndm5ZRlRpUT09IiwibWFjIjoiZjM3ZmFkMzUyNmZkYmRlNWVhOWUwZDdjNGM1ZDRmNjg4ZGZkYzQ4MzUyOGMzZTZjZDBjMjNiNjM4NjRmZTRiZSIsInRhZyI6IiJ9&Arabic_Title=DROP US A LINE&English_Title=DROP US A LINE&Arabic_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&English_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&Opening_Hours=Mon - Sat : 9am - 11pm&Phone1=440000000&Phone2=440000000&Phone_Header=440000000&Email=sales@yousite.com&Arabic_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&English_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&Map=https://www.google.com/maps/embed?pb=	2022-06-04 15:26:34	2022-06-04 15:26:34	\N
7	::1	medium	rfi	11	http://localhost:8888/laravel/ERP/public/ContactUSUpdate/1	http://localhost:8888/laravel/ERP/public/ContactUS	_token=cMggGWc3GiRQ9RpsUo0yM0WTatiVJrHf9VyvpkkA&valid_from=eyJpdiI6IkFZZ280WjQ2anpsZ2ZrLy94R3BXYUE9PSIsInZhbHVlIjoiZnRtZjQwU0JWRGs4K2dndm5ZRlRpUT09IiwibWFjIjoiZjM3ZmFkMzUyNmZkYmRlNWVhOWUwZDdjNGM1ZDRmNjg4ZGZkYzQ4MzUyOGMzZTZjZDBjMjNiNjM4NjRmZTRiZSIsInRhZyI6IiJ9&Arabic_Title=DROP US A LINE&English_Title=DROP US A LINE&Arabic_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&English_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&Opening_Hours=Mon - Sat : 9am - 11pm&Phone1=440000000&Phone2=440000000&Phone_Header=440000000&Email=sales@yousite.com&Arabic_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&English_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&Map=https://www.google.com/maps/embed?pb=	2022-06-04 15:26:55	2022-06-04 15:26:55	\N
8	::1	medium	xss	11	http://localhost:8888/laravel/ERP/public/AddArticles	http://localhost:8888/laravel/ERP/public/Articles	_token=doVeFV3XD2rH8l1cPooyMAao9nq89yqum3PtXs41&valid_from=eyJpdiI6IlB6U25kQnRaUkZOTHJhOTJwNDIreXc9PSIsInZhbHVlIjoiS2QzTVJwd3paNXNiMUx3UDFGbDAzQT09IiwibWFjIjoiMWQ5NmQ3MThhODI1NDk0NzEyNWZiNTQxYmFlMzQyMTdmMGE0MThmODhkZDE1YmFjNjBkMTUyODBkNGI0YThiOCIsInRhZyI6IiJ9&Date=May 02, 2017&Arabic_Title=IT'S ALL ABOUT HOW YOU WEAR&English_Title=IT'S ALL ABOUT HOW YOU WEAR&Arabic_Desc=<h4 class="modal-title" style="color: rgb(102, 102, 102); letter-spacing: 0.1px;">On sait depuis longtemps que travailler avec du texte lisible et contenant du sens est source de distractions, et empêche de se concentrer sur la mise en page elle-même. L'avantage du Lorem Ipsum sur un texte générique comme 'Du texte. Du texte. Du texte.' est qu'il possède une distribution de lettres plus ou moins normale, et en tout cas comparable avec celle du français standard. De nombreuses suites logicielles de. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum. Sample Text Listing Donec et lacus mattis ipsum feugiat interdum non id sapien. Quisque et mauris eget nisi vestibulum rhoncus molestie a ante. Curabitur pulvinar ex at tempus sodales. Mauris efficitur magna quis lectus lobortis venenatis. Nunc id enim eget augue molestie lobortis in a purus. Donec maximus quam at lectus bibendum, non suscipit nunc tristique. The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</h4><button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin: -1.25rem; padding: 1.25rem;"><span aria-hidden="true"><span class="fal fa-times"></span></span></button>&English_Desc=<h4 class="modal-title" style="color: rgb(102, 102, 102); letter-spacing: 0.1px;">On sait depuis longtemps que travailler avec du texte lisible et contenant du sens est source de distractions, et empêche de se concentrer sur la mise en page elle-même. L'avantage du Lorem Ipsum sur un texte générique comme 'Du texte. Du texte. Du texte.' est qu'il possède une distribution de lettres plus ou moins normale, et en tout cas comparable avec celle du français standard. De nombreuses suites logicielles de. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum. Sample Text Listing Donec et lacus mattis ipsum feugiat interdum non id sapien. Quisque et mauris eget nisi vestibulum rhoncus molestie a ante. Curabitur pulvinar ex at tempus sodales. Mauris efficitur magna quis lectus lobortis venenatis. Nunc id enim eget augue molestie lobortis in a purus. Donec maximus quam at lectus bibendum, non suscipit nunc tristique. The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</h4><button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin: -1.25rem; padding: 1.25rem;"><span aria-hidden="true"><span class="fal fa-times"></span></span></button>	2022-06-06 20:02:03	2022-06-06 20:02:03	\N
9	::1	medium	xss	11	http://localhost:8888/laravel/ERP/public/UpdatePolices/2	http://localhost:8888/laravel/ERP/public/Polices	_token=doVeFV3XD2rH8l1cPooyMAao9nq89yqum3PtXs41&valid_from=eyJpdiI6Ik9LaHdHOXluQzBFMlNSWG5qcThncUE9PSIsInZhbHVlIjoicGxudDdPNi9sbThzNTEwYi9URGZCZz09IiwibWFjIjoiMTRhOWMzNmM4MjFjOGZjOTQ4MjU0MzZmNjc4MzliNGFkMzcyZmVhNzk4OTQ0MTgyNzcyZjYxMzhiODhlMGI2MCIsInRhZyI6IiJ9&Arabic_Desc=<h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Returns Policy</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce eros justo, accumsan non dui sit amet. Phasellus semper volutpat mi sed imperdiet. Ut odio lectus, vulputate non ex non, mattis sollicitudin purus. Mauris consequat justo a enim interdum, in consequat dolor accumsan. Nulla iaculis diam purus, ut vehicula leo efficitur at.</p><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Interdum et malesuada fames ac ante ipsum primis in faucibus. In blandit nunc enim, sit amet pharetra erat aliquet ac.</p><h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Shipping</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Pellentesque ultrices ut sem sit amet lacinia. Sed nisi dui, ultrices ut turpis pulvinar. Sed fringilla ex eget lorem consectetur, consectetur blandit lacus varius. Duis vel scelerisque elit, et vestibulum metus. Integer sit amet tincidunt tortor. Ut lacinia ullamcorper massa, a fermentum arcu vehicula ut. Ut efficitur faucibus dui Nullam tristique dolor eget turpis consequat varius. Quisque a interdum augue. Nam ut nibh mauris.</p>&English_Desc=<h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Returns Policy</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce eros justo, accumsan non dui sit amet. Phasellus semper volutpat mi sed imperdiet. Ut odio lectus, vulputate non ex non, mattis sollicitudin purus. Mauris consequat justo a enim interdum, in consequat dolor accumsan. Nulla iaculis diam purus, ut vehicula leo efficitur at.</p><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Interdum et malesuada fames ac ante ipsum primis in faucibus. In blandit nunc enim, sit amet pharetra erat aliquet ac.</p><h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Shipping</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Pellentesque ultrices ut sem sit amet lacinia. Sed nisi dui, ultrices ut turpis pulvinar. Sed fringilla ex eget lorem consectetur, consectetur blandit lacus varius. Duis vel scelerisque elit, et vestibulum metus. Integer sit amet tincidunt tortor. Ut lacinia ullamcorper massa, a fermentum arcu vehicula ut. Ut efficitur faucibus dui Nullam tristique dolor eget turpis consequat varius. Quisque a interdum augue. Nam ut nibh mauris.</p>	2022-06-06 22:22:15	2022-06-06 22:22:15	\N
10	::1	medium	xss	11	http://localhost:8888/laravel/ERP/public/UpdatePolices/2	http://localhost:8888/laravel/ERP/public/Polices	_token=doVeFV3XD2rH8l1cPooyMAao9nq89yqum3PtXs41&valid_from=eyJpdiI6IkIvaUJZMFBOUStFbXNJZHY5Mmd4dmc9PSIsInZhbHVlIjoickNFdURkM0ZneVlyV3MyZEtSUDc1dz09IiwibWFjIjoiMmFiNjc4OTIyZjM3NjY2M2U3M2U5ZjI3M2RhNWQ3NTQ3ZDZiOTE2ZDU4YzlkNWVmMDM2ZGJhODM1YWExMTQ5MyIsInRhZyI6IiJ9&Arabic_Desc=<h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Returns Policy</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce eros justo, accumsan non dui sit amet. Phasellus semper volutpat mi sed imperdiet. Ut odio lectus, vulputate non ex non, mattis sollicitudin purus. Mauris consequat justo a enim interdum, in consequat dolor accumsan. Nulla iaculis diam purus, ut vehicula leo efficitur at.</p><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Interdum et malesuada fames ac ante ipsum primis in faucibus. In blandit nunc enim, sit amet pharetra erat aliquet ac.</p><h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Shipping</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Pellentesque ultrices ut sem sit amet lacinia. Sed nisi dui, ultrices ut turpis pulvinar. Sed fringilla ex eget lorem consectetur, consectetur blandit lacus varius. Duis vel scelerisque elit, et vestibulum metus. Integer sit amet tincidunt tortor. Ut lacinia ullamcorper massa, a fermentum arcu vehicula ut. Ut efficitur faucibus dui Nullam tristique dolor eget turpis consequat varius. Quisque a interdum augue. Nam ut nibh mauris.</p>&English_Desc=<h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Returns Policy</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce eros justo, accumsan non dui sit amet. Phasellus semper volutpat mi sed imperdiet. Ut odio lectus, vulputate non ex non, mattis sollicitudin purus. Mauris consequat justo a enim interdum, in consequat dolor accumsan. Nulla iaculis diam purus, ut vehicula leo efficitur at.</p><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Interdum et malesuada fames ac ante ipsum primis in faucibus. In blandit nunc enim, sit amet pharetra erat aliquet ac.</p><h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Shipping</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Pellentesque ultrices ut sem sit amet lacinia. Sed nisi dui, ultrices ut turpis pulvinar. Sed fringilla ex eget lorem consectetur, consectetur blandit lacus varius. Duis vel scelerisque elit, et vestibulum metus. Integer sit amet tincidunt tortor. Ut lacinia ullamcorper massa, a fermentum arcu vehicula ut. Ut efficitur faucibus dui Nullam tristique dolor eget turpis consequat varius. Quisque a interdum augue. Nam ut nibh mauris.</p>	2022-06-06 22:22:27	2022-06-06 22:22:27	\N
11	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/PostLoginSite	http://localhost:8888/laravel/ERP/public/LoginSite	_token=xBCZkelPEYieOfzSztHnCsRpprRAIrzVwqOEO7D9&Email=islamyousief353@gmail.com&Password=123456&password=******	2022-06-07 12:05:21	2022-06-07 12:05:21	\N
12	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/PostLoginSite	http://localhost:8888/laravel/ERP/public/LoginSite	_token=xBCZkelPEYieOfzSztHnCsRpprRAIrzVwqOEO7D9&Email=islamyousief353@gmail.com&Password=123456&password=******	2022-06-07 12:18:58	2022-06-07 12:18:58	\N
13	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/PostLoginSite	http://localhost:8888/laravel/ERP/public/LoginSite	_token=xBCZkelPEYieOfzSztHnCsRpprRAIrzVwqOEO7D9&Email=islamyousief353@gmail.com&Password=123456&password=******	2022-06-07 12:27:07	2022-06-07 12:27:07	\N
14	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/PostLoginSite	http://localhost:8888/laravel/ERP/public/LoginSite	_token=xBCZkelPEYieOfzSztHnCsRpprRAIrzVwqOEO7D9&Email=islamyousief353@gmail.com&Password=123456&password=******	2022-06-07 12:43:03	2022-06-07 12:43:03	\N
15	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/PostLoginSite	http://localhost:8888/laravel/ERP/public/LoginSite	_token=xBCZkelPEYieOfzSztHnCsRpprRAIrzVwqOEO7D9&Email=islamyousief353@gmail.com&Password=123456&password=******	2022-06-07 12:43:39	2022-06-07 12:43:39	\N
16	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/PostLoginSite	http://localhost:8888/laravel/ERP/public/LoginSite	_token=xBCZkelPEYieOfzSztHnCsRpprRAIrzVwqOEO7D9&Email=islamyousief353@gmail.com&Password=123456&password=******	2022-06-07 12:49:43	2022-06-07 12:49:43	\N
17	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/Login	http://localhost:8888/laravel/ERP/public/AdminLogin	_token=ddC4WRKEWrRNwcu08j4Dm5icj0Hzo7eNz6RcmiAj&valid_from=eyJpdiI6IndSYXlaeVQ4b2wxQ2lZQ202a1dNUlE9PSIsInZhbHVlIjoiK0JkenBWTzJ1NUdVTHE3RndWYmtSUT09IiwibWFjIjoiZTJkNTc3OTU4ZWI1NTVlOTIzOGRlZjZjNDY0ZTY2ZjFjYzNmMDkzYWM2YjBmOWZhZTUwYzFhM2Y2N2I2MDZhYiIsInRhZyI6IiJ9&email=Alaa@test.com&password=******	2025-04-25 13:47:40	2025-04-25 13:47:40	\N
18	197.43.32.239	medium	login	0	https://demo.rabiherp.com/public/api/LoginApi	NULL	email=ba@ba&password=******	2025-10-02 17:09:31	2025-10-02 17:09:31	\N
19	197.43.32.239	medium	login	0	https://demo.rabiherp.com/public/api/LoginApi	NULL	email=ba@ba&password=******	2025-10-02 17:09:41	2025-10-02 17:09:41	\N
20	197.43.32.239	medium	login	0	https://demo.rabiherp.com/public/api/LoginApi	NULL	email=o@o&password=******	2025-10-02 17:09:54	2025-10-02 17:09:54	\N
21	197.43.95.197	medium	login	0	https://demo.rabiherp.com/public/api/LoginApi	NULL	email=t@1&password=******	2025-10-09 11:43:53	2025-10-09 11:43:53	\N
22	156.205.105.181	medium	login	0	https://demo.rabiherp.com/public/api/LoginApi	NULL	email=admin@rabih&password=******	2025-10-09 12:10:43	2025-10-09 12:10:43	\N
23	196.129.51.90	medium	login	0	https://demo.rabiherp.com/public/Login	https://demo.rabiherp.com/public/AdminLogin	_token=VDrG0lsxITXQ2X12wy1s5zjZsId5NTbfPNB3BoqY&valid_from=eyJpdiI6InlONnQyQi9tWE5QNFdqUWFKc2Y0TWc9PSIsInZhbHVlIjoiRGx3aXpvd0txQVJmQUZpdElkemlrZz09IiwibWFjIjoiNDg1NmEyODgxNTU4N2RhMGRhMmE4MDAwNDQyMjEwMjM2YzUwYzc2YTFhMDE5YmRkNjQ2MDZjMWZhNDY1NzBhMiIsInRhZyI6IiJ9&email=heba@rabih.com&password=******	2025-10-11 20:27:49	2025-10-11 20:27:49	\N
24	188.71.220.120	medium	login	0	https://demo.rabiherp.com/public/api/LoginApi	NULL	email=t@2&password=******	2025-10-13 16:02:51	2025-10-13 16:02:51	\N
25	41.36.98.82	medium	login	0	https://demo.rabiherp.com/public/Login	https://demo.rabiherp.com/public/AdminLogin	_token=z6btJ8oNQsnrc0ELfBLo8wPrMfJHvKwAfwyYIriU&valid_from=eyJpdiI6IkZBMXBtOC9uMXlDOEV0UUNnckl6NHc9PSIsInZhbHVlIjoiR2lPaEhZZzllTVFNakFPK2JrTG53dz09IiwibWFjIjoiMjM4MTcyMWViOTdmN2YyMzc0MjcyYzhkZjc3YzE2OGI3NjQ5MjY5YjhlYmQ2ODEyNDJiYTg2ZGUyNDNhYTc2NCIsInRhZyI6IiJ9&email=heba@rabih.com&password=******&rememberme=on	2025-10-14 15:43:21	2025-10-14 15:43:21	\N
26	41.36.98.82	medium	login	0	https://demo.rabiherp.com/public/Login	https://demo.rabiherp.com/public/AdminLogin	_token=z6btJ8oNQsnrc0ELfBLo8wPrMfJHvKwAfwyYIriU&valid_from=eyJpdiI6ImFtQkdlbGRIeVZIdkhOMXNDU3N2eUE9PSIsInZhbHVlIjoiNHBwMlVLb2UzNEdBSXlMNVdxTFRPdz09IiwibWFjIjoiZGZlZDYzZDFjZGFkNTJiYzRjMDZmNjAwOWRmZjc0MWZlMzI1MmVhNDAzNGE2MTUzMjE3Y2UwZGEzYmIyZDVjYiIsInRhZyI6IiJ9&email=heba@rabih.com&password=******	2025-10-14 15:43:49	2025-10-14 15:43:49	\N
27	41.36.98.82	medium	login	0	https://demo.rabiherp.com/public/Login	https://demo.rabiherp.com/public/AdminLogin	_token=z6btJ8oNQsnrc0ELfBLo8wPrMfJHvKwAfwyYIriU&valid_from=eyJpdiI6ImROdzlnd25rQlFYaTFnbzU2ZDF5Qmc9PSIsInZhbHVlIjoib09kR0lDZjR4dTVRdDZNOUFyMVFKdz09IiwibWFjIjoiZDA4MGMxYmRmYjU3ZTY3MGMyYmJhZjk4MDgzNzUzMDgwZjE1Y2MzM2RhOWIxZmJhYjBlZTQ2MGQ5MGI4ZWY5ZiIsInRhZyI6IiJ9&email=heba@rabih.com&password=******	2025-10-14 15:44:38	2025-10-14 15:44:38	\N
28	41.36.98.82	medium	login	0	https://demo.rabiherp.com/public/Login	https://demo.rabiherp.com/public/AdminLogin	_token=z6btJ8oNQsnrc0ELfBLo8wPrMfJHvKwAfwyYIriU&valid_from=eyJpdiI6IjhrS29rWE5FMGhxeDE0dXEwWk9UdXc9PSIsInZhbHVlIjoiZnJtcUx4RTFtYllyWENiYXdnV0VCQT09IiwibWFjIjoiMmY2NWU3MGM2YTljYWJjYjhjMTA4ZjNkZDFhODAyZDAzMmM2ZmZkNGFkNTEzMTg4YjM2NWU5YzU2MWFmMTQwYSIsInRhZyI6IiJ9&email=heba@rabih.com&password=******	2025-10-14 15:44:49	2025-10-14 15:44:49	\N
29	156.206.130.49	medium	login	0	https://demo.rabiherp.com/public/api/LoginApi	NULL	email=m@m.com&password=******	2025-10-17 17:01:11	2025-10-17 17:01:11	\N
30	156.206.130.49	medium	login	0	https://demo.rabiherp.com/public/api/LoginApi	NULL	email=mina@gmail.com&password=******	2025-10-17 17:02:03	2025-10-17 17:02:03	\N
31	185.200.100.178	medium	login	0	https://demo.rabiherp.com/public/api/LoginApi	NULL	email=3@&password=******	2025-10-17 17:12:41	2025-10-17 17:12:41	\N
32	156.202.24.47	medium	login	0	https://demo.rabiherp.com/public/api/LoginApi	NULL	email=a@b&password=******	2025-10-18 14:42:22	2025-10-18 14:42:22	\N
33	2c0f:fc88:45:9044:1:0:ac14:5699	medium	login	0	https://demo.rabiherp.com/public/Login	https://demo.rabiherp.com/public/AdminLogin	_token=c4VxEZRZwUtfVCrvhKxD1hPusyCxzZ7rxc5HGv78&valid_from=eyJpdiI6Im8vRE9PV3JiTlJ6RUh3aEIzb3ptOGc9PSIsInZhbHVlIjoiVFgrUHQ4UWtDR3pySWgyZ3ZVLy9SUT09IiwibWFjIjoiMTU0NzA4MTFiMTg5M2QzODc1MWM3ZmZmMWNlNWRkNTA1NGYzMWQ2ZGE2ODc0YjY1MmVjMTBkMjg5ZGZkYmJhZSIsInRhZyI6IiJ9&email=heraatrade@gmail.com&password=******&rememberme=on	2025-10-18 16:43:29	2025-10-18 16:43:29	\N
34	2c0f:fc88:45:9044:1:0:ac14:5699	medium	login	0	https://demo.rabiherp.com/public/Login	https://demo.rabiherp.com/public/AdminLogin	_token=c4VxEZRZwUtfVCrvhKxD1hPusyCxzZ7rxc5HGv78&valid_from=eyJpdiI6Ii9IUUFFanZNTlNoMm1USUtxcTJnQnc9PSIsInZhbHVlIjoiWnZKeHVIV1ROa2NaRXNUeERjL1hmdz09IiwibWFjIjoiYmI3OTM3MWUzODk4NTZiODBkYzkwN2E0NWNkNDg5ZGYyMGZkY2JhNTFjMzgyZmEzOTEyNzRmNDcyMTdhYjJiZCIsInRhZyI6IiJ9&email=heraatrade@gmail.com&password=******&rememberme=on	2025-10-18 16:43:56	2025-10-18 16:43:56	\N
35	41.39.128.18	medium	login	0	https://demo.rabiherp.com/public/api/LoginApi	NULL	email=t@3&password=******	2025-10-22 12:33:58	2025-10-22 12:33:58	\N
38	151.254.80.48	medium	login	0	https://demo.rabiherp.com/public/api/LoginApi	NULL	email=t@2&password=******	2025-10-25 07:52:17	2025-10-25 07:52:17	\N
39	151.254.80.48	medium	login	0	https://demo.rabiherp.com/public/api/LoginApi	NULL	email=t@3&password=******	2025-10-25 07:52:23	2025-10-25 07:52:23	\N
40	2001:16a2:c99b:f800:5945:a8e6:52c:3005	medium	login	0	https://demo.rabiherp.com/public/Login	https://demo.rabiherp.com/public/AdminLogin	_token=uVTA4PK9iQcTmKJHrpO32sK0RFysOqIr6xLVWLG7&valid_from=eyJpdiI6IkczQWMxd3IramhyVGxNaUswWTN2eGc9PSIsInZhbHVlIjoiMzl3cDJCbHFzNXBxRXhxblpETFpxQT09IiwibWFjIjoiMjA5ZjVkOGYzZTY4MTZiZjdmMmIwZjhhZDUzYzUxNDc4OTI5YzhkODIxZmNhMmYwMmIzMjhiNDA3NzA4N2EwMCIsInRhZyI6IiJ9&email=admin@rabiherp.com&password=******	2025-10-26 14:48:43	2025-10-26 14:48:43	\N
\.


--
-- Data for Name: follow_lists; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.follow_lists (id, "Emp", "Day", "Time", "Client", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: general_dailies; Type: TABLE DATA; Schema: public; Owner: demorabiherp_karim
--

COPY public.general_dailies (id, "Code", "Date", "Type", "Debitor", "Creditor", "Statement", "Draw", "Debitor_Coin", "Creditor_Coin", "Account", "Coin", "Cost_Center", created_at, updated_at, userr, "Code_Type", "Branch", "TypeEn", arr) FROM stdin;
1	1	2025-10-02	سند قبض	0	100000	\N	1	0	100000	45	1	\N	2025-10-02 14:31:40	2025-10-02 14:31:40	1	1	\N	Receipt Voucher	\N
2	1	2025-10-02	سند قبض	100000	0	\N	1	100000	0	30	1	\N	2025-10-02 14:31:40	2025-10-02 14:31:40	1	1	3	Receipt Voucher	\N
3	2	2025-10-02	المشتريات	2000.00	0	\N	1	2000	0	2500	1	\N	2025-10-02 14:32:07	2025-10-02 14:32:07	1	1	\N	Purchases	\N
4	2	2025-10-02	المشتريات	0	2000.00	\N	1	0	2000	2523	1	\N	2025-10-02 14:32:07	2025-10-02 14:32:07	1	1	\N	Purchases	\N
5	2	2025-10-02	المشتريات	2000.00	0	\N	1	2000	0	2523	1	\N	2025-10-02 14:32:07	2025-10-02 14:32:07	1	1	\N	Purchases	\N
6	2	2025-10-02	المشتريات	0	2000.00	\N	1	0	2000	30	1	\N	2025-10-02 14:32:07	2025-10-02 14:32:07	1	1	\N	Purchases	\N
7	3	2025-10-02	المشتريات	2000.00	0	\N	1	2000	0	2500	1	\N	2025-10-02 14:36:49	2025-10-02 14:36:49	1	2	\N	Purchases	\N
8	3	2025-10-02	المشتريات	0	2000.00	\N	1	0	2000	2523	1	\N	2025-10-02 14:36:49	2025-10-02 14:36:49	1	2	\N	Purchases	\N
9	3	2025-10-02	المشتريات	2000.00	0	\N	1	2000	0	2523	1	\N	2025-10-02 14:36:49	2025-10-02 14:36:49	1	2	\N	Purchases	\N
10	3	2025-10-02	المشتريات	0	2000.00	\N	1	0	2000	30	1	\N	2025-10-02 14:36:49	2025-10-02 14:36:49	1	2	\N	Purchases	\N
11	4	2025-10-02	المشتريات	60	0	\N	1	60	0	2500	1	\N	2025-10-02 14:38:55	2025-10-02 14:38:55	1	3	\N	Purchases	\N
12	4	2025-10-02	المشتريات	0	60	\N	1	0	60	2523	1	\N	2025-10-02 14:38:55	2025-10-02 14:38:55	1	3	\N	Purchases	\N
13	4	2025-10-02	المشتريات	60	0	\N	1	60	0	2523	1	\N	2025-10-02 14:38:55	2025-10-02 14:38:55	1	3	\N	Purchases	\N
14	4	2025-10-02	المشتريات	0	60	\N	1	0	60	30	1	\N	2025-10-02 14:38:55	2025-10-02 14:38:55	1	3	\N	Purchases	\N
15	5	2025-10-02	المشتريات	2000.00	0	\N	1	2000	0	2500	1	\N	2025-10-02 14:39:31	2025-10-02 14:39:31	1	4	\N	Purchases	\N
16	5	2025-10-02	المشتريات	0	2000.00	\N	1	0	2000	2523	1	\N	2025-10-02 14:39:31	2025-10-02 14:39:31	1	4	\N	Purchases	\N
17	5	2025-10-02	المشتريات	2000.00	0	\N	1	2000	0	2523	1	\N	2025-10-02 14:39:31	2025-10-02 14:39:31	1	4	\N	Purchases	\N
18	5	2025-10-02	المشتريات	0	2000.00	\N	1	0	2000	30	1	\N	2025-10-02 14:39:31	2025-10-02 14:39:31	1	4	\N	Purchases	\N
19	6	2025-10-02	المشتريات	2000.00	0	\N	1	2000	0	2500	1	\N	2025-10-02 14:40:13	2025-10-02 14:40:13	1	5	\N	Purchases	\N
20	6	2025-10-02	المشتريات	0	2000.00	\N	1	0	2000	2523	1	\N	2025-10-02 14:40:13	2025-10-02 14:40:13	1	5	\N	Purchases	\N
21	6	2025-10-02	المشتريات	2000.00	0	\N	1	2000	0	2523	1	\N	2025-10-02 14:40:13	2025-10-02 14:40:13	1	5	\N	Purchases	\N
22	6	2025-10-02	المشتريات	0	2000.00	\N	1	0	2000	30	1	\N	2025-10-02 14:40:13	2025-10-02 14:40:13	1	5	\N	Purchases	\N
23	7	2025-10-02	المشتريات	100	0	\N	1	100	0	2500	1	\N	2025-10-02 14:42:20	2025-10-02 14:42:20	1	6	\N	Purchases	\N
24	7	2025-10-02	المشتريات	0	100	\N	1	0	100	2523	1	\N	2025-10-02 14:42:20	2025-10-02 14:42:20	1	6	\N	Purchases	\N
25	7	2025-10-02	المشتريات	100	0	\N	1	100	0	2523	1	\N	2025-10-02 14:42:20	2025-10-02 14:42:20	1	6	\N	Purchases	\N
26	7	2025-10-02	المشتريات	0	100	\N	1	0	100	30	1	\N	2025-10-02 14:42:20	2025-10-02 14:42:20	1	6	\N	Purchases	\N
27	8	2025-10-02	المبيعات	200	0	\N	1	200	0	52	1	\N	2025-10-02 14:43:55	2025-10-02 14:43:55	1	1	\N	Sales	\N
28	8	2025-10-02	المبيعات	0	200	\N	1	0	200	71	1	\N	2025-10-02 14:43:55	2025-10-02 14:43:55	1	1	\N	Sales	\N
29	8	2025-10-02	المبيعات	1000.00	0	\N	1	1000	0	30	1	\N	2025-10-02 14:43:55	2025-10-02 14:43:55	1	1	\N	Sales	\N
30	8	2025-10-02	المبيعات	0	1000.00	\N	1	0	1000	2535	1	\N	2025-10-02 14:43:55	2025-10-02 14:43:55	1	1	\N	Sales	\N
31	8	2025-10-02	المبيعات	1000.00	0	\N	1	1000	0	2535	1	\N	2025-10-02 14:43:55	2025-10-02 14:43:55	1	1	\N	Sales	\N
32	8	2025-10-02	المبيعات	0	1000.00	\N	1	0	1000	48	1	\N	2025-10-02 14:43:55	2025-10-02 14:43:55	1	1	\N	Sales	\N
33	9	2025-10-02	المبيعات	0	20.00	\N	1	0	20	2500	1	\N	2025-10-02 14:45:45	2025-10-02 14:45:45	1	1	\N	Sales	\N
34	9	2025-10-02	المبيعات	20.00	0	\N	1	20	0	71	1	\N	2025-10-02 14:45:45	2025-10-02 14:45:45	1	1	\N	Sales	\N
35	10	2025-10-02	المبيعات	200	0	\N	1	200	0	52	1	\N	2025-10-02 14:47:47	2025-10-02 14:47:47	1	2	\N	Sales	\N
36	10	2025-10-02	المبيعات	0	200	\N	1	0	200	2500	1	\N	2025-10-02 14:47:47	2025-10-02 14:47:47	1	2	\N	Sales	\N
37	10	2025-10-02	المبيعات	1000.00	0	\N	1	1000	0	30	1	\N	2025-10-02 14:47:47	2025-10-02 14:47:47	1	2	\N	Sales	\N
38	10	2025-10-02	المبيعات	0	1000.00	\N	1	0	1000	2535	1	\N	2025-10-02 14:47:47	2025-10-02 14:47:47	1	2	\N	Sales	\N
39	10	2025-10-02	المبيعات	1000.00	0	\N	1	1000	0	2535	1	\N	2025-10-02 14:47:47	2025-10-02 14:47:47	1	2	\N	Sales	\N
40	10	2025-10-02	المبيعات	0	1000.00	\N	1	0	1000	48	1	\N	2025-10-02 14:47:47	2025-10-02 14:47:47	1	2	\N	Sales	\N
41	11	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-02 14:47:47	2025-10-02 14:47:47	1	2	\N	Commission Entitlement	\N
42	11	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-02 14:47:47	2025-10-02 14:47:47	1	2	\N	Commission Entitlement	\N
43	12	2025-10-02	المبيعات	200	0	\N	1	200	0	52	1	\N	2025-10-02 14:49:48	2025-10-02 14:49:48	1	3	\N	Sales	\N
44	12	2025-10-02	المبيعات	0	200	\N	1	0	200	2500	1	\N	2025-10-02 14:49:48	2025-10-02 14:49:48	1	3	\N	Sales	\N
45	12	2025-10-02	المبيعات	1000.00	0	\N	1	1000	0	30	1	\N	2025-10-02 14:49:48	2025-10-02 14:49:48	1	3	\N	Sales	\N
46	12	2025-10-02	المبيعات	0	1000.00	\N	1	0	1000	2535	1	\N	2025-10-02 14:49:48	2025-10-02 14:49:48	1	3	\N	Sales	\N
47	12	2025-10-02	المبيعات	1000.00	0	\N	1	1000	0	2535	1	\N	2025-10-02 14:49:48	2025-10-02 14:49:48	1	3	\N	Sales	\N
48	12	2025-10-02	المبيعات	0	1000.00	\N	1	0	1000	48	1	\N	2025-10-02 14:49:48	2025-10-02 14:49:48	1	3	\N	Sales	\N
49	13	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-02 14:49:48	2025-10-02 14:49:48	1	3	\N	Commission Entitlement	\N
50	13	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-02 14:49:48	2025-10-02 14:49:48	1	3	\N	Commission Entitlement	\N
51	15	2025-10-02	المبيعات	20	0	\N	1	20	0	52	1	\N	2025-10-02 16:46:48	2025-10-02 16:46:48	62	5	\N	Sales	\N
52	15	2025-10-02	المبيعات	0	20	\N	1	0	20	2500	1	\N	2025-10-02 16:46:48	2025-10-02 16:46:48	62	5	\N	Sales	\N
53	15	2025-10-02	المبيعات	100.00	0	\N	1	100	0	30	1	\N	2025-10-02 16:46:48	2025-10-02 16:46:48	62	5	\N	Sales	\N
54	15	2025-10-02	المبيعات	0	100.00	\N	1	0	100	2522	1	\N	2025-10-02 16:46:48	2025-10-02 16:46:48	62	5	\N	Sales	\N
55	15	2025-10-02	المبيعات	100.00	0	\N	1	100	0	2522	1	\N	2025-10-02 16:46:48	2025-10-02 16:46:48	62	5	\N	Sales	\N
56	15	2025-10-02	المبيعات	0	100.00	\N	1	0	100	48	1	\N	2025-10-02 16:46:48	2025-10-02 16:46:48	62	5	\N	Sales	\N
57	16	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-02 16:46:48	2025-10-02 16:46:48	62	5	\N	Commission Entitlement	\N
58	16	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-02 16:46:48	2025-10-02 16:46:48	62	5	\N	Commission Entitlement	\N
59	17	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-02 16:46:48	2025-10-02 16:46:48	62	5	\N	Commission Entitlement	\N
60	17	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-02 16:46:48	2025-10-02 16:46:48	62	5	\N	Commission Entitlement	\N
61	18	2025-10-02	المبيعات	20	0	\N	1	20	0	52	1	\N	2025-10-02 16:47:31	2025-10-02 16:47:31	62	6	\N	Sales	\N
62	18	2025-10-02	المبيعات	0	20	\N	1	0	20	2500	1	\N	2025-10-02 16:47:31	2025-10-02 16:47:31	62	6	\N	Sales	\N
63	18	2025-10-02	المبيعات	0	100.00	\N	1	0	100	48	1	\N	2025-10-02 16:47:31	2025-10-02 16:47:31	62	6	\N	Sales	\N
64	18	2025-10-02	المبيعات	0	1	\N	1	0	1	826	1	\N	2025-10-02 16:47:31	2025-10-02 16:47:31	62	6	\N	Sales	\N
65	18	2025-10-02	المبيعات	101	0	\N	1	101	0	2522	1	\N	2025-10-02 16:47:31	2025-10-02 16:47:31	62	6	\N	Sales	\N
66	18	2025-10-02	المبيعات	101	0	\N	1	101	0	2542	1	\N	2025-10-02 16:47:31	2025-10-02 16:47:31	62	6	\N	Sales	\N
67	18	2025-10-02	المبيعات	0	101	\N	1	0	101	2522	1	\N	2025-10-02 16:47:31	2025-10-02 16:47:31	62	6	\N	Sales	\N
68	19	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-02 16:47:31	2025-10-02 16:47:31	62	6	\N	Commission Entitlement	\N
69	19	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-02 16:47:31	2025-10-02 16:47:31	62	6	\N	Commission Entitlement	\N
70	20	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-02 16:47:31	2025-10-02 16:47:31	62	6	\N	Commission Entitlement	\N
71	20	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-02 16:47:31	2025-10-02 16:47:31	62	6	\N	Commission Entitlement	\N
72	21	2025-10-02	المبيعات	20	0	\N	1	20	0	52	1	\N	2025-10-02 16:50:31	2025-10-02 16:50:31	62	7	\N	Sales	\N
73	21	2025-10-02	المبيعات	0	20	\N	1	0	20	2500	1	\N	2025-10-02 16:50:31	2025-10-02 16:50:31	62	7	\N	Sales	\N
74	21	2025-10-02	المبيعات	0	100.00	\N	1	0	100	48	1	\N	2025-10-02 16:50:31	2025-10-02 16:50:31	62	7	\N	Sales	\N
75	21	2025-10-02	المبيعات	0	1	\N	1	0	1	826	1	\N	2025-10-02 16:50:31	2025-10-02 16:50:31	62	7	\N	Sales	\N
76	21	2025-10-02	المبيعات	101	0	\N	1	101	0	2522	1	\N	2025-10-02 16:50:31	2025-10-02 16:50:31	62	7	\N	Sales	\N
77	21	2025-10-02	المبيعات	101	0	\N	1	101	0	2516	1	\N	2025-10-02 16:50:31	2025-10-02 16:50:31	62	7	\N	Sales	\N
78	21	2025-10-02	المبيعات	0	101	\N	1	0	101	2522	1	\N	2025-10-02 16:50:31	2025-10-02 16:50:31	62	7	\N	Sales	\N
79	22	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-02 16:50:31	2025-10-02 16:50:31	62	7	\N	Commission Entitlement	\N
80	22	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-02 16:50:31	2025-10-02 16:50:31	62	7	\N	Commission Entitlement	\N
81	23	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-02 16:50:31	2025-10-02 16:50:31	62	7	\N	Commission Entitlement	\N
82	23	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-02 16:50:31	2025-10-02 16:50:31	62	7	\N	Commission Entitlement	\N
83	24	2025-10-02	المبيعات	100	0	\N	1	100	0	52	1	\N	2025-10-02 16:51:02	2025-10-02 16:51:02	62	8	\N	Sales	\N
84	24	2025-10-02	المبيعات	0	100	\N	1	0	100	2500	1	\N	2025-10-02 16:51:02	2025-10-02 16:51:02	62	8	\N	Sales	\N
85	24	2025-10-02	المبيعات	0	500.00	\N	1	0	500	48	1	\N	2025-10-02 16:51:02	2025-10-02 16:51:02	62	8	\N	Sales	\N
86	24	2025-10-02	المبيعات	0	1	\N	1	0	1	826	1	\N	2025-10-02 16:51:02	2025-10-02 16:51:02	62	8	\N	Sales	\N
87	24	2025-10-02	المبيعات	501	0	\N	1	501	0	2522	1	\N	2025-10-02 16:51:02	2025-10-02 16:51:02	62	8	\N	Sales	\N
88	24	2025-10-02	المبيعات	501	0	\N	1	501	0	2542	1	\N	2025-10-02 16:51:02	2025-10-02 16:51:02	62	8	\N	Sales	\N
89	24	2025-10-02	المبيعات	0	501	\N	1	0	501	2522	1	\N	2025-10-02 16:51:02	2025-10-02 16:51:02	62	8	\N	Sales	\N
90	25	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-02 16:51:02	2025-10-02 16:51:02	62	8	\N	Commission Entitlement	\N
91	25	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-02 16:51:02	2025-10-02 16:51:02	62	8	\N	Commission Entitlement	\N
92	26	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-02 16:51:02	2025-10-02 16:51:02	62	8	\N	Commission Entitlement	\N
93	26	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-02 16:51:02	2025-10-02 16:51:02	62	8	\N	Commission Entitlement	\N
94	27	2025-10-02	المبيعات	40	0	\N	1	40	0	52	1	\N	2025-10-02 16:51:22	2025-10-02 16:51:22	62	9	\N	Sales	\N
95	27	2025-10-02	المبيعات	0	40	\N	1	0	40	2500	1	\N	2025-10-02 16:51:22	2025-10-02 16:51:22	62	9	\N	Sales	\N
96	27	2025-10-02	المبيعات	0	300.00	\N	1	0	300	48	1	\N	2025-10-02 16:51:22	2025-10-02 16:51:22	62	9	\N	Sales	\N
97	27	2025-10-02	المبيعات	0	1	\N	1	0	1	826	1	\N	2025-10-02 16:51:22	2025-10-02 16:51:22	62	9	\N	Sales	\N
98	27	2025-10-02	المبيعات	301	0	\N	1	301	0	2522	1	\N	2025-10-02 16:51:22	2025-10-02 16:51:22	62	9	\N	Sales	\N
99	27	2025-10-02	المبيعات	301	0	\N	1	301	0	2542	1	\N	2025-10-02 16:51:22	2025-10-02 16:51:22	62	9	\N	Sales	\N
100	27	2025-10-02	المبيعات	0	301	\N	1	0	301	2522	1	\N	2025-10-02 16:51:22	2025-10-02 16:51:22	62	9	\N	Sales	\N
101	28	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-02 16:51:22	2025-10-02 16:51:22	62	9	\N	Commission Entitlement	\N
102	28	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-02 16:51:22	2025-10-02 16:51:22	62	9	\N	Commission Entitlement	\N
103	29	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-02 16:51:22	2025-10-02 16:51:22	62	9	\N	Commission Entitlement	\N
104	29	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-02 16:51:22	2025-10-02 16:51:22	62	9	\N	Commission Entitlement	\N
105	30	2025-10-02	المبيعات	100	0	\N	1	100	0	52	1	\N	2025-10-02 16:51:46	2025-10-02 16:51:46	62	10	\N	Sales	\N
106	30	2025-10-02	المبيعات	0	100	\N	1	0	100	2500	1	\N	2025-10-02 16:51:46	2025-10-02 16:51:46	62	10	\N	Sales	\N
107	30	2025-10-02	المبيعات	0	400.00	\N	1	0	400	48	1	\N	2025-10-02 16:51:46	2025-10-02 16:51:46	62	10	\N	Sales	\N
108	30	2025-10-02	المبيعات	0	1	\N	1	0	1	826	1	\N	2025-10-02 16:51:46	2025-10-02 16:51:46	62	10	\N	Sales	\N
109	30	2025-10-02	المبيعات	401	0	\N	1	401	0	2522	1	\N	2025-10-02 16:51:46	2025-10-02 16:51:46	62	10	\N	Sales	\N
110	30	2025-10-02	المبيعات	401	0	\N	1	401	0	2542	1	\N	2025-10-02 16:51:46	2025-10-02 16:51:46	62	10	\N	Sales	\N
111	30	2025-10-02	المبيعات	0	401	\N	1	0	401	2522	1	\N	2025-10-02 16:51:46	2025-10-02 16:51:46	62	10	\N	Sales	\N
112	31	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-02 16:51:46	2025-10-02 16:51:46	62	10	\N	Commission Entitlement	\N
113	31	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-02 16:51:46	2025-10-02 16:51:46	62	10	\N	Commission Entitlement	\N
114	32	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-02 16:51:46	2025-10-02 16:51:46	62	10	\N	Commission Entitlement	\N
115	32	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-02 16:51:46	2025-10-02 16:51:46	62	10	\N	Commission Entitlement	\N
116	33	2025-10-02	المبيعات	100	0	\N	1	100	0	52	1	\N	2025-10-02 16:52:08	2025-10-02 16:52:08	62	11	\N	Sales	\N
117	33	2025-10-02	المبيعات	0	100	\N	1	0	100	2500	1	\N	2025-10-02 16:52:08	2025-10-02 16:52:08	62	11	\N	Sales	\N
118	33	2025-10-02	المبيعات	0	400.00	\N	1	0	400	48	1	\N	2025-10-02 16:52:08	2025-10-02 16:52:08	62	11	\N	Sales	\N
119	33	2025-10-02	المبيعات	0	1	\N	1	0	1	826	1	\N	2025-10-02 16:52:08	2025-10-02 16:52:08	62	11	\N	Sales	\N
120	33	2025-10-02	المبيعات	401	0	\N	1	401	0	2522	1	\N	2025-10-02 16:52:08	2025-10-02 16:52:08	62	11	\N	Sales	\N
121	33	2025-10-02	المبيعات	401	0	\N	1	401	0	2542	1	\N	2025-10-02 16:52:08	2025-10-02 16:52:08	62	11	\N	Sales	\N
122	33	2025-10-02	المبيعات	0	401	\N	1	0	401	2522	1	\N	2025-10-02 16:52:08	2025-10-02 16:52:08	62	11	\N	Sales	\N
123	34	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-02 16:52:08	2025-10-02 16:52:08	62	11	\N	Commission Entitlement	\N
124	34	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-02 16:52:08	2025-10-02 16:52:08	62	11	\N	Commission Entitlement	\N
125	35	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-02 16:52:08	2025-10-02 16:52:08	62	11	\N	Commission Entitlement	\N
126	35	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-02 16:52:08	2025-10-02 16:52:08	62	11	\N	Commission Entitlement	\N
127	36	2025-10-02	المبيعات	160	0	\N	1	160	0	52	1	\N	2025-10-02 16:59:02	2025-10-02 16:59:02	62	12	\N	Sales	\N
128	36	2025-10-02	المبيعات	0	160	\N	1	0	160	2500	1	\N	2025-10-02 16:59:02	2025-10-02 16:59:02	62	12	\N	Sales	\N
129	36	2025-10-02	المبيعات	0	500.00	\N	1	0	500	48	1	\N	2025-10-02 16:59:02	2025-10-02 16:59:02	62	12	\N	Sales	\N
130	36	2025-10-02	المبيعات	0	1	\N	1	0	1	826	1	\N	2025-10-02 16:59:02	2025-10-02 16:59:02	62	12	\N	Sales	\N
131	36	2025-10-02	المبيعات	501	0	\N	1	501	0	2522	1	\N	2025-10-02 16:59:02	2025-10-02 16:59:02	62	12	\N	Sales	\N
132	36	2025-10-02	المبيعات	501	0	\N	1	501	0	2542	1	\N	2025-10-02 16:59:02	2025-10-02 16:59:02	62	12	\N	Sales	\N
133	36	2025-10-02	المبيعات	0	501	\N	1	0	501	2522	1	\N	2025-10-02 16:59:02	2025-10-02 16:59:02	62	12	\N	Sales	\N
134	37	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-02 16:59:02	2025-10-02 16:59:02	62	12	\N	Commission Entitlement	\N
135	37	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-02 16:59:02	2025-10-02 16:59:02	62	12	\N	Commission Entitlement	\N
136	38	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-02 16:59:02	2025-10-02 16:59:02	62	12	\N	Commission Entitlement	\N
137	38	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-02 16:59:02	2025-10-02 16:59:02	62	12	\N	Commission Entitlement	\N
138	39	2025-10-02	المبيعات	80	0	\N	1	80	0	52	1	\N	2025-10-02 17:15:08	2025-10-02 17:15:08	61	13	\N	Sales	\N
139	39	2025-10-02	المبيعات	0	80	\N	1	0	80	2500	1	\N	2025-10-02 17:15:08	2025-10-02 17:15:08	61	13	\N	Sales	\N
140	39	2025-10-02	المبيعات	0	400.00	\N	1	0	400	48	1	\N	2025-10-02 17:15:08	2025-10-02 17:15:08	61	13	\N	Sales	\N
141	39	2025-10-02	المبيعات	0	1	\N	1	0	1	826	1	\N	2025-10-02 17:15:08	2025-10-02 17:15:08	61	13	\N	Sales	\N
142	39	2025-10-02	المبيعات	401	0	\N	1	401	0	2522	1	\N	2025-10-02 17:15:08	2025-10-02 17:15:08	61	13	\N	Sales	\N
143	39	2025-10-02	المبيعات	401	0	\N	1	401	0	2538	1	\N	2025-10-02 17:15:08	2025-10-02 17:15:08	61	13	\N	Sales	\N
144	39	2025-10-02	المبيعات	0	401	\N	1	0	401	2522	1	\N	2025-10-02 17:15:08	2025-10-02 17:15:08	61	13	\N	Sales	\N
145	40	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2541	1	\N	2025-10-02 17:15:08	2025-10-02 17:15:08	61	13	\N	Commission Entitlement	\N
146	40	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2543	1	\N	2025-10-02 17:15:08	2025-10-02 17:15:08	61	13	\N	Commission Entitlement	\N
147	41	2025-10-02	المبيعات	60	0	\N	1	60	0	52	1	\N	2025-10-02 17:16:42	2025-10-02 17:16:42	61	14	\N	Sales	\N
148	41	2025-10-02	المبيعات	0	60	\N	1	0	60	2500	1	\N	2025-10-02 17:16:42	2025-10-02 17:16:42	61	14	\N	Sales	\N
149	41	2025-10-02	المبيعات	0	400.00	\N	1	0	400	48	1	\N	2025-10-02 17:16:42	2025-10-02 17:16:42	61	14	\N	Sales	\N
150	41	2025-10-02	المبيعات	0	1	\N	1	0	1	826	1	\N	2025-10-02 17:16:42	2025-10-02 17:16:42	61	14	\N	Sales	\N
151	41	2025-10-02	المبيعات	401	0	\N	1	401	0	2577	1	\N	2025-10-02 17:16:42	2025-10-02 17:16:42	61	14	\N	Sales	\N
152	41	2025-10-02	المبيعات	401	0	\N	1	401	0	2538	1	\N	2025-10-02 17:16:42	2025-10-02 17:16:42	61	14	\N	Sales	\N
153	41	2025-10-02	المبيعات	0	401	\N	1	0	401	2577	1	\N	2025-10-02 17:16:42	2025-10-02 17:16:42	61	14	\N	Sales	\N
154	42	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2541	1	\N	2025-10-02 17:16:42	2025-10-02 17:16:42	61	14	\N	Commission Entitlement	\N
155	42	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2543	1	\N	2025-10-02 17:16:42	2025-10-02 17:16:42	61	14	\N	Commission Entitlement	\N
156	43	2025-10-02	المبيعات	40	0	\N	1	40	0	52	1	\N	2025-10-02 17:16:58	2025-10-02 17:16:58	61	15	\N	Sales	\N
157	43	2025-10-02	المبيعات	0	40	\N	1	0	40	2500	1	\N	2025-10-02 17:16:58	2025-10-02 17:16:58	61	15	\N	Sales	\N
158	43	2025-10-02	المبيعات	0	300.00	\N	1	0	300	48	1	\N	2025-10-02 17:16:58	2025-10-02 17:16:58	61	15	\N	Sales	\N
159	43	2025-10-02	المبيعات	0	1	\N	1	0	1	826	1	\N	2025-10-02 17:16:58	2025-10-02 17:16:58	61	15	\N	Sales	\N
160	43	2025-10-02	المبيعات	301	0	\N	1	301	0	2577	1	\N	2025-10-02 17:16:58	2025-10-02 17:16:58	61	15	\N	Sales	\N
161	43	2025-10-02	المبيعات	301	0	\N	1	301	0	2538	1	\N	2025-10-02 17:16:58	2025-10-02 17:16:58	61	15	\N	Sales	\N
162	43	2025-10-02	المبيعات	0	301	\N	1	0	301	2577	1	\N	2025-10-02 17:16:58	2025-10-02 17:16:58	61	15	\N	Sales	\N
163	44	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2541	1	\N	2025-10-02 17:16:58	2025-10-02 17:16:58	61	15	\N	Commission Entitlement	\N
164	44	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2543	1	\N	2025-10-02 17:16:58	2025-10-02 17:16:58	61	15	\N	Commission Entitlement	\N
165	10	2025-10-02	استحقاق راتب	1	0	\N	1	1	0	2536	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	10	\N	Salary Due	\N
166	10	2025-10-02	استحقاق راتب	0	1	\N	1	0	1	2539	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	10	\N	Salary Due	\N
167	11	2025-10-02	استحقاق راتب	1	0	\N	1	1	0	2540	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	11	\N	Salary Due	\N
168	11	2025-10-02	استحقاق راتب	0	1	\N	1	0	1	2543	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	11	\N	Salary Due	\N
169	12	2025-10-02	استحقاق راتب	1	0	\N	1	1	0	2544	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	12	\N	Salary Due	\N
170	12	2025-10-02	استحقاق راتب	0	1	\N	1	0	1	2547	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	12	\N	Salary Due	\N
171	13	2025-10-02	استحقاق راتب	1	0	\N	1	1	0	2548	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	13	\N	Salary Due	\N
172	13	2025-10-02	استحقاق راتب	0	1	\N	1	0	1	2551	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	13	\N	Salary Due	\N
173	14	2025-10-02	استحقاق راتب	1	0	\N	1	1	0	2552	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	14	\N	Salary Due	\N
174	14	2025-10-02	استحقاق راتب	0	1	\N	1	0	1	2555	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	14	\N	Salary Due	\N
175	15	2025-10-02	استحقاق راتب	1	0	\N	1	1	0	2556	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	15	\N	Salary Due	\N
176	15	2025-10-02	استحقاق راتب	0	1	\N	1	0	1	2559	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	15	\N	Salary Due	\N
177	16	2025-10-02	استحقاق راتب	1	0	\N	1	1	0	2560	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	16	\N	Salary Due	\N
178	16	2025-10-02	استحقاق راتب	0	1	\N	1	0	1	2563	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	16	\N	Salary Due	\N
179	17	2025-10-02	استحقاق راتب	1	0	\N	1	1	0	2564	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	17	\N	Salary Due	\N
180	17	2025-10-02	استحقاق راتب	0	1	\N	1	0	1	2567	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	17	\N	Salary Due	\N
181	18	2025-10-02	استحقاق راتب	1	0	\N	1	1	0	2568	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	18	\N	Salary Due	\N
182	18	2025-10-02	استحقاق راتب	0	1	\N	1	0	1	2571	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	18	\N	Salary Due	\N
183	19	2025-10-02	استحقاق راتب	1	0	\N	1	1	0	2573	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	19	\N	Salary Due	\N
184	19	2025-10-02	استحقاق راتب	0	1	\N	1	0	1	2576	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	19	\N	Salary Due	\N
185	20	2025-10-02	استحقاق راتب	1	0	\N	1	1	0	2578	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	20	\N	Salary Due	\N
186	20	2025-10-02	استحقاق راتب	0	1	\N	1	0	1	2581	1	\N	2025-10-02 17:35:54	2025-10-02 17:35:54	1	20	\N	Salary Due	\N
187	45	2025-10-02	المبيعات	60	0	\N	1	60	0	52	1	\N	2025-10-02 18:24:15	2025-10-02 18:24:15	61	16	\N	Sales	\N
188	45	2025-10-02	المبيعات	0	60	\N	1	0	60	2500	1	\N	2025-10-02 18:24:15	2025-10-02 18:24:15	61	16	\N	Sales	\N
189	45	2025-10-02	المبيعات	0	300.00	\N	1	0	300	48	1	\N	2025-10-02 18:24:15	2025-10-02 18:24:15	61	16	\N	Sales	\N
190	45	2025-10-02	المبيعات	0	1	\N	1	0	1	826	1	\N	2025-10-02 18:24:15	2025-10-02 18:24:15	61	16	\N	Sales	\N
191	45	2025-10-02	المبيعات	301	0	\N	1	301	0	2586	1	\N	2025-10-02 18:24:15	2025-10-02 18:24:15	61	16	\N	Sales	\N
192	45	2025-10-02	المبيعات	301	0	\N	1	301	0	2542	1	\N	2025-10-02 18:24:15	2025-10-02 18:24:15	61	16	\N	Sales	\N
193	45	2025-10-02	المبيعات	0	301	\N	1	0	301	2586	1	\N	2025-10-02 18:24:15	2025-10-02 18:24:15	61	16	\N	Sales	\N
194	46	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2541	1	\N	2025-10-02 18:24:15	2025-10-02 18:24:15	61	16	\N	Commission Entitlement	\N
195	46	2025-10-02	استحقاق عمولة	0	0	\N	1	0	0	2543	1	\N	2025-10-02 18:24:15	2025-10-02 18:24:15	61	16	\N	Commission Entitlement	\N
196	47	2025-10-04	سند صرف	1000	0	\N	1	1000	0	42	1	\N	2025-10-04 17:16:34	2025-10-04 17:16:34	1	1	\N	Payment Voucher	\N
197	47	2025-10-04	سند صرف	0	1000	سند صرف	1	0	1000	30	1	\N	2025-10-04 17:16:34	2025-10-04 17:16:34	1	1	3	Payment Voucher	\N
198	48	2025-10-04	سند صرف	500	0	\N	1	500	0	2588	1	\N	2025-10-04 17:21:25	2025-10-04 17:21:25	1	2	\N	Payment Voucher	\N
199	48	2025-10-04	سند صرف	0	500	\N	1	0	500	30	1	\N	2025-10-04 17:21:25	2025-10-04 17:21:25	1	2	3	Payment Voucher	\N
200	49	2025-10-04	سند صرف	1000	0	بيان موظف صرف	1	1000	0	2578	1	\N	2025-10-04 17:26:02	2025-10-04 17:26:02	1	3	\N	Payment Voucher	\N
201	49	2025-10-04	سند صرف	0	1000	سند صرف	1	0	1000	30	1	\N	2025-10-04 17:26:02	2025-10-04 17:26:02	1	3	3	Payment Voucher	\N
202	50	2025-10-05	المشتريات	200000	0	\N	1	200000	0	2500	1	\N	2025-10-05 09:03:56	2025-10-05 09:03:56	11	7	\N	Purchases	\N
203	50	2025-10-05	المشتريات	0	200000	\N	1	0	200000	2523	1	\N	2025-10-05 09:03:56	2025-10-05 09:03:56	11	7	\N	Purchases	\N
204	51	2025-10-05	المبيعات	1000	0	\N	1	1000	0	52	1	\N	2025-10-05 09:05:02	2025-10-05 09:05:02	11	17	\N	Sales	\N
205	51	2025-10-05	المبيعات	0	1000	\N	1	0	1000	2500	1	\N	2025-10-05 09:05:02	2025-10-05 09:05:02	11	17	\N	Sales	\N
206	51	2025-10-05	المبيعات	0	4000.00	\N	1	0	4000	2522	1	\N	2025-10-05 09:05:02	2025-10-05 09:05:02	11	17	\N	Sales	\N
207	51	2025-10-05	المبيعات	4000.00	0	\N	1	4000	0	30	1	\N	2025-10-05 09:05:02	2025-10-05 09:05:02	11	17	\N	Sales	\N
208	51	2025-10-05	المبيعات	4000	0	\N	1	4000	0	2522	1	\N	2025-10-05 09:05:02	2025-10-05 09:05:02	11	17	\N	Sales	\N
209	51	2025-10-05	المبيعات	0	5000.00	\N	1	0	5000	48	1	\N	2025-10-05 09:05:02	2025-10-05 09:05:02	11	17	\N	Sales	\N
210	51	2025-10-05	المبيعات	1000	0	\N	1	1000	0	50	1	\N	2025-10-05 09:05:02	2025-10-05 09:05:02	11	17	\N	Sales	\N
211	52	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-05 09:05:02	2025-10-05 09:05:02	11	17	\N	Commission Entitlement	\N
212	52	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-05 09:05:02	2025-10-05 09:05:02	11	17	\N	Commission Entitlement	\N
213	53	2025-10-05	المبيعات	20	0	\N	1	20	0	52	1	\N	2025-10-05 09:10:30	2025-10-05 09:10:30	61	18	\N	Sales	\N
214	53	2025-10-05	المبيعات	0	20	\N	1	0	20	2500	1	\N	2025-10-05 09:10:30	2025-10-05 09:10:30	61	18	\N	Sales	\N
215	53	2025-10-05	المبيعات	100.0	0	\N	1	100	0	30	1	\N	2025-10-05 09:10:30	2025-10-05 09:10:30	61	18	\N	Sales	\N
216	53	2025-10-05	المبيعات	0	100.0	\N	1	0	100	2522	1	\N	2025-10-05 09:10:30	2025-10-05 09:10:30	61	18	\N	Sales	\N
217	53	2025-10-05	المبيعات	100.0	0	\N	1	100	0	2522	1	\N	2025-10-05 09:10:30	2025-10-05 09:10:30	61	18	\N	Sales	\N
218	53	2025-10-05	المبيعات	0	100.0	\N	1	0	100	48	1	\N	2025-10-05 09:10:30	2025-10-05 09:10:30	61	18	\N	Sales	\N
219	54	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2541	1	\N	2025-10-05 09:10:30	2025-10-05 09:10:30	61	18	\N	Commission Entitlement	\N
220	54	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2543	1	\N	2025-10-05 09:10:30	2025-10-05 09:10:30	61	18	\N	Commission Entitlement	\N
221	55	2025-10-05	المبيعات	1000	0	\N	1	1000	0	52	1	\N	2025-10-05 10:32:49	2025-10-05 10:32:49	11	19	\N	Sales	\N
222	55	2025-10-05	المبيعات	0	1000	\N	1	0	1000	2500	1	\N	2025-10-05 10:32:49	2025-10-05 10:32:49	11	19	\N	Sales	\N
223	55	2025-10-05	المبيعات	0	4700.00	\N	1	0	4700	2522	1	\N	2025-10-05 10:32:49	2025-10-05 10:32:49	11	19	\N	Sales	\N
224	55	2025-10-05	المبيعات	4700.00	0	\N	1	4700	0	30	1	\N	2025-10-05 10:32:49	2025-10-05 10:32:49	11	19	\N	Sales	\N
225	55	2025-10-05	المبيعات	0	5000.00	\N	1	0	5000	48	1	\N	2025-10-05 10:32:49	2025-10-05 10:32:49	11	19	\N	Sales	\N
226	55	2025-10-05	المبيعات	0	700.00	\N	1	0	700	40	1	\N	2025-10-05 10:32:49	2025-10-05 10:32:49	11	19	\N	Sales	\N
227	55	2025-10-05	المبيعات	4700.00	0	\N	1	4700	0	2522	1	\N	2025-10-05 10:32:49	2025-10-05 10:32:49	11	19	\N	Sales	\N
228	55	2025-10-05	المبيعات	1000	0	\N	1	1000	0	50	1	\N	2025-10-05 10:32:49	2025-10-05 10:32:49	11	19	\N	Sales	\N
229	56	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-05 10:32:49	2025-10-05 10:32:49	11	19	\N	Commission Entitlement	\N
230	56	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-05 10:32:49	2025-10-05 10:32:49	11	19	\N	Commission Entitlement	\N
231	57	2025-10-05	المبيعات	400	0	\N	1	400	0	52	1	\N	2025-10-05 15:03:45	2025-10-05 15:03:45	1	20	\N	Sales	\N
232	57	2025-10-05	المبيعات	0	400	\N	1	0	400	2500	1	\N	2025-10-05 15:03:45	2025-10-05 15:03:45	1	20	\N	Sales	\N
233	57	2025-10-05	المبيعات	6000.00	0	\N	1	6000	0	30	1	\N	2025-10-05 15:03:45	2025-10-05 15:03:45	1	20	\N	Sales	\N
234	57	2025-10-05	المبيعات	0	6000.00	\N	1	0	6000	2586	1	\N	2025-10-05 15:03:45	2025-10-05 15:03:45	1	20	\N	Sales	\N
235	57	2025-10-05	المبيعات	6000.00	0	\N	1	6000	0	2586	1	\N	2025-10-05 15:03:45	2025-10-05 15:03:45	1	20	\N	Sales	\N
236	57	2025-10-05	المبيعات	0	6000.00	\N	1	0	6000	48	1	\N	2025-10-05 15:03:45	2025-10-05 15:03:45	1	20	\N	Sales	\N
237	58	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-05 15:03:45	2025-10-05 15:03:45	1	20	\N	Commission Entitlement	\N
238	58	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-05 15:03:45	2025-10-05 15:03:45	1	20	\N	Commission Entitlement	\N
239	59	2025-10-05	المشتريات	20000.00	0	\N	1	20000	0	2500	1	\N	2025-10-05 17:29:06	2025-10-05 17:29:06	1	8	\N	Purchases	\N
240	59	2025-10-05	المشتريات	0	20000.00	\N	1	0	20000	2523	1	\N	2025-10-05 17:29:06	2025-10-05 17:29:06	1	8	\N	Purchases	\N
241	59	2025-10-05	المشتريات	20000.00	0	\N	1	20000	0	2523	1	\N	2025-10-05 17:29:06	2025-10-05 17:29:06	1	8	\N	Purchases	\N
242	59	2025-10-05	المشتريات	0	20000.00	\N	1	0	20000	30	1	\N	2025-10-05 17:29:06	2025-10-05 17:29:06	1	8	\N	Purchases	\N
243	60	2025-10-05	المبيعات	1000	0	\N	1	1000	0	52	1	\N	2025-10-05 17:32:09	2025-10-05 17:32:09	62	21	\N	Sales	\N
244	60	2025-10-05	المبيعات	0	1000	\N	1	0	1000	2500	1	\N	2025-10-05 17:32:09	2025-10-05 17:32:09	62	21	\N	Sales	\N
245	60	2025-10-05	المبيعات	0	3000	\N	1	0	3000	2522	1	\N	2025-10-05 17:32:09	2025-10-05 17:32:09	62	21	\N	Sales	\N
246	60	2025-10-05	المبيعات	3000	0	\N	1	3000	0	32	1	\N	2025-10-05 17:32:09	2025-10-05 17:32:09	62	21	\N	Sales	\N
247	60	2025-10-05	المبيعات	3000	0	\N	1	3000	0	2522	1	\N	2025-10-05 17:32:09	2025-10-05 17:32:09	62	21	\N	Sales	\N
248	60	2025-10-05	المبيعات	0	5000.00	\N	1	0	5000	48	1	\N	2025-10-05 17:32:09	2025-10-05 17:32:09	62	21	\N	Sales	\N
249	60	2025-10-05	المبيعات	2000	0	\N	1	2000	0	50	1	\N	2025-10-05 17:32:09	2025-10-05 17:32:09	62	21	\N	Sales	\N
250	61	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-05 17:32:09	2025-10-05 17:32:09	62	21	\N	Commission Entitlement	\N
251	61	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-05 17:32:09	2025-10-05 17:32:09	62	21	\N	Commission Entitlement	\N
252	62	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-05 17:32:09	2025-10-05 17:32:09	62	21	\N	Commission Entitlement	\N
253	62	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-05 17:32:09	2025-10-05 17:32:09	62	21	\N	Commission Entitlement	\N
254	63	2025-10-05	مرتجع مبيعات	200	0	\N	1	200	0	2500	1	\N	2025-10-05 17:34:44	2025-10-05 17:34:44	1	1	\N	Return Sales	\N
255	63	2025-10-05	مرتجع مبيعات	0	200	\N	1	0	200	52	1	\N	2025-10-05 17:34:44	2025-10-05 17:34:44	1	1	\N	Return Sales	\N
256	63	2025-10-05	مرتجع مبيعات	800	0	\N	1	800	0	2522	1	\N	2025-10-05 17:34:44	2025-10-05 17:34:44	1	1	\N	Return Sales	\N
257	63	2025-10-05	مرتجع مبيعات	0	800	\N	1	0	800	30	1	\N	2025-10-05 17:34:44	2025-10-05 17:34:44	1	1	\N	Return Sales	\N
258	63	2025-10-05	مرتجع مبيعات	1000	0	\N	1	1000	0	49	1	\N	2025-10-05 17:34:44	2025-10-05 17:34:44	1	1	\N	Return Sales	\N
259	63	2025-10-05	مرتجع مبيعات	0	800	\N	1	0	800	2522	1	\N	2025-10-05 17:34:44	2025-10-05 17:34:44	1	1	\N	Return Sales	\N
260	63	2025-10-05	مرتجع مبيعات	0	200.00	\N	1	0	200	50	1	\N	2025-10-05 17:34:44	2025-10-05 17:34:44	1	1	\N	Return Sales	\N
261	64	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-05 17:34:44	2025-10-05 17:34:44	1	1	\N	Commission Entitlement	\N
262	64	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-05 17:34:44	2025-10-05 17:34:44	1	1	\N	Commission Entitlement	\N
263	65	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-05 17:34:44	2025-10-05 17:34:44	1	1	\N	Commission Entitlement	\N
264	65	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-05 17:34:44	2025-10-05 17:34:44	1	1	\N	Commission Entitlement	\N
265	66	2025-10-05	مرتجع مبيعات	200	0	\N	1	200	0	2500	1	\N	2025-10-05 17:36:11	2025-10-05 17:36:11	1	2	\N	Return Sales	\N
266	66	2025-10-05	مرتجع مبيعات	0	200	\N	1	0	200	52	1	\N	2025-10-05 17:36:11	2025-10-05 17:36:11	1	2	\N	Return Sales	\N
267	66	2025-10-05	مرتجع مبيعات	1000	0	\N	1	1000	0	49	1	\N	2025-10-05 17:36:11	2025-10-05 17:36:11	1	2	\N	Return Sales	\N
268	66	2025-10-05	مرتجع مبيعات	0	800	\N	1	0	800	2522	1	\N	2025-10-05 17:36:11	2025-10-05 17:36:11	1	2	\N	Return Sales	\N
269	66	2025-10-05	مرتجع مبيعات	0	200.00	\N	1	0	200	50	1	\N	2025-10-05 17:36:11	2025-10-05 17:36:11	1	2	\N	Return Sales	\N
270	67	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-05 17:36:11	2025-10-05 17:36:11	1	2	\N	Commission Entitlement	\N
271	67	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-05 17:36:11	2025-10-05 17:36:11	1	2	\N	Commission Entitlement	\N
272	68	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-05 17:36:11	2025-10-05 17:36:11	1	2	\N	Commission Entitlement	\N
273	68	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-05 17:36:11	2025-10-05 17:36:11	1	2	\N	Commission Entitlement	\N
274	69	2025-10-05	مرتجع مبيعات	200	0	\N	1	200	0	2500	1	\N	2025-10-05 17:37:45	2025-10-05 17:37:45	1	3	\N	Return Sales	\N
275	69	2025-10-05	مرتجع مبيعات	0	200	\N	1	0	200	52	1	\N	2025-10-05 17:37:45	2025-10-05 17:37:45	1	3	\N	Return Sales	\N
276	69	2025-10-05	مرتجع مبيعات	1000	0	\N	1	1000	0	49	1	\N	2025-10-05 17:37:45	2025-10-05 17:37:45	1	3	\N	Return Sales	\N
277	69	2025-10-05	مرتجع مبيعات	0	800	\N	1	0	800	2522	1	\N	2025-10-05 17:37:45	2025-10-05 17:37:45	1	3	\N	Return Sales	\N
278	69	2025-10-05	مرتجع مبيعات	0	200.00	\N	1	0	200	50	1	\N	2025-10-05 17:37:45	2025-10-05 17:37:45	1	3	\N	Return Sales	\N
279	69	2025-10-05	مرتجع مبيعات	400	0	\N	1	400	0	2522	1	\N	2025-10-05 17:37:45	2025-10-05 17:37:45	1	3	\N	Return Sales	\N
280	69	2025-10-05	مرتجع مبيعات	0	400	\N	1	0	400	30	1	\N	2025-10-05 17:37:45	2025-10-05 17:37:45	1	3	\N	Return Sales	\N
281	70	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-05 17:37:45	2025-10-05 17:37:45	1	3	\N	Commission Entitlement	\N
282	70	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-05 17:37:45	2025-10-05 17:37:45	1	3	\N	Commission Entitlement	\N
283	71	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-05 17:37:45	2025-10-05 17:37:45	1	3	\N	Commission Entitlement	\N
284	71	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-05 17:37:45	2025-10-05 17:37:45	1	3	\N	Commission Entitlement	\N
285	72	2025-10-05	المبيعات	1000	0	\N	1	1000	0	52	1	\N	2025-10-05 17:44:37	2025-10-05 17:44:37	62	22	\N	Sales	\N
286	72	2025-10-05	المبيعات	0	1000	\N	1	0	1000	2500	1	\N	2025-10-05 17:44:37	2025-10-05 17:44:37	62	22	\N	Sales	\N
287	72	2025-10-05	المبيعات	0	4560	\N	1	0	4560	2522	1	\N	2025-10-05 17:44:37	2025-10-05 17:44:37	62	22	\N	Sales	\N
288	72	2025-10-05	المبيعات	4560	0	\N	1	4560	0	32	1	\N	2025-10-05 17:44:37	2025-10-05 17:44:37	62	22	\N	Sales	\N
289	72	2025-10-05	المبيعات	4560	0	\N	1	4560	0	2522	1	\N	2025-10-05 17:44:37	2025-10-05 17:44:37	62	22	\N	Sales	\N
290	72	2025-10-05	المبيعات	0	5000.00	\N	1	0	5000	48	1	\N	2025-10-05 17:44:37	2025-10-05 17:44:37	62	22	\N	Sales	\N
291	72	2025-10-05	المبيعات	1000	0	\N	1	1000	0	50	1	\N	2025-10-05 17:44:37	2025-10-05 17:44:37	62	22	\N	Sales	\N
292	72	2025-10-05	المبيعات	560	0	\N	1	560	0	30	1	\N	2025-10-05 17:44:37	2025-10-05 17:44:37	62	22	\N	Sales	\N
293	72	2025-10-05	المبيعات	0	560	\N	1	0	560	2522	1	\N	2025-10-05 17:44:37	2025-10-05 17:44:37	62	22	\N	Sales	\N
294	72	2025-10-05	المبيعات	560	0	\N	1	560	0	2522	1	\N	2025-10-05 17:44:37	2025-10-05 17:44:37	62	22	\N	Sales	\N
295	72	2025-10-05	المبيعات	0	560	\N	1	0	560	40	1	\N	2025-10-05 17:44:37	2025-10-05 17:44:37	62	22	\N	Sales	\N
296	73	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-05 17:44:37	2025-10-05 17:44:37	62	22	\N	Commission Entitlement	\N
297	73	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-05 17:44:37	2025-10-05 17:44:37	62	22	\N	Commission Entitlement	\N
298	74	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-10-05 17:44:37	2025-10-05 17:44:37	62	22	\N	Commission Entitlement	\N
299	74	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-10-05 17:44:37	2025-10-05 17:44:37	62	22	\N	Commission Entitlement	\N
300	75	2025-10-05	سند صرف	10	0	\N	1	10	0	57	1	\N	2025-10-05 21:39:47	2025-10-05 21:39:47	61	4	\N	Payment Voucher	\N
301	75	2025-10-05	سند صرف	0	10	\N	1	0	10	30	1	\N	2025-10-05 21:39:47	2025-10-05 21:39:47	61	4	\N	Payment Voucher	\N
302	76	2025-10-05	المبيعات	40	0	\N	1	40	0	52	1	\N	2025-10-05 21:47:16	2025-10-05 21:47:16	61	23	\N	Sales	\N
303	76	2025-10-05	المبيعات	0	40	\N	1	0	40	2500	1	\N	2025-10-05 21:47:16	2025-10-05 21:47:16	61	23	\N	Sales	\N
304	76	2025-10-05	المبيعات	200.0	0	\N	1	200	0	30	1	\N	2025-10-05 21:47:16	2025-10-05 21:47:16	61	23	\N	Sales	\N
305	76	2025-10-05	المبيعات	0	200.0	\N	1	0	200	2522	1	\N	2025-10-05 21:47:16	2025-10-05 21:47:16	61	23	\N	Sales	\N
306	76	2025-10-05	المبيعات	200.0	0	\N	1	200	0	2522	1	\N	2025-10-05 21:47:16	2025-10-05 21:47:16	61	23	\N	Sales	\N
307	76	2025-10-05	المبيعات	0	200.0	\N	1	0	200	48	1	\N	2025-10-05 21:47:16	2025-10-05 21:47:16	61	23	\N	Sales	\N
308	77	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2541	1	\N	2025-10-05 21:47:16	2025-10-05 21:47:16	61	23	\N	Commission Entitlement	\N
309	77	2025-10-05	استحقاق عمولة	0	0	\N	1	0	0	2543	1	\N	2025-10-05 21:47:16	2025-10-05 21:47:16	61	23	\N	Commission Entitlement	\N
310	78	2025-10-06	المشتريات	20000.00	0	\N	1	20000	0	2500	1	\N	2025-10-06 13:31:45	2025-10-06 13:31:45	60	9	\N	Purchases	\N
311	78	2025-10-06	المشتريات	0	20000.00	\N	1	0	20000	2523	1	\N	2025-10-06 13:31:45	2025-10-06 13:31:45	60	9	\N	Purchases	\N
312	78	2025-10-06	المشتريات	20000.00	0	\N	1	20000	0	2523	1	\N	2025-10-06 13:31:45	2025-10-06 13:31:45	60	9	\N	Purchases	\N
313	78	2025-10-06	المشتريات	0	20000.00	\N	1	0	20000	30	1	\N	2025-10-06 13:31:45	2025-10-06 13:31:45	60	9	\N	Purchases	\N
314	79	2025-10-06	المبيعات	20	0	\N	1	20	0	52	1	\N	2025-10-06 13:34:32	2025-10-06 13:34:32	60	24	\N	Sales	\N
315	79	2025-10-06	المبيعات	0	20	\N	1	0	20	2500	1	\N	2025-10-06 13:34:32	2025-10-06 13:34:32	60	24	\N	Sales	\N
316	79	2025-10-06	المبيعات	0	104	\N	1	0	104	2522	1	\N	2025-10-06 13:34:32	2025-10-06 13:34:32	60	24	\N	Sales	\N
317	79	2025-10-06	المبيعات	104.00	0	\N	1	104	0	32	1	\N	2025-10-06 13:34:32	2025-10-06 13:34:32	60	24	\N	Sales	\N
318	79	2025-10-06	المبيعات	0	100.00	\N	1	0	100	48	1	\N	2025-10-06 13:34:32	2025-10-06 13:34:32	60	24	\N	Sales	\N
319	79	2025-10-06	المبيعات	0	14.00	\N	1	0	14	40	1	\N	2025-10-06 13:34:32	2025-10-06 13:34:32	60	24	\N	Sales	\N
320	79	2025-10-06	المبيعات	104	0	\N	1	104	0	2522	1	\N	2025-10-06 13:34:32	2025-10-06 13:34:32	60	24	\N	Sales	\N
321	79	2025-10-06	المبيعات	10	0	\N	1	10	0	50	1	\N	2025-10-06 13:34:32	2025-10-06 13:34:32	60	24	\N	Sales	\N
322	80	2025-10-06	استحقاق عمولة	0	0	\N	1	0	0	2537	1	\N	2025-10-06 13:34:32	2025-10-06 13:34:32	60	24	\N	Commission Entitlement	\N
323	80	2025-10-06	استحقاق عمولة	0	0	\N	1	0	0	2539	1	\N	2025-10-06 13:34:32	2025-10-06 13:34:32	60	24	\N	Commission Entitlement	\N
324	81	2025-10-06	المبيعات	20	0	\N	1	20	0	52	1	\N	2025-10-06 13:36:22	2025-10-06 13:36:22	60	25	\N	Sales	\N
325	81	2025-10-06	المبيعات	0	20	\N	1	0	20	2500	1	\N	2025-10-06 13:36:22	2025-10-06 13:36:22	60	25	\N	Sales	\N
326	81	2025-10-06	المبيعات	0	118.56	\N	1	0	118.56	2522	1	\N	2025-10-06 13:36:22	2025-10-06 13:36:22	60	25	\N	Sales	\N
327	81	2025-10-06	المبيعات	118.56	0	\N	1	118.56	0	30	1	\N	2025-10-06 13:36:22	2025-10-06 13:36:22	60	25	\N	Sales	\N
328	81	2025-10-06	المبيعات	0	100.00	\N	1	0	100	48	1	\N	2025-10-06 13:36:22	2025-10-06 13:36:22	60	25	\N	Sales	\N
329	81	2025-10-06	المبيعات	0	14.00	\N	1	0	14	40	1	\N	2025-10-06 13:36:22	2025-10-06 13:36:22	60	25	\N	Sales	\N
330	81	2025-10-06	المبيعات	118.56	0	\N	1	118.56	0	2522	1	\N	2025-10-06 13:36:22	2025-10-06 13:36:22	60	25	\N	Sales	\N
331	81	2025-10-06	المبيعات	10	0	\N	1	10	0	50	1	\N	2025-10-06 13:36:22	2025-10-06 13:36:22	60	25	\N	Sales	\N
332	82	2025-10-06	استحقاق عمولة	0	0	\N	1	0	0	2537	1	\N	2025-10-06 13:36:22	2025-10-06 13:36:22	60	25	\N	Commission Entitlement	\N
333	82	2025-10-06	استحقاق عمولة	0	0	\N	1	0	0	2539	1	\N	2025-10-06 13:36:22	2025-10-06 13:36:22	60	25	\N	Commission Entitlement	\N
334	83	2025-10-06	المبيعات	20	0	\N	1	20	0	52	1	\N	2025-10-06 13:38:35	2025-10-06 13:38:35	60	26	\N	Sales	\N
335	83	2025-10-06	المبيعات	0	20	\N	1	0	20	2500	1	\N	2025-10-06 13:38:35	2025-10-06 13:38:35	60	26	\N	Sales	\N
336	83	2025-10-06	المبيعات	114	0	\N	1	114	0	30	1	\N	2025-10-06 13:38:35	2025-10-06 13:38:35	60	26	\N	Sales	\N
337	83	2025-10-06	المبيعات	0	114	\N	1	0	114	2522	1	\N	2025-10-06 13:38:35	2025-10-06 13:38:35	60	26	\N	Sales	\N
338	83	2025-10-06	المبيعات	114	0	\N	1	114	0	2522	1	\N	2025-10-06 13:38:35	2025-10-06 13:38:35	60	26	\N	Sales	\N
339	83	2025-10-06	المبيعات	0	100.00	\N	1	0	100	48	1	\N	2025-10-06 13:38:35	2025-10-06 13:38:35	60	26	\N	Sales	\N
340	83	2025-10-06	المبيعات	0	14.00	\N	1	0	14	40	1	\N	2025-10-06 13:38:35	2025-10-06 13:38:35	60	26	\N	Sales	\N
341	83	2025-10-06	المبيعات	15.96	0	\N	1	15.96	0	30	1	\N	2025-10-06 13:38:35	2025-10-06 13:38:35	60	26	\N	Sales	\N
342	83	2025-10-06	المبيعات	0	15.96	\N	1	0	15.96	2522	1	\N	2025-10-06 13:38:35	2025-10-06 13:38:35	60	26	\N	Sales	\N
343	83	2025-10-06	المبيعات	15.96	0	\N	1	15.96	0	2522	1	\N	2025-10-06 13:38:35	2025-10-06 13:38:35	60	26	\N	Sales	\N
344	83	2025-10-06	المبيعات	0	15.96	\N	1	0	15.96	40	1	\N	2025-10-06 13:38:35	2025-10-06 13:38:35	60	26	\N	Sales	\N
345	84	2025-10-06	استحقاق عمولة	0	0	\N	1	0	0	2537	1	\N	2025-10-06 13:38:35	2025-10-06 13:38:35	60	26	\N	Commission Entitlement	\N
346	84	2025-10-06	استحقاق عمولة	0	0	\N	1	0	0	2539	1	\N	2025-10-06 13:38:35	2025-10-06 13:38:35	60	26	\N	Commission Entitlement	\N
347	85	2025-10-06	المبيعات	20	0	\N	1	20	0	52	1	\N	2025-10-06 13:40:42	2025-10-06 13:40:42	60	27	\N	Sales	\N
348	85	2025-10-06	المبيعات	0	20	\N	1	0	20	2500	1	\N	2025-10-06 13:40:42	2025-10-06 13:40:42	60	27	\N	Sales	\N
349	85	2025-10-06	المبيعات	100.00	0	\N	1	100	0	30	1	\N	2025-10-06 13:40:42	2025-10-06 13:40:42	60	27	\N	Sales	\N
350	85	2025-10-06	المبيعات	0	100.00	\N	1	0	100	2522	1	\N	2025-10-06 13:40:42	2025-10-06 13:40:42	60	27	\N	Sales	\N
351	85	2025-10-06	المبيعات	100.00	0	\N	1	100	0	2522	1	\N	2025-10-06 13:40:42	2025-10-06 13:40:42	60	27	\N	Sales	\N
352	85	2025-10-06	المبيعات	0	100.00	\N	1	0	100	48	1	\N	2025-10-06 13:40:42	2025-10-06 13:40:42	60	27	\N	Sales	\N
353	86	2025-10-06	استحقاق عمولة	0	0	\N	1	0	0	2537	1	\N	2025-10-06 13:40:42	2025-10-06 13:40:42	60	27	\N	Commission Entitlement	\N
354	86	2025-10-06	استحقاق عمولة	0	0	\N	1	0	0	2539	1	\N	2025-10-06 13:40:42	2025-10-06 13:40:42	60	27	\N	Commission Entitlement	\N
355	87	2025-10-06	المشتريات	2000.00	0	\N	1	2000	0	2500	1	\N	2025-10-06 16:06:02	2025-10-06 16:06:02	1	10	\N	Purchases	\N
356	87	2025-10-06	المشتريات	0	1500	\N	1	0	1500	2523	1	\N	2025-10-06 16:06:02	2025-10-06 16:06:02	1	10	\N	Purchases	\N
357	87	2025-10-06	المشتريات	0	500	\N	1	0	500	206	1	\N	2025-10-06 16:06:02	2025-10-06 16:06:02	1	10	\N	Purchases	\N
358	87	2025-10-06	المشتريات	1500	0	\N	1	1500	0	2523	1	\N	2025-10-06 16:06:02	2025-10-06 16:06:02	1	10	\N	Purchases	\N
359	87	2025-10-06	المشتريات	0	1500	\N	1	0	1500	30	1	\N	2025-10-06 16:06:02	2025-10-06 16:06:02	1	10	\N	Purchases	\N
360	88	2025-10-06	المشتريات	2000.00	0	\N	1	2000	0	2500	1	\N	2025-10-06 17:45:28	2025-10-06 17:45:28	1	11	\N	Purchases	\N
361	88	2025-10-06	المشتريات	0	2000.00	\N	1	0	2000	2523	1	\N	2025-10-06 17:45:28	2025-10-06 17:45:28	1	11	\N	Purchases	\N
362	88	2025-10-06	المشتريات	2000.00	0	\N	1	2000	0	2523	1	\N	2025-10-06 17:45:28	2025-10-06 17:45:28	1	11	\N	Purchases	\N
363	88	2025-10-06	المشتريات	0	2000.00	\N	1	0	2000	30	1	\N	2025-10-06 17:45:28	2025-10-06 17:45:28	1	11	\N	Purchases	\N
364	89	2025-10-06	المشتريات	2000.00	0	\N	1	2000	0	2500	1	\N	2025-10-06 17:54:05	2025-10-06 17:54:05	1	12	\N	Purchases	\N
365	89	2025-10-06	المشتريات	0	1900	\N	1	0	1900	2523	1	\N	2025-10-06 17:54:05	2025-10-06 17:54:05	1	12	\N	Purchases	\N
366	89	2025-10-06	المشتريات	0	100	\N	1	0	100	206	1	\N	2025-10-06 17:54:05	2025-10-06 17:54:05	1	12	\N	Purchases	\N
367	89	2025-10-06	المشتريات	1900	0	\N	1	1900	0	2523	1	\N	2025-10-06 17:54:05	2025-10-06 17:54:05	1	12	\N	Purchases	\N
368	89	2025-10-06	المشتريات	0	1900	\N	1	0	1900	30	1	\N	2025-10-06 17:54:05	2025-10-06 17:54:05	1	12	\N	Purchases	\N
369	90	2025-10-06	المشتريات	2000.00	0	\N	1	2000	0	2500	1	\N	2025-10-06 18:03:06	2025-10-06 18:03:06	1	13	\N	Purchases	\N
370	90	2025-10-06	المشتريات	280.00	0	\N	1	280	0	40	1	\N	2025-10-06 18:03:06	2025-10-06 18:03:06	1	13	\N	Purchases	\N
371	90	2025-10-06	المشتريات	0	2280	\N	1	0	2280	2523	1	\N	2025-10-06 18:03:06	2025-10-06 18:03:06	1	13	\N	Purchases	\N
372	90	2025-10-06	المشتريات	2280	0	\N	1	2280	0	2523	1	\N	2025-10-06 18:03:06	2025-10-06 18:03:06	1	13	\N	Purchases	\N
373	90	2025-10-06	المشتريات	0	2280	\N	1	0	2280	30	1	\N	2025-10-06 18:03:06	2025-10-06 18:03:06	1	13	\N	Purchases	\N
374	91	2025-10-06	المشتريات	2000.00	0	\N	1	2000	0	2500	1	\N	2025-10-06 18:05:12	2025-10-06 18:05:12	1	14	\N	Purchases	\N
375	91	2025-10-06	المشتريات	0	1400	\N	1	0	1400	2523	1	\N	2025-10-06 18:05:12	2025-10-06 18:05:12	1	14	\N	Purchases	\N
376	91	2025-10-06	المشتريات	0	600	\N	1	0	600	206	1	\N	2025-10-06 18:05:12	2025-10-06 18:05:12	1	14	\N	Purchases	\N
377	91	2025-10-06	المشتريات	1400	0	\N	1	1400	0	2523	1	\N	2025-10-06 18:05:12	2025-10-06 18:05:12	1	14	\N	Purchases	\N
378	91	2025-10-06	المشتريات	0	1400	\N	1	0	1400	30	1	\N	2025-10-06 18:05:12	2025-10-06 18:05:12	1	14	\N	Purchases	\N
379	92	2025-10-06	المشتريات	2000.00	0	\N	1	2000	0	2500	1	\N	2025-10-06 18:10:43	2025-10-06 18:10:43	1	15	\N	Purchases	\N
380	92	2025-10-06	المشتريات	280.00	0	\N	1	280	0	40	1	\N	2025-10-06 18:10:43	2025-10-06 18:10:43	1	15	\N	Purchases	\N
381	92	2025-10-06	المشتريات	0	1780	\N	1	0	1780	2523	1	\N	2025-10-06 18:10:43	2025-10-06 18:10:43	1	15	\N	Purchases	\N
382	92	2025-10-06	المشتريات	0	500	\N	1	0	500	206	1	\N	2025-10-06 18:10:43	2025-10-06 18:10:43	1	15	\N	Purchases	\N
383	92	2025-10-06	المشتريات	1780	0	\N	1	1780	0	2523	1	\N	2025-10-06 18:10:43	2025-10-06 18:10:43	1	15	\N	Purchases	\N
384	92	2025-10-06	المشتريات	0	1780	\N	1	0	1780	30	1	\N	2025-10-06 18:10:43	2025-10-06 18:10:43	1	15	\N	Purchases	\N
385	93	2025-10-06	المشتريات	2000.00	0	\N	1	2000	0	2500	1	\N	2025-10-06 18:52:32	2025-10-06 18:52:32	1	16	\N	Purchases	\N
386	93	2025-10-06	المشتريات	280.00	0	\N	1	280	0	40	1	\N	2025-10-06 18:52:32	2025-10-06 18:52:32	1	16	\N	Purchases	\N
387	93	2025-10-06	المشتريات	0	2180	\N	1	0	2180	2523	1	\N	2025-10-06 18:52:32	2025-10-06 18:52:32	1	16	\N	Purchases	\N
388	93	2025-10-06	المشتريات	0	100	\N	1	0	100	206	1	\N	2025-10-06 18:52:32	2025-10-06 18:52:32	1	16	\N	Purchases	\N
389	93	2025-10-06	المشتريات	2180	0	\N	1	2180	0	2523	1	\N	2025-10-06 18:52:32	2025-10-06 18:52:32	1	16	\N	Purchases	\N
390	93	2025-10-06	المشتريات	0	2180	\N	1	0	2180	30	1	\N	2025-10-06 18:52:32	2025-10-06 18:52:32	1	16	\N	Purchases	\N
391	94	2025-10-06	المشتريات	2000.00	0	\N	1	2000	0	2500	1	\N	2025-10-06 18:53:21	2025-10-06 18:53:21	1	17	\N	Purchases	\N
392	94	2025-10-06	المشتريات	280.00	0	\N	1	280	0	40	1	\N	2025-10-06 18:53:21	2025-10-06 18:53:21	1	17	\N	Purchases	\N
393	94	2025-10-06	المشتريات	0	1680	\N	1	0	1680	2523	1	\N	2025-10-06 18:53:21	2025-10-06 18:53:21	1	17	\N	Purchases	\N
394	94	2025-10-06	المشتريات	0	600	\N	1	0	600	206	1	\N	2025-10-06 18:53:21	2025-10-06 18:53:21	1	17	\N	Purchases	\N
395	94	2025-10-06	المشتريات	1680	0	\N	1	1680	0	2523	1	\N	2025-10-06 18:53:21	2025-10-06 18:53:21	1	17	\N	Purchases	\N
396	94	2025-10-06	المشتريات	0	1680	\N	1	0	1680	30	1	\N	2025-10-06 18:53:21	2025-10-06 18:53:21	1	17	\N	Purchases	\N
397	95	2025-10-07	شحن	100.00	0	\N	1	100	0	30	1	\N	2025-10-07 11:19:56	2025-10-07 11:19:56	1	1	\N	Shipping	\N
398	95	2025-10-07	شحن	0	100.00	\N	1	0	100	2535	1	\N	2025-10-07 11:19:56	2025-10-07 11:19:56	1	1	\N	Shipping	\N
399	95	2025-10-07	شحن	100.00	0	\N	1	100	0	2535	1	\N	2025-10-07 11:19:56	2025-10-07 11:19:56	1	1	\N	Shipping	\N
400	95	2025-10-07	شحن	0	100.00	\N	1	0	100	48	1	\N	2025-10-07 11:19:56	2025-10-07 11:19:56	1	1	\N	Shipping	\N
401	98	2025-10-07	شحن	100.00	0	\N	1	100	0	30	1	\N	2025-10-07 11:54:42	2025-10-07 11:54:42	1	2	\N	Shipping	\N
402	98	2025-10-07	شحن	0	100.00	\N	1	0	100	2572	1	\N	2025-10-07 11:54:43	2025-10-07 11:54:43	1	2	\N	Shipping	\N
403	98	2025-10-07	شحن	100.00	0	\N	1	100	0	2572	1	\N	2025-10-07 11:54:43	2025-10-07 11:54:43	1	2	\N	Shipping	\N
404	98	2025-10-07	شحن	0	100.00	\N	1	0	100	48	1	\N	2025-10-07 11:54:43	2025-10-07 11:54:43	1	2	\N	Shipping	\N
405	99	2025-10-07	شحن	0.00	0	\N	1	0	0	2577	1	\N	2025-10-07 12:00:28	2025-10-07 12:00:28	1	3	\N	Shipping	\N
406	99	2025-10-07	شحن	0	0.00	\N	1	0	0	48	1	\N	2025-10-07 12:00:28	2025-10-07 12:00:28	1	3	\N	Shipping	\N
407	100	2025-10-07	شحن	100.00	0	\N	1	100	0	30	1	\N	2025-10-07 12:02:01	2025-10-07 12:02:01	1	4	\N	Shipping	\N
408	100	2025-10-07	شحن	0	100.00	\N	1	0	100	2535	1	\N	2025-10-07 12:02:01	2025-10-07 12:02:01	1	4	\N	Shipping	\N
409	100	2025-10-07	شحن	100.00	0	\N	1	100	0	2535	1	\N	2025-10-07 12:02:01	2025-10-07 12:02:01	1	4	\N	Shipping	\N
410	100	2025-10-07	شحن	0	0	\N	1	0	0	2586	1	\N	2025-10-07 12:02:01	2025-10-07 12:02:01	1	4	\N	Shipping	\N
411	100	2025-10-07	شحن	0	100.00	\N	1	0	100	48	1	\N	2025-10-07 12:02:01	2025-10-07 12:02:01	1	4	\N	Shipping	\N
412	101	2025-10-07	شحن	330.00	0	\N	1	330	0	30	1	\N	2025-10-07 12:07:38	2025-10-07 12:07:38	1	5	\N	Shipping	\N
413	101	2025-10-07	شحن	0	330.00	\N	1	0	330	2572	1	\N	2025-10-07 12:07:38	2025-10-07 12:07:38	1	5	\N	Shipping	\N
414	101	2025-10-07	شحن	330.00	0	\N	1	330	0	2572	1	\N	2025-10-07 12:07:38	2025-10-07 12:07:38	1	5	\N	Shipping	\N
415	101	2025-10-07	شحن	0	330.00	\N	1	0	330	48	1	\N	2025-10-07 12:07:38	2025-10-07 12:07:38	1	5	\N	Shipping	\N
416	102	2025-10-07	شحن	320.00	0	\N	1	320	0	30	1	\N	2025-10-07 12:21:50	2025-10-07 12:21:50	1	6	\N	Shipping	\N
417	102	2025-10-07	شحن	0	320.00	\N	1	0	320	2586	1	\N	2025-10-07 12:21:50	2025-10-07 12:21:50	1	6	\N	Shipping	\N
418	102	2025-10-07	شحن	320.00	0	\N	1	320	0	2586	1	\N	2025-10-07 12:21:50	2025-10-07 12:21:50	1	6	\N	Shipping	\N
419	102	2025-10-07	شحن	0	320.00	\N	1	0	320	48	1	\N	2025-10-07 12:21:50	2025-10-07 12:21:50	1	6	\N	Shipping	\N
420	103	2025-10-07	شحن	507.00	0	\N	1	507	0	30	1	\N	2025-10-07 12:31:21	2025-10-07 12:31:21	1	7	\N	Shipping	\N
421	103	2025-10-07	شحن	0	507.00	\N	1	0	507	2522	1	\N	2025-10-07 12:31:21	2025-10-07 12:31:21	1	7	\N	Shipping	\N
422	103	2025-10-07	شحن	507.00	0	\N	1	507	0	2522	1	\N	2025-10-07 12:31:21	2025-10-07 12:31:21	1	7	\N	Shipping	\N
423	103	2025-10-07	شحن	0	507.00	\N	1	0	507	48	1	\N	2025-10-07 12:31:21	2025-10-07 12:31:21	1	7	\N	Shipping	\N
424	104	2025-10-07	شحن	215.00	0	\N	1	215	0	2586	1	\N	2025-10-07 12:34:39	2025-10-07 12:34:39	1	8	\N	Shipping	\N
425	104	2025-10-07	شحن	0	215.00	\N	1	0	215	48	1	\N	2025-10-07 12:34:39	2025-10-07 12:34:39	1	8	\N	Shipping	\N
426	105	2025-10-07	شحن	307.00	0	\N	1	307	0	32	1	\N	2025-10-07 12:37:58	2025-10-07 12:37:58	1	9	\N	Shipping	\N
427	105	2025-10-07	شحن	0	307.00	\N	1	0	307	2535	1	\N	2025-10-07 12:37:58	2025-10-07 12:37:58	1	9	\N	Shipping	\N
428	105	2025-10-07	شحن	307.00	0	\N	1	307	0	2535	1	\N	2025-10-07 12:37:58	2025-10-07 12:37:58	1	9	\N	Shipping	\N
429	105	2025-10-07	شحن	0	307.00	\N	1	0	307	48	1	\N	2025-10-07 12:37:58	2025-10-07 12:37:58	1	9	\N	Shipping	\N
430	106	2025-10-07	شحن	315.00	0	\N	1	315	0	30	1	\N	2025-10-07 12:40:08	2025-10-07 12:40:08	1	10	\N	Shipping	\N
431	106	2025-10-07	شحن	0	315.00	\N	1	0	315	2590	1	\N	2025-10-07 12:40:08	2025-10-07 12:40:08	1	10	\N	Shipping	\N
432	106	2025-10-07	شحن	315.00	0	\N	1	315	0	2590	1	\N	2025-10-07 12:40:08	2025-10-07 12:40:08	1	10	\N	Shipping	\N
433	106	2025-10-07	شحن	0	315.00	\N	1	0	315	48	1	\N	2025-10-07 12:40:08	2025-10-07 12:40:08	1	10	\N	Shipping	\N
434	107	2025-10-07	شحن	170.00	0	\N	1	170	0	2586	1	\N	2025-10-07 12:42:49	2025-10-07 12:42:49	1	11	\N	Shipping	\N
435	107	2025-10-07	شحن	0	170.00	\N	1	0	170	48	1	\N	2025-10-07 12:42:49	2025-10-07 12:42:49	1	11	\N	Shipping	\N
436	108	2025-10-07	شحن	120	0	\N	1	120	0	30	1	\N	2025-10-07 13:01:06	2025-10-07 13:01:06	1	12	\N	Shipping	\N
437	108	2025-10-07	شحن	0	120	\N	1	0	120	2535	1	\N	2025-10-07 13:01:06	2025-10-07 13:01:06	1	12	\N	Shipping	\N
438	108	2025-10-07	شحن	120	0	\N	1	120	0	2535	1	\N	2025-10-07 13:01:06	2025-10-07 13:01:06	1	12	\N	Shipping	\N
439	108	2025-10-07	شحن	0	0	\N	1	0	0	2590	1	\N	2025-10-07 13:01:06	2025-10-07 13:01:06	1	12	\N	Shipping	\N
440	108	2025-10-07	شحن	0	120.00	\N	1	0	120	48	1	\N	2025-10-07 13:01:06	2025-10-07 13:01:06	1	12	\N	Shipping	\N
441	109	2025-10-07	شحن	157.00	0	\N	1	157	0	2590	1	\N	2025-10-07 13:05:04	2025-10-07 13:05:04	1	13	\N	Shipping	\N
442	109	2025-10-07	شحن	0	157.00	\N	1	0	157	48	1	\N	2025-10-07 13:05:04	2025-10-07 13:05:04	1	13	\N	Shipping	\N
443	110	2025-10-07	شحن	130.00	0	\N	1	130	0	30	1	\N	2025-10-07 13:07:56	2025-10-07 13:07:56	1	14	\N	Shipping	\N
444	110	2025-10-07	شحن	0	130.00	\N	1	0	130	2535	1	\N	2025-10-07 13:07:56	2025-10-07 13:07:56	1	14	\N	Shipping	\N
445	110	2025-10-07	شحن	130.00	0	\N	1	130	0	2535	1	\N	2025-10-07 13:07:56	2025-10-07 13:07:56	1	14	\N	Shipping	\N
446	110	2025-10-07	شحن	0	130.00	\N	1	0	130	48	1	\N	2025-10-07 13:07:56	2025-10-07 13:07:56	1	14	\N	Shipping	\N
447	111	2025-10-07	شحن	200.00	0	\N	1	200	0	2572	1	\N	2025-10-07 13:11:05	2025-10-07 13:11:05	1	15	\N	Shipping	\N
448	111	2025-10-07	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-07 13:11:05	2025-10-07 13:11:05	1	15	\N	Shipping	\N
449	112	2025-10-07	شحن	130.00	0	\N	1	130	0	30	1	\N	2025-10-07 13:13:59	2025-10-07 13:13:59	1	16	\N	Shipping	\N
450	112	2025-10-07	شحن	0	130.00	\N	1	0	130	2535	1	\N	2025-10-07 13:13:59	2025-10-07 13:13:59	1	16	\N	Shipping	\N
451	112	2025-10-07	شحن	130.00	0	\N	1	130	0	2535	1	\N	2025-10-07 13:13:59	2025-10-07 13:13:59	1	16	\N	Shipping	\N
452	112	2025-10-07	شحن	0	130.00	\N	1	0	130	48	1	\N	2025-10-07 13:13:59	2025-10-07 13:13:59	1	16	\N	Shipping	\N
453	113	2025-10-07	شحن	130.00	0	\N	1	130	0	30	1	\N	2025-10-07 13:15:33	2025-10-07 13:15:33	1	17	\N	Shipping	\N
454	113	2025-10-07	شحن	0	130.00	\N	1	0	130	2535	1	\N	2025-10-07 13:15:33	2025-10-07 13:15:33	1	17	\N	Shipping	\N
455	113	2025-10-07	شحن	130.00	0	\N	1	130	0	2535	1	\N	2025-10-07 13:15:33	2025-10-07 13:15:33	1	17	\N	Shipping	\N
456	113	2025-10-07	شحن	0	130.00	\N	1	0	130	48	1	\N	2025-10-07 13:15:33	2025-10-07 13:15:33	1	17	\N	Shipping	\N
457	114	2025-10-07	المشتريات	40000	0	\N	1	40000	0	2500	1	\N	2025-10-07 14:05:55	2025-10-07 14:05:55	11	18	\N	Purchases	\N
458	114	2025-10-07	المشتريات	0	40000	\N	1	0	40000	2523	1	\N	2025-10-07 14:05:55	2025-10-07 14:05:55	11	18	\N	Purchases	\N
459	114	2025-10-07	المشتريات	40000	0	\N	1	40000	0	2523	1	\N	2025-10-07 14:05:55	2025-10-07 14:05:55	11	18	\N	Purchases	\N
460	114	2025-10-07	المشتريات	0	40000	\N	1	0	40000	30	1	\N	2025-10-07 14:05:55	2025-10-07 14:05:55	11	18	\N	Purchases	\N
461	118	2025-10-07	شحن	250.00	0	\N	1	250	0	30	1	\N	2025-10-07 14:53:15	2025-10-07 14:53:15	1	18	\N	Shipping	\N
462	118	2025-10-07	شحن	0	250.00	\N	1	0	250	2535	1	\N	2025-10-07 14:53:15	2025-10-07 14:53:15	1	18	\N	Shipping	\N
463	118	2025-10-07	شحن	250.00	0	\N	1	250	0	2535	1	\N	2025-10-07 14:53:15	2025-10-07 14:53:15	1	18	\N	Shipping	\N
464	118	2025-10-07	شحن	0	250.00	\N	1	0	250	48	1	\N	2025-10-07 14:53:15	2025-10-07 14:53:15	1	18	\N	Shipping	\N
465	119	2025-10-07	شحن	157.00	0	\N	1	157	0	2590	1	\N	2025-10-07 14:56:13	2025-10-07 14:56:13	1	19	\N	Shipping	\N
466	119	2025-10-07	شحن	0	157.00	\N	1	0	157	48	1	\N	2025-10-07 14:56:13	2025-10-07 14:56:13	1	19	\N	Shipping	\N
467	120	2025-10-07	شحن	220.00	0	\N	1	220	0	30	1	\N	2025-10-07 15:01:31	2025-10-07 15:01:31	1	20	\N	Shipping	\N
468	120	2025-10-07	شحن	0	220.00	\N	1	0	220	2572	1	\N	2025-10-07 15:01:31	2025-10-07 15:01:31	1	20	\N	Shipping	\N
469	120	2025-10-07	شحن	220.00	0	\N	1	220	0	2572	1	\N	2025-10-07 15:01:31	2025-10-07 15:01:31	1	20	\N	Shipping	\N
470	120	2025-10-07	شحن	0	220.00	\N	1	0	220	48	1	\N	2025-10-07 15:01:31	2025-10-07 15:01:31	1	20	\N	Shipping	\N
471	121	2025-10-07	شحن	160.00	0	\N	1	160	0	30	1	\N	2025-10-07 15:09:19	2025-10-07 15:09:19	1	21	\N	Shipping	\N
472	121	2025-10-07	شحن	0	160.00	\N	1	0	160	2535	1	\N	2025-10-07 15:09:19	2025-10-07 15:09:19	1	21	\N	Shipping	\N
473	121	2025-10-07	شحن	160.00	0	\N	1	160	0	2535	1	\N	2025-10-07 15:09:19	2025-10-07 15:09:19	1	21	\N	Shipping	\N
474	121	2025-10-07	شحن	0	160.00	\N	1	0	160	48	1	\N	2025-10-07 15:09:19	2025-10-07 15:09:19	1	21	\N	Shipping	\N
475	122	2025-10-07	شحن	237.00	0	\N	1	237	0	30	1	\N	2025-10-07 15:13:30	2025-10-07 15:13:30	1	22	\N	Shipping	\N
476	122	2025-10-07	شحن	0	237.00	\N	1	0	237	2535	1	\N	2025-10-07 15:13:30	2025-10-07 15:13:30	1	22	\N	Shipping	\N
477	122	2025-10-07	شحن	237.00	0	\N	1	237	0	2535	1	\N	2025-10-07 15:13:30	2025-10-07 15:13:30	1	22	\N	Shipping	\N
478	122	2025-10-07	شحن	0	237.00	\N	1	0	237	48	1	\N	2025-10-07 15:13:30	2025-10-07 15:13:30	1	22	\N	Shipping	\N
479	123	2025-10-07	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-07 15:43:53	2025-10-07 15:43:53	11	23	\N	Shipping	\N
480	123	2025-10-07	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-07 15:43:53	2025-10-07 15:43:53	11	23	\N	Shipping	\N
481	123	2025-10-07	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-07 15:43:53	2025-10-07 15:43:53	11	23	\N	Shipping	\N
482	123	2025-10-07	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-07 15:43:53	2025-10-07 15:43:53	11	23	\N	Shipping	\N
483	124	2025-10-07	المشتريات	20000	0	\N	1	20000	0	2500	1	\N	2025-10-07 17:22:07	2025-10-07 17:22:07	11	19	\N	Purchases	\N
484	124	2025-10-07	المشتريات	0	20000	\N	1	0	20000	2523	1	\N	2025-10-07 17:22:07	2025-10-07 17:22:07	11	19	\N	Purchases	\N
485	125	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 10:32:54	2025-10-08 10:32:54	1	24	\N	Shipping	\N
486	125	2025-10-08	شحن	0	200.00	\N	1	0	200	2535	1	\N	2025-10-08 10:32:54	2025-10-08 10:32:54	1	24	\N	Shipping	\N
487	125	2025-10-08	شحن	200.00	0	\N	1	200	0	2535	1	\N	2025-10-08 10:32:54	2025-10-08 10:32:54	1	24	\N	Shipping	\N
488	125	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 10:32:54	2025-10-08 10:32:54	1	24	\N	Shipping	\N
489	128	2025-10-08	المشتريات	200	0	\N	1	200	0	2500	1	\N	2025-10-08 13:09:56	2025-10-08 13:09:56	1	20	\N	Purchases	\N
490	128	2025-10-08	المشتريات	0	200	\N	1	0	200	2523	1	\N	2025-10-08 13:09:56	2025-10-08 13:09:56	1	20	\N	Purchases	\N
491	129	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 13:50:50	2025-10-08 13:50:50	11	25	\N	Shipping	\N
492	129	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 13:50:50	2025-10-08 13:50:50	11	25	\N	Shipping	\N
493	129	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 13:50:50	2025-10-08 13:50:50	11	25	\N	Shipping	\N
494	129	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 13:50:50	2025-10-08 13:50:50	11	25	\N	Shipping	\N
495	130	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 14:04:50	2025-10-08 14:04:50	11	1	\N	Shipping Distrbution	\N
496	130	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 14:04:50	2025-10-08 14:04:50	11	1	\N	Shipping Distrbution	\N
497	130	2025-10-08	توزيع شحنات	20	0	\N	1	20	0	2534	1	\N	2025-10-08 14:04:50	2025-10-08 14:04:50	11	1	\N	Shipping Distrbution	\N
498	131	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 14:08:41	2025-10-08 14:08:41	11	26	\N	Shipping	\N
499	131	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 14:08:41	2025-10-08 14:08:41	11	26	\N	Shipping	\N
500	131	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 14:08:41	2025-10-08 14:08:41	11	26	\N	Shipping	\N
501	131	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 14:08:41	2025-10-08 14:08:41	11	26	\N	Shipping	\N
502	132	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2684	1	\N	2025-10-08 14:09:22	2025-10-08 14:09:22	11	9	\N	Shipping Distrbution	\N
503	132	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2692	1	\N	2025-10-08 14:09:22	2025-10-08 14:09:22	11	9	\N	Shipping Distrbution	\N
504	132	2025-10-08	توزيع شحنات	20	0	\N	1	20	0	2534	1	\N	2025-10-08 14:09:22	2025-10-08 14:09:22	11	9	\N	Shipping Distrbution	\N
505	133	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 14:12:25	2025-10-08 14:12:25	11	27	\N	Shipping	\N
506	133	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 14:12:25	2025-10-08 14:12:25	11	27	\N	Shipping	\N
507	133	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 14:12:25	2025-10-08 14:12:25	11	27	\N	Shipping	\N
508	133	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 14:12:25	2025-10-08 14:12:25	11	27	\N	Shipping	\N
509	134	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 14:13:08	2025-10-08 14:13:08	11	10	\N	Shipping Distrbution	\N
510	134	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 14:13:08	2025-10-08 14:13:08	11	10	\N	Shipping Distrbution	\N
511	134	2025-10-08	توزيع شحنات	60	0	\N	1	60	0	2534	1	\N	2025-10-08 14:13:08	2025-10-08 14:13:08	11	10	\N	Shipping Distrbution	\N
512	135	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 14:15:00	2025-10-08 14:15:00	11	28	\N	Shipping	\N
513	135	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 14:15:00	2025-10-08 14:15:00	11	28	\N	Shipping	\N
514	135	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 14:15:00	2025-10-08 14:15:00	11	28	\N	Shipping	\N
515	135	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 14:15:00	2025-10-08 14:15:00	11	28	\N	Shipping	\N
516	136	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 14:17:32	2025-10-08 14:17:32	11	11	\N	Shipping Distrbution	\N
517	136	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 14:17:32	2025-10-08 14:17:32	11	11	\N	Shipping Distrbution	\N
518	136	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2696	1	\N	2025-10-08 14:17:32	2025-10-08 14:17:32	11	11	\N	Shipping Distrbution	\N
519	136	2025-10-08	توزيع شحنات	30	0	\N	1	30	0	2534	1	\N	2025-10-08 14:17:32	2025-10-08 14:17:32	11	11	\N	Shipping Distrbution	\N
520	137	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 14:31:55	2025-10-08 14:31:55	1	29	\N	Shipping	\N
521	137	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 14:31:55	2025-10-08 14:31:55	1	29	\N	Shipping	\N
522	137	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 14:31:55	2025-10-08 14:31:55	1	29	\N	Shipping	\N
523	137	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 14:31:55	2025-10-08 14:31:55	1	29	\N	Shipping	\N
524	138	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 14:32:45	2025-10-08 14:32:45	1	12	\N	Shipping Distrbution	\N
525	138	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 14:32:45	2025-10-08 14:32:45	1	12	\N	Shipping Distrbution	\N
526	138	2025-10-08	توزيع شحنات	40	0	\N	1	40	0	2534	1	\N	2025-10-08 14:32:45	2025-10-08 14:32:45	1	12	\N	Shipping Distrbution	\N
527	139	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 14:34:25	2025-10-08 14:34:25	1	30	\N	Shipping	\N
528	139	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 14:34:25	2025-10-08 14:34:25	1	30	\N	Shipping	\N
529	139	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 14:34:25	2025-10-08 14:34:25	1	30	\N	Shipping	\N
530	139	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 14:34:25	2025-10-08 14:34:25	1	30	\N	Shipping	\N
531	140	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 14:34:54	2025-10-08 14:34:54	1	13	\N	Shipping Distrbution	\N
532	140	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 14:34:54	2025-10-08 14:34:54	1	13	\N	Shipping Distrbution	\N
533	140	2025-10-08	توزيع شحنات	40	0	\N	1	40	0	2534	1	\N	2025-10-08 14:34:54	2025-10-08 14:34:54	1	13	\N	Shipping Distrbution	\N
534	141	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 14:36:09	2025-10-08 14:36:09	1	31	\N	Shipping	\N
535	141	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 14:36:09	2025-10-08 14:36:09	1	31	\N	Shipping	\N
536	141	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 14:36:09	2025-10-08 14:36:09	1	31	\N	Shipping	\N
537	141	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 14:36:09	2025-10-08 14:36:09	1	31	\N	Shipping	\N
538	142	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 14:36:46	2025-10-08 14:36:46	1	14	\N	Shipping Distrbution	\N
539	142	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 14:36:46	2025-10-08 14:36:46	1	14	\N	Shipping Distrbution	\N
540	142	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2700	1	\N	2025-10-08 14:36:46	2025-10-08 14:36:46	1	14	\N	Shipping Distrbution	\N
541	142	2025-10-08	توزيع شحنات	90	0	\N	1	90	0	2534	1	\N	2025-10-08 14:36:46	2025-10-08 14:36:46	1	14	\N	Shipping Distrbution	\N
542	143	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 14:38:34	2025-10-08 14:38:34	1	32	\N	Shipping	\N
543	143	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 14:38:34	2025-10-08 14:38:34	1	32	\N	Shipping	\N
544	143	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 14:38:34	2025-10-08 14:38:34	1	32	\N	Shipping	\N
545	143	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 14:38:34	2025-10-08 14:38:34	1	32	\N	Shipping	\N
546	144	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 14:40:25	2025-10-08 14:40:25	1	15	\N	Shipping Distrbution	\N
547	144	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 14:40:25	2025-10-08 14:40:25	1	15	\N	Shipping Distrbution	\N
548	144	2025-10-08	توزيع شحنات	20	0	\N	1	20	0	2534	1	\N	2025-10-08 14:40:25	2025-10-08 14:40:25	1	15	\N	Shipping Distrbution	\N
549	145	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 14:42:02	2025-10-08 14:42:02	1	33	\N	Shipping	\N
550	145	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 14:42:02	2025-10-08 14:42:02	1	33	\N	Shipping	\N
551	145	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 14:42:02	2025-10-08 14:42:02	1	33	\N	Shipping	\N
552	145	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 14:42:02	2025-10-08 14:42:02	1	33	\N	Shipping	\N
553	146	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 14:42:28	2025-10-08 14:42:28	1	16	\N	Shipping Distrbution	\N
554	146	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 14:42:28	2025-10-08 14:42:28	1	16	\N	Shipping Distrbution	\N
555	146	2025-10-08	توزيع شحنات	60	0	\N	1	60	0	2534	1	\N	2025-10-08 14:42:28	2025-10-08 14:42:28	1	16	\N	Shipping Distrbution	\N
556	147	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 14:44:21	2025-10-08 14:44:21	1	34	\N	Shipping	\N
557	147	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 14:44:21	2025-10-08 14:44:21	1	34	\N	Shipping	\N
558	147	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 14:44:21	2025-10-08 14:44:21	1	34	\N	Shipping	\N
559	147	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 14:44:21	2025-10-08 14:44:21	1	34	\N	Shipping	\N
560	148	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 14:45:01	2025-10-08 14:45:01	1	17	\N	Shipping Distrbution	\N
561	148	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 14:45:01	2025-10-08 14:45:01	1	17	\N	Shipping Distrbution	\N
562	148	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2696	1	\N	2025-10-08 14:45:01	2025-10-08 14:45:01	1	17	\N	Shipping Distrbution	\N
563	148	2025-10-08	توزيع شحنات	30	0	\N	1	30	0	2534	1	\N	2025-10-08 14:45:01	2025-10-08 14:45:01	1	17	\N	Shipping Distrbution	\N
564	149	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 14:46:35	2025-10-08 14:46:35	1	35	\N	Shipping	\N
565	149	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 14:46:35	2025-10-08 14:46:35	1	35	\N	Shipping	\N
566	149	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 14:46:35	2025-10-08 14:46:35	1	35	\N	Shipping	\N
567	149	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 14:46:35	2025-10-08 14:46:35	1	35	\N	Shipping	\N
568	150	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 14:56:31	2025-10-08 14:56:31	1	18	\N	Shipping Distrbution	\N
569	150	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 14:56:31	2025-10-08 14:56:31	1	18	\N	Shipping Distrbution	\N
570	150	2025-10-08	توزيع شحنات	40	0	\N	1	40	0	2534	1	\N	2025-10-08 14:56:31	2025-10-08 14:56:31	1	18	\N	Shipping Distrbution	\N
571	151	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 14:58:00	2025-10-08 14:58:00	1	36	\N	Shipping	\N
572	151	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 14:58:00	2025-10-08 14:58:00	1	36	\N	Shipping	\N
573	151	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 14:58:00	2025-10-08 14:58:00	1	36	\N	Shipping	\N
574	151	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 14:58:00	2025-10-08 14:58:00	1	36	\N	Shipping	\N
575	152	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 14:59:00	2025-10-08 14:59:00	1	19	\N	Shipping Distrbution	\N
576	152	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 14:59:00	2025-10-08 14:59:00	1	19	\N	Shipping Distrbution	\N
577	152	2025-10-08	توزيع شحنات	40	0	\N	1	40	0	2534	1	\N	2025-10-08 14:59:00	2025-10-08 14:59:00	1	19	\N	Shipping Distrbution	\N
578	153	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:00:39	2025-10-08 15:00:39	1	37	\N	Shipping	\N
579	153	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:00:39	2025-10-08 15:00:39	1	37	\N	Shipping	\N
580	153	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:00:39	2025-10-08 15:00:39	1	37	\N	Shipping	\N
581	153	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:00:39	2025-10-08 15:00:39	1	37	\N	Shipping	\N
582	154	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 15:01:06	2025-10-08 15:01:06	1	20	\N	Shipping Distrbution	\N
583	154	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 15:01:06	2025-10-08 15:01:06	1	20	\N	Shipping Distrbution	\N
584	154	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2700	1	\N	2025-10-08 15:01:06	2025-10-08 15:01:06	1	20	\N	Shipping Distrbution	\N
585	154	2025-10-08	توزيع شحنات	90	0	\N	1	90	0	2534	1	\N	2025-10-08 15:01:06	2025-10-08 15:01:06	1	20	\N	Shipping Distrbution	\N
586	155	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:02:34	2025-10-08 15:02:34	1	38	\N	Shipping	\N
587	155	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:02:34	2025-10-08 15:02:34	1	38	\N	Shipping	\N
588	155	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:02:34	2025-10-08 15:02:34	1	38	\N	Shipping	\N
589	155	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:02:34	2025-10-08 15:02:34	1	38	\N	Shipping	\N
590	156	2025-10-08	توزيع شحنات	0	1000	\N	1	0	1000	2706	1	\N	2025-10-08 15:03:06	2025-10-08 15:03:06	1	21	\N	Shipping Distrbution	\N
591	156	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 15:03:06	2025-10-08 15:03:06	1	21	\N	Shipping Distrbution	\N
592	156	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 15:03:06	2025-10-08 15:03:06	1	21	\N	Shipping Distrbution	\N
593	156	2025-10-08	توزيع شحنات	1020	0	\N	1	1020	0	2534	1	\N	2025-10-08 15:03:06	2025-10-08 15:03:06	1	21	\N	Shipping Distrbution	\N
594	157	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:04:53	2025-10-08 15:04:53	1	39	\N	Shipping	\N
595	157	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:04:53	2025-10-08 15:04:53	1	39	\N	Shipping	\N
596	157	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:04:53	2025-10-08 15:04:53	1	39	\N	Shipping	\N
597	157	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:04:53	2025-10-08 15:04:53	1	39	\N	Shipping	\N
598	158	2025-10-08	توزيع شحنات	0	1000	\N	1	0	1000	2706	1	\N	2025-10-08 15:05:18	2025-10-08 15:05:18	1	22	\N	Shipping Distrbution	\N
599	158	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 15:05:18	2025-10-08 15:05:18	1	22	\N	Shipping Distrbution	\N
600	158	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 15:05:18	2025-10-08 15:05:18	1	22	\N	Shipping Distrbution	\N
601	158	2025-10-08	توزيع شحنات	1060	0	\N	1	1060	0	2534	1	\N	2025-10-08 15:05:18	2025-10-08 15:05:18	1	22	\N	Shipping Distrbution	\N
602	159	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:06:40	2025-10-08 15:06:40	1	40	\N	Shipping	\N
603	159	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:06:40	2025-10-08 15:06:40	1	40	\N	Shipping	\N
604	159	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:06:40	2025-10-08 15:06:40	1	40	\N	Shipping	\N
605	159	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:06:40	2025-10-08 15:06:40	1	40	\N	Shipping	\N
606	160	2025-10-08	توزيع شحنات	0	1000	\N	1	0	1000	2706	1	\N	2025-10-08 15:07:11	2025-10-08 15:07:11	1	23	\N	Shipping Distrbution	\N
607	160	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 15:07:11	2025-10-08 15:07:11	1	23	\N	Shipping Distrbution	\N
608	160	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 15:07:11	2025-10-08 15:07:11	1	23	\N	Shipping Distrbution	\N
609	160	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2696	1	\N	2025-10-08 15:07:11	2025-10-08 15:07:11	1	23	\N	Shipping Distrbution	\N
610	160	2025-10-08	توزيع شحنات	1030	0	\N	1	1030	0	2534	1	\N	2025-10-08 15:07:11	2025-10-08 15:07:11	1	23	\N	Shipping Distrbution	\N
611	161	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:08:21	2025-10-08 15:08:21	1	41	\N	Shipping	\N
612	161	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:08:21	2025-10-08 15:08:21	1	41	\N	Shipping	\N
613	161	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:08:21	2025-10-08 15:08:21	1	41	\N	Shipping	\N
614	161	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:08:21	2025-10-08 15:08:21	1	41	\N	Shipping	\N
615	162	2025-10-08	توزيع شحنات	0	1000	\N	1	0	1000	2706	1	\N	2025-10-08 15:08:45	2025-10-08 15:08:45	1	24	\N	Shipping Distrbution	\N
616	162	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 15:08:45	2025-10-08 15:08:45	1	24	\N	Shipping Distrbution	\N
617	162	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 15:08:45	2025-10-08 15:08:45	1	24	\N	Shipping Distrbution	\N
618	162	2025-10-08	توزيع شحنات	1040	0	\N	1	1040	0	2534	1	\N	2025-10-08 15:08:45	2025-10-08 15:08:45	1	24	\N	Shipping Distrbution	\N
619	163	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:09:45	2025-10-08 15:09:45	1	42	\N	Shipping	\N
620	163	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:09:45	2025-10-08 15:09:45	1	42	\N	Shipping	\N
621	163	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:09:45	2025-10-08 15:09:45	1	42	\N	Shipping	\N
622	163	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:09:45	2025-10-08 15:09:45	1	42	\N	Shipping	\N
623	164	2025-10-08	توزيع شحنات	0	1000	\N	1	0	1000	2706	1	\N	2025-10-08 15:10:17	2025-10-08 15:10:17	1	25	\N	Shipping Distrbution	\N
624	164	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 15:10:17	2025-10-08 15:10:17	1	25	\N	Shipping Distrbution	\N
625	164	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 15:10:17	2025-10-08 15:10:17	1	25	\N	Shipping Distrbution	\N
626	164	2025-10-08	توزيع شحنات	1060	0	\N	1	1060	0	2534	1	\N	2025-10-08 15:10:17	2025-10-08 15:10:17	1	25	\N	Shipping Distrbution	\N
627	165	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:11:21	2025-10-08 15:11:21	1	43	\N	Shipping	\N
628	165	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:11:21	2025-10-08 15:11:21	1	43	\N	Shipping	\N
629	165	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:11:21	2025-10-08 15:11:21	1	43	\N	Shipping	\N
630	165	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:11:21	2025-10-08 15:11:21	1	43	\N	Shipping	\N
631	166	2025-10-08	توزيع شحنات	0	1000	\N	1	0	1000	2706	1	\N	2025-10-08 15:11:46	2025-10-08 15:11:46	1	26	\N	Shipping Distrbution	\N
632	166	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 15:11:46	2025-10-08 15:11:46	1	26	\N	Shipping Distrbution	\N
633	166	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 15:11:46	2025-10-08 15:11:46	1	26	\N	Shipping Distrbution	\N
634	166	2025-10-08	توزيع شحنات	1040	0	\N	1	1040	0	2534	1	\N	2025-10-08 15:11:46	2025-10-08 15:11:46	1	26	\N	Shipping Distrbution	\N
635	167	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:12:47	2025-10-08 15:12:47	1	44	\N	Shipping	\N
636	167	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:12:47	2025-10-08 15:12:47	1	44	\N	Shipping	\N
637	167	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:12:47	2025-10-08 15:12:47	1	44	\N	Shipping	\N
638	167	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:12:47	2025-10-08 15:12:47	1	44	\N	Shipping	\N
639	168	2025-10-08	توزيع شحنات	0	1000	\N	1	0	1000	2706	1	\N	2025-10-08 15:13:12	2025-10-08 15:13:12	1	27	\N	Shipping Distrbution	\N
640	168	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 15:13:12	2025-10-08 15:13:12	1	27	\N	Shipping Distrbution	\N
641	168	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 15:13:12	2025-10-08 15:13:12	1	27	\N	Shipping Distrbution	\N
642	168	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2700	1	\N	2025-10-08 15:13:12	2025-10-08 15:13:12	1	27	\N	Shipping Distrbution	\N
643	168	2025-10-08	توزيع شحنات	1090	0	\N	1	1090	0	2534	1	\N	2025-10-08 15:13:12	2025-10-08 15:13:12	1	27	\N	Shipping Distrbution	\N
644	169	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:14:49	2025-10-08 15:14:49	1	45	\N	Shipping	\N
645	169	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:14:49	2025-10-08 15:14:49	1	45	\N	Shipping	\N
646	169	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:14:49	2025-10-08 15:14:49	1	45	\N	Shipping	\N
647	169	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:14:49	2025-10-08 15:14:49	1	45	\N	Shipping	\N
648	170	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2708	1	\N	2025-10-08 15:15:10	2025-10-08 15:15:10	1	28	\N	Shipping Distrbution	\N
649	170	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 15:15:10	2025-10-08 15:15:10	1	28	\N	Shipping Distrbution	\N
650	170	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 15:15:10	2025-10-08 15:15:10	1	28	\N	Shipping Distrbution	\N
651	170	2025-10-08	توزيع شحنات	30	0	\N	1	30	0	2534	1	\N	2025-10-08 15:15:10	2025-10-08 15:15:10	1	28	\N	Shipping Distrbution	\N
652	171	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:27:44	2025-10-08 15:27:44	1	46	\N	Shipping	\N
653	171	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:27:44	2025-10-08 15:27:44	1	46	\N	Shipping	\N
654	171	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:27:44	2025-10-08 15:27:44	1	46	\N	Shipping	\N
655	171	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:27:44	2025-10-08 15:27:44	1	46	\N	Shipping	\N
656	172	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2708	1	\N	2025-10-08 15:28:07	2025-10-08 15:28:07	1	29	\N	Shipping Distrbution	\N
657	172	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 15:28:07	2025-10-08 15:28:07	1	29	\N	Shipping Distrbution	\N
658	172	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 15:28:07	2025-10-08 15:28:07	1	29	\N	Shipping Distrbution	\N
659	172	2025-10-08	توزيع شحنات	70	0	\N	1	70	0	2534	1	\N	2025-10-08 15:28:07	2025-10-08 15:28:07	1	29	\N	Shipping Distrbution	\N
660	173	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:29:33	2025-10-08 15:29:33	1	47	\N	Shipping	\N
661	173	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:29:33	2025-10-08 15:29:33	1	47	\N	Shipping	\N
662	173	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:29:33	2025-10-08 15:29:33	1	47	\N	Shipping	\N
663	173	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:29:33	2025-10-08 15:29:33	1	47	\N	Shipping	\N
664	174	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2708	1	\N	2025-10-08 15:30:02	2025-10-08 15:30:02	1	30	\N	Shipping Distrbution	\N
665	174	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 15:30:02	2025-10-08 15:30:02	1	30	\N	Shipping Distrbution	\N
666	174	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 15:30:02	2025-10-08 15:30:02	1	30	\N	Shipping Distrbution	\N
667	174	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2696	1	\N	2025-10-08 15:30:02	2025-10-08 15:30:02	1	30	\N	Shipping Distrbution	\N
668	174	2025-10-08	توزيع شحنات	40	0	\N	1	40	0	2534	1	\N	2025-10-08 15:30:02	2025-10-08 15:30:02	1	30	\N	Shipping Distrbution	\N
669	175	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:31:40	2025-10-08 15:31:40	1	48	\N	Shipping	\N
670	175	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:31:40	2025-10-08 15:31:40	1	48	\N	Shipping	\N
671	175	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:31:40	2025-10-08 15:31:40	1	48	\N	Shipping	\N
672	175	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:31:40	2025-10-08 15:31:40	1	48	\N	Shipping	\N
673	176	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2708	1	\N	2025-10-08 15:32:08	2025-10-08 15:32:08	1	31	\N	Shipping Distrbution	\N
674	176	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 15:32:08	2025-10-08 15:32:08	1	31	\N	Shipping Distrbution	\N
675	176	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 15:32:08	2025-10-08 15:32:08	1	31	\N	Shipping Distrbution	\N
676	176	2025-10-08	توزيع شحنات	50	0	\N	1	50	0	2534	1	\N	2025-10-08 15:32:08	2025-10-08 15:32:08	1	31	\N	Shipping Distrbution	\N
677	177	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:33:51	2025-10-08 15:33:51	1	49	\N	Shipping	\N
678	177	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:33:51	2025-10-08 15:33:51	1	49	\N	Shipping	\N
679	177	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:33:51	2025-10-08 15:33:51	1	49	\N	Shipping	\N
680	177	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:33:51	2025-10-08 15:33:51	1	49	\N	Shipping	\N
681	178	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2708	1	\N	2025-10-08 15:34:18	2025-10-08 15:34:18	1	32	\N	Shipping Distrbution	\N
682	178	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 15:34:18	2025-10-08 15:34:18	1	32	\N	Shipping Distrbution	\N
683	178	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 15:34:18	2025-10-08 15:34:18	1	32	\N	Shipping Distrbution	\N
684	178	2025-10-08	توزيع شحنات	50	0	\N	1	50	0	2534	1	\N	2025-10-08 15:34:18	2025-10-08 15:34:18	1	32	\N	Shipping Distrbution	\N
685	179	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:37:08	2025-10-08 15:37:08	1	50	\N	Shipping	\N
686	179	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:37:08	2025-10-08 15:37:08	1	50	\N	Shipping	\N
687	179	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:37:08	2025-10-08 15:37:08	1	50	\N	Shipping	\N
688	179	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:37:08	2025-10-08 15:37:08	1	50	\N	Shipping	\N
689	180	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2708	1	\N	2025-10-08 15:37:48	2025-10-08 15:37:48	1	33	\N	Shipping Distrbution	\N
690	180	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 15:37:48	2025-10-08 15:37:48	1	33	\N	Shipping Distrbution	\N
691	180	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 15:37:48	2025-10-08 15:37:48	1	33	\N	Shipping Distrbution	\N
692	180	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2700	1	\N	2025-10-08 15:37:48	2025-10-08 15:37:48	1	33	\N	Shipping Distrbution	\N
693	180	2025-10-08	توزيع شحنات	100	0	\N	1	100	0	2534	1	\N	2025-10-08 15:37:48	2025-10-08 15:37:48	1	33	\N	Shipping Distrbution	\N
694	181	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:45:45	2025-10-08 15:45:45	1	51	\N	Shipping	\N
695	181	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:45:45	2025-10-08 15:45:45	1	51	\N	Shipping	\N
696	181	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:45:45	2025-10-08 15:45:45	1	51	\N	Shipping	\N
697	181	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:45:45	2025-10-08 15:45:45	1	51	\N	Shipping	\N
698	182	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 15:47:14	2025-10-08 15:47:14	1	34	\N	Shipping Distrbution	\N
699	182	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 15:47:14	2025-10-08 15:47:14	1	34	\N	Shipping Distrbution	\N
700	182	2025-10-08	توزيع شحنات	20	0	\N	1	20	0	2534	1	\N	2025-10-08 15:47:14	2025-10-08 15:47:14	1	34	\N	Shipping Distrbution	\N
701	183	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:48:22	2025-10-08 15:48:22	1	52	\N	Shipping	\N
702	183	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:48:22	2025-10-08 15:48:22	1	52	\N	Shipping	\N
703	183	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:48:22	2025-10-08 15:48:22	1	52	\N	Shipping	\N
704	183	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:48:22	2025-10-08 15:48:22	1	52	\N	Shipping	\N
705	184	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 15:48:48	2025-10-08 15:48:48	1	35	\N	Shipping Distrbution	\N
706	184	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 15:48:48	2025-10-08 15:48:48	1	35	\N	Shipping Distrbution	\N
707	184	2025-10-08	توزيع شحنات	60	0	\N	1	60	0	2534	1	\N	2025-10-08 15:48:48	2025-10-08 15:48:48	1	35	\N	Shipping Distrbution	\N
708	185	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:50:10	2025-10-08 15:50:10	1	53	\N	Shipping	\N
709	185	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:50:10	2025-10-08 15:50:10	1	53	\N	Shipping	\N
710	185	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:50:10	2025-10-08 15:50:10	1	53	\N	Shipping	\N
711	185	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:50:10	2025-10-08 15:50:10	1	53	\N	Shipping	\N
712	186	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 15:50:53	2025-10-08 15:50:53	1	36	\N	Shipping Distrbution	\N
713	186	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 15:50:53	2025-10-08 15:50:53	1	36	\N	Shipping Distrbution	\N
714	186	2025-10-08	توزيع شحنات	20	0	\N	1	20	0	2534	1	\N	2025-10-08 15:50:53	2025-10-08 15:50:53	1	36	\N	Shipping Distrbution	\N
715	187	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:51:43	2025-10-08 15:51:43	1	54	\N	Shipping	\N
716	187	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:51:43	2025-10-08 15:51:43	1	54	\N	Shipping	\N
717	187	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:51:43	2025-10-08 15:51:43	1	54	\N	Shipping	\N
718	187	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:51:43	2025-10-08 15:51:43	1	54	\N	Shipping	\N
719	188	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 15:52:25	2025-10-08 15:52:25	1	37	\N	Shipping Distrbution	\N
720	188	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 15:52:25	2025-10-08 15:52:25	1	37	\N	Shipping Distrbution	\N
721	188	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2696	1	\N	2025-10-08 15:52:25	2025-10-08 15:52:25	1	37	\N	Shipping Distrbution	\N
722	188	2025-10-08	توزيع شحنات	30	0	\N	1	30	0	2534	1	\N	2025-10-08 15:52:25	2025-10-08 15:52:25	1	37	\N	Shipping Distrbution	\N
723	189	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:53:38	2025-10-08 15:53:38	1	55	\N	Shipping	\N
724	189	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:53:38	2025-10-08 15:53:38	1	55	\N	Shipping	\N
725	189	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:53:38	2025-10-08 15:53:38	1	55	\N	Shipping	\N
726	189	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:53:38	2025-10-08 15:53:38	1	55	\N	Shipping	\N
727	190	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 15:54:06	2025-10-08 15:54:06	1	38	\N	Shipping Distrbution	\N
728	190	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 15:54:06	2025-10-08 15:54:06	1	38	\N	Shipping Distrbution	\N
729	190	2025-10-08	توزيع شحنات	40	0	\N	1	40	0	2534	1	\N	2025-10-08 15:54:06	2025-10-08 15:54:06	1	38	\N	Shipping Distrbution	\N
730	191	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:55:08	2025-10-08 15:55:08	1	56	\N	Shipping	\N
731	191	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:55:08	2025-10-08 15:55:08	1	56	\N	Shipping	\N
732	191	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:55:08	2025-10-08 15:55:08	1	56	\N	Shipping	\N
733	191	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:55:08	2025-10-08 15:55:08	1	56	\N	Shipping	\N
734	192	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 15:55:32	2025-10-08 15:55:32	1	39	\N	Shipping Distrbution	\N
735	192	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 15:55:32	2025-10-08 15:55:32	1	39	\N	Shipping Distrbution	\N
736	192	2025-10-08	توزيع شحنات	40	0	\N	1	40	0	2534	1	\N	2025-10-08 15:55:32	2025-10-08 15:55:32	1	39	\N	Shipping Distrbution	\N
737	193	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 15:57:56	2025-10-08 15:57:56	1	57	\N	Shipping	\N
738	193	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 15:57:56	2025-10-08 15:57:56	1	57	\N	Shipping	\N
739	193	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 15:57:56	2025-10-08 15:57:56	1	57	\N	Shipping	\N
740	193	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 15:57:56	2025-10-08 15:57:56	1	57	\N	Shipping	\N
741	194	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 15:58:30	2025-10-08 15:58:30	1	40	\N	Shipping Distrbution	\N
742	194	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 15:58:30	2025-10-08 15:58:30	1	40	\N	Shipping Distrbution	\N
743	194	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2700	1	\N	2025-10-08 15:58:30	2025-10-08 15:58:30	1	40	\N	Shipping Distrbution	\N
744	194	2025-10-08	توزيع شحنات	90	0	\N	1	90	0	2534	1	\N	2025-10-08 15:58:30	2025-10-08 15:58:30	1	40	\N	Shipping Distrbution	\N
745	195	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 16:00:21	2025-10-08 16:00:21	1	58	\N	Shipping	\N
746	195	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 16:00:21	2025-10-08 16:00:21	1	58	\N	Shipping	\N
747	195	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 16:00:21	2025-10-08 16:00:21	1	58	\N	Shipping	\N
748	195	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 16:00:21	2025-10-08 16:00:21	1	58	\N	Shipping	\N
749	196	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 16:01:02	2025-10-08 16:01:02	1	41	\N	Shipping Distrbution	\N
750	196	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 16:01:02	2025-10-08 16:01:02	1	41	\N	Shipping Distrbution	\N
751	196	2025-10-08	توزيع شحنات	20	0	\N	1	20	0	2534	1	\N	2025-10-08 16:01:02	2025-10-08 16:01:02	1	41	\N	Shipping Distrbution	\N
752	197	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 16:19:33	2025-10-08 16:19:33	1	59	\N	Shipping	\N
753	197	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 16:19:33	2025-10-08 16:19:33	1	59	\N	Shipping	\N
754	197	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 16:19:33	2025-10-08 16:19:33	1	59	\N	Shipping	\N
755	197	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 16:19:33	2025-10-08 16:19:33	1	59	\N	Shipping	\N
756	198	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 16:20:04	2025-10-08 16:20:04	1	42	\N	Shipping Distrbution	\N
757	198	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 16:20:04	2025-10-08 16:20:04	1	42	\N	Shipping Distrbution	\N
758	198	2025-10-08	توزيع شحنات	60	0	\N	1	60	0	2534	1	\N	2025-10-08 16:20:04	2025-10-08 16:20:04	1	42	\N	Shipping Distrbution	\N
759	199	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 16:21:05	2025-10-08 16:21:05	1	60	\N	Shipping	\N
760	199	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 16:21:05	2025-10-08 16:21:05	1	60	\N	Shipping	\N
761	199	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 16:21:05	2025-10-08 16:21:05	1	60	\N	Shipping	\N
762	199	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 16:21:05	2025-10-08 16:21:05	1	60	\N	Shipping	\N
763	200	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 16:21:26	2025-10-08 16:21:26	1	43	\N	Shipping Distrbution	\N
764	200	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 16:21:26	2025-10-08 16:21:26	1	43	\N	Shipping Distrbution	\N
765	200	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2696	1	\N	2025-10-08 16:21:26	2025-10-08 16:21:26	1	43	\N	Shipping Distrbution	\N
766	200	2025-10-08	توزيع شحنات	30	0	\N	1	30	0	2534	1	\N	2025-10-08 16:21:26	2025-10-08 16:21:26	1	43	\N	Shipping Distrbution	\N
767	201	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 16:22:07	2025-10-08 16:22:07	1	61	\N	Shipping	\N
768	201	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 16:22:07	2025-10-08 16:22:07	1	61	\N	Shipping	\N
769	201	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 16:22:07	2025-10-08 16:22:07	1	61	\N	Shipping	\N
770	201	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 16:22:07	2025-10-08 16:22:07	1	61	\N	Shipping	\N
771	202	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 16:22:29	2025-10-08 16:22:29	1	44	\N	Shipping Distrbution	\N
772	202	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 16:22:29	2025-10-08 16:22:29	1	44	\N	Shipping Distrbution	\N
773	202	2025-10-08	توزيع شحنات	40	0	\N	1	40	0	2534	1	\N	2025-10-08 16:22:29	2025-10-08 16:22:29	1	44	\N	Shipping Distrbution	\N
774	203	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 16:23:09	2025-10-08 16:23:09	1	62	\N	Shipping	\N
775	203	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 16:23:09	2025-10-08 16:23:09	1	62	\N	Shipping	\N
776	203	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 16:23:09	2025-10-08 16:23:09	1	62	\N	Shipping	\N
777	203	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 16:23:09	2025-10-08 16:23:09	1	62	\N	Shipping	\N
778	204	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 16:23:40	2025-10-08 16:23:40	1	45	\N	Shipping Distrbution	\N
779	204	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 16:23:40	2025-10-08 16:23:40	1	45	\N	Shipping Distrbution	\N
780	204	2025-10-08	توزيع شحنات	40	0	\N	1	40	0	2534	1	\N	2025-10-08 16:23:40	2025-10-08 16:23:40	1	45	\N	Shipping Distrbution	\N
781	205	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 16:24:25	2025-10-08 16:24:25	1	63	\N	Shipping	\N
782	205	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 16:24:25	2025-10-08 16:24:25	1	63	\N	Shipping	\N
783	205	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 16:24:25	2025-10-08 16:24:25	1	63	\N	Shipping	\N
784	205	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 16:24:25	2025-10-08 16:24:25	1	63	\N	Shipping	\N
785	206	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 16:24:59	2025-10-08 16:24:59	1	46	\N	Shipping Distrbution	\N
786	206	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 16:24:59	2025-10-08 16:24:59	1	46	\N	Shipping Distrbution	\N
787	206	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2700	1	\N	2025-10-08 16:24:59	2025-10-08 16:24:59	1	46	\N	Shipping Distrbution	\N
788	206	2025-10-08	توزيع شحنات	90	0	\N	1	90	0	2534	1	\N	2025-10-08 16:24:59	2025-10-08 16:24:59	1	46	\N	Shipping Distrbution	\N
789	207	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 16:27:30	2025-10-08 16:27:30	1	64	\N	Shipping	\N
790	207	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 16:27:30	2025-10-08 16:27:30	1	64	\N	Shipping	\N
791	207	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 16:27:30	2025-10-08 16:27:30	1	64	\N	Shipping	\N
792	207	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 16:27:30	2025-10-08 16:27:30	1	64	\N	Shipping	\N
793	208	2025-10-08	توزيع شحنات	0	1000	\N	1	0	1000	2706	1	\N	2025-10-08 16:27:52	2025-10-08 16:27:52	1	47	\N	Shipping Distrbution	\N
794	208	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 16:27:52	2025-10-08 16:27:52	1	47	\N	Shipping Distrbution	\N
795	208	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 16:27:52	2025-10-08 16:27:52	1	47	\N	Shipping Distrbution	\N
796	208	2025-10-08	توزيع شحنات	1020	0	\N	1	1020	0	2534	1	\N	2025-10-08 16:27:52	2025-10-08 16:27:52	1	47	\N	Shipping Distrbution	\N
797	209	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 16:29:13	2025-10-08 16:29:13	1	65	\N	Shipping	\N
798	209	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 16:29:13	2025-10-08 16:29:13	1	65	\N	Shipping	\N
799	209	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 16:29:13	2025-10-08 16:29:13	1	65	\N	Shipping	\N
800	209	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 16:29:13	2025-10-08 16:29:13	1	65	\N	Shipping	\N
801	210	2025-10-08	توزيع شحنات	0	1000	\N	1	0	1000	2706	1	\N	2025-10-08 16:29:43	2025-10-08 16:29:43	1	48	\N	Shipping Distrbution	\N
802	210	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 16:29:43	2025-10-08 16:29:43	1	48	\N	Shipping Distrbution	\N
803	210	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 16:29:43	2025-10-08 16:29:43	1	48	\N	Shipping Distrbution	\N
804	210	2025-10-08	توزيع شحنات	1060	0	\N	1	1060	0	2534	1	\N	2025-10-08 16:29:43	2025-10-08 16:29:43	1	48	\N	Shipping Distrbution	\N
805	211	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 16:33:32	2025-10-08 16:33:32	1	66	\N	Shipping	\N
806	211	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 16:33:32	2025-10-08 16:33:32	1	66	\N	Shipping	\N
807	211	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 16:33:32	2025-10-08 16:33:32	1	66	\N	Shipping	\N
808	211	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 16:33:32	2025-10-08 16:33:32	1	66	\N	Shipping	\N
809	212	2025-10-08	توزيع شحنات	0	1000	\N	1	0	1000	2706	1	\N	2025-10-08 16:33:54	2025-10-08 16:33:54	1	49	\N	Shipping Distrbution	\N
810	212	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 16:33:54	2025-10-08 16:33:54	1	49	\N	Shipping Distrbution	\N
811	212	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 16:33:54	2025-10-08 16:33:54	1	49	\N	Shipping Distrbution	\N
812	212	2025-10-08	توزيع شحنات	1040	0	\N	1	1040	0	2534	1	\N	2025-10-08 16:33:54	2025-10-08 16:33:54	1	49	\N	Shipping Distrbution	\N
813	213	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 16:35:40	2025-10-08 16:35:40	1	67	\N	Shipping	\N
814	213	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 16:35:40	2025-10-08 16:35:40	1	67	\N	Shipping	\N
815	213	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 16:35:40	2025-10-08 16:35:40	1	67	\N	Shipping	\N
816	213	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 16:35:40	2025-10-08 16:35:40	1	67	\N	Shipping	\N
817	214	2025-10-08	توزيع شحنات	0	1000	\N	1	0	1000	2706	1	\N	2025-10-08 16:36:01	2025-10-08 16:36:01	1	50	\N	Shipping Distrbution	\N
818	214	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 16:36:01	2025-10-08 16:36:01	1	50	\N	Shipping Distrbution	\N
819	214	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 16:36:01	2025-10-08 16:36:01	1	50	\N	Shipping Distrbution	\N
820	214	2025-10-08	توزيع شحنات	1040	0	\N	1	1040	0	2534	1	\N	2025-10-08 16:36:01	2025-10-08 16:36:01	1	50	\N	Shipping Distrbution	\N
821	215	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 16:36:59	2025-10-08 16:36:59	1	68	\N	Shipping	\N
822	215	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 16:36:59	2025-10-08 16:36:59	1	68	\N	Shipping	\N
823	215	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 16:36:59	2025-10-08 16:36:59	1	68	\N	Shipping	\N
824	215	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 16:36:59	2025-10-08 16:36:59	1	68	\N	Shipping	\N
825	216	2025-10-08	توزيع شحنات	0	1000	\N	1	0	1000	2706	1	\N	2025-10-08 16:37:25	2025-10-08 16:37:25	1	51	\N	Shipping Distrbution	\N
826	216	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 16:37:25	2025-10-08 16:37:25	1	51	\N	Shipping Distrbution	\N
827	216	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 16:37:25	2025-10-08 16:37:25	1	51	\N	Shipping Distrbution	\N
828	216	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2700	1	\N	2025-10-08 16:37:25	2025-10-08 16:37:25	1	51	\N	Shipping Distrbution	\N
829	216	2025-10-08	توزيع شحنات	1090	0	\N	1	1090	0	2534	1	\N	2025-10-08 16:37:25	2025-10-08 16:37:25	1	51	\N	Shipping Distrbution	\N
830	217	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 16:38:54	2025-10-08 16:38:54	1	69	\N	Shipping	\N
831	217	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 16:38:54	2025-10-08 16:38:54	1	69	\N	Shipping	\N
832	217	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 16:38:54	2025-10-08 16:38:54	1	69	\N	Shipping	\N
833	217	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 16:38:54	2025-10-08 16:38:54	1	69	\N	Shipping	\N
834	218	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2708	1	\N	2025-10-08 16:39:17	2025-10-08 16:39:17	1	52	\N	Shipping Distrbution	\N
835	218	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 16:39:17	2025-10-08 16:39:17	1	52	\N	Shipping Distrbution	\N
836	218	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 16:39:17	2025-10-08 16:39:17	1	52	\N	Shipping Distrbution	\N
837	218	2025-10-08	توزيع شحنات	30	0	\N	1	30	0	2534	1	\N	2025-10-08 16:39:17	2025-10-08 16:39:17	1	52	\N	Shipping Distrbution	\N
838	219	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 16:40:32	2025-10-08 16:40:32	1	70	\N	Shipping	\N
839	219	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 16:40:32	2025-10-08 16:40:32	1	70	\N	Shipping	\N
840	219	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 16:40:32	2025-10-08 16:40:32	1	70	\N	Shipping	\N
841	219	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 16:40:32	2025-10-08 16:40:32	1	70	\N	Shipping	\N
842	220	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2708	1	\N	2025-10-08 16:40:55	2025-10-08 16:40:55	1	53	\N	Shipping Distrbution	\N
843	220	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 16:40:55	2025-10-08 16:40:55	1	53	\N	Shipping Distrbution	\N
844	220	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 16:40:55	2025-10-08 16:40:55	1	53	\N	Shipping Distrbution	\N
845	220	2025-10-08	توزيع شحنات	70	0	\N	1	70	0	2534	1	\N	2025-10-08 16:40:55	2025-10-08 16:40:55	1	53	\N	Shipping Distrbution	\N
846	221	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 16:42:18	2025-10-08 16:42:18	1	71	\N	Shipping	\N
847	221	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 16:42:18	2025-10-08 16:42:18	1	71	\N	Shipping	\N
848	221	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 16:42:18	2025-10-08 16:42:18	1	71	\N	Shipping	\N
849	221	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 16:42:18	2025-10-08 16:42:18	1	71	\N	Shipping	\N
850	222	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2708	1	\N	2025-10-08 16:42:39	2025-10-08 16:42:39	1	54	\N	Shipping Distrbution	\N
851	222	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 16:42:39	2025-10-08 16:42:39	1	54	\N	Shipping Distrbution	\N
852	222	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 16:42:39	2025-10-08 16:42:39	1	54	\N	Shipping Distrbution	\N
853	222	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2696	1	\N	2025-10-08 16:42:39	2025-10-08 16:42:39	1	54	\N	Shipping Distrbution	\N
854	222	2025-10-08	توزيع شحنات	40	0	\N	1	40	0	2534	1	\N	2025-10-08 16:42:39	2025-10-08 16:42:39	1	54	\N	Shipping Distrbution	\N
855	223	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 16:43:53	2025-10-08 16:43:53	1	72	\N	Shipping	\N
856	223	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 16:43:53	2025-10-08 16:43:53	1	72	\N	Shipping	\N
857	223	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 16:43:53	2025-10-08 16:43:53	1	72	\N	Shipping	\N
858	223	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 16:43:53	2025-10-08 16:43:53	1	72	\N	Shipping	\N
859	224	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2708	1	\N	2025-10-08 16:44:16	2025-10-08 16:44:16	1	55	\N	Shipping Distrbution	\N
860	224	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 16:44:16	2025-10-08 16:44:16	1	55	\N	Shipping Distrbution	\N
861	224	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 16:44:16	2025-10-08 16:44:16	1	55	\N	Shipping Distrbution	\N
862	224	2025-10-08	توزيع شحنات	50	0	\N	1	50	0	2534	1	\N	2025-10-08 16:44:16	2025-10-08 16:44:16	1	55	\N	Shipping Distrbution	\N
863	225	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 16:45:58	2025-10-08 16:45:58	1	73	\N	Shipping	\N
864	225	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 16:45:58	2025-10-08 16:45:58	1	73	\N	Shipping	\N
865	225	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 16:45:58	2025-10-08 16:45:58	1	73	\N	Shipping	\N
866	225	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 16:45:58	2025-10-08 16:45:58	1	73	\N	Shipping	\N
867	226	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2708	1	\N	2025-10-08 16:46:26	2025-10-08 16:46:26	1	56	\N	Shipping Distrbution	\N
868	226	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 16:46:26	2025-10-08 16:46:26	1	56	\N	Shipping Distrbution	\N
869	226	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 16:46:26	2025-10-08 16:46:26	1	56	\N	Shipping Distrbution	\N
870	226	2025-10-08	توزيع شحنات	50	0	\N	1	50	0	2534	1	\N	2025-10-08 16:46:26	2025-10-08 16:46:26	1	56	\N	Shipping Distrbution	\N
871	227	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 16:47:59	2025-10-08 16:47:59	1	74	\N	Shipping	\N
872	227	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 16:47:59	2025-10-08 16:47:59	1	74	\N	Shipping	\N
873	227	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 16:47:59	2025-10-08 16:47:59	1	74	\N	Shipping	\N
874	227	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 16:47:59	2025-10-08 16:47:59	1	74	\N	Shipping	\N
875	228	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2708	1	\N	2025-10-08 16:48:24	2025-10-08 16:48:24	1	57	\N	Shipping Distrbution	\N
876	228	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 16:48:24	2025-10-08 16:48:24	1	57	\N	Shipping Distrbution	\N
877	228	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 16:48:24	2025-10-08 16:48:24	1	57	\N	Shipping Distrbution	\N
878	228	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2700	1	\N	2025-10-08 16:48:24	2025-10-08 16:48:24	1	57	\N	Shipping Distrbution	\N
879	228	2025-10-08	توزيع شحنات	100	0	\N	1	100	0	2534	1	\N	2025-10-08 16:48:24	2025-10-08 16:48:24	1	57	\N	Shipping Distrbution	\N
880	229	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 16:57:50	2025-10-08 16:57:50	1	75	\N	Shipping	\N
881	229	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 16:57:50	2025-10-08 16:57:50	1	75	\N	Shipping	\N
882	229	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 16:57:50	2025-10-08 16:57:50	1	75	\N	Shipping	\N
883	229	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 16:57:50	2025-10-08 16:57:50	1	75	\N	Shipping	\N
884	230	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 16:58:21	2025-10-08 16:58:21	1	58	\N	Shipping Distrbution	\N
885	230	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 16:58:21	2025-10-08 16:58:21	1	58	\N	Shipping Distrbution	\N
886	230	2025-10-08	توزيع شحنات	20	0	\N	1	20	0	2534	1	\N	2025-10-08 16:58:21	2025-10-08 16:58:21	1	58	\N	Shipping Distrbution	\N
887	231	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 17:00:13	2025-10-08 17:00:13	1	76	\N	Shipping	\N
888	231	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 17:00:13	2025-10-08 17:00:13	1	76	\N	Shipping	\N
889	231	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 17:00:13	2025-10-08 17:00:13	1	76	\N	Shipping	\N
890	231	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 17:00:13	2025-10-08 17:00:13	1	76	\N	Shipping	\N
891	232	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 17:00:40	2025-10-08 17:00:40	1	59	\N	Shipping Distrbution	\N
892	232	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 17:00:40	2025-10-08 17:00:40	1	59	\N	Shipping Distrbution	\N
893	232	2025-10-08	توزيع شحنات	60	0	\N	1	60	0	2534	1	\N	2025-10-08 17:00:40	2025-10-08 17:00:40	1	59	\N	Shipping Distrbution	\N
894	233	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 17:01:59	2025-10-08 17:01:59	1	77	\N	Shipping	\N
895	233	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 17:01:59	2025-10-08 17:01:59	1	77	\N	Shipping	\N
896	233	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 17:01:59	2025-10-08 17:01:59	1	77	\N	Shipping	\N
897	233	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 17:01:59	2025-10-08 17:01:59	1	77	\N	Shipping	\N
898	234	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 17:02:21	2025-10-08 17:02:21	1	60	\N	Shipping Distrbution	\N
899	234	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 17:02:21	2025-10-08 17:02:21	1	60	\N	Shipping Distrbution	\N
900	234	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2696	1	\N	2025-10-08 17:02:21	2025-10-08 17:02:21	1	60	\N	Shipping Distrbution	\N
901	234	2025-10-08	توزيع شحنات	30	0	\N	1	30	0	2534	1	\N	2025-10-08 17:02:21	2025-10-08 17:02:21	1	60	\N	Shipping Distrbution	\N
902	235	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 17:03:19	2025-10-08 17:03:19	1	78	\N	Shipping	\N
903	235	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 17:03:19	2025-10-08 17:03:19	1	78	\N	Shipping	\N
904	235	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 17:03:19	2025-10-08 17:03:19	1	78	\N	Shipping	\N
905	235	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 17:03:19	2025-10-08 17:03:19	1	78	\N	Shipping	\N
906	236	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2676	1	\N	2025-10-08 17:03:43	2025-10-08 17:03:43	1	61	\N	Shipping Distrbution	\N
907	236	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2692	1	\N	2025-10-08 17:03:43	2025-10-08 17:03:43	1	61	\N	Shipping Distrbution	\N
908	236	2025-10-08	توزيع شحنات	40	0	\N	1	40	0	2534	1	\N	2025-10-08 17:03:43	2025-10-08 17:03:43	1	61	\N	Shipping Distrbution	\N
909	237	2025-10-08	شحن	200.00	0	\N	1	200	0	30	1	\N	2025-10-08 17:04:45	2025-10-08 17:04:45	1	79	\N	Shipping	\N
910	237	2025-10-08	شحن	0	200.00	\N	1	0	200	2667	1	\N	2025-10-08 17:04:45	2025-10-08 17:04:45	1	79	\N	Shipping	\N
911	237	2025-10-08	شحن	200.00	0	\N	1	200	0	2667	1	\N	2025-10-08 17:04:45	2025-10-08 17:04:45	1	79	\N	Shipping	\N
912	237	2025-10-08	شحن	0	200.00	\N	1	0	200	48	1	\N	2025-10-08 17:04:45	2025-10-08 17:04:45	1	79	\N	Shipping	\N
913	238	2025-10-08	توزيع شحنات	0	30	\N	1	0	30	2684	1	\N	2025-10-08 17:05:13	2025-10-08 17:05:13	1	62	\N	Shipping Distrbution	\N
914	238	2025-10-08	توزيع شحنات	0	10	\N	1	0	10	2688	1	\N	2025-10-08 17:05:13	2025-10-08 17:05:13	1	62	\N	