<?php

namespace App\Traits;
use App\Models\City;
use App\Models\Journalizing;
use App\Models\Shipping\NewShippingCategories;
use App\Models\Shipping\NewShippingTypes;
use App\Models\UsersMoves;
use App\Models\MaintainceDefaultData;
use App\Models\Purchases;
use App\Models\Vendors;
use App\Models\Event;
use App\Models\GeneralDaily;
use App\Models\JournalizingDetails;
use App\Models\AcccountingManual;
use App\Models\PurchasesDefaultData;
use App\Models\SalesDefaultData;
use App\Models\AccountsDefaultData;
use App\Models\StoresDefaultData;
use App\Models\ModuleSettingsNum;
use App\Models\SafesBanks;
use App\Models\Stores;
use App\Models\Customers;
use App\Models\Taxes;
use App\Models\Notifications;
use App\Models\BarcodeSettings;
use App\Models\DefaultDataShowHide;
use App\Models\ProductUnits;
use App\Models\ProductsQty;
use App\Models\ProductMoves;
use App\Models\FifoQty;
use App\Models\StoresMoves;
use App\Models\ExpireDateQty;
use DB;
use Str;
trait GeneralTrait
{



    // User Moves ===================
    public function UserCreateMoves($data)
    {

        if(!empty(auth()->guard('admin')->user()->id)){
            $id=auth()->guard('admin')->user()->id;
        }else{
            $id=$data['id'];
        }

    $dataUser['User']=$id;
    $dataUser['Date']=date('Y-m-d');
    $dataUser['Time']=date("h:i:s a", time());
    $dataUser['Screen']=$data['screen_ar'];
    $dataUser['ScreenEn']=$data['screen_en'];
    $dataUser['Type']='اضافه جديده';
    $dataUser['TypeEn']='New Add';

    $dataUser['Explain']=$data['explain_ar'];

    if(!empty($data['explain_en'])){
    $dataUser['ExplainEn']=$data['explain_en'];
    }else{
    $dataUser['ExplainEn']=$data['explain_ar'];

    }

    UsersMoves::create($dataUser);


    }

    public function UserUpdateMoves($data)
    {

        if(!empty(auth()->guard('admin')->user()->id)){
            $id=auth()->guard('admin')->user()->id;
        }else{
            $id=$data['id'];
        }

        $dataUser['User']=$id;
    $dataUser['Date']=date('Y-m-d');
    $dataUser['Time']=date("h:i:s a", time());
    $dataUser['Screen']=$data['screen_ar'];
    $dataUser['ScreenEn']=$data['screen_en'];
    $dataUser['Type']='تعديل';
    $dataUser['TypeEn']='Edit';

    $dataUser['Explain']=$data['explain_ar'];

    if(!empty($data['explain_en'])){
    $dataUser['ExplainEn']=$data['explain_en'];
    }else{
    $dataUser['ExplainEn']=$data['explain_ar'];

    }

    UsersMoves::create($dataUser);


    }


    public function UserDeleteMoves($data)
    {

        if(!empty(auth()->guard('admin')->user()->id)){
            $id=auth()->guard('admin')->user()->id;
        }else{
            $id=$data['id'];
        }

        $dataUser['User']=$id;
    $dataUser['Date']=date('Y-m-d');
    $dataUser['Time']=date("h:i:s a", time());
    $dataUser['Screen']=$data['screen_ar'];
    $dataUser['ScreenEn']=$data['screen_en'];
    $dataUser['Type']='حذف';
    $dataUser['TypeEn']='Delete';

    $dataUser['Explain']=$data['explain_ar'];

    if(!empty($data['explain_en'])){
    $dataUser['ExplainEn']=$data['explain_en'];
    }else{
    $dataUser['ExplainEn']=$data['explain_ar'];

    }

    UsersMoves::create($dataUser);


    }

    public function UserCustomMoves($data)
    {

        if(!empty(auth()->guard('admin')->user()->id)){
            $id=auth()->guard('admin')->user()->id;
        }else{
            $id=$data['id'];
        }

        $dataUser['User']=$id;
    $dataUser['Date']=date('Y-m-d');
    $dataUser['Time']=date("h:i:s a", time());
    $dataUser['Screen']=$data['screen_ar'];
    $dataUser['ScreenEn']=$data['screen_en'];
    $dataUser['Type']=$data['type_ar'];
    $dataUser['TypeEn']=$data['type_en'];

    $dataUser['Explain']=$data['explain_ar'];

    if(!empty($data['explain_en'])){
    $dataUser['ExplainEn']=$data['explain_en'];
    }else{
    $dataUser['ExplainEn']=$data['explain_ar'];

    }

    UsersMoves::create($dataUser);


    }

    // End User Moves ===================


    // Whene Delete Something in Default Data ===================
    public function DefaultDataDelete($model,$id,$item)
    {

    $check=$model::latest('id')->first();

    if($check->$item == $id){

    session()->flash('error',trans('admin.Cant_Delete_Default_Data'));
    return 1;
    }



    return 0;



    }
    
    // Used Maximum ===================
    public function MaxUse($name,$model,$num)
    {


    $Module=ModuleSettingsNum::orderBy('id','desc')->first();

    if($Module->$name == 1){

    $count=$model::count();

    if($Module->$num <= $count){ $result=1; }else{ $result=0; } }else{ $result=0; } return $result;


    }


    // Create New Code===================

    public function ReturnCode($model) { $res=$model::orderBy('id','desc')->first();

        if(!empty($res->Code)){

        $Code=$res->Code + 1 ;

        }else{

        $Code=1;

        }

        return $Code;


        }


        // Jounralizing ===================

        public function CreateNewJun($data)
        {

        if(!empty($data['branch'])){
        $branch = $data['branch'] ;
        }else{
        $branch = null ;
        }

        if(!empty($data['status'])){
        $status = $data['status'] ;
        }else{
        $status = 1 ;
        }


        $ID = DB::table('journalizings')->insertGetId(

        array(

        'Type' => $data['type_ar'],
        'TypeEn' => $data['type_en'],
        'Code_Type' =>$data['code_type'],
        'Date' => $data['date'],
        'Draw' => $data['draw'],
        'Coin' => $data['coin'],
        'Branch' => $branch,
        'Cost_Center' => $data['cost_center'],
        'Total_Debaitor' => $data['total'],
        'Total_Creditor' => $data['total'],
        'Note' =>$data['note'],
        'Status' =>$status,

        )
        );



        return $ID;


        }


        public function JunDetails($data)
        {


        if(!empty($data['branch'])){
        $branch = $data['branch'] ;
        }else{


        $branch = null ;
        }


        if(!empty($data['admin_id'])){
        $user = $data['admin_id'] ;
        }else{


            $user = auth()->guard('admin')->user()->id ;
        }



        $PRODUCTSS['Joun_ID']=$data['joun_id'];
        $PRODUCTSS['Debitor']=$data['debitor_debt'];
        $PRODUCTSS['Creditor']=$data['creditor_debt'];
        $PRODUCTSS['Account']=$data['account_debt'];
        $PRODUCTSS['Statement']=$data['note'];

        JournalizingDetails::create($PRODUCTSS);

        $Gen['Code']=$data['code'];
        $Gen['Code_Type']=$data['code_type'];
        $Gen['Date']=$data['date'];
        $Gen['Type']=$data['type_ar'];
        $Gen['TypeEn']=$data['type_en'];
        $Gen['Debitor']=$data['debitor_debt'];
        $Gen['Creditor']=$data['creditor_debt'];
        $Gen['Statement']=$data['note'];
        $Gen['Draw']=$data['draw'];
        $Gen['Branch']= $branch;
        $Gen['Debitor_Coin']= $data['draw'] * $data['debitor_debt'];
        $Gen['Creditor_Coin']=$data['draw'] * $data['creditor_debt'];
        $Gen['Account']=$data['account_debt'];
        $Gen['Coin']= $data['coin'];
        $Gen['Cost_Center']=$data['cost_center'];
        $Gen['userr']= $user;

        GeneralDaily::create($Gen);


        $PRODUCTSS['Joun_ID']=$data['joun_id'];
        $PRODUCTSS['Debitor']=$data['debitor_cred'];
        $PRODUCTSS['Creditor']=$data['creditor_cred'];
        $PRODUCTSS['Account']=$data['account_cred'];
        $PRODUCTSS['Statement']=$data['note'];


        JournalizingDetails::create($PRODUCTSS);

        $Gen['Code']=$data['code'];
        $Gen['Code_Type']=$data['code_type'];
        $Gen['Date']=$data['date'];
        $Gen['Type']=$data['type_ar'];
        $Gen['TypeEn']=$data['type_en'];
        $Gen['Debitor']=$data['debitor_cred'];
        $Gen['Creditor']=$data['creditor_cred'];
        $Gen['Statement']=$data['note'];
        $Gen['Draw']=$data['draw'];
        $Gen['Branch']= $branch;
        $Gen['Debitor_Coin']= $data['draw'] * $data['debitor_cred'];
        $Gen['Creditor_Coin']=$data['draw'] * $data['creditor_cred'];
        $Gen['Account']=$data['account_cred'];
        $Gen['Coin']= $data['coin'];
        $Gen['Cost_Center']=$data['cost_center'];
        $Gen['userr']= $user;

        GeneralDaily::create($Gen);


        }

        public function OneJunDetails($data ,$type)
        {


            if(!empty($data['admin_id'])){
                $user = $data['admin_id'] ;
            }else{


                $user = auth()->guard('admin')->user()->id ;
            }

            if(!empty($data['branch'])){
        $branch = $data['branch'] ;
        }else{


        $branch = null ;
        }


        $PRODUCTSS['Joun_ID']=$data['joun_id'];
        $PRODUCTSS['Debitor']=$data['debitor'];
        $PRODUCTSS['Creditor']=$data['creditor'];
        $PRODUCTSS['Account']=$data['account'];
        $PRODUCTSS['Statement']=$data['note'];

        JournalizingDetails::create($PRODUCTSS);


        if($type == 0){
        $Gen['Code']=$data['code'];
        $Gen['Code_Type']=$data['code_type'];
        $Gen['Date']=$data['date'];
        $Gen['Type']=$data['type_ar'];
        $Gen['TypeEn']=$data['type_en'];
        $Gen['Debitor']=$data['debitor'];
        $Gen['Creditor']=$data['creditor'];
        $Gen['Statement']=$data['note'];
        $Gen['Draw']=$data['draw'];
        $Gen['Debitor_Coin']= $data['draw'] * $data['debitor'];
        $Gen['Creditor_Coin']=$data['draw'] * $data['creditor'];
        $Gen['Account']=$data['account'];
        $Gen['Coin']= $data['coin'];
        $Gen['Branch']= $branch;
        $Gen['Cost_Center']=$data['cost_center'];
        $Gen['userr']= $user;

        GeneralDaily::create($Gen);
        }



        }

        // End Jounralizing ===================



        // Upload File ===================
        public function UploadFile($imageFile)
        {



        if($imageFile){
        $image_nameFile=Str::random(10);
        $extFile=strtolower($imageFile->getClientOriginalExtension());
        $image_full_nameFile=$image_nameFile .'.' . $extFile ;
        $upload_pathFile='SafeTransferFiles/';
        $image_urlFile=$upload_pathFile.$image_full_nameFile;
        $successFile=$imageFile->move($upload_pathFile,$image_full_nameFile);
        }


        if(!empty($image_urlFile)){

        $zFile=$image_urlFile;

        }else{
        $zFile=null;
        }




        return $zFile;


        }

        // Create Event ===================

        public function CreateEvent($data)
        {


        $event['Start_Date']=$data['start_date'];
        $event['End_Date']=$data['end_date'];
        $event['Event_Ar_Name']=$data['event_name_ar'];
        $event['Event_En_Name']=$data['event_name_en'];
        $event['Type']=$data['type'];
        $event['Type_ID']=$data['type_id'];
        $event['Type_Code']=$data['type_code'];
        $event['Emp']=$data['emp'];
        $event['Client']=$data['client'];
        $event['Product']=$data['product'];
        $event['Customer']=$data['customer'];
        Event::create($event);


        }


        // Create Notifications ===================

        public function CreateNotification($data)
        {


        $notii['Date']=date('Y-m-d');
        $notii['Status']=0;
        $notii['Noti_Ar_Name']=$data['noti_name_ar'];
        $notii['Noti_En_Name']=$data['noti_name_ar'];
        $notii['Type']=$data['type_ar'];
        $notii['TypeEn']=$data['type_en'];
        $notii['Type_Code']=$data['type_code'];
        $notii['Emp']=$data['emp'];
        $notii['Client']=$data['client'];
        $notii['Product']=$data['product'];
        $notii['Store']=$data['store'];
        $notii['Safe']=$data['safe'];

        Notifications::create($notii);

        notify()->warning($data['notify_name']);


        }



        // Create Account in Account Manual

        public function CreateAccount($name_ar,$name_en ,$parent ,$note)
        {


        $count=AcccountingManual::orderBy('id','desc')->where('Parent',$parent)->count();
        $code=AcccountingManual::orderBy('id','desc')->where('Parent',$parent)->first();
        $codee=AcccountingManual::find($parent);

        if($count == 0){

        $x=$codee->Code.'01';
        $data['Code']=(int) $x ;

        }else{

        $y=substr($code->Code, strlen($codee->Code));
        $newY=$y + 1 ;

        if(strlen($newY) == 1){
        $NewXY='0'.$newY;
        }else{
        $NewXY=$newY;
        }
        $x= $codee->Code.$NewXY;
        $data['Code']=(int) $x;

        }

        $data['Name']=$name_ar;
        $data['NameEn']=$name_en;
        $data['Type']=1;
        $data['Parent']=$parent;
        $data['Note']=$note;
        $data['User']=auth()->guard('admin')->user()->id;
        AcccountingManual::create($data);

        $Acc=AcccountingManual::latest('id')->first();
        return $Acc->id ;


        }
    
        public function CreateAccountMain($name_ar,$name_en ,$parent ,$note)
        {


        $count=AcccountingManual::orderBy('id','desc')->where('Parent',$parent)->count();
        $code=AcccountingManual::orderBy('id','desc')->where('Parent',$parent)->first();
        $codee=AcccountingManual::find($parent);

        if($count == 0){

        $x=$codee->Code.'01';
        $data['Code']=(int) $x ;

        }else{

        $y=substr($code->Code, strlen($codee->Code));
        $newY=$y + 1 ;

        if(strlen($newY) == 1){
        $NewXY='0'.$newY;
        }else{
        $NewXY=$newY;
        }
        $x= $codee->Code.$NewXY;
        $data['Code']=(int) $x;

        }

        $data['Name']=$name_ar;
        $data['NameEn']=$name_en;
        $data['Type']=0;
        $data['Parent']=$parent;
        $data['Note']=$note;
        $data['User']=auth()->guard('admin')->user()->id;
        AcccountingManual::create($data);

        $Acc=AcccountingManual::latest('id')->first();
        return $Acc->id ;


        }

        public function CreateAccountByName($name_ar,$name_en ,$parent ,$note)
        {


        $count=AcccountingManual::orderBy('id','desc')->where('Name',$parent)->count();
        $code=AcccountingManual::orderBy('id','desc')->where('Name',$parent)->first();
        $codee=AcccountingManual::latest('id')->where('Name',$parent)->first();


        if($count == 0){

        $x=$codee->Code.'01';
        $data['Code']=(int) $x ;

        }else{

        $y=substr($code->Code, strlen($codee->Code));

        if(!empty($y)) {
            $newY = $y + 1;

            if (strlen($newY) == 1) {
                $NewXY = '0' . $newY;
            } else {
                $NewXY = $newY;
            }
            $x = $codee->Code . $NewXY;
            $data['Code'] = (int)$x;
        }else{
            $x=$codee->Code.'01';
            $data['Code']=(int) $x ;
        }

        }

        $data['Name']=$name_ar;
        $data['NameEn']=$name_en;
        $data['Type']=1;
        $data['Parent']=$codee->id;
        $data['Note']=$note;
        $data['User']=auth()->guard('admin')->user()->id;
        AcccountingManual::create($data);

        $Acc=AcccountingManual::latest('id')->first();
        return $Acc->id ;


        }


        public function CreateAccountApi($name_ar,$name_en ,$parent ,$note,$id)
        {


        $count=AcccountingManual::orderBy('id','desc')->where('Parent',$parent)->count();
        $code=AcccountingManual::orderBy('id','desc')->where('Parent',$parent)->first();
        $codee=AcccountingManual::find($parent);

        if($count == 0){

        $x=$codee->Code.'01';
        $data['Code']=(int) $x ;

        }else{

        $y=substr($code->Code, strlen($codee->Code));
        $newY=$y + 1 ;

        if(strlen($newY) == 1){
        $NewXY='0'.$newY;
        }else{
        $NewXY=$newY;
        }
        $x= $codee->Code.$NewXY;
        $data['Code']=(int) $x;

        }

        $data['Name']=$name_ar;
        $data['NameEn']=$name_en;
        $data['Type']=1;
        $data['Parent']=$parent;
        $data['Note']=$note;
        $data['User']=$id;
        AcccountingManual::create($data);

        $Acc=AcccountingManual::latest('id')->first();
        return $Acc->id ;


        }


        //Safe Credit
        public function SafeCredit($safe,$amount)
        {

        $debt=GeneralDaily::where('Account',$safe)->get()->sum('Debitor');
        $crdt=GeneralDaily::where('Account',$safe)->get()->sum('Creditor');
        $dif=$debt - $crdt ;
        $SafyFatora=$amount;

        if($dif < $SafyFatora){ return 1; } 
            
            
            
            return 0 ; 
        
        
        
        
        }


    //Filter Products  (Supplay Chain) =====================================
    
    public function FilterProduct($search){
    $DefSHOW = DefaultDataShowHide::orderBy('id', 'desc')->first();

    $data = ProductUnits::whereRelation('Product', 'Status', 0)
        ->whereIn('P_Type', ['Completed', 'Raw', 'Service', 'Industrial', 'Subscribe'])
        ->where('Def', 1)
        ->limit(100);

    if ($DefSHOW->Search_Typical == 0) {
        // Fuzzy search
        $data->where(function ($query) use ($search) {
            $query->whereRelation('Product', function ($q) use ($search) {
                $q->where('P_Ar_Name', 'ILIKE', "%{$search}%")
                  ->orWhere('P_En_Name', 'ILIKE', "%{$search}%");
            })->orWhere('Barcode', 'ILIKE', "%{$search}%"); // Barcode on ProductUnits
        });
    } else {
        // Exact search
        $data->where(function ($query) use ($search) {
            $query->whereRelation('Product', function ($q) use ($search) {
                $q->where('P_Ar_Name', $search)
                  ->orWhere('P_En_Name', $search);
            })->orWhere('Barcode', $search); // Barcode on ProductUnits
        });
    }

    return $data->get();
}

     public function FilterProductQty($search,$store){
        $DefSHOW = DefaultDataShowHide::orderBy('id', 'desc')->first();
        $isFuzzySearch = ($DefSHOW->Search_Typical == 0); 
        $operator = $isFuzzySearch ? 'ILIKE' : '=';
        $searchValue = $isFuzzySearch ? "%{$search}%" : $search;

        $query = ProductsQty::whereRelation('Product', 'Status', 0);


        $query->where(function ($q) use ($searchValue, $operator) {
  
            $q->whereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                $subQuery->where('P_Ar_Name', $operator, $searchValue)
                         ->orWhere('P_En_Name', $operator, $searchValue);
            })

            ->orWhere('V_Name', $operator, $searchValue)
            ->orWhere('VV_Name', $operator, $searchValue)
            ->orWhere('P_Code', $operator, $searchValue)
            ->orWhere('PP_Code', $operator, $searchValue)
            ->orWhere('PPP_Code', $operator, $searchValue)
            ->orWhere('PPPP_Code', $operator, $searchValue);
        });

        if (!empty($store)) {
            $query->where('Store', $store);
        }

        $Prodss = $query->limit(100)->get();

        return $Prodss;
    }
    
    //Product Moves
    public function ProductMoves($data){


         $move['Date']=$data['Date'];
         $move['Type']=$data['Type'] ;
         $move['TypeEn']=$data['TypeEn'] ;
         $move['Bill_Num']=$data['Bill_Num'];
         $move['Incom']=$data['Incom'];
         $move['Outcom']=$data['Outcom'];
         $move['Current']=$data['Current'];
         $move['CostIn']=$data['CostIn'];
         $move['CostOut']=$data['CostOut'];
         $move['CostCurrent']=$data['CostCurrent'];
         $move['P_Ar_Name']=$data['P_Ar_Name'];
         $move['P_En_Name']=$data['P_En_Name'];
         $move['P_Code']=$data['P_Code'];
         $move['Unit']=$data['Unit'];
         $move['Qty']=$data['Qty'];
         $move['Group']=$data['Group'];
         $move['Store']=$data['Store'];
         $move['Product']=$data['Product'];
         $move['V1']=$data['V1'];
         $move['V2']=$data['V2'];
         $move['Brand']=$data['Brand'];
         $move['Safe']=$data['Safe'];
         $move['Branch']=$data['Branch'];
         $move['SalePrice']=$data['SalePrice'];
         $move['ProductPrice']=$data['ProductPrice'];
         $move['Delegate']=$data['Delegate'];
         $move['Payment_Method']=$data['Payment_Method'];
         $move['User']=$data['User'];
         ProductMoves::create($move);





    }

    //StoresMoves
    public function StoresMoves($data){



           $dataStMove['Date']=$data['Date'];
           $dataStMove['Code']=$data['Code'];
           $dataStMove['Time']=$data['Time'];
           $dataStMove['Branch']=$data['Branch'];
           $dataStMove['Store']=$data['Store'];
           $dataStMove['Safe']=$data['Safe'];
           $dataStMove['Type']=$data['Type'];
           $dataStMove['TypeEn']=$data['TypeEn'];
           $dataStMove['Cost_Center']=$data['Cost_Center'];
           $dataStMove['User']=$data['User'];
           $dataStMove['Coin']=$data['Coin'];
           $dataStMove['Note']=$data['Note'];
           $dataStMove['Total_Qty']=$data['Total_Qty'];
           $dataStMove['Total_Price']=$data['Total_Price'];
           $dataStMove['Account']=$data['Account'];
           $dataStMove['Ship']=$data['Ship'];
           $dataStMove['ID']=$data['ID'];
           StoresMoves::create($dataStMove);




    }

    //Fifo Avliable Qty

    public function FifoAvQty($store,$product,$code,$date){


           // Define the common base query
        $baseQuery = FifoQty::where('Store', $store)
                            ->where('Product', $product)
                            ->where('Purchases_Date', $date);

        // Define the columns to search for the code
        $codeColumns = ['P_Code', 'PP_Code', 'PPP_Code', 'PPPP_Code'];

        // Build the OR conditions for the codes
        $fifo = $baseQuery->where(function ($query) use ($code, $codeColumns) {
            foreach ($codeColumns as $column) {
                $query->orWhere($column, $code);
            }
        })->first();

        return $fifo;


    }

    public function FifoAvQtyDate($store,$product,$code){

            // Define the common base query
        $baseQuery = FifoQty::orderBy('id','asc')->where('Store', $store)
                            ->where('Product', $product)
//                            ->where('Purchases_Date', $date)
                            ->where('Qty','!=',0);
                                                

        // Define the columns to search for the code
        $codeColumns = ['P_Code', 'PP_Code', 'PPP_Code', 'PPPP_Code'];

        // Build the OR conditions for the codes
        $fifo = $baseQuery->where(function ($query) use ($code, $codeColumns) {
            foreach ($codeColumns as $column) {
                $query->orWhere($column, $code);
            }
        })->first();

        return $fifo;


    }

    public function TestCost($store,$product,$code,$id,$Purchases_Date){

                   $rr=ProductUnits::where('Product',$product)->where('Def',1)->first();

        
                  // Define the common base query
        $baseQuery = FifoQty::where('Store', $store)
                            ->where('Product', $product)
                            ->where('Purchases_Date', $Purchases_Date)        
                            ->where('id','!=',$id);

        // Define the columns to search for the code
        $codeColumns = ['P_Code', 'PP_Code', 'PPP_Code', 'PPPP_Code'];

        // Build the OR conditions for the codes
        $fifo = $baseQuery->where(function ($query) use ($code, $codeColumns) {
            foreach ($codeColumns as $column) {
                $query->orWhere($column, $code);
            }
        })->first();
        
        
                   if(!empty($fifo)){

                   if($fifo->Qty == 0){



                   $ty=$this->TestCost($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);

                   $AVERAGE = $ty ;

                   }else{
                   $AVERAGE = $fifo->Cost_Price ;
                   }


                   }else{

                   $AVERAGE = $rr->Price ;

                   }

        return $AVERAGE ;


    }


    //Products Avalibles Qties
        public function ProAvQties($store,$product,$code){

                  // Define the common base query
        $baseQuery = ProductsQty::where('Store', $store)
                                ->where('Product', $product);

        // Define the columns to search for the code
        $codeColumns = ['P_Code', 'PP_Code', 'PPP_Code', 'PPPP_Code'];

        // Build the OR conditions for the codes and execute the query
        $quantityRecord = $baseQuery->where(function ($query) use ($code, $codeColumns) {
            foreach ($codeColumns as $column) {
                $query->orWhere($column, $code);
            }
        })->first();

        return $quantityRecord;
            
    }

    public function ProAvQtiesDamaged($store,$product,$code){

        
                          // Define the common base query
        $baseQuery = ProductsQty::where('Store', $store)
                                ->where('Product', $product)
                                 ->where('Original','Damage');

        // Define the columns to search for the code
        $codeColumns = ['P_Code', 'PP_Code', 'PPP_Code', 'PPPP_Code'];

        // Build the OR conditions for the codes and execute the query
        $quantityRecord = $baseQuery->where(function ($query) use ($code, $codeColumns) {
            foreach ($codeColumns as $column) {
                $query->orWhere($column, $code);
            }
        })->first();

        return $quantityRecord;

    }
    
     public function ProAvQtiesUnit($store,$product,$code,$unit){

        // Define the common base query
        $baseQuery = ProductsQty::where("Unit",$unit)->where('Store', $store)
                                ->where('Product', $product);

        // Define the columns to search for the code
        $codeColumns = ['P_Code', 'PP_Code', 'PPP_Code', 'PPPP_Code'];

        // Build the OR conditions for the codes and execute the query
        $quantityRecord = $baseQuery->where(function ($query) use ($code, $codeColumns) {
            foreach ($codeColumns as $column) {
                $query->orWhere($column, $code);
            }
        })->first();

        return $quantityRecord;
         
         
    }


    //Expire Date Avalibles Qties
        public function ExpireAvQties($store,$product,$code){

            
               // Define the common base query
        $baseQuery = ExpireDateQty::where('Store', $store)
                                 ->where('Product', $product);

        // Define the columns to search for the code
        $codeColumns = ['P_Code', 'PP_Code', 'PPP_Code', 'PPPP_Code'];

        // Build the OR conditions for the codes and execute the query
        $quantityRecord = $baseQuery->where(function ($query) use ($code, $codeColumns) {
            foreach ($codeColumns as $column) {
                $query->orWhere($column, $code);
            }
        })->first();

        return $quantityRecord;
 
    }

         public function ExpireAvQtiesCheck($store,$product,$code,$date){

             
                       // Define the common base query
        $baseQuery = ExpireDateQty::where('Store', $store)
                                 ->where('Product', $product)->where('Exp_Date',$date);

        // Define the columns to search for the code
        $codeColumns = ['P_Code', 'PP_Code', 'PPP_Code', 'PPPP_Code'];

        // Build the OR conditions for the codes and execute the query
        $quantityRecord = $baseQuery->where(function ($query) use ($code, $codeColumns) {
            foreach ($codeColumns as $column) {
                $query->orWhere($column, $code);
            }
        })->first();

        return $quantityRecord;
            
   
    

    }



    // =======================  Purchases Filter  ========================

         public function FilterPurchProduct($search,$Group,$Brand)
        {


        $DefSHOW = DefaultDataShowHide::orderBy('id', 'desc')->first();
        $isFuzzySearch = ($DefSHOW->Search_Typical == 0);
        $operator = $isFuzzySearch ? 'ILIKE' : '=';
        $searchValue = $isFuzzySearch ? "%{$search}%" : $search;

        $query = ProductUnits::whereRelation('Product', 'Status', 0)
            ->whereIn('P_Type', [
                'Completed', 'Raw', 'Industrial', 'Additions', 'Serial',
                'Single_Variable', 'Duble_Variable'
            ]);

        // Apply search conditions based on whether the search term is numeric
        $query->where(function ($q) use ($search, $searchValue, $operator) {
            if (!is_numeric($search)) {
                // Search by product name (P_Ar_Name or P_En_Name)
                $q->whereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                    $subQuery->where('P_Ar_Name', $operator, $searchValue)
                             ->orWhere('P_En_Name', $operator, $searchValue);
                });
            } else {
                // Search by barcode. Assuming Barcode is on ProductUnits.
                // If Barcode is on Product model, change to ->whereRelation('Product', 'Barcode', ...)
                $q->where('Barcode', $operator, $searchValue);
            }
        });

        // Apply Group filter if provided (currently unused in original code, adding here for completeness)
         if (!empty($group)) {
             $query->whereRelation('Product', 'Group', $group); // Assuming 'Group' column in Product model
         }

        // Apply Brand filter if provided (currently unused in original code, adding here for completeness)
         if (!empty($brand)) {
             $query->whereRelation('Product', 'Brand', $brand); // Assuming 'Brand' column in Product model
         }

        return $query->limit(100)->get();

       }

         public function FilterPurchProductSearchCode($search,$Group,$Brand)
        {

         $DefSHOW = DefaultDataShowHide::orderBy('id', 'desc')->first();
        $isFuzzySearch = ($DefSHOW->Search_Typical == 0);
        $operator = $isFuzzySearch ? 'ILIKE' : '=';
        $searchValue = $isFuzzySearch ? "%{$search}%" : $search;

        $query = ProductUnits::whereRelation('Product', 'Status', 0)
            ->whereIn('P_Type', [
                'Completed', 'Raw', 'Industrial', 'Additions', 'Serial',
                'Single_Variable', 'Duble_Variable'
            ])
            ->where('Def', 1); // Condition moved outside 'when' blocks as it's always applied

        // Since the 'when' logic is the same for numeric and non-numeric, we can simplify this.
        // We always search in SearchCode1 or SearchCode2 on the related Product.
        $query->where(function ($q) use ($searchValue, $operator) {
            $q->whereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                $subQuery->where('SearchCode1', $operator, $searchValue)
                         ->orWhere('SearchCode2', $operator, $searchValue);
            });
        });

        // Apply Group filter if provided (assuming 'Group' column in Product model)
             if (!empty($group)) {
                 $query->whereRelation('Product', 'Group', $group);
             }

        // Apply Brand filter if provided (assuming 'Brand' column in Product model)
             if (!empty($brand)) {
                 $query->whereRelation('Product', 'Brand', $brand);
             }

        return $query->limit(100)->get();

       }

    
         public function FilterPurchProductShort($search,$Group,$Brand)
        {

        $DefSHOW=DefaultDataShowHide::orderBy('id','desc')->first();
        if($DefSHOW->Search_Typical ==  0){

     $data = ProductUnits::query()->whereRelation('Product', 'Status', 0)
         ->whereIn('P_Type',['Completed','Raw','Industrial','Additions'])

    ->when(!is_numeric($search), function ($query) use ($search) {
         return  $query->whereRelation('Product','P_Ar_Name','ILIKE', "%{$search}%")
               ->orWhereRelation('Product','P_En_Name','ILIKE', "%{$search}%");

    })

    ->when(is_numeric($search), function ($query) use ($search) {
         return  $query->where('Barcode','ILIKE', "%{$search}%") ;
    })
         ->where('Def',1)
            ->limit(100)
               ->get();



              }else{

                   $data =ProductUnits::whereRelation('Product', 'Status', 0)
                  ->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable'])

             ->when(!is_numeric($search), function ($query) use ($search) {
         return  $query->whereRelation('Product','P_Ar_Name', $search)
               ->orWhereRelation('Product','P_En_Name', $search);

    })

    ->when(is_numeric($search), function ($query) use ($search) {
         return  $query->where('Barcode', $search) ;
    })


                       ->where('Def',1)
               ->limit(100)
               ->get();


                }



           return $data ;

       }

         public function FilterPurchProductSearchCodeShort($search,$Group,$Brand)
        {

        $DefSHOW=DefaultDataShowHide::orderBy('id','desc')->first();
        if($DefSHOW->Search_Typical ==  0){

     $data = ProductUnits::query()->whereRelation('Product', 'Status', 0)
         ->whereIn('P_Type',['Completed','Raw','Industrial','Additions'])

    ->when(!is_numeric($search), function ($query) use ($search) {
         return  $query->whereRelation('Product','SearchCode1','ILIKE', "%{$search}%")
               ->orWhereRelation('Product','SearchCode2','ILIKE', "%{$search}%");

    })

    ->when(is_numeric($search), function ($query) use ($search) {
             return  $query->whereRelation('Product','SearchCode1','ILIKE', "%{$search}%")
               ->orWhereRelation('Product','SearchCode2','ILIKE', "%{$search}%");
    })
         ->where('Def',1)
            ->limit(100)
               ->get();



              }else{

                   $data =ProductUnits::whereRelation('Product', 'Status', 0)
                  ->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable'])

      ->when(!is_numeric($search), function ($query) use ($search) {
         return  $query->whereRelation('Product','SearchCode1', $search)
               ->orWhereRelation('Product','SearchCode2', $search);

    })

    ->when(is_numeric($search), function ($query) use ($search) {
             return  $query->whereRelation('Product','SearchCode1', $search)
               ->orWhereRelation('Product','SearchCode2', $search);
    })
                       ->where('Def',1)
               ->limit(100)
               ->get();


                }



           return $data ;

       }

// ======================  Sales Filters  =====================


    public function FilterSalesProductQty($search,$store,$Group,$Brand)
    {   

        $defShow = DefaultDataShowHide::latest('id')->first();
        
    $searchOperator = ($defShow->Search_Typical == 0) ? 'ILIKE' : '=';
        
    $searchValue = ($defShow->Search_Typical == 0) ? "%{$search}%" : $search;

    $query = ProductsQty::query()
        ->whereHas('Product', function ($productQuery) {
            $productQuery->where('Status', 0)
                ->whereIn('P_Type', [
                    'Completed',
                    'Industrial',
                    'Additions',
                    'Serial',
                    'Single_Variable',
                    'Duble_Variable'
                ]);
        });

    $query->where(function ($searchQuery) use ($searchOperator, $searchValue) {
        $searchQuery->whereHas('Product', function ($productNameQuery) use ($searchOperator, $searchValue) {
            $productNameQuery->where('P_Ar_Name', $searchOperator, $searchValue)
                ->orWhere('P_En_Name', $searchOperator, $searchValue);
        })
        ->orWhere('V_Name', $searchOperator, $searchValue)
        ->orWhere('VV_Name', $searchOperator, $searchValue)
        ->orWhereHas('Product', function ($productCodeQuery) use ($searchOperator, $searchValue) {
            $productCodeQuery->where('P_Code', $searchOperator, $searchValue)
                ->orWhere('PP_Code', $searchOperator, $searchValue)
                ->orWhere('PPP_Code', $searchOperator, $searchValue)
                ->orWhere('PPPP_Code', $searchOperator, $searchValue);
        });
    });

    if (!empty($store)) {
        $query->where('Store', $store);
    }
    if (!empty($Group)) {
 
        $query->where('Group', $Group);
    }
    if (!empty($Brand)) {
    
        $query->where('Brand', $Brand);
    }

    $prodss = $query->take(100)->get();

    return $prodss;
   

    }

    public function FilterSalesProductQtyWithout($search,$store,$Group,$Brand)
    {

       $DefSHOW = DefaultDataShowHide::latest('id')->first();
        $isFuzzySearch = ($DefSHOW->Search_Typical == 0);
        $operator = $isFuzzySearch ? 'ILIKE' : '=';
        $searchValue = $isFuzzySearch ? "%{$search}%" : $search;

        $query = ProductsQty::whereRelation('Product', 'Status', 0)
            ->whereRelation('Product', function ($prodQuery) {
                $prodQuery->whereIn('P_Type', [
                    'Completed', 'Industrial', 'Additions', 'Serial',
                    'Single_Variable', 'Duble_Variable'
                ]);
            });

        // Apply search conditions for name, vendor name, and product codes
        $query->where(function ($q) use ($searchValue, $operator) {
            // Search in Product relation (P_Ar_Name, P_En_Name)
            $q->whereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                $subQuery->where('P_Ar_Name', $operator, $searchValue)
                         ->orWhere('P_En_Name', $operator, $searchValue);
            })
            // OR search in ProductsQty for vendor names
            // Assuming V_Name, VV_Name are on ProductsQty table
            ->orWhere('V_Name', $operator, $searchValue)
            ->orWhere('VV_Name', $operator, $searchValue)
            // OR search in ProductsQty for product codes
            // Assuming P_Code, PP_Code, PPP_Code, PPPP_Code are on ProductsQty table
            ->orWhere('P_Code', $operator, $searchValue)
            ->orWhere('PP_Code', $operator, $searchValue)
            ->orWhere('PPP_Code', $operator, $searchValue)
            ->orWhere('PPPP_Code', $operator, $searchValue);
        });

        // Apply store filter if provided
        if (!empty($store)) {
            $query->where('Store', $store);
        }

        // Apply Group filter if provided (assuming 'Group' column in Product model)
         if (!empty($group)) {
             $query->whereRelation('Product', 'Group', $group);
         }

        // Apply Brand filter if provided (assuming 'Brand' column in Product model)
         if (!empty($brand)) {
             $query->whereRelation('Product', 'Brand', $brand);
         }

        return $query->limit(100)->get();

    }

    public function FilterSalesProductQtySearchCode($search,$store,$Group,$Brand)
    {

         $DefSHOW = DefaultDataShowHide::latest('id')->first();
        
        // 1. Determine search operator and value
        $isFuzzySearch = ($DefSHOW->Search_Typical == 0);
        $operator = $isFuzzySearch ? 'ILIKE' : '=';
        $searchValue = $isFuzzySearch ? "%{$search}%" : $search;

        // 2. Build the base query with common mandatory conditions
        $query = ProductsQty::whereRelation('Product', 'Status', 0)
            // Apply mandatory product types filter
            ->whereRelation('Product', function ($prodQuery) {
                $prodQuery->whereIn('P_Type', [
                    'Completed', 'Industrial', 'Additions', 'Serial',
                    'Single_Variable', 'Duble_Variable'
                ]);
            });

        // 3. Apply the search code filter (dynamically)
        // This is always applied, regardless of the store check in the original code.
        $query->whereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
            $subQuery->where('SearchCode1', $operator, $searchValue)
                     ->orWhere('SearchCode2', $operator, $searchValue);
        });

        // 4. Apply store filter (conditional)
        // The original code only runs the query if $store is NOT empty. 
        // We'll apply the filter conditionally for more flexibility.
        if (!empty($store)) {
            $query->where('Store', $store);
        }

        // 5. Apply unused filters (Group, Brand) for potential future use
        
        if (!empty($group)) {
            $query->whereRelation('Product', 'Group', $group);
        }
        if (!empty($brand)) {
            $query->whereRelation('Product', 'Brand', $brand);
        }
        

        // 6. Execute and return results
        return $query->limit(100)->get();

    }

    public function FilterSalesProduct($search,$Group,$Brand)
    {

      $DefSHOW = DefaultDataShowHide::orderBy('id', 'desc')->first();
        
        // 1. Determine search operator and value
        $isFuzzySearch = ($DefSHOW->Search_Typical == 0);
        $operator = $isFuzzySearch ? 'ILIKE' : '=';
        $searchValue = $isFuzzySearch ? "%{$search}%" : $search;
        $isNumeric = is_numeric($search);

        // 2. Build the base query with common mandatory conditions
        $query = ProductUnits::whereRelation('Product', 'Status', 0)
            // Filter for 'Assembly' or 'Service' types
            ->whereIn('P_Type', ['Assembly', 'Service'])
            // Filter for default unit only
            ->where('Def', 1); 

        // 3. Apply search conditions based on whether the search term is numeric
        $query->where(function ($q) use ($search, $searchValue, $operator, $isNumeric) {
            if (!$isNumeric) {
                // Search by product name (P_Ar_Name or P_En_Name)
                // These columns are in the related 'Product' model
                $q->whereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                    $subQuery->where('P_Ar_Name', $operator, $searchValue)
                             ->orWhere('P_En_Name', $operator, $searchValue);
                });
            } else {
                // Search by barcode. Assuming Barcode is on ProductUnits.
                $q->where('Barcode', $operator, $searchValue);
                
                // Add an OR condition for product name search if Barcode search is too narrow
                // Note: The original code didn't have a name OR condition for numeric search,
                // but if the intention is to allow searching by name even if the input is numeric (e.g., '100' is a name), 
                // you would add:
                // ->orWhereRelation('Product', 'P_Ar_Name', $operator, $searchValue);
            }
        });

        // 4. Apply unused filters (Group, Brand) for potential future use
        
        if (!empty($group)) {
            $query->whereRelation('Product', 'Group', $group);
        }
        if (!empty($brand)) {
            $query->whereRelation('Product', 'Brand', $brand);
        }
        

        // 5. Execute and return results
        return $query->limit(100)->get();

    }


    public function FilterSalesProductResturant($search,$Group,$Brand)
    {

      $DefSHOW = DefaultDataShowHide::orderBy('id', 'desc')->first();
        
        // 1. Determine search operator and value
        $isFuzzySearch = ($DefSHOW->Search_Typical == 0);
        $operator = $isFuzzySearch ? 'ILIKE' : '=';
        $searchValue = $isFuzzySearch ? "%{$search}%" : $search;
        $isNumeric = is_numeric($search);

        // 2. Build the base query with common mandatory conditions
        $query = ProductUnits::whereRelation('Product', 'Status', 0)
            // Filter for 'Assembly', 'Service', or 'Variable_Aggregate' types
            ->whereIn('P_Type', ['Assembly', 'Service', 'Variable_Aggregate'])
            // Filter for default unit only
            ->where('Def', 1); 

        // 3. Apply search conditions based on whether the search term is numeric
        $query->where(function ($q) use ($searchValue, $operator, $isNumeric) {
            if (!$isNumeric) {
                // Search by product name (P_Ar_Name or P_En_Name)
                $q->whereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                    $subQuery->where('P_Ar_Name', $operator, $searchValue)
                             ->orWhere('P_En_Name', $operator, $searchValue);
                });
            } else {
                // Search by barcode. Assuming Barcode is on ProductUnits.
                $q->where('Barcode', $operator, $searchValue);
                
                // As noted in previous examples, if you intend to allow name search even for numeric inputs, add:
                // ->orWhereRelation('Product', 'P_Ar_Name', $operator, $searchValue);
            }
        });

        // 4. Apply unused filters (Group, Brand) for potential future use
        
        if (!empty($group)) {
            $query->whereRelation('Product', 'Group', $group);
        }
        if (!empty($brand)) {
            $query->whereRelation('Product', 'Brand', $brand);
        }
        

        // 5. Execute and return results
        return $query->limit(100)->get();

    }

    public function FilterSalesProductWithout($search,$Group,$Brand)
    {

       $DefSHOW = DefaultDataShowHide::orderBy('id', 'desc')->first();
        
        // 1. Determine search operator and value
        $isFuzzySearch = ($DefSHOW->Search_Typical == 0);
        $operator = $isFuzzySearch ? 'ILIKE' : '=';
        $searchValue = $isFuzzySearch ? "%{$search}%" : $search;
        $isNumeric = is_numeric($search);

        // Define the allowed product types
        $allowedProductTypes = [
            'Assembly', 'Service', 'Completed', 'Industrial', 'Additions'
        ];

        // 2. Build the base query with common mandatory conditions
        $query = ProductUnits::whereRelation('Product', 'Status', 0)
            // Filter for the specified product types
            ->whereIn('P_Type', $allowedProductTypes)
            // Filter for default unit only
            ->where('Def', 1); 

        // 3. Apply search conditions based on whether the search term is numeric
        $query->where(function ($q) use ($searchValue, $operator, $isNumeric) {
            if (!$isNumeric) {
                // Search by product name (P_Ar_Name or P_En_Name)
                $q->whereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                    $subQuery->where('P_Ar_Name', $operator, $searchValue)
                             ->orWhere('P_En_Name', $operator, $searchValue);
                });
            } else {
                // Search by barcode. Assuming Barcode is on ProductUnits.
                $q->where('Barcode', $operator, $searchValue);
                
                // If the intention is to allow name search even for numeric inputs, you would add:
                // ->orWhereRelation('Product', 'P_Ar_Name', $operator, $searchValue);
            }
        });

        // 4. Apply unused filters (Group, Brand) for potential future use
        
        if (!empty($group)) {
            $query->whereRelation('Product', 'Group', $group);
        }
        if (!empty($brand)) {
            $query->whereRelation('Product', 'Brand', $brand);
        }
        

        // 5. Execute and return results
        return $query->limit(100)->get();

    }

    public function FilterSalesProductSearchCode($search,$Group,$Brand)
    {

      $DefSHOW = DefaultDataShowHide::orderBy('id', 'desc')->first();
        
        // 1. Determine search operator and value based on DefaultDataShowHide settings
        $isFuzzySearch = ($DefSHOW->Search_Typical == 0);
        $operator = $isFuzzySearch ? 'ILIKE' : '='; // Using ILIKE for case-insensitive search in PostgreSQL
        $searchValue = $isFuzzySearch ? "%{$search}%" : $search;
        $isNumeric = is_numeric($search);

        // 2. Build the base query with common mandatory conditions
        $query = ProductUnits::whereRelation('Product', 'Status', 0) // Product status must be 0
            ->whereIn('P_Type', ['Assembly', 'Service']) // Filter for specific product types
            ->where('Def', 1); // Filter for default unit only

        // 3. Apply search conditions (name or barcode) within a nested WHERE clause
        $query->where(function ($q) use ($searchValue, $operator, $isNumeric) {
            if (!$isNumeric) {
                // If search term is not numeric, search by product name
                $q->whereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                    $subQuery->where('P_Ar_Name', $operator, $searchValue)
                             ->orWhere('P_En_Name', $operator, $searchValue);
                });
            } else {
                // If search term is numeric, search by barcode
                // Assuming 'Barcode' is a column directly on the ProductUnits table.
                $q->where('Barcode', $operator, $searchValue);
                
                // Optional: If you want to allow name search even for numeric input (e.g., product named "123"),
                // you could add an orWhere for names here:
                // ->orWhereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                //     $subQuery->where('P_Ar_Name', $operator, $searchValue)
                //              ->orWhere('P_En_Name', $operator, $searchValue);
                // });
            }
        });

        // 4. Apply Group and Brand filters if they were intended to be used (currently ignored in original logic)
        
        if (!is_null($group)) {
            $query->whereRelation('Product', 'group_id', $group); // Assuming 'group_id' column on Product model
        }
        if (!is_null($brand)) {
            $query->whereRelation('Product', 'brand_id', $brand); // Assuming 'brand_id' column on Product model
        }
        

        // 5. Limit results and execute the query
        return $query->limit(100)->get();

    }
       
    public function FilterSalesProductSearchCodeResturant($search,$Group,$Brand)
    {

      $DefSHOW = DefaultDataShowHide::orderBy('id', 'desc')->first();
        
        // 1. Determine search operator and value based on DefaultDataShowHide settings
        $isFuzzySearch = ($DefSHOW->Search_Typical == 0);
        $operator = $isFuzzySearch ? 'ILIKE' : '='; // Using ILIKE for case-insensitive search in PostgreSQL
        $searchValue = $isFuzzySearch ? "%{$search}%" : $search;
        $isNumeric = is_numeric($search);

        // 2. Build the base query with common mandatory conditions
        $query = ProductUnits::whereRelation('Product', 'Status', 0) // Product status must be 0
            // Filter for specific product types relevant for restaurant sales
            ->whereIn('P_Type', ['Assembly', 'Service', 'Variable_Aggregate'])
            ->where('Def', 1); // Filter for default unit only

        // 3. Apply search conditions (product name or barcode) within a nested WHERE clause
        $query->where(function ($q) use ($searchValue, $operator, $isNumeric) {
            if (!$isNumeric) {
                // If search term is not numeric, search by product name (P_Ar_Name or P_En_Name)
                // These columns are in the related 'Product' model
                $q->whereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                    $subQuery->where('P_Ar_Name', $operator, $searchValue)
                             ->orWhere('P_En_Name', $operator, $searchValue);
                });
            } else {
                // If search term is numeric, search by barcode
                // Assuming 'Barcode' is a column directly on the ProductUnits table.
                $q->where('Barcode', $operator, $searchValue);
                
                // Optional: If you want to allow name search even for numeric input,
                // you could add an orWhere for names here, as '123' might also be part of a name.
                // ->orWhereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                //     $subQuery->where('P_Ar_Name', $operator, $searchValue)
                //              ->orWhere('P_En_Name', $operator, $searchValue);
                // });
            }
        });

        // 4. Apply Group and Brand filters if they were intended to be used (currently ignored in original logic)
        
        if (!is_null($group)) {
            $query->whereRelation('Product', 'group_id', $group); // Assuming 'group_id' column on Product model
        }
        if (!is_null($brand)) {
            $query->whereRelation('Product', 'brand_id', $brand); // Assuming 'brand_id' column on Product model
        }
        

        // 5. Limit results and execute the query
        return $query->limit(100)->get();

    }


    //POS
    public function FilterSalesProductQtyCount($search,$store,$Group,$Brand)
    {

         $DefSHOW = DefaultDataShowHide::latest('id')->first();
        $isFuzzySearch = ($DefSHOW->Search_Typical == 0);
        $operator = $isFuzzySearch ? 'ILIKE' : '=';
        $searchValue = $isFuzzySearch ? "%{$search}%" : $search;

        // 2. Build the base query with common mandatory conditions
        $query = ProductsQty::whereRelation('Product', 'Status', 0)
            ->whereRelation('Product', function ($prodQuery) {
                // Filter for specific product types
                $prodQuery->whereIn('P_Type', [
                    'Completed', 'Industrial', 'Additions', 'Serial',
                    'Single_Variable', 'Duble_Variable'
                ]);
            });

        // 3. Apply search conditions (name, vendor name, and product codes) grouped by WHERE
        $query->where(function ($q) use ($searchValue, $operator) {
            // OR search by Product name (P_Ar_Name, P_En_Name)
            $q->whereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                $subQuery->where('P_Ar_Name', $operator, $searchValue)
                         ->orWhere('P_En_Name', $operator, $searchValue);
            })
            // OR search by Vendor names (V_Name, VV_Name are on ProductsQty table)
            ->orWhere('V_Name', $operator, $searchValue)
            ->orWhere('VV_Name', $operator, $searchValue)
            // OR search by product codes (P_Code, PP_Code, PPP_Code, PPPP_Code are on ProductsQty table)
            ->orWhere('P_Code', $operator, $searchValue)
            ->orWhere('PP_Code', $operator, $searchValue)
            ->orWhere('PPP_Code', $operator, $searchValue)
            ->orWhere('PPPP_Code', $operator, $searchValue);
        });
        
        // 4. Apply store filter (conditional)
        if (!empty($store)) {
            $query->where('Store', $store);
        } else {
            // Note: The original code only ran the query if $store was NOT empty.
            // If $store is empty, it returned $Prodss which was undefined (or null).
            // We return 0 here to explicitly state the count is zero if no store is specified.
            return 0;
        }

        // 5. Execute the count query (efficiently!)
        // Removed ->limit(100) as it is not needed for a count and replaced ->get()->count() with ->count()
        return $query->count();

    }

    public function FilterSalesProductQtyGet($search,$store,$Group,$Brand)
    {

        // 1. Determine search operator and value
        $DefSHOW = DefaultDataShowHide::latest('id')->first();
        $isFuzzySearch = ($DefSHOW->Search_Typical == 0);
        $operator = $isFuzzySearch ? 'ILIKE' : '=';
        $searchValue = $isFuzzySearch ? "%{$search}%" : $search;

        // 2. Build the base query with common mandatory conditions
        $query = ProductsQty::whereRelation('Product', 'Status', 0)
            ->whereRelation('Product', function ($prodQuery) {
                // Filter for specific product types
                $prodQuery->whereIn('P_Type', [
                    'Completed', 'Industrial', 'Additions', 'Serial',
                    'Single_Variable', 'Duble_Variable'
                ]);
            });

        // 3. Apply search conditions (name, vendor name, and product codes) grouped by WHERE
        $query->where(function ($q) use ($searchValue, $operator) {
            // OR search by Product name (P_Ar_Name, P_En_Name)
            $q->whereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                $subQuery->where('P_Ar_Name', $operator, $searchValue)
                         ->orWhere('P_En_Name', $operator, $searchValue);
            })
            // OR search by Vendor names (V_Name, VV_Name are on ProductsQty table)
            ->orWhere('V_Name', $operator, $searchValue)
            ->orWhere('VV_Name', $operator, $searchValue)
            // OR search by product codes (P_Code, PP_Code, PPP_Code, PPPP_Code are on ProductsQty table)
            ->orWhere('P_Code', $operator, $searchValue)
            ->orWhere('PP_Code', $operator, $searchValue)
            ->orWhere('PPP_Code', $operator, $searchValue)
            ->orWhere('PPPP_Code', $operator, $searchValue);
        });
        
        // 4. Apply store filter (conditional)
        if (!empty($store)) {
            $query->where('Store', $store);
        } else {
            // If no store is specified, the original code would return an uninitialized $Prodss.
            // We explicitly return 0 here as the sum would be 0 if no store is considered.
            return 0;
        }

        // 5. Execute the sum query (efficiently!)
        // Removed ->limit(100) as it's not relevant for sum, and replaced ->get()->sum('id') with ->sum('id')
        // Laravel's sum() returns 0 if no records match, which is appropriate here.
        return (int) $query->sum('id'); 

    }

    public function FilterSalesProductQtyCountSearchCode($search,$store,$Group,$Brand)
    {

       // 1. Determine search operator and value
        $DefSHOW = DefaultDataShowHide::latest('id')->first();
        $isFuzzySearch = ($DefSHOW->Search_Typical == 0);
        $operator = $isFuzzySearch ? 'ILIKE' : '=';
        $searchValue = $isFuzzySearch ? "%{$search}%" : $search;

        // 2. Handle case where no store is provided (as per original logic's implicit return)
        if (empty($store)) {
            return 0; // Return 0 if no store is specified, as no results would be found.
        }

        // 3. Build the base query with common mandatory conditions
        $query = ProductsQty::whereRelation('Product', 'Status', 0)
            ->whereRelation('Product', function ($prodQuery) {
                // Filter for specific product types
                $prodQuery->whereIn('P_Type', [
                    'Completed', 'Industrial', 'Additions', 'Serial',
                    'Single_Variable', 'Duble_Variable'
                ]);
            })
            // Apply the custom search code filter
            ->whereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                $subQuery->where('SearchCode1', $operator, $searchValue)
                         ->orWhere('SearchCode2', $operator, $searchValue);
            })
            // Apply the store filter
            ->where('Store', $store);

        // 4. Apply Group and Brand filters if they were intended to be used (currently ignored in original logic)
        /*
        if (!is_null($group)) {
            $query->whereRelation('Product', 'group_id', $group); // Assuming 'group_id' column on Product model
        }
        if (!is_null($brand)) {
            $query->whereRelation('Product', 'brand_id', $brand); // Assuming 'brand_id' column on Product model
        }
        */

        // 5. Execute the count query
        return $query->count();

    }
    

    public function FilterSalesProductQtyGetSearchCode($search,$store,$Group,$Brand)
    {

       // 1. Determine search operator and value
        $DefSHOW = DefaultDataShowHide::latest('id')->first();
        $isFuzzySearch = ($DefSHOW->Search_Typical == 0);
        $operator = $isFuzzySearch ? 'ILIKE' : '=';
        $searchValue = $isFuzzySearch ? "%{$search}%" : $search;

        // 2. Handle case where no store is provided (as per original logic's implicit return)
        if (empty($store)) {
            return 0; // Return 0 if no store is specified, as no sum would be calculated.
        }

        // 3. Build the base query with common mandatory conditions
        $query = ProductsQty::whereRelation('Product', 'Status', 0)
            ->whereRelation('Product', function ($prodQuery) {
                // Filter for specific product types
                $prodQuery->whereIn('P_Type', [
                    'Completed', 'Industrial', 'Additions', 'Serial',
                    'Single_Variable', 'Duble_Variable'
                ]);
            })
            // Apply the custom search code filter
            ->whereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                $subQuery->where('SearchCode1', $operator, $searchValue)
                         ->orWhere('SearchCode2', $operator, $searchValue);
            })
            // Apply the store filter
            ->where('Store', $store);

        // 4. Apply Group and Brand filters if they were intended to be used (currently ignored in original logic)
        
        if (!is_null($group)) {
            $query->whereRelation('Product', 'group_id', $group); // Assuming 'group_id' column on Product model
        }
        if (!is_null($brand)) {
            $query->whereRelation('Product', 'brand_id', $brand); // Assuming 'brand_id' column on Product model
        }
        

        // 5. Execute the sum query (efficiently!)
        // Laravel's sum() returns 0 if no records match, which is appropriate here.
        return (int) $query->sum('id');

    }


    public function FilterSalesProductQtyGroup($Group,$store)
    {


            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)

                    ->whereRelation('Product', 'Group', $Group)
                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })
                    ->where('Store',$store)
                    ->limit(100)
                    ->get();



            }



        return $Prodss ;

    }

    public function FilterSalesProductGroup($Group)
    {

        $data =ProductUnits::whereRelation('Product', 'Status', 0)
            ->whereRelation('Product', 'Group', $Group)
            ->whereIn('P_Type',['Assembly','Service'])
            ->limit(100)
            ->get();


        return $data ;

    }

    public function FilterSalesProductGroupResturant($Group)
    {

        $data =ProductUnits::whereRelation('Product', 'Status', 0)
            ->whereRelation('Product', 'Group', $Group)
            ->whereIn('P_Type',['Assembly','Service','Variable_Aggregate'])
            ->limit(100)
            ->get();


        return $data ;

    }


    public function FilterSalesProductQtyBrand($Group,$store)
    {


            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)

                    ->whereRelation('Product', 'Brand', $Group)
                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })
                    ->where('Store',$store)
                    ->limit(100)
                    ->get();



            }



        return $Prodss ;

    }

    public function FilterSalesProductBrand($Group)
    {

        $data =ProductUnits::whereRelation('Product', 'Status', 0)
            ->whereRelation('Product', 'Brand', $Group)
            ->whereIn('P_Type',['Assembly','Service'])
            ->limit(100)
            ->get();


        return $data ;

    }
    
    public function FilterSalesProductBrandResturant($Group)
    {

        $data =ProductUnits::whereRelation('Product', 'Status', 0)
            ->whereRelation('Product', 'Brand', $Group)
            ->whereIn('P_Type',['Assembly','Service','Variable_Aggregate'])
            ->limit(100)
            ->get();


        return $data ;

    }


    public function FilterSalesProductQtyAll($store)
    {


            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)


                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })
                    ->where('Store',$store)
                    ->limit(200)
                    ->get();



            }



        return $Prodss ;

    }

    public function FilterSalesProductAll()
    {

        $data =ProductUnits::whereRelation('Product', 'Status', 0)

            ->whereIn('P_Type',['Assembly','Service'])
            ->limit(100)
            ->get();


        return $data ;

    }
    
    public function FilterSalesProductAllResturant()
    {

        $data =ProductUnits::whereRelation('Product', 'Status', 0)

            ->whereIn('P_Type',['Assembly','Service','Variable_Aggregate'])
            ->limit(100)
            ->get();


        return $data ;

    }


//Supscribes

    public function FilterSupscribeProduct($search)
    {

      $DefSHOW = DefaultDataShowHide::orderBy('id', 'desc')->first();
        
        // 1. Determine search operator and value based on DefaultDataShowHide settings
        $isFuzzySearch = ($DefSHOW->Search_Typical == 0);
        $operator = $isFuzzySearch ? 'ILIKE' : '='; // Using ILIKE for case-insensitive search in PostgreSQL
        $searchValue = $isFuzzySearch ? "%{$search}%" : $search;
        $isNumeric = is_numeric($search);

        // 2. Build the base query with common mandatory conditions
        $query = ProductUnits::whereRelation('Product', 'Status', 0) // Product status must be 0
            ->where('Def', 1); // Filter for default unit only (assuming 'Def' is on ProductUnits)

        // 3. Apply search conditions (product name or barcode) within a nested WHERE clause
        $query->where(function ($q) use ($searchValue, $operator, $isNumeric) {
            if (!$isNumeric) {
                // If search term is not numeric, search by product name
                // These columns are in the related 'Product' model
                $q->whereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                    $subQuery->where('P_Ar_Name', $operator, $searchValue)
                             ->orWhere('P_En_Name', $operator, $searchValue);
                });
            } else {
                // If search term is numeric, search by barcode
                // Assuming 'Barcode' is a column directly on the ProductUnits table.
                $q->where('Barcode', $operator, $searchValue);
                
                // Optional: If you want to allow name search even for numeric input,
                // you could add an orWhere for names here:
                // ->orWhereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                //     $subQuery->where('P_Ar_Name', $operator, $searchValue)
                //              ->orWhere('P_En_Name', $operator, $searchValue);
                // });
            }
        });

        // 4. Limit results and execute the query
        return $query->limit(100)->get();

    }




// ================  FIFO Functions  =========================

    public function FindQty($store,$product,$code,$id,$Purchases_Date){


             
        $rr=ProductUnits::where('Product',$product)->where('Def',1)->first();
        
                 // Define the common base query
        $baseQuery = FifoQty::where('Store', $store)
                            ->where('Product', $product)
                              ->where('id','!=',$id)
                         ->where('Purchases_Date','>',$Purchases_Date);

        // Define the columns to search for the code
        $codeColumns = ['P_Code', 'PP_Code', 'PPP_Code', 'PPPP_Code'];

        // Build the OR conditions for the codes
        $fifo = $baseQuery->where(function ($query) use ($code, $codeColumns) {
            foreach ($codeColumns as $column) {
                $query->orWhere($column, $code);
            }
        })->first();
        
        
   
        if(!empty($fifo)){

            if($fifo->Qty == 0){



                $Quntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);



            }else{
                $qty = $fifo->Qty ;
            }


        }

        return  $qty  ;


    }


    public function MoreThanQty($store,$product,$code,$id,$Purchases_Date,$Qty){


                
        $rr=ProductUnits::where('Product',$product)->where('Def',1)->first();
        
                 // Define the common base query
        $baseQuery = FifoQty::where('Store', $store)
                            ->where('Product', $product)
                              ->where('id','!=',$id)
                         ->where('Purchases_Date','>',$Purchases_Date);

        // Define the columns to search for the code
        $codeColumns = ['P_Code', 'PP_Code', 'PPP_Code', 'PPPP_Code'];

        // Build the OR conditions for the codes
        $fifo = $baseQuery->where(function ($query) use ($code, $codeColumns) {
            foreach ($codeColumns as $column) {
                $query->orWhere($column, $code);
            }
        })->first();
        
        

        $totCost=0;

        if(!empty($fifo)){


            if($fifo->Qty == 0){



                $Quntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                if($Quntatity == 0){


                    $Quntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                }else{



                    if($Quntatity >= $Qty){

                        $totCost += $fifo->Cost_Price * $Qty ;

                    }else{

                        $res=$Qty - $Quntatity ;


                        $totCost += $fifo->Cost_Price * $Quntatity ;

                        $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                        $totCost +=$ResdiualCost;

                    }


                }



            }else{


                if($fifo->Qty >= $Qty){

                    $totCost += $fifo->Cost_Price * $Qty ;

                }else{

                    $res=$Qty - $fifo->Qty ;


                    $totCost += $fifo->Cost_Price * $fifo->Qty ;

                    $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                    $totCost +=$ResdiualCost;

                }



            }


        }

        return  $totCost  ;


    }


    public function FifoStoreQty($store,$product,$code,$id,$Purchases_Date,$Qty,$Unit,$SalesID){

              $rr=ProductUnits::where('Product',$product)->where('Def',1)->first();
        
                 // Define the common base query
        $baseQuery = FifoQty::where('Store', $store)
                            ->where('Product', $product)
                              ->where('id','!=',$id)
                         ->where('Purchases_Date','>',$Purchases_Date);

        // Define the columns to search for the code
        $codeColumns = ['P_Code', 'PP_Code', 'PPP_Code', 'PPPP_Code'];

        // Build the OR conditions for the codes
        $fifo = $baseQuery->where(function ($query) use ($code, $codeColumns) {
            foreach ($codeColumns as $column) {
                $query->orWhere($column, $code);
            }
        })->first();
        
        


        if(!empty($fifo)){

            if($fifo->Qty >= $Qty){


                $unit=ProductUnits::where('Unit',$Unit)->where('Product',$product)->first();

                $qq= $unit->Rate * $Qty ;

                $newqty=$fifo->Qty -  $qq ;

                FifoQty::where('id',$fifo->id)->update(['Qty'=>$newqty]);


                $fifQty['Sales_Qty']=$Qty;
                $fifQty['Sales_ID']=$SalesID;
                $fifQty['Fifo_ID']=$fifo->id;
                $fifQty['Store']=$fifo->Store;
                $fifQty['Product']=$fifo->Product;
                $fifQty['Cost_Price']=$fifo->Cost_Price;
                $fifQty['Purchases_Date']=$fifo->Purchases_Date;

                SalesFifoQty::create($fifQty);




            }else{


                $resdiualQty=$Qty - $fifo->Qty ;

                $unit=ProductUnits::where('Unit',$Unit)->where('Product',$product)->first();

                $qq= $unit->Rate * $fifo->Qty ;

                $newqty=$fifo->Qty -  $qq ;

                FifoQty::where('id',$fifo->id)->update(['Qty'=>$newqty]);


                $fifQty['Sales_Qty']=$fifo->Qty;
                $fifQty['Sales_ID']=$SalesID;
                $fifQty['Fifo_ID']=$fifo->id;
                $fifQty['Store']=$fifo->Store;
                $fifQty['Product']=$fifo->Product;
                $fifQty['Cost_Price']=$fifo->Cost_Price;
                $fifQty['Purchases_Date']=$fifo->Purchases_Date;

                SalesFifoQty::create($fifQty);





                $ResdiualCost=$this->FifoStoreQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$resdiualQty,$Unit,$SalesID);





            }


        }



        return  $newqty  ;


    }
    
    public function FifoStoreHoldQty($store,$product,$code,$id,$Purchases_Date,$Qty,$Unit,$SalesID){

               $rr=ProductUnits::where('Product',$product)->where('Def',1)->first();
        
                 // Define the common base query
        $baseQuery = FifoQty::where('Store', $store)
                            ->where('Product', $product)
                              ->where('id','!=',$id)
                         ->where('Purchases_Date','>',$Purchases_Date);

        // Define the columns to search for the code
        $codeColumns = ['P_Code', 'PP_Code', 'PPP_Code', 'PPPP_Code'];

        // Build the OR conditions for the codes
        $fifo = $baseQuery->where(function ($query) use ($code, $codeColumns) {
            foreach ($codeColumns as $column) {
                $query->orWhere($column, $code);
            }
        })->first();
        
        


        if(!empty($fifo)){

            if($fifo->Qty >= $Qty){


                $unit=ProductUnits::where('Unit',$Unit)->where('Product',$product)->first();

                $qq= $unit->Rate * $Qty ;

                $newqty=$fifo->Qty -  $qq ;

                $hold_qty_fifo = $fifo->Hold_Qty + $qq;

                FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty,'Hold_Qty'=>$hold_qty_fifo]);



            }else{


                $resdiualQty=$Qty - $fifo->Qty ;

                $unit=ProductUnits::where('Unit',$Unit)->where('Product',$product)->first();

                $qq= $unit->Rate * $fifo->Qty ;

                $newqty=$fifo->Qty -  $qq ;



                $hold_qty_fifo = $fifo->Hold_Qty + $qq;

                FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty,'Hold_Qty'=>$hold_qty_fifo]);


                $ResdiualCost=$this->FifoStoreHoldQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$resdiualQty,$Unit,$SalesID);





            }


        }



        return  $newqty  ;


    }


    public function FifoStoreAssemblyQty($store,$product,$code,$id,$Purchases_Date,$Qty,$Unit,$AssQty,$SalesID){

               $rr=ProductUnits::where('Product',$product)->where('Def',1)->first();
        
                 // Define the common base query
        $baseQuery = FifoQty::where('Store', $store)
                            ->where('Product', $product)
                              ->where('id','!=',$id)
                         ->where('Purchases_Date','>',$Purchases_Date);

        // Define the columns to search for the code
        $codeColumns = ['P_Code', 'PP_Code', 'PPP_Code', 'PPPP_Code'];

        // Build the OR conditions for the codes
        $fifo = $baseQuery->where(function ($query) use ($code, $codeColumns) {
            foreach ($codeColumns as $column) {
                $query->orWhere($column, $code);
            }
        })->first();
        
        


        if(!empty($fifo)){

            if($fifo->Qty >= ($Qty * $AssQty) ){


                $unit=ProductUnits::where('Unit',$Unit)->where('Product',$product)->first();

                $qq= $unit->Rate * ($Qty * $AssQty) ;

                $newqty=$fifo->Qty -  $qq ;

                FifoQty::where('id',$fifo->id)->update(['Qty'=>$newqty]);



                $fifQty['Sales_Qty']=($Qty * $AssQty);
                $fifQty['Sales_ID']=$SalesID;
                $fifQty['Fifo_ID']=$fifo->id;
                $fifQty['Store']=$fifo->Store;
                $fifQty['Product']=$fifo->Product;
                $fifQty['Cost_Price']=$fifo->Cost_Price;
                $fifQty['Purchases_Date']=$fifo->Purchases_Date;

                SalesFifoQty::create($fifQty);

            }else{


                $resdiualQty=($Qty * $AssQty)  - $fifo->Qty ;

                $unit=ProductUnits::where('Unit',$Unit)->where('Product',$product)->first();

                $qq= $unit->Rate * ($fifo->Qty  * $AssQty);

                $newqty=$fifo->Qty -  $qq ;

                FifoQty::where('id',$fifo->id)->update(['Qty'=>$newqty]);


                $fifQty['Sales_Qty']=$fifo->Qty;
                $fifQty['Sales_ID']=$SalesID;
                $fifQty['Fifo_ID']=$fifo->id;
                $fifQty['Store']=$fifo->Store;
                $fifQty['Product']=$fifo->Product;
                $fifQty['Cost_Price']=$fifo->Cost_Price;
                $fifQty['Purchases_Date']=$fifo->Purchases_Date;

                SalesFifoQty::create($fifQty);

                $ResdiualCost=$this->FifoStoreAssemblyQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$resdiualQty,$Unit,$AssQty,$SalesID);



            }


        }



        return  $newqty  ;


    }


    public function FifoStoreAssemblyHoldQty($store,$product,$code,$id,$Purchases_Date,$Qty,$Unit,$AssQty,$SalesID){

            $rr=ProductUnits::where('Product',$product)->where('Def',1)->first();
        
                 // Define the common base query
        $baseQuery = FifoQty::where('Store', $store)
                            ->where('Product', $product)
                              ->where('id','!=',$id)
                         ->where('Purchases_Date','>',$Purchases_Date);

        // Define the columns to search for the code
        $codeColumns = ['P_Code', 'PP_Code', 'PPP_Code', 'PPPP_Code'];

        // Build the OR conditions for the codes
        $fifo = $baseQuery->where(function ($query) use ($code, $codeColumns) {
            foreach ($codeColumns as $column) {
                $query->orWhere($column, $code);
            }
        })->first();
        
        



        if(!empty($fifo)){

            if($fifo->Qty >= ($Qty * $AssQty) ){


                $unit=ProductUnits::where('Unit',$Unit)->where('Product',$product)->first();

                $qq= $unit->Rate * ($Qty * $AssQty) ;

                $newqty=$fifo->Qty -  $qq ;

                $hold_qty_fifo = $fifo->Hold_Qty + $qq;

                FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty,'Hold_Qty'=>$hold_qty_fifo]);



            }else{


                $resdiualQty=($Qty * $AssQty)  - $fifo->Qty ;

                $unit=ProductUnits::where('Unit',$Unit)->where('Product',$product)->first();

                $qq= $unit->Rate * ($fifo->Qty  * $AssQty);

                $newqty=$fifo->Qty -  $qq ;

                $hold_qty_fifo = $fifo->Hold_Qty + $qq;

                FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty,'Hold_Qty'=>$hold_qty_fifo]);




                $ResdiualCost=$this->FifoStoreAssemblyHoldQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$resdiualQty,$Unit,$AssQty,$SalesID);



            }


        }



        return  $newqty  ;


    }




    //======================================================================

    //Manfacturing Filter =======================================

    public function FilterManuProduct($search)
    {


      $DefSHOW = DefaultDataShowHide::orderBy('id', 'desc')->first();
        
        // 1. Determine search operator and value based on DefaultDataShowHide settings
        $isFuzzySearch = ($DefSHOW->Search_Typical == 0);
        $operator = $isFuzzySearch ? 'ILIKE' : '='; // Using ILIKE for case-insensitive search in PostgreSQL
        $searchValue = $isFuzzySearch ? "%{$search}%" : $search;
        $isNumeric = is_numeric($search);

        // Define the allowed product types for manufacturing
        $allowedProductTypes = [
            'Completed', 'Raw', 'Industrial', 'Service'
        ];

        // 2. Build the base query with common mandatory conditions
        $query = ProductUnits::whereRelation('Product', 'Status', 0) // Product status must be 0
            // Filter for specific product types relevant for manufacturing
            ->whereIn('P_Type', $allowedProductTypes);

        // 3. Apply search conditions (product name or barcode) within a nested WHERE clause
        $query->where(function ($q) use ($searchValue, $operator, $isNumeric) {
            if (!$isNumeric) {
                // If search term is not numeric, search by product name
                // These columns are in the related 'Product' model
                $q->whereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                    $subQuery->where('P_Ar_Name', $operator, $searchValue)
                             ->orWhere('P_En_Name', $operator, $searchValue);
                });
            } else {
                // If search term is numeric, search by barcode
                // Assuming 'Barcode' is a column directly on the ProductUnits table.
                $q->where('Barcode', $operator, $searchValue);
                
                // Optional: If you want to allow name search even for numeric input,
                // you could add an orWhere for names here:
                // ->orWhereRelation('Product', function ($subQuery) use ($searchValue, $operator) {
                //     $subQuery->where('P_Ar_Name', $operator, $searchValue)
                //              ->orWhere('P_En_Name', $operator, $searchValue);
                // });
            }
        });

        // Note: The original code does NOT have ->where('Def', 1) in this function, unlike previous ones.
        // If this was an oversight, you might want to add it. For now, it's omitted as per original.

        // 4. Limit results and execute the query
        return $query->limit(100)->get();

    }


    //Profit  and Capital =======================================
    
    
    //Total Profit
    public function TOTALPROFIT($from,$to)
    {
        $AEryd=AcccountingManual::where('id',18)->first();


        if($AEryd->Parent == 0){

            $words=$AEryd->Code.'0';
            $wordsX=$AEryd->Code.'1';

        }else{

            $words=$AEryd->Code;
            $wordsX=$AEryd->Code;

        }

        $egmalymby3atDa2n=GeneralDaily::where('Account',48)
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Creditor_Coin');
        $egmalymby3atMadeen=GeneralDaily::where('Account',48)
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Debitor_Coin');

        $egmalymrdodatDa2n=GeneralDaily::where('Account',49)
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Creditor_Coin');

        $egmalymrdodatMadeen=GeneralDaily::where('Account',49)
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Debitor_Coin');

        $safy = abs($egmalymby3atDa2n - $egmalymby3atMadeen) -  abs($egmalymrdodatDa2n - $egmalymrdodatMadeen);


        $TotalDebErydat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $words.'%')
            ->orWhere('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to)  {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $words.'%')
            ->orWhere('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');


        $EgmalyErydaat=  $TotalCredErydat -  $TotalDebErydat ;



        $ATaklfa=AcccountingManual::where('id',19)->first();

        if($ATaklfa->Parent == 0){

            $wordss=$ATaklfa->Code.'0';
            $wordssX=$ATaklfa->Code.'1';

        }else{

            $wordss=$ATaklfa->Code;
            $wordssX=$ATaklfa->Code;

        }

        $TotalDebTaklfa = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to)  {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordss.'%')
            ->orWhere('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfa = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to)  {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordss.'%')
            ->orWhere('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');


        $EgmalyTaklfa=  $TotalDebTaklfa -  $TotalCredTaklfa ;



        $Mogml = $EgmalyErydaat   -  $EgmalyTaklfa   ;


        $AMsrfoat=AcccountingManual::where('id',20)->first();

        if($AMsrfoat->Parent == 0){

            $wordsss=$AMsrfoat->Code.'0';
            $wordsssX=$AMsrfoat->Code.'1';

        }else{

            $wordsss=$AMsrfoat->Code;
            $wordsssX=$AMsrfoat->Code;


        }



        if(app()->getLocale() == 'ar' ){
            $xxxName=$AMsrfoat->Name;

        }else{
            $xxxName=$AMsrfoat->NameEn;

        }

        $TotalDebMasrofat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to)  {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->orWhere('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to)  {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->orWhere('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');


        $EgmalyMasrofat=  $TotalDebMasrofat -  $TotalCredMasrofat ;


        $fg= $EgmalyTaklfa + $EgmalyMasrofat;
        if($EgmalyErydaat >  $fg){
            if($fg  <  0 ){

                $SafyRab7 =$EgmalyErydaat + ($EgmalyTaklfa  +   $EgmalyMasrofat)  ;
            }else{

                $SafyRab7 = $EgmalyErydaat -  ($EgmalyTaklfa  +   $EgmalyMasrofat)  ;

            }
        }elseif($EgmalyErydaat <  $fg){

            if($fg  <  0 ){

                $SafyRab7 =$EgmalyErydaat + ($EgmalyTaklfa  +   $EgmalyMasrofat)  ;
            }else{

                $SafyRab7 = $EgmalyErydaat -  ($EgmalyTaklfa  +   $EgmalyMasrofat)  ;

            }


        }elseif($EgmalyErydaat ==  $fg){

            $SafyRab7 = $EgmalyErydaat -  ($EgmalyTaklfa  +   $EgmalyMasrofat)  ;

        }



        return $SafyRab7 ;

    }


    //Total Capital
    public function TOTALCAPITAL()
    {

        $to=date('Y-m-d');
        //   =============  Asoul Sabta   ===========
        $ASabta=AcccountingManual::where('id',21)->first();
        if($ASabta->Parent == 0){

            $wordsSabta=$ASabta->Code.'0';

        }else{

            $wordsSabta=$ASabta->Code;

        }

        $TotalDebAsoulSabta = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsSabta.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredAsoulSabta = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsSabta.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');


        $EgmalyAsoulSabta=$TotalDebAsoulSabta - $TotalCredAsoulSabta ;


        //   End Asoul Sabta ====================================


        //   =============  Asoul Mtdawla   ===========

        $Amtdawla=AcccountingManual::where('id',22)->first();

        if($Amtdawla->Parent == 0){

            $wordsMtdawla=$Amtdawla->Code.'0';

        }else{

            $wordsMtdawla=$Amtdawla->Code;

        }

        $TotalDebAsoulMtadawla = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsMtdawla.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredAsoulMtadawla = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsMtdawla.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyAsoulMtadawla=$TotalDebAsoulMtadawla - $TotalCredAsoulMtadawla ;

        //   End Asoul Mtdawla  ====================================


        //   =============  Asoul Okhra   ===========

        $AOther=AcccountingManual::where('id',147)->first();

        if($AOther->Parent == 0){

            $wordsOther=$AOther->Code.'0';

        }else{

            $wordsOther=$AOther->Code;

        }


        $TotalDebAsoulOkhraa = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsOther.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredAsoulOkhraa = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsOther.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyAsoulOkhraa=$TotalDebAsoulOkhraa - $TotalCredAsoulOkhraa ;

        //   End Asoul Okhra  ====================================

        //  Asoul  ======================================
        $EgmalyAsoul=$EgmalyAsoulSabta + $EgmalyAsoulMtadawla + $EgmalyAsoulOkhraa ;

        //  Asoul End ======================================


        //  Khsoum  =========================


        $ATaklfa=AcccountingManual::where('id',16)->first();

        if($ATaklfa->Parent == 0){

            $wordss=$ATaklfa->Code.'0';

        }else{

            $wordss=$ATaklfa->Code;

        }




        $TotalDebKhsoum = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredKhsoum = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyKhsoum= $TotalCredKhsoum  - $TotalDebKhsoum ;


        // End  Khsoum  =========================


        //  Khsoum Tawela  =========================

        $ATaklfaTweel=AcccountingManual::where('id',148)->first();

        if($ATaklfaTweel->Parent == 0){

            $wordssTweel=$ATaklfaTweel->Code.'0';

        }else{

            $wordssTweel=$ATaklfaTweel->Code;

        }


        $TotalDebKhsoumTweel = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssTweel.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredKhsoumTweel = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssTweel.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyKhsoumTweel= $TotalCredKhsoumTweel  - $TotalDebKhsoumTweel ;

        //  End Khsoum Tweel ========================

        //   Khsoum Qaserr ========================

        $EgmalyKhsoumQaserr= $EgmalyKhsoum -  $EgmalyKhsoumTweel;

        //  End Khsoum Qaserr ========================

        //  Ras Mal #aml + Estsmar ========================

        $RasMal3aml=$EgmalyAsoulMtadawla - $EgmalyKhsoumQaserr;


        $Estsmar=$RasMal3aml + $EgmalyAsoulSabta + $EgmalyAsoulOkhraa ;

        // End  Ras Mal #aml + Estsmar ========================


        $data=['capital'=>$RasMal3aml , 'invest'=>$Estsmar ];
        return $data ;

    }
    
    
    public function NEWTOTALCAPITAL($from,$to)
    {


        //   =============  Asoul Sabta   ===========
        $ASabta=AcccountingManual::where('id',21)->first();
        if($ASabta->Parent == 0){

            $wordsSabta=$ASabta->Code.'0';

        }else{

            $wordsSabta=$ASabta->Code;

        }

        $TotalDebAsoulSabta = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsSabta.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredAsoulSabta = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                      ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsSabta.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');


        $EgmalyAsoulSabta=$TotalDebAsoulSabta - $TotalCredAsoulSabta ;


        //   End Asoul Sabta ====================================


        //   =============  Asoul Mtdawla   ===========

        $Amtdawla=AcccountingManual::where('id',22)->first();

        if($Amtdawla->Parent == 0){

            $wordsMtdawla=$Amtdawla->Code.'0';

        }else{

            $wordsMtdawla=$Amtdawla->Code;

        }

        $TotalDebAsoulMtadawla = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsMtdawla.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredAsoulMtadawla = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                      ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsMtdawla.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyAsoulMtadawla=$TotalDebAsoulMtadawla - $TotalCredAsoulMtadawla ;

        //   End Asoul Mtdawla  ====================================


        //   =============  Asoul Okhra   ===========

        $AOther=AcccountingManual::where('id',147)->first();

        if($AOther->Parent == 0){

            $wordsOther=$AOther->Code.'0';

        }else{

            $wordsOther=$AOther->Code;

        }


        $TotalDebAsoulOkhraa = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                      ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsOther.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredAsoulOkhraa = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsOther.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyAsoulOkhraa=$TotalDebAsoulOkhraa - $TotalCredAsoulOkhraa ;

        //   End Asoul Okhra  ====================================

        //  Asoul  ======================================
        $EgmalyAsoul=$EgmalyAsoulSabta + $EgmalyAsoulMtadawla + $EgmalyAsoulOkhraa ;

        //  Asoul End ======================================


        //  Khsoum  =========================


        $ATaklfa=AcccountingManual::where('id',16)->first();

        if($ATaklfa->Parent == 0){

            $wordss=$ATaklfa->Code.'0';

        }else{

            $wordss=$ATaklfa->Code;

        }




        $TotalDebKhsoum = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                   ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredKhsoum = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                     ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyKhsoum= $TotalCredKhsoum  - $TotalDebKhsoum ;


        // End  Khsoum  =========================


        //  Khsoum Tawela  =========================

        $ATaklfaTweel=AcccountingManual::where('id',148)->first();

        if($ATaklfaTweel->Parent == 0){

            $wordssTweel=$ATaklfaTweel->Code.'0';

        }else{

            $wordssTweel=$ATaklfaTweel->Code;

        }


        $TotalDebKhsoumTweel = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                      ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssTweel.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredKhsoumTweel = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                      ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssTweel.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyKhsoumTweel= $TotalCredKhsoumTweel  - $TotalDebKhsoumTweel ;

        //  End Khsoum Tweel ========================

        //   Khsoum Qaserr ========================

        $EgmalyKhsoumQaserr= $EgmalyKhsoum -  $EgmalyKhsoumTweel;

        //  End Khsoum Qaserr ========================

        //  Ras Mal #aml + Estsmar ========================

        $RasMal3aml=$EgmalyAsoulMtadawla - $EgmalyKhsoumQaserr;


        $Estsmar=$RasMal3aml + $EgmalyAsoulSabta + $EgmalyAsoulOkhraa ;

        // End  Ras Mal #aml + Estsmar ========================


        $data=['capital'=>$RasMal3aml , 'invest'=>$Estsmar ];
        return $data ;

    }



//Api =========================================================

    public function getCurrentLang()
    {
        return app()->getLocale();
    }

    public function returnError($msg)
    {
        return response()->json([
            'status' => 404,
            'msg' => $msg
        ]);
    }
    public function returnErrorKey($msg,$key)
    {
        return response()->json([
            'status' => 404,
            'msg' => $msg,
            $key => false
        ]);
    }


    public function returnSuccessMessage($msg = "")
    {
        return [
            'status' => 200,
            'msg' => $msg
        ];
    }

    public function returnData($key, $value, $msg = "")
    {
        return response()->json([
            'status' => 200,
            'msg' => $msg,
            $key => $value
        ]);
    }
    public function returnDataLocation($key, $value, $msg = "",$open)
    {
        return response()->json([
            'status' => 200,
            'msg' => $msg,
            $key => $value,
            'open' => $open,
        ]);
    }

    public function returnValidationError($code, $validator)
    {
        return $this->returnError($validator->errors()->first());
    }

    public function returnCodeAccordingToInput($validator)
    {
        $inputs = array_keys($validator->errors()->toArray());
        $code =0;
        return $code;
    }
    //========================================================



    public function BarcodeShipment($Code,$Breakable,$Sender_City,$Receiver_City,$Shipment_Type,$Shipment_Category){

        $SCity=City::find($Sender_City);
        $RCity=City::find($Receiver_City);
  
        $category=NewShippingCategories::find($Shipment_Category);


        $year=date('Y');
        $month=date('m');
        $day=date('d');
        $from_city=$SCity->ShippingCode;
        $to_city=$RCity->ShippingCode;
        $cat_ship=$category->Code;

        if($Breakable == 'Yes'){
            $break='01';
        }else{

            $break='00';
        }




        $barcode=$year.$month.$day.$from_city.$to_city.$cat_ship.$break.$Code;

        return $barcode ;

    }

}
