<?php

namespace App\Services;
use App\Http\Controllers\HRController;
use App\Models\Attendance;
use App\Models\CompanyData;
use App\Models\Departure;
use App\Models\Employess;
use App\Models\ModuleSettingsNum;
use Spatie\DbDumper\Databases\PostgreSql;
use DB;
use Illuminate\Support\Facades\Log;
class Auto
{



    public function BackupDB()
    {


        @ini_set('max_execution_time', 0);
        @set_time_limit(0);
        ini_set('memory_limit', '-1');

        try {
            DB::beginTransaction();

            $def=CompanyData::orderBy('id','desc')->first();

            $backup_name = $def->Name.'-Rabih-' . date('c')  . '.sql';

            PostgreSql::create()
                ->setDbName(env('DB_DATABASE'))
                ->setUserName(env('DB_USERNAME'))
                ->setPassword(env('DB_PASSWORD'))
                ->dumpToFile($backup_name);

            DB::commit();

            return 0 ;

        }catch(\Exception $ex){


            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");



        }catch(\Error $ex){



            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");



        }


    }

    public function BackupAttendence()
    {


        @ini_set('max_execution_time', 0);
        @set_time_limit(0);
        ini_set('memory_limit', '-1');

        try {
            DB::beginTransaction();



                //Attendence Function
            $setting=ModuleSettingsNum::orderBy('id','desc')->first();

            if($setting->Fingerprint == 1){



                $currentDate = date('Y-m-d');
                $IfAttendDate=Attendance::where('Date',$currentDate)->count();
                $IfDepDate=Departure::where('Date',$currentDate)->count();


                if($IfDepDate != 0){

                    return 2 ;
                }else {
                    $Use = new HRController();
                    $Use->RegisterAttendanceFP();
                    return 1 ;
                }




            }else{return 3 ;}



            DB::commit();

            return 0 ;


        }catch(\Exception $ex){


            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");



        }catch(\Error $ex){



            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");



        }


    }

    public function SalaryDue()
    {


        try {

            DB::beginTransaction();
            \App\Events\SalaryDue::dispatch();
            DB::commit();

            return 0 ;
        }catch(\Exception $ex){

            $MODEL=Employess::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");


        }catch(\Error $ex){


            $MODEL=Employess::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");



        }


    }



}



