<?php

namespace App\Providers;

use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;

use  App\Events\IncomCheckEvent;
use  App\Events\ExportChecksEvent;
use  App\Events\InsurancePaperEvent;

use  App\Events\CreateAccountManualEvent;
use  App\Events\EditAccountManualEvent;
use  App\Events\DeleteAccountManualEvent;

use  App\Events\AddJournalizingEvent;
use  App\Events\SureJournalizingEvent;

use  App\Events\AddReciptVoucherEvent;
use  App\Events\SureReciptVoucherEvent;

use  App\Events\AddPaymentVoucherEvent;
use  App\Events\SurePaymentVoucherEvent;

use  App\Events\AddOpeningEntriesEvent;
use  App\Events\SureOpeningEntriesEvent;
use  App\Events\AssetsMonthlyEvent;
use  App\Events\AssetsEvent;
use  App\Events\SalesEventApi;

use  App\Events\AddProductEvent;

use  App\Events\PurchasesEvent;
use  App\Events\ReturnPurchasesEvent;
use  App\Events\SalesEvent;
use  App\Events\SalesOrderEvent;
use  App\Events\ReturnSalesEvent;
use  App\Events\SalesSubscribesEvent;
use  App\Events\JobOrderEvent;
use  App\Events\ReturnWithoutEvent;
use  App\Events\StartPeriodEvent;
use  App\Events\SettlementEvent;
use  App\Events\ConsistEvent;
use  App\Events\StoresTransferEvent;
use  App\Events\StoresTransferApiEvent;
use  App\Events\ReturnSalesEventApi;
use  App\Events\SalaryDue;
use  App\Events\ManyfacturingEvent;
use  App\Events\SalesGiftsEvent;
use  App\Events\InvestorsDue;


use  App\Listeners\IncomChecks\IncomChecksListener;

use  App\Listeners\AccountManual\CreateAccountManualEventListener;
use  App\Listeners\AccountManual\EditAccountManualEventListener;
use  App\Listeners\AccountManual\DeleteAccountManualEventListener;

use  App\Listeners\Journalizing\AddJournalizingListener;
use  App\Listeners\Journalizing\SureJournalizingListener;

use  App\Listeners\ReciptVoucher\AddReciptVoucherListener;
use  App\Listeners\ReciptVoucher\SureReciptVoucherListener;

use  App\Listeners\PaymentVoucher\AddPaymentVoucherListener;
use  App\Listeners\PaymentVoucher\SurePaymentVoucherListener;

use  App\Listeners\OpeningEntries\AddOpeningEntriesListener;
use  App\Listeners\OpeningEntries\SureOpeningEntriesListener;

use  App\Listeners\ExportChecks\ExportChecksListener;
use  App\Listeners\Insurance\InsurancePaperListener;
use  App\Listeners\Assets\AssetsMonthlyListener;
use  App\Listeners\Assets\AssetsListener;
use  App\Listeners\Products\AddProductListener;

use  App\Listeners\Purchases\PurchasesListener;
use  App\Listeners\Purchases\PurchasesJounListener;
use  App\Listeners\Purchases\ReturnPurchasesListener;
use  App\Listeners\Purchases\ReturnPurchasesJounListener;

use  App\Listeners\Sales\SalesListener;
use  App\Listeners\Sales\SalesJounListener;
use  App\Listeners\Sales\SalesApiListener;
use  App\Listeners\Sales\SalesJounApiListener;
use  App\Listeners\Sales\ReturnSalesListener;
use  App\Listeners\SalesOrder\SalesOrderListener;
use  App\Listeners\Subscribes\SalesSubscribesListener;
use  App\Listeners\JobOrder\JobOrderListener;
use  App\Listeners\ReturnWithout\ReturnWithoutListener;
use  App\Listeners\StartPeriod\StartPeriodListener;
use  App\Listeners\Settlement\SettlementListener;
use  App\Listeners\Consist\ConsistListener;
use  App\Listeners\StoresTransfer\StoresTransferListener;
use  App\Listeners\StoresTransfer\StoresTransferApiListener;
use  App\Listeners\Sales\ReturnSalesApiListener;
use  App\Listeners\HR\SalaryDueListener;
use  App\Listeners\Manufacturing\ManyfacturingListener;
use  App\Listeners\Gifts\SalesGiftsListener;
use  App\Listeners\Investors\InvestorsDueListener;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [

        IncomCheckEvent::class => [
            IncomChecksListener::class,
        ],


        CreateAccountManualEvent::class => [
            CreateAccountManualEventListener::class,
        ],

        EditAccountManualEvent::class => [
            EditAccountManualEventListener::class,
        ],


        DeleteAccountManualEvent::class => [
            DeleteAccountManualEventListener::class,
        ],


        AddJournalizingEvent::class => [
            AddJournalizingListener::class,
        ],


        SureJournalizingEvent::class => [
            SureJournalizingListener::class,
        ],

        AddReciptVoucherEvent::class => [
            AddReciptVoucherListener::class,
        ],


        SureReciptVoucherEvent::class => [
            SureReciptVoucherListener::class,
        ],

        AddPaymentVoucherEvent::class => [
            AddPaymentVoucherListener::class,
        ],

        SurePaymentVoucherEvent::class => [
            SurePaymentVoucherListener::class,
        ],


        AddOpeningEntriesEvent::class => [
            AddOpeningEntriesListener::class,
        ],


        SureOpeningEntriesEvent::class => [
            SureOpeningEntriesListener::class,
        ],


        ExportChecksEvent::class => [
            ExportChecksListener::class,
        ],


        InsurancePaperEvent::class => [
            InsurancePaperListener::class,
        ],

        AssetsMonthlyEvent::class => [
            AssetsMonthlyListener::class,
        ],
                AssetsEvent::class => [
            AssetsListener::class,
        ],

                 AddProductEvent::class => [
            AddProductListener::class,
        ],

        PurchasesEvent::class => [
            PurchasesListener::class,
            PurchasesJounListener::class,
        ],

        SalesEvent::class => [
            SalesListener::class,
            SalesJounListener::class,
        ],

               ReturnPurchasesEvent::class => [
            ReturnPurchasesListener::class,
            ReturnPurchasesJounListener::class,
        ],

        SalesOrderEvent::class => [
            SalesOrderListener::class,

        ],

        ReturnSalesEvent::class => [
            ReturnSalesListener::class,

        ],
        ReturnSalesEventApi::class => [
            ReturnSalesApiListener::class,

        ],

        SalesSubscribesEvent::class => [
            SalesSubscribesListener::class,

        ],

        JobOrderEvent::class => [
            JobOrderListener::class,

        ],
        ReturnWithoutEvent::class => [
            ReturnWithoutListener::class,

        ],
        StartPeriodEvent::class => [
            StartPeriodListener::class,

        ],

        SettlementEvent::class => [
            SettlementListener::class,

        ],

        ConsistEvent::class => [
            ConsistListener::class,

        ],

        StoresTransferEvent::class => [
            StoresTransferListener::class,

        ],


        StoresTransferApiEvent::class => [
            StoresTransferApiListener::class,

        ],

        SalesEventApi::class => [
            SalesApiListener::class,
            SalesJounApiListener::class,

        ],

        SalaryDue::class => [
            SalaryDueListener::class,

        ],
        ManyfacturingEvent::class => [
          ManyfacturingListener::class,
        ],

        SalesGiftsEvent::class => [
            SalesGiftsListener::class,
        ],

        InvestorsDue::class => [
            InvestorsDueListener::class,
        ],


    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}
