<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TransportReceiver extends Model
{
    use HasFactory;
           protected $table = 'transport_receivers';
    protected $fillable = [
        'Arabic_Name',
        'English_Name',
        'Phone',
        'Phone2',
        'Gov',
        'City',
        'Place',
        'Address',
        'Location',
        'Client',

    ];

    public function Place()
    {
        return $this->belongsTo(Places::class,'Place');
    }

    public function City()
    {
        return $this->belongsTo(City::class,'City');
    }
    
    public function Gov()
    {
        return $this->belongsTo(Governrate::class,'Gov');
    }
    
    public function Client()
    {
        return $this->belongsTo(Customers::class,'Client');
    }
}
