<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TransportContractors extends Model
{
    use HasFactory;
       protected $table = 'transport_contractors';
    protected $fillable = [
        'Arabic_Name',
        'English_Name',
        'Phone',
        'Gov',
        'City',
        'Place',
        'Account',
        'Merit_Account',

    ];

    public function Place()
    {
        return $this->belongsTo(Places::class,'Place');
    }

    public function City()
    {
        return $this->belongsTo(City::class,'City');
    }
    
    public function Gov()
    {
        return $this->belongsTo(Governrate::class,'Gov');
    }
    
    public function Account()
    {
        return $this->belongsTo(AcccountingManual::class,'Account');
    }
        
    public function Merit_Account()
    {
        return $this->belongsTo(AcccountingManual::class,'Merit_Account');
    }
    
}
