<?php

namespace App\Models;

use App\Models\StoresDefaultData;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StorsTransfers extends Model
{
    use HasFactory;
      protected $table = 'stors_transfers';
      protected $fillable = [
        'Code',
        'Date',
        'Draw',
        'Total',
        'TotalQty',
        'Note',
        'From_Store',
        'To_Store',
        'Coin',
        'Cost_Center',
        'User',
        'Status',
        'Ship',
        'CostShip',
        'RecivedShip',
        'OldQty',
        'Edit',
        'Delegate',
        'Time',
        'Branch',
        'Total_Cost',
        'TypeTransfer',
        'Cost_Store',
        'File',
        'Edit_t',
        'Delete',
        'Edit_New_Code',

    ];

        public function From_Store()
    {
        return $this->belongsTo(Stores::class,'From_Store');
    }

            public function To_Store()
    {
        return $this->belongsTo(Stores::class,'To_Store');
    }

            public function Coin()
    {
        return $this->belongsTo(Coins::class,'Coin');
    }

            public function Cost_Center()
    {
        return $this->belongsTo(CostCenter::class,'Cost_Center');
    }

            public function Ship()
    {
        return $this->belongsTo(ShippingCompany::class,'Ship');
    }

            public function User()
    {
        return $this->belongsTo(Admin::class,'User');
    }


                   public function ProductsStoresTransfers()
    {
        return $this->hasOne(ProductsStoresTransfers::class);
    }
              public function Delegate()
    {
        return $this->belongsTo(Employess::class,'Delegate');
    }

                    public function Branch()
    {
        return $this->belongsTo(Branches::class,'Branch');
    }

    public function scopeType($query){

        $Def=StoresDefaultData::orderBy('id','desc')->first();

        if($Def->StoresTarnsferHide == 1){
            if(auth()->guard('admin')->user()->emp != 0){

                if(!empty(auth()->guard('admin')->user()->store)){

                    return $query->where('To_Store',auth()->guard('admin')->user()->store);
                }


            }

        }else{

            if(auth()->guard('admin')->user()->emp == 0){


                return $query->where('Status',0);
            }else{

                if(!empty(auth()->guard('admin')->user()->store)){

                    return $query->where('To_Store',auth()->guard('admin')->user()->store)->where('Status',0);
                }

            }

        }




    }


}
