<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Shipping\NewShippingCategories;

class ShippingDefault extends Model
{
    use HasFactory;
         protected $table = 'shipping_defaults';
      protected $fillable = [

          
        'Shipment_Class',
        'Payment_Method',
        'Breakable',
        'Opening_Package',
        'Shipment_Type',
        'Shipment_Category',
        'Delivery_To_Others',
        'Shipping_Costs_Included',
        'Insurance',
        'Coin',
        'Safe',
        'Draw',
        'Store',



    ];


    
             public function Coin()
    {
        return $this->belongsTo(Coins::class,'Coin');
    }

    
             public function Shipment_Category()
    {
        return $this->belongsTo(NewShippingCategories::class,'Shipment_Category');
    }

    
             public function Safe()
    {
        return $this->belongsTo(AcccountingManual::class,'Safe');
    }

    
             public function Store()
    {
        return $this->belongsTo(Stores::class,'Store');
    }

 
}
