<?php

namespace App\Models\Shipping;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Stores;
use App\Models\Products;
use App\Models\SubVirables;
use App\Models\Measuerments;

class ShippmentProducts extends Model
{
    use HasFactory;
     protected $table = 'shippment_products';
      protected $fillable = [
        'P_Code',
        'P_Ar_Name',
        'P_En_Name',
        'V1',
        'V2',
        'V_Name',
        'VV_Name',
        'AvQty',
        'Qty',
        'Price',
        'Total',
        'Store',  
        'Product',
        'Unit',
        'Shipment',
          
          
          
    ];

         public function Store()
    {
        return $this->belongsTo(Stores::class,'Store');
    }
    

    
            public function Product()
    {
        return $this->belongsTo(Products::class,'Product');
    }
    
            public function V1()
    {
        return $this->belongsTo(SubVirables::class,'V1');
    }
    
            public function V2()
    {
        return $this->belongsTo(SubVirables::class,'V2');
    }
    
            public function Unit()
    {
        return $this->belongsTo(Measuerments::class,'Unit');
    }
    
            public function Shipment()
    {
        return $this->belongsTo(Shipment::class,'Shipment');
    }

 
}
