<?php

namespace App\Models\Shipping;

use App\Models\City;
use App\Models\Places;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShippingPrices extends Model
{
    use HasFactory;
    protected $table = 'shipping_prices';
    protected $fillable = [
        'From',
        'To',
        'Price',
        'Place',
        'City',

    ];

    public function Place()
    {
        return $this->belongsTo(Places::class,'Place');
    }

    public function City()
    {
        return $this->belongsTo(City::class,'City');
    }

}
