<?php

namespace App\Models\Shipping;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Admin;
use App\Models\City;
use App\Models\Customers;
use App\Models\Employess;
use App\Models\Governrate;
use App\Models\Places;
use App\Models\AcccountingManual;
use App\Models\Coins;
use App\Models\Stores;
class ShipmentRequest extends Model
{
    use HasFactory;
      protected $table = 'shipment_requests';
    protected $fillable = [

        'Code',
        'Date',
        'Time',
        'Status',
        'Pieces_Num',
        'Desc',
        'Weight',
        'Length',
        'Width',
        'Height',
        'Note',
        'Payment_Method',
        'Breakable',
        'Delivery_To_Others',
        'Opening_Package',
        'Sender_Name',
        'Sender_Governorate',
        'Sender_City',
        'Sender_Place',
        'Sender_Address',
        'Sender_Phone1',
        'Sender_Phone2',
        'Sender_Location',
        'Receiver_Name',
        'Receiver_Governorate',
        'Receiver_City',
        'Receiver_Place',
        'Receiver_Address',
        'Receiver_Phone1',
        'Receiver_Phone2',
        'Receiver_Location',

        'Delegate',
        'Sender',
        'Received',
        'Shipment_Cost',
        'Total',
        'User',
        
        'Pay',
        'Safe',
        'Coin',
        'Draw',
        'Transfer',
        
        'Shipment_Type',
        'Receipt_Date',
        'Receipt_Time',
        'Arrival_Date',
        'Arrival_Time',
   
    ];

    public function Sender_Governorate()
    {
        return $this->belongsTo(Governrate::class,'Sender_Governorate');
    }


    public function Sender_City()
    {
        return $this->belongsTo(City::class,'Sender_City');
    }


    public function Sender_Place()
    {
        return $this->belongsTo(Places::class,'Sender_Place');
    }


    public function Receiver_Governorate()
    {
        return $this->belongsTo(Governrate::class,'Receiver_Governorate');
    }


    public function Receiver_City()
    {
        return $this->belongsTo(City::class,'Receiver_City');
    }


    public function Receiver_Place()
    {
        return $this->belongsTo(Places::class,'Receiver_Place');
    }


    public function Delegate()
    {
        return $this->belongsTo(Employess::class,'Delegate');
    }


 
    public function Sender()
    {
        return $this->belongsTo(Customers::class,'Sender');
    }


    public function Received()
    {
        return $this->belongsTo(Customers::class,'Received');
    }


  


    public function User()
    {
        return $this->belongsTo(Admin::class,'User');
    }


    public function Safe()
    {
        return $this->belongsTo(AcccountingManual::class,'Safe');
    }


    public function Coin()
    {
        return $this->belongsTo(Coins::class,'Coin');
    }


  
}
