<?php

namespace App\Models\Shipping;

use App\Models\Customers;
use App\Models\Employess;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
    use App\Enums\ShippingStatus;
use App\Models\Admin;
class ShipmentMoves extends Model
{
    use HasFactory;
    protected $table = 'shipment_moves';
    protected $fillable = [
        'Code',
        'Barcode',
        'Date',
        'Time',
        'Sender',
        'Sender_Name',
        'Reciver',
        'Reciver_Name',
        'Status',
        'Status_Code',
        'Delegate',
        'Driver',
        'Note',
        'User',
        'Shipment_ID',
        'Shipment_Dist_ID',
        'Shipment_Unload_ID',
        'Shipment_Recived_ID',

    ];

    public function Shipment_ID()
    {
        return $this->belongsTo(Shipment::class,'Shipment_ID');
    }

    public function Shipment_Dist_ID()
    {
        return $this->belongsTo(ShipmentsDistribution::class,'Shipment_Dist_ID');
    }

    public function Shipment_Unload_ID()
    {
        return $this->belongsTo(UnloadingShipments::class,'Shipment_Unload_ID');
    }

    public function Shipment_Recived_ID()
    {
        return $this->belongsTo(RecivedShipment::class,'Shipment_Recived_ID');
    }

    public function Sender()
    {
        return $this->belongsTo(Customers::class,'Sender');
    }

    public function Reciver()
    {
        return $this->belongsTo(Customers::class,'Reciver');
    }
    public function Delegate()
    {
        return $this->belongsTo(Employess::class,'Delegate');
    }

    public function Driver()
    {
        return $this->belongsTo(Employess::class,'Driver');
    }

    public function User()
    {
        return $this->belongsTo(Admin::class,'User');
    }

    

    protected $casts = [
'Status'=>ShippingStatus::class,
];

}
