<?php

namespace App\Models\Shipping;

use App\Models\Admin;
use App\Models\City;
use App\Models\Customers;
use App\Models\Employess;
use App\Models\Governrate;
use App\Models\Places;
use App\Models\AcccountingManual;
use App\Models\Coins;
use App\Models\Stores;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Enums\ShippingStatus;
class Shipment extends Model
{
    use HasFactory;
    protected $table = 'shipments';
    protected $fillable = [

        'Code',
        'Date',
        'Time',
        'Arrival_Date',
        'Arrival_Time',
        'Barcode',
        'Status',
        'Pieces_Num',
        'Desc',
        'Reference_Num',
        'Weight',
        'Length',
        'Width',
        'Height',
        'Note',
        'Shipment_Class',
        'Payment_Method',
        'Breakable',
        'Delivery_To_Others',
        'Shipping_Costs_Included',
        'Opening_Package',

        'Sender_Name',
        'Sender_Governorate',
        'Sender_City',
        'Sender_Place',
        'Sender_Address',
        'Sender_Phone1',
        'Sender_Phone2',
        'Sender_Location',

        'Receiver_Name',
        'Receiver_Governorate',
        'Receiver_City',
        'Receiver_Place',
        'Receiver_Address',
        'Receiver_Phone1',
        'Receiver_Phone2',
        'Receiver_Location',

        'Delegate',
        'Driver',
        'Sender',
        'Received',
        'Shipment_Type',
        'Shipment_Rqst_Type',
        'Shipment_Category',

        'Shipment_Cost',
        'Goods_Cost',
        'Delivery_Cost',
        'Overload_Weight_Cost',
        'Collection_Commission',
        'Delivery_Commission',
        'Return_Cost',
        'Total',
        'User',
        
        'Pay',
        'Insurance',
        'Safe',
        'Coin',
        'Draw',
        'Store',
        'ToStore',
        'Car',

    ];

    public function Sender_Governorate()
    {
        return $this->belongsTo(Governrate::class,'Sender_Governorate');
    }


    public function Sender_City()
    {
        return $this->belongsTo(City::class,'Sender_City');
    }


    public function Sender_Place()
    {
        return $this->belongsTo(Places::class,'Sender_Place');
    }


    public function Receiver_Governorate()
    {
        return $this->belongsTo(Governrate::class,'Receiver_Governorate');
    }


    public function Receiver_City()
    {
        return $this->belongsTo(City::class,'Receiver_City');
    }


    public function Receiver_Place()
    {
        return $this->belongsTo(Places::class,'Receiver_Place');
    }


    public function Delegate()
    {
        return $this->belongsTo(Employess::class,'Delegate');
    }


    public function Driver()
    {
        return $this->belongsTo(Employess::class,'Driver');
    }


    public function Sender()
    {
        return $this->belongsTo(Customers::class,'Sender');
    }


    public function Received()
    {
        return $this->belongsTo(Customers::class,'Received');
    }


    public function Shipment_Type()
    {
        return $this->belongsTo(NewShippingTypes::class,'Shipment_Type');
    }


    public function Shipment_Rqst_Type()
    {
        return $this->belongsTo(NewShippingRqstTypes::class,'Shipment_Rqst_Type');
    }


    public function Shipment_Category()
    {
        return $this->belongsTo(NewShippingCategories::class,'Shipment_Category');
    }


    public function User()
    {
        return $this->belongsTo(Admin::class,'User');
    }


    public function Safe()
    {
        return $this->belongsTo(AcccountingManual::class,'Safe');
    }


    public function Coin()
    {
        return $this->belongsTo(Coins::class,'Coin');
    }


    public function Store()
    {
        return $this->belongsTo(Stores::class,'Store');
    }

    public function ToStore()
    {
        return $this->belongsTo(Stores::class,'ToStore');
    }


    public function Car()
    {
        return $this->belongsTo(CarShipping::class,'Car');
    }

    
    protected $casts = [
'Status'=>ShippingStatus::class,
];


}
