<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SalesGifts extends Model
{
    use HasFactory;
    protected $table = 'sales_gifts';
    protected $fillable = [

        'Code',
        'Date',
        'Draw',
        'Note',
        'Product_Numbers',
        'Total_Qty',
        'Total_Price',
        'Total_Cost',
        'Client',
        'Account',
        'Store',
        'Coin',
        'Cost_Center',
        'Edit',
        'Delete',
        'Edit_New_Code',
        'User',

    ];


    public function Client()
    {
        return $this->belongsTo(AcccountingManual::class,'Client');
    }

    public function Account()
    {
        return $this->belongsTo(AcccountingManual::class,'Account');
    }

    public function Store()
    {
        return $this->belongsTo(Stores::class,'Store');
    }
    public function Coin()
    {
        return $this->belongsTo(Coins::class,'Coin');
    }
    public function Cost_Center()
    {
        return $this->belongsTo(CostCenter::class,'Cost_Center');
    }
    public function User()
    {
        return $this->belongsTo(Admin::class,'User');
    }




}
