<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Shipping\CarShipping;
class RqstTransport extends Model
{
    use HasFactory;
        protected $table = 'rqst_transports';
    protected $fillable = [

        'Code',
        'Date',
        'Time',
        'Arrival_Date',
        'Arrival_Time',
        'Reference_Num',
        'Weight',
        'Note',
        'Payment_Method',
        'Insurance',
        'Pay',
        'Value',
        'Type',
      

        'Sender_Name',
        'Sender_Governorate',
        'Sender_City',
        'Sender_Place',
        'Sender_Address',
        'Sender_Phone1',
        'Sender_Phone2',
        'Sender_Location',

        'Receiver_Name',
        'Receiver_Governorate',
        'Receiver_City',
        'Receiver_Place',
        'Receiver_Address',
        'Receiver_Phone1',
        'Receiver_Phone2',
        'Receiver_Location',

        'Safe',
        'Coin',
        'Draw',
        'Cost_Center',

        'Driver',
         'Car',
         'Driver_Precent',
         'Driver_Value',      
        'Expenses_Precent',
         'Expenses_Value',
         'The_Net',
               
        'Contractor',
         'Contractor_Precent',
         'Contractor_Value',
        
        
        'Sender',
        'Received',
        'Transfer',
       

    ];

    public function Sender_Governorate()
    {
        return $this->belongsTo(Governrate::class,'Sender_Governorate');
    }


    public function Sender_City()
    {
        return $this->belongsTo(City::class,'Sender_City');
    }


    public function Sender_Place()
    {
        return $this->belongsTo(Places::class,'Sender_Place');
    }


    public function Receiver_Governorate()
    {
        return $this->belongsTo(Governrate::class,'Receiver_Governorate');
    }


    public function Receiver_City()
    {
        return $this->belongsTo(City::class,'Receiver_City');
    }


    public function Receiver_Place()
    {
        return $this->belongsTo(Places::class,'Receiver_Place');
    }


  
    public function Driver()
    {
        return $this->belongsTo(Employess::class,'Driver');
    }


  
    public function Contractor()
    {
        return $this->belongsTo(TransportContractors::class,'Contractor');
    }


    public function Sender()
    {
        return $this->belongsTo(Customers::class,'Sender');
    }


    public function Received()
    {
        return $this->belongsTo(TransportReceiver::class,'Received');
    }

    public function Safe()
    {
        return $this->belongsTo(AcccountingManual::class,'Safe');
    }



    public function Cost_Center()
    {
        return $this->belongsTo(CostCenter::class,'Cost_Center');
    }


    public function Coin()
    {
        return $this->belongsTo(Coins::class,'Coin');
    }


    public function Car()
    {
        return $this->belongsTo(CarShipping::class,'Car');
    }
}
