<?php

namespace App\Models\RealStates;

use App\Models\AcccountingManual;
use App\Models\City;
use App\Models\Coins;
use App\Models\CostCenter;
use App\Models\Customers;
use App\Models\Employess;
use App\Models\Governrate;
use App\Models\Places;
use App\Models\RealStates\ContractStatus;
use App\Models\RealStates\ProjectStatus;
use App\Models\Stores;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RealSateProjects extends Model
{
    use HasFactory;
    protected $table = 'real_sate_projects';
    protected $fillable = [

        'Code',
        'Name',
        'Start_Date',
        'End_Date',
        'Period',
        'Value',
        'Expect_Cost',
        'Expect_Profit',
        'Project_File',
        'Contract_File',
        'Contract_Type',
        'Completed',
        'Account',
        'Goods_Account',
        'Client',
        'Client_Account',
        'Manager',
        'Reponsible',
        'Store',
        'Cost_Center',
        'Contract_Status',
        'Project_Status',
        'Governrate',
        'City',
        'Place',
        'Coin',
        'Draw',
        'Location',
        'Address_Details',
        'Contractor_Account',

    ];

    public function Account()
    {
        return $this->belongsTo(AcccountingManual::class,'Account');
    }
    public function Goods_Account()
    {
        return $this->belongsTo(AcccountingManual::class,'Goods_Account');
    }    public function Contractor_Account()
    {
        return $this->belongsTo(AcccountingManual::class,'Contractor_Account');
    }
    public function Client()
    {
        return $this->belongsTo(Customers::class,'Client');
    }
    public function Client_Account()
    {
        return $this->belongsTo(AcccountingManual::class,'Client_Account');
    }
    public function Manager()
    {
        return $this->belongsTo(Employess::class,'Manager');
    }
    public function Reponsible()
    {
        return $this->belongsTo(Employess::class,'Reponsible');
    }
    public function Store()
    {
        return $this->belongsTo(Stores::class,'Store');
    }
    public function Cost_Center()
    {
        return $this->belongsTo(CostCenter::class,'Cost_Center');
    }
    public function Contract_Status()
    {
        return $this->belongsTo(ContractStatus::class,'Contract_Status');
    }
    public function Project_Status()
    {
        return $this->belongsTo(ProjectStatus::class,'Project_Status');
    }

    public function Governrate()
    {
        return $this->belongsTo(Governrate::class,'Governrate');
    }
    public function City()
    {
        return $this->belongsTo(City::class,'City');

    }
    public function Place()
    {
        return $this->belongsTo(Places::class,'Place');
    }
    public function Coin()
    {
        return $this->belongsTo(Coins::class,'Coin');
    }


}
