<?php

namespace App\Models\RealStates;

use App\Models\AcccountingManual;
use App\Models\Admin;
use App\Models\Branches;
use App\Models\Coins;
use App\Models\CostCenter;
use App\Models\Employess;
use App\Models\Stores;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentssRealProjects extends Model
{
    use HasFactory;
    protected $table = 'paymentss_real_projects';
    protected $fillable = [
        'Code',
        'Date',
        'Time',
        'Branch',
        'Draw',
        'Note',
        'Product_Numbers',
        'Total_Qty',
        'Total_Discount',
        'Total_BF_Taxes',
        'Total_Taxes',
        'Total_Price',
        'Total_Cost',
        'Total_Net',
        'DiscountBill',
        'Pay',
        'Safe',
        'Client',
        'Delegate',
        'Store',
        'Coin',
        'Cost_Center',
        'User',
        'Edit',
        'Delete',
        'Edit_New_Code',
        'Project',
    ];

    public function Safe()
    {
        return $this->belongsTo(AcccountingManual::class,'Safe');
    }
    public function Client()
    {
        return $this->belongsTo(AcccountingManual::class,'Client');
    }
    public function Delegate()
    {
        return $this->belongsTo(Employess::class,'Delegate');
    }

    public function Store()
    {
        return $this->belongsTo(Stores::class,'Store');
    }
    public function Coin()
    {
        return $this->belongsTo(Coins::class,'Coin');
    }
    public function Cost_Center()
    {
        return $this->belongsTo(CostCenter::class,'Cost_Center');
    }
    public function User()
    {
        return $this->belongsTo(Admin::class,'User');
    }


    public function Branch()
    {
        return $this->belongsTo(Branches::class,'Branch');
    }


    public function Project()
    {
        return $this->belongsTo(RealSateProjects::class,'Project');
    }


}
