<?php

namespace App\Models\RealStates;

use App\Models\Measuerments;
use App\Models\Products;
use App\Models\Stores;
use App\Models\Taxes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentssProductsRealProjects extends Model
{
    use HasFactory;
    protected $table = 'paymentss_products_real_projects';
    protected $fillable = [
        'Product_Code',
        'P_Ar_Name',
        'P_En_Name',
        'Pro_Desc',
        'AvQty',
        'Qty',
        'Price',
        'CostPrice',
        'Discount',
        'TDiscount',
        'Tax',
        'Total_Bf_Tax',
        'Total_Tax',
        'Total',
        'TotCostNew',
        'Total_Net',
        'Store',
        'Product',
        'Unit',
        'Payment',
    ];

    public function Store()
    {
        return $this->belongsTo(Stores::class,'Store');
    }

    public function Tax()
    {
        return $this->belongsTo(Taxes::class,'Tax');
    }

    public function Product()
    {
        return $this->belongsTo(Products::class,'Product');
    }

    public function Unit()
    {
        return $this->belongsTo(Measuerments::class,'Unit');
    }

    public function Payment()
    {
        return $this->belongsTo(PaymentssRealProjects::class,'Payment');
    }


}
