<?php

namespace App\Models\RealStates;

use App\Models\AcccountingManual;
use App\Models\Coins;
use App\Models\CostCenter;
use App\Models\Employess;
use App\Models\RealStates\RealSateProjects;
use App\Models\Stores;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GoodsProject extends Model
{
    use HasFactory;
    protected $table = 'goods_projects';
    protected $fillable = [

        'Code',
        'Date',
        'Store',
        'Cost_Center',
        'Responsible',
        'Safe',
        'Coin',
        'Draw',
        'Note',
        'Project',
        'Product_Numbers',
        'Total_Qty',
        'Total_Price',


    ];

    public function Store()
    {
        return $this->belongsTo(Stores::class,'Store');
    }


    public function Cost_Center()
    {
        return $this->belongsTo(CostCenter::class,'Cost_Center');
    }


    public function Responsible()
    {
        return $this->belongsTo(Employess::class,'Responsible');
    }


    public function Safe()
    {
        return $this->belongsTo(AcccountingManual::class,'Safe');
    }


    public function Coin()
    {
        return $this->belongsTo(Coins::class,'Coin');
    }


    public function Project()
    {
        return $this->belongsTo(RealSateProjects::class,'Project');
    }


}
