<?php

namespace App\Models\RealStates;

use App\Models\AcccountingManual;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ContractorsRealProjects extends Model
{
    use HasFactory;
    protected $table = 'contractors_real_projects';
    protected $fillable = [
        'Arabic_Name',
        'English_Name',
        'Expenses_Account',
        'Merit_Account',
        'Project',
    ];

    public function Expenses_Account()
    {
        return $this->belongsTo(AcccountingManual::class,'Expenses_Account');
    }

    public function Merit_Account()
    {
        return $this->belongsTo(AcccountingManual::class,'Merit_Account');
    }


    public function Project()
    {
        return $this->belongsTo(RealSateProjects::class,'Project');
    }



}
