<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Quote extends Model
{
    use HasFactory;
    protected $table = 'quotes';
      protected $fillable = [
        'Code',
        'Date',
        'Draw',
        'Payment_Method',
        'Status',
        'Refernce_Number',
        'Note',
        'Product_Numbers',
        'Total_Qty',
        'Total_Discount',
        'Total_BF_Taxes',
        'Total_Taxes',
        'Total_Price',
        'Pay',
        'Safe',
        'Client',
        'Executor',
        'Delegate',
        'Store',
        'Coin',
        'Cost_Center',
        'User',
        'presenter',
        'annual_interest',
        'monthly_installment',
        'Years_Number',
        'total',
        'installment_Num',
        'Date_First_installment',
        'Later_Due',
        'Sale_Date',
        'Total_Wight_Bill',
          'DiscountBill',

        'ToSales',
        'Shipping',
        'Delivery_Status',
        'Order_Type',
        'ProfitPrecent',
        'InstallCompany',
        'ContractNumber',
        'PayFees',
        'ServiceFee',
        'CompanyPrecent',
        'Time',
        'TaxBill',
        'TaxCode',
        'TaxOnTotal',
        'TaxOnTotalType',
        'Check_Type',
        'Due_Date',
        'Check_Number',
        'Shift_Code',
        'Client_Address',
        'Delivery',
        'ProfitTax',
        'Branch',
        'CustomerGroup',
        'Total_Cost',
        'File',
        'Edit',
        'Delete',
        'Edit_New_Code',
        'Total_Net',
        'Residual',
        'Current_Credit',
        'DiscountTax',
        'Shipping_Price',
          
        'Email',
        'Phone',
        'Expire_Date',
        'Care',
        'Location',
        'Desc',
          
          
          




    ];



    public function Safe()
    {
        return $this->belongsTo(AcccountingManual::class,'Safe');
    }
    public function Client()
    {
        return $this->belongsTo(AcccountingManual::class,'Client');
    }
    public function Delegate()
    {
        return $this->belongsTo(Employess::class,'Delegate');
    }

    public function Executor()
    {
        return $this->belongsTo(Employess::class,'Executor');
    }

    public function emp()
    {
        return $this->belongsTo(Employess::class,'emp');
    }


    public function Store()
    {
        return $this->belongsTo(Stores::class,'Store');
    }
    public function Coin()
    {
        return $this->belongsTo(Coins::class,'Coin');
    }
    public function Cost_Center()
    {
        return $this->belongsTo(CostCenter::class,'Cost_Center');
    }
    public function User()
    {
        return $this->belongsTo(Admin::class,'User');
    }

    public function ProductSales()
    {
        return $this->hasOne(ProductSales::class);
    }

    public function Installment()
    {
        return $this->hasOne(Installment::class);
    }

    public function RecivedSales()
    {
        return $this->hasOne(RecivedSales::class);
    }

    public function ReturnSales()
    {
        return $this->hasOne(ReturnSales::class);
    }

    public function Ship()
    {
        return $this->belongsTo(AcccountingManual::class,'Shipping');
    }

    public function Check_Type()
    {
        return $this->belongsTo(ChecksTypes::class,'Check_Type');
    }

    public function Delivery()
    {
        return $this->belongsTo(Employess::class,'Delivery');
    }

    public function Client_Address()
    {
        return $this->belongsTo(Addressses::class,'Client_Address');
    }

    public function Sale_User()
    {
        return $this->belongsTo(Admin::class,'Sale_User');
    }


    public function TaxOnTotalType()
    {
        return $this->belongsTo(Taxes::class,'TaxOnTotalType');
    }


    public function InstallCompany()
    {
        return $this->belongsTo(InstallmentCompanies::class,'InstallCompany');
    }



    public function Branch()
    {
        return $this->belongsTo(Branches::class,'Branch');
    }


    public function CustomerGroup()
    {
        return $this->belongsTo(CustomersGroup::class,'CustomerGroup');
    }


    public function ProductsQuote()
    {
        return $this->hasOne(ProductsQuote::class);
    }


    public function scopeType($query){

    if(auth()->guard('admin')->user()->emp != 0){

    return $query->where('Delegate',auth()->guard('admin')->user()->emp);

    }

    }


}
