<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchasesOrder extends Model
{
    use HasFactory;
     protected $table = 'purchases_orders';
      protected $fillable = [
        'Code',
        'Date',
        'Purchases_Date',
        'Draw',
        'Payment_Method',
        'Status',
        'Vendor_Bill_Date',
        'Refernce_Number',
        'Note',
        'Product_Numbers',
        'Total_Qty',
        'Total_Discount',
        'Total_BF_Taxes',
        'Total_Taxes',
        'Total_Price',
        'Pay',
        'P_Order_Num',
        'Safe',
        'Vendor',
        'Delegate',
        'Store',
        'Coin',
        'Cost_Center',
        'User',
        'ToPurch',
        'Quality',
        'Quality_Note',
        'Quantity',
        'Quantity_Note',

          'DiscountBill',
      'ShipStatus',
      'Ship',
      'Check_Type',
      'Due_Date',
      'Check_Number',
      'Later_Due',
      'Sent',
      'TaxBill',
      'TaxCode',
      'Time',
      'Branch',
      'CustomerGroup',
      'File',
     'Current_Credit',
      'Residual',
      'Total_Net',
            'Edit',
      'Delete',
      'Edit_New_Code',
      'ImportTotalCost',


    ];


    public function Safe_fk()
    {
        return $this->belongsTo(AcccountingManual::class,'Safe');
    }

    public function Safe()
    {
        return $this->belongsTo(AcccountingManual::class,'Safe');
    }

    public function Vendor_fk()
    {
        return $this->belongsTo(AcccountingManual::class,'Vendor');
    }


    public function Vendor()
    {
        return $this->belongsTo(AcccountingManual::class,'Vendor');
    }



    public function Delegate()
    {
        return $this->belongsTo(Employess::class,'Delegate');
    }
    public function Delegate_fk()
    {
        return $this->belongsTo(Employess::class,'Delegate');
    }


    public function Store()
    {
        return $this->belongsTo(Stores::class,'Store');
    }


    public function Store_fk()
    {
        return $this->belongsTo(Stores::class,'Store');
    }


    public function Coin()
    {
        return $this->belongsTo(Coins::class,'Coin');
    }

    public function Coin_fk()
    {
        return $this->belongsTo(Coins::class,'Coin');
    }


    public function Cost_Center()
    {
        return $this->belongsTo(CostCenter::class,'Cost_Center');
    }

    public function Cost_Center_fk()
    {
        return $this->belongsTo(CostCenter::class,'Cost_Center');
    }



    public function User()
    {
        return $this->belongsTo(Admin::class,'User');
    }

    public function User_fk()
    {
        return $this->belongsTo(Admin::class,'User');
    }

    public function ProductsPurchases()
    {
        return $this->hasOne(ProductsPurchases::class);
    }

    public function RecivedPurcht()
    {
        return $this->hasOne(RecivedPurcht::class);
    }

    public function ReturnPurch()
    {
        return $this->hasOne(ReturnPurch::class);
    }

    public function Ship()
    {
        return $this->belongsTo(AcccountingManual::class,'Ship');
    }

    public function Ship_fk()
    {
        return $this->belongsTo(AcccountingManual::class);
    }



    public function Check_Type()
    {
        return $this->belongsTo(ChecksTypes::class,'Check_Type');
    }


    public function Check_Type_fk()
    {
        return $this->belongsTo(ChecksTypes::class,'Check_Type');
    }

    public function Branch()
    {
        return $this->belongsTo(Branches::class,'Branch');
    }

    public function Branch_fk()
    {
        return $this->belongsTo(Branches::class,'Branch');
    }


    public function CustomerGroup()
    {
        return $this->belongsTo(CustomersGroup::class,'CustomerGroup');
    }

    public function CustomerGroup_fk()
    {
        return $this->belongsTo(CustomersGroup::class,'CustomerGroup');
    }








}
