<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductSalesGifts extends Model
{
    use HasFactory;
    protected $table = 'product_sales_gifts';
    protected $fillable = [
        'Product_Code',
        'P_Ar_Name',
        'P_En_Name',
        'V_Name',
        'VV_Name',
        'AvQty',
        'Qty',
        'Price',
        'CostPrice',
        'Total',
        'Store',
        'Exp_Date',
        'V1',
        'V2',
        'Unit',
        'Gift',
        'TotCost',
        'Product',


    ];

    public function Store()
    {
        return $this->belongsTo(Stores::class,'Store');
    }

    public function Product()
    {
        return $this->belongsTo(Products::class,'Product');
    }

    public function V1()
    {
        return $this->belongsTo(SubVirables::class,'V1');
    }

    public function V2()
    {
        return $this->belongsTo(SubVirables::class,'V2');
    }

    public function Unit()
    {
        return $this->belongsTo(Measuerments::class,'Unit');
    }

    public function Gift()
    {
        return $this->belongsTo(SalesGifts::class,'Gift');
    }


}
