<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Partners extends Model
{
    use HasFactory;
      protected $table = 'partners';
      protected $fillable = [
        'Name',
        'Shares_Number',
        'Nominal_Value_of_Shares',
        'Actual_Share_Value',

        'Profits_Precentage',
        'Profits',
        'Withdraw_Profits',
        'Remaining_Profits',
        'Account',

        'Gary_Account',
        'Recent_Profit_Account',
        'Stage_Profit_Account',
        'First_Partner_Share',
        'Now_Partner_Share',
        'Capital_Increase_Rate',
        'Capital_Increase_Value',
        'Partnership_Ratio',
    ];

                 public function Account()
    {
        return $this->belongsTo(AcccountingManual::class,'Account');
    }
                 public function Gary_Account()
    {
        return $this->belongsTo(AcccountingManual::class,'Gary_Account');
    }
                 public function Recent_Profit_Account()
    {
        return $this->belongsTo(AcccountingManual::class,'Recent_Profit_Account');
    }
                 public function Stage_Profit_Account()
    {
        return $this->belongsTo(AcccountingManual::class,'Stage_Profit_Account');
    }


}
