<?php

namespace App\Listeners\SalesOrder;


use App\Events\SalesOrderEvent;
use App\Models\AssemblyProducts;
use App\Models\ExpireDateQty;
use App\Models\FifoQty;
use App\Models\Products;
use App\Models\ProductSalesOrder;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Models\SalesDefaultData;
use App\Models\SalesFifoQty;
use App\Models\SalesOrder;
use App\Models\Stores;
use App\Models\StoresDefaultData;
use App\Models\VAQty;
use App\Traits\GeneralTrait;
use DB;
use App\Services\Average;


class SalesOrderListener
{


    use GeneralTrait;

    public function __construct()
    {

    }


    public function handle(SalesOrderEvent $event)
    {


        $average = new Average ;

        $ID=$event->ID;
        $Bill=SalesOrder::findOrFail($ID);
        $DEEF=SalesDefaultData::latest('id')->first();

        $def=StoresDefaultData::latest('id')->first();

        if(empty($event->requests['Delegate'])){
            $event->requests['Delegate']=null;
        }
        if(empty($event->requests['Executor'])){
            $event->requests['Executor']=null;
        }
        if(empty($event->requests['Patch_Number'])){
            $event->requests['Patch_Number']=null;
        }

        if(empty($event->requests['SalesProDesc'])){
            $event->requests['SalesProDesc']=null;
        }

        if(empty($event->requests['Refernce_Number'])){
            $event->requests['Refernce_Number']=null;
        }

        if(empty($event->requests['Ship'])){
            $event->requests['Ship']=null;
        }

        if(empty($event->requests['Cost_Center'])){
            $event->requests['Cost_Center']=null;
        }


        if(empty($event->requests['ProfitTax'])){
            $event->requests['ProfitTax']=null;
        }
        if(empty($event->requests['TaxBill'])){
            $event->requests['TaxBill']=null;
        }


        if(empty($event->requests['TaxOnTotal'])){
            $event->requests['TaxOnTotal']=null;
        }


        if(empty($event->requests['ProfitTax'])){
            $event->requests['ProfitTax']=null;
        }


        if(empty($event->requests['TaxOnTotalType'])){
            $event->requests['TaxOnTotalType']=null;
        }


        //Noti
            $order=[
                'noti_name_ar'=>'امر بيع',
                'noti_name_en'=>'Sales Order',
                'type_ar'=>'امر بيع',
                'type_en'=>'Sales Order',
                'type_code'=>$Bill->Code,
                'emp'=>$event->requests['Delegate'],
                'client'=>$event->requests['Client'],
                'product'=>null,
                'store'=>$event->requests['Store'],
                'safe'=>$event->requests['Safe'],
                'notify_name'=>trans('admin.SalesOrder'),
            ];
            $this->CreateNotification($order);


        //Event
        if(!empty($event->requests['Sale_Date'])){


            $data=[

                'start_date'=>$event->requests['Sale_Date'],
                'end_date'=>$event->requests['Sale_Date'],
                'event_name_ar'=>'تحويل امر بيع الي   فاتورة مبيعات ',
                'event_name_en'=>'Transfer Sales Order to Sales Bill',
                'type'=>'امر البيع',
                'type_id'=>null,
                'type_code'=>$Bill->Code,
                'emp'=>$event->requests['Delegate'],
                'client'=>$event->requests['Client'],
                'product'=>null,
                'customer'=>null,

            ];


            $this->CreateEvent($data);

        }


        //Qty and Details
        if(!empty($event->requests['Unit'])){


            $P_Ar_Name=$event->requests['P_Ar_Name'];
            $P_En_Name=$event->requests['P_En_Name'];
            $Unit=$event->requests['Unit'];
            $P_Code=$event->requests['P_Code'];
            $Qty=$event->requests['Qty'];
            $AvQty=$event->requests['AvQty'];
            $Price=$event->requests['Price'];
            $Discount=$event->requests['Discount'];
            $TotalBFTax=$event->requests['TotalBFTax'];
            $TotalTax=$event->requests['TotalTax'];
            $PurchTax=$event->requests['PurchTax'];
            $Total=$event->requests['Total'];
            $StorePurch=$event->requests['StorePurch'];
            $Exp_Date=$event->requests['Exp_Date'];
            $Product=$event->requests['Product'];
            $VOne=$event->requests['VOne'];
            $VTwo=$event->requests['VTwo'];
            $V_Name=$event->requests['V_Name'];
            $VV_Name=$event->requests['VV_Name'];
            $Exp_Date=$event->requests['Exp_Date'];
            $Patch_Number=$event->requests['Patch_Number'];
            $TDiscount=$event->requests['TDiscPro'];
            $CostPrice=$event->requests['CostPrice'];
            if(!empty($event->requests['Total_Wight'])){
                $Total_Wight=$event->requests['Total_Wight'];
            }else{
                $Total_Wight=[];
            }

            if(!empty($event->requests['weight'])){
                $weight=$event->requests['weight'];
            }else{
                $weight=[];
            }

            if(!empty($event->requests['UnitRate'])){
                $UnitRate=$event->requests['UnitRate'];
            }else{
                $UnitRate=[];
            }




            $SalesProDesc=$event->requests['SalesProDesc'];
            $TotCostNew=$event->requests['TotCostNew'];
            $Total_Net=$event->requests['Total_Net'];
            if(!empty($event->requests['SubVID'])){
                $SubVID=$event->requests['SubVID'];
            }else{
                $SubVID=[];
            }




            if(!empty($event->requests['Pro_Note'])){
                $Pro_Note=$event->requests['Pro_Note'];
            }else{
                $Pro_Note=[];
            }


            for($i=0 ; $i < count($Unit) ; $i++){

                $pp=ProductUnits::where('Product',$Product[$i])->where('Unit',$Unit[$i])->first();
                $plow=ProductUnits::where('Product',$Product[$i])->where('Def',1)->first();
                $rr = ProductUnits::where("Unit",$Unit[$i])->where('Product',$Product[$i])->first();
                $SS=Stores::find($StorePurch[$i]);
                $PSS=Products::find($Product[$i]);
                $prooooo=Products::find($Product[$i]);


                if(!empty($SubVID[$i])) {
                    $uu['SubVID'] = $SubVID[$i];
                }else{
                    $uu['SubVID'] = null;
                }
                if(!empty($Pro_Note[$i])) {
                    $uu['Pro_Note'] = $Pro_Note[$i];
                }else{
                    $uu['Pro_Note'] = null;
                }


                $uu['Product_Code']=$P_Code[$i];
                $uu['P_Ar_Name']=$P_Ar_Name[$i];
                $uu['P_En_Name']=$P_En_Name[$i];
                $uu['V_Name']=$V_Name[$i];
                $uu['VV_Name']=$VV_Name[$i];
                $uu['Original_Qty']=$Qty[$i];
                $uu['Qty']=$Qty[$i];
                $uu['AvQty']=$AvQty[$i];
                $uu['Price']=$Price[$i];
                $uu['Discount']=$Discount[$i];
                $uu['Tax']=$PurchTax[$i];
                $uu['Total_Bf_Tax']=$TotalBFTax[$i];
                $uu['Total_Tax']=$TotalTax[$i];
                $uu['Total']=$Total[$i];
                $uu['Store']=$StorePurch[$i];
                $uu['Product']=$Product[$i];
                $uu['Unit']=$Unit[$i];
                $uu['Exp_Date']=$Exp_Date[$i];
                $uu['TDiscount']=$TDiscount[$i];
                $uu['SalesOrder']=$ID;
                $uu['V1']=$VOne[$i];
                $uu['V2']=$VTwo[$i];
                $uu['Total_Net']=$Total_Net[$i];
                if(!empty($Patch_Number[$i])) {
                    $uu['Patch_Number'] = $Patch_Number[$i];
                }else{
                    $uu['Patch_Number'] = null;
                }
                $uu['CostPrice']=$CostPrice[$i];
                if(!empty($SalesProDesc[$i])) {
                    $uu['SalesProDesc']=$SalesProDesc[$i];
                }else{
                    $uu['SalesProDesc'] = null;
                }

                $uu['TotCostNew']=$TotCostNew[$i];
                $uu['SmallCode']=$plow->Barcode;

                if(!empty($UnitRate[$i])) {
                    $uu['UnitRate'] = $UnitRate[$i];
                }else{
                    $uu['UnitRate'] = null;
                }

                if(!empty($weight[$i])) {
                    $uu['weight'] = $weight[$i];
                }else{
                    $uu['weight'] = null;
                }

                if(!empty($Total_Wight[$i])) {
                    $uu['Total_Wight'] = $Total_Wight[$i];
                }else{
                    $uu['Total_Wight'] = null;
                }


                $uu['SmallQty']=$Qty[$i] * $pp->Rate;

                $uu['Date']=$event->requests['Date'];
                $uu['Branch']=$SS->Branch;
                $uu['Group']=$PSS->Group;
                $uu['Brand']=$PSS->Brand;
                ProductSalesOrder::create($uu);


                if($DEEF->SalesOrderType == 1){



                    if($prooooo->P_Type == 'Assembly'){

                        $Asembs=AssemblyProducts::where('p_id',$Product[$i])->get();

                        foreach($Asembs as $ass){


                            $unit = ProductUnits::where('Unit', $ass->Unit)->where('Product', $ass->Product)->first();
                            $Quantity = $this->ProAvQties($StorePurch[$i],$ass->Product,$ass->P_Code);

                            $qq = $unit->Rate * ($Qty[$i] * $ass->Qty) ;

                            $ty = $average->AverageCostGetUnit($ass->Product,$ass->P_Code, $StorePurch[$i], $ass->Unit);

                            if (!empty($Quantity)) {
                                $hold_qty = $Quantity->Hold_Qty + $qq;
                                $newqty = $Quantity->Qty - $qq;
                                if($newqty < 0){
                                    return 5;
                                }
                                $cur = $newqty * ($ty / $unit->Rate);
                                ProductsQty::where('id', $Quantity->id)->update(['Qty' => $newqty, 'Price' => $ty, 'TotalCost' => $cur, 'Hold_Qty' => $hold_qty]);

                            }


                                //Expire Date
                                if (!empty($Exp_Date[$i])) {
                                    $unit = ProductUnits::where('Unit', $ass->Unit)->where('Product', $ass->Product)->first();

                                    $qq = $unit->Rate *( $Qty[$i] * $ass->Qty);


                                    $EXPO = ExpireDateQty::find($Exp_Date[$i]);
                                    $NewExpQty = $EXPO->Qty - $qq;
                                    $hold_qty_exp = $EXPO->Hold_Qty + $qq;
                                    if($NewExpQty < 0){
                                        return 5;
                                    }

                                    ExpireDateQty::where('id', $Exp_Date[$i])->update(['Qty' => $NewExpQty,'Hold_Qty'=>$hold_qty_exp]);


                                }

                                //Fifo
                                if ($def->Cost_Price == 2) {

                                    $fifo=$this->FifoAvQtyDate($StorePurch[$i],$ass->Product, $ass->P_Code);


                                    if (!empty($fifo)) {

                                        if ($fifo->Qty >= ($Qty[$i] * $ass->Qty)) {


                                            $unit = ProductUnits::where('Unit', $ass->Unit)->where('Product', $ass->Product)->first();

                                            $qq = $unit->Rate * ($Qty[$i] * $ass->Qty);

                                            $newqty = $fifo->Qty - $qq;
                                            $hold_qty_fifo = $fifo->Hold_Qty + $qq;

                                            if($newqty < 0){
                                                return 5;
                                            }
                                            FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty,'Hold_Qty'=>$hold_qty_fifo]);





                                        } else {


                                            $resdiualQty = ($Qty[$i] * $ass->Qty) - $fifo->Qty;

                                            $unit = ProductUnits::where('Unit', $ass->Unit)->where('Product', $ass->Product)->first();

                                            $qq = $unit->Rate * ($fifo->Qty * $ass->Qty);

                                            $newqty = $fifo->Qty - $qq;
                                            if($newqty < 0){
                                                return 5;
                                            }
                                            $hold_qty_fifo = $fifo->Hold_Qty + $qq;

                                            FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty,'Hold_Qty'=>$hold_qty_fifo]);


                                            $ResdiualCost = $this->FifoStoreAssemblyHoldQty($fifo->Store, $fifo->Product, $fifo->P_Code, $fifo->id, $fifo->Purchases_Date, $resdiualQty, $ass->Unit, $ass->Qty, $ID);


                                        }


                                    }


                                }



                        }


                    }elseif($prooooo->P_Type == 'Variable_Aggregate'){



                        $AVs=VAQty::where('Product',$Product[$i])->where('SubV',$SubVID[$i])->get();


                        foreach($AVs as $av){

                            $Quantity=$this->ProAvQties($StorePurch[$i],$av->ProductID,$av->VAProductID()->first()->Product_Code);

                            if(!empty($Quantity)){

                                $unit = ProductUnits::where('Unit',$av->VAProductID()->first()->Unit)->where('Product',$av->ProductID)->first();
                                $Quantity = $this->ProAvQties($StorePurch[$i],$av->ProductID,$av->VAProductID()->first()->Product_Code);

                                $qq = $unit->Rate * ($Qty[$i] * $av->Qty) ;

                                $ty = $average->AverageCostGetUnit($av->ProductID,$av->VAProductID()->first()->Product_Code, $StorePurch[$i], $av->VAProductID()->first()->Unit);

                                if (!empty($Quantity)) {
                                    $hold_qty = $Quantity->Hold_Qty + $qq;
                                    $newqty = $Quantity->Qty - $qq;
                                    if($newqty < 0){
                                        return 5;
                                    }
                                    $cur = $newqty * ($ty / $unit->Rate);
                                    ProductsQty::where('id', $Quantity->id)->update(['Qty' => $newqty, 'Price' => $ty, 'TotalCost' => $cur, 'Hold_Qty' => $hold_qty]);

                                }


                                //Expire Date
                                if (!empty($Exp_Date[$i])) {
                                    $unit = ProductUnits::where('Unit', $av->VAProductID()->first()->Unit)->where('Product',$av->ProductID)->first();

                                    $qq = $unit->Rate *( $Qty[$i] * $av->Qty);


                                    $EXPO = ExpireDateQty::find($Exp_Date[$i]);
                                    $NewExpQty = $EXPO->Qty - $qq;
                                    $hold_qty_exp = $EXPO->Hold_Qty + $qq;
                                    if($NewExpQty < 0){
                                        return 5;
                                    }

                                    ExpireDateQty::where('id', $Exp_Date[$i])->update(['Qty' => $NewExpQty,'Hold_Qty'=>$hold_qty_exp]);


                                }

                                //Fifo
                                if ($def->Cost_Price == 2) {

                                    $fifo=$this->FifoAvQtyDate($StorePurch[$i],$av->ProductID, $av->VAProductID()->first()->Product_Code);


                                    if (!empty($fifo)) {

                                        if ($fifo->Qty >= ($Qty[$i] * $av->Qty)) {


                                            $unit = ProductUnits::where('Unit', $av->VAProductID()->first()->Unit)->where('Product',$av->ProductID)->first();

                                            $qq = $unit->Rate * ($Qty[$i] * $av->Qty);

                                            $newqty = $fifo->Qty - $qq;
                                            $hold_qty_fifo = $fifo->Hold_Qty + $qq;

                                            if($newqty < 0){
                                                return 5;
                                            }
                                            FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty,'Hold_Qty'=>$hold_qty_fifo]);





                                        } else {


                                            $resdiualQty = ($Qty[$i] * $av->Qty) - $fifo->Qty;

                                            $unit = ProductUnits::where('Unit', $av->VAProductID()->first()->Unit)->where('Product', $av->ProductID)->first();

                                            $qq = $unit->Rate * ($fifo->Qty * $av->Qty);

                                            $newqty = $fifo->Qty - $qq;
                                            if($newqty < 0){
                                                return 5;
                                            }
                                            $hold_qty_fifo = $fifo->Hold_Qty + $qq;

                                            FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty,'Hold_Qty'=>$hold_qty_fifo]);


                                            $ResdiualCost = $this->FifoStoreAssemblyHoldQty($fifo->Store, $fifo->Product, $fifo->P_Code, $fifo->id, $fifo->Purchases_Date, $resdiualQty, $av->VAProductID()->first()->Unit, $av->Qty, $ID);


                                        }


                                    }


                                }


                            }



                        }






                    }elseif($prooooo->P_Type != 'Service' and $prooooo->P_Type != 'Subscribe') {


                        $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();
                        $Quantity = $this->ProAvQties($StorePurch[$i], $Product[$i], $P_Code[$i]);

                        $qq = $unit->Rate * $Qty[$i];

                        $ty = $average->AverageCostGetUnit($Product[$i], $plow->Barcode, $StorePurch[$i], $Unit[$i]);

                        if (!empty($Quantity)) {
                            $hold_qty = $Quantity->Hold_Qty + $qq;
                            $newqty = $Quantity->Qty - $qq;
                            $cur = $newqty * ($ty / $unit->Rate);
                            if($newqty < 0){
                                return 5;
                            }
                            ProductsQty::where('id', $Quantity->id)->update(['Qty' => $newqty, 'Price' => $ty, 'TotalCost' => $cur, 'Hold_Qty' => $hold_qty]);

                        }


                        if (!empty($Exp_Date[$i])) {
                            $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();

                            $qq = $unit->Rate * $Qty[$i];


                            $EXPO = ExpireDateQty::find($Exp_Date[$i]);
                            $NewExpQty = $EXPO->Qty - $qq;
                            $hold_qty_exp = $EXPO->Hold_Qty + $qq;
                            if($NewExpQty < 0){
                                return 5;
                            }
                            ExpireDateQty::where('id', $Exp_Date[$i])->update(['Qty' => $NewExpQty,'Hold_Qty'=>$hold_qty_exp]);

                        }

                        //Fifo

                        if ($def->Cost_Price == 2) {

                            $fifo=$this->FifoAvQtyDate($StorePurch[$i] ,$Product[$i],$P_Code[$i]);


                            if (!empty($fifo)) {

                                if ($fifo->Qty >= $Qty[$i]) {


                                    $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();

                                    $qq = $unit->Rate * $Qty[$i];

                                    $newqty = $fifo->Qty - $qq;

                                    $hold_qty_fifo = $fifo->Hold_Qty + $qq;

                                    if($newqty < 0){

                                        return 5;
                                    }
                                    FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty,'Hold_Qty'=>$hold_qty_fifo]);




                                } else {


                                    $resdiualQty = $Qty[$i] - $fifo->Qty;

                                    $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();

                                    $qq = $unit->Rate * $fifo->Qty;

                                    $newqty = $fifo->Qty - $qq;


                                    if($newqty < 0){
                                        return 5;
                                    }
                                    $hold_qty_fifo = $fifo->Hold_Qty + $qq;

                                    FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty,'Hold_Qty'=>$hold_qty_fifo]);


                                    $ResdiualCost = $this->FifoStoreHoldQty($fifo->Store, $fifo->Product, $fifo->P_Code, $fifo->id, $fifo->Purchases_Date, $resdiualQty, $Unit[$i], $ID);


                                }


                            }


                        }


                    }

                }


            }


        }


    }
}
