<?php

namespace App\Listeners\ReciptVoucher;

use App\Events\SureReciptVoucherEvent;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;
use App\Models\Journalizing;
use App\Models\GeneralDaily;
use App\Models\SafesBanks;
use App\Models\ReciptVoucher;
use App\Events\AddJournalizingEvent;  
class SureReciptVoucherListener
{
    

     use GeneralTrait;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\TestEvent  $event
     * @return void
     */
    public function handle(SureReciptVoucherEvent $event)
    {
              

          
                  
             $type_ar= 'سند قبض';
             $type_en= 'Receipt Voucher';
             $type=0;
             $Status=1;
             $custom=1;
             $Branch=SafesBanks::where('Account',$event->requests['Safe'])->latest('id')->first()->Branch;
        
             $code_type=ReciptVoucher::findOrFail($event->requests['ID']);

             $custom_data=[
             'Debitor'=>$event->requests['Total_Creditor'],
             'Creditor'=>0,
             'Account'=>$event->requests['Safe'],
             'Statement'=>$event->requests['Note'],
             'Safe'=>$event->requests['Safe'],
             'Branch'=>$Branch,
             'Code_Type'=>$code_type->Code,
             'Date'=>$event->requests['Date'],
             'Draw'=>$event->requests['Draw'],
             'Coin'=>$event->requests['Coin'],
             'Cost_Center'=>$event->requests['Cost_Center'],

             ];

             AddJournalizingEvent::dispatch($event->requests,$Status,$type,$type_ar,$type_en,$custom,$custom_data);       
 
   
                   
        $dataUser=[
        'screen_ar'=>'سند قبض',
        'screen_en'=>'Receipt Voucher',
        'type_ar'=>'تأكيد',
        'type_en'=>'Sure',
        'explain_ar'=>$event->requests['Code'],
        'explain_en'=>$event->requests['Code'],
        ];
        $this->UserCustomMoves($dataUser);   
        
        
    
        //Notifications
    
            
              $order=[
                'noti_name_ar'=>'تأكيد سند قبض',
                'noti_name_en'=>'Receipt Voucher  Confirmed',
                'type_ar'=>'سند قبض',
                'type_en'=>'Receipt Voucher',
                'type_code'=>$event->requests['Code'],
                'emp'=>null,
                'client'=>null,
                'product'=>null,
                'store'=>null,
                'safe'=>null,
                'notify_name'=>trans('admin.Receipt_Voucher_Confirmed'),
            ];      
            $this->CreateNotification($order);      
            

        
        
    }
}
