<?php

namespace App\Listeners\Products;

use App\Events\AddProductEvent;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;
use App\Models\Journalizing;
use App\Models\PaymentVoucherDetails;
use App\Models\ProductUnits;
use App\Models\Products;
use App\Models\SubImages;
use App\Events\AddJournalizingEvent;
use DB;
use App\Services\ProductService;
use App\Models\FifoQty;
use App\Models\GeneralDaily;
use App\Models\JournalizingDetails;
use App\Models\ProductsStartPeriods;
use App\Models\StartPeriods;
use App\Models\SubVirables;
use App\Models\ExpireDateQty;
use App\Models\ProductMoves;
use App\Models\ProductsQty;
use App\Models\Stores;
use App\Models\StoresDefaultData;
use App\Models\PurchasesDefaultData;
use App\Services\Average;

class AddProductListener
{


     use GeneralTrait;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\TestEvent  $event
     * @return void
     */
    public function handle(AddProductEvent $event)
    {

       $service = new ProductService ;



        if(!empty($event->requests['P_En_Name'])){
         $english_name=$event->requests['P_En_Name'];
         }else{
         $english_name=$event->requests['P_Ar_Name'];
         }



     if(!empty($event->requests['Tax'])){

     $tax=$event->requests['Tax'];
     }else{

     $tax=1;

     }

     if(!empty($event->requests['P_En_Name'])){

     $EnName=$event->requests['P_En_Name'];
     }else{

     $EnName=$event->requests['P_Ar_Name'];

     }

     if(!empty($event->requests['Minimum'])){
     $mini=$event->requests['Minimum'] ;
     }else{
     $mini=0;
     }

     if(!empty($event->requests['Maximum_Sales_Qty'])){
     $MAX=$event->requests['Maximum_Sales_Qty'] ;
     }else{
     $MAX=1000000;
     }

        $image=request()->file('Image');
        $img=$this->UploadFile($image);

        $image2=request()->file('Image2');
        $img2=$this->UploadFile($image2);

     $ID = DB::table('products')->insertGetId(

     array(
     'P_Type' => $event->requests['P_Type'],
     'P_Ar_Name' => $event->requests['P_Ar_Name'],
     'P_En_Name' => $english_name,
     'Brand' => $event->requests['Brand'],
     'Group' => $event->requests['Group'],
     'Offer' => $event->requests['Offer'],
     'OfferPrice' => $event->requests['OfferPrice'],
     'Image' =>$img,
     'Image2' =>$img2,
     'Minimum' => $mini,
     'Maximum' => $event->requests['Maximum'],
     'Length' => $event->requests['Length'],
     'Width' => $event->requests['Width'],
     'Height' => $event->requests['Height'],
     'Weight' => $event->requests['Weight'],
     'Saller_Point' => $event->requests['Saller_Point'],
     'Customer_Point' => $event->requests['Customer_Point'],
     'Tax' => $tax,
     'Validity' => $event->requests['Validity'],
     'Days_Notify' => $event->requests['Days_Notify'],
     'Ar_Desc' => $event->requests['Ar_Desc'],
     'En_Desc' => $event->requests['En_Desc'],
     'Ar_Spec' => $event->requests['Ar_Spec'],
     'En_Spec' => $event->requests['En_Spec'],
     'Store_Show' => $event->requests['Store_Show'],
     'Store_Type' => $event->requests['Store_Type'],
     'Sub_Cost' => $event->requests['Sub_Cost'],
     'Cas_No' => $event->requests['Cas_No'],
     'HSN' => $event->requests['HSN'],
     'Code_Type' => $event->requests['Code_Type'],
     'World_Code' => $event->requests['World_Code'],
     'Uni_Code' => $event->requests['Uni_Code'],
     'subscribe_type' => $event->requests['subscribe_type'],
     'Origin_Number' => $event->requests['Origin_Number'],
     'Origin_Country' => $event->requests['Origin_Country'],
     'SearchCode1' => $event->requests['SearchCode1'],
     'SearchCode2' => $event->requests['SearchCode2'],
     'Space' => $event->requests['Space'],
     'Storage' => $event->requests['Storage'],
     'Processor' => $event->requests['Processor'],
     'Camera' => $event->requests['Camera'],
     'Screen' => $event->requests['Screen'],
     'OS' => $event->requests['OS'],
     'Battery' => $event->requests['Battery'],
     'Warranty' => $event->requests['Warranty'],
     'Color' => $event->requests['Color'],
     'Category' => $event->requests['Category'],
     'Model' => $event->requests['Model'],
     'Guess_Price' => $event->requests['Guess_Price'],
     'Offer_Start_Date' => $event->requests['Offer_Start_Date'],
     'Offer_End_Date' => $event->requests['Offer_End_Date'],
     'Arrange' => $event->requests['Arrange'],
     'Show_Other_Store' => $event->requests['Show_Other_Store'],
     'Arabic_Brief_Desc' => $event->requests['Arabic_Brief_Desc'],
     'English_Brief_Desc' => $event->requests['English_Brief_Desc'],
     'Calories' => $event->requests['Calories'],
     'Thickness' => $event->requests['Thickness'],
     'Cost_Price' => $event->requests['Cost_Price'],
     'Faveorite' => $event->requests['Faveorite'],
     'Bonus' => $event->requests['Bonus'],
     'Maximum_Sales_Qty' => $MAX,
     'Status' => 0,
     )
     );

     if(!empty($event->requests['Unit'])){

     $unit=$event->requests['Unit'];
     $rate=$event->requests['Rate'];
     $barcode=$event->requests['Barcode'];
     $price=$event->requests['Price'];
     $priceTwo=$event->requests['Price_Two'];
     $priceThree=$event->requests['Price_Three'];
     $default=$event->requests['Def'];


     for($i=0 ; $i < count($unit) ; $i++){

         $uu['Rate']=$rate[$i];
         $uu['Barcode']=$barcode[$i];
         $uu['Price']=$price[$i];
         $uu['Price_Two']=$priceTwo[$i];
         $uu['Price_Three']=$priceThree[$i];
         $uu['Def']=$default[$i];
         $uu['P_Ar_Name']=$event->requests['P_Ar_Name'];
         $uu['P_En_Name']=$english_name;
         $uu['P_Type']=$event->requests['P_Type'];
         $uu['Unit']=$unit[$i];
         $uu['Product']=$ID;
         $uu['Brand']=$event->requests['Brand'];
         $uu['Group']=$event->requests['Group'];
         ProductUnits::create($uu);
     }

     }

    $rr=ProductUnits::where('Product',$ID)->where('Def',1)->latest('id')->first();

            //Product Moves
        $move=[

            'Date'=>date('Y-m-d'),
            'Type'=>'رصيد سابق' ,
            'TypeEn'=>'Previous Balance',
            'Bill_Num'=>0,
            'Incom'=>0,
            'Outcom'=>0,
            'Current'=>0,
            'CostIn'=>0,
            'CostOut'=>0,
            'CostCurrent'=>0,
            'P_Ar_Name'=>$event->requests['P_Ar_Name'],
            'P_En_Name'=>$english_name,
            'P_Code'=>$rr->Barcode,
            'Unit'=>$rr->Unit,
            'Qty'=>0,
            'Group'=>$event->requests['Group'],
            'Store'=>null,
            'Product'=>$ID,
            'V1'=>null,
            'V2'=>null,
            'Brand'=>$event->requests['Brand'],
            'Safe'=>null,
            'Branch'=>null,
            'SalePrice'=>$rr->Price,
            'ProductPrice'=>null,
             'Delegate'=>null,
            'Payment_Method'=>null,
            'User'=>auth()->guard('admin')->user()->id,

        ];

    $this->ProductMoves($move);
    $service->ProductAdd($event->requests,$ID);


        if(!empty($event->requests['SubImage'])){
         foreach ($event->requests['SubImage'] as $photo) {
         $filename = $photo->store('ProductImagesCatlouge');
         SubImages::create([
         'Product' => $ID,
         'Image' => $filename
         ]);
         }
         }




        //==================== Lw Kamyat Whmyaaa =====================================

        $Default=StoresDefaultData::latest('id')->first();


    if($Default->Qty_With_Add_Product == 0){

        if($Default->Fictitious_Quantities == 1){

      $Data=PurchasesDefaultData::latest('id')->first();
        $defPro=ProductUnits::where('Product',$ID)->where('Def',1)->first();
        $Safe=$Data->Safe;
        $Store=$Data->Store;
        $Coin=$Data->Coin;
        $Draw=1;
        $total=$event->requests['Cost_Price'] * 100000;


              $s=Stores::find($Store);
    $IDStart = DB::table('start_periods')->insertGetId(

        array(


            'Date' => date('Y-m-d'),
            'Store' => $Store,
            'Draw' => $Draw,
            'Note' => null,
            'Total_Products' => 1,
            'Total_Qty' => 100000,
            'Total_Price' => $total,
            'Coin' => $Coin,
            'Time' =>date("h:i:s a", time()),
            'Branch' => $s->Branch,
            'User' => auth()->guard('admin')->user()->id,


        )
    );


               $average = new Average ;

        $Bill=StartPeriods::findOrFail($IDStart);
        $branch=Stores::findOrFail($Store);
        $def=StoresDefaultData::latest('id')->first();




        //Products Details and Qties

            $P_Ar_Name=$defPro->P_Ar_Name;
            $P_En_Name=$defPro->P_En_Name;
            $Unit=$defPro->Unit;
            $P_Code=$defPro->Barcode;
            $Price_Sale=$defPro->Price;
            $Qty=100000;
            $Price=$event->requests['Cost_Price'];
            $Total=$total;
            $Exp_Date=null;
            $Product=$defPro->Product;
            $VOne=null;
            $VTwo=null;
            $V_Name=null;
            $VV_Name=null;
            $Patch_Number=null;

                $pp=ProductUnits::where('Product',$defPro->Product)->where('Unit',$defPro->Unit)->first();
                $plow=ProductUnits::where('Product',$defPro->Product)->where('Def',1)->first();


                $uu['P_Code']=$P_Code;
                $uu['SmallCode']=$plow->Barcode;
                $uu['Qty']=$Qty;
                $uu['SmallQty']=$Qty  * $pp->Rate;
                $uu['Price']=$Price;
                $uu['Total']=$Total;
                $uu['Old_Qty']=$Qty;
                $uu['Exp_Date']=$Exp_Date;
                $uu['SP_ID']=$Bill->id;
                $uu['Date']=date('Y-m-d') ;
                $uu['Store']=$Store;
                $uu['User']=auth()->guard('admin')->user()->id;
                $uu['Unit']=$Unit;
                $uu['P_Ar_Name']=$P_Ar_Name;
                $uu['P_En_Name']=$P_En_Name;
                $uu['V_Name']=$V_Name;
                $uu['VV_Name']=$VV_Name;
                $uu['Product']=$Product;
                $uu['Patch_Number']=$Patch_Number;
                    $uu['V1']=$VOne;
                    $uu['V2']=$VTwo;

                ProductsStartPeriods::create($uu);



                $Quantity=$this->ProAvQties($Store,$Product,$P_Code);




                    if(!empty($Quantity)){

                        //if have old Qty

                        $unit=ProductUnits::where('Unit',$Unit)->where('Product',$Product)->first();
                        $plow=ProductUnits::where('Product',$Product)->where('Def',1)->first();

                        $qq= $unit->Rate * $Qty ;
                        $newqty=$Quantity->Qty + $qq ;

                        $ty=$average->AverageCost($Total,$qq,$Product,$P_Code,$Store,date('Y-m-d'),$Price);

                        $prooooo=Products::findOrFail($Product);

                        if($prooooo->P_Type == 'Serial' or $prooooo->P_Type == 'Single_Variable' or $prooooo->P_Type == 'Duble_Variable' ) {
                 $lastOperation=ProductMoves::latest('id')->where('P_Code',$P_Code)->where('Product',$Product)->where('Store',$Store)->first();
                        }else{
               $lastOperation=ProductMoves::latest('id')->where('Product',$Product)->where('Store',$Store)->first();
                        }





                        $in=$Total;
                        $out=0;
                        if(!empty($lastOperation)){
                            $current=$lastOperation->CostCurrent + ($Total / $unit->Rate);
                        }else{
                            $current= ($Total / $unit->Rate);
                        }
                        $cur=$newqty * $ty ;

                        //Add Qty to Store
                        ProductsQty::where('id',$Quantity->id)->update(['Qty'=>$newqty,'Exp_Date'=>$Exp_Date,'Price'=>$ty , 'TotalCost'=>$cur]);

                        $prooooo=Products::find($Product);

                        //Product Moves
                        $move=[

                            'Date'=>date('Y-m-d'),
                            'Type'=>  'بدايه فتره' ,
                            'TypeEn'=>'Start Period',
                            'Bill_Num'=>$Bill->Code,
                            'Incom'=>$qq,
                            'Outcom'=>0,
                            'Current'=>$newqty,
                            'CostIn'=>number_format((float)$in, 2, '.', ''),
                            'CostOut'=>number_format((float)$out, 2, '.', ''),
                            'CostCurrent'=>number_format((float)$current, 2, '.', ''),
                            'P_Ar_Name'=>$P_Ar_Name,
                            'P_En_Name'=>$P_En_Name,
                            'P_Code'=>$P_Code,
                            'Unit'=>$Unit,
                            'Qty'=>$Qty,
                            'Group'=>$prooooo->Group,
                            'Store'=>$Store,
                            'Product'=>$Product,
                            'V1'=>$VOne,
                            'V2'=>$VTwo,
                            'Brand'=>$prooooo->Brand,
                            'Safe'=>null,
                            'Branch'=>$branch->Branch,
                            'SalePrice'=>$plow->Price,
                            'ProductPrice'=>null,
                            'Delegate'=>null,
                            'Payment_Method'=>null,
                            'User'=>auth()->guard('admin')->user()->id,

                        ];

                        $this->ProductMoves($move);



                    }else{


                        //if new Qty in Store

                            $sNam=$V_Name;
                            $ssNam=$VV_Name;
                            $sId=$VOne;
                            $ssId=$VTwo;

                        $id_store = DB::table('products_stores')->insertGetId(

                            array(

                                'P_Ar_Name' => $P_Ar_Name,
                                'P_En_Name' => $P_En_Name,
                                'P_Code' => $P_Code,
                                'Exp_Date' => $Exp_Date,
                                'Product' => $Product,
                                'Store' =>$Store,
                                'V1' => $sId,
                                'V2' => $ssId,
                                'V_Name' => $sNam,
                                'VV_Name' => $ssNam,

                            )
                        );

                        $prooooo=Products::find($Product);
                        $PRICE_RATE=$Price  /  $pp->Rate ;
                        $pqty['P_Ar_Name']=$P_Ar_Name;
                        $pqty['Exp_Date']=$Exp_Date;
                        $pqty['P_En_Name']=$P_En_Name;
                        $pqty['Qty']=$Qty * $pp->Rate;
                        $pqty['Price']=$PRICE_RATE;
                        $pqty['TotalCost']=$PRICE_RATE * ($Qty * $pp->Rate);
                        $pqty['Pro_Stores']=$id_store;
                        $pqty['Store']=$Store;
                        $pqty['Unit']=$Unit;
                        $pqty['Low_Unit']=$plow->Unit;
                        $pqty['Product']=$Product;
                        $pqty['Price_Sale']=$Price_Sale;
                        $pqty['SearchCode1']=$prooooo->SearchCode1;
                        $pqty['SearchCode2']=$prooooo->SearchCode2;
                        $pqty['V1']=$VOne;
                        $pqty['V2']=$VTwo;
                        $pqty['V_Name']=$V_Name;
                        $pqty['VV_Name']=$VV_Name;
                        $pqty['P_Code']=$defPro->Barcode;
                        $pqty['PP_Code']=null;
                        $pqty['PPP_Code']=null;
                        $pqty['PPPP_Code']=null;
                        $pqty['Group']=$prooooo->Group;
                        $pqty['Brand']=$prooooo->Brand;
                        $pqty['Branch']=$branch->Branch;
                        ProductsQty::create($pqty);



                        //product Moves
                        $newQQty=$Qty * $pp->Rate;
                        $ty=$average->AverageCost($Total,$newQQty,$Product,$plow->Barcode,$Store,date('Y-m-d'),$Price);

                        if($ty != 0){
                            $in=($Qty * $pp->Rate) * $ty ;
                            $out=0;
                            $current=($Qty * $pp->Rate) * $ty ;
                        }else{
                            $in=($Qty * $pp->Rate) * 1;
                            $out=0;
                            $current=($Qty * $pp->Rate) * 1;
                        }


                        //Product Moves
                        $move=[

                            'Date'=>date('Y-m-d'),
                            'Type'=>  'بدايه فتره' ,
                            'TypeEn'=>'Start Period',
                            'Bill_Num'=>$Bill->Code,
                            'Incom'=>$Qty * $pp->Rate,
                            'Outcom'=>0,
                            'Current'=>$Qty * $pp->Rate,
                            'CostIn'=>number_format((float)$in, 2, '.', ''),
                            'CostOut'=>number_format((float)$out, 2, '.', ''),
                            'CostCurrent'=>number_format((float)$current, 2, '.', ''),
                            'P_Ar_Name'=>$P_Ar_Name,
                            'P_En_Name'=>$P_En_Name,
                            'P_Code'=>$P_Code,
                            'Unit'=>$Unit,
                            'Qty'=>$Qty,
                            'Group'=>$prooooo->Group,
                            'Store'=>$Store,
                            'Product'=>$Product,
                            'V1'=>$VOne,
                            'V2'=>$VTwo,
                            'Brand'=>$prooooo->Brand,
                            'Safe'=>null,
                            'Branch'=>$branch->Branch,
                            'SalePrice'=>$plow->Price,
                            'ProductPrice'=>null,
                            'Delegate'=>null,
                            'Payment_Method'=>null,
                            'User'=>auth()->guard('admin')->user()->id,

                        ];

                        $this->ProductMoves($move);


                    }


                    //Expire Date
                    if(!empty($Exp_Date[$i])){


                        $unit=ProductUnits::where('Unit',$Unit)->where('Product',$Product)->first();
                        $EXPO=$this->ExpireAvQties($Store,$Product,$P_Code);



                        if(!empty($EXPO)){


                            if($EXPO->Exp_Date == $Exp_Date){

                                $qq= $unit->Rate * $Qty ;
                                $NewExpQty=$EXPO->Qty + $qq ;
                                ExpireDateQty::where('id',$EXPO->id)->update(['Qty'=>$NewExpQty]);

                            }else{


                                $EXNEW['Qty']=$unit->Rate * $Qty;
                                $EXNEW['P_Ar_Name']=$EXPO->P_Ar_Name;
                                $EXNEW['P_En_Name']=$EXPO->P_En_Name;
                                $EXNEW['P_Code']=$EXPO->P_Code;
                                $EXNEW['PP_Code']=$EXPO->PP_Code;
                                $EXNEW['PPP_Code']=$EXPO->PPP_Code;
                                $EXNEW['PPPP_Code']=$EXPO->PPPP_Code;
                                $EXNEW['V_Name']=$EXPO->V_Name;
                                $EXNEW['VV_Name']=$EXPO->VV_Name;
                                $EXNEW['Store']=$EXPO->Store;
                                $EXNEW['Unit']=$EXPO->Unit;
                                $EXNEW['Product']=$EXPO->Product;
                                $EXNEW['V1']=$EXPO->V1;
                                $EXNEW['V2']=$EXPO->V2;
                                $EXNEW['Low_Unit']=$EXPO->Low_Unit;
                                $EXNEW['Exp_Date']=$Exp_Date;
                                $EXNEW['Group']=$EXPO->Group;
                                $EXNEW['Brand']=$EXPO->Brand;
                                $EXNEW['Branch']=$EXPO->Branch;

                                ExpireDateQty::create($EXNEW);

                            }


                        }else{

                            $CodesProducts=ProductUnits::where('Product',$Product)->select('Barcode')->get();
                            $prooooo=Products::find($Product);

                                $sNam=$V_Name;
                                $ssNam=$VV_Name;
                                $sId=$VOne;
                                $ssId=$VTwo;

                            $EXNEW['Qty']=$unit->Rate * $Qty;
                            $EXNEW['P_Ar_Name']=$P_Ar_Name;
                            $EXNEW['P_En_Name']=$P_En_Name;
                            $EXNEW['P_Code']=$P_Code;
                            $EXNEW['Store']=$Store;
                            $EXNEW['V1']=$sId;
                            $EXNEW['V2']=$ssId;
                            $EXNEW['Exp_Date']=$Exp_Date;
                            $EXNEW['Unit']=$Unit;
                            $EXNEW['Product']=$Product;
                            $EXNEW['V_Name']=$sNam;
                            $EXNEW['VV_Name']=$ssNam;
                            $EXNEW['P_Code']=$P_Code;
                                $EXNEW['PP_Code']=null;
                                $EXNEW['PPP_Code']=null;
                                $EXNEW['PPPP_Code']=null;
                            $EXNEW['Group']=$prooooo->Group;
                            $EXNEW['Brand']=$prooooo->Brand;
                            $EXNEW['Branch']=$branch->Branch;
                            $EXNEW['Low_Unit']=$plow->Unit;
                            ExpireDateQty::create($EXNEW);

                        }



                    }

                    //Fifo
                    if($def->Cost_Price == 2){


                        $fifo=$this->FifoAvQty($Store,$Product,$P_Code,date('Y-m-d'));


                        if(!empty($fifo)){

                            $qq= $pp->Rate * $Qty ;

                            $newqty=$fifo->Qty + $qq ;

                            FifoQty::where('id',$fifo->id)->update(['Qty'=>$newqty,'Original_Qty'=>$newqty]);

                        }else{



                                $sNam=$V_Name;
                                $ssNam=$VV_Name;
                                $sId=$VOne;
                                $ssId=$VTwo;


                            $prooooo=Products::find($Product);

                            $pqty['P_Ar_Name']=$P_Ar_Name;
                            $pqty['Exp_Date']=$Exp_Date;
                            $pqty['P_En_Name']=$P_En_Name;
                            $pqty['Qty']=$Qty[$i] * $pp->Rate;
                            $pqty['Original_Qty']=$Qty * $pp->Rate;
                            $pqty['Cost_Price']=$Price;
                            $pqty['Store']=$Store;
                            $pqty['Unit']=$Unit;
                            $pqty['Low_Unit']=$plow->Unit;
                            $pqty['Product']=$Product;
                            $pqty['SearchCode1']=$prooooo->SearchCode1;
                            $pqty['SearchCode2']=$prooooo->SearchCode2;
                            $pqty['V1']=$VOne;
                            $pqty['V2']=$VTwo;
                            $pqty['V_Name']=$V_Name;
                            $pqty['VV_Name']=$VV_Name;
                            $pqty['P_Code']=$P_Code;
                            $pqty['PP_Code']=null;
                            $pqty['PPP_Code']=null;
                            $pqty['PPPP_Code']=null;
                            $pqty['Group']=$prooooo->Group;
                            $pqty['Brand']=$prooooo->Brand;
                            $pqty['Branch']=$branch->Branch;
                            $pqty['Purchases_Date']=date('Y-m-d');
                            FifoQty::create($pqty);

                        }




                    }

        $date=date('Y-m-d');

        //Joun

        $JunID = DB::table('journalizings')->insertGetId(

            array(


                'Type' => 'اصناف بداية فترة',
                'TypeEn' => 'Start Period Products',
                'Code_Type' => $Bill->Code,
                'Date' =>$date,
                'Draw' =>$Draw,
                'Coin' =>$Coin,
                'Cost_Center' => null,
                'Total_Debaitor' =>$total,
                'Total_Creditor' =>$total,
                'Note' =>null,

            )
        );

        $Code=Journalizing::findOrFail($JunID)->Code;





        $store=Stores::find($Store);
        $s=Stores::find($Store);

        $PRODUCTSS['Joun_ID']=$JunID;
        $PRODUCTSS['Debitor']=$total;
        $PRODUCTSS['Creditor']=0;
        $PRODUCTSS['Account']=$store->Account;
        $PRODUCTSS['Statement']=null;


        JournalizingDetails::create($PRODUCTSS);


        $Gen['Code']=$Code;
        $Gen['Code_Type']=$Bill->Code;
        $Gen['Date']=$date;
        $Gen['Type']= 'اصناف بداية فترة';
        $Gen['TypeEn']='Start Period Products';
        $Gen['Debitor']=$total;
        $Gen['Creditor']=0;
        $Gen['Statement']=null;
        $Gen['Draw']=$Draw;
        $Gen['Debitor_Coin']= $Draw * $total;
        $Gen['Creditor_Coin']=$Draw * 0;
        $Gen['Account']=$store->Account;
        $Gen['Coin']= $Coin;
        $Gen['Cost_Center']=null;
        $Gen['userr']= auth()->guard('admin')->user()->id;

        GeneralDaily::create($Gen);




        $PRODUCTSS['Joun_ID']=$JunID;
        $PRODUCTSS['Debitor']=0;
        $PRODUCTSS['Creditor']=$total;
        $PRODUCTSS['Account']=45;
        $PRODUCTSS['Statement']=null;


        JournalizingDetails::create($PRODUCTSS);



        $Gen['Code']=$Code;
        $Gen['Code_Type']=$Bill->Code;
        $Gen['Date']=$date;
        $Gen['Type']= 'اصناف بداية فترة';
        $Gen['TypeEn']='Start Period Products';
        $Gen['Debitor']=0;
        $Gen['Creditor']=$total;
        $Gen['Statement']=null;
        $Gen['Draw']=$Draw;
        $Gen['Debitor_Coin']= $Draw * 0;
        $Gen['Creditor_Coin']=$Draw * $total;
        $Gen['Account']=45;
        $Gen['Coin']= $Coin;
        $Gen['Cost_Center']= null;
        $Gen['userr']= auth()->guard('admin')->user()->id;

        GeneralDaily::create($Gen);

        //Stores Moves
        $totpri=($total) ;

        $dataStMove=[

            'Date'=>date('Y-m-d'),
            'Code'=>$Bill->Code ,
            'Time'=>date("h:i:s a", time()),
            'Branch'=>$branch->Branch,
            'Store'=>$Store,
            'Safe'=>null,
            'Type'=>'بدايه فتره',
            'TypeEn'=>'Start Period',
            'Cost_Center'=>null,
            'User'=>auth()->guard('admin')->user()->id,
            'Coin'=>$Coin,
            'Note'=>null,
            'Total_Qty'=>100000,
            'Total_Price'=>$totpri,
            'Account'=>null,
            'Ship'=>null,
            'ID'=>$IDStart,

        ];

        $this->StoresMoves($dataStMove);




        }

    }
// =====================   Lw Kamyat m3 el adafa


        if($Default->Qty_With_Add_Product == 1){

      $Data=PurchasesDefaultData::latest('id')->first();
        $defPro=ProductUnits::where('Product',$ID)->where('Def',1)->first();
        $Safe=$Data->Safe;
        $Store=$event->requests['Store'];
        $Coin=$Data->Coin;
        $Draw=1;
        $total=$event->requests['Cost_Price'] * $event->requests['Qty'];


              $s=Stores::find($Store);
    $IDStart = DB::table('start_periods')->insertGetId(

        array(


            'Date' => date('Y-m-d'),
            'Store' => $Store,
            'Draw' => $Draw,
            'Note' => null,
            'Total_Products' => 1,
            'Total_Qty' => $event->requests['Qty'],
            'Total_Price' => $total,
            'Coin' => $Coin,
            'Time' =>date("h:i:s a", time()),
            'Branch' => $s->Branch,
            'User' => auth()->guard('admin')->user()->id,


        )
    );


               $average = new Average ;

        $Bill=StartPeriods::findOrFail($IDStart);
        $branch=Stores::findOrFail($Store);
        $def=StoresDefaultData::latest('id')->first();




        //Products Details and Qties

            $P_Ar_Name=$defPro->P_Ar_Name;
            $P_En_Name=$defPro->P_En_Name;
            $Unit=$defPro->Unit;
            $P_Code=$defPro->Barcode;
            $Price_Sale=$defPro->Price;
            $Qty=$event->requests['Qty'];
            $Price=$event->requests['Cost_Price'];
            $Total=$total;
            $Exp_Date=null;
            $Product=$defPro->Product;
            $VOne=null;
            $VTwo=null;
            $V_Name=null;
            $VV_Name=null;
            $Patch_Number=null;

                $pp=ProductUnits::where('Product',$defPro->Product)->where('Unit',$defPro->Unit)->first();
                $plow=ProductUnits::where('Product',$defPro->Product)->where('Def',1)->first();


                $uu['P_Code']=$P_Code;
                $uu['SmallCode']=$plow->Barcode;
                $uu['Qty']=$Qty;
                $uu['SmallQty']=$Qty  * $pp->Rate;
                $uu['Price']=$Price;
                $uu['Total']=$Total;
                $uu['Old_Qty']=$Qty;
                $uu['Exp_Date']=$Exp_Date;
                $uu['SP_ID']=$Bill->id;
                $uu['Date']=date('Y-m-d') ;
                $uu['Store']=$Store;
                $uu['User']=auth()->guard('admin')->user()->id;
                $uu['Unit']=$Unit;
                $uu['P_Ar_Name']=$P_Ar_Name;
                $uu['P_En_Name']=$P_En_Name;
                $uu['V_Name']=$V_Name;
                $uu['VV_Name']=$VV_Name;
                $uu['Product']=$Product;
                $uu['Patch_Number']=$Patch_Number;
                    $uu['V1']=$VOne;
                    $uu['V2']=$VTwo;

                ProductsStartPeriods::create($uu);



                $Quantity=$this->ProAvQties($Store,$Product,$P_Code);




                    if(!empty($Quantity)){

                        //if have old Qty

                        $unit=ProductUnits::where('Unit',$Unit)->where('Product',$Product)->first();
                        $plow=ProductUnits::where('Product',$Product)->where('Def',1)->first();

                        $qq= $unit->Rate * $Qty ;
                        $newqty=$Quantity->Qty + $qq ;

                        $ty=$average->AverageCost($Total,$qq,$Product,$P_Code,$Store,date('Y-m-d'),$Price);

                        $prooooo=Products::findOrFail($Product);

                        if($prooooo->P_Type == 'Serial' or $prooooo->P_Type == 'Single_Variable' or $prooooo->P_Type == 'Duble_Variable' ) {
                 $lastOperation=ProductMoves::latest('id')->where('P_Code',$P_Code)->where('Product',$Product)->where('Store',$Store)->first();
                        }else{
               $lastOperation=ProductMoves::latest('id')->where('Product',$Product)->where('Store',$Store)->first();
                        }





                        $in=$Total;
                        $out=0;
                        if(!empty($lastOperation)){
                            $current=$lastOperation->CostCurrent + ($Total / $unit->Rate);
                        }else{
                            $current= ($Total / $unit->Rate);
                        }
                        $cur=$newqty * $ty ;

                        //Add Qty to Store
                        ProductsQty::where('id',$Quantity->id)->update(['Qty'=>$newqty,'Exp_Date'=>$Exp_Date,'Price'=>$ty , 'TotalCost'=>$cur]);

                        $prooooo=Products::find($Product);

                        //Product Moves
                        $move=[

                            'Date'=>date('Y-m-d'),
                            'Type'=>  'بدايه فتره' ,
                            'TypeEn'=>'Start Period',
                            'Bill_Num'=>$Bill->Code,
                            'Incom'=>$qq,
                            'Outcom'=>0,
                            'Current'=>$newqty,
                            'CostIn'=>number_format((float)$in, 2, '.', ''),
                            'CostOut'=>number_format((float)$out, 2, '.', ''),
                            'CostCurrent'=>number_format((float)$current, 2, '.', ''),
                            'P_Ar_Name'=>$P_Ar_Name,
                            'P_En_Name'=>$P_En_Name,
                            'P_Code'=>$P_Code,
                            'Unit'=>$Unit,
                            'Qty'=>$Qty,
                            'Group'=>$prooooo->Group,
                            'Store'=>$Store,
                            'Product'=>$Product,
                            'V1'=>$VOne,
                            'V2'=>$VTwo,
                            'Brand'=>$prooooo->Brand,
                            'Safe'=>null,
                            'Branch'=>$branch->Branch,
                            'SalePrice'=>$plow->Price,
                            'ProductPrice'=>null,
                            'Delegate'=>null,
                            'Payment_Method'=>null,
                            'User'=>auth()->guard('admin')->user()->id,

                        ];

                        $this->ProductMoves($move);



                    }else{


                        //if new Qty in Store

                            $sNam=$V_Name;
                            $ssNam=$VV_Name;
                            $sId=$VOne;
                            $ssId=$VTwo;

                        $id_store = DB::table('products_stores')->insertGetId(

                            array(

                                'P_Ar_Name' => $P_Ar_Name,
                                'P_En_Name' => $P_En_Name,
                                'P_Code' => $P_Code,
                                'Exp_Date' => $Exp_Date,
                                'Product' => $Product,
                                'Store' =>$Store,
                                'V1' => $sId,
                                'V2' => $ssId,
                                'V_Name' => $sNam,
                                'VV_Name' => $ssNam,

                            )
                        );

                        $prooooo=Products::find($Product);
                        $PRICE_RATE=$Price  /  $pp->Rate ;
                        $pqty['P_Ar_Name']=$P_Ar_Name;
                        $pqty['Exp_Date']=$Exp_Date;
                        $pqty['P_En_Name']=$P_En_Name;
                        $pqty['Qty']=$Qty * $pp->Rate;
                        $pqty['Price']=$PRICE_RATE;
                        $pqty['TotalCost']=$PRICE_RATE * ($Qty * $pp->Rate);
                        $pqty['Pro_Stores']=$id_store;
                        $pqty['Store']=$Store;
                        $pqty['Unit']=$Unit;
                        $pqty['Low_Unit']=$plow->Unit;
                        $pqty['Product']=$Product;
                        $pqty['Price_Sale']=$Price_Sale;
                        $pqty['SearchCode1']=$prooooo->SearchCode1;
                        $pqty['SearchCode2']=$prooooo->SearchCode2;
                        $pqty['V1']=$VOne;
                        $pqty['V2']=$VTwo;
                        $pqty['V_Name']=$V_Name;
                        $pqty['VV_Name']=$VV_Name;
                        $pqty['P_Code']=$defPro->Barcode;
                        $pqty['PP_Code']=null;
                        $pqty['PPP_Code']=null;
                        $pqty['PPPP_Code']=null;
                        $pqty['Group']=$prooooo->Group;
                        $pqty['Brand']=$prooooo->Brand;
                        $pqty['Branch']=$branch->Branch;
                        ProductsQty::create($pqty);



                        //product Moves
                        $newQQty=$Qty * $pp->Rate;
                        $ty=$average->AverageCost($Total,$newQQty,$Product,$plow->Barcode,$Store,date('Y-m-d'),$Price);

                        if($ty != 0){
                            $in=($Qty * $pp->Rate) * $ty ;
                            $out=0;
                            $current=($Qty * $pp->Rate) * $ty ;
                        }else{
                            $in=($Qty * $pp->Rate) * 1;
                            $out=0;
                            $current=($Qty * $pp->Rate) * 1;
                        }


                        //Product Moves
                        $move=[

                            'Date'=>date('Y-m-d'),
                            'Type'=>  'بدايه فتره' ,
                            'TypeEn'=>'Start Period',
                            'Bill_Num'=>$Bill->Code,
                            'Incom'=>$Qty * $pp->Rate,
                            'Outcom'=>0,
                            'Current'=>$Qty * $pp->Rate,
                            'CostIn'=>number_format((float)$in, 2, '.', ''),
                            'CostOut'=>number_format((float)$out, 2, '.', ''),
                            'CostCurrent'=>number_format((float)$current, 2, '.', ''),
                            'P_Ar_Name'=>$P_Ar_Name,
                            'P_En_Name'=>$P_En_Name,
                            'P_Code'=>$P_Code,
                            'Unit'=>$Unit,
                            'Qty'=>$Qty,
                            'Group'=>$prooooo->Group,
                            'Store'=>$Store,
                            'Product'=>$Product,
                            'V1'=>$VOne,
                            'V2'=>$VTwo,
                            'Brand'=>$prooooo->Brand,
                            'Safe'=>null,
                            'Branch'=>$branch->Branch,
                            'SalePrice'=>$plow->Price,
                            'ProductPrice'=>null,
                            'Delegate'=>null,
                            'Payment_Method'=>null,
                            'User'=>auth()->guard('admin')->user()->id,

                        ];

                        $this->ProductMoves($move);


                    }


                    //Expire Date
                    if(!empty($Exp_Date[$i])){


                        $unit=ProductUnits::where('Unit',$Unit)->where('Product',$Product)->first();
                        $EXPO=$this->ExpireAvQties($Store,$Product,$P_Code);



                        if(!empty($EXPO)){


                            if($EXPO->Exp_Date == $Exp_Date){

                                $qq= $unit->Rate * $Qty ;
                                $NewExpQty=$EXPO->Qty + $qq ;
                                ExpireDateQty::where('id',$EXPO->id)->update(['Qty'=>$NewExpQty]);

                            }else{


                                $EXNEW['Qty']=$unit->Rate * $Qty;
                                $EXNEW['P_Ar_Name']=$EXPO->P_Ar_Name;
                                $EXNEW['P_En_Name']=$EXPO->P_En_Name;
                                $EXNEW['P_Code']=$EXPO->P_Code;
                                $EXNEW['PP_Code']=$EXPO->PP_Code;
                                $EXNEW['PPP_Code']=$EXPO->PPP_Code;
                                $EXNEW['PPPP_Code']=$EXPO->PPPP_Code;
                                $EXNEW['V_Name']=$EXPO->V_Name;
                                $EXNEW['VV_Name']=$EXPO->VV_Name;
                                $EXNEW['Store']=$EXPO->Store;
                                $EXNEW['Unit']=$EXPO->Unit;
                                $EXNEW['Product']=$EXPO->Product;
                                $EXNEW['V1']=$EXPO->V1;
                                $EXNEW['V2']=$EXPO->V2;
                                $EXNEW['Low_Unit']=$EXPO->Low_Unit;
                                $EXNEW['Exp_Date']=$Exp_Date;
                                $EXNEW['Group']=$EXPO->Group;
                                $EXNEW['Brand']=$EXPO->Brand;
                                $EXNEW['Branch']=$EXPO->Branch;

                                ExpireDateQty::create($EXNEW);

                            }


                        }else{

                            $CodesProducts=ProductUnits::where('Product',$Product)->select('Barcode')->get();
                            $prooooo=Products::find($Product);

                                $sNam=$V_Name;
                                $ssNam=$VV_Name;
                                $sId=$VOne;
                                $ssId=$VTwo;

                            $EXNEW['Qty']=$unit->Rate * $Qty;
                            $EXNEW['P_Ar_Name']=$P_Ar_Name;
                            $EXNEW['P_En_Name']=$P_En_Name;
                            $EXNEW['P_Code']=$P_Code;
                            $EXNEW['Store']=$Store;
                            $EXNEW['V1']=$sId;
                            $EXNEW['V2']=$ssId;
                            $EXNEW['Exp_Date']=$Exp_Date;
                            $EXNEW['Unit']=$Unit;
                            $EXNEW['Product']=$Product;
                            $EXNEW['V_Name']=$sNam;
                            $EXNEW['VV_Name']=$ssNam;
                            $EXNEW['P_Code']=$P_Code;
                                $EXNEW['PP_Code']=null;
                                $EXNEW['PPP_Code']=null;
                                $EXNEW['PPPP_Code']=null;
                            $EXNEW['Group']=$prooooo->Group;
                            $EXNEW['Brand']=$prooooo->Brand;
                            $EXNEW['Branch']=$branch->Branch;
                            $EXNEW['Low_Unit']=$plow->Unit;
                            ExpireDateQty::create($EXNEW);

                        }



                    }

                    //Fifo
                    if($def->Cost_Price == 2){


                        $fifo=$this->FifoAvQty($Store,$Product,$P_Code,date('Y-m-d'));


                        if(!empty($fifo)){

                            $qq= $pp->Rate * $Qty ;

                            $newqty=$fifo->Qty + $qq ;

                            FifoQty::where('id',$fifo->id)->update(['Qty'=>$newqty,'Original_Qty'=>$newqty]);

                        }else{



                                $sNam=$V_Name;
                                $ssNam=$VV_Name;
                                $sId=$VOne;
                                $ssId=$VTwo;


                            $prooooo=Products::find($Product);

                            $pqty['P_Ar_Name']=$P_Ar_Name;
                            $pqty['Exp_Date']=$Exp_Date;
                            $pqty['P_En_Name']=$P_En_Name;
                            $pqty['Qty']=$Qty[$i] * $pp->Rate;
                            $pqty['Original_Qty']=$Qty * $pp->Rate;
                            $pqty['Cost_Price']=$Price;
                            $pqty['Store']=$Store;
                            $pqty['Unit']=$Unit;
                            $pqty['Low_Unit']=$plow->Unit;
                            $pqty['Product']=$Product;
                            $pqty['SearchCode1']=$prooooo->SearchCode1;
                            $pqty['SearchCode2']=$prooooo->SearchCode2;
                            $pqty['V1']=$VOne;
                            $pqty['V2']=$VTwo;
                            $pqty['V_Name']=$V_Name;
                            $pqty['VV_Name']=$VV_Name;
                            $pqty['P_Code']=$P_Code;
                            $pqty['PP_Code']=null;
                            $pqty['PPP_Code']=null;
                            $pqty['PPPP_Code']=null;
                            $pqty['Group']=$prooooo->Group;
                            $pqty['Brand']=$prooooo->Brand;
                            $pqty['Branch']=$branch->Branch;
                            $pqty['Purchases_Date']=date('Y-m-d');
                            FifoQty::create($pqty);

                        }




                    }

        $date=date('Y-m-d');

        //Joun

        $JunID = DB::table('journalizings')->insertGetId(

            array(


                'Type' => 'اصناف بداية فترة',
                'TypeEn' => 'Start Period Products',
                'Code_Type' => $Bill->Code,
                'Date' =>$date,
                'Draw' =>$Draw,
                'Coin' =>$Coin,
                'Cost_Center' => null,
                'Total_Debaitor' =>$total,
                'Total_Creditor' =>$total,
                'Note' =>null,

            )
        );

        $Code=Journalizing::findOrFail($JunID)->Code;





        $store=Stores::find($Store);
        $s=Stores::find($Store);

        $PRODUCTSS['Joun_ID']=$JunID;
        $PRODUCTSS['Debitor']=$total;
        $PRODUCTSS['Creditor']=0;
        $PRODUCTSS['Account']=$store->Account;
        $PRODUCTSS['Statement']=null;


        JournalizingDetails::create($PRODUCTSS);


        $Gen['Code']=$Code;
        $Gen['Code_Type']=$Bill->Code;
        $Gen['Date']=$date;
        $Gen['Type']= 'اصناف بداية فترة';
        $Gen['TypeEn']='Start Period Products';
        $Gen['Debitor']=$total;
        $Gen['Creditor']=0;
        $Gen['Statement']=null;
        $Gen['Draw']=$Draw;
        $Gen['Debitor_Coin']= $Draw * $total;
        $Gen['Creditor_Coin']=$Draw * 0;
        $Gen['Account']=$store->Account;
        $Gen['Coin']= $Coin;
        $Gen['Cost_Center']=null;
        $Gen['userr']= auth()->guard('admin')->user()->id;

        GeneralDaily::create($Gen);




        $PRODUCTSS['Joun_ID']=$JunID;
        $PRODUCTSS['Debitor']=0;
        $PRODUCTSS['Creditor']=$total;
        $PRODUCTSS['Account']=45;
        $PRODUCTSS['Statement']=null;


        JournalizingDetails::create($PRODUCTSS);



        $Gen['Code']=$Code;
        $Gen['Code_Type']=$Bill->Code;
        $Gen['Date']=$date;
        $Gen['Type']= 'اصناف بداية فترة';
        $Gen['TypeEn']='Start Period Products';
        $Gen['Debitor']=0;
        $Gen['Creditor']=$total;
        $Gen['Statement']=null;
        $Gen['Draw']=$Draw;
        $Gen['Debitor_Coin']= $Draw * 0;
        $Gen['Creditor_Coin']=$Draw * $total;
        $Gen['Account']=45;
        $Gen['Coin']= $Coin;
        $Gen['Cost_Center']= null;
        $Gen['userr']= auth()->guard('admin')->user()->id;

        GeneralDaily::create($Gen);

        //Stores Moves
        $totpri=($total) ;

        $dataStMove=[

            'Date'=>date('Y-m-d'),
            'Code'=>$Bill->Code ,
            'Time'=>date("h:i:s a", time()),
            'Branch'=>$branch->Branch,
            'Store'=>$Store,
            'Safe'=>null,
            'Type'=>'بدايه فتره',
            'TypeEn'=>'Start Period',
            'Cost_Center'=>null,
            'User'=>auth()->guard('admin')->user()->id,
            'Coin'=>$Coin,
            'Note'=>null,
            'Total_Qty'=>100000,
            'Total_Price'=>$totpri,
            'Account'=>null,
            'Ship'=>null,
            'ID'=>$IDStart,

        ];

        $this->StoresMoves($dataStMove);




        }









    }
}
