<?php

namespace App\Listeners\PaymentVoucher;

use App\Events\AddPaymentVoucherEvent;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;
use App\Models\Journalizing;
use App\Models\PaymentVoucherDetails;
use App\Models\PaymentVoucher;
use App\Models\SafesBanks;
use App\Events\AddJournalizingEvent;
use DB;

class AddPaymentVoucherListener
{


     use GeneralTrait;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\TestEvent  $event
     * @return void
     */
    public function handle(AddPaymentVoucherEvent $event)
    {

          $Branch=SafesBanks::where('Account',$event->requests['Safe'])->latest('id')->first()->Branch;

        $IDD = DB::table('payment_vouchers')->insertGetId(

        array(


            'Date' => $event->requests['Date'],
             'Draw' => $event->requests['Draw'],
            'Coin' => $event->requests['Coin'],
            'Safe' => $event->requests['Safe'],
            'Cost_Center' => $event->requests['Cost_Center'],
            'Total_Debaitor' =>$event->requests['Total_Debaitor'],
            'Note' =>$event->requests['Note'],
            'Responsiple' =>$event->requests['Responsiple'],
          'Branch'=>$Branch,
             'Status' => $event->status,
             'File' => $event->zfile,

        )
    );






         $Debitor = $event->requests['Debitor'];
         $Account = $event->requests['Account'];
         $Statement = $event->requests['Statement'];
         $Bill_Num = $event->requests['Bill_Num'];
         $Order_Number = $event->requests['Order_Number'];
         $Tax = $event->requests['Tax'];
         $CostCenterTable = $event->requests['CostCenterTable'];


        for($z=0 ; $z < count($Debitor) ; $z++){

        $PRODUCTS['PV_ID']=$IDD;
        $PRODUCTS['Debitor']=$Debitor[$z];
        $PRODUCTS['Account']=$Account[$z];
        $PRODUCTS['Bill_Num']=$Bill_Num[$z];
        $PRODUCTS['Order_Number']=$Order_Number[$z];
        $PRODUCTS['Tax']=$Tax[$z];
        $PRODUCTS['Statement']=$Statement[$z];

        $PRODUCTS['Date']=$event->requests['Date'];
        $PRODUCTS['Time']=date("h:i:s a", time());
        $PRODUCTS['Cost_Center']=$CostCenterTable[$z];
        $PRODUCTS['Coin']=$event->requests['Coin'];
        $PRODUCTS['User']=auth()->guard('admin')->user()->id;
        $PRODUCTS['Branch']=$Branch;
        $PRODUCTS['Safe']=$event->requests['Safe'];

         PaymentVoucherDetails::create($PRODUCTS);


             }



        //Notifications
        if($event->status == 0){

              $order=[
                'noti_name_ar'=>' سند صرف يحتاج للتأكيد',
                'noti_name_en'=>'Payment Voucher Need Confirmation',
                'type_ar'=>'سند صرف',
                'type_en'=>'Payment Voucher',
                'type_code'=>$event->requests['Code'],
                'emp'=>null,
                'client'=>null,
                'product'=>null,
                'store'=>null,
                'safe'=>null,
                'notify_name'=>trans('admin.Payment_Voucher_Need_Confirmation'),
            ];
            $this->CreateNotification($order);


        }



      //Recipt Jounralizing
         if($event->status == 1){

             $type_ar=  'سند صرف';
             $type_en= 'Payment Voucher';
             $type=0;
             $Status=1;
             $custom=1;
             $code_type=PaymentVoucher::findOrFail($IDD);

             $custom_data=[
             'Debitor'=>0,
             'Creditor'=>$event->requests['Total_Debaitor'],
             'Account'=>$event->requests['Safe'],
             'Statement'=>$event->requests['Note'],
             'Safe'=>$event->requests['Safe'],
             'Branch'=>$Branch,
             'Code_Type'=>$code_type->Code,
             'Date'=>$event->requests['Date'],
             'Draw'=>$event->requests['Draw'],
             'Coin'=>$event->requests['Coin'],
             'Cost_Center'=>$event->requests['Cost_Center'],

             ];



             AddJournalizingEvent::dispatch($event->requests,$Status,$type,$type_ar,$type_en,$custom,$custom_data);


         }






    }
}
