<?php

namespace App\Listeners\Insurance;

use App\Events\InsurancePaperEvent;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;
use App\Models\Journalizing;
use App\Models\InsurancePaper;
use DB;

class InsurancePaperListener
{
    

     use GeneralTrait;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\TestEvent  $event
     * @return void
     */
    public function handle(InsurancePaperEvent $event)
    {
        
                   if(!empty($event->requests['FromEn'])){
                   $FromEEN=$event->requests['FromEn'];

                   }else{
                   $FromEEN=$event->requests['From'];
                   }


                   if(!empty($event->requests['ToEn'])){
                   $ToEEN=$event->requests['ToEn'];

                   }else{
                   $ToEEN=$event->requests['To'];
                   }


                   $IDD = DB::table('insurance_papers')->insertGetId(

                   array(

                   'Date' => $event->requests['Date'],
                   'Draw' => $event->requests['Draw'],
                   'From' => $event->requests['From'],
                   'To' => $event->requests['To'],
                   'FromEn' => $FromEEN,
                   'ToEn' => $ToEEN,
                   'Note' => $event->requests['Note'],
                   'Due_Date' => $event->requests['Due_Date'],
                   'Amount' => $event->requests['Amount'],
                   'Status' => 0,
                   'Coin' => $event->requests['Coin'],
                   'Cost_Center' => $event->requests['Cost_Center'],
                   'Account' => $event->requests['Account'],
                   'Bank' => null,
                   'File' => $event->zfile,
                   'User' => auth()->guard('admin')->user()->id,

                   )
                   );
        
         $Code=InsurancePaper::findOrFail($IDD);
 
        //Event
      
       $data=[
             
             'start_date'=>$event->requests['Due_Date'],
             'end_date'=>$event->requests['Due_Date'],
             'event_name_ar'=>'وصل امانة',
             'event_name_en'=>'Insurance Paper',
             'type'=>'وصل امانة',
             'type_id'=>null,
             'type_code'=>$Code->Code,
             'emp'=>null,
             'client'=>$event->requests['Account'],
             'product'=>null,
             'customer'=>null,
       
         ];
         

           $this->CreateEvent($data);

        
        
    
      //Jounralizing               
$type_ar='وصل أمانة';
$type_en='Insurance Paper';
$debitor=$event->requests['Amount'];
$creditor=$event->requests['Amount'];
$account_cred=$event->requests['Account'];
$account_debt=35;
$date=$event->requests['Date'];
$draw=$event->requests['Draw'];
$coin=$event->requests['Coin'];
$cost_center=$event->requests['Cost_Center'];
$note=$event->requests['Note'];
$total=$event->requests['Amount'];
$joun_id=0;        
$Code_Type=$Code->Code;      
 $Code=0;     

       $data=[
             
             'type_ar'=>$type_ar,
             'type_en'=>$type_en,
             'code'=>$Code,
             'code_type'=>$Code_Type,
             'date'=>$date,
             'draw'=>$draw,
             'coin'=>$coin,
             'cost_center'=>$cost_center,
             'note'=>$note,
             'debitor_cred'=>0,
             'creditor_cred'=>$creditor,
             'account_cred'=>$account_cred,        
             'debitor_debt'=>$debitor,
             'creditor_debt'=>0,
             'account_debt'=>$account_debt,
             'total'=>$total,
             'joun_id'=>$joun_id,
         ];
         
        $joun_id=$this->CreateNewJun($data);   
          $new=Journalizing::findOrFail($joun_id);
         $data['code']=$new->Code;  
         $data['joun_id']=$joun_id;  
    
           $this->JunDetails($data);     
        
   
        
    }
}
