<?php

namespace App\Listeners\HR;

use App\Events\SalaryDue;
use App\Models\AccountsDefaultData;
use App\Models\AllowencesEmp;
use App\Models\Borrowa;
use App\Models\Deduction;
use App\Models\DepartureEmp;
use App\Models\DiscountsEmp;
use App\Models\EmpInstallmentDetails;
use App\Models\Employess;
use App\Models\EmpRatio;
use App\Models\EmpsProducationPoint;
use App\Models\EmpsProducationQuantity;
use App\Models\Entitlement;
use App\Models\Holidays;
use App\Models\Journalizing;
use App\Models\PaySalary;
use App\Models\RegOverTime;
use App\Models\Sales;
use App\Models\Settlement;
use App\Models\ShippingList;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;
use App\Models\JournalizingDetails;
use App\Models\GeneralDaily;
use App\Models\Assets;
use DB;
use DateTime;
use Illuminate\Support\Carbon;

class SalaryDueListener
{


    use GeneralTrait;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\TestEvent  $event
     * @return void
     */
 
 public function handle(SalaryDue $event)
    {
        // ... (rest of the code for checking salaryDueExists) ...
        $currentMonth = Carbon::now()->format('Y-m');
        $salaryDueExists = GeneralDaily::where('Type', 'استحقاق راتب')
                                        ->whereBetween('Date', [Carbon::now()->startOfMonth(), Carbon::now()->endOfMonth()])
                                        ->exists();

        if ($salaryDueExists) {
            return;
        }

        $employees = Employess::where('Active', 1)
                            ->whereNotIn('id', [38, 39, 40, 41, 42])
                            ->get();

        $employeeIds = $employees->pluck('id');
        $lastJournalCode = optional(Journalizing::latest('Code')->first())->Code ?? 0;

        // Fetch and group all necessary data
        $borrowas = Borrowa::where('Month', $currentMonth)->whereIn('Emp', $employeeIds)->get()->groupBy('Emp');
        $prodPoints = EmpsProducationPoint::where('Month', $currentMonth)->whereIn('Emp', $employeeIds)->get()->groupBy('Emp');
        $deductions = Deduction::where('Month', $currentMonth)->whereIn('Emp', $employeeIds)->get()->groupBy('Emp');
        $entitlements = Entitlement::where('Month', $currentMonth)->whereIn('Emp', $employeeIds)->get()->groupBy('Emp');
        $installments = EmpInstallmentDetails::where('Date', 'like', "{$currentMonth}%")->whereIn('Emp', $employeeIds)->get()->groupBy('Emp');
        $overtimes = RegOverTime::where('Month', $currentMonth)->whereIn('Emp', $employeeIds)->get()->groupBy('Emp');
        $attendances = DepartureEmp::where('Month', $currentMonth)->whereIn('Emp', $employeeIds)->get()->groupBy('Emp');
        $holidays = Holidays::where('Month', $currentMonth)->whereIn('Emp', $employeeIds)->where('Discount', 1)->get()->groupBy('Emp');

        // Ensure these queries have monthly filters for better performance and accuracy
        $sales = Sales::where('Status', 1)->where('Date', 'like', "{$currentMonth}%")->whereIn('Delegate', $employeeIds)->get()->groupBy('Delegate');
        $execSales = Sales::where('Status', 1)->where('Date', 'like', "{$currentMonth}%")->whereIn('Executor', $employeeIds)->get()->groupBy('Executor');
        $shippingLists = ShippingList::where('Status', 1)->where('Date', 'like', "{$currentMonth}%")->whereIn('Driver', $employeeIds)->get()->groupBy('Driver');
        $ratios = EmpRatio::whereIn('Emp', $employeeIds)->get()->groupBy('Emp'); // Ratios might not be month-specific, so this is okay.


        DB::beginTransaction();

        try {
            foreach ($employees as $employee) {
                $employeeId = $employee->id;
                $currentJournalCode = ++$lastJournalCode;

                // Safely sum values. The `->get($employeeId, collect())` approach is robust.
                $borrowAmount = $borrowas->get($employeeId, collect())->sum('Amount');
                $prodPointSum = $prodPoints->get($employeeId, collect())->sum('Point');
                // THIS LINE: Use `collect()` as the default value if the employeeId key doesn't exist
                $deductionAmount = $deductions->get($employeeId, collect())->sum('Amount');
                $entitlementAmount = $entitlements->get($employeeId, collect())->sum('Amount');
                $installmentValue = $installments->get($employeeId, collect())->sum('Value');
                $overtimeAmount = $overtimes->get($employeeId, collect())->sum('Amount');

                // For attendance, sum on the retrieved collection
                $employeeAttendances = $attendances->get($employeeId, collect());
                $attendanceHours = $employeeAttendances->sum('Hours_Number');
                $discLate = $employeeAttendances->sum('Disc_Late');
                $discDeparture = $employeeAttendances->sum('Disc_Early');

                $holidayDays = $holidays->get($employeeId, collect())->sum('Num_of_Days');

                // Recalculate sales and shipping commissions more efficiently
                $salesAmount = $sales->get($employeeId, collect())->sum('Total_Price');
                $execAmount = $execSales->get($employeeId, collect())->sum('Total_Price');
                $shippingAmount = $shippingLists->get($employeeId, collect())->sum('Total_Price');

                $empRatios = $ratios->get($employeeId, collect());
                $salesCommission = $this->calculateCommission($empRatios->where('Typee', 1), $salesAmount);
                $execCommission = $this->calculateCommission($empRatios->where('Typee', 2), $execAmount);
                $shippingCommission = $this->calculateCommission($empRatios->where('Typee', 3), $shippingAmount);


                // Calculate point-based compensation.
                $prodPointValue = 0;
                $qtyData = EmpsProducationQuantity::where('Emp', $employeeId)->get(); // This is still an N+1 query. Ideally, fetch all `EmpsProducationQuantity` outside the loop, then filter.
                $remainingPoints = $prodPointSum;

                // Refactored point calculation logic
                foreach ($qtyData as $qty) {
                    if ($remainingPoints <= 0) break; // Optimization: stop if no points left
                    if ($prodPointSum >= $qty->FromQ) { // Only consider tiers where total points meet the 'From' threshold
                        $tierPoints = min($remainingPoints, $qty->ToQ - $qty->FromQ + 1); // +1 because `ToQ` is inclusive
                        $prodPointValue += $tierPoints * $qty->ValueQ;
                        $remainingPoints -= $tierPoints;
                    }
                }


                // Simplified calculations for hourly and daily rates
                // Ensure $employee->Hours_Numbers is not zero to prevent division by zero
                $hourCost = ($employee->Hours_Numbers > 0) ? ($employee->Salary / $employee->Hours_Numbers) : 0;
                $workDayHours = ($employee->Hours_Numbers > 0) ? ($employee->Hours_Numbers / 30) : 0; // Assuming 30-day month
                $holidayDiscount = ($hourCost * $workDayHours) * $holidayDays;


                $grossPay = $employee->Salary + $entitlementAmount + $overtimeAmount + $prodPointValue + $salesCommission + $execCommission + $shippingCommission;
                $deductionsTotal = $borrowAmount + $deductionAmount + $installmentValue + $holidayDiscount + $discLate + $discDeparture;
                $netSalary = $grossPay - $deductionsTotal;

                if ($netSalary <= 0) {
                    $netSalary = 0;
                }

                if ($netSalary > 0) {
                    $accDefaults = AccountsDefaultData::latest('id')->first();

                    // ... (Journalizing and GeneralDaily insertions) ...
                    // All the insertion logic remains the same as previously refactored.
                    // Make sure $accDefaults is not null before accessing its properties.
                     if ($accDefaults) {
                        $journalId = DB::table('journalizings')->insertGetId([
                            'Code' => $currentJournalCode,
                            'Type' => 'استحقاق راتب',
                            'TypeEn' => 'Salary Due',
                            'Code_Type' => $currentJournalCode,
                            'Date' => Carbon::now()->format('Y-m-d'),
                            'Draw' => $accDefaults->Draw,
                            'Coin' => $accDefaults->Coin,
                            'Cost_Center' => null,
                            'Total_Debaitor' => $netSalary,
                            'Total_Creditor' => $netSalary,
                            'Note' => '',
                        ]);

                        JournalizingDetails::create([
                            'Joun_ID' => $journalId,
                            'Debitor' => $netSalary,
                            'Creditor' => 0,
                            'Account' => $employee->Account_Emp,
                            'Statement' => null,
                        ]);

                        GeneralDaily::create([
                            'Code' => $currentJournalCode,
                            'Code_Type' => $currentJournalCode,
                            'Date' => Carbon::now()->format('Y-m-d'),
                            'Type' => 'استحقاق راتب',
                            'TypeEn' => 'Salary Due',
                            'Debitor' => $netSalary,
                            'Creditor' => 0,
                            'Statement' => null,
                            'Draw' => $accDefaults->Draw,
                            'Debitor_Coin' => $accDefaults->Draw * $netSalary,
                            'Creditor_Coin' => 0,
                            'Account' => $employee->Account_Emp,
                            'Coin' => $accDefaults->Coin,
                            'Cost_Center' => null,
                            'userr' => 1,
                        ]);

                        JournalizingDetails::create([
                            'Joun_ID' => $journalId,
                            'Debitor' => 0,
                            'Creditor' => $netSalary,
                            'Account' => $employee->Merit,
                            'Statement' => null,
                        ]);

                        GeneralDaily::create([
                            'Code' => $currentJournalCode,
                            'Code_Type' => $currentJournalCode,
                            'Date' => Carbon::now()->format('Y-m-d'),
                            'Type' => 'استحقاق راتب',
                            'TypeEn' => 'Salary Due',
                            'Debitor' => 0,
                            'Creditor' => $netSalary,
                            'Statement' => null,
                            'Draw' => $accDefaults->Draw,
                            'Debitor_Coin' => 0,
                            'Creditor_Coin' => $accDefaults->Draw * $netSalary,
                            'Account' => $employee->Merit,
                            'Coin' => $accDefaults->Coin,
                            'Cost_Center' => null,
                            'userr' => 1,
                        ]);
                    } // End if ($accDefaults)
                } // End if ($netSalary > 0)
            } // End foreach ($employees as $employee)

            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            logger()->error("Salary due process failed. Error: " . $e->getMessage());
        }
    }

    protected function calculateCommission($ratios, $totalAmount)
    {
        $commission = 0;
        foreach ($ratios as $ratio) {
            // Check if the total amount falls within the ratio's range
            if ($totalAmount >= $ratio->From && $totalAmount <= $ratio->To) {
                $commission += ($ratio->Rate / 100) * $totalAmount;
                // If only one ratio should apply, uncomment the next line:
                // break;
            }
        }
        return $commission;
    }    
 
}
