<?php

namespace App\Listeners\Consist;

use App\Events\ConsistEvent;
use App\Models\Consists;
use App\Models\FifoQty;
use App\Models\GeneralDaily;
use App\Models\JournalizingDetails;
use App\Models\ProductsConsists;
use App\Models\ProductsStartPeriods;
use App\Models\SalesFifoQty;
use App\Models\StartPeriods;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;

use App\Models\Journalizing;
use App\Models\SubVirables;
use App\Models\ExpireDateQty;
use App\Models\ProductUnits;
use App\Models\ProductMoves;
use App\Models\ProductsQty;
use App\Models\Stores;
use App\Models\StoresDefaultData;
use App\Models\Products;
use DB;
use App\Services\Average;


class ConsistListener
{


    use GeneralTrait;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\TestEvent  $event
     * @return void
     */
    public function handle(ConsistEvent $event)
    {


        $average = new Average ;

        $Bill=Consists::findOrFail($event->ID);
        $branch=Stores::findOrFail($event->requests['Store']);
        $store=Stores::findOrFail($event->requests['Store']);
        $def=StoresDefaultData::latest('id')->first();


        if(empty($event->requests['Note'])){
            $event->requests['Note']=null;
        }


        //Products Details and Qties


        if(!empty($event->requests['Unit'])){

            $P_Ar_Name=$event->requests['P_Ar_Name'];
            $P_En_Name=$event->requests['P_En_Name'];
            $Unit=$event->requests['Unit'];
            $P_Code=$event->requests['P_Code'];
            $P_Qty=$event->requests['Qty'];
            $P_Price=$event->requests['Price'];
            $Total=$event->requests['Total'];
            $P_Product=$event->requests['Product'];
            $P_VOne=$event->requests['VOne'];
            $P_VTwo=$event->requests['VTwo'];
            $V_Name=$event->requests['V_Name'];
            $VV_Name=$event->requests['VV_Name'];
            $Exp_Date=$event->requests['Exp_Date'];
            $Consist=$event->requests['Consist'];


            for($i=0 ; $i < count($Unit) ; $i++){

                $uu['Product_Code']=$P_Code[$i];
                $uu['P_Ar_Name']=$P_Ar_Name[$i];
                $uu['P_En_Name']=$P_En_Name[$i];
                $uu['V_Name']=$V_Name[$i];
                $uu['VV_Name']=$VV_Name[$i];
                $uu['Qty']=$P_Qty[$i];
                $uu['Consist']=$Consist[$i];
                $uu['Price']=$P_Price[$i];
                $uu['Total']=$Total[$i];
                $uu['Product']=$P_Product[$i];
                $uu['V1']=$P_VOne[$i];
                $uu['V2']=$P_VTwo[$i];
                $uu['Unit']=$Unit[$i];
                $uu['Exp_Date']=$Exp_Date[$i];
                $uu['Consist_ID']=$event->ID;

                ProductsConsists::create($uu);

                $unit=ProductUnits::where('Unit',$Unit[$i])->where('Product',$P_Product[$i])->first();
                $Quantity=$this->ProAvQties($event->requests['Store'],$P_Product[$i],$P_Code[$i]);
                $prooooo=Products::findOrFail($P_Product[$i]);


                if(!empty($Quantity)){
                    $unit=ProductUnits::where('Unit',$Unit[$i])->where('Product',$P_Product[$i])->first();

                    $qq= $unit->Rate * $Consist[$i] ;

                    $newqty=$Quantity->Qty -  $qq ;

                    //Products Qties
                    if($def->Cost_Price == 2){
                        $totCost=0;

                        $fifo=$this->FifoAvQtyDate($event->requests['Store'],$P_Product[$i],$P_Code[$i]);

                        if(!empty($fifo)){

                            if($fifo->Qty == 0){

                                $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                                if($NNQuntatity == 0){


                                    $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                                }else{



                                    if($NNQuntatity >= $Consist[$i]){

                                        $totCost += $fifo->Cost_Price * $Consist[$i] ;

                                    }else{

                                        $res=$Consist[$i] - $NNQuntatity ;


                                        $totCost += $fifo->Cost_Price * $NNQuntatity ;

                                        $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                        $totCost +=$ResdiualCost;

                                    }


                                }



                            }else{


                                if($fifo->Qty >= $Consist[$i]){

                                    $totCost += $fifo->Cost_Price * $Consist[$i] ;

                                }else{

                                    $res=$Consist[$i] - $fifo->Qty ;


                                    $totCost += $fifo->Cost_Price * $fifo->Qty ;

                                    $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                    $totCost +=$ResdiualCost;

                                }



                            }


                        }

                        $newQQty= $unit->Rate * $Consist[$i] ;
                        $CostTotalSale=$totCost;


                        $lastOperation=ProductMoves::latest('id')->where('P_Code',$P_Code[$i])->where('Product',$P_Product[$i])->where('Store',$event->requests['Store'])->first();
                        $in=0;
                        $out=$CostTotalSale;

                        if(!empty($lastOperation->Current)){
                            if($lastOperation->Current != 0){
                                $current=($lastOperation->Current - $newQQty) *  $totCost;
                            }else{
                                $current=( $newQQty) *  $totCost;
                            }
                        }else{

                            $current=($newQQty) *  $totCost;
                        }



                        $cur= $totCost ;

                        $ty=$cur / $newQQty ;

                            ProductsQty::where('id', $Quantity->id)->update(['Qty' => $newqty, 'Price' => $ty, 'TotalCost' => $cur]);




                    }else{


                        $newQQty= $unit->Rate * $Consist[$i] ;

                        $ty=$average->AverageCostGetUnit($P_Product[$i],$P_Code[$i],$event->requests['Store'],$Unit[$i]);

                        $CostTotalSale=$ty * $newQQty;



                        $in=0;
                        $out=$CostTotalSale;

                        $current= $newqty *  ($ty / $unit->Rate);

                        $cur=$newqty * ($ty / $unit->Rate) ;

                            ProductsQty::where('id', $Quantity->id)->update(['Qty' => $newqty, 'Price' => $ty, 'TotalCost' => $cur]);

                    }


                        //Products Moves
                        $move = [

                            'Date' => $event->requests['Date'],
                            'Type' => 'توالف',
                            'TypeEn' => 'Consists',
                            'Bill_Num' => $Bill->Code,
                            'Incom' => 0,
                            'Outcom' => $qq,
                            'Current' => $newqty,
                            'CostIn' => number_format((float)$in, 2, '.', ''),
                            'CostOut' => number_format((float)$out, 2, '.', ''),
                            'CostCurrent' => number_format((float)$current, 2, '.', ''),
                            'P_Ar_Name' => $P_Ar_Name[$i],
                            'P_En_Name' => $P_En_Name[$i],
                            'P_Code' => $P_Code[$i],
                            'Unit' => $Unit[$i],
                            'Qty' => $Consist[$i],
                            'Group' => $prooooo->Group,
                            'Store' => $event->requests['Store'],
                            'Product' => $P_Product[$i],
                            'V1' => $P_VOne[$i],
                            'V2' => $P_VTwo[$i],
                            'Brand' => $prooooo->Brand,
                            'Safe' => null,
                            'Branch' => $branch->Branch,
                            'SalePrice' => $P_Price[$i],
                            'ProductPrice' =>null,
                            'Delegate' => null,
                            'Payment_Method' => null,
                            'User' => auth()->guard('admin')->user()->id,

                        ];

                        $this->ProductMoves($move);


                }

                if (!empty($Exp_Date[$i])) {
                    $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $P_Product[$i])->first();

                    $qq = $unit->Rate * $Consist[$i];


                    $EXPO = ExpireDateQty::find($Exp_Date[$i]);
                    $NewExpQty = $EXPO->Qty - $qq;
                    ExpireDateQty::where('id', $Exp_Date[$i])->update(['Qty' => $NewExpQty]);


                }

                //Fifo

                if ($def->Cost_Price == 2) {

                    $fifo=$this->FifoAvQtyDate($event->requests['Store'] ,$P_Product[$i],$P_Code[$i]);


                    if (!empty($fifo)) {

                        if ($fifo->Qty >= $Consist[$i]) {


                            $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $P_Product[$i])->first();

                            $qq = $unit->Rate * $Consist[$i];

                            $newqty = $fifo->Qty - $qq;


                            FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty]);



                        } else {


                            $resdiualQty = $Consist[$i] - $fifo->Qty;

                            $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $P_Product[$i])->first();

                            $qq = $unit->Rate * $fifo->Qty;

                            $newqty = $fifo->Qty - $qq;


                            FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty]);



                        }


                    }


                }


            }


        }




        //Joun

        $JunID = DB::table('journalizings')->insertGetId(

            array(


                'Type' => 'تالف',
                'TypeEn' => 'Consists',
                'Code_Type' => $Bill->Code,
                'Date' =>$event->requests['Date'] ,
                'Draw' =>$event->requests['Draw'],
                'Coin' =>$event->requests['Coin'],
                'Cost_Center' => null,
                'Total_Debaitor' =>$event->requests['Total_Price'] ,
                'Total_Creditor' => $event->requests['Total_Price'],
                'Note' => $event->requests['Note'],

            )
        );

        $Code=Journalizing::findOrFail($JunID)->Code;


        $PRODUCTSS['Joun_ID']=$JunID;
        $PRODUCTSS['Debitor']=0;
        $PRODUCTSS['Creditor']=$event->requests['Total_Price'];
        $PRODUCTSS['Account']=$store->Account;
        $PRODUCTSS['Statement']=null;


        JournalizingDetails::create($PRODUCTSS);

        $Gen['Code']=$Code;
        $Gen['Code_Type']=$Bill->Code;
        $Gen['Date']=$event->requests['Date'];
        $Gen['Type']='تالف';
        $Gen['TypeEn']='Consists';
        $Gen['Debitor']=0;
        $Gen['Creditor']=$event->requests['Total_Price'];
        $Gen['Statement']=null;
        $Gen['Draw']=$event->requests['Draw'];
        $Gen['Debitor_Coin']=$event->requests['Draw'] * 0;
        $Gen['Creditor_Coin']=$event->requests['Draw'] * $event->requests['Total_Price'];
        $Gen['Account']=$store->Account;
        $Gen['Coin']= $event->requests['Coin'];
        $Gen['Cost_Center']=null;
        $Gen['userr']= auth()->guard('admin')->user()->id;

        GeneralDaily::create($Gen);


        $PRODUCTSS['Joun_ID']=$JunID;
        $PRODUCTSS['Debitor']=$event->requests['Total_Price'];
        $PRODUCTSS['Creditor']=0;
        $PRODUCTSS['Account']=$event->requests['Account'];
        $PRODUCTSS['Statement']=null;


        JournalizingDetails::create($PRODUCTSS);

        $Gen['Code']=$Code;
        $Gen['Code_Type']=$Bill->Code;
        $Gen['Date']=$event->requests['Date'];
        $Gen['Type']='تالف';
        $Gen['TypeEn']='Consists';
        $Gen['Debitor']=$event->requests['Total_Price'];
        $Gen['Creditor']=0;
        $Gen['Statement']=null;
        $Gen['Draw']=$event->requests['Draw'];
        $Gen['Debitor_Coin']= $event->requests['Draw'] * $event->requests['Total_Price'];
        $Gen['Creditor_Coin']=$event->requests['Draw'] * 0;
        $Gen['Account']=$event->requests['Account'];
        $Gen['Coin']= $event->requests['Coin'];
        $Gen['Cost_Center']= null;
        $Gen['userr']= auth()->guard('admin')->user()->id;

        GeneralDaily::create($Gen);




        //Stores Moves
        $totpri=($event->requests['Total_Price']) ;
        $TotQty=($event->requests['Total_Qty']) ;

        $dataStMove=[

            'Date'=>date('Y-m-d'),
            'Code'=>$Bill->Code ,
            'Time'=>date("h:i:s a", time()),
            'Branch'=>$branch->Branch,
            'Store'=>$event->requests['Store'],
            'Safe'=>null,
            'Type'=>' تالف',
            'TypeEn'=>'Consists',
            'Cost_Center'=>null,
            'User'=>auth()->guard('admin')->user()->id,
            'Coin'=>$event->requests['Coin'],
            'Note'=>$event->requests['Note'],
            'Total_Qty'=>$TotQty,
            'Total_Price'=>$totpri,
            'Account'=>$event->requests['Account'],
            'Ship'=>null,
            'ID'=>$event->ID,

        ];

        $this->StoresMoves($dataStMove);





    }
}
