<?php

namespace App\Listeners\Assets;

use App\Events\AssetsEvent;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;
use App\Models\Journalizing;
use App\Models\Assets;
use DB;
use DateTime;

class AssetsListener
{


     use GeneralTrait;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\TestEvent  $event
     * @return void
     */
    public function handle(AssetsEvent $event)
    {



    if($event->requests['Asset_Type'] == 'consumer'){
    $Asset_TypeAr='مستهلك';
    $Asset_TypeEn='consumer';
    }else{
    $Asset_TypeAr='غير مستهلك';
    $Asset_TypeEn='unconsumed';
    }


    if($event->requests['Asset_Type'] == 'Fixed'){
    $DeprAr='ثابت';
    $DeprEn='Fixed';
    }else{
    $DeprAr='متناقص';
    $DeprEn='decreasing';
    }


        if(!empty($event->requests['NameEn'])){

         $english_name=$event->requests['NameEn'];
         }else{

         $english_name=$event->requests['Name'];
         }



        if(!empty($event->requests['Vendor'])){

         $vendor=$event->requests['Vendor'];
         }else{

         $vendor=null;
         }
        if(!empty($event->requests['Safe'])){

         $safe=$event->requests['Safe'];
         }else{

         $safe=null;
         }

        if(!empty($event->requests['Depreciation_Complex'])){

         $Depreciation_Complex=$event->requests['Depreciation_Complex'];
         }else{

         $Depreciation_Complex=null;
         }

    // Account Trait
    $name_ar=$event->requests['Name'];
    $name_en=$english_name;
$parent=$event->requests['Main_Account'];
$note=null;
$Acc=$this->CreateAccount($name_ar,$name_en,$parent,$note);




    $dataa['Image']=$event->img;
    $dataa['Name']=$event->requests['Name'];
    $dataa['NameEn']=$english_name;
    $dataa['Asset_Type']=$Asset_TypeAr;
    $dataa['Asset_Type_En']=$Asset_TypeEn;
    $dataa['Depreciation_Method']=$DeprAr;
    $dataa['Depreciation_Method_En']=$DeprEn;
    $dataa['Purchases_Date']=date('Y-m', strtotime('+1 month'));
    $dataa['Operation_Date']=$event->requests['Operation_Date'];
    $dataa['Cost']=$event->requests['Cost'];
    $dataa['Previous_Depreciation']=$event->requests['Previous_Depreciation'];
    $dataa['Asset_Net']=$event->requests['Asset_Net'];
    $dataa['Annual_Depreciation_Ratio']=$event->requests['Annual_Depreciation_Ratio'];
    $dataa['Annual_Depreciation']=$event->requests['Annual_Depreciation'];
    $dataa['Life_Span']=$event->requests['Life_Span'];
    $dataa['Note']=$event->requests['Note'];
    $dataa['Depreciation_Expenses']=null;
    $dataa['Depreciation_Complex']=$Depreciation_Complex;
    $dataa['Main_Account']=$event->requests['Main_Account'];
    $dataa['Draw']=$event->requests['Draw'];
    $dataa['Coin']=$event->requests['Coin'];
    $dataa['Branch']=$event->requests['Branch'];
    $dataa['Cost_Center']=$event->requests['Cost_Center'];
    $dataa['Sort_Asset']=$event->requests['Sort_Asset'];
    $dataa['Vendor']=$vendor;
    $dataa['Safe']=$safe;
    $dataa['Ehlak']=$event->requests['Ehlak'];
    $dataa['Payment_Method']=$event->requests['Payment_Method'];
    $dataa['Account']=$Acc;
    $dataa['User']=auth()->guard('admin')->user()->id;

    Assets::create($dataa);


         $CodeA=Assets::latest('id')->first();



      //Jounralizing

    if($event->requests['Asset_Type'] == 'consumer'){

    $money=$event->requests['Asset_Net'];

    }else{

    $money= $event->requests['Cost'];
    }


    $type_ar='شراء أصل';
$type_en='Purchases Asset';
$date=date('Y-m-d');
$draw=$event->requests['Draw'];
$coin=$event->requests['Coin'];
$cost_center=$event->requests['Cost_Center'];
$note=$event->requests['Note'];
$joun_id=0;
$Code_Type=$CodeA->Code;
 $Code=0;


     if($event->requests['Sort_Asset']  == 1){


$account_cred=45;
$account_debt=$CodeA->Account;
$total=$money;
         $debitor=$money;
         $creditor=$money;

     }elseif($event->requests['Sort_Asset']  == 2){

     $account_cred=$event->requests['Safe'];
$account_debt=$event->requests['Vendor'];
if($event->requests['Payment_Method'] == 'Cash'){
    $total=$money;
    $debitor=$money;
    $creditor=$money;
}else{
    $total=0;
    $debitor=0;
    $creditor=0;
}


     }



       $data=[

             'type_ar'=>$type_ar,
             'type_en'=>$type_en,
             'code'=>$Code,
             'code_type'=>$Code_Type,
             'date'=>$date,
             'draw'=>$draw,
             'coin'=>$coin,
             'cost_center'=>$cost_center,
             'note'=>$note,
             'debitor_cred'=>0,
             'creditor_cred'=>$creditor,
             'account_cred'=>$account_cred,
             'debitor_debt'=>$debitor,
             'creditor_debt'=>0,
             'account_debt'=>$account_debt,
             'total'=>$total,
             'joun_id'=>$joun_id,
         ];

        $joun_id=$this->CreateNewJun($data);
          $new=Journalizing::findOrFail($joun_id);

         $data['code']=$new->Code;
         $data['joun_id']=$joun_id;
         $this->JunDetails($data);


        $debitor=$money;
        $creditor=$money;

        $data['debitor_debt']=$money;
        $data['creditor_cred']=$money;
if($event->requests['Sort_Asset']  == 2){
         $data['account_cred']=$event->requests['Vendor'];
         $data['account_debt']=$CodeA->Account;
           $this->JunDetails($data);
}





    }
}
