<?php

namespace App\Listeners\AccountManual;

use App\Events\DeleteAccountManualEvent;
use App\Models\InstallmentCompanies;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;
use App\Models\Journalizing;
use App\Models\SafesBanks;
use App\Models\Stores;
use App\Models\Vendors;
use App\Models\Customers;
use App\Models\Taxes;

class DeleteAccountManualEventListener
{


     use GeneralTrait;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\TestEvent  $event
     * @return void
     */
    public function handle(DeleteAccountManualEvent $event)
    {



          if($event->item->Parent == 28 or $event->item->Parent == 29){
         $safe=SafesBanks::where('Account',$event->item->id)->delete();
        }

        if($event->item->Parent == 27){
         $safe=Stores::where('Account',$event->item->id)->delete();
        }

        if($event->item->Parent == 37){
         $safe=Vendors::where('Account',$event->item->id)->delete();
        }

         if($event->item->Parent == 24){
         $safe=Customers::where('Account',$event->item->id)->delete();
        }

        if($event->item->Parent == 97){
         $safe=ShippingCompany::where('Account',$event->item->id)->delete();
        }

        if($event->item->Parent == 39){
         $safe=Taxes::where('Account',$event->item->id)->delete();
        }

        if($event->item->Parent == 888){
            $safe=InstallmentCompanies::where('Account',$event->item->id)->first();

             InstallmentCompanies::where('NakdyaAccount',$safe->NakdyaAccount)->delete();
            InstallmentCompanies::where('Account',$event->item->id)->delete();
        }





    }
}
