<?php

namespace App\Http\Resources;


use App\Models\ReciptVoucher;
use App\Models\Sales;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class ShiftsDetailsReportResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');


        $data = [


            'shift_id'=>$this->id,
            'shift_code'=>$this->Code,
            'shift_open_date'=>$this->Date,
            'shift_close_date'=>$this->Close_Date,
            'sales'=>$this->when(!empty($this->Code), function () {

                $SALES=SalesResources::collection(Sales::where('Shift_Code',$this->Code)->get());

                return $SALES;
            }),
            'vouchers'=>$this->when(!empty($this->Code), function () {

                $Recipts=ReciptsVouchersResources::collection(ReciptVoucher::where('Shift',$this->Code)->get());

                return $Recipts;
            }),


            'total_cash'=>$this->Total_Cash,
            'total_later'=>$this->Total_Later,
            'total_visa'=>$this->Total_Visa,
            'total_recipt'=>$this->Total_Recipt,
            'total_payment'=>$this->Total_Payment,
            'total_later_not_paid'=>$this->Total_Later_Not_Paid,
            'total_later_paid'=>$this->Total_Later_Paid,
            'total_installment'=>$this->Total_Installment,
            'total_checks'=>$this->Total_Checks,
            'total_delivery'=>$this->Total_Delivery,
            'total_installment_companies'=>$this->Total_Installment_Companies,
            'total'=>$this->Total,
            'amount'=>$this->Amount,

        ];




        return $data ;
    }

}
