<?php

namespace App\Http\Resources;
use App\Models\ProductSalesOrder;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class SalesOrderResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');

        if(!empty($this ->Executor()->first()->Name)){

            if($lang == 'ar'){
                $exe=$this ->Executor()->first()->Name;
            }else{
                $exe=$this ->Executor()->first()->NameEn;

            }

        }else{
            $exe='';
        }
        if(!empty($this ->Delegate()->first()->Name)){
            if($lang == 'ar'){
                $dele=$this ->Delegate()->first()->Name;
            }else{

                $dele=$this ->Delegate()->first()->NameEn;
            }
        }else{
            $dele='';
        }

        if($lang == 'ar'){
            $safeName=$this ->Safe()->first()->Name;
            $cliName=$this ->Client()->first()->Name;
            $stName=$this ->Store()->first()->Name;
            $coiName=$this ->Coin()->first()->Arabic_Name;
            $userName=$this ->User()->first()->name;

        }else{
            $safeName=$this ->Safe()->first()->NameEn;
            $cliName=$this ->Client()->first()->NameEn;
            $stName=$this ->Store()->first()->NameEn;
            $coiName=$this ->Coin()->first()->English_Name;
            $userName=$this ->User()->first()->nameEn;

        }



        if($this->Payment_Method == 'Cash'){
            $Payment_Method=trans('admin.Cash');
        }elseif ($this->Payment_Method == 'Later'){

            $Payment_Method=trans('admin.Later');
        }elseif ($this->Payment_Method == 'Delivery'){

            $Payment_Method=trans('admin.Delivery');
        }elseif ($this->Payment_Method == 'Cash_Visa'){

            $Payment_Method=trans('admin.Cash_Visa');
        }elseif ($this->Payment_Method == 'Visa'){

            $Payment_Method=trans('admin.Visa');
        }elseif ($this->Payment_Method == 'Cash_Collection'){

            $Payment_Method=trans('admin.Cash_Collection');
        }elseif ($this->Payment_Method == 'Check'){

            $Payment_Method=trans('admin.Check');
        }elseif ($this->Payment_Method == 'Installment'){

            $Payment_Method=trans('admin.Installment');
        }elseif ($this->Payment_Method == 'InstallmentCompanies'){

            $Payment_Method=trans('admin.InstallmentCompanies');
        }


            $data = [


                'id'=>$this ->id,
                'code'=>$this ->Code,
                'date'=>$this ->Date,
                'draw'=>$this ->Draw,
                'payment_method'=>$Payment_Method,
                'payment_methodEn'=>$this->Payment_Method,
                'refernce_number'=>$this ->Refernce_Number,
                'note'=>$this ->Note,
                'product_numbers'=>$this ->Product_Numbers,
                'total_qty'=>$this ->Total_Qty,
                'total_discount'=>$this ->Total_Discount,
                'total_bf_taxes'=>$this ->Total_BF_Taxes,
                'total_taxes'=>$this ->Total_Taxes,
                'total_price'=>$this ->Total_Price,
                'pay'=>$this ->Pay,
                'safe'=>$safeName,
                'safe_id'=>$this ->Safe,
                'client'=>$cliName,
                'client_id'=>$this ->Client,
                'executor'=>$exe,
                'executor_id'=>$this ->Executor,
                'delegate'=>$dele,
                'delegate_id'=>$this ->Delegate,
                'store'=>$stName,
                'store_id'=>$this ->Store,
                'coin'=>$coiName,
                'coin_id'=>$this ->Coin,
                'due_date'=>$this ->Due_Date,
                'shift_code'=>$this ->Shift_Code,
                'later_due'=>$this ->Later_Due,
                'later_collection'=>$this ->Later_Collection,
                'user'=>$userName,
                'user_id'=>$this ->User,
                'products'=>$this->when(!empty($this->id), function () {

                $details=ProductSalesOrderResources::collection(ProductSalesOrder::where('SalesOrder',$this->id)->get());

                return $details;
            }),

            ];



        return $data ;
    }

}
