<?php

namespace App\Http\Resources;


use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class SalesDefaultResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');


        if($lang ==  'ar') {
            $data = [

                'payment_method'=>$this->Payment_Method,
                'status'=>$this->Status,
                'safe_id'=>$this->Safe,
                'safe'=>$this->Safe()->first()->Name,
                'client_id'=>$this->Client,
                'client'=>$this->Client()->first()->Name,
                'delegate_id'=>$this->Delegate,
                'delegate'=>$this->Delegate()->first()->Name,
                'store_id'=>$this->Store,
                'store'=>$this->Store()->first()->Name,
                'coin_id'=>$this->Coin,
                'coin'=>$this->Coin()->first()->Arabic_Name,
                'draw'=>$this->Draw,
                'discount'=>$this->Discount,
                'price_sale'=>$this->Price_Sale,
                'shift_pass'=>$this->Shift_Pass,
                'delivery_id'=>$this->Delivery,
                'delivery'=>$this->Delivery()->first()->Name,
                'stores_qty'=>$this->StoresQty,
                'tax_type'=>$this->TaxType,
                'discount_tax_show'=>$this->DiscountTaxShow,
                'waiter_id'=>$this->Waiter,
                'waiter'=>$this->Waiter()->first()->Name,
                'hall_service_type'=>$this->Hall_Service_Type,
                'hall_service_precent'=>$this->Hall_Service_Precent,
                'bank_id'=>$this->Bank,
                'bank'=>$this->Bank()->first()->Name,
                'country_id'=>$this->Country,
                'country'=>$this->Country()->first()->Arabic_Name,
                'sales_low_cost_price'=>$this->SalesLowCostPrice,
                'limit_sales_qty'=>$this->LimitSalesQty,
                'total_weight_bill'=>$this->Total_Wight_Bill,
                'duplicate_items'=>$this->Duplicate_Items,
                'choice_collector_POS'=>$this->Choice_Collector_POS,
                'hide_discount_POS'=>$this->Hide_Discount_POS,
                'daily_clients'=>$this->Daily_Clients,
                'location_conditon'=>$this->Location_Conditon,
                'sales_order_type'=>$this->SalesOrderType,
                'Use_Max_Discount_Group'=>$this->Use_Max_Discount_Group,



            ];
        }else{


            $data = [


                'payment_method'=>$this->Payment_Method,
                'status'=>$this->Status,
                'safe_id'=>$this->Safe,
                'safe'=>$this->Safe()->first()->NameEn,
                'client_id'=>$this->Client,
                'client'=>$this->Client()->first()->NameEn,
                'delegate_id'=>$this->Delegate,
                'delegate'=>$this->Delegate()->first()->NameEn,
                'store_id'=>$this->Store,
                'store'=>$this->Store()->first()->NameEn,
                'coin_id'=>$this->Coin,
                'coin'=>$this->Coin()->first()->English_Name,
                'draw'=>$this->Draw,
                'discount'=>$this->Discount,
                'price_sale'=>$this->Price_Sale,
                'shift_pass'=>$this->Shift_Pass,
                'delivery_id'=>$this->Delivery,
                'delivery'=>$this->Delivery()->first()->NameEn,
                'stores_qty'=>$this->StoresQty,
                'tax_type'=>$this->TaxType,
                'discount_tax_show'=>$this->DiscountTaxShow,
                'waiter_id'=>$this->Waiter,
                'waiter'=>$this->Waiter()->first()->NameEn,
                'hall_service_type'=>$this->Hall_Service_Type,
                'hall_service_precent'=>$this->Hall_Service_Precent,
                'bank_id'=>$this->Bank,
                'bank'=>$this->Bank()->first()->NameEn,
                'country_id'=>$this->Country,
                'country'=>$this->Country()->first()->English_Name,
                'sales_low_cost_price'=>$this->SalesLowCostPrice,
                'limit_sales_qty'=>$this->LimitSalesQty,
                'total_weight_bill'=>$this->Total_Wight_Bill,
                'duplicate_items'=>$this->Duplicate_Items,
                'choice_collector_POS'=>$this->Choice_Collector_POS,
                'hide_discount_POS'=>$this->Hide_Discount_POS,
                'daily_clients'=>$this->Daily_Clients,
                'location_conditon'=>$this->Location_Conditon,
                'sales_order_type'=>$this->SalesOrderType,
                'Use_Max_Discount_Group'=>$this->Use_Max_Discount_Group,


            ];
        }



        return $data ;
    }

}
