<?php

namespace App\Http\Resources;


use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class SafeTransfersResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');

        if(!empty($this->Cost_Center()->first()->Arabic_Name)){



            if($lang == 'ar'){
                $Cost_Name=$this->Cost_Center()->first()->Arabic_Name;
            }else{
                $Cost_Name=$this->Cost_Center()->first()->Arabic_Name;

            }


        }else{
            $Cost_Name='';
        }



        if($lang == 'ar'){
            $FromsafeName=$this->From_Safe()->first()->Name;
            $TosafeName=$this->To_Safe()->first()->Name;
            $CoinName=$this->Coin()->first()->Arabic_Name;


        }else{
            $FromsafeName=$this->From_Safe()->first()->NameEn;
            $TosafeName=$this->To_Safe()->first()->NameEn;
            $CoinName=$this->Coin()->first()->English_Name;


        }



        if(!empty($this->User()->first()->name)){



            if($lang == 'ar'){
                $User_Name=$this->User()->first()->name;
            }else{
                $User_Name=$this->User()->first()->nameEn;

            }


        }else{
            $User_Name='';
        }



        if(!empty($this->Delegate()->first()->name)){



            if($lang == 'ar'){
                $Delegate_Name=$this->Delegate()->first()->name;
            }else{
                $Delegate_Name=$this->Delegate()->first()->nameEn;

            }


        }else{
            $Delegate_Name='';
        }



        if(!empty($this->Branch()->first()->name)){



            if($lang == 'ar'){
                $Branch_Name=$this->Branch()->first()->name;
            }else{
                $Branch_Name=$this->Branch()->first()->nameEn;

            }


        }else{
            $Branch_Name='';
        }

        $ArrayDet=array();

            array_push($ArrayDet,[

                'debitor'=>$this->Amount,
                'creditor'=>0,
                'account_code'=>$this->From_Safe()->first()->Code,
                'account_name'=>$FromsafeName,
                'statement'=>'',


            ]);

            array_push($ArrayDet,[

                'debitor'=>0,
                'creditor'=>$this->Amount,
                'account_code'=>$this->To_Safe()->first()->Code,
                'account_name'=>$TosafeName,
                'statement'=>'',


            ]);





            $data = [

                'id'=>$this->id,
                'code'=>$this->Code,
                'date'=>$this->Date,
                'amount'=>$this->Amount,
                'from_safe'=>$FromsafeName,
                'from_safe_id'=>$this->From_Safe,
                'to_safe'=>$TosafeName,
                'to_safe_id'=>$this->To_Safe,
                'draw'=>$this->Draw,
                'notes'=>$this->Notes,
                'coin'=>$CoinName,
                'coin_id'=>$this->Coin,
                'cost_center'=>$Cost_Name,
                'cost_center_id'=>$this->Cost_Center,
                'user'=>$User_Name,
                'delegate'=>$Delegate_Name,
                'branch'=>$Branch_Name,
                'file'=>asset($this->File),
                'details'=>$ArrayDet
            ];


        return $data ;
    }

}
